/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.common.UserStore;
import org.wso2.carbon.user.core.dto.RoleDTO;
import org.wso2.carbon.user.core.internal.UserStoreMgtDSComponent;
import org.wso2.carbon.user.core.model.UserMgtContext;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.utils.Secret;
import org.wso2.carbon.utils.UnsupportedSecretTypeException;
import org.wso2.carbon.utils.xml.StringUtils;

public final class UserCoreUtil {
    private static final String DUMMY_VALUE = "dummy";
    private static final String APPLICATION_DOMAIN = "Application";
    private static final String WORKFLOW_DOMAIN = "Workflow";
    private static Log log = LogFactory.getLog(UserCoreUtil.class);
    private static Boolean isEmailUserName;
    private static Boolean isCrossTenantUniqueUserName;
    private static RealmService realmService;
    private static ThreadLocal<String> threadLocalToSetDomain;
    private static ThreadLocal<UserMgtContext> threadLocalToSetUserMgtContext;

    public static String[] combineArrays(String[] arr1, String[] arr2) throws UserStoreException {
        if (arr1 == null || arr1.length == 0) {
            return arr2;
        }
        if (arr2 == null || arr2.length == 0) {
            return arr1;
        }
        String[] newArray = new String[arr1.length + arr2.length];
        for (int i = 0; i < arr1.length; ++i) {
            newArray[i] = arr1[i];
        }
        int j = 0;
        for (int i = arr1.length; i < newArray.length; ++i) {
            newArray[i] = arr2[j];
            ++j;
        }
        return newArray;
    }

    public static String[] combine(String[] array, List<String> list) throws UserStoreException {
        if (array == null || list == null) {
            throw new IllegalArgumentException("Invalid parameters; array : " + array + ", list : " + list);
        }
        HashSet<String> h = new HashSet<String>(list);
        h.addAll(Arrays.asList(array));
        return h.toArray(new String[h.size()]);
    }

    public static String[] optimizePermissions(String[] rawResourcePath) {
        Arrays.sort(rawResourcePath);
        int index = 0;
        ArrayList<String> lst = new ArrayList<String>();
        block0: while (index < rawResourcePath.length) {
            String shortestString = rawResourcePath[index];
            lst.add(shortestString);
            ++index;
            Pattern p = Pattern.compile("(.*)/.*$");
            while (index < rawResourcePath.length) {
                Matcher m = p.matcher(rawResourcePath[index]);
                if (!m.find()) continue;
                String s = m.group(1);
                if (!s.equals(shortestString)) continue block0;
                ++index;
            }
        }
        return lst.toArray(new String[lst.size()]);
    }

    public static Boolean getIsEmailUserName() {
        return isEmailUserName;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static void setRealmService(RealmService realmService) {
        UserCoreUtil.realmService = realmService;
    }

    public static Boolean getIsCrossTenantUniqueUserName() {
        return isCrossTenantUniqueUserName;
    }

    @Deprecated
    public static String getPasswordToStore(String password, String passwordHashMethod, boolean isKdcEnabled) throws UserStoreException {
        if (isKdcEnabled) {
            return password;
        }
        String passwordToStore = password;
        if (passwordHashMethod != null) {
            if (passwordHashMethod.equals("PLAIN_TEXT")) {
                return passwordToStore;
            }
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(passwordHashMethod);
                byte[] digestValue = messageDigest.digest(password.getBytes());
                passwordToStore = "{" + passwordHashMethod + "}" + Base64.encode((byte[])digestValue);
            }
            catch (NoSuchAlgorithmException e) {
                throw new UserStoreException("Invalid hashMethod", e);
            }
        }
        return passwordToStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getPasswordToStore(Object password, String passwordHashMethod, boolean isKdcEnabled) throws UserStoreException {
        Secret credentialObj;
        try {
            credentialObj = Secret.getSecret((Object)password);
        }
        catch (UnsupportedSecretTypeException e) {
            throw new UserStoreException("Unsupported credential type", e);
        }
        try {
            byte[] passwordBytes = credentialObj.getBytes();
            byte[] passwordToStore = Arrays.copyOf(passwordBytes, passwordBytes.length);
            if (isKdcEnabled) {
                byte[] byArray = passwordToStore;
                return byArray;
            }
            if (passwordHashMethod != null) {
                if (passwordHashMethod.equals("PLAIN_TEXT")) {
                    byte[] byArray = passwordToStore;
                    return byArray;
                }
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance(passwordHashMethod);
                    byte[] digestValue = messageDigest.digest(passwordBytes);
                    String saltedPassword = "{" + passwordHashMethod + "}" + Base64.encode((byte[])digestValue);
                    passwordToStore = saltedPassword.getBytes();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new UserStoreException("Invalid hashMethod", e);
                }
            }
            byte[] byArray = passwordToStore;
            return byArray;
        }
        finally {
            credentialObj.clear();
        }
    }

    public static boolean isKdcEnabled(RealmConfiguration realmConfig) {
        String stringKdcEnabled = realmConfig.getUserStoreProperty("kdcEnabled");
        if (stringKdcEnabled != null) {
            return Boolean.parseBoolean(stringKdcEnabled);
        }
        return false;
    }

    public static String getDummyPassword() {
        SecureRandom rand = new SecureRandom();
        return DUMMY_VALUE + rand.nextInt(999999);
    }

    public static boolean isContain(String name, String[] names) {
        if (name == null || names == null || names.length == 0) {
            return false;
        }
        for (String n : names) {
            if (!name.equalsIgnoreCase(n)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static String getPolicyFriendlyRandomPassword(String username) throws UserStoreException {
        return UserCoreUtil.getPolicyFriendlyRandomPassword(username, 8);
    }

    public static char[] getPolicyFriendlyRandomPasswordInChars(String username) throws UserStoreException {
        return UserCoreUtil.getPolicyFriendlyRandomPasswordInChars(username, 8);
    }

    @Deprecated
    public static String getPolicyFriendlyRandomPassword(String username, int length) throws UserStoreException {
        return new String(UserCoreUtil.getPolicyFriendlyRandomPasswordInChars(username, length));
    }

    public static char[] getPolicyFriendlyRandomPasswordInChars(String username, int length) throws UserStoreException {
        if (length < 8 || length > 50) {
            length = 12;
        }
        char[] chars = new char[]{'E', 'F', 'G', 'H', 'J', 'K', 'L', 'N', 'P', 'Q', 'U', 'V', 'W', 'X', 'Y', 'Z', 'e', 'f', 'g', 'h', 'j', 'k', 'l', 'n', 'p', 'q', 'u', 'v', 'w', 'x', 'y', 'z', '~', '!', '@', '#', '$', '%', '^', '&', '*', '_', '-', '+', '='};
        char[] invalidChars = username.toCharArray();
        StringBuffer passwordFeed = new StringBuffer();
        for (char invalidCha : invalidChars) {
            for (char cha : chars) {
                if (cha == invalidCha) continue;
                passwordFeed.append(cha);
            }
        }
        String passwordChars = passwordFeed.toString();
        char[] password = new char[length];
        String randomNum = null;
        try {
            SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
            for (int i = 0; i < length; ++i) {
                password[i] = passwordChars.charAt(prng.nextInt(passwordFeed.length()));
            }
            randomNum = new Integer(prng.nextInt()).toString();
        }
        catch (NoSuchAlgorithmException e) {
            String errorMessage = "Error while creating the random password for user : " + username;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        return ArrayUtils.addAll((char[])password, (char[])randomNum.toCharArray());
    }

    public static RoleDTO[] convertRoleNamesToRoleDTO(String[] roleNames, String domain) {
        if (roleNames != null && roleNames.length != 0) {
            ArrayList<RoleDTO> dtos = new ArrayList<RoleDTO>();
            for (String roleName : roleNames) {
                RoleDTO dto = new RoleDTO();
                dto.setRoleName(roleName);
                dto.setDomainName(domain);
                dtos.add(dto);
            }
            return dtos.toArray(new RoleDTO[dtos.size()]);
        }
        return null;
    }

    public static void setDomainInThreadLocal(String domain) {
        if (domain == null || domain.trim().isEmpty() || "PRIMARY".equalsIgnoreCase(domain)) {
            threadLocalToSetDomain.remove();
        } else {
            threadLocalToSetDomain.set(domain.toUpperCase());
        }
    }

    public static String getDomainFromThreadLocal() {
        return threadLocalToSetDomain.get();
    }

    public static String removeDomainFromName(String name) {
        int index = name.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index >= 0) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public static void setUserMgtContextInThreadLocal(UserMgtContext functionalContainer) {
        if (functionalContainer != null) {
            threadLocalToSetUserMgtContext.set(functionalContainer);
        } else {
            threadLocalToSetUserMgtContext.remove();
        }
    }

    public static UserMgtContext getUserMgtContextFromThreadLocal() {
        return threadLocalToSetUserMgtContext.get();
    }

    public static void removeUserMgtContextInThreadLocal() {
        threadLocalToSetUserMgtContext.remove();
    }

    public static String formatSearchBase(String base, String entryName, String nameAttribute) {
        entryName = UserCoreUtil.removeDomainFromName(entryName);
        String key = nameAttribute + "=" + entryName;
        if (base.indexOf(key) >= 0) {
            String[] arr = base.split(key);
            base = "";
            for (String s : arr) {
                base = base + s;
            }
            if (base.startsWith(",")) {
                base = base.substring(1);
            }
            if (base.endsWith(",")) {
                base = base.substring(0, base.length() - 1);
            }
            return base;
        }
        return base;
    }

    public static String removeDistinguishedName(String name) {
        int index = name.indexOf("@");
        if (index >= 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    public static String addInternalDomainName(String name) {
        if (name.indexOf(CarbonConstants.DOMAIN_SEPARATOR) < 0) {
            name = "Internal" + CarbonConstants.DOMAIN_SEPARATOR + name;
        }
        return name;
    }

    public static String setDomainToUpperCase(String name) {
        int index = name.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index > 0) {
            String domain = name.substring(0, index);
            name = domain.toUpperCase() + name.substring(index);
        }
        return name;
    }

    public static String addDomainToName(String name, String domainName) {
        String[] names;
        String domain;
        if (name.indexOf(UserCoreConstants.DOMAIN_SEPARATOR) < 0 && !"PRIMARY".equalsIgnoreCase(domainName)) {
            if (domainName != null) {
                domainName = domainName.toUpperCase() + CarbonConstants.DOMAIN_SEPARATOR;
                name = domainName + name;
            }
        } else if (name.indexOf("$_USERNAME_SEPARATOR_$") > 0 && name.indexOf(UserCoreConstants.DOMAIN_SEPARATOR) > 0 && !"PRIMARY".equalsIgnoreCase(domainName) && !domainName.equalsIgnoreCase(domain = UserCoreUtil.extractDomainFromName((names = name.split(UserCoreConstants.DOMAIN_SEPARATOR))[0]))) {
            domainName = domainName.toUpperCase() + CarbonConstants.DOMAIN_SEPARATOR;
            name = domainName + name;
        }
        return name;
    }

    public static String addTenantDomainToEntry(String tenantAwareEntry, String tenantDomain) {
        if (StringUtils.isEmpty((String)tenantAwareEntry)) {
            throw new IllegalArgumentException();
        }
        if (!StringUtils.isEmpty((String)tenantDomain)) {
            return tenantAwareEntry + "@" + tenantDomain;
        }
        return tenantAwareEntry + "@" + "carbon.super";
    }

    public static String getDomainName(RealmConfiguration realmConfig) {
        String domainName = realmConfig.getUserStoreProperty("DomainName");
        if (domainName != null) {
            domainName = domainName.toUpperCase();
        }
        return domainName;
    }

    public static String[] addDomainToNames(String[] names, String domainName) {
        if (domainName != null) {
            domainName = domainName.toUpperCase();
        }
        ArrayList<String> namesList = new ArrayList<String>();
        if (names != null && names.length != 0) {
            for (String name : names) {
                if (name.indexOf(UserCoreConstants.DOMAIN_SEPARATOR) < 0 && !"PRIMARY".equalsIgnoreCase(domainName) && domainName != null) {
                    name = UserCoreUtil.addDomainToName(name, domainName);
                    namesList.add(name);
                    continue;
                }
                namesList.add(name);
            }
        }
        if (namesList.size() != 0) {
            return namesList.toArray(new String[namesList.size()]);
        }
        return names;
    }

    public static String[] removeDomainFromNames(String[] names) {
        ArrayList<String> nameList = new ArrayList<String>();
        if (names != null && names.length != 0) {
            for (String name : names) {
                int index = name.indexOf(UserCoreConstants.DOMAIN_SEPARATOR);
                if (index <= 0) continue;
                String domain = name.substring(0, index);
                if (!("Internal".equalsIgnoreCase(domain) || APPLICATION_DOMAIN.equalsIgnoreCase(domain) || WORKFLOW_DOMAIN.equalsIgnoreCase(domain))) {
                    nameList.add(name.substring(index + 1));
                    continue;
                }
                nameList.add(name);
            }
        }
        if (nameList.size() != 0) {
            return nameList.toArray(new String[nameList.size()]);
        }
        return names;
    }

    public static String getCombinedName(String domainName, String userName, String displayName) {
        String combinedName = null;
        if (domainName != null && !"PRIMARY".equalsIgnoreCase(domainName)) {
            domainName = domainName.toUpperCase() + UserCoreConstants.DOMAIN_SEPARATOR;
            if (!userName.equals(displayName) && displayName != null) {
                userName = domainName + userName;
                displayName = domainName + displayName;
                combinedName = userName + "$_USERNAME_SEPARATOR_$" + displayName;
            } else {
                combinedName = domainName + userName;
            }
        } else {
            combinedName = !userName.equals(displayName) && displayName != null ? userName + "$_USERNAME_SEPARATOR_$" + displayName : userName;
        }
        return combinedName;
    }

    public static boolean isPrimaryAdminUser(String userName, RealmConfiguration realmConfig) {
        String myDomain = UserCoreUtil.getDomainName(realmConfig);
        if (myDomain != null) {
            myDomain = myDomain + CarbonConstants.DOMAIN_SEPARATOR;
        }
        return realmConfig.isPrimary() && (realmConfig.getAdminUserName().equalsIgnoreCase(userName) || realmConfig.getAdminUserName().equalsIgnoreCase(myDomain + userName));
    }

    public static boolean isPrimaryAdminRole(String roleName, RealmConfiguration realmConfig) {
        String myDomain = UserCoreUtil.getDomainName(realmConfig);
        if (myDomain != null) {
            myDomain = myDomain + CarbonConstants.DOMAIN_SEPARATOR;
        }
        return realmConfig.isPrimary() && (realmConfig.getAdminRoleName().equalsIgnoreCase(roleName) || realmConfig.getAdminRoleName().equalsIgnoreCase(myDomain + roleName));
    }

    public static boolean isEveryoneRole(String roleName, RealmConfiguration realmConfig) {
        String myDomain = "Internal";
        if (myDomain != null) {
            myDomain = myDomain + CarbonConstants.DOMAIN_SEPARATOR;
        }
        return realmConfig.isPrimary() && realmConfig.getEveryOneRoleName() != null && realmConfig.getEveryOneRoleName().equalsIgnoreCase(roleName) || realmConfig.getEveryOneRoleName().equalsIgnoreCase(myDomain + roleName);
    }

    public static boolean canRoleBeRenamed(UserStore oldStore, UserStore newStore, RealmConfiguration realmConfig) {
        if (oldStore.getDomainName() == null && newStore.getDomainName() != null) {
            return false;
        }
        if (oldStore.getDomainName() != null && !oldStore.getDomainName().equalsIgnoreCase(newStore.getDomainName())) {
            return false;
        }
        return (!oldStore.isHybridRole() || !realmConfig.isReservedRoleName(oldStore.getDomainFreeName())) && (!newStore.isHybridRole() || !realmConfig.isReservedRoleName(newStore.getDomainFreeName()));
    }

    public static boolean isRegistryAnnonymousUser(String userName) {
        return "wso2.anonymous.user".equalsIgnoreCase(userName);
    }

    public static boolean isRegistrySystemUser(String userName) {
        return "wso2.system.user".equalsIgnoreCase(userName);
    }

    public static String extractDomainFromName(String nameWithDomain) {
        if (nameWithDomain.indexOf(UserCoreConstants.DOMAIN_SEPARATOR) > 0) {
            String[] names = nameWithDomain.split(UserCoreConstants.DOMAIN_SEPARATOR);
            return names[0];
        }
        if (UserStoreMgtDSComponent.getRealmService() != null) {
            RealmConfiguration realmConfiguration = UserStoreMgtDSComponent.getRealmService().getBootstrapRealmConfiguration();
            if (realmConfiguration.getUserStoreProperty("DomainName") != null) {
                return realmConfiguration.getUserStoreProperty("DomainName");
            }
            return "PRIMARY";
        }
        return "PRIMARY";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void persistDomain(String domain, int tenantId, DataSource dataSource) throws UserStoreException {
        Connection dbConnection = null;
        try {
            String sqlStatement = "INSERT INTO UM_DOMAIN (UM_DOMAIN_NAME, UM_TENANT_ID) VALUES (?, ?)";
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            dbConnection = DatabaseUtil.getDBConnection(dataSource);
            dbConnection.setAutoCommit(false);
            if (!UserCoreUtil.isExistingDomain(domain, tenantId, dbConnection)) {
                DatabaseUtil.updateDatabase(dbConnection, sqlStatement, domain, tenantId);
            }
            dbConnection.commit();
        }
        catch (UserStoreException e) {
            try {
                String errorMessage = "Error occurred while checking is existing domain : " + domain + " for tenant : " + tenantId;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)((Object)e));
                }
                DatabaseUtil.rollBack(dbConnection);
                throw new UserStoreException(errorMessage, (Throwable)((Object)e));
                catch (SQLException e2) {
                    errorMessage = "DB error occurred while persisting domain : " + domain + " & tenant id : " + tenantId;
                    if (!log.isDebugEnabled()) throw new UserStoreException(errorMessage, e2);
                    log.debug((Object)errorMessage, (Throwable)e2);
                    throw new UserStoreException(errorMessage, e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    public static void deletePersistedDomain(String domain, int tenantId, DataSource dataSource) throws UserStoreException {
        Connection dbConnection = null;
        try {
            String sqlStatement = "DELETE FROM UM_DOMAIN WHERE UM_DOMAIN_NAME=? AND UM_TENANT_ID=?";
            String removeDomainSqlStatement = "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            dbConnection = DatabaseUtil.getDBConnection(dataSource);
            dbConnection.setAutoCommit(false);
            if (UserCoreUtil.isExistingDomain(domain, tenantId, dbConnection)) {
                DatabaseUtil.updateDatabase(dbConnection, removeDomainSqlStatement, tenantId, domain);
                DatabaseUtil.updateDatabase(dbConnection, sqlStatement, domain, tenantId);
            }
            dbConnection.commit();
        }
        catch (UserStoreException e) {
            block16: {
                try {
                    dbConnection.rollback();
                }
                catch (SQLException e1) {
                    if (!log.isDebugEnabled()) break block16;
                    log.debug((Object)"Error occurred while rollback the connection", (Throwable)e1);
                }
            }
            String errorMessage = "Error occurred while deleting domain : " + domain + " for tenant : " + tenantId;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)((Object)e));
            }
            throw new UserStoreException(errorMessage, (Throwable)((Object)e));
        }
        catch (SQLException e) {
            block17: {
                try {
                    if (dbConnection != null) {
                        dbConnection.rollback();
                    }
                }
                catch (SQLException e1) {
                    if (!log.isDebugEnabled()) break block17;
                    log.debug((Object)"Error occurred while rollback the connection", (Throwable)e1);
                }
            }
            String errorMessage = "DB error occurred while deleting domain : " + domain + " & tenant id : " + tenantId;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updatePersistedDomain(String previousDomain, String newDomain, int tenantId, DataSource dataSource) throws UserStoreException {
        Connection dbConnection = null;
        try {
            String sqlStatement = "UPDATE UM_DOMAIN SET UM_DOMAIN_NAME=? WHERE UM_DOMAIN_NAME=? AND UM_TENANT_ID=?";
            if (previousDomain != null) {
                previousDomain = previousDomain.toUpperCase();
            }
            if (newDomain != null) {
                newDomain = newDomain.toUpperCase();
            }
            if (UserCoreUtil.isExistingDomain(previousDomain, tenantId, dbConnection = DatabaseUtil.getDBConnection(dataSource))) {
                if (!UserCoreUtil.isExistingDomain(newDomain, tenantId, dbConnection)) {
                    UserCoreUtil.deletePersistedDomain(newDomain, tenantId, dataSource);
                }
                dbConnection.setAutoCommit(false);
                DatabaseUtil.updateDatabase(dbConnection, sqlStatement, newDomain, previousDomain, tenantId);
                dbConnection.commit();
            }
        }
        catch (UserStoreException e) {
            try {
                String errorMessage = "Error occurred while updating domain : " + previousDomain + " to new domain : " + newDomain + " for tenant : " + tenantId;
                if (!log.isDebugEnabled()) throw new UserStoreException(errorMessage, (Throwable)((Object)e));
                log.debug((Object)errorMessage, (Throwable)((Object)e));
                throw new UserStoreException(errorMessage, (Throwable)((Object)e));
                catch (SQLException e2) {
                    errorMessage = "DB error occurred while updating domain : " + previousDomain + " to new domain : " + newDomain + " for tenant : " + tenantId;
                    if (!log.isDebugEnabled()) throw new UserStoreException(errorMessage, e2);
                    log.debug((Object)errorMessage, (Throwable)e2);
                    throw new UserStoreException(errorMessage, e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    private static boolean isExistingDomain(String domain, int tenantId, Connection connection) throws UserStoreException {
        boolean bl;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        boolean isExisting = false;
        try {
            prepStmt = connection.prepareStatement("SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_DOMAIN_NAME=? AND UM_TENANT_ID=?");
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            prepStmt.setString(1, domain);
            prepStmt.setInt(2, tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                isExisting = true;
            }
            bl = isExisting;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "DB error occurred while checking is existing domain : " + domain + " & tenant id : " + tenantId;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return bl;
    }

    private static boolean checkExistingDomainId(int domainId, int tenantId, DataSource dataSource) throws UserStoreException {
        int value;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int isExisting = 0;
        try {
            dbConnection = DatabaseUtil.getDBConnection(dataSource);
            prepStmt = dbConnection.prepareStatement("SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_DOMAIN_ID=? AND UM_TENANT_ID=?");
            prepStmt.setInt(1, domainId);
            prepStmt.setInt(2, tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next() && domainId == (value = rs.getInt(1))) {
                isExisting = 1;
            }
            value = isExisting;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "DB error occurred while checking is existing domain id : " + domainId + " & tenant id : " + tenantId;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return value;
    }

    public static boolean isSystemRole(String roleName, int tenantId, DataSource dataSource) throws UserStoreException {
        boolean value;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        boolean isExisting = false;
        try {
            dbConnection = DatabaseUtil.getDBConnection(dataSource);
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, roleName);
            prepStmt.setInt(2, tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next() && (value = rs.getInt(1)) > -1 != 0) {
                isExisting = true;
            }
            value = isExisting;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "DB error occurred while checking is existing system role for : " + roleName + " & tenant id : " + tenantId;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return value;
    }

    public static String getTenantShareGroupBase(String tenantOu) {
        return tenantOu + "=" + CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
    }

    public static void clearSensitiveChars(char[] chars) {
        if (chars == null) {
            return;
        }
        Arrays.fill(chars, '\u0000');
    }

    public static void clearSensitiveBytes(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        Arrays.fill(bytes, (byte)0);
    }

    public static List<User> getUserList(String[] userList) {
        ArrayList<User> usersList = new ArrayList<User>();
        for (String userID : userList) {
            User user = new User();
            user.setUserID(userID);
            usersList.add(user);
        }
        return usersList;
    }

    static {
        realmService = null;
        threadLocalToSetDomain = new ThreadLocal();
        threadLocalToSetUserMgtContext = new ThreadLocal();
    }
}

