/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.util;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LDAPUtil {
    private static Log log = LogFactory.getLog(LDAPUtil.class);

    public static String findGroupBySID(DirContext ctx, String ldapSearchBase, String sid, String userAttribute) throws NamingException {
        String searchFilter = "(&(objectClass=group)(objectSid=" + sid + "))";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(ldapSearchBase, searchFilter, searchControls);
        if (results.hasMoreElements()) {
            SearchResult searchResult = (SearchResult)results.nextElement();
            if (results.hasMoreElements()) {
                log.error((Object)("Matched multiple groups for the group with SID: " + sid));
                return null;
            }
            return (String)searchResult.getAttributes().get(userAttribute).get();
        }
        return null;
    }

    public static String getPrimaryGroupSID(SearchResult srLdapUser, String objectSid, String primaryGroupID) throws NamingException {
        byte[] objectSID = (byte[])srLdapUser.getAttributes().get(objectSid).get();
        String strPrimaryGroupID = (String)srLdapUser.getAttributes().get(primaryGroupID).get();
        String strObjectSid = LDAPUtil.decodeSID(objectSID);
        return strObjectSid.substring(0, strObjectSid.lastIndexOf(45) + 1) + strPrimaryGroupID;
    }

    private static String decodeSID(byte[] sid) {
        StringBuilder strSid = new StringBuilder("S-");
        byte revision = sid[0];
        strSid.append(Integer.toString(revision));
        int countSubAuths = sid[1] & 0xFF;
        long authority = 0L;
        for (int i = 2; i <= 7; ++i) {
            authority |= (long)sid[i] << 8 * (5 - (i - 2));
        }
        strSid.append("-");
        strSid.append(Long.toHexString(authority));
        int offset = 8;
        int size = 4;
        for (int j = 0; j < countSubAuths; ++j) {
            long subAuthority = 0L;
            for (int k = 0; k < size; ++k) {
                subAuthority |= (long)(sid[offset + k] & 0xFF) << 8 * k;
            }
            strSid.append("-");
            strSid.append(subAuthority);
            offset += size;
        }
        return strSid.toString();
    }
}

