/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tracker;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.user.api.Properties;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.internal.UserStoreMgtDSComponent;

public class UserStoreManagerRegistry
extends UserStoreMgtDSComponent {
    private static Log log = LogFactory.getLog(UserStoreManagerRegistry.class);
    private static ServiceTracker userStoreManagerTracker;

    public static void init(BundleContext bc) throws Exception {
        if (userStoreManagerTracker != null) {
            log.error((Object)"UserStoreManagerRegistry init called more than once, with trace, ", new Throwable());
        }
        try {
            userStoreManagerTracker = new ServiceTracker(bc, UserStoreManager.class.getName(), null);
            userStoreManagerTracker.open();
            if (log.isDebugEnabled()) {
                log.debug((Object)(userStoreManagerTracker.getServices().length + " User Store Managers registered."));
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Error" + e.getMessage()), (Throwable)e);
            }
            throw e;
        }
    }

    private static Map<String, Properties> getUserStoreManagers() {
        HashMap<String, Properties> userStoreManagers = new HashMap<String, Properties>();
        Object[] objects = userStoreManagerTracker.getServices();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            UserStoreManager userStoreManager = (UserStoreManager)objects[i];
            if (userStoreManager.getDefaultUserStoreProperties() != null) {
                Properties userStoreProperties = userStoreManager.getDefaultUserStoreProperties();
                userStoreManagers.put(userStoreManager.getClass().getName(), userStoreProperties);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Adding UserStoreManager with name: " + userStoreManager.getClass().getName() + ". UserStoreManager class: " + userStoreManager));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("The user store manager has no DefaultUserStoreProperties, and will be skipped. UserStoreManager : " + userStoreManager));
        }
        return userStoreManagers;
    }

    public static Set<String> getUserStoreManagerClasses() {
        Set<String> classes = UserStoreManagerRegistry.getUserStoreManagers().keySet();
        return classes;
    }

    public static Properties getUserStoreProperties(String className) {
        Properties properties = UserStoreManagerRegistry.getUserStoreManagers().get(className);
        return properties;
    }
}

