/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tenant;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.core.tenant.TenantUniqueIDKey;

public class TenantUniqueIdCache {
    private static final String TENANT_UNIQUE_ID_CACHE_MANAGER = "TENANT_UNIQUE_ID_CACHE_MANAGER";
    private static final String TENANT_UNIQUE_ID_CACHE = "TENANT_UNIQUE_ID_CACHE";
    private static Log log = LogFactory.getLog(TenantUniqueIdCache.class);
    private static TenantUniqueIdCache tenantUniqueIdCache = new TenantUniqueIdCache();

    private TenantUniqueIdCache() {
    }

    public static synchronized TenantUniqueIdCache getInstance() {
        return tenantUniqueIdCache;
    }

    private <T> Cache<TenantUniqueIDKey, T> getTenantUUIDCache() {
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(TENANT_UNIQUE_ID_CACHE_MANAGER);
        Cache cache = cacheManager.getCache(TENANT_UNIQUE_ID_CACHE);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addToCache(TenantUniqueIDKey key, T entry) {
        PrivilegedCarbonContext.startTenantFlow();
        try {
            this.startSuperTenantFlow();
            this.clearCacheEntry(key);
            Cache<TenantUniqueIDKey, T> cache = this.getTenantUUIDCache();
            if (cache != null) {
                cache.put((Object)key, entry);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_UNIQUE_ID_CACHE which is under TENANT_UNIQUE_ID_CACHE_MANAGER, added the entry : " + entry + " for the key : " + key + " successfully"));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_UNIQUE_ID_CACHE which is under TENANT_UNIQUE_ID_CACHE_MANAGER");
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getValueFromCache(TenantUniqueIDKey key) {
        PrivilegedCarbonContext.startTenantFlow();
        try {
            this.startSuperTenantFlow();
            Cache<TenantUniqueIDKey, T> cache = this.getTenantUUIDCache();
            if (cache != null) {
                if (cache.containsKey((Object)key)) {
                    Object entry = cache.get((Object)key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("TENANT_UNIQUE_ID_CACHE which is under TENANT_UNIQUE_ID_CACHE_MANAGER, found the entry : " + entry + " for the key : " + key + " successfully"));
                    }
                    Object object = entry;
                    return (T)object;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_UNIQUE_ID_CACHE which is under TENANT_UNIQUE_ID_CACHE_MANAGER, doesn't contain the key : " + key));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_UNIQUE_ID_CACHE which is under TENANT_UNIQUE_ID_CACHE_MANAGER");
            }
            T t = null;
            return t;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void clearCacheEntry(TenantUniqueIDKey key) {
        PrivilegedCarbonContext.startTenantFlow();
        try {
            this.startSuperTenantFlow();
            Cache cache = this.getTenantUUIDCache();
            if (cache != null) {
                if (cache.containsKey((Object)key)) {
                    cache.remove((Object)key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("TENANT_UNIQUE_ID_CACHE which is under TENANT_UNIQUE_ID_CACHE_MANAGER, is removed entry for the key : " + key + " successfully"));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_UNIQUE_ID_CACHE which is under TENANT_UNIQUE_ID_CACHE_MANAGER, doesn't contain the key : " + key));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_UNIQUE_ID_CACHE which is under TENANT_UNIQUE_ID_CACHE_MANAGER");
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void startSuperTenantFlow() {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantId(-1234);
        carbonContext.setTenantDomain("carbon.super");
    }

    public void clear() {
        PrivilegedCarbonContext.startTenantFlow();
        try {
            this.startSuperTenantFlow();
            Cache tenantUniqueIDCache = this.getTenantUUIDCache();
            if (tenantUniqueIDCache != null) {
                tenantUniqueIDCache.removeAll();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"TENANT_UNIQUE_ID_CACHE which is under TENANT_UNIQUE_ID_CACHE_MANAGER, is cleared successfully");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_UNIQUE_ID_CACHE which is under TENANT_UNIQUE_ID_CACHE_MANAGER");
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

