/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tenant;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.core.tenant.TenantDomainEntry;
import org.wso2.carbon.user.core.tenant.TenantIdKey;

class TenantDomainCache {
    private static final String TENANT_DOMAIN_CACHE_MANAGER = "TENANT_DOMAIN_CACHE_MANAGER";
    private static final String TENANT_DOMAIN_CACHE = "TENANT_DOMAIN_CACHE";
    private static Log log = LogFactory.getLog(TenantDomainCache.class);
    private static TenantDomainCache tenantDomainCache = new TenantDomainCache();

    private TenantDomainCache() {
    }

    public static synchronized TenantDomainCache getInstance() {
        return tenantDomainCache;
    }

    private Cache<TenantIdKey, TenantDomainEntry> getTenantDomainCache() {
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(TENANT_DOMAIN_CACHE_MANAGER);
        Cache cache = cacheManager.getCache(TENANT_DOMAIN_CACHE);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(TenantIdKey key, TenantDomainEntry entry) {
        try {
            this.startSuperTenantFlow();
            Cache<TenantIdKey, TenantDomainEntry> cache = this.getTenantDomainCache();
            if (cache != null) {
                cache.put((Object)key, (Object)entry);
                log.debug((Object)("TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER, added the entry : " + entry + " for the key : " + key + " successfully"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER");
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TenantDomainEntry getValueFromCache(TenantIdKey key) {
        try {
            this.startSuperTenantFlow();
            Cache<TenantIdKey, TenantDomainEntry> cache = this.getTenantDomainCache();
            if (cache != null) {
                if (cache.containsKey((Object)key)) {
                    TenantDomainEntry entry = (TenantDomainEntry)cache.get((Object)key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER, found the entry : " + entry + " for the key : " + key + " successfully"));
                    }
                    TenantDomainEntry tenantDomainEntry = entry;
                    return tenantDomainEntry;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER, doesn't contain the key : " + key));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER");
            }
            TenantDomainEntry tenantDomainEntry = null;
            return tenantDomainEntry;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void startSuperTenantFlow() {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super");
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
    }

    public void clearCacheEntry(TenantIdKey key) {
        try {
            this.startSuperTenantFlow();
            Cache<TenantIdKey, TenantDomainEntry> cache = this.getTenantDomainCache();
            if (cache != null) {
                if (cache.containsKey((Object)key)) {
                    cache.remove((Object)key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER, is removed entry for the key : " + key + " successfully"));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER, doen't contain the key : " + key));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER");
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void clear() {
        try {
            this.startSuperTenantFlow();
            Cache<TenantIdKey, TenantDomainEntry> cache = this.getTenantDomainCache();
            if (cache != null) {
                cache.removeAll();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER, is cleared successfully");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER");
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

