/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tenant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.axiom.om.OMElement;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;
import org.wso2.carbon.user.core.ldap.LDAPConnectionContext;
import org.wso2.carbon.user.core.tenant.CommonHybridLDAPTenantManager;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantCache;
import org.wso2.carbon.user.core.tenant.TenantCacheEntry;
import org.wso2.carbon.user.core.tenant.TenantIdKey;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;

public class FileSystemTenantManager
extends CommonHybridLDAPTenantManager {
    private static Log log = LogFactory.getLog(TenantManager.class);
    private final String CarbonHome = CarbonUtils.getCarbonHome();
    private String filePath = this.CarbonHome + "/repository/tenants/";
    private final String userMgtXml = "user-mgt.xml";
    protected BundleContext bundleContext;
    protected TenantCache tenantCacheManager = TenantCache.getInstance();
    DataSource dataSource;
    private Map tenantDomainIdMap = new ConcurrentHashMap();
    private Map tenantIdDomainMap = new ConcurrentHashMap();
    private LDAPConnectionContext ldapConnectionSource;
    private TenantMgtConfiguration tenantMgtConfig = null;
    private RealmConfiguration realmConfig = null;

    public FileSystemTenantManager(OMElement omElement, Map<String, Object> properties) throws Exception {
        super(omElement, properties);
    }

    public FileSystemTenantManager(DataSource dataSource, String superTenantDomain) {
        super(dataSource, superTenantDomain);
    }

    @Override
    public int addTenant(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        int tenantID = super.addTenant(tenant);
        RealmConfiguration tenantRealmConfig = tenant.getRealmConfig();
        tenantRealmConfig.setSecondaryRealmConfig(null);
        String realmConfigString = RealmConfigXMLProcessor.serialize(tenantRealmConfig).toString();
        this.saveConfigToFileSystem(tenantID, realmConfigString);
        return tenantID;
    }

    private void saveConfigToFileSystem(int id, String realmConfigString) {
        File tenantFolder = new File(this.filePath + id + File.separator + "user-mgt.xml");
        if (!tenantFolder.exists()) {
            new File(this.filePath + id).mkdir();
        }
        try {
            FileUtils.writeStringToFile((File)tenantFolder, (String)realmConfigString);
        }
        catch (IOException e) {
            log.error((Object)("Error in saving realm configuration of tenant:" + id + "."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tenant getTenant(int tenantId) throws UserStoreException {
        Tenant tenant = super.getTenant(tenantId);
        InputStream inStream = null;
        try {
            inStream = new FileInputStream(this.filePath + tenantId + File.separator + "user-mgt.xml");
            if (inStream == null) {
                String message = "Configuration file could not be read in.";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
            }
            inStream = CarbonUtils.replaceSystemVariablesInXml((InputStream)inStream);
            RealmConfigXMLProcessor processor = new RealmConfigXMLProcessor();
            RealmConfiguration realmConfig = processor.buildRealmConfiguration(inStream);
            realmConfig.setTenantId(tenantId);
            for (RealmConfiguration secondary = realmConfig.getSecondaryRealmConfig(); secondary != null; secondary = secondary.getSecondaryRealmConfig()) {
                secondary.setTenantId(tenantId);
            }
            tenant.setRealmConfig(realmConfig);
            tenant.setAdminName(realmConfig.getAdminUserName());
            this.tenantCacheManager.addToCache(new TenantIdKey(tenantId), new TenantCacheEntry<Tenant>(tenant));
        }
        catch (CarbonException e) {
            String errorMessage = "Error occurred while getting tenant from tenant id : " + (Object)((Object)tenant);
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Realm configuration file 'user-mgt.xml',does not exist for tenant:" + tenantId));
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error((Object)("Couldn't close FileInputStream " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return tenant;
    }
}

