/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tenant;

import java.util.Locale;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.sql.DataSource;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.ldap.LDAPConnectionContext;
import org.wso2.carbon.user.core.tenant.JDBCTenantManager;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.util.JNDIUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class CommonHybridLDAPTenantManager
extends JDBCTenantManager {
    private static final String USER_PASSWORD_ATTRIBUTE_NAME = "userPassword";
    private static final String EMAIL_ATTRIBUTE_NAME = "mail";
    private static final String SN_ATTRIBUTE_NAME = "sn";
    private static final String CN_ATTRIBUTE_NAME = "cn";
    private static Log logger = LogFactory.getLog(CommonHybridLDAPTenantManager.class);
    private LDAPConnectionContext ldapConnectionSource;
    private TenantMgtConfiguration tenantMgtConfig = null;
    private RealmConfiguration realmConfig = null;

    public CommonHybridLDAPTenantManager(OMElement omElement, Map<String, Object> properties) throws Exception {
        super(omElement, properties);
        this.tenantMgtConfig = (TenantMgtConfiguration)properties.get("tenantMgtConfiguration");
        this.realmConfig = (RealmConfiguration)properties.get("userMgtConfiguration");
        if (this.realmConfig == null) {
            throw new UserStoreException("Tenant Manager can not function without a bootstrap realm config");
        }
        if (this.ldapConnectionSource == null) {
            this.ldapConnectionSource = new LDAPConnectionContext(this.realmConfig);
        }
    }

    public CommonHybridLDAPTenantManager(DataSource dataSource, String superTenantDomain) {
        super(dataSource, superTenantDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addTenant(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        int tenantID = super.addTenant(tenant);
        tenant.setId(tenantID);
        DirContext initialDirContext = null;
        try {
            initialDirContext = this.ldapConnectionSource.getContext();
            if (!this.isOrganizationalUnitCreated(tenant.getDomain(), initialDirContext)) {
                this.createOrganizationalUnit(tenant.getDomain(), (Tenant)tenant, initialDirContext);
                this.addSharedGroupForTenant((Tenant)tenant, initialDirContext);
            } else {
                logger.warn((Object)("Organizational unit for tenant domain:" + tenant.getDomain() + " is already created."));
            }
        }
        finally {
            this.closeContext(initialDirContext);
        }
        return tenantID;
    }

    protected boolean isOrganizationalUnitCreated(String orgName, DirContext initialDirContext) throws UserStoreException {
        String partitionDN = (String)this.tenantMgtConfig.getTenantStoreProperties().get("RootPartition");
        String organizationalObjectClass = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalObjectClass");
        String organizationalAttribute = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalAttribute");
        String searchFilter = "(&(objectClass=" + organizationalObjectClass + ")(" + organizationalAttribute + "=" + orgName + "))";
        SearchControls userSearchControl = new SearchControls();
        userSearchControl.setSearchScope(1);
        NamingEnumeration<SearchResult> userSearchResults = null;
        try {
            userSearchResults = initialDirContext.search(partitionDN, searchFilter, userSearchControl);
            return userSearchResults.hasMore();
        }
        catch (PartialResultException e) {
            String errorMessage = "Error occurred while getting user list from search Filter : " + searchFilter;
            if (this.isIgnorePartialResultException()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)errorMessage, (Throwable)e);
                }
                return false;
            }
            throw new UserStoreException(errorMessage, e);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while searching in root partition for organization : " + orgName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
    }

    private boolean isIgnorePartialResultException() {
        return "ignore".equals(this.realmConfig.getUserStoreProperty("Referral"));
    }

    protected void createOrganizationalUnit(String orgName, Tenant tenant, DirContext initialDirContext) throws UserStoreException {
        String partitionDN = (String)this.tenantMgtConfig.getTenantStoreProperties().get("RootPartition");
        this.createOrganizationalContext(partitionDN, orgName, initialDirContext);
        String organizationNameAttribute = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalAttribute");
        String dnOfOrganizationalContext = organizationNameAttribute + "=" + orgName + "," + partitionDN;
        String orgSubContextValue = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextUserContextName");
        if (orgSubContextValue == null) {
            orgSubContextValue = "users";
        }
        this.createOrganizationalSubContext(dnOfOrganizationalContext, orgSubContextValue, initialDirContext);
        String orgGroupContextValue = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextGroupContextName");
        if (orgGroupContextValue == null) {
            orgGroupContextValue = "groups";
        }
        this.createOrganizationalSubContext(dnOfOrganizationalContext, orgGroupContextValue, initialDirContext);
    }

    protected void createOrganizationalContext(String rootDN, String orgName, DirContext initialDirContext) throws UserStoreException {
        DirContext subContext = null;
        DirContext organizationalContext = null;
        try {
            subContext = (DirContext)initialDirContext.lookup(rootDN);
            BasicAttributes contextAttributes = new BasicAttributes(true);
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            objectClass.add(this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalObjectClass"));
            contextAttributes.put(objectClass);
            String organizationalNameAttribute = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalAttribute");
            BasicAttribute organization = new BasicAttribute(organizationalNameAttribute);
            organization.add(orgName);
            contextAttributes.put(organization);
            String rdnOfOrganizationalContext = organizationalNameAttribute + "=" + orgName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding sub context: " + rdnOfOrganizationalContext + " under " + rootDN + " ..."));
            }
            organizationalContext = subContext.createSubcontext(rdnOfOrganizationalContext, (Attributes)contextAttributes);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sub context: " + rdnOfOrganizationalContext + " was added under " + rootDN + " successfully."));
            }
            this.closeContext(organizationalContext);
            this.closeContext(subContext);
        }
        catch (NamingException e) {
            try {
                String errorMsg = "Error occurred while adding the organizational unit sub context.";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)errorMsg, (Throwable)e);
                }
                throw new UserStoreException(errorMsg, e);
            }
            catch (Throwable throwable) {
                this.closeContext(organizationalContext);
                this.closeContext(subContext);
                throw throwable;
            }
        }
    }

    protected void closeContext(DirContext ldapContext) {
        if (ldapContext != null) {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                logger.error((Object)"Error closing sub context.", (Throwable)e);
            }
        }
    }

    protected void createOrganizationalSubContext(String dnOfParentContext, String nameOfCurrentContext, DirContext initialDirContext) throws UserStoreException {
        DirContext subContext = null;
        DirContext organizationalContext = null;
        try {
            subContext = (DirContext)initialDirContext.lookup(dnOfParentContext);
            BasicAttributes contextAttributes = new BasicAttributes(true);
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            objectClass.add(this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextObjectClass"));
            contextAttributes.put(objectClass);
            String orgSubUnitAttributeName = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextAttribute");
            BasicAttribute organizationSubUnit = new BasicAttribute(orgSubUnitAttributeName);
            organizationSubUnit.add(nameOfCurrentContext);
            contextAttributes.put(organizationSubUnit);
            String rdnOfOrganizationalContext = orgSubUnitAttributeName + "=" + nameOfCurrentContext;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding sub context: " + rdnOfOrganizationalContext + " under " + dnOfParentContext + " ..."));
            }
            organizationalContext = subContext.createSubcontext(rdnOfOrganizationalContext, (Attributes)contextAttributes);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sub context: " + rdnOfOrganizationalContext + " was added under " + dnOfParentContext + " successfully."));
            }
            this.closeContext(organizationalContext);
            this.closeContext(subContext);
        }
        catch (NamingException e) {
            try {
                String errorMsg = "Error occurred while adding the organizational unit sub context.";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)errorMsg, (Throwable)e);
                }
                throw new UserStoreException(errorMsg, e);
            }
            catch (Throwable throwable) {
                this.closeContext(organizationalContext);
                this.closeContext(subContext);
                throw throwable;
            }
        }
    }

    @Deprecated
    protected String createAdminEntry(String dnOfUserContext, Tenant tenant, DirContext initialDirContext) throws UserStoreException {
        String userDN = null;
        DirContext organizationalUsersContext = null;
        try {
            organizationalUsersContext = (DirContext)initialDirContext.lookup(dnOfUserContext);
            BasicAttributes userAttributes = new BasicAttributes(true);
            BasicAttribute objClass = new BasicAttribute("objectClass");
            objClass.add(this.realmConfig.getUserStoreProperty("UserEntryObjectClass"));
            if (UserCoreUtil.isKdcEnabled(this.realmConfig)) {
                objClass.add("krb5principal");
                objClass.add("krb5kdcentry");
                objClass.add("subschema");
                String principal = tenant.getAdminName() + "_" + tenant.getDomain() + "@" + this.getRealmName();
                BasicAttribute kerberosPrincipalName = new BasicAttribute("krb5PrincipalName");
                kerberosPrincipalName.add(principal);
                BasicAttribute keyVersionNumber = new BasicAttribute("krb5KeyVersionNumber");
                keyVersionNumber.add("0");
                userAttributes.put(kerberosPrincipalName);
                userAttributes.put(keyVersionNumber);
            }
            userAttributes.put(objClass);
            BasicAttribute password = new BasicAttribute(USER_PASSWORD_ATTRIBUTE_NAME);
            String passwordHashMethod = this.realmConfig.getUserStoreProperty("PasswordHashMethod");
            if (passwordHashMethod == null) {
                passwordHashMethod = this.realmConfig.getUserStoreProperty("passwordHashMethod");
            }
            String passwordToStore = UserCoreUtil.getPasswordToStore(tenant.getAdminPassword(), passwordHashMethod, this.isKDCEnabled());
            password.add(passwordToStore);
            userAttributes.put(password);
            BasicAttribute adminEmail = new BasicAttribute(EMAIL_ATTRIBUTE_NAME);
            adminEmail.add(tenant.getEmail());
            userAttributes.put(adminEmail);
            BasicAttribute lastName = new BasicAttribute(SN_ATTRIBUTE_NAME);
            lastName.add(tenant.getAdminLastName());
            userAttributes.put(lastName);
            String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
            if (!CN_ATTRIBUTE_NAME.equals(userNameAttribute)) {
                BasicAttribute firstName = new BasicAttribute(CN_ATTRIBUTE_NAME);
                firstName.add(tenant.getAdminFirstName());
                userAttributes.put(firstName);
            }
            String userRDN = userNameAttribute + "=" + tenant.getAdminName();
            organizationalUsersContext.bind(userRDN, null, (Attributes)userAttributes);
            userDN = userRDN + "," + dnOfUserContext;
        }
        catch (NamingException e) {
            String errorMsg = "Error occurred while creating Admin entry";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMsg, (Throwable)e);
            }
            throw new UserStoreException(errorMsg, e);
        }
        finally {
            this.closeContext(organizationalUsersContext);
        }
        return userDN;
    }

    @Deprecated
    protected void createAdminGroup(String dnOfGroupContext, String adminUserDN, DirContext initialDirContext) throws UserStoreException {
        BasicAttributes adminGroupAttributes = new BasicAttributes(true);
        BasicAttribute objectClassAttribute = new BasicAttribute("objectClass");
        objectClassAttribute.add(this.realmConfig.getUserStoreProperty("GroupEntryObjectClass"));
        adminGroupAttributes.put(objectClassAttribute);
        String groupNameAttributeName = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
        BasicAttribute groupNameAttribute = new BasicAttribute(groupNameAttributeName);
        String adminRoleName = this.realmConfig.getAdminRoleName();
        groupNameAttribute.add(UserCoreUtil.removeDomainFromName(adminRoleName));
        adminGroupAttributes.put(groupNameAttribute);
        BasicAttribute membershipAttribute = new BasicAttribute(this.realmConfig.getUserStoreProperty("MembershipAttribute"));
        membershipAttribute.add(adminUserDN);
        adminGroupAttributes.put(membershipAttribute);
        DirContext groupContext = null;
        try {
            groupContext = (DirContext)initialDirContext.lookup(dnOfGroupContext);
            String rdnOfAdminGroup = groupNameAttributeName + "=" + UserCoreUtil.removeDomainFromName(adminRoleName);
            groupContext.bind(rdnOfAdminGroup, null, (Attributes)adminGroupAttributes);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while creating the admin group.";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            this.closeContext(groupContext);
        }
    }

    private boolean isKDCEnabled() {
        return UserCoreUtil.isKdcEnabled(this.realmConfig);
    }

    public boolean isSharedGroupEnabled() {
        String value = this.realmConfig.getUserStoreProperty("SharedGroupEnabled");
        return this.realmConfig.isPrimary() && "true".equalsIgnoreCase(value);
    }

    public void addSharedGroupForTenant(Tenant tenant, DirContext mainDirContext) throws UserStoreException {
        if (!this.isSharedGroupEnabled()) {
            return;
        }
        BasicAttributes groupAttributes = new BasicAttributes(true);
        String domainName = tenant.getDomain();
        String groupNameAttributeName = this.realmConfig.getUserStoreProperty("SharedTenantNameAttribute");
        BasicAttribute objectClassAttribute = new BasicAttribute("objectClass");
        objectClassAttribute.add(this.realmConfig.getUserStoreProperty("SharedTenantObjectClass"));
        groupAttributes.put(objectClassAttribute);
        DirContext groupContext = null;
        String searchBase = (String)this.realmConfig.getUserStoreProperties().get("SharedGroupSearchBase");
        try {
            groupContext = (DirContext)mainDirContext.lookup(searchBase);
            NameParser ldapParser = groupContext.getNameParser("");
            Name compoundGroupName = ldapParser.parse(groupNameAttributeName + "=" + domainName);
            groupContext.bind(compoundGroupName, null, (Attributes)groupAttributes);
        }
        catch (Exception e) {
            try {
                String errorMsg = "Shared tenant: " + domainName + "could not be added.";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)errorMsg, (Throwable)e);
                }
                throw new UserStoreException(errorMsg, e);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeContext(groupContext);
                throw throwable;
            }
        }
        JNDIUtil.closeContext(groupContext);
    }

    protected String getRealmName() {
        String defaultRealmName = this.realmConfig.getUserStoreProperty("defaultRealmName");
        if (defaultRealmName != null) {
            return defaultRealmName;
        }
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String[] domainComponents = searchBase.split("dc=");
        StringBuilder builder = new StringBuilder();
        for (String dc : domainComponents) {
            if (dc.contains("=")) continue;
            String trimmedDc = dc.trim();
            if (trimmedDc.endsWith(",")) {
                builder.append(trimmedDc.replace(',', '.'));
                continue;
            }
            builder.append(trimmedDc);
        }
        return builder.toString().toUpperCase(Locale.ENGLISH);
    }
}

