/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.system;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.apache.axis2.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.constants.UserCoreErrorConstants;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.Secret;
import org.wso2.carbon.utils.UnsupportedSecretTypeException;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class SystemUserRoleManager {
    private static Log log = LogFactory.getLog(SystemUserRoleManager.class);
    int tenantId;
    private DataSource dataSource;
    private static final String SHA_1_PRNG = "SHA1PRNG";

    public SystemUserRoleManager(DataSource dataSource, int tenantId) throws UserStoreException {
        this.dataSource = dataSource;
        this.tenantId = tenantId;
        UserCoreUtil.persistDomain("SYSTEM", this.tenantId, this.dataSource);
    }

    public void addSystemRole(String roleName, String[] userList) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            if (!this.isExistingRole(roleName)) {
                DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_SYSTEM_ROLE (UM_ROLE_NAME, UM_TENANT_ID) VALUES (?, ?)", roleName, this.tenantId);
            }
            if (userList != null) {
                String sql = "INSERT INTO UM_SYSTEM_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) VALUES (?,(SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?)";
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                if ("mssql".equals(type)) {
                    sql = "INSERT INTO UM_SYSTEM_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT (?),(SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?)";
                }
                if ("openedge".equals(type)) {
                    sql = "INSERT INTO UM_SYSTEM_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT ?, UM_ID, ? FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sql, userList, this.tenantId, roleName, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sql, userList, roleName, this.tenantId, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while adding system role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            if (e instanceof SQLIntegrityConstraintViolationException) {
                throw new UserStoreException(e.getMessage(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_A_SYSTEM_ROLE.getCode(), e);
            }
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while getting database type from DB connection";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            if (e instanceof UserStoreException && UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_WRITING_TO_DATABASE.getCode().equals(((UserStoreException)((Object)e)).getErrorCode())) {
                throw new UserStoreException(e.getMessage(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_A_SYSTEM_ROLE.getCode(), e);
            }
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public boolean isExistingRole(String roleName) throws UserStoreException {
        boolean value;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        boolean isExisting = false;
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME =? AND UM_TENANT_ID=?");
            prepStmt.setString(1, roleName);
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next() && (value = rs.getInt(1)) > -1 != 0) {
                isExisting = true;
            }
            value = isExisting;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while checking is existing role : " + roleName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return value;
    }

    public String[] getSystemRoles() throws UserStoreException {
        String sqlStmt = "SELECT UM_ROLE_NAME FROM UM_SYSTEM_ROLE WHERE UM_TENANT_ID=?";
        Connection dbConnection = null;
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            String[] roles = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, this.tenantId);
            String[] stringArray = UserCoreUtil.addDomainToNames(roles, "SYSTEM");
            return stringArray;
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting system roles";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public String[] getUserListOfSystemRole(String roleName) throws UserStoreException {
        String sqlStmt = "SELECT UM_USER_NAME FROM UM_SYSTEM_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?";
        Connection dbConnection = null;
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            String[] users = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, roleName, this.tenantId, this.tenantId);
            String[] stringArray = UserCoreUtil.addDomainToNames(users, "SYSTEM");
            return stringArray;
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting user list of system role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public void updateUserListOfSystemRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        String sqlStmt1 = "DELETE FROM UM_SYSTEM_USER_ROLE WHERE UM_USER_NAME=? AND UM_ROLE_ID=(SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?";
        String sqlStmt2 = "INSERT INTO UM_SYSTEM_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) VALUES (?,(SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?)";
        Connection dbConnection = null;
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            if ("mssql".equals(type)) {
                sqlStmt2 = "INSERT INTO UM_SYSTEM_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT (?),(SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?)";
            }
            if (deletedUsers != null && deletedUsers.length > 0) {
                DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedUsers, roleName, this.tenantId, this.tenantId);
            }
            if (newUsers != null && newUsers.length > 0) {
                if ("openedge".equals(type)) {
                    sqlStmt2 = "INSERT INTO UM_SYSTEM_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT ?, UM_ID, ? FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newUsers, this.tenantId, roleName, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newUsers, roleName, this.tenantId, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while updating user list of system role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while getting database type from DB connection";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public String[] getSystemRoleListOfUser(String userName) throws UserStoreException {
        String sqlStmt = "SELECT UM_ROLE_NAME FROM UM_SYSTEM_USER_ROLE, UM_SYSTEM_ROLE WHERE UM_USER_NAME=? AND UM_SYSTEM_USER_ROLE.UM_ROLE_ID=UM_SYSTEM_ROLE.UM_ID AND UM_SYSTEM_USER_ROLE.UM_TENANT_ID=? AND UM_SYSTEM_ROLE.UM_TENANT_ID=?";
        Connection dbConnection = null;
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            String[] roles = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, userName, this.tenantId, this.tenantId);
            String[] stringArray = UserCoreUtil.addDomainToNames(roles, "SYSTEM");
            return stringArray;
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting system role list of user : " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public void updateSystemRoleListOfUser(String user, String[] deletedRoles, String[] addRoles) throws UserStoreException {
        String sqlStmt1 = "DELETE FROM UM_SYSTEM_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_NAME=? AND UM_TENANT_ID=?";
        String sqlStmt2 = "INSERT INTO UM_SYSTEM_USER_ROLE (UM_ROLE_ID, UM_USER_NAME, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?, ?)";
        Connection dbConnection = null;
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            if ("mssql".equals(type)) {
                sqlStmt2 = "INSERT INTO UM_SYSTEM_USER_ROLE (UM_ROLE_ID, UM_USER_NAME, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?), (?)";
            }
            if (deletedRoles != null && deletedRoles.length > 0) {
                DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedRoles, this.tenantId, user, this.tenantId);
            }
            if (addRoles != null && addRoles.length > 0) {
                if ("openedge".equals(type)) {
                    sqlStmt2 = "INSERT INTO UM_SYSTEM_USER_ROLE (UM_ROLE_ID, UM_USER_NAME, UM_TENANT_ID) SELECT UM_ID, ?, ? FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, user, this.tenantId, addRoles, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, addRoles, this.tenantId, user, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting system role list of user : " + user;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while getting database type from DB connection";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public boolean isUserInRole(String userName, String roleName) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        boolean isUserInRole = false;
        try {
            int value;
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            prepStmt = dbConnection.prepareStatement("SELECT UM_ROLE_ID FROM UM_SYSTEM_USER_ROLE WHERE UM_USER_NAME=? AND UM_ROLE_ID=(SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
            prepStmt.setString(1, userName);
            prepStmt.setString(2, roleName);
            prepStmt.setInt(3, this.tenantId);
            prepStmt.setInt(4, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next() && (value = rs.getInt(1)) != -1) {
                isUserInRole = true;
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while checking is user : " + userName + " & in role : " + roleName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return isUserInRole;
    }

    public boolean isExistingSystemUser(String userName) throws UserStoreException {
        boolean value;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        boolean isExisting = false;
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_SYSTEM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, userName);
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next() && (value = rs.getInt(1)) > -1 != 0) {
                isExisting = true;
            }
            value = isExisting;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while checking is existing system user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return value;
    }

    public void addSystemUser(String userName, Object credential, String[] roleList) throws UserStoreException {
        Connection dbConnection = null;
        Secret credentialObj = null;
        try {
            credentialObj = Secret.getSecret((Object)credential);
        }
        catch (UnsupportedSecretTypeException e) {
            throw new UserStoreException("Unsupported credential type", e);
        }
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            String sqlStmt1 = "INSERT INTO UM_SYSTEM_USER (UM_USER_NAME, UM_USER_PASSWORD, UM_SALT_VALUE, UM_REQUIRE_CHANGE, UM_CHANGED_TIME, UM_TENANT_ID) VALUES (?, ?, ?, ?, ?, ?)";
            String saltValue = null;
            try {
                SecureRandom secureRandom = SecureRandom.getInstance(SHA_1_PRNG);
                byte[] bytes = new byte[16];
                secureRandom.nextBytes(bytes);
                saltValue = Base64.encode((byte[])bytes);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("SHA1PRNG algorithm could not be found.");
            }
            String password = this.preparePassword(credentialObj, saltValue);
            this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, saltValue, false, new Date(), this.tenantId);
            this.updateSystemRoleListOfUser(userName, null, roleList);
            dbConnection.commit();
        }
        catch (Throwable e) {
            try {
                if (dbConnection != null) {
                    dbConnection.rollback();
                }
            }
            catch (SQLException e1) {
                log.error((Object)"Error while rollbacking add system user operation", (Throwable)e1);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), e);
            }
            if (e instanceof UserStoreException && UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_WRITING_TO_DATABASE.getCode().equals(((UserStoreException)((Object)e)).getErrorCode())) {
                throw new UserStoreException(e.getMessage(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_A_SYSTEM_USER.getCode(), e);
            }
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            credentialObj.clear();
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public String[] getSystemUsers() throws UserStoreException {
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String filter = "*";
        int maxItemLimit = 100;
        Object[] systemsUsers = new String[]{};
        try {
            if (filter != null && filter.trim().length() != 0) {
                filter = filter.trim();
                filter = filter.replace("*", "%");
                filter = filter.replace("?", "_");
            } else {
                filter = "%";
            }
            LinkedList<String> lst = new LinkedList<String>();
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            if (dbConnection == null) {
                throw new UserStoreException("null connection");
            }
            dbConnection.setAutoCommit(false);
            dbConnection.setTransactionIsolation(2);
            sqlStmt = "SELECT UM_USER_NAME FROM UM_SYSTEM_USER WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID=? ORDER BY UM_USER_NAME";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, filter);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            for (int i = 0; rs.next() && i < maxItemLimit; ++i) {
                String name = rs.getString(1);
                lst.add(name);
            }
            rs.close();
            if (lst.size() > 0) {
                systemsUsers = lst.toArray(new String[lst.size()]);
            }
            Arrays.sort(systemsUsers);
            systemsUsers = UserCoreUtil.addDomainToNames((String[])systemsUsers, "SYSTEM");
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while getting system users";
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return systemsUsers;
    }

    private String preparePassword(Secret password, String saltValue) throws UserStoreException {
        try {
            if (saltValue != null) {
                password.addChars(saltValue.toCharArray());
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] byteValue = digest.digest(password.getBytes());
            return Base64.encode((byte[])byteValue);
        }
        catch (NoSuchAlgorithmException e) {
            String errorMessage = "Error occurred while preparing password";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateStringValuesToDatabase(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        PreparedStatement prepStmt;
        block16: {
            prepStmt = null;
            boolean localConnection = false;
            try {
                int count;
                if (dbConnection == null) {
                    localConnection = true;
                    dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
                }
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                if (params != null && params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        Object param = params[i];
                        if (param == null) {
                            throw new UserStoreException("Invalid data provided");
                        }
                        if (param instanceof String) {
                            prepStmt.setString(i + 1, (String)param);
                            continue;
                        }
                        if (param instanceof Integer) {
                            prepStmt.setInt(i + 1, (Integer)param);
                            continue;
                        }
                        if (param instanceof Date) {
                            prepStmt.setTimestamp(i + 1, new Timestamp(System.currentTimeMillis()));
                            continue;
                        }
                        if (!(param instanceof Boolean)) continue;
                        prepStmt.setBoolean(i + 1, (Boolean)param);
                    }
                }
                if ((count = prepStmt.executeUpdate()) == 0) {
                    log.info((Object)"No rows were updated");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executed querry is " + sqlStmt + " and number of updated rows :: " + count));
                }
                if (localConnection) {
                    dbConnection.commit();
                }
                if (!localConnection) break block16;
            }
            catch (SQLException e) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    if (!(e instanceof SQLIntegrityConstraintViolationException)) throw new UserStoreException(e.getMessage(), e);
                    throw new UserStoreException(e.getMessage(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_WRITING_TO_DATABASE.getCode(), e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }
}

