/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.Caching;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.SortControl;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.Properties;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.AuthenticationResult;
import org.wso2.carbon.user.core.common.FailureReason;
import org.wso2.carbon.user.core.common.LoginIdentifier;
import org.wso2.carbon.user.core.common.PaginatedSearchResult;
import org.wso2.carbon.user.core.common.RoleContext;
import org.wso2.carbon.user.core.common.UniqueIDPaginatedSearchResult;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.internal.UserStoreMgtDSComponent;
import org.wso2.carbon.user.core.ldap.LDAPRoleContext;
import org.wso2.carbon.user.core.ldap.LDAPSearchSpecification;
import org.wso2.carbon.user.core.ldap.ReadOnlyLDAPUserStoreConstants;
import org.wso2.carbon.user.core.ldap.ReadOnlyLDAPUserStoreManager;
import org.wso2.carbon.user.core.model.Condition;
import org.wso2.carbon.user.core.model.ExpressionAttribute;
import org.wso2.carbon.user.core.model.ExpressionCondition;
import org.wso2.carbon.user.core.model.ExpressionOperation;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.JNDIUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class UniqueIDReadOnlyLDAPUserStoreManager
extends ReadOnlyLDAPUserStoreManager {
    private static Log logger = LogFactory.getLog(UniqueIDReadOnlyLDAPUserStoreManager.class);
    public static final String MEMBER_UID = "memberUid";
    protected static final String OBJECT_GUID = "objectGUID";
    protected static final String MEMBERSHIP_ATTRIBUTE_RANGE = "MembershipAttributeRange";
    protected static final String MEMBERSHIP_ATTRIBUTE_RANGE_DISPLAY_NAME = "Membership Attribute Range";
    private static final String USER_CACHE_NAME_PREFIX = "$__local__$.UserCache-";
    private static final String USER_CACHE_MANAGER = "UserCacheManager";
    private static Log log = LogFactory.getLog(UniqueIDReadOnlyLDAPUserStoreManager.class);
    private static final String MULTI_ATTRIBUTE_SEPARATOR_DESCRIPTION = "This is the separator for multiple claim values";
    private static final String MULTI_ATTRIBUTE_SEPARATOR = "MultiAttributeSeparator";
    private static final ArrayList<Property> UNIQUE_ID_RO_LDAP_UM_ADVANCED_PROPERTIES = new ArrayList();
    private static final String PROPERTY_REFERRAL_IGNORE = "ignore";
    private static final String LDAPConnectionTimeout = "LDAPConnectionTimeout";
    private static final String LDAPConnectionTimeoutDescription = "LDAP Connection Timeout";
    private static final String readTimeout = "ReadTimeout";
    private static final String readTimeoutDescription = "Configure this to define the read timeout for LDAP operations";
    private static final String RETRY_ATTEMPTS = "RetryAttempts";
    private static final String LDAPBinaryAttributesDescription = "Configure this to define the LDAP binary attributes seperated by a space. Ex:mpegVideo mySpecialKey";
    protected static final String USER_CACHE_EXPIRY_TIME_ATTRIBUTE_NAME = "User Cache Expiry milliseconds";
    protected static final String USER_DN_CACHE_ENABLED_ATTRIBUTE_NAME = "Enable User DN Cache";
    protected static final String USER_CACHE_EXPIRY_TIME_ATTRIBUTE_DESCRIPTION = "Configure the user cache expiry in milliseconds. Values  {0: expire immediately, -1: never expire, '': i.e. empty, system default}.";
    protected static final String USER_DN_CACHE_ENABLED_ATTRIBUTE_DESCRIPTION = "Enables the user cache. Default true, Unless set to false. Empty value is interpreted as true.";
    private static final String USE_ANONYMOUS_BIND = "AnonymousBind";
    protected static final int MEMBERSHIP_ATTRIBUTE_RANGE_VALUE = 0;
    private static final int MAX_ITEM_LIMIT_UNLIMITED = -1;
    private String cacheExpiryTimeAttribute = "";
    private long userDnCacheExpiryTime = 0L;
    private CacheBuilder userDnCacheBuilder = null;
    private String userDnCacheName;
    private boolean userDnCacheEnabled = true;

    public UniqueIDReadOnlyLDAPUserStoreManager() {
    }

    public UniqueIDReadOnlyLDAPUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        super(realmConfig, properties, claimManager, profileManager, realm, tenantId, false);
    }

    public UniqueIDReadOnlyLDAPUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId, boolean skipInitData) throws UserStoreException {
        super(realmConfig, properties, claimManager, profileManager, realm, tenantId, skipInitData);
    }

    public UniqueIDReadOnlyLDAPUserStoreManager(RealmConfiguration realmConfig, ClaimManager claimManager, ProfileConfigurationManager profileManager) throws UserStoreException {
        super(realmConfig, claimManager, profileManager);
    }

    @Override
    protected void checkRequiredUserStoreConfigurations() throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Checking LDAP configurations ");
        }
        String connectionURL = this.realmConfig.getUserStoreProperty("ConnectionURL");
        String DNSURL = this.realmConfig.getUserStoreProperty("URLOfDNS");
        String AnonymousBind = this.realmConfig.getUserStoreProperty(USE_ANONYMOUS_BIND);
        if (!(connectionURL != null && connectionURL.trim().length() != 0 || DNSURL != null && DNSURL.trim().length() != 0)) {
            throw new UserStoreException("Required ConnectionURL property is not set at the LDAP configurations");
        }
        if (!Boolean.parseBoolean(AnonymousBind)) {
            String connectionName = this.realmConfig.getUserStoreProperty("ConnectionName");
            if (StringUtils.isEmpty((String)connectionName)) {
                throw new UserStoreException("Required ConnectionNme property is not set at the LDAP configurations");
            }
            String connectionPassword = this.realmConfig.getUserStoreProperty("ConnectionPassword");
            if (StringUtils.isEmpty((String)connectionPassword)) {
                throw new UserStoreException("Required ConnectionPassword property is not set at the LDAP configurations");
            }
        }
        this.userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        if (this.userSearchBase == null || this.userSearchBase.trim().length() == 0) {
            throw new UserStoreException("Required UserSearchBase property is not set at the LDAP configurations");
        }
        String usernameListFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
        if (usernameListFilter == null || usernameListFilter.trim().length() == 0) {
            throw new UserStoreException("Required UserNameListFilter property is not set at the LDAP configurations");
        }
        String usernameSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        if (usernameSearchFilter == null || usernameSearchFilter.trim().length() == 0) {
            throw new UserStoreException("Required UserNameSearchFilter property is not set at the LDAP configurations");
        }
        String usernameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        if (usernameAttribute == null || usernameAttribute.trim().length() == 0) {
            throw new UserStoreException("Required UserNameAttribute property is not set at the LDAP configurations");
        }
        String userIDAttribute = this.realmConfig.getUserStoreProperty("UserIDAttribute");
        if (userIDAttribute == null || userIDAttribute.trim().length() == 0) {
            throw new UserStoreException("Required userIDAttribute property is not set at the LDAP configurations");
        }
        this.writeGroupsEnabled = false;
        if (this.realmConfig.getUserStoreProperty("ReadGroups") != null) {
            this.readGroupsEnabled = Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("ReadGroups"));
        }
        if (log.isDebugEnabled()) {
            if (this.readGroupsEnabled) {
                log.debug((Object)("ReadGroups is enabled for " + this.getMyDomainName()));
            } else {
                log.debug((Object)("ReadGroups is disabled for " + this.getMyDomainName()));
            }
        }
        if (this.readGroupsEnabled) {
            this.groupSearchBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
            if (this.groupSearchBase == null || this.groupSearchBase.trim().length() == 0) {
                throw new UserStoreException("Required GroupSearchBase property is not set at the LDAP configurations");
            }
            String groupNameListFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
            if (groupNameListFilter == null || groupNameListFilter.trim().length() == 0) {
                throw new UserStoreException("Required GroupNameListFilter property is not set at the LDAP configurations");
            }
            String groupNameSearchFilter = this.realmConfig.getUserStoreProperty("GroupNameSearchFilter");
            if (groupNameSearchFilter == null || groupNameSearchFilter.trim().length() == 0) {
                throw new UserStoreException("Required GroupNameSearchFilter property is not set at the LDAP configurations");
            }
            String groupNameAttribute = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
            if (groupNameAttribute == null || groupNameAttribute.trim().length() == 0) {
                throw new UserStoreException("Required GroupNameAttribute property is not set at the LDAP configurations");
            }
            String memebershipAttribute = this.realmConfig.getUserStoreProperty("MembershipAttribute");
            if (memebershipAttribute == null || memebershipAttribute.trim().length() == 0) {
                throw new UserStoreException("Required MembershipAttribute property is not set at the LDAP configurations");
            }
        }
        this.cacheExpiryTimeAttribute = this.realmConfig.getUserStoreProperty("UserCacheExpiryMilliseconds");
        String userDnCacheEnabledAttribute = this.realmConfig.getUserStoreProperty("UserDNCacheEnabled");
        if (StringUtils.isNotEmpty((String)userDnCacheEnabledAttribute)) {
            this.userDnCacheEnabled = Boolean.parseBoolean(userDnCacheEnabledAttribute);
        }
    }

    @Override
    public AuthenticationResult doAuthenticateWithID(String preferredUserNameProperty, String preferredUserNameValue, Object credential, String profileName) throws UserStoreException {
        if (!this.validateForWildCardCharacters(preferredUserNameValue)) {
            String reason = "preferredUserNameValue is not valid. It contains LDAP special character/characters: " + preferredUserNameValue;
            return this.handleAuthenticationFailure(reason);
        }
        String userPropertyName = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        Object[] users = preferredUserNameProperty.equals(userPropertyName) ? new String[]{preferredUserNameValue} : super.getUserListFromProperties(preferredUserNameProperty, preferredUserNameValue, profileName);
        if (ArrayUtils.isEmpty((Object[])users)) {
            String reason = "Invalid scenario. No users found for the given username property: " + preferredUserNameValue + " and value: " + preferredUserNameValue;
            return this.handleAuthenticationFailure(reason);
        }
        if (users.length > 1) {
            String reason = "Invalid scenario. Multiple users found for the given username property: " + preferredUserNameValue + " and value: " + preferredUserNameValue;
            return this.handleAuthenticationFailure(reason);
        }
        if (super.doAuthenticate((String)users[0], credential)) {
            Object userName = users[0];
            String userID = this.getUserIDFromUserName((String)userName);
            User user = this.getUser(userID, (String)userName);
            user.setPreferredUsername(preferredUserNameValue);
            AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.SUCCESS);
            authenticationResult.setAuthenticatedUser(user);
            return authenticationResult;
        }
        String reason = "Authentication failed for the given username property: " + preferredUserNameValue + " and value: " + preferredUserNameValue;
        return this.handleAuthenticationFailure(reason);
    }

    @Override
    public AuthenticationResult doAuthenticateWithID(List<LoginIdentifier> loginIdentifiers, Object credential) throws UserStoreException {
        List<String> users = this.doGetUserListFromProperties(loginIdentifiers);
        if (users.isEmpty()) {
            String reason = "Invalid scenario. No users found for the given username properties";
            return this.handleAuthenticationFailure(reason);
        }
        if (users.size() > 1) {
            String reason = "Invalid scenario. Multiple users found for the given username properties";
            return this.handleAuthenticationFailure(reason);
        }
        if (super.doAuthenticate(users.get(0), credential)) {
            String userName = users.get(0);
            String userID = this.getUserIDFromUserName(userName);
            User user = this.getUser(userID, userName);
            AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.SUCCESS);
            authenticationResult.setAuthenticatedUser(user);
            return authenticationResult;
        }
        String reason = "Authentication failed for the given username properties";
        return this.handleAuthenticationFailure(reason);
    }

    protected List<String> doGetUserListFromProperties(List<LoginIdentifier> loginIdentifiers) throws UserStoreException {
        ArrayList<String> results;
        boolean debug;
        block18: {
            debug = log.isDebugEnabled();
            String userAttributeSeparator = ",";
            String serviceNameAttribute = "sn";
            results = new ArrayList<String>();
            String userPropertyName = this.realmConfig.getUserStoreProperty("UserNameAttribute");
            String searchFilter = this.getSearchFilter(loginIdentifiers);
            DirContext dirContext = this.connectionSource.getContext();
            NamingEnumeration<SearchResult> answer = null;
            NamingEnumeration<?> attrs = null;
            if (debug) {
                log.debug((Object)("Listing users with SearchFilter: " + searchFilter));
            }
            String[] returnedAttributes = new String[]{userPropertyName, serviceNameAttribute};
            try {
                String searchBase;
                String[] searchBaseArray;
                String searchBases = this.realmConfig.getUserStoreProperty("UserSearchBase");
                String[] stringArray = searchBaseArray = searchBases.split("#");
                int n = stringArray.length;
                for (int i = 0; i < n && !(answer = this.searchUsersForASearchBase(searchFilter, returnedAttributes, dirContext, searchBase = stringArray[i], -1)).hasMore(); ++i) {
                }
                while (answer != null && answer.hasMoreElements()) {
                    Attribute attribute;
                    SearchResult sr = (SearchResult)answer.next();
                    Attributes attributes = sr.getAttributes();
                    if (attributes == null || (attribute = attributes.get(userPropertyName)) == null) continue;
                    StringBuffer attrBuffer = new StringBuffer();
                    attrs = attribute.getAll();
                    while (attrs.hasMore()) {
                        String attr = (String)attrs.next();
                        if (attr == null || attr.trim().length() <= 0) continue;
                        String attrSeparator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
                        if (attrSeparator != null && !attrSeparator.trim().isEmpty()) {
                            userAttributeSeparator = attrSeparator;
                        }
                        attrBuffer.append(attr + userAttributeSeparator);
                        if (!debug) continue;
                        log.debug((Object)(userPropertyName + " : " + attr));
                    }
                    String propertyValue = attrBuffer.toString();
                    Attribute serviceNameObject = attributes.get(serviceNameAttribute);
                    String serviceNameAttributeValue = null;
                    if (serviceNameObject != null) {
                        serviceNameAttributeValue = (String)serviceNameObject.get();
                    }
                    if (propertyValue == null || propertyValue.trim().length() <= userAttributeSeparator.length() || "Service".equals(serviceNameAttributeValue)) continue;
                    propertyValue = propertyValue.substring(0, propertyValue.length() - userAttributeSeparator.length());
                    results.add(propertyValue);
                }
            }
            catch (PartialResultException e) {
                String errorMessage = "Error occurred while getting user list for SearchFilter : " + searchFilter;
                if (this.isIgnorePartialResultException()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMessage, (Throwable)e);
                    }
                    break block18;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (NamingException e) {
                String errorMessage = "Error occurred while getting user list with SearchFilter: " + searchFilter;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(attrs);
                JNDIUtil.closeNamingEnumeration(answer);
                JNDIUtil.closeContext(dirContext);
            }
        }
        if (debug) {
            for (String result : results) {
                log.debug((Object)("result: " + result));
            }
        }
        return results;
    }

    private String getSearchFilter(List<LoginIdentifier> loginIdentifiers) {
        String userNameListFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
        StringBuilder searchFilter = new StringBuilder("(&" + userNameListFilter);
        for (LoginIdentifier loginIdentifier : loginIdentifiers) {
            String property = loginIdentifier.getLoginKey();
            String value = loginIdentifier.getLoginValue();
            if (OBJECT_GUID.equalsIgnoreCase(property)) {
                String convertedValue;
                boolean transformObjectGuidToUuid;
                String transformObjectGuidToUuidProperty = this.realmConfig.getUserStoreProperty("transformObjectGUIDToUUID");
                boolean bl = transformObjectGuidToUuid = StringUtils.isEmpty((String)transformObjectGuidToUuidProperty) || Boolean.parseBoolean(transformObjectGuidToUuidProperty);
                if (transformObjectGuidToUuid) {
                    convertedValue = this.transformUUIDToObjectGUID(value);
                } else {
                    byte[] bytes = Base64.decodeBase64((byte[])value.getBytes());
                    convertedValue = this.convertBytesToHexString(bytes);
                }
                searchFilter.append("(").append(property).append("=").append(convertedValue).append(")");
                continue;
            }
            searchFilter.append("(").append(property).append("=").append(this.escapeSpecialCharactersForFilterWithStarAsRegex(value)).append(")");
        }
        searchFilter.append(")");
        return searchFilter.toString();
    }

    @Override
    public AuthenticationResult doAuthenticateWithID(String userID, Object credential) throws UserStoreException {
        if (!this.validateForWildCardCharacters(userID)) {
            String reason = "preferredUserNameValue is not valid. It contains LDAP special character/characters: " + userID;
            return this.handleAuthenticationFailure(reason);
        }
        String userIDAttribute = this.realmConfig.getUserStoreProperty("UserIDAttribute");
        Object[] users = super.getUserListFromProperties(userIDAttribute, userID, null);
        if (ArrayUtils.isEmpty((Object[])users)) {
            String reason = "Invalid scenario. No users found for the given userID: " + userID;
            return this.handleAuthenticationFailure(reason);
        }
        if (users.length > 1) {
            String reason = "Invalid scenario. Multiple users found for the given userID: " + userID;
            return this.handleAuthenticationFailure(reason);
        }
        if (super.doAuthenticate((String)users[0], credential)) {
            Object userName = users[0];
            User user = this.getUser(userID, (String)userName);
            AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.SUCCESS);
            authenticationResult.setAuthenticatedUser(user);
            return authenticationResult;
        }
        String reason = "Authentication failed for the given userID: " + userID;
        return this.handleAuthenticationFailure(reason);
    }

    private AuthenticationResult handleAuthenticationFailure(String reason) {
        if (log.isDebugEnabled()) {
            log.debug((Object)reason);
        }
        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
        authenticationResult.setFailureReason(new FailureReason(reason));
        return authenticationResult;
    }

    private boolean validateForWildCardCharacters(String preferredUserNameValue) {
        String[] ldapSpecialCharacters = new String[]{"*", "<", ">", "~", "!", ")", "("};
        if (StringUtils.isNotEmpty((String)preferredUserNameValue)) {
            for (String ldapSpecialCharacter : ldapSpecialCharacters) {
                if (!preferredUserNameValue.contains(ldapSpecialCharacter)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean doAuthenticate(String userName, Object credential) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    protected String doGetUserIDFromUserNameWithID(String userName) throws UserStoreException {
        String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        return this.getUserIDFromProperty(userNameProperty, userName);
    }

    private String getUserIDFromProperty(String property, String claimValue) throws UserStoreException {
        try {
            List<String> userIds = this.doGetUserListFromPropertiesWithID(property, claimValue, null);
            if (userIds.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No UserID found for the property: " + property + ", value: " + claimValue + ", in domain: " + this.getMyDomainName()));
                }
                return null;
            }
            if (userIds.size() > 1) {
                throw new UserStoreException("Invalid scenario. Multiple users cannot be found for the given value: " + claimValue + "of the property: " + property);
            }
            return userIds.get(0);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException("Error occurred while retrieving the userId of domain : " + this.getMyDomainName() + " and property" + property + " value: " + claimValue, e);
        }
    }

    @Override
    public String getUserIDFromProperties(String claimURI, String claimValue, String profileName) throws UserStoreException {
        try {
            String property = this.claimManager.getAttributeName(this.getMyDomainName(), claimURI);
            if (property == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Could not find the matching property for claim URI: " + claimURI + " in user domain: " + this.getMyDomainName()));
                }
                return null;
            }
            return this.getUserIDFromProperty(property, claimValue);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException("Error occurred while retrieving the userId of domain : " + this.getMyDomainName() + " and claim" + claimURI + " value: " + claimValue, e);
        }
    }

    @Override
    public String doGetUserNameFromUserIDWithID(String userID) throws UserStoreException {
        String userIDAttribute = this.realmConfig.getUserStoreProperty("UserIDAttribute");
        String[] userNames = super.getUserListFromProperties(userIDAttribute, userID, null);
        if (userNames.length > 1) {
            throw new UserStoreException("Invalid scenario. Multiple users cannot be found for the given userID: " + userID);
        }
        if (userNames.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No user ID found for the given userID: " + userID));
            }
            return null;
        }
        return userNames[0];
    }

    @Override
    public String[] getProfileNamesWithID(String userID) throws UserStoreException {
        return new String[]{"default"};
    }

    @Override
    protected Map<String, String> getUserPropertyValuesWithID(String userID, String[] propertyNames, String profileName) throws UserStoreException {
        return super.getUserPropertyValues(this.doGetUserNameFromUserID(userID), propertyNames, profileName);
    }

    @Override
    public boolean doCheckExistingUserNameWithIDImpl(String userName) throws UserStoreException {
        return super.doCheckExistingUser(userName);
    }

    @Override
    public boolean doCheckExistingUserWithID(String userID) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for userID " + userID));
        }
        if (userID == null) {
            return false;
        }
        return this.doGetUserNameFromUserID(userID) != null;
    }

    @Override
    public String[] doListUsers(String filter, int maxItemLimit) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public List<User> doListUsersWithID(String filter, int maxItemLimit) throws UserStoreException {
        ArrayList<User> userNames;
        block31: {
            String[] returnedAttributes;
            userNames = new ArrayList<User>();
            if (maxItemLimit == 0) {
                return userNames;
            }
            int givenMax = 100;
            int searchTime = 10000;
            try {
                givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
            }
            catch (Exception e) {
                givenMax = 100;
            }
            try {
                searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
            }
            catch (NumberFormatException e) {
                searchTime = 10000;
            }
            if (maxItemLimit < 0 || maxItemLimit > givenMax) {
                maxItemLimit = givenMax;
            }
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            searchCtls.setCountLimit(maxItemLimit);
            searchCtls.setTimeLimit(searchTime);
            if (filter.contains("?") || filter.contains("**")) {
                throw new UserStoreException("Invalid character sequence entered for user serch. Please enter valid sequence.");
            }
            StringBuilder searchFilter = new StringBuilder(this.realmConfig.getUserStoreProperty("UserNameListFilter"));
            String searchBases = this.realmConfig.getUserStoreProperty("UserSearchBase");
            String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
            String userIDProperty = this.realmConfig.getUserStoreProperty("UserIDAttribute");
            String serviceNameAttribute = "sn";
            StringBuilder finalFilter = new StringBuilder();
            String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
            if (StringUtils.isNotEmpty((String)displayNameAttribute)) {
                returnedAttributes = new String[]{userNameProperty, serviceNameAttribute, displayNameAttribute, userIDProperty};
                finalFilter.append("(&").append((CharSequence)searchFilter).append("(").append(displayNameAttribute).append("=").append(this.escapeSpecialCharactersForFilterWithStarAsRegex(filter)).append("))");
            } else {
                returnedAttributes = new String[]{userNameProperty, serviceNameAttribute, userIDProperty};
                finalFilter.append("(&").append((CharSequence)searchFilter).append("(").append(userNameProperty).append("=").append(this.escapeSpecialCharactersForFilterWithStarAsRegex(filter)).append("))");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Listing users. SearchBase: " + searchBases + " Constructed-Filter: " + finalFilter.toString()));
                log.debug((Object)("Search controls. Max Limit: " + maxItemLimit + " Max Time: " + searchTime));
            }
            searchCtls.setReturningAttributes(returnedAttributes);
            DirContext dirContext = null;
            NamingEnumeration<SearchResult> answer = null;
            ArrayList<User> list = new ArrayList<User>();
            try {
                dirContext = this.connectionSource.getContext();
                String[] searchBaseArray = searchBases.split("#");
                for (String searchBase : searchBaseArray) {
                    answer = dirContext.search(this.escapeDNForSearch(searchBase), finalFilter.toString(), searchCtls);
                    while (answer.hasMoreElements()) {
                        SearchResult sr = answer.next();
                        if (sr.getAttributes() == null) continue;
                        log.debug((Object)"Result found ..");
                        Attribute userName = sr.getAttributes().get(userNameProperty);
                        Attribute userID = sr.getAttributes().get(userIDProperty);
                        Attribute attrSurname = sr.getAttributes().get(serviceNameAttribute);
                        if (attrSurname != null) {
                            String serviceName;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(serviceNameAttribute + " : " + attrSurname));
                            }
                            if ((serviceName = (String)attrSurname.get()) != null && serviceName.equals("Service")) continue;
                        }
                        Attribute displayName = null;
                        if (StringUtils.isNotEmpty((String)displayNameAttribute)) {
                            displayName = sr.getAttributes().get(displayNameAttribute);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(displayNameAttribute + " : " + displayName));
                            }
                        }
                        String name = null;
                        String display = null;
                        String id = null;
                        String domain = null;
                        if (userName != null) {
                            name = this.resolveLdapAttributeValue(userName.get());
                            if (displayName != null) {
                                display = this.resolveLdapAttributeValue(displayName.get());
                            }
                            domain = this.getRealmConfiguration().getUserStoreProperty("DomainName");
                        }
                        if (userID != null) {
                            id = this.resolveLdapAttributeValue(userID.get());
                        }
                        name = UserCoreUtil.getCombinedName(domain, name, display);
                        User user = this.getUser(id, name);
                        user.setDisplayName(display);
                        user.setUserStoreDomain(domain);
                        user.setTenantDomain(this.getTenantDomain(this.tenantId));
                        list.add(user);
                    }
                }
                userNames = list;
                if (log.isDebugEnabled()) {
                    for (User userName : userNames) {
                        log.debug((Object)("result: " + userName.getUsername()));
                    }
                }
            }
            catch (PartialResultException e) {
                String errorMessage = "Error occurred while getting user list for filter : " + filter + "max limit : " + maxItemLimit;
                if (this.isIgnorePartialResultException()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMessage, (Throwable)e);
                    }
                    break block31;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (NamingException e) {
                String errorMessage = "Error occurred while getting user list for filter : " + filter + "max limit : " + maxItemLimit;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(answer);
                JNDIUtil.closeContext(dirContext);
            }
        }
        return userNames;
    }

    @Override
    public String[] doGetUserListOfRole(String roleName, String filter) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public List<User> doGetUserListOfRoleWithID(String roleName, String filter) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        return this.getUserListOfLDAPRoleWithID(roleContext, filter);
    }

    protected String resolveLdapAttributeValue(Object attributeObject) {
        String resolvedStringValue = null;
        if (attributeObject instanceof String) {
            resolvedStringValue = (String)attributeObject;
        } else if (attributeObject instanceof byte[]) {
            byte[] bytes = (byte[])attributeObject;
            if (bytes.length == 16) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(this.swapBytes(bytes));
                resolvedStringValue = new UUID(byteBuffer.getLong(), byteBuffer.getLong()).toString();
            } else {
                resolvedStringValue = new String(Base64.encodeBase64((byte[])((byte[])attributeObject)));
            }
        }
        return resolvedStringValue;
    }

    /*
     * Loose catch block
     */
    protected List<User> getUserListOfLDAPRoleWithID(RoleContext context, String filter) throws UserStoreException {
        ArrayList<User> userList;
        block50: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting user list of role: " + context.getRoleName() + " with filter: " + filter));
            }
            userList = new ArrayList<User>();
            int givenMax = 100;
            int searchTime = 10000;
            try {
                givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
            }
            catch (Exception e) {
                givenMax = 100;
            }
            try {
                searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
            }
            catch (Exception e) {
                searchTime = 10000;
            }
            DirContext dirContext = null;
            NamingEnumeration<SearchResult> answer = null;
            try {
                SearchControls searchCtls = new SearchControls();
                searchCtls.setSearchScope(2);
                searchCtls.setTimeLimit(searchTime);
                searchCtls.setCountLimit(givenMax);
                String searchFilter = ((LDAPRoleContext)context).getListFilter();
                String roleNameProperty = ((LDAPRoleContext)context).getRoleNameProperty();
                searchFilter = "(&" + searchFilter + "(" + roleNameProperty + "=" + this.escapeSpecialCharactersForFilter(context.getRoleName()) + "))";
                int offset = 0;
                int lastRecord = 0;
                int attributeValuesRange = 0;
                boolean isEndOfAttributes = false;
                String roleListRange = this.realmConfig.getUserStoreProperty(MEMBERSHIP_ATTRIBUTE_RANGE);
                if (StringUtils.isNotEmpty((String)roleListRange)) {
                    attributeValuesRange = Integer.parseInt(roleListRange);
                }
                if (attributeValuesRange > 0) {
                    lastRecord = attributeValuesRange - 1;
                }
                String membershipProperty = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                ArrayList<String> userDNList = new ArrayList<String>();
                String rangedMembershipProperty = membershipProperty;
                while (!isEndOfAttributes) {
                    Attributes attributes;
                    if (lastRecord > 0 && StringUtils.isNotEmpty((String)membershipProperty)) {
                        rangedMembershipProperty = membershipProperty + String.format(";range=%1$d-%2$d", offset, lastRecord);
                    }
                    String[] returnedAtts = new String[]{rangedMembershipProperty};
                    searchCtls.setReturningAttributes(returnedAtts);
                    Object sr = null;
                    dirContext = this.connectionSource.getContext();
                    if (!((LDAPRoleContext)context).getRoleDNPatterns().isEmpty()) {
                        for (String pattern : ((LDAPRoleContext)context).getRoleDNPatterns()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Using pattern: " + pattern));
                            }
                            pattern = MessageFormat.format(pattern.trim(), this.escapeSpecialCharactersForDN(context.getRoleName()));
                            try {
                                answer = dirContext.search(this.escapeDNForSearch(pattern), searchFilter, searchCtls);
                                if (!answer.hasMore()) continue;
                                sr = answer.next();
                                break;
                            }
                            catch (NamingException e) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)e);
                            }
                        }
                    }
                    if (sr == null) {
                        String[] roleSearchBaseArray;
                        String searchBases = ((LDAPRoleContext)context).getSearchBase();
                        for (String searchBase : roleSearchBaseArray = searchBases.split("#")) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Searching role: " + context.getRoleName() + " SearchBase: " + searchBase + " SearchFilter: " + searchFilter));
                            }
                            try {
                                answer = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchCtls);
                                int count = 0;
                                if (!answer.hasMore()) continue;
                                while (answer.hasMore()) {
                                    if (count > 0) {
                                        throw new UserStoreException("More than one group exist with name");
                                    }
                                    sr = answer.next();
                                    ++count;
                                }
                                break;
                            }
                            catch (NamingException e) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)e);
                            }
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found role: " + ((NameClassPair)sr).getNameInNamespace()));
                    }
                    if ((attributes = ((SearchResult)sr).getAttributes()) == null) continue;
                    int recordCount = 0;
                    NamingEnumeration<? extends Attribute> attributeEntry = attributes.getAll();
                    while (attributeEntry.hasMore()) {
                        Attribute valAttribute = attributeEntry.next();
                        if (membershipProperty != null && !this.isAttributeEqualsProperty(membershipProperty, valAttribute.getID())) continue;
                        NamingEnumeration<?> values = null;
                        values = valAttribute.getAll();
                        while (values.hasMore()) {
                            String value = values.next().toString();
                            userDNList.add(value);
                            ++recordCount;
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Found attribute: " + membershipProperty + " value: " + value));
                        }
                    }
                    if (attributeValuesRange == 0 || recordCount < attributeValuesRange) {
                        isEndOfAttributes = true;
                        continue;
                    }
                    offset += attributeValuesRange;
                    lastRecord += attributeValuesRange;
                }
                if (MEMBER_UID.equals(this.realmConfig.getUserStoreProperty("MembershipAttribute"))) {
                    ArrayList<String> userDNListNew = new ArrayList<String>();
                    for (String user : userDNList) {
                        String userDN = this.getNameInSpaceForUserName(user);
                        userDNListNew.add(userDN);
                    }
                    userDNList = userDNListNew;
                }
                String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
                String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
                String userIDAttribute = this.realmConfig.getUserStoreProperty("UserIDAttribute");
                String[] returnedAttributes = new String[]{userNameProperty, displayNameAttribute, userIDAttribute};
                User userObject = null;
                for (String user : userDNList) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Getting name attributes of: " + user));
                    }
                    try {
                        Attributes userAttributes = dirContext.getAttributes(this.escapeDNForSearch(user), returnedAttributes);
                        String displayName = null;
                        String userName = null;
                        String id = null;
                        if (userAttributes != null) {
                            Attribute userNameAttribute = userAttributes.get(userNameProperty);
                            if (userNameAttribute != null) {
                                userName = (String)userNameAttribute.get();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("UserName: " + userName));
                                }
                            }
                            if (StringUtils.isNotEmpty((String)displayNameAttribute)) {
                                Attribute displayAttribute = userAttributes.get(displayNameAttribute);
                                if (displayAttribute != null) {
                                    displayName = (String)displayAttribute.get();
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("DisplayName: " + displayName));
                                }
                            }
                            if (StringUtils.isNotEmpty((String)userIDAttribute)) {
                                Attribute userID = userAttributes.get(userIDAttribute);
                                if (userID != null) {
                                    id = this.resolveLdapAttributeValue(userID.get());
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("UserID: " + id));
                                }
                            }
                        }
                        String domainName = this.realmConfig.getUserStoreProperty("DomainName");
                        userObject = this.getUser(id, userName);
                        userObject.setDisplayName(displayName);
                        userObject.setUserStoreDomain(domainName);
                        userObject.setTenantDomain(this.getTenantDomain(this.tenantId));
                        userList.add(userObject);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)(userObject.getUsername() + " is added to the result list"));
                    }
                    catch (NamingException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Error in reading user information in the user store for the user: " + user + " " + e.getMessage()), (Throwable)e);
                    }
                }
                JNDIUtil.closeNamingEnumeration(answer);
            }
            catch (PartialResultException e) {
                String errorMessage = "Error in reading user information in the user store for filter : " + filter;
                if (this.isIgnorePartialResultException()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMessage, (Throwable)e);
                    }
                    break block50;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (NamingException e2) {
                String errorMessage = "Error in reading user information in the user store for filter : " + filter;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e2);
                }
                throw new UserStoreException(errorMessage, e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                JNDIUtil.closeNamingEnumeration(answer);
                JNDIUtil.closeContext(dirContext);
            }
            JNDIUtil.closeContext(dirContext);
        }
        return userList;
    }

    private boolean isAttributeEqualsProperty(String property, String attribute) {
        if (StringUtils.isEmpty((String)property) || StringUtils.isEmpty((String)attribute)) {
            return false;
        }
        return property.equals(attribute) || property.equals(attribute.substring(0, attribute.indexOf(";")));
    }

    @Override
    protected String[] doGetExternalRoleListOfUser(String userName, String filter) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    protected String[] doGetExternalRoleListOfUserWithID(String userID, String filter) throws UserStoreException {
        String searchBase = this.getEffectiveSearchBase(false);
        String userName = this.doGetUserNameFromUserID(userID);
        return this.getLDAPRoleListOfUser(userName, filter, searchBase, false);
    }

    @Override
    public String[] doGetSharedRoleListOfUser(String userName, String tenantDomain, String filter) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public String[] doGetSharedRoleListOfUserWithID(String userID, String tenantDomain, String filter) throws UserStoreException {
        String searchBase = this.getEffectiveSearchBase(true);
        if (tenantDomain != null && tenantDomain.trim().length() > 0 && !"carbon.super".equalsIgnoreCase(tenantDomain.trim())) {
            String groupNameAttributeName = this.realmConfig.getUserStoreProperty("SharedTenantNameAttribute");
            if (groupNameAttributeName == null || groupNameAttributeName.trim().length() == 0) {
                groupNameAttributeName = "ou";
            }
            searchBase = groupNameAttributeName + "=" + tenantDomain + "," + searchBase;
        }
        String userName = this.doGetUserNameFromUserID(userID);
        return this.getLDAPRoleListOfUser(userName, filter, searchBase, true);
    }

    @Override
    public boolean isReadOnly() throws UserStoreException {
        return true;
    }

    private List<String> parseSearchResult(SearchResult sr, String groupAttributeName) {
        ArrayList<String> list = new ArrayList<String>();
        Attributes attrs = sr.getAttributes();
        if (attrs != null) {
            try {
                NamingEnumeration<? extends Attribute> ae = null;
                ae = attrs.getAll();
                while (ae.hasMore()) {
                    Attribute attr = ae.next();
                    if (groupAttributeName != null && !groupAttributeName.equals(attr.getID())) continue;
                    NamingEnumeration<?> e = null;
                    e = attr.getAll();
                    while (e.hasMore()) {
                        String value = e.next().toString();
                        int begin = value.indexOf("=") + 1;
                        int end = value.indexOf(",");
                        if (begin > -1 && end > -1) {
                            value = value.substring(begin, end);
                        }
                        list.add(value);
                    }
                    JNDIUtil.closeNamingEnumeration(e);
                }
                JNDIUtil.closeNamingEnumeration(ae);
            }
            catch (NamingException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> getAttributeListOfOneElement(String searchBases, String searchFilter, SearchControls searchCtls) throws UserStoreException {
        List<String> list = new ArrayList<String>();
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        try {
            String[] searchBaseArray;
            dirContext = this.connectionSource.getContext();
            for (String searchBase : searchBaseArray = searchBases.split("#")) {
                try {
                    answer = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchCtls);
                    int count = 0;
                    if (!answer.hasMore()) continue;
                    while (answer.hasMore()) {
                        if (count > 0) {
                            log.error((Object)"More than element user exist with name");
                            throw new UserStoreException("More than element user exist with name");
                        }
                        SearchResult sr = answer.next();
                        ++count;
                        list = this.parseSearchResult(sr, null);
                    }
                    break;
                }
                catch (NamingException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)e);
                }
            }
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        return list;
    }

    @Override
    public List<String> doGetUserListFromPropertiesWithID(String property, String value, String profileName) throws UserStoreException {
        ArrayList<String> values;
        block33: {
            if (value == null) {
                return new ArrayList<String>();
            }
            String userAttributeSeparator = ",";
            String serviceNameAttribute = "sn";
            values = new ArrayList<String>();
            String searchFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
            String userIDProperty = this.realmConfig.getUserStoreProperty("UserIDAttribute");
            if (OBJECT_GUID.equalsIgnoreCase(property) && (this.isGUIDValue(value) || StringUtils.equals((String)value, (String)"*"))) {
                String convertedValue;
                boolean transformObjectGuidToUuid;
                String transformObjectGuidToUuidProperty = this.realmConfig.getUserStoreProperty("transformObjectGUIDToUUID");
                boolean bl = transformObjectGuidToUuid = StringUtils.isEmpty((String)transformObjectGuidToUuidProperty) || Boolean.parseBoolean(transformObjectGuidToUuidProperty);
                if (StringUtils.equals((String)value, (String)"*")) {
                    convertedValue = value;
                } else if (transformObjectGuidToUuid) {
                    convertedValue = this.transformUUIDToObjectGUID(value);
                } else {
                    byte[] bytes = Base64.decodeBase64((byte[])value.getBytes());
                    convertedValue = this.convertBytesToHexString(bytes);
                }
                searchFilter = "(&" + searchFilter + "(" + property + "=" + convertedValue + "))";
            } else {
                searchFilter = "(&" + searchFilter + "(" + property + "=" + this.escapeSpecialCharactersForFilterWithStarAsRegex(value) + "))";
            }
            DirContext dirContext = this.connectionSource.getContext();
            NamingEnumeration<SearchResult> answer = null;
            NamingEnumeration<?> attrs = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Listing users with Property: " + property + " SearchFilter: " + searchFilter));
            }
            String[] returnedAttributes = new String[]{userIDProperty, serviceNameAttribute};
            try {
                String searchBase;
                String[] searchBaseArray;
                String searchBases = this.realmConfig.getUserStoreProperty("UserSearchBase");
                String[] stringArray = searchBaseArray = searchBases.split("#");
                int n = stringArray.length;
                for (int i = 0; i < n && !(answer = this.searchUsersForASearchBase(searchFilter, returnedAttributes, dirContext, searchBase = stringArray[i], -1)).hasMore(); ++i) {
                }
                while (answer != null && answer.hasMoreElements()) {
                    Attribute attribute;
                    SearchResult sr = (SearchResult)answer.next();
                    Attributes attributes = sr.getAttributes();
                    if (attributes == null || (attribute = attributes.get(userIDProperty)) == null) continue;
                    StringBuilder attrBuffer = new StringBuilder();
                    attrs = attribute.getAll();
                    while (attrs.hasMore()) {
                        Object attObject = attrs.next();
                        String attr = null;
                        if (attObject instanceof String) {
                            attr = (String)attObject;
                        } else if (attObject instanceof byte[]) {
                            byte[] bytes = (byte[])attObject;
                            if (bytes.length == 16 && userIDProperty.toLowerCase().endsWith("uid")) {
                                if (userIDProperty.equalsIgnoreCase(OBJECT_GUID)) {
                                    boolean transformObjectGuidToUuid;
                                    String transformToObjectGuidProperty = this.realmConfig.getUserStoreProperty("transformObjectGUIDToUUID");
                                    boolean bl = transformObjectGuidToUuid = StringUtils.isEmpty((String)transformToObjectGuidProperty) || Boolean.parseBoolean(transformToObjectGuidProperty);
                                    if (transformObjectGuidToUuid) {
                                        ByteBuffer bb = ByteBuffer.wrap(this.swapBytes(bytes));
                                        attr = new UUID(bb.getLong(), bb.getLong()).toString();
                                    } else {
                                        attr = new String(Base64.encodeBase64((byte[])((byte[])attObject)));
                                    }
                                }
                            } else {
                                attr = new String(Base64.encodeBase64((byte[])((byte[])attObject)));
                            }
                        }
                        if (!StringUtils.isNotEmpty((String)attr)) continue;
                        String attrSeparator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
                        if (attrSeparator != null && !attrSeparator.trim().isEmpty()) {
                            userAttributeSeparator = attrSeparator;
                        }
                        attrBuffer.append(attr).append(userAttributeSeparator);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)(userIDProperty + " : " + attr));
                    }
                    String propertyValue = attrBuffer.toString();
                    Attribute serviceNameObject = attributes.get(serviceNameAttribute);
                    String serviceNameAttributeValue = null;
                    if (serviceNameObject != null) {
                        serviceNameAttributeValue = (String)serviceNameObject.get();
                    }
                    if (propertyValue == null || propertyValue.trim().length() <= userAttributeSeparator.length() || "Service".equals(serviceNameAttributeValue)) continue;
                    propertyValue = propertyValue.substring(0, propertyValue.length() - userAttributeSeparator.length());
                    values.add(propertyValue);
                }
            }
            catch (PartialResultException e) {
                String errorMessage = "Error occurred while getting user list from search Filter : " + searchFilter;
                if (this.isIgnorePartialResultException()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMessage, (Throwable)e);
                    }
                    break block33;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (NamingException e) {
                String errorMessage = "Error occurred while getting user list from property : " + property + " & value : " + value + " & profile name : " + profileName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(attrs);
                JNDIUtil.closeNamingEnumeration(answer);
                JNDIUtil.closeContext(dirContext);
            }
        }
        if (log.isDebugEnabled()) {
            String[] results;
            for (String result : results = values.toArray(new String[0])) {
                log.debug((Object)("result: " + result));
            }
        }
        return values;
    }

    @Override
    protected UniqueIDPaginatedSearchResult doGetUserListWithID(Condition condition, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        UniqueIDPaginatedSearchResult result = new UniqueIDPaginatedSearchResult();
        List<ExpressionCondition> expressionConditions = this.getExpressionConditions(condition);
        LDAPSearchSpecification ldapSearchSpecification = new LDAPSearchSpecification(this.realmConfig, expressionConditions);
        boolean isMemberShipPropertyFound = ldapSearchSpecification.isMemberShipPropertyFound();
        limit = this.getLimit(limit, isMemberShipPropertyFound);
        offset = this.getOffset(offset);
        if (limit == 0) {
            return result;
        }
        int pageSize = limit;
        DirContext dirContext = this.connectionSource.getContext();
        LdapContext ldapContext = (LdapContext)dirContext;
        String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        try {
            ldapContext.setRequestControls(new Control[]{new PagedResultsControl(pageSize, true), new SortControl(userNameAttribute, false)});
            List<User> users = this.performLDAPSearch(ldapContext, ldapSearchSpecification, pageSize, offset, expressionConditions);
            result.setUsers(users);
            UniqueIDPaginatedSearchResult uniqueIDPaginatedSearchResult = result;
            return uniqueIDPaginatedSearchResult;
        }
        catch (NamingException e) {
            log.error((Object)String.format("Error occurred while performing paginated search, %s", e.getMessage()));
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (IOException e) {
            log.error((Object)String.format("Error occurred while setting paged results controls for paginated search, %s", e.getMessage()));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeContext(dirContext);
            JNDIUtil.closeContext(ldapContext);
        }
    }

    @Override
    protected PaginatedSearchResult doGetUserList(Condition condition, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public boolean doCheckIsUserInRole(String userName, String roleName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public boolean doCheckIsUserInRoleWithID(String userID, String roleName) throws UserStoreException {
        return super.doCheckIsUserInRole(this.doGetUserNameFromUserID(userID), roleName);
    }

    @Override
    public Date getPasswordExpirationTimeWithID(String userID) throws UserStoreException {
        String username = this.getUserNameFromUserID(userID);
        return super.getPasswordExpirationTime(username);
    }

    @Override
    public int getTenantId(String username) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public int getUserId(String username) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    protected void doSetUserAttributeWithID(String userID, String attributeName, String value, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    protected void doSetUserAttributesWithID(String userID, Map<String, String> processedClaimAttributes, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    protected void doSetUserAttributesWithID(String userID, Map<String, List<String>> claimAttributesToAdd, Map<String, List<String>> claimAttributesToDelete, Map<String, List<String>> claimAttributesToReplace, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doDeleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doDeleteUserClaimValueWithID(String userID, String claimURI, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doDeleteUserClaimValuesWithID(String userID, String[] claims, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doDeleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public User doAddUserWithID(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doDeleteUser(String userName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doDeleteUserWithID(String userID) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doSetUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doSetUserClaimValues(String userName, Map<String, List<String>> multiValuedClaimsToAdd, Map<String, List<String>> multiValuedClaimsToDelete, Map<String, List<String>> claimsExcludingMultiValuedClaims, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doUpdateCredentialWithID(String userID, Object newCredential, Object oldCredential) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doUpdateCredentialByAdminWithID(String userID, Object newCredential) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doUpdateRoleListOfUserWithID(String userID, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doUpdateUserListOfRoleWithID(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    private String escapeSpecialCharactersForFilterWithStarAsRegex(String dnPartial) {
        boolean replaceEscapeCharacters = true;
        String replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin");
        if (replaceEscapeCharactersAtUserLoginString != null) {
            replaceEscapeCharacters = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replace escape characters configured to: " + replaceEscapeCharactersAtUserLoginString));
            }
        }
        if (replaceEscapeCharacters) {
            StringBuilder sb = new StringBuilder();
            block6: for (int i = 0; i < dnPartial.length(); ++i) {
                char currentChar = dnPartial.charAt(i);
                switch (currentChar) {
                    case '\\': {
                        if (dnPartial.charAt(i + 1) == '*') {
                            sb.append("\\2a");
                            ++i;
                            continue block6;
                        }
                        sb.append("\\5c");
                        continue block6;
                    }
                    case '(': {
                        sb.append("\\28");
                        continue block6;
                    }
                    case ')': {
                        sb.append("\\29");
                        continue block6;
                    }
                    case '\u0000': {
                        sb.append("\\00");
                        continue block6;
                    }
                    default: {
                        sb.append(currentChar);
                    }
                }
            }
            return sb.toString();
        }
        return dnPartial;
    }

    private String escapeSpecialCharactersForFilter(String dnPartial) {
        boolean replaceEscapeCharacters = true;
        dnPartial.replace("\\*", "*");
        String replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin");
        if (replaceEscapeCharactersAtUserLoginString != null) {
            replaceEscapeCharacters = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replace escape characters configured to: " + replaceEscapeCharactersAtUserLoginString));
            }
        }
        if (replaceEscapeCharacters) {
            StringBuilder sb = new StringBuilder();
            block7: for (int i = 0; i < dnPartial.length(); ++i) {
                char currentChar = dnPartial.charAt(i);
                switch (currentChar) {
                    case '\\': {
                        sb.append("\\5c");
                        continue block7;
                    }
                    case '*': {
                        sb.append("\\2a");
                        continue block7;
                    }
                    case '(': {
                        sb.append("\\28");
                        continue block7;
                    }
                    case ')': {
                        sb.append("\\29");
                        continue block7;
                    }
                    case '\u0000': {
                        sb.append("\\00");
                        continue block7;
                    }
                    default: {
                        sb.append(currentChar);
                    }
                }
            }
            return sb.toString();
        }
        return dnPartial;
    }

    private String escapeSpecialCharactersForDN(String text) {
        boolean replaceEscapeCharacters = true;
        text.replace("\\*", "*");
        String replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin");
        if (replaceEscapeCharactersAtUserLoginString != null) {
            replaceEscapeCharacters = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replace escape characters configured to: " + replaceEscapeCharactersAtUserLoginString));
            }
        }
        if (replaceEscapeCharacters) {
            StringBuilder sb = new StringBuilder();
            if (text.length() > 0 && (text.charAt(0) == ' ' || text.charAt(0) == '#')) {
                sb.append('\\');
            }
            block10: for (int i = 0; i < text.length(); ++i) {
                char currentChar = text.charAt(i);
                switch (currentChar) {
                    case '\\': {
                        sb.append("\\\\");
                        continue block10;
                    }
                    case ',': {
                        sb.append("\\,");
                        continue block10;
                    }
                    case '+': {
                        sb.append("\\+");
                        continue block10;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        continue block10;
                    }
                    case '<': {
                        sb.append("\\<");
                        continue block10;
                    }
                    case '>': {
                        sb.append("\\>");
                        continue block10;
                    }
                    case ';': {
                        sb.append("\\;");
                        continue block10;
                    }
                    case '*': {
                        sb.append("\\2a");
                        continue block10;
                    }
                    default: {
                        sb.append(currentChar);
                    }
                }
            }
            if (text.length() > 1 && text.charAt(text.length() - 1) == ' ') {
                sb.insert(sb.length() - 1, '\\');
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("value after escaping special characters in " + text + " : " + sb.toString()));
            }
            return sb.toString();
        }
        return text;
    }

    @Override
    protected Name escapeDNForSearch(String dn) throws InvalidNameException {
        return new CompositeName().add(dn);
    }

    @Override
    public Properties getDefaultUserStoreProperties() {
        Properties properties = new Properties();
        properties.setMandatoryProperties((Property[])Stream.concat(ReadOnlyLDAPUserStoreConstants.ROLDAP_USERSTORE_PROPERTIES.stream(), ReadOnlyLDAPUserStoreConstants.UNIQUE_ID_ROLDAP_USERSTORE_PROPERTIES.stream()).toArray(Property[]::new));
        properties.setOptionalProperties(ReadOnlyLDAPUserStoreConstants.OPTIONAL_ROLDAP_USERSTORE_PROPERTIES.toArray(new Property[0]));
        properties.setAdvancedProperties(UNIQUE_ID_RO_LDAP_UM_ADVANCED_PROPERTIES.toArray(new Property[0]));
        return properties;
    }

    private static void setAdvancedProperties() {
        UNIQUE_ID_RO_LDAP_UM_ADVANCED_PROPERTIES.clear();
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("PasswordHashMethod", "Password Hashing Algorithm", "PLAIN_TEXT", "Password Hash method to use when storing user entries");
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty(MULTI_ATTRIBUTE_SEPARATOR, "Multiple Attribute Separator", ",", MULTI_ATTRIBUTE_SEPARATOR_DESCRIPTION);
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("MaxUserNameListLength", "Maximum User List Length", "100", "Maximum number of users retrieved at once");
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("MaxRoleNameListLength", "Maximum Role List Length", "100", "Maximum number of groups retrieved at once");
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("UserRolesCacheEnabled", "Enable User Role Cache", "true", "This is to indicate whether to cache the group list of a user");
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("ConnectionPoolingEnabled", "Enable LDAP Connection Pooling", "false", "Set this property to enable LDAP connection pooling.");
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty(LDAPConnectionTimeout, LDAPConnectionTimeoutDescription, "5000", LDAPConnectionTimeoutDescription);
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty(readTimeout, "LDAP Read Timeout", "5000", readTimeoutDescription);
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty(RETRY_ATTEMPTS, "Retry Attempts", "0", "Number of retries for authentication in case ldap read timed out.");
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("CountRetrieverClass", "Count Implementation", "", "Name of the class that implements the count functionality");
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("java.naming.ldap.attributes.binary", "LDAP binary attributes", " ", LDAPBinaryAttributesDescription);
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("ClaimOperationsSupported", "Claim Operations Supported", "false", "Whether the userstore supports claim read and write");
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty(MEMBERSHIP_ATTRIBUTE_RANGE, MEMBERSHIP_ATTRIBUTE_RANGE_DISPLAY_NAME, String.valueOf(0), "Number of maximum users of role returned by the LDAP");
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("UserCacheExpiryMilliseconds", USER_CACHE_EXPIRY_TIME_ATTRIBUTE_NAME, "", USER_CACHE_EXPIRY_TIME_ATTRIBUTE_DESCRIPTION);
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("UserDNCacheEnabled", USER_DN_CACHE_ENABLED_ATTRIBUTE_NAME, "true", USER_DN_CACHE_ENABLED_ATTRIBUTE_DESCRIPTION);
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("StartTLSEnabled", "Enable StartTLS", "false", "Enable secure connection by using StartTLS extended operation in LDAP");
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("ConnectionRetryDelay", "Connection Retry Delay", String.valueOf(120000), "Specifies waiting time in milliseconds inorder to establish the connection after couple of failure attempts.");
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("ImmutableAttributes", "Immutable Attributes", " ", "Comma-separated list of user store maintained immutable attributes");
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperty("TimestampAttributes", "Timestamp Attributes", " ", "Comma-separated list of user store attributes having the data type of Timestamp and may require a conversion when reading from/writing to user store");
    }

    private static void setAdvancedProperty(String name, String displayName, String value, String description) {
        Property property = new Property(name, value, displayName + "#" + description, null);
        UNIQUE_ID_RO_LDAP_UM_ADVANCED_PROPERTIES.add(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initUserCache() throws UserStoreException {
        RealmService realmService;
        if (!this.userDnCacheEnabled) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User DN cache is disabled in configuration on UserStore having SearchBase: " + this.userSearchBase));
            }
            return;
        }
        boolean isUserDnCacheCustomExpiryValuePresent = false;
        if (StringUtils.isNotEmpty((String)this.cacheExpiryTimeAttribute)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache expiry time : " + this.cacheExpiryTimeAttribute + " configured for the user DN cache having search base: " + this.userSearchBase));
            }
            try {
                this.userDnCacheExpiryTime = Long.parseLong(this.cacheExpiryTimeAttribute);
                isUserDnCacheCustomExpiryValuePresent = true;
            }
            catch (NumberFormatException nfe) {
                log.error((Object)("Could not convert the cache expiry time to Number (long) : " + this.cacheExpiryTimeAttribute + " . Will default to system wide expiry settings."), (Throwable)nfe);
            }
        }
        if ((realmService = UserStoreMgtDSComponent.getRealmService()) != null && realmService.getTenantManager() != null) {
            try {
                this.tenantDomain = realmService.getTenantManager().getDomain(this.tenantId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Tenant domain : " + this.tenantDomain + " found for the tenant ID : " + this.tenantId));
                }
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException("Could not get the tenant domain for tenant id : " + this.tenantId, e);
            }
        }
        if (this.tenantDomain == null && this.tenantId == -1234) {
            this.tenantDomain = "carbon.super";
        }
        if (this.tenantDomain == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not find a tenant domain for the tenant ID : " + this.tenantId + ". Not initializing the User DN cache."));
            }
            return;
        }
        try {
            this.startTenantFlow();
            this.userDnCacheName = USER_CACHE_NAME_PREFIX + this.hashCode();
            this.cacheManager = Caching.getCacheManagerFactory().getCacheManager(USER_CACHE_MANAGER);
            this.cacheManager.removeCache(this.userDnCacheName);
            if (isUserDnCacheCustomExpiryValuePresent) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using cache expiry time : " + this.userDnCacheExpiryTime + " configured for the user DN cache having search base: " + this.userSearchBase));
                }
                this.userDnCacheBuilder = this.cacheManager.createCacheBuilder(this.userDnCacheName);
                this.userDnCacheBuilder.setExpiry(CacheConfiguration.ExpiryType.ACCESSED, new CacheConfiguration.Duration(TimeUnit.MILLISECONDS, this.userDnCacheExpiryTime)).setExpiry(CacheConfiguration.ExpiryType.MODIFIED, new CacheConfiguration.Duration(TimeUnit.MILLISECONDS, this.userDnCacheExpiryTime)).setStoreByValue(false);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putToUserCache(String name, LdapName value) {
        try {
            this.startTenantFlow();
            Cache<String, LdapName> userDnCache = this.createOrGetUserDnCache();
            if (userDnCache == null) {
                return;
            }
            userDnCache.put((Object)name, (Object)value);
        }
        catch (IllegalStateException e) {
            log.error((Object)("Error occurred while putting User DN to the cache having search base : " + this.userSearchBase), (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LdapName getFromUserCache(String userName) {
        try {
            this.startTenantFlow();
            Cache<String, LdapName> userDnCache = this.createOrGetUserDnCache();
            if (userDnCache == null) {
                LdapName ldapName = null;
                return ldapName;
            }
            LdapName ldapName = (LdapName)userDnCache.get((Object)userName);
            return ldapName;
        }
        catch (IllegalStateException e) {
            log.error((Object)("Error occurred while getting User DN from cache having search base : " + this.userSearchBase), (Throwable)e);
            LdapName ldapName = null;
            return ldapName;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeFromUserCache(String userName) {
        try {
            this.startTenantFlow();
            Cache<String, LdapName> userDnCache = this.createOrGetUserDnCache();
            if (userDnCache == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = userDnCache.remove((Object)userName);
            return bl;
        }
        catch (IllegalStateException e) {
            log.error((Object)("Error occurred while removing User DN from cache having search base : " + this.userSearchBase), (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void startTenantFlow() {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantId(this.tenantId);
        carbonContext.setTenantDomain(this.tenantDomain);
    }

    private Cache<String, LdapName> createOrGetUserDnCache() {
        Cache userDnCache;
        if (this.cacheManager == null || !this.userDnCacheEnabled) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not using the cache on UserDN. cacheManager: " + this.cacheManager + " , Enabled : " + this.userDnCacheEnabled));
            }
            return null;
        }
        if (this.userDnCacheBuilder != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using cache bulder to get the cache, for UserSearchBase: " + this.userSearchBase));
            }
            userDnCache = this.userDnCacheBuilder.build();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using default configurations for the user DN cache, having search base : " + this.userSearchBase));
            }
            userDnCache = this.cacheManager.getCache(this.userDnCacheName);
        }
        return userDnCache;
    }

    @Override
    protected void finalize() throws Throwable {
        if (this.cacheManager != null && this.userDnCacheName != null) {
            try {
                this.startTenantFlow();
                this.cacheManager.removeCache(this.userDnCacheName);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        super.finalize();
    }

    @Override
    public boolean isUniqueUserIdEnabled() {
        return true;
    }

    @Override
    protected void processAttributesAfterRetrievalWithID(String userID, Map<String, String> userStorePropertyValues, String profileName) {
        String timestampAttributesProperty = Optional.ofNullable(this.realmConfig.getUserStoreProperty("TimestampAttributes")).orElse("");
        Object[] timestampAttributes = StringUtils.split((String)timestampAttributesProperty, (String)",");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unique read only timestamp attributes: " + Arrays.toString(timestampAttributes)));
        }
        if (ArrayUtils.isNotEmpty((Object[])timestampAttributes)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieved user store properties before type conversions: " + userStorePropertyValues));
            }
            Map convertedTimestampAttributeValues = Arrays.stream(timestampAttributes).filter(attribute -> userStorePropertyValues.get(attribute) != null).collect(Collectors.toMap(Function.identity(), attribute -> this.convertDateFormatFromLDAP((String)userStorePropertyValues.get(attribute))));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converted timestamp attribute values: " + convertedTimestampAttributeValues));
            }
            userStorePropertyValues.putAll(convertedTimestampAttributeValues);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieved user store properties after type conversions: " + userStorePropertyValues));
            }
        }
    }

    private List<User> performLDAPSearch(LdapContext ldapContext, LDAPSearchSpecification ldapSearchSpecification, int pageSize, int offset, List<ExpressionCondition> expressionConditions) throws UserStoreException {
        List<User> users;
        block16: {
            int pageIndex = -1;
            boolean isGroupFiltering = ldapSearchSpecification.isGroupFiltering();
            boolean isUsernameFiltering = ldapSearchSpecification.isUsernameFiltering();
            boolean isClaimFiltering = ldapSearchSpecification.isClaimFiltering();
            boolean isMemberShipPropertyFound = ldapSearchSpecification.isMemberShipPropertyFound();
            String searchBases = ldapSearchSpecification.getSearchBases();
            String[] searchBaseArray = searchBases.split("#");
            String searchFilter = ldapSearchSpecification.getSearchFilterQuery();
            SearchControls searchControls = ldapSearchSpecification.getSearchControls();
            List<String> returnedAttributes = Arrays.asList(searchControls.getReturningAttributes());
            NamingEnumeration<SearchResult> answer = null;
            users = new ArrayList<User>();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Searching for user(s) with SearchFilter: %s and page size %d", searchFilter, pageSize));
            }
            try {
                block8: for (String searchBase : searchBaseArray) {
                    byte[] cookie;
                    do {
                        ArrayList<User> tempUsersList = new ArrayList();
                        answer = ldapContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchControls);
                        if (answer.hasMore()) {
                            tempUsersList = this.getUserListFromSearch(isGroupFiltering, returnedAttributes, answer, this.isSingleAttributeFilterOperation(expressionConditions));
                            ++pageIndex;
                        }
                        if (CollectionUtils.isNotEmpty(tempUsersList)) {
                            if (isMemberShipPropertyFound) {
                                users = this.membershipGroupFilterPostProcessing(isUsernameFiltering, isClaimFiltering, expressionConditions, tempUsersList);
                                continue block8;
                            }
                            this.generatePaginatedUserList(pageIndex, offset, pageSize, tempUsersList, users);
                            int needMore = pageSize - users.size();
                            if (needMore == 0) continue block8;
                        }
                        cookie = UniqueIDReadOnlyLDAPUserStoreManager.parseControls(ldapContext.getResponseControls());
                        String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
                        ldapContext.setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookie, true), new SortControl(userNameAttribute, false)});
                    } while (cookie != null && cookie.length != 0);
                }
            }
            catch (PartialResultException e) {
                if (this.isIgnorePartialResultException()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Error occurred while searching for user(s) for filter: %s", searchFilter));
                    }
                    break block16;
                }
                log.error((Object)String.format("Error occurred while searching for user(s) for filter: %s", searchFilter));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (NamingException e) {
                log.error((Object)String.format("Error occurred while searching for user(s) for filter: %s, %s", searchFilter, e.getMessage()));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (IOException e) {
                log.error((Object)String.format("Error occurred while doing paginated search, %s", e.getMessage()));
                throw new UserStoreException(e.getMessage(), e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(answer);
            }
        }
        return users;
    }

    private List<User> getUserListFromSearch(boolean isGroupFiltering, List<String> returnedAttributes, NamingEnumeration<SearchResult> answer, boolean isSingleAttributeFilter) throws UserStoreException {
        List<User> tempUsersList = isGroupFiltering ? (returnedAttributes.contains(this.realmConfig.getUserStoreProperty("MembershipAttribute")) ? this.getUserListFromMembershipGroupFilterResult(answer, returnedAttributes, isSingleAttributeFilter) : this.getUserListFromMemberOfGroupFilterResult(answer)) : this.getUserListFromNonGroupFilterResult(answer, returnedAttributes);
        return tempUsersList;
    }

    private List<User> getUserListFromNonGroupFilterResult(NamingEnumeration<SearchResult> answer, List<String> returnedAttributes) throws UserStoreException {
        ArrayList<User> finalUserList = new ArrayList<User>();
        String userAttributeSeparator = ",";
        NamingEnumeration<?> attrs = null;
        try {
            while (answer.hasMoreElements()) {
                Attribute attribute;
                SearchResult searchResult = answer.next();
                Attributes attributes = searchResult.getAttributes();
                if (attributes == null || (attribute = attributes.get(returnedAttributes.get(0))) == null) continue;
                StringBuffer attrBuffer = new StringBuffer();
                attrs = attribute.getAll();
                while (attrs.hasMore()) {
                    String attr = (String)attrs.next();
                    if (!StringUtils.isNotEmpty((String)attr.trim())) continue;
                    String attrSeparator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
                    if (StringUtils.isNotEmpty((String)attrSeparator.trim())) {
                        userAttributeSeparator = attrSeparator;
                    }
                    attrBuffer.append(attr + userAttributeSeparator);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(returnedAttributes.get(0) + " : " + attr));
                }
                String userNamePropertyValue = attrBuffer.toString();
                Attribute serviceNameObject = attributes.get(returnedAttributes.get(1));
                String serviceNameAttributeValue = null;
                if (serviceNameObject != null) {
                    serviceNameAttributeValue = (String)serviceNameObject.get();
                }
                if (userNamePropertyValue.trim().length() <= userAttributeSeparator.length() || "Service".equals(serviceNameAttributeValue)) continue;
                userNamePropertyValue = userNamePropertyValue.substring(0, userNamePropertyValue.length() - userAttributeSeparator.length());
                Attribute userIdObject = attributes.get(this.realmConfig.getUserStoreProperty("UserIDAttribute"));
                String userIdAttributeValue = null;
                if (userIdObject != null) {
                    userIdAttributeValue = this.resolveLdapAttributeValue(userIdObject.get());
                }
                String domain = this.getRealmConfiguration().getUserStoreProperty("DomainName");
                User user = this.getUser(userIdAttributeValue, userNamePropertyValue);
                user.setDisplayName(null);
                user.setUserStoreDomain(domain);
                user.setTenantDomain(this.getTenantDomain(this.tenantId));
                finalUserList.add(user);
            }
        }
        catch (NamingException e) {
            log.error((Object)String.format("Error occurred while getting user list from non group filter %s", e.getMessage()));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(attrs);
        }
        return finalUserList;
    }

    private List<User> getUserListFromMembershipGroupFilterResult(NamingEnumeration<SearchResult> answer, List<String> returnedAttributes, boolean isSingleAttributeFilter) throws UserStoreException {
        ArrayList<String> userListFromSearch = new ArrayList<String>();
        int count = 0;
        NamingEnumeration<?> attrs = null;
        try {
            while (answer.hasMoreElements()) {
                ++count;
                ArrayList<String> tempUserList = new ArrayList<String>();
                SearchResult searchResult = answer.next();
                Attributes attributes = searchResult.getAttributes();
                if (attributes == null) continue;
                NamingEnumeration<? extends Attribute> attributeEntry = attributes.getAll();
                while (attributeEntry.hasMore()) {
                    Attribute valAttribute = attributeEntry.next();
                    if (!this.isAttributeEqualsProperty(returnedAttributes.get(0), valAttribute.getID())) continue;
                    NamingEnumeration<?> values = valAttribute.getAll();
                    while (values.hasMore()) {
                        tempUserList.add(values.next().toString());
                    }
                }
                if (isSingleAttributeFilter) {
                    userListFromSearch.addAll(tempUserList);
                    continue;
                }
                if (count == 1) {
                    userListFromSearch.addAll(tempUserList);
                    continue;
                }
                userListFromSearch.retainAll(tempUserList);
            }
        }
        catch (NamingException e) {
            log.error((Object)String.format("Error occurred while getting user list from group filter %s", e.getMessage()));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(attrs);
        }
        List<User> finalUserList = this.getUserListFromDNList(userListFromSearch);
        return finalUserList;
    }

    private List<User> getUserListFromMemberOfGroupFilterResult(NamingEnumeration<SearchResult> answer) throws UserStoreException {
        ArrayList<User> finalUserList = new ArrayList<User>();
        try {
            while (answer.hasMoreElements()) {
                SearchResult searchResult = answer.next();
                if (searchResult.getAttributes() == null) continue;
                Attribute userName = searchResult.getAttributes().get(this.realmConfig.getUserStoreProperty("UserNameAttribute"));
                Attribute userID = searchResult.getAttributes().get(this.realmConfig.getUserStoreProperty("UserIDAttribute"));
                String serviceNameAttribute = "sn";
                Attribute attrSurname = searchResult.getAttributes().get(serviceNameAttribute);
                if (attrSurname != null) {
                    String serviceName;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(serviceNameAttribute + " : " + attrSurname));
                    }
                    if ((serviceName = (String)attrSurname.get()) != null && serviceName.equals("Service")) continue;
                }
                String name = null;
                String displayName = null;
                String id = null;
                String domain = null;
                if (userName != null) {
                    name = this.resolveLdapAttributeValue(userName.get());
                    domain = this.getRealmConfiguration().getUserStoreProperty("DomainName");
                }
                if (userID != null) {
                    id = this.resolveLdapAttributeValue(userID.get());
                }
                User user = this.getUser(id, name);
                user.setDisplayName(displayName);
                user.setUserStoreDomain(domain);
                user.setTenantDomain(this.getTenantDomain(this.tenantId));
                finalUserList.add(user);
            }
        }
        catch (NamingException e) {
            log.error((Object)String.format("Error occurred while getting user list from non group filter %s", e.getMessage()));
            throw new UserStoreException(e.getMessage(), e);
        }
        return finalUserList;
    }

    private List<User> getUserListFromDNList(List<String> userListFromSearch) throws UserStoreException {
        ArrayList<User> usersList = new ArrayList<User>();
        DirContext dirContext = this.connectionSource.getContext();
        String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
        String userIdProperty = this.realmConfig.getUserStoreProperty("UserIDAttribute");
        String[] requiredAttributes = new String[]{userNameProperty, displayNameAttribute, userIdProperty};
        for (String userFromSearch : userListFromSearch) {
            try {
                String displayName = null;
                String userName = null;
                String userId = null;
                Attributes userAttributes = dirContext.getAttributes(this.escapeDNForSearch(userFromSearch), requiredAttributes);
                if (userAttributes != null) {
                    Attribute userIdAttribute;
                    Attribute displayAttribute;
                    Attribute userNameAttribute = userAttributes.get(userNameProperty);
                    if (userNameAttribute != null) {
                        userName = (String)userNameAttribute.get();
                    }
                    if (StringUtils.isNotEmpty((String)displayNameAttribute) && (displayAttribute = userAttributes.get(displayNameAttribute)) != null) {
                        displayName = (String)displayAttribute.get();
                    }
                    if ((userIdAttribute = userAttributes.get(userIdProperty)) != null) {
                        userId = this.resolveLdapAttributeValue(userIdAttribute.get());
                    }
                }
                String domainName = this.realmConfig.getUserStoreProperty("DomainName");
                if (userName != null) {
                    User user = this.getUser(userId, userName);
                    user.setDisplayName(displayName);
                    user.setUserStoreDomain(domainName);
                    user.setTenantDomain(this.getTenantDomain(this.tenantId));
                    usersList.add(user);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("User %s doesn't have the user name property %s", userFromSearch, userNameProperty));
            }
            catch (NamingException e) {
                log.error((Object)String.format("Error in reading user information in the user store for the user %s, %s", userFromSearch, e.getMessage()));
                throw new UserStoreException(e.getMessage(), e);
            }
        }
        return usersList;
    }

    protected void generatePaginatedUserList(int pageIndex, int offset, int pageSize, List<User> tempUserList, List<User> users) {
        if (pageIndex == offset / pageSize) {
            int startPosition = offset % pageSize;
            if (startPosition < tempUserList.size() - 1) {
                users.addAll(tempUserList.subList(startPosition, tempUserList.size()));
            } else if (startPosition == tempUserList.size() - 1) {
                users.add(tempUserList.get(tempUserList.size() - 1));
            }
        } else if (pageIndex == offset / pageSize + 1) {
            int needMore = pageSize - users.size();
            if (tempUserList.size() >= needMore) {
                users.addAll(tempUserList.subList(0, needMore));
            } else {
                users.addAll(tempUserList);
            }
        }
    }

    private List<User> membershipGroupFilterPostProcessing(boolean isUsernameFiltering, boolean isClaimFiltering, List<ExpressionCondition> expressionConditions, List<User> tempUserList) throws UserStoreException {
        if (isUsernameFiltering) {
            tempUserList = this.getMatchUsersFromMemberList(expressionConditions, tempUserList);
        }
        List<User> users = isClaimFiltering ? this.getUserListFromClaimFiltering(expressionConditions, tempUserList) : tempUserList;
        return users;
    }

    private List<User> getMatchUsersFromMemberList(List<ExpressionCondition> expressionConditions, List<User> userList) {
        ArrayList<User> derivedUserList = new ArrayList<User>();
        for (ExpressionCondition expressionCondition : expressionConditions) {
            if (!ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) continue;
            derivedUserList.addAll(this.getMatchUsers(expressionCondition, userList));
        }
        LinkedHashSet<User> linkedHashSet = new LinkedHashSet<User>();
        linkedHashSet.addAll(derivedUserList);
        derivedUserList.clear();
        derivedUserList.addAll(linkedHashSet);
        return derivedUserList;
    }

    private List<User> getMatchUsers(ExpressionCondition expressionCondition, List<User> users) {
        ArrayList<User> newUsersList = new ArrayList<User>();
        for (User user : users) {
            if (ExpressionOperation.SW.toString().equals(expressionCondition.getOperation()) && user.getUsername().startsWith(expressionCondition.getAttributeValue()) && !newUsersList.contains(user)) {
                newUsersList.add(user);
                continue;
            }
            if (ExpressionOperation.EQ.toString().equals(expressionCondition.getOperation()) && user.getUsername().equals(expressionCondition.getAttributeValue()) && !newUsersList.contains(user)) {
                newUsersList.add(user);
                continue;
            }
            if (ExpressionOperation.CO.toString().equals(expressionCondition.getOperation()) && user.getUsername().contains(expressionCondition.getAttributeValue()) && !newUsersList.contains(user)) {
                newUsersList.add(user);
                continue;
            }
            if (!ExpressionOperation.EW.toString().equals(expressionCondition.getOperation()) || !user.getUsername().endsWith(expressionCondition.getAttributeValue()) || newUsersList.contains(user)) continue;
            newUsersList.add(user);
        }
        return newUsersList;
    }

    private List<User> getUserListFromClaimFiltering(List<ExpressionCondition> expressionConditions, List<User> tempUserList) throws UserStoreException {
        List<Object> claimSearchUserList = new ArrayList();
        List<ExpressionCondition> derivedConditionList = expressionConditions;
        Iterator<ExpressionCondition> iterator = derivedConditionList.iterator();
        while (iterator.hasNext()) {
            ExpressionCondition expressionCondition = iterator.next();
            if (!ExpressionAttribute.ROLE.toString().equals(expressionCondition.getAttributeName())) continue;
            iterator.remove();
        }
        LDAPSearchSpecification claimSearch = new LDAPSearchSpecification(this.realmConfig, derivedConditionList);
        SearchControls claimSearchControls = claimSearch.getSearchControls();
        DirContext claimSearchDirContext = this.connectionSource.getContext();
        NamingEnumeration<SearchResult> tempAnswer = null;
        try {
            tempAnswer = claimSearchDirContext.search(claimSearch.getSearchBases(), claimSearch.getSearchFilterQuery(), claimSearchControls);
            if (tempAnswer.hasMore()) {
                claimSearchUserList = this.getUserListFromNonGroupFilterResult(tempAnswer, Arrays.asList(claimSearchControls.getReturningAttributes()));
            }
        }
        catch (NamingException e) {
            log.error((Object)String.format("Error occurred while doing claim filtering for user(s) with filter: %s, %s", claimSearch.getSearchFilterQuery(), e.getMessage()));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeContext(claimSearchDirContext);
            JNDIUtil.closeNamingEnumeration(tempAnswer);
        }
        tempUserList.retainAll(claimSearchUserList);
        return tempUserList;
    }

    static {
        UniqueIDReadOnlyLDAPUserStoreManager.setAdvancedProperties();
    }
}

