/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.naming.AuthenticationException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.Rdn;
import javax.naming.ldap.SortControl;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.Properties;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.common.PaginatedSearchResult;
import org.wso2.carbon.user.core.common.RoleContext;
import org.wso2.carbon.user.core.internal.UserStoreMgtDSComponent;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreManager;
import org.wso2.carbon.user.core.ldap.LDAPConnectionContext;
import org.wso2.carbon.user.core.ldap.LDAPRoleContext;
import org.wso2.carbon.user.core.ldap.LDAPSearchSpecification;
import org.wso2.carbon.user.core.ldap.ReadOnlyLDAPUserStoreConstants;
import org.wso2.carbon.user.core.model.Condition;
import org.wso2.carbon.user.core.model.ExpressionAttribute;
import org.wso2.carbon.user.core.model.ExpressionCondition;
import org.wso2.carbon.user.core.model.ExpressionOperation;
import org.wso2.carbon.user.core.model.OperationalCondition;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.JNDIUtil;
import org.wso2.carbon.user.core.util.LDAPUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.Secret;
import org.wso2.carbon.utils.UnsupportedSecretTypeException;

public class ReadOnlyLDAPUserStoreManager
extends AbstractUserStoreManager {
    private static final String MULTI_ATTRIBUTE_SEPARATOR_DESCRIPTION = "This is the separator for multiple claim values";
    public static final String MEMBER_UID = "memberUid";
    private static final String OBJECT_GUID = "objectGUID";
    private static final String OBJECT_GUID_REGEX = "^[0-9a-f]{8}-[0-9a-f]{4}-[0-5][0-9a-f]{3}-[089ab][0-9a-f]{3}-[0-9a-f]{12}$";
    private static Pattern OBJECT_GUID_PATTERN;
    protected static final String MEMBERSHIP_ATTRIBUTE_RANGE = "MembershipAttributeRange";
    protected static final String MEMBERSHIP_ATTRIBUTE_RANGE_DISPLAY_NAME = "Membership Attribute Range";
    private static final String USER_CACHE_NAME_PREFIX = "$__local__$.UserCache-";
    private static final String USER_CACHE_MANAGER = "UserCacheManager";
    private static Log log;
    protected static final int MAX_USER_CACHE = 200;
    private static final String PROPERTY_REFERRAL_IGNORE = "ignore";
    private static final String MULTI_ATTRIBUTE_SEPARATOR = "MultiAttributeSeparator";
    private static final ArrayList<Property> RO_LDAP_UM_ADVANCED_PROPERTIES;
    private static final String readTimeoutDescription = "Configure this to define the read timeout for LDAP operations";
    private static final String LDAPConnectionTimeout = "LDAPConnectionTimeout";
    private static final String LDAPConnectionTimeoutDescription = "LDAP Connection Timeout";
    private static final String readTimeout = "ReadTimeout";
    private static final String LDAPBinaryAttributesDescription = "Configure this to define the LDAP binary attributes seperated by a space. Ex:mpegVideo mySpecialKey";
    private static final String RETRY_ATTEMPTS = "RetryAttempts";
    private static final String GENARALIZE_DATE_TIME_FORMAT = "uuuuMMddHHmmss[,S][.S]X";
    protected static final String USER_CACHE_EXPIRY_TIME_ATTRIBUTE_NAME = "User Cache Expiry milliseconds";
    protected static final String USER_DN_CACHE_ENABLED_ATTRIBUTE_NAME = "Enable User DN Cache";
    protected static final String USER_CACHE_EXPIRY_TIME_ATTRIBUTE_DESCRIPTION = "Configure the user cache expiry in milliseconds. Values  {0: expire immediately, -1: never expire, '': i.e. empty, system default}.";
    protected static final String USER_DN_CACHE_ENABLED_ATTRIBUTE_DESCRIPTION = "Enables the user cache. Default true, Unless set to false. Empty value is interpreted as true.";
    private static final String USE_ANONYMOUS_BIND = "AnonymousBind";
    protected static final int MEMBERSHIP_ATTRIBUTE_RANGE_VALUE = 0;
    private static final int MAX_ITEM_LIMIT_UNLIMITED = -1;
    private static Log logger;
    private String cacheExpiryTimeAttribute = "";
    private long userDnCacheExpiryTime = 0L;
    private CacheBuilder userDnCacheBuilder = null;
    private String userDnCacheName;
    private boolean userDnCacheEnabled = true;
    protected CacheManager cacheManager;
    protected String tenantDomain;
    @Deprecated
    Map<String, Object> userCache = new ConcurrentHashMap<String, Object>(200);
    protected LDAPConnectionContext connectionSource = null;
    protected String userSearchBase = null;
    protected String groupSearchBase = null;
    protected boolean emptyRolesAllowed = false;

    public ReadOnlyLDAPUserStoreManager() {
    }

    public ReadOnlyLDAPUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        this(realmConfig, properties, claimManager, profileManager, realm, tenantId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadOnlyLDAPUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId, boolean skipInitData) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initialization Started " + System.currentTimeMillis()));
        }
        this.realmConfig = realmConfig;
        this.claimManager = claimManager;
        this.userRealm = realm;
        this.tenantId = tenantId;
        this.checkRequiredUserStoreConfigurations();
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
        }
        if (this.dataSource == null) {
            throw new UserStoreException("Data Source is null");
        }
        properties.put("um.datasource", this.dataSource);
        this.connectionSource = new LDAPConnectionContext(realmConfig);
        DirContext dirContext = null;
        try {
            dirContext = this.connectionSource.getContext();
            if (this.isReadOnly()) {
                log.info((Object)"LDAP connection created successfully in read-only mode");
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot create connection to LDAP server. Connection URL: " + realmConfig.getUserStoreProperty("ConnectionURL") + " Error message: " + e.getMessage()));
        }
        finally {
            JNDIUtil.closeContext(dirContext);
        }
        this.userRealm = realm;
        this.persistDomain();
        this.doInitialSetup();
        if (realmConfig.isPrimary()) {
            this.addInitialAdminData(Boolean.parseBoolean(realmConfig.getAddAdmin()), !this.isInitSetupDone());
        }
        this.initUserRolesCache();
        this.initUserCache();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initialization Ended " + System.currentTimeMillis()));
        }
    }

    public ReadOnlyLDAPUserStoreManager(RealmConfiguration realmConfig, ClaimManager claimManager, ProfileConfigurationManager profileManager) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started " + System.currentTimeMillis()));
        }
        this.realmConfig = realmConfig;
        this.claimManager = claimManager;
        this.checkRequiredUserStoreConfigurations();
        this.connectionSource = new LDAPConnectionContext(realmConfig);
    }

    protected void checkRequiredUserStoreConfigurations() throws UserStoreException {
        log.debug((Object)"Checking LDAP configurations ");
        String connectionURL = this.realmConfig.getUserStoreProperty("ConnectionURL");
        String DNSURL = this.realmConfig.getUserStoreProperty("URLOfDNS");
        String AnonymousBind = this.realmConfig.getUserStoreProperty(USE_ANONYMOUS_BIND);
        if (!(connectionURL != null && connectionURL.trim().length() != 0 || DNSURL != null && DNSURL.trim().length() != 0)) {
            throw new UserStoreException("Required ConnectionURL property is not set at the LDAP configurations");
        }
        if (!Boolean.parseBoolean(AnonymousBind)) {
            String connectionName = this.realmConfig.getUserStoreProperty("ConnectionName");
            if (StringUtils.isEmpty((String)connectionName)) {
                throw new UserStoreException("Required ConnectionNme property is not set at the LDAP configurations");
            }
            String connectionPassword = this.realmConfig.getUserStoreProperty("ConnectionPassword");
            if (StringUtils.isEmpty((String)connectionPassword)) {
                throw new UserStoreException("Required ConnectionPassword property is not set at the LDAP configurations");
            }
        }
        this.userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        if (this.userSearchBase == null || this.userSearchBase.trim().length() == 0) {
            throw new UserStoreException("Required UserSearchBase property is not set at the LDAP configurations");
        }
        String usernameListFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
        if (usernameListFilter == null || usernameListFilter.trim().length() == 0) {
            throw new UserStoreException("Required UserNameListFilter property is not set at the LDAP configurations");
        }
        String usernameSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        if (usernameSearchFilter == null || usernameSearchFilter.trim().length() == 0) {
            throw new UserStoreException("Required UserNameSearchFilter property is not set at the LDAP configurations");
        }
        String usernameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        if (usernameAttribute == null || usernameAttribute.trim().length() == 0) {
            throw new UserStoreException("Required UserNameAttribute property is not set at the LDAP configurations");
        }
        this.writeGroupsEnabled = false;
        if (this.realmConfig.getUserStoreProperty("ReadGroups") != null) {
            this.readGroupsEnabled = Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("ReadGroups"));
        }
        if (log.isDebugEnabled()) {
            if (this.readGroupsEnabled) {
                log.debug((Object)("ReadGroups is enabled for " + this.getMyDomainName()));
            } else {
                log.debug((Object)("ReadGroups is disabled for " + this.getMyDomainName()));
            }
        }
        if (this.readGroupsEnabled) {
            this.groupSearchBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
            if (this.groupSearchBase == null || this.groupSearchBase.trim().length() == 0) {
                throw new UserStoreException("Required GroupSearchBase property is not set at the LDAP configurations");
            }
            String groupNameListFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
            if (groupNameListFilter == null || groupNameListFilter.trim().length() == 0) {
                throw new UserStoreException("Required GroupNameListFilter property is not set at the LDAP configurations");
            }
            String groupNameSearchFilter = this.realmConfig.getUserStoreProperty("GroupNameSearchFilter");
            if (groupNameSearchFilter == null || groupNameSearchFilter.trim().length() == 0) {
                throw new UserStoreException("Required GroupNameSearchFilter property is not set at the LDAP configurations");
            }
            String groupNameAttribute = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
            if (groupNameAttribute == null || groupNameAttribute.trim().length() == 0) {
                throw new UserStoreException("Required GroupNameAttribute property is not set at the LDAP configurations");
            }
            String memebershipAttribute = this.realmConfig.getUserStoreProperty("MembershipAttribute");
            if (memebershipAttribute == null || memebershipAttribute.trim().length() == 0) {
                throw new UserStoreException("Required MembershipAttribute property is not set at the LDAP configurations");
            }
        }
        this.cacheExpiryTimeAttribute = this.realmConfig.getUserStoreProperty("UserCacheExpiryMilliseconds");
        String userDnCacheEnabledAttribute = this.realmConfig.getUserStoreProperty("UserDNCacheEnabled");
        if (StringUtils.isNotEmpty((String)userDnCacheEnabledAttribute)) {
            this.userDnCacheEnabled = Boolean.parseBoolean(userDnCacheEnabledAttribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean doAuthenticate(String userName, Object credential) throws UserStoreException {
        debug = ReadOnlyLDAPUserStoreManager.log.isDebugEnabled();
        failedUserDN = null;
        if (userName == null || credential == null) {
            return false;
        }
        leadingOrTrailingSpaceAllowedInUserName = this.realmConfig.getUserStoreProperty("LeadingOrTrailingSpaceAllowedInUserName");
        if (StringUtils.isNotEmpty((String)leadingOrTrailingSpaceAllowedInUserName)) {
            isSpaceAllowedInUserName = Boolean.parseBoolean(leadingOrTrailingSpaceAllowedInUserName);
            if (ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) {
                ReadOnlyLDAPUserStoreManager.log.debug((Object)("'LeadingOrTrailingSpaceAllowedInUserName' property is set to : " + isSpaceAllowedInUserName));
            }
            if (!isSpaceAllowedInUserName) {
                if (ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) {
                    ReadOnlyLDAPUserStoreManager.log.debug((Object)("Leading or trailing spaces are not allowed in username. Hence validating the username against the regex for the user : " + userName));
                }
                if (!this.checkUserNameValid(userName)) {
                    if (ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) {
                        ReadOnlyLDAPUserStoreManager.log.debug((Object)("Username validation failed for the user : " + userName));
                    }
                    return false;
                }
            }
        } else {
            userName = userName.trim();
        }
        try {
            credentialObj = Secret.getSecret((Object)credential);
        }
        catch (UnsupportedSecretTypeException e) {
            throw new UserStoreException("Unsupported credential type", e);
        }
        if (userName.equals("") || credentialObj.isEmpty()) {
            return false;
        }
        if (debug) {
            ReadOnlyLDAPUserStoreManager.log.debug((Object)("Authenticating user " + userName));
        }
        try {
            bValue = false;
            name = null;
            ldn = this.getFromUserCache(userName);
            if (ldn != null) {
                block33: {
                    name = ldn.toString();
                    try {
                        if (debug) {
                            ReadOnlyLDAPUserStoreManager.log.debug((Object)("Cache hit. Using DN " + name));
                        }
                        bValue = this.bindAsUser(userName, name, credentialObj);
                    }
                    catch (NamingException e) {
                        if (!ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) break block33;
                        ReadOnlyLDAPUserStoreManager.log.debug((Object)("Checking authentication with UserDN " + name + "failed " + e.getMessage()), (Throwable)e);
                    }
                }
                if (bValue) {
                    e = bValue;
                    return e;
                }
                failedUserDN = name;
            }
            if ((patterns = this.realmConfig.getUserStoreProperty("UserDNPattern")) != null && !patterns.isEmpty()) {
                if (debug) {
                    ReadOnlyLDAPUserStoreManager.log.debug((Object)("Using UserDNPatterns " + patterns));
                }
                if ((userDNPatternList = patterns.split("#")).length > 0) {
                    for (String userDNPattern : userDNPatternList) {
                        name = MessageFormat.format(userDNPattern, new Object[]{this.escapeSpecialCharactersForDN(userName)});
                        if (failedUserDN != null && failedUserDN.equalsIgnoreCase(name)) continue;
                        if (debug) {
                            ReadOnlyLDAPUserStoreManager.log.debug((Object)("Authenticating with " + name));
                        }
                        try {
                            if (name == null || !(bValue = this.bindAsUser(userName, name, credentialObj))) continue;
                            ldapName = new LdapName(name);
                            this.putToUserCache(userName, ldapName);
                            break;
                        }
                        catch (NamingException e) {
                            if (!ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) continue;
                            ReadOnlyLDAPUserStoreManager.log.debug((Object)("Checking authentication with UserDN " + userDNPattern + "failed " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
            } else {
                name = this.getNameInSpaceForUsernameFromLDAP(userName);
                try {
                    if (name == null || failedUserDN != null && failedUserDN.equalsIgnoreCase(name)) ** GOTO lbl81
                    if (ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) {
                        ReadOnlyLDAPUserStoreManager.log.debug((Object)("Authenticating with " + name));
                    }
                    if (!(bValue = this.bindAsUser(userName, name, credentialObj))) ** GOTO lbl81
                    ldapName = new LdapName(name);
                    this.putToUserCache(userName, ldapName);
                }
                catch (NamingException e) {
                    errorMessage = "Cannot bind user : " + userName;
                    if (ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) {
                        ReadOnlyLDAPUserStoreManager.log.debug((Object)errorMessage, (Throwable)e);
                    }
                    throw new UserStoreException(errorMessage, e);
                }
            }
            var11_17 = bValue;
            return var11_17;
        }
        finally {
            credentialObj.clear();
        }
    }

    @Override
    public String[] getAllProfileNames() throws UserStoreException {
        return new String[]{"default"};
    }

    @Override
    public String[] getProfileNames(String userName) throws UserStoreException {
        return new String[]{"default"};
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Map<String, String> getUserPropertyValues(String userName, String[] propertyNames, String profileName) throws UserStoreException {
        block45: {
            if (userName == null) {
                throw new UserStoreException("userName value is null.");
            }
            userAttributeSeparator = ",";
            userDN = null;
            ldn = this.getFromUserCache(userName);
            if (ldn == null) {
                patterns = this.realmConfig.getUserStoreProperty("UserDNPattern");
                if (patterns != null && !patterns.isEmpty()) {
                    if (ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) {
                        ReadOnlyLDAPUserStoreManager.log.debug((Object)("Using User DN Patterns " + patterns));
                    }
                    userDN = patterns.contains("#") ? this.getNameInSpaceForUserName(userName) : MessageFormat.format(patterns, new Object[]{this.escapeSpecialCharactersForDN(userName)});
                }
            } else {
                userDN = ldn.toString();
            }
            values = new HashMap<String, String>();
            userNames = userName.split(CarbonConstants.DOMAIN_SEPARATOR);
            if (userNames.length > 1) {
                userName = userNames[1];
            }
            dirContext = this.connectionSource.getContext();
            userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
            searchFilter = userSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
            answer = null;
            attrs = null;
            try {
                if (userDN != null) {
                    searchCtls = new SearchControls();
                    searchCtls.setSearchScope(2);
                    if (propertyNames != null && propertyNames.length > 0) {
                        searchCtls.setReturningAttributes(propertyNames);
                    }
                    if (ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) {
                        try {
                            ReadOnlyLDAPUserStoreManager.log.debug((Object)("Searching for user with SearchFilter: " + searchFilter + " in SearchBase: " + dirContext.getNameInNamespace()));
                        }
                        catch (NamingException e) {
                            ReadOnlyLDAPUserStoreManager.log.debug((Object)"Error while getting DN of search base", (Throwable)e);
                        }
                        if (propertyNames == null) {
                            ReadOnlyLDAPUserStoreManager.log.debug((Object)"No attributes requested");
                        } else {
                            for (String attribute : propertyNames) {
                                ReadOnlyLDAPUserStoreManager.log.debug((Object)("Requesting attribute :" + attribute));
                            }
                        }
                    }
                    try {
                        answer = dirContext.search(this.escapeDNForSearch(userDN), searchFilter, searchCtls);
                    }
                    catch (PartialResultException e) {
                        errorMessage = "Error occurred while searching directory context for user : " + userDN + " searchFilter : " + searchFilter;
                        if (this.isIgnorePartialResultException()) {
                            if (!ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) ** GOTO lbl61
                            ReadOnlyLDAPUserStoreManager.log.debug((Object)errorMessage, (Throwable)e);
                        }
                        throw new UserStoreException(errorMessage, e);
                    }
                    catch (NamingException e) {
                        errorMessage = "Error occurred while searching directory context for user : " + userDN + " searchFilter : " + searchFilter;
                        if (ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) {
                            ReadOnlyLDAPUserStoreManager.log.debug((Object)errorMessage, (Throwable)e);
                        }
                        throw new UserStoreException(errorMessage, e);
                    }
                } else {
                    searchBases = this.realmConfig.getUserStoreProperty("UserSearchBase");
                    var16_26 = searchBaseAraay = searchBases.split("#");
                    var17_28 = var16_26.length;
                    for (var18_30 = 0; var18_30 < var17_28 && !(answer = this.searchUserForASearchBase(searchFilter, propertyNames, dirContext, searchBase = var16_26[var18_30])).hasMore(); ++var18_30) {
                    }
                }
lbl61:
                // 6 sources

                while (answer != null && answer.hasMoreElements()) {
                    sr = answer.next();
                    if (userDN == null && sr != null && (userDN = sr.getNameInNamespace()) != null) {
                        this.putToUserCache(userName, new LdapName(userDN));
                    }
                    if ((attributes = sr.getAttributes()) == null) continue;
                    for (String name : propertyNames) {
                        if (name == null || (attribute = attributes.get(name)) == null) continue;
                        attrBuffer = new StringBuffer();
                        attrs = attribute.getAll();
                        while (attrs.hasMore()) {
                            attObject = attrs.next();
                            attr = null;
                            if (attObject instanceof String) {
                                attr = (String)attObject;
                            } else if (attObject instanceof byte[]) {
                                bytes = (byte[])attObject;
                                if (bytes.length == 16 && name.toLowerCase().endsWith("uid")) {
                                    if (name.equalsIgnoreCase("objectGUID")) {
                                        property = this.realmConfig.getUserStoreProperty("transformObjectGUIDToUUID");
                                        v0 = transformObjectGuidToUuid = StringUtils.isEmpty((String)property) != false || Boolean.parseBoolean(property) != false;
                                        if (transformObjectGuidToUuid) {
                                            bb = ByteBuffer.wrap(this.swapBytes(bytes));
                                            attr = new UUID(bb.getLong(), bb.getLong()).toString();
                                        } else {
                                            attr = new String(Base64.encodeBase64((byte[])((byte[])attObject)));
                                        }
                                    }
                                } else {
                                    attr = new String(Base64.encodeBase64((byte[])((byte[])attObject)));
                                }
                            }
                            if (attr != null && attr.trim().length() > 0) {
                                attrSeparator = this.realmConfig.getUserStoreProperty("MultiAttributeSeparator");
                                if (attrSeparator != null && !attrSeparator.trim().isEmpty()) {
                                    userAttributeSeparator = attrSeparator;
                                }
                                attrBuffer.append(attr + userAttributeSeparator);
                            }
                            if ((value = attrBuffer.toString()) == null || value.trim().length() <= userAttributeSeparator.length()) continue;
                            value = value.substring(0, value.length() - userAttributeSeparator.length());
                            values.put(name, value);
                        }
                    }
                }
            }
            catch (PartialResultException e) {
                errorMessage = "Error occurred while search user for filter : " + searchFilter;
                if (this.isIgnorePartialResultException()) {
                    if (ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) {
                        ReadOnlyLDAPUserStoreManager.log.debug((Object)errorMessage, (Throwable)e);
                    }
                    break block45;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (NamingException e) {
                errorMessage = "Error occurred while getting user property values for user : " + userName;
                if (ReadOnlyLDAPUserStoreManager.log.isDebugEnabled()) {
                    ReadOnlyLDAPUserStoreManager.log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(attrs);
                JNDIUtil.closeNamingEnumeration(answer);
                JNDIUtil.closeContext(dirContext);
            }
        }
        return values;
    }

    @Override
    public boolean doCheckExistingRole(String roleName) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        return this.isExistingLDAPRole(roleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExistingLDAPRole(RoleContext context) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        boolean isExisting = false;
        String roleName = context.getRoleName();
        if (debug) {
            log.debug((Object)("Searching for role: " + roleName));
        }
        String searchFilter = ((LDAPRoleContext)context).getListFilter();
        String roleNameProperty = ((LDAPRoleContext)context).getRoleNameProperty();
        searchFilter = "(&" + searchFilter + "(" + roleNameProperty + "=" + this.escapeSpecialCharactersForFilter(roleName) + "))";
        String searchBases = ((LDAPRoleContext)context).getSearchBase();
        if (debug) {
            log.debug((Object)("Using search filter: " + searchFilter));
        }
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(new String[]{roleNameProperty});
        NamingEnumeration<SearchResult> answer = null;
        DirContext dirContext = null;
        try {
            String[] roleSearchBaseArray;
            dirContext = this.connectionSource.getContext();
            if (((LDAPRoleContext)context).getRoleDNPatterns().size() > 0) {
                for (String pattern : ((LDAPRoleContext)context).getRoleDNPatterns()) {
                    block16: {
                        if (debug) {
                            log.debug((Object)("Using pattern: " + pattern));
                        }
                        pattern = MessageFormat.format(pattern.trim(), this.escapeSpecialCharactersForDN(roleName));
                        try {
                            answer = dirContext.search(this.escapeDNForSearch(pattern), searchFilter, searchCtls);
                        }
                        catch (NamingException e) {
                            if (!log.isDebugEnabled()) break block16;
                            log.debug((Object)e);
                        }
                    }
                    if (answer == null || !answer.hasMoreElements()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            for (String searchBase : roleSearchBaseArray = searchBases.split("#")) {
                if (debug) {
                    log.debug((Object)("Searching in " + searchBase));
                }
                try {
                    answer = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchCtls);
                    if (!answer.hasMoreElements()) continue;
                    isExisting = true;
                    break;
                }
                catch (NamingException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)e);
                }
            }
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        if (debug) {
            log.debug((Object)("Is role: " + roleName + " exist: " + isExisting));
        }
        return isExisting;
    }

    @Override
    public boolean doCheckExistingUser(String userName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for user " + userName));
        }
        if (userName == null) {
            return false;
        }
        boolean bFound = false;
        String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        userSearchFilter = userSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
        try {
            String searchBase = null;
            String userDN = null;
            LdapName ldn = this.getFromUserCache(userName);
            if (ldn == null) {
                String userDNPattern = this.realmConfig.getUserStoreProperty("UserDNPattern");
                if (userDNPattern != null && userDNPattern.trim().length() > 0) {
                    String[] patterns;
                    for (String pattern : patterns = userDNPattern.split("#")) {
                        searchBase = MessageFormat.format(pattern, this.escapeSpecialCharactersForDN(userName));
                        userDN = this.getNameInSpaceForUserName(userName, searchBase, userSearchFilter);
                        if (userDN == null || userDN.length() <= 0) continue;
                        bFound = true;
                        LdapName ldapName = new LdapName(userDN);
                        this.putToUserCache(userName, ldapName);
                        break;
                    }
                }
            } else {
                userDN = ldn.toString();
                searchBase = MessageFormat.format(userDN, this.escapeSpecialCharactersForDN(userName));
                if ((userDN = this.getNameInSpaceForUserName(userName, searchBase, userSearchFilter)) != null && userDN.length() > 0) {
                    bFound = true;
                } else {
                    this.removeFromUserCache(userName);
                }
            }
            if (!bFound && (userDN = this.getNameInSpaceForUserName(userName, searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase"), userSearchFilter)) != null && userDN.length() > 0) {
                bFound = true;
            }
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while checking existence of user : " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User: " + userName + " exist: " + bFound));
        }
        return bFound;
    }

    @Override
    public String[] doListUsers(String filter, int maxItemLimit) throws UserStoreException {
        Object[] userNames;
        block23: {
            boolean debug = log.isDebugEnabled();
            userNames = new String[]{};
            if (maxItemLimit == 0) {
                return userNames;
            }
            if (filter.contains("?") || filter.contains("**")) {
                throw new UserStoreException("Invalid character sequence entered for user serch. Please enter valid sequence.");
            }
            StringBuffer searchFilter = new StringBuffer(this.realmConfig.getUserStoreProperty("UserNameListFilter"));
            String searchBases = this.realmConfig.getUserStoreProperty("UserSearchBase");
            String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
            String serviceNameAttribute = "sn";
            StringBuffer finalFilter = new StringBuffer();
            String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
            String[] returnedAtts = null;
            if (StringUtils.isNotEmpty((String)displayNameAttribute)) {
                returnedAtts = new String[]{userNameProperty, serviceNameAttribute, displayNameAttribute};
                finalFilter.append("(&").append(searchFilter).append("(").append(displayNameAttribute).append("=").append(this.escapeSpecialCharactersForFilterWithStarAsRegex(filter)).append("))");
            } else {
                returnedAtts = new String[]{userNameProperty, serviceNameAttribute};
                finalFilter.append("(&").append(searchFilter).append("(").append(userNameProperty).append("=").append(this.escapeSpecialCharactersForFilterWithStarAsRegex(filter)).append("))");
            }
            NamingEnumeration<SearchResult> answer = null;
            ArrayList<String> list = new ArrayList<String>();
            DirContext dirContext = this.connectionSource.getContext();
            try {
                String[] searchBaseArray = searchBases.split("#");
                for (String searchBase : searchBaseArray) {
                    answer = this.searchUsersForASearchBase(finalFilter.toString(), returnedAtts, dirContext, searchBase, maxItemLimit);
                    while (answer != null && answer.hasMoreElements()) {
                        SearchResult sr = answer.next();
                        if (sr.getAttributes() == null) continue;
                        log.debug((Object)"Result found ..");
                        Attribute attr = sr.getAttributes().get(userNameProperty);
                        Attribute attrSurname = sr.getAttributes().get(serviceNameAttribute);
                        if (attrSurname != null) {
                            String serviceName;
                            if (debug) {
                                log.debug((Object)(serviceNameAttribute + " : " + attrSurname));
                            }
                            if ((serviceName = (String)attrSurname.get()) != null && serviceName.equals("Service")) continue;
                        }
                        Attribute displayName = null;
                        if (StringUtils.isNotEmpty((String)displayNameAttribute)) {
                            displayName = sr.getAttributes().get(displayNameAttribute);
                            if (debug) {
                                log.debug((Object)(displayNameAttribute + " : " + displayName));
                            }
                        }
                        if (attr == null) continue;
                        String name = (String)attr.get();
                        String display = null;
                        if (displayName != null) {
                            display = (String)displayName.get();
                        }
                        String domain = this.getRealmConfiguration().getUserStoreProperty("DomainName");
                        name = UserCoreUtil.getCombinedName(domain, name, display);
                        list.add(name);
                    }
                }
                userNames = list.toArray(new String[list.size()]);
                Arrays.sort(userNames);
                if (debug) {
                    for (Object username : userNames) {
                        log.debug((Object)("result: " + (String)username));
                    }
                }
            }
            catch (PartialResultException e) {
                String errorMessage = "Error occurred while getting user list for filter : " + filter + "max limit : " + maxItemLimit;
                if (this.isIgnorePartialResultException()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMessage, (Throwable)e);
                    }
                    break block23;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (NamingException e) {
                String errorMessage = "Error occurred while getting user list for filter : " + filter + "max limit : " + maxItemLimit;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(answer);
                JNDIUtil.closeContext(dirContext);
            }
        }
        return userNames;
    }

    @Override
    public long doCountUsersWithClaims(String claimURI, String valueFilter) throws UserStoreException {
        throw new UserStoreException("Error occurred while getting users count with claims ");
    }

    protected NamingEnumeration<SearchResult> searchForUsers(String finalFilter, String searchBase, String searchBases, int maxItemLimit, String[] returnedAtts) throws UserStoreException {
        NamingEnumeration<SearchResult> answer;
        int searchTime;
        int givenMax;
        try {
            givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
        }
        catch (Exception e) {
            givenMax = 100;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 10000;
        }
        if (maxItemLimit < 0 || maxItemLimit > givenMax) {
            maxItemLimit = givenMax;
        }
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setCountLimit(maxItemLimit);
        searchCtls.setTimeLimit(searchTime);
        searchCtls.setReturningAttributes(returnedAtts);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing users. SearchBase: " + searchBases + " Constructed-Filter: " + finalFilter));
            log.debug((Object)("Search controls. Max Limit: " + maxItemLimit + " Max Time: " + searchTime));
        }
        DirContext dirContext = null;
        dirContext = this.connectionSource.getContext();
        try {
            answer = dirContext.search(this.escapeDNForSearch(searchBase), finalFilter, searchCtls);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while getting user list for filter : " + finalFilter + "max limit : " + maxItemLimit;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeContext(dirContext);
        }
        return answer;
    }

    protected NamingEnumeration<SearchResult> searchUsersForASearchBase(String searchFilter, String[] returnedAttributes, DirContext dirContext, String searchBase, int maxItemLimit) throws NamingException {
        NamingEnumeration<SearchResult> answer;
        int searchTime;
        int givenMax;
        try {
            givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
        }
        catch (Exception e) {
            givenMax = 100;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 10000;
        }
        if (maxItemLimit < 0 || maxItemLimit > givenMax) {
            maxItemLimit = givenMax;
        }
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setCountLimit(maxItemLimit);
        searchCtls.setTimeLimit(searchTime);
        searchCtls.setReturningAttributes(returnedAttributes);
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)("Searching for user with SearchFilter: " + searchFilter + " in SearchBase: " + dirContext.getNameInNamespace()));
            }
            catch (NamingException e) {
                log.debug((Object)"Error while getting DN of search base", (Throwable)e);
            }
            if (returnedAttributes == null) {
                log.debug((Object)"ReturnedAttributes are null, hence retuning all.");
            } else if (ArrayUtils.isEmpty((Object[])returnedAttributes)) {
                log.debug((Object)"No attributes requested.");
            } else {
                for (String attribute : returnedAttributes) {
                    log.debug((Object)("Requesting attribute :" + attribute));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing users. SearchBase: " + searchBase + " Constructed-Filter: " + searchFilter));
            log.debug((Object)("Search controls. Max Limit: " + maxItemLimit + " Max Time: " + searchTime));
        }
        try {
            answer = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchCtls);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while getting user list for filter : " + searchFilter + "max limit : " + maxItemLimit;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw e;
        }
        return answer;
    }

    @Override
    protected String[] doGetDisplayNamesForInternalRole(String[] userNames) throws UserStoreException {
        String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
        if (StringUtils.isNotEmpty((String)displayNameAttribute)) {
            String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
            String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
            String userNameListFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
            String[] returningAttributes = new String[]{displayNameAttribute};
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(returningAttributes);
            ArrayList<String> combinedNames = new ArrayList<String>();
            if (userNames != null && userNames.length > 0) {
                for (String userName : userNames) {
                    String searchFilter = "(&" + userNameListFilter + "(" + userNameAttribute + "=" + this.escapeSpecialCharactersForFilter(userName) + "))";
                    List<String> displayNames = this.getListOfNames(userSearchBase, searchFilter, searchControls, displayNameAttribute, false);
                    if (displayNames == null || displayNames.isEmpty()) continue;
                    String name = UserCoreUtil.getCombinedName(this.realmConfig.getUserStoreProperty("DomainName"), userName, displayNames.get(0));
                    combinedNames.add(name);
                }
                return combinedNames.toArray(new String[combinedNames.size()]);
            }
            return userNames;
        }
        return userNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean bindAsUser(String dn, String credentials) throws NamingException, UserStoreException {
        boolean isAuthed = false;
        boolean debug = log.isDebugEnabled();
        LdapContext cxt = null;
        try {
            boolean retry;
            int retries;
            try {
                retries = Integer.parseInt(this.realmConfig.getUserStoreProperty(RETRY_ATTEMPTS));
            }
            catch (NullPointerException | NumberFormatException e) {
                retries = 0;
            }
            do {
                --retries;
                retry = false;
                try {
                    cxt = this.connectionSource.getContextWithCredentials(dn, credentials);
                    isAuthed = true;
                }
                catch (UserStoreException e) {
                    if (!e.getMessage().contains("TimeLimitExceeded")) continue;
                    retry = true;
                }
            } while (retry && retries >= 0);
            JNDIUtil.closeContext(cxt);
        }
        catch (AuthenticationException e) {
            if (debug) {
                log.debug((Object)("Authentication failed " + e));
            }
        }
        finally {
            JNDIUtil.closeContext(cxt);
        }
        if (debug) {
            log.debug((Object)("User: " + dn + " is authenticated: " + isAuthed));
        }
        return isAuthed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bindAsUser(String userName, String dn, Object credentials) throws NamingException, UserStoreException {
        boolean isAuthed = false;
        boolean debug = log.isDebugEnabled();
        LdapContext cxt = null;
        try {
            cxt = this.connectionSource.getContextWithCredentials(dn, credentials);
            isAuthed = true;
        }
        catch (AuthenticationException e) {
            block6: {
                try {
                    if (debug) {
                        log.debug((Object)("Authentication failed " + e));
                        log.debug((Object)("Clearing cache for DN: " + dn));
                    }
                    if (userName == null) break block6;
                    this.removeFromUserCache(userName);
                }
                catch (Throwable throwable) {
                    JNDIUtil.closeContext(cxt);
                    throw throwable;
                }
            }
            JNDIUtil.closeContext(cxt);
        }
        JNDIUtil.closeContext(cxt);
        if (debug) {
            log.debug((Object)("User: " + dn + " is authnticated: " + isAuthed));
        }
        return isAuthed;
    }

    protected NamingEnumeration<SearchResult> searchForUser(String searchFilter, String[] returnedAtts, DirContext dirContext) throws UserStoreException {
        String errorMessage;
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        String searchBases = this.realmConfig.getUserStoreProperty("UserSearchBase");
        if (returnedAtts != null && returnedAtts.length > 0) {
            searchCtls.setReturningAttributes(returnedAtts);
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)("Searching for user with SearchFilter: " + searchFilter + " in SearchBase: " + dirContext.getNameInNamespace()));
            }
            catch (NamingException e) {
                log.debug((Object)"Error while getting DN of search base", (Throwable)e);
            }
            if (returnedAtts == null) {
                log.debug((Object)"No attributes requested");
            } else {
                for (String attribute : returnedAtts) {
                    log.debug((Object)("Requesting attribute :" + attribute));
                }
            }
        }
        String[] searchBaseAraay = searchBases.split("#");
        NamingEnumeration<SearchResult> answer = null;
        try {
            for (String searchBase : searchBaseAraay) {
                answer = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchCtls);
                if (!answer.hasMore()) continue;
                return answer;
            }
        }
        catch (PartialResultException e) {
            errorMessage = "Error occurred while search user for filter : " + searchFilter;
            if (this.isIgnorePartialResultException()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
            }
            throw new UserStoreException(errorMessage, e);
        }
        catch (NamingException e) {
            errorMessage = "Error occurred while search user for filter : " + searchFilter;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        return answer;
    }

    protected NamingEnumeration<SearchResult> searchUserForASearchBase(String searchFilter, String[] returnedAttributes, DirContext dirContext, String searchBase) throws NamingException {
        NamingEnumeration<SearchResult> answer;
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(returnedAttributes);
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)("Searching for user with SearchFilter: " + searchFilter + " in SearchBase: " + dirContext.getNameInNamespace()));
            }
            catch (NamingException e) {
                log.debug((Object)"Error while getting DN of search base", (Throwable)e);
            }
            if (returnedAttributes == null) {
                log.debug((Object)"ReturnedAttributes are null, hence retuning all.");
            } else if (ArrayUtils.isEmpty((Object[])returnedAttributes)) {
                log.debug((Object)"No attributes requested.");
            } else {
                for (String attribute : returnedAttributes) {
                    log.debug((Object)("Requesting attribute :" + attribute));
                }
            }
        }
        try {
            answer = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchCtls);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while search user for filter : " + searchFilter + " in the search base: " + searchBase;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw e;
        }
        return answer;
    }

    @Override
    public void doAddRole(String roleName, String[] userList, boolean shared) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateRoleName(String roleName, String newRoleName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    public boolean isMultipleProfilesAllowed() {
        return false;
    }

    @Override
    public void doDeleteRole(String roleName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    protected List<String> getLDAPRoleNames(int searchTime, String filter, int maxItemLimit, String searchFilter, String roleNameProperty, String searchBase, boolean appendTenantDomain) throws UserStoreException {
        ArrayList<String> roles;
        boolean debug;
        block15: {
            debug = log.isDebugEnabled();
            roles = new ArrayList<String>();
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            searchCtls.setCountLimit(maxItemLimit);
            searchCtls.setTimeLimit(searchTime);
            String[] returnedAtts = new String[]{roleNameProperty};
            searchCtls.setReturningAttributes(returnedAtts);
            StringBuffer finalFilter = new StringBuffer();
            finalFilter.append("(&").append(searchFilter).append("(").append(roleNameProperty).append("=").append(this.escapeSpecialCharactersForFilterWithStarAsRegex(filter)).append("))");
            if (debug) {
                log.debug((Object)("Listing roles. SearchBase: " + searchBase + " ConstructedFilter: " + finalFilter.toString()));
            }
            DirContext dirContext = null;
            NamingEnumeration<SearchResult> answer = null;
            try {
                dirContext = this.connectionSource.getContext();
                answer = dirContext.search(this.escapeDNForSearch(searchBase), finalFilter.toString(), searchCtls);
                String domain = this.getRealmConfiguration().getUserStoreProperty("DomainName");
                while (answer.hasMoreElements()) {
                    Attribute attr;
                    SearchResult sr = answer.next();
                    if (sr.getAttributes() == null || (attr = sr.getAttributes().get(roleNameProperty)) == null) continue;
                    String name = (String)attr.get();
                    name = UserCoreUtil.addDomainToName(name, domain);
                    if (appendTenantDomain) {
                        String dn = sr.getNameInNamespace();
                        name = UserCoreUtil.addTenantDomainToEntry(name, this.getTenantDomainFromRoleDN(dn, name));
                    }
                    roles.add(name);
                }
            }
            catch (PartialResultException e) {
                String errorMessage = "Error occurred while getting LDAP role names. SearchBase: " + searchBase + " ConstructedFilter: " + finalFilter.toString();
                if (this.isIgnorePartialResultException()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMessage, (Throwable)e);
                    }
                    break block15;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (NamingException e) {
                String errorMessage = "Error occurred while getting LDAP role names. SearchBase: " + searchBase + " ConstructedFilter: " + finalFilter.toString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(answer);
                JNDIUtil.closeContext(dirContext);
            }
        }
        if (debug) {
            Iterator rolesIte = roles.iterator();
            while (rolesIte.hasNext()) {
                log.debug((Object)("result: " + (String)rolesIte.next()));
            }
        }
        return roles;
    }

    private String getTenantDomainFromRoleDN(String dn, String roleName) {
        dn = dn.toLowerCase();
        roleName = roleName.toLowerCase();
        String sharedSearchBase = (String)this.realmConfig.getUserStoreProperties().get("SharedGroupSearchBase");
        if (dn.indexOf(sharedSearchBase = sharedSearchBase.toLowerCase()) > -1) {
            String groupNameAttributeName;
            int lastIndex;
            dn = dn.replaceAll(sharedSearchBase, "");
            if ((dn = dn.replace(this.realmConfig.getUserStoreProperty("GroupNameAttribute").toLowerCase() + "=" + roleName, "")).indexOf(",") == 0) {
                dn = dn.substring(1);
            }
            if ((lastIndex = dn.indexOf(",")) > -1 && lastIndex == dn.length() - 1) {
                dn = dn.substring(0, dn.length() - 1);
            }
            if ((dn = dn.replaceAll((groupNameAttributeName = this.realmConfig.getUserStoreProperty("SharedTenantNameAttribute").toLowerCase()) + "=", "")) == null || dn.isEmpty()) {
                dn = "carbon.super";
            }
            return dn;
        }
        return CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
    }

    @Override
    protected void filterSharedRoles(List<String> sharedRoles, String tenantDomain) {
        if ((tenantDomain = tenantDomain.toLowerCase()) != null) {
            Iterator<String> i = sharedRoles.iterator();
            while (i.hasNext()) {
                String role = i.next();
                if (role.toLowerCase().indexOf(tenantDomain) <= -1) continue;
                i.remove();
            }
        }
    }

    @Override
    public String[] doGetRoleNames(String filter, int maxItemLimit) throws UserStoreException {
        if (maxItemLimit == 0) {
            return new String[0];
        }
        int givenMax = 100;
        int searchTime = 10000;
        try {
            givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxRoleNameListLength"));
        }
        catch (Exception e) {
            givenMax = 100;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 10000;
        }
        if (maxItemLimit < 0 || maxItemLimit > givenMax) {
            maxItemLimit = givenMax;
        }
        ArrayList<String> externalRoles = new ArrayList<String>();
        if (this.readGroupsEnabled) {
            String[] searchBaseArray;
            String searchBases = this.realmConfig.getUserStoreProperty("GroupSearchBase");
            for (String searchBase : searchBaseArray = searchBases.split("#")) {
                externalRoles.addAll(this.getLDAPRoleNames(searchTime, filter, maxItemLimit, this.realmConfig.getUserStoreProperty("GroupNameListFilter"), this.realmConfig.getUserStoreProperty("GroupNameAttribute"), searchBase, false));
            }
        }
        return externalRoles.toArray(new String[externalRoles.size()]);
    }

    @Override
    protected String[] doGetSharedRoleNames(String tenantDomain, String filter, int maxItemLimit) throws UserStoreException {
        if (!this.isSharedGroupEnabled()) {
            return new String[0];
        }
        if (maxItemLimit == 0) {
            return new String[0];
        }
        int givenMax = 100;
        int searchTime = 10000;
        try {
            givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxRoleNameListLength"));
        }
        catch (Exception e) {
            givenMax = 100;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 10000;
        }
        if (maxItemLimit < 0 || maxItemLimit > givenMax) {
            maxItemLimit = givenMax;
        }
        String searchBase = null;
        if ("carbon.super".equalsIgnoreCase(tenantDomain)) {
            searchBase = this.realmConfig.getUserStoreProperty("SharedGroupSearchBase");
        } else {
            String groupNameAttributeName = this.realmConfig.getUserStoreProperty("SharedTenantNameAttribute");
            if (groupNameAttributeName == null || groupNameAttributeName.trim().length() == 0) {
                groupNameAttributeName = "ou";
            }
            searchBase = groupNameAttributeName + "=" + tenantDomain + "," + this.realmConfig.getUserStoreProperty("SharedGroupSearchBase");
        }
        List<String> sharedRoleNames = this.getLDAPRoleNames(searchTime, filter, maxItemLimit, this.realmConfig.getUserStoreProperty("GroupNameListFilter"), this.realmConfig.getUserStoreProperty("GroupNameAttribute"), searchBase, true);
        this.filterSharedRoles(sharedRoleNames, CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
        return sharedRoleNames.toArray(new String[sharedRoleNames.size()]);
    }

    @Override
    public RealmConfiguration getRealmConfiguration() {
        return this.realmConfig;
    }

    @Override
    public String[] doGetUserListOfRole(String roleName, String filter) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        return this.getUserListOfLDAPRole(roleContext, filter);
    }

    /*
     * Loose catch block
     */
    public String[] getUserListOfLDAPRole(RoleContext context, String filter) throws UserStoreException {
        String[] names;
        block48: {
            boolean debug = log.isDebugEnabled();
            if (debug) {
                log.debug((Object)("Getting user list of role: " + context.getRoleName() + " with filter: " + filter));
            }
            ArrayList<String> userList = new ArrayList<String>();
            names = new String[]{};
            int givenMax = 100;
            int searchTime = 10000;
            try {
                givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
            }
            catch (Exception e) {
                givenMax = 100;
            }
            try {
                searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
            }
            catch (Exception e) {
                searchTime = 10000;
            }
            DirContext dirContext = null;
            NamingEnumeration<SearchResult> answer = null;
            try {
                SearchControls searchCtls = new SearchControls();
                searchCtls.setSearchScope(2);
                searchCtls.setTimeLimit(searchTime);
                searchCtls.setCountLimit(givenMax);
                String searchFilter = ((LDAPRoleContext)context).getListFilter();
                String roleNameProperty = ((LDAPRoleContext)context).getRoleNameProperty();
                searchFilter = "(&" + searchFilter + "(" + roleNameProperty + "=" + this.escapeSpecialCharactersForFilter(context.getRoleName()) + "))";
                int offset = 0;
                int lastRecord = 0;
                int attributeValuesRange = 0;
                boolean isEndOfAttributes = false;
                String roleListRange = this.realmConfig.getUserStoreProperty(MEMBERSHIP_ATTRIBUTE_RANGE);
                if (StringUtils.isNotEmpty((String)roleListRange)) {
                    attributeValuesRange = Integer.parseInt(roleListRange);
                }
                if (attributeValuesRange > 0) {
                    lastRecord = attributeValuesRange - 1;
                }
                String membershipProperty = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                ArrayList<String> userDNList = new ArrayList<String>();
                String rangedMembershipProperty = membershipProperty;
                while (!isEndOfAttributes) {
                    Attributes attributes;
                    if (lastRecord > 0 && StringUtils.isNotEmpty((String)membershipProperty)) {
                        rangedMembershipProperty = membershipProperty + String.format(";range=%1$d-%2$d", offset, lastRecord);
                    }
                    String[] returnedAtts = new String[]{rangedMembershipProperty};
                    searchCtls.setReturningAttributes(returnedAtts);
                    Object sr = null;
                    dirContext = this.connectionSource.getContext();
                    if (!((LDAPRoleContext)context).getRoleDNPatterns().isEmpty()) {
                        for (String pattern : ((LDAPRoleContext)context).getRoleDNPatterns()) {
                            if (debug) {
                                log.debug((Object)("Using pattern: " + pattern));
                            }
                            pattern = MessageFormat.format(pattern.trim(), this.escapeSpecialCharactersForDN(context.getRoleName()));
                            try {
                                answer = dirContext.search(this.escapeDNForSearch(pattern), searchFilter, searchCtls);
                                if (!answer.hasMore()) continue;
                                sr = answer.next();
                                break;
                            }
                            catch (NamingException e) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)e);
                            }
                        }
                    }
                    if (sr == null) {
                        String[] roleSearchBaseArray;
                        String searchBases = ((LDAPRoleContext)context).getSearchBase();
                        for (String searchBase : roleSearchBaseArray = searchBases.split("#")) {
                            if (debug) {
                                log.debug((Object)("Searching role: " + context.getRoleName() + " SearchBase: " + searchBase + " SearchFilter: " + searchFilter));
                            }
                            try {
                                answer = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchCtls);
                                int count = 0;
                                if (!answer.hasMore()) continue;
                                while (answer.hasMore()) {
                                    if (count > 0) {
                                        throw new UserStoreException("More than one group exist with name");
                                    }
                                    sr = answer.next();
                                    ++count;
                                }
                                break;
                            }
                            catch (NamingException e) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)e);
                            }
                        }
                    }
                    if (debug) {
                        log.debug((Object)("Found role: " + ((NameClassPair)sr).getNameInNamespace()));
                    }
                    if ((attributes = ((SearchResult)sr).getAttributes()) == null) continue;
                    NamingEnumeration<? extends Attribute> attributeEntry = null;
                    int recordCount = 0;
                    attributeEntry = attributes.getAll();
                    while (attributeEntry.hasMore()) {
                        Attribute valAttribute = attributeEntry.next();
                        if (membershipProperty != null && !this.isAttributeEqualsProperty(membershipProperty, valAttribute.getID())) continue;
                        NamingEnumeration<?> values = null;
                        values = valAttribute.getAll();
                        while (values.hasMore()) {
                            String value = values.next().toString();
                            userDNList.add(value);
                            ++recordCount;
                            if (!debug) continue;
                            log.debug((Object)("Found attribute: " + membershipProperty + " value: " + value));
                        }
                    }
                    if (attributeValuesRange == 0 || recordCount < attributeValuesRange) {
                        isEndOfAttributes = true;
                        continue;
                    }
                    offset += attributeValuesRange;
                    lastRecord += attributeValuesRange;
                }
                if (MEMBER_UID.equals(this.realmConfig.getUserStoreProperty("MembershipAttribute"))) {
                    ArrayList<String> userDNListNew = new ArrayList<String>();
                    for (String user : userDNList) {
                        String userDN = this.getNameInSpaceForUserName(user);
                        userDNListNew.add(userDN);
                    }
                    userDNList = userDNListNew;
                }
                String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
                String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
                String[] returnedAttributes = new String[]{userNameProperty, displayNameAttribute};
                for (String user : userDNList) {
                    if (debug) {
                        log.debug((Object)("Getting name attributes of: " + user));
                    }
                    try {
                        Attributes userAttributes = dirContext.getAttributes(this.escapeDNForSearch(user), returnedAttributes);
                        String displayName = null;
                        String userName = null;
                        if (userAttributes != null) {
                            Attribute userNameAttribute = userAttributes.get(userNameProperty);
                            if (userNameAttribute != null) {
                                userName = (String)userNameAttribute.get();
                                if (debug) {
                                    log.debug((Object)("UserName: " + userName));
                                }
                            }
                            if (StringUtils.isNotEmpty((String)displayNameAttribute)) {
                                Attribute displayAttribute = userAttributes.get(displayNameAttribute);
                                if (displayAttribute != null) {
                                    displayName = (String)displayAttribute.get();
                                }
                                if (debug) {
                                    log.debug((Object)("DisplayName: " + displayName));
                                }
                            }
                        }
                        String domainName = this.realmConfig.getUserStoreProperty("DomainName");
                        if (userName != null) {
                            user = UserCoreUtil.getCombinedName(domainName, userName, displayName);
                            userList.add(user);
                            if (!debug) continue;
                            log.debug((Object)(user + " is added to the result list"));
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("User " + user + " doesn't have the user name property : " + userNameProperty));
                    }
                    catch (NamingException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Error in reading user information in the user store for the user " + user + e.getMessage()), (Throwable)e);
                    }
                }
                names = userList.toArray(new String[userList.size()]);
                JNDIUtil.closeNamingEnumeration(answer);
            }
            catch (PartialResultException e) {
                String errorMessage = "Error in reading user information in the user store for filter : " + filter;
                if (this.isIgnorePartialResultException()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMessage, (Throwable)e);
                    }
                    break block48;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (NamingException e2) {
                String errorMessage = "Error in reading user information in the user store for filter : " + filter;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e2);
                }
                throw new UserStoreException(errorMessage, e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                JNDIUtil.closeNamingEnumeration(answer);
                JNDIUtil.closeContext(dirContext);
            }
            JNDIUtil.closeContext(dirContext);
        }
        return names;
    }

    private boolean isAttributeEqualsProperty(String property, String attribute) {
        if (StringUtils.isEmpty((String)property) || StringUtils.isEmpty((String)attribute)) {
            return false;
        }
        return property.equals(attribute) || property.equals(attribute.substring(0, attribute.indexOf(";")));
    }

    protected String getEffectiveSearchBase(boolean shared) {
        String backLinksEnabled = this.realmConfig.getUserStoreProperty("BackLinksEnabled");
        boolean isBackLinkEnabled = false;
        if (backLinksEnabled != null && !backLinksEnabled.equals("")) {
            isBackLinkEnabled = Boolean.parseBoolean(backLinksEnabled);
        }
        if (isBackLinkEnabled) {
            return this.realmConfig.getUserStoreProperty("UserSearchBase");
        }
        if (shared) {
            return this.realmConfig.getUserStoreProperty("SharedGroupSearchBase");
        }
        return this.realmConfig.getUserStoreProperty("GroupSearchBase");
    }

    protected String[] getLDAPRoleListOfUser(String userName, String filter, String searchBase, boolean shared) throws UserStoreException {
        if (userName == null) {
            throw new UserStoreException("userName value is null.");
        }
        boolean debug = log.isDebugEnabled();
        List<String> list = new ArrayList<String>();
        if (this.readGroupsEnabled && !UserCoreUtil.isRegistryAnnonymousUser(userName) && !UserCoreUtil.isRegistrySystemUser(userName)) {
            LdapName ldn;
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            String memberOfProperty = this.realmConfig.getUserStoreProperty("MemberOfAttribute");
            if (memberOfProperty != null && memberOfProperty.length() > 0) {
                String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
                String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
                String searchFilter = userSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
                String binaryAttribute = this.realmConfig.getUserStoreProperty("java.naming.ldap.attributes.binary");
                String primaryGroupId = this.realmConfig.getUserStoreProperty("PrimaryGroupId");
                String[] returnedAtts = new String[]{memberOfProperty};
                if (binaryAttribute != null && primaryGroupId != null) {
                    returnedAtts = new String[]{memberOfProperty, binaryAttribute, primaryGroupId};
                }
                searchCtls.setReturningAttributes(returnedAtts);
                if (debug) {
                    log.debug((Object)("Reading roles with the memberOfProperty Property: " + memberOfProperty));
                }
                if (binaryAttribute != null && primaryGroupId != null) {
                    list = this.getAttributeListOfOneElementWithPrimarGroup(searchBase, searchFilter, searchCtls, binaryAttribute, primaryGroupId, userNameProperty, memberOfProperty);
                } else {
                    ldn = this.getFromUserCache(userName);
                    if (ldn != null) {
                        searchBase = ldn.toString();
                    } else {
                        String userDNPattern = this.realmConfig.getUserStoreProperty("UserDNPattern");
                        if (userDNPattern != null && userDNPattern.trim().length() > 0 && !userDNPattern.contains("#")) {
                            searchBase = MessageFormat.format(userDNPattern, this.escapeSpecialCharactersForDN(userName));
                        }
                    }
                    List<String> groupDNs = this.getListOfNames(searchBase, searchFilter, searchCtls, memberOfProperty, false);
                    ArrayList<LdapName> groups = new ArrayList<LdapName>();
                    for (String groupDN : groupDNs) {
                        try {
                            groups.add(new LdapName(groupDN));
                        }
                        catch (InvalidNameException e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"LDAP Name error :", (Throwable)e);
                        }
                    }
                    list = this.getGroupNameAttributeValuesOfGroups(groups);
                }
            } else {
                String membershipValue;
                String roleNameProperty;
                String searchFilter;
                if (shared) {
                    searchFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
                    roleNameProperty = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
                } else {
                    searchFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
                    roleNameProperty = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
                }
                String membershipProperty = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                String userDNPattern = this.realmConfig.getUserStoreProperty("UserDNPattern");
                String nameInSpace = userDNPattern != null && userDNPattern.trim().length() > 0 && !userDNPattern.contains("#") ? MessageFormat.format(userDNPattern, this.escapeSpecialCharactersForDN(userName)) : this.getNameInSpaceForUserName(userName);
                if (membershipProperty == null || membershipProperty.length() < 1) {
                    throw new UserStoreException("Please set member of attribute or membership attribute");
                }
                if (nameInSpace != null) {
                    try {
                        ldn = new LdapName(nameInSpace);
                        if (MEMBER_UID.equals(this.realmConfig.getUserStoreProperty("MembershipAttribute"))) {
                            List<Rdn> rdns = ldn.getRdns();
                            membershipValue = rdns.get(rdns.size() - 1).getValue().toString();
                        }
                        membershipValue = this.escapeLdapNameForFilter(ldn);
                    }
                    catch (InvalidNameException e) {
                        log.error((Object)("Error while creating LDAP name from: " + nameInSpace));
                        throw new UserStoreException("Invalid naming exception for : " + nameInSpace, e);
                    }
                } else {
                    return new String[0];
                }
                searchFilter = "(&" + searchFilter + "(" + membershipProperty + "=" + membershipValue + "))";
                String[] returnedAtts = new String[]{roleNameProperty};
                searchCtls.setReturningAttributes(returnedAtts);
                if (debug) {
                    log.debug((Object)("Reading roles with the membershipProperty Property: " + membershipProperty));
                }
                list = this.getListOfNames(searchBase, searchFilter, searchCtls, roleNameProperty, false);
            }
        } else if (UserCoreUtil.isRegistryAnnonymousUser(userName)) {
            list.add("system/wso2.anonymous.role");
        }
        String[] result = list.toArray(new String[list.size()]);
        if (result != null) {
            for (String rolename : result) {
                log.debug((Object)("Found role: " + rolename));
            }
        }
        return result;
    }

    @Override
    protected String[] doGetExternalRoleListOfUser(String userName, String filter) throws UserStoreException {
        String searchBase = this.getEffectiveSearchBase(false);
        return this.getLDAPRoleListOfUser(userName, filter, searchBase, false);
    }

    @Override
    protected String[] doGetSharedRoleListOfUser(String userName, String tenantDomain, String filter) throws UserStoreException {
        String searchBase = this.getEffectiveSearchBase(true);
        if (tenantDomain != null && tenantDomain.trim().length() > 0 && !"carbon.super".equalsIgnoreCase(tenantDomain.trim())) {
            String groupNameAttributeName = this.realmConfig.getUserStoreProperty("SharedTenantNameAttribute");
            if (groupNameAttributeName == null || groupNameAttributeName.trim().length() == 0) {
                groupNameAttributeName = "ou";
            }
            searchBase = groupNameAttributeName + "=" + tenantDomain + "," + searchBase;
        }
        return this.getLDAPRoleListOfUser(userName, filter, searchBase, true);
    }

    @Override
    public boolean isReadOnly() throws UserStoreException {
        return true;
    }

    protected String getNameInSpaceForUserName(String userName) throws UserStoreException {
        LdapName ldn = null;
        if (userName == null) {
            throw new UserStoreException("userName value is null.");
        }
        ldn = this.getFromUserCache(userName);
        if (ldn != null) {
            return ldn.toString();
        }
        return this.getNameInSpaceForUsernameFromLDAP(userName);
    }

    protected String getNameInSpaceForUsernameFromLDAP(String userName) throws UserStoreException {
        String searchBase = null;
        String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        userSearchFilter = userSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
        String userDNPattern = this.realmConfig.getUserStoreProperty("UserDNPattern");
        if (userDNPattern != null && userDNPattern.trim().length() > 0) {
            String[] patterns;
            for (String pattern : patterns = userDNPattern.split("#")) {
                searchBase = MessageFormat.format(pattern, this.escapeSpecialCharactersForDN(userName));
                String userDN = this.getNameInSpaceForUserName(userName, searchBase, userSearchFilter);
                if (userDN == null) continue;
                return userDN;
            }
        }
        searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        return this.getNameInSpaceForUserName(userName, searchBase, userSearchFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNameInSpaceForUserName(String userName, String searchBase, String searchFilter) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        if (userName == null) {
            throw new UserStoreException("userName value is null.");
        }
        LdapName cachedDn = this.getFromUserCache(userName);
        if (cachedDn != null) {
            return ((Object)cachedDn).toString();
        }
        String userDN = null;
        DirContext dirContext = this.connectionSource.getContext();
        NamingEnumeration<SearchResult> answer = null;
        try {
            String[] searchBases;
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            if (log.isDebugEnabled()) {
                try {
                    log.debug((Object)("Searching for user with SearchFilter: " + searchFilter + " in SearchBase: " + dirContext.getNameInNamespace()));
                }
                catch (NamingException e) {
                    log.debug((Object)"Error while getting DN of search base", (Throwable)e);
                }
            }
            SearchResult userObj = null;
            for (String base : searchBases = searchBase.split("#")) {
                answer = dirContext.search(this.escapeDNForSearch(base), searchFilter, searchCtls);
                if (!answer.hasMore() || (userObj = answer.next()) == null) continue;
                userDN = userObj.getNameInNamespace();
                break;
            }
            if (userDN != null) {
                LdapName ldn = new LdapName(userDN);
                this.putToUserCache(userName, ldn);
            }
            if (debug) {
                log.debug((Object)("Name in space for " + userName + " is " + userDN));
            }
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        return userDN;
    }

    private List<String> parseSearchResult(SearchResult sr, String groupAttributeName) {
        ArrayList<String> list = new ArrayList<String>();
        Attributes attrs = sr.getAttributes();
        if (attrs != null) {
            try {
                NamingEnumeration<? extends Attribute> ae = null;
                ae = attrs.getAll();
                while (ae.hasMore()) {
                    Attribute attr = ae.next();
                    if (groupAttributeName != null && !groupAttributeName.equals(attr.getID())) continue;
                    NamingEnumeration<?> e = null;
                    e = attr.getAll();
                    while (e.hasMore()) {
                        String value = e.next().toString();
                        int begin = value.indexOf("=") + 1;
                        int end = value.indexOf(",");
                        if (begin > -1 && end > -1) {
                            value = value.substring(begin, end);
                        }
                        list.add(value);
                    }
                    JNDIUtil.closeNamingEnumeration(e);
                }
                JNDIUtil.closeNamingEnumeration(ae);
            }
            catch (NamingException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    private List<String> getAttributeListOfOneElementWithPrimarGroup(String searchBase, String searchFilter, SearchControls searchCtls, String objectSid, String primaryGroupID, String userAttributeId, String groupAttributeName) throws UserStoreException {
        List<String> list;
        boolean debug;
        block15: {
            debug = log.isDebugEnabled();
            list = new ArrayList<String>();
            DirContext dirContext = null;
            NamingEnumeration<SearchResult> answer = null;
            if (debug) {
                log.debug((Object)("GetAttributeListOfOneElementWithPrimarGroup. SearchBase: " + searchBase + " SearchFilter: " + searchFilter));
            }
            try {
                dirContext = this.connectionSource.getContext();
                answer = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchCtls);
                int count = 0;
                while (answer.hasMore()) {
                    if (count > 0) {
                        log.error((Object)"More than element user exist with name");
                        throw new UserStoreException("More than element user exist with name");
                    }
                    SearchResult sr = answer.next();
                    ++count;
                    list = this.parseSearchResult(sr, groupAttributeName);
                    String primaryGroupSID = LDAPUtil.getPrimaryGroupSID(sr, objectSid, primaryGroupID);
                    String primaryGroupName = LDAPUtil.findGroupBySID(dirContext, searchBase, primaryGroupSID, userAttributeId);
                    if (primaryGroupName == null) continue;
                    list.add(primaryGroupName);
                }
            }
            catch (PartialResultException e) {
                String errorMessage = "Error occurred while GetAttributeListOfOneElementWithPrimarGroup. SearchBase: " + searchBase + " SearchFilter: " + searchFilter;
                if (this.isIgnorePartialResultException()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMessage, (Throwable)e);
                    }
                    break block15;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (NamingException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                throw new UserStoreException(e.getMessage(), e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(answer);
                JNDIUtil.closeContext(dirContext);
            }
        }
        if (debug) {
            log.debug((Object)("GetAttributeListOfOneElementWithPrimarGroup. SearchBase: " + searchBase + " SearchFilter: " + searchFilter));
            Iterator<String> ite = list.iterator();
            while (ite.hasNext()) {
                log.debug((Object)("result: " + ite.next()));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getAttributeListOfOneElement(String searchBases, String searchFilter, SearchControls searchCtls) throws UserStoreException {
        List<String> list = new ArrayList<String>();
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        try {
            String[] searchBaseArray;
            dirContext = this.connectionSource.getContext();
            for (String searchBase : searchBaseArray = searchBases.split("#")) {
                try {
                    answer = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchCtls);
                    int count = 0;
                    if (!answer.hasMore()) continue;
                    while (answer.hasMore()) {
                        if (count > 0) {
                            log.error((Object)"More than element user exist with name");
                            throw new UserStoreException("More than element user exist with name");
                        }
                        SearchResult sr = answer.next();
                        ++count;
                        list = this.parseSearchResult(sr, null);
                    }
                    break;
                }
                catch (NamingException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)e);
                }
            }
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getListOfNames(String searchBases, String searchFilter, SearchControls searchCtls, String property, boolean appendDn) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        ArrayList<String> names = new ArrayList<String>();
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        if (debug) {
            log.debug((Object)("Result for searchBase: " + searchBases + " searchFilter: " + searchFilter + " property:" + property + " appendDN: " + appendDn));
        }
        try {
            String[] searchBaseArray;
            dirContext = this.connectionSource.getContext();
            for (String searchBase : searchBaseArray = searchBases.split("#")) {
                block11: {
                    try {
                        answer = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchCtls);
                        String domain = this.getRealmConfiguration().getUserStoreProperty("DomainName");
                        while (answer.hasMoreElements()) {
                            Attribute attr;
                            SearchResult sr = answer.next();
                            if (sr.getAttributes() == null || (attr = sr.getAttributes().get(property)) == null) continue;
                            NamingEnumeration<?> vals = attr.getAll();
                            while (vals.hasMoreElements()) {
                                String name = (String)vals.nextElement();
                                if (debug) {
                                    log.debug((Object)("Found user: " + name));
                                }
                                domain = UserCoreUtil.addDomainToName(name, domain);
                                names.add(name);
                            }
                        }
                    }
                    catch (NamingException e) {
                        if (!log.isDebugEnabled()) break block11;
                        log.debug((Object)e);
                    }
                }
                if (!debug) continue;
                for (String name : names) {
                    log.debug((Object)("Result  :  " + name));
                }
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
    }

    public Map<String, String> getProperties(org.wso2.carbon.user.api.Tenant tenant) throws org.wso2.carbon.user.api.UserStoreException {
        return this.getProperties((Tenant)tenant);
    }

    @Override
    public int getTenantId() throws UserStoreException {
        return this.tenantId;
    }

    @Override
    public String[] getUserListFromProperties(String property, String value, String profileName) throws UserStoreException {
        ArrayList<String> values;
        boolean debug;
        block25: {
            if (value == null) {
                return new String[0];
            }
            debug = log.isDebugEnabled();
            String userAttributeSeparator = ",";
            String serviceNameAttribute = "sn";
            values = new ArrayList<String>();
            String searchFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
            String userPropertyName = this.realmConfig.getUserStoreProperty("UserNameAttribute");
            if (OBJECT_GUID.equalsIgnoreCase(property) && (this.isGUIDValue(value) || StringUtils.equals((String)value, (String)"*"))) {
                String convertedValue;
                boolean transformObjectGuidToUuid;
                String transformObjectGuidToUuidProperty = this.realmConfig.getUserStoreProperty("transformObjectGUIDToUUID");
                boolean bl = transformObjectGuidToUuid = StringUtils.isEmpty((String)transformObjectGuidToUuidProperty) || Boolean.parseBoolean(transformObjectGuidToUuidProperty);
                if (StringUtils.equals((String)value, (String)"*")) {
                    convertedValue = value;
                } else if (transformObjectGuidToUuid) {
                    convertedValue = this.transformUUIDToObjectGUID(value);
                } else {
                    byte[] bytes = Base64.decodeBase64((byte[])value.getBytes());
                    convertedValue = this.convertBytesToHexString(bytes);
                }
                searchFilter = "(&" + searchFilter + "(" + property + "=" + convertedValue + "))";
            } else {
                searchFilter = "(&" + searchFilter + "(" + property + "=" + this.escapeSpecialCharactersForFilterWithStarAsRegex(value) + "))";
            }
            DirContext dirContext = this.connectionSource.getContext();
            NamingEnumeration<SearchResult> answer = null;
            NamingEnumeration<?> attrs = null;
            if (debug) {
                log.debug((Object)("Listing users with Property: " + property + " SearchFilter: " + searchFilter));
            }
            String[] returnedAttributes = new String[]{userPropertyName, serviceNameAttribute};
            try {
                String searchBase;
                String[] searchBaseArray;
                String searchBases = this.realmConfig.getUserStoreProperty("UserSearchBase");
                String[] stringArray = searchBaseArray = searchBases.split("#");
                int n = stringArray.length;
                for (int i = 0; i < n && !(answer = this.searchUsersForASearchBase(searchFilter, returnedAttributes, dirContext, searchBase = stringArray[i], -1)).hasMore(); ++i) {
                }
                while (answer != null && answer.hasMoreElements()) {
                    Attribute attribute;
                    SearchResult sr = (SearchResult)answer.next();
                    Attributes attributes = sr.getAttributes();
                    if (attributes == null || (attribute = attributes.get(userPropertyName)) == null) continue;
                    StringBuffer attrBuffer = new StringBuffer();
                    attrs = attribute.getAll();
                    while (attrs.hasMore()) {
                        String attr = (String)attrs.next();
                        if (attr == null || attr.trim().length() <= 0) continue;
                        String attrSeparator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
                        if (attrSeparator != null && !attrSeparator.trim().isEmpty()) {
                            userAttributeSeparator = attrSeparator;
                        }
                        attrBuffer.append(attr + userAttributeSeparator);
                        if (!debug) continue;
                        log.debug((Object)(userPropertyName + " : " + attr));
                    }
                    String propertyValue = attrBuffer.toString();
                    Attribute serviceNameObject = attributes.get(serviceNameAttribute);
                    String serviceNameAttributeValue = null;
                    if (serviceNameObject != null) {
                        serviceNameAttributeValue = (String)serviceNameObject.get();
                    }
                    if (propertyValue == null || propertyValue.trim().length() <= userAttributeSeparator.length() || "Service".equals(serviceNameAttributeValue)) continue;
                    propertyValue = propertyValue.substring(0, propertyValue.length() - userAttributeSeparator.length());
                    values.add(propertyValue);
                }
            }
            catch (PartialResultException e) {
                String errorMessage = "Error occurred while getting user list from properties for filter : " + searchFilter;
                if (this.isIgnorePartialResultException()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMessage, (Throwable)e);
                    }
                    break block25;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (NamingException e) {
                String errorMessage = "Error occurred while getting user list from property : " + property + " & value : " + value + " & profile name : " + profileName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(attrs);
                JNDIUtil.closeNamingEnumeration(answer);
                JNDIUtil.closeContext(dirContext);
            }
        }
        if (debug) {
            String[] results;
            for (String result : results = values.toArray(new String[values.size()])) {
                log.debug((Object)("result: " + result));
            }
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    protected PaginatedSearchResult doGetUserList(Condition condition, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        PaginatedSearchResult result = new PaginatedSearchResult();
        List<ExpressionCondition> expressionConditions = this.getExpressionConditions(condition);
        LDAPSearchSpecification ldapSearchSpecification = new LDAPSearchSpecification(this.realmConfig, expressionConditions);
        boolean isMemberShipPropertyFound = ldapSearchSpecification.isMemberShipPropertyFound();
        limit = this.getLimit(limit, isMemberShipPropertyFound);
        offset = this.getOffset(offset);
        if (limit == 0) {
            return result;
        }
        int pageSize = limit;
        DirContext dirContext = this.connectionSource.getContext();
        LdapContext ldapContext = (LdapContext)dirContext;
        ArrayList<String> ldapUsers = new ArrayList<String>();
        String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        try {
            ldapContext.setRequestControls(new Control[]{new PagedResultsControl(pageSize, true), new SortControl(userNameAttribute, false)});
            List<String> users = this.performLDAPSearch(ldapContext, ldapSearchSpecification, pageSize, offset, expressionConditions);
            for (String ldapUser : users) {
                ldapUsers.add(UserCoreUtil.addDomainToName(ldapUser, this.getMyDomainName()));
            }
            result.setUsers(ldapUsers.toArray(new String[0]));
            PaginatedSearchResult paginatedSearchResult = result;
            return paginatedSearchResult;
        }
        catch (NamingException e) {
            log.error((Object)String.format("Error occurred while performing paginated search, %s", e.getMessage()));
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (IOException e) {
            log.error((Object)String.format("Error occurred while setting paged results controls for paginated search, %s", e.getMessage()));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeContext(dirContext);
            JNDIUtil.closeContext(ldapContext);
        }
    }

    protected int getOffset(int offset) {
        offset = offset <= 0 ? 0 : --offset;
        return offset;
    }

    protected int getLimit(int limit, boolean isMemberShipPropertyFound) {
        int givenMax;
        try {
            givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
        }
        catch (Exception e) {
            givenMax = 100;
        }
        if (isMemberShipPropertyFound || limit > givenMax) {
            limit = givenMax;
        }
        return limit;
    }

    protected static byte[] parseControls(Control[] controls) {
        byte[] cookie = null;
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[i];
                cookie = prrc.getCookie();
            }
        }
        return cookie;
    }

    protected List<ExpressionCondition> getExpressionConditions(Condition condition) {
        ArrayList<ExpressionCondition> expressionConditions = new ArrayList<ExpressionCondition>();
        this.getExpressionConditionsAsList(condition, expressionConditions);
        return expressionConditions;
    }

    private void getExpressionConditionsAsList(Condition condition, List<ExpressionCondition> expressionConditions) {
        if (condition instanceof ExpressionCondition) {
            ExpressionCondition expressionCondition = (ExpressionCondition)condition;
            expressionCondition.setAttributeValue(this.escapeSpecialCharactersForFilterWithStarAsRegex(expressionCondition.getAttributeValue()));
            expressionConditions.add(expressionCondition);
        } else if (condition instanceof OperationalCondition) {
            Condition leftCondition = ((OperationalCondition)condition).getLeftCondition();
            this.getExpressionConditionsAsList(leftCondition, expressionConditions);
            Condition rightCondition = ((OperationalCondition)condition).getRightCondition();
            this.getExpressionConditionsAsList(rightCondition, expressionConditions);
        }
    }

    private List<String> performLDAPSearch(LdapContext ldapContext, LDAPSearchSpecification ldapSearchSpecification, int pageSize, int offset, List<ExpressionCondition> expressionConditions) throws UserStoreException {
        List<String> users;
        block16: {
            int pageIndex = -1;
            boolean isGroupFiltering = ldapSearchSpecification.isGroupFiltering();
            boolean isUsernameFiltering = ldapSearchSpecification.isUsernameFiltering();
            boolean isClaimFiltering = ldapSearchSpecification.isClaimFiltering();
            boolean isMemberShipPropertyFound = ldapSearchSpecification.isMemberShipPropertyFound();
            String searchBases = ldapSearchSpecification.getSearchBases();
            String[] searchBaseAraay = searchBases.split("#");
            String searchFilter = ldapSearchSpecification.getSearchFilterQuery();
            SearchControls searchControls = ldapSearchSpecification.getSearchControls();
            List<String> returnedAttributes = Arrays.asList(searchControls.getReturningAttributes());
            NamingEnumeration<SearchResult> answer = null;
            users = new ArrayList<String>();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Searching for user(s) with SearchFilter: %s and page size %d", searchFilter, pageSize));
            }
            try {
                block8: for (String searchBase : searchBaseAraay) {
                    byte[] cookie;
                    do {
                        ArrayList<String> tempUserList = new ArrayList();
                        answer = ldapContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchControls);
                        if (answer.hasMore()) {
                            tempUserList = this.getUserListFromSearch(isGroupFiltering, returnedAttributes, answer, this.isSingleAttributeFilterOperation(expressionConditions));
                            ++pageIndex;
                        }
                        if (CollectionUtils.isNotEmpty(tempUserList)) {
                            if (isMemberShipPropertyFound) {
                                users = this.membershipGroupFilterPostProcessing(isUsernameFiltering, isClaimFiltering, expressionConditions, tempUserList);
                                continue block8;
                            }
                            this.generatePaginatedUserList(pageIndex, offset, pageSize, tempUserList, users);
                            int needMore = pageSize - users.size();
                            if (needMore == 0) continue block8;
                        }
                        cookie = ReadOnlyLDAPUserStoreManager.parseControls(ldapContext.getResponseControls());
                        String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
                        ldapContext.setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookie, true), new SortControl(userNameAttribute, false)});
                    } while (cookie != null && cookie.length != 0);
                }
            }
            catch (PartialResultException e) {
                if (this.isIgnorePartialResultException()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Error occurred while searching for user(s) for filter: %s", searchFilter));
                    }
                    break block16;
                }
                log.error((Object)String.format("Error occurred while searching for user(s) for filter: %s", searchFilter));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (NamingException e) {
                log.error((Object)String.format("Error occurred while searching for user(s) for filter: %s, %s", searchFilter, e.getMessage()));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (IOException e) {
                log.error((Object)String.format("Error occurred while doing paginated search, %s", e.getMessage()));
                throw new UserStoreException(e.getMessage(), e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(answer);
            }
        }
        return users;
    }

    protected boolean isSingleAttributeFilterOperation(List<ExpressionCondition> expressionConditions) {
        return expressionConditions.size() == 1;
    }

    private List<String> getUserListFromSearch(boolean isGroupFiltering, List<String> returnedAttributes, NamingEnumeration<SearchResult> answer, boolean isSingleAttributeFilter) throws UserStoreException {
        List<String> tempUserList = isGroupFiltering ? this.getUserListFromGroupFilterResult(answer, returnedAttributes, isSingleAttributeFilter) : this.getUserListFromNonGroupFilterResult(answer, returnedAttributes);
        return tempUserList;
    }

    private List<String> getUserListFromGroupFilterResult(NamingEnumeration<SearchResult> answer, List<String> returnedAttributes, boolean isSingleAttributeFilter) throws UserStoreException {
        ArrayList<String> userListFromSearch = new ArrayList<String>();
        int count = 0;
        NamingEnumeration<?> attrs = null;
        try {
            while (answer.hasMoreElements()) {
                ++count;
                ArrayList<String> tempUserList = new ArrayList<String>();
                SearchResult searchResult = answer.next();
                Attributes attributes = searchResult.getAttributes();
                if (attributes == null) continue;
                NamingEnumeration<? extends Attribute> attributeEntry = attributes.getAll();
                while (attributeEntry.hasMore()) {
                    Attribute valAttribute = attributeEntry.next();
                    if (!this.isAttributeEqualsProperty(returnedAttributes.get(0), valAttribute.getID())) continue;
                    NamingEnumeration<?> values = valAttribute.getAll();
                    while (values.hasMore()) {
                        tempUserList.add(values.next().toString());
                    }
                }
                if (isSingleAttributeFilter) {
                    userListFromSearch.addAll(tempUserList);
                    continue;
                }
                if (!returnedAttributes.contains(this.realmConfig.getUserStoreProperty("MembershipAttribute")) || count == 1) {
                    userListFromSearch.addAll(tempUserList);
                    continue;
                }
                userListFromSearch.retainAll(tempUserList);
            }
        }
        catch (NamingException e) {
            log.error((Object)String.format("Error occurred while getting user list from group filter %s", e.getMessage()));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(attrs);
        }
        List<String> finalUserList = returnedAttributes.contains(this.realmConfig.getUserStoreProperty("MembershipAttribute")) ? this.getUserNamesFromDNList(userListFromSearch) : userListFromSearch;
        return finalUserList;
    }

    private List<String> getUserNamesFromDNList(List<String> userListFromSearch) throws UserStoreException {
        ArrayList<String> userNameList = new ArrayList<String>();
        DirContext dirContext = this.connectionSource.getContext();
        String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
        String[] requiredAttributes = new String[]{userNameProperty, displayNameAttribute};
        for (String user : userListFromSearch) {
            try {
                String displayName = null;
                String userName = null;
                Attributes userAttributes = dirContext.getAttributes(this.escapeDNForSearch(user), requiredAttributes);
                if (userAttributes != null) {
                    Attribute displayAttribute;
                    Attribute userNameAttribute = userAttributes.get(userNameProperty);
                    if (userNameAttribute != null) {
                        userName = (String)userNameAttribute.get();
                    }
                    if (StringUtils.isNotEmpty((String)displayNameAttribute) && (displayAttribute = userAttributes.get(displayNameAttribute)) != null) {
                        displayName = (String)displayAttribute.get();
                    }
                }
                String domainName = this.realmConfig.getUserStoreProperty("DomainName");
                if (userName != null) {
                    user = UserCoreUtil.getCombinedName(domainName, userName, displayName);
                    userNameList.add(user);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("User %s doesn't have the user name property %s", user, userNameProperty));
            }
            catch (NamingException e) {
                log.error((Object)String.format("Error in reading user information in the user store for the user %s, %s", user, e.getMessage()));
                throw new UserStoreException(e.getMessage(), e);
            }
        }
        return userNameList;
    }

    private List<String> getUserListFromNonGroupFilterResult(NamingEnumeration<SearchResult> answer, List<String> returnedAttributes) throws UserStoreException {
        ArrayList<String> finalUserList = new ArrayList<String>();
        String userAttributeSeparator = ",";
        NamingEnumeration<?> attrs = null;
        try {
            while (answer.hasMoreElements()) {
                Attribute attribute;
                SearchResult searchResult = answer.next();
                Attributes attributes = searchResult.getAttributes();
                if (attributes == null || (attribute = attributes.get(returnedAttributes.get(0))) == null) continue;
                StringBuffer attrBuffer = new StringBuffer();
                attrs = attribute.getAll();
                while (attrs.hasMore()) {
                    String attr = (String)attrs.next();
                    if (!StringUtils.isNotEmpty((String)attr.trim())) continue;
                    String attrSeparator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
                    if (StringUtils.isNotEmpty((String)attrSeparator.trim())) {
                        userAttributeSeparator = attrSeparator;
                    }
                    attrBuffer.append(attr + userAttributeSeparator);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(returnedAttributes.get(0) + " : " + attr));
                }
                String propertyValue = attrBuffer.toString();
                Attribute serviceNameObject = attributes.get(returnedAttributes.get(1));
                String serviceNameAttributeValue = null;
                if (serviceNameObject != null) {
                    serviceNameAttributeValue = (String)serviceNameObject.get();
                }
                if (propertyValue.trim().length() <= userAttributeSeparator.length() || "Service".equals(serviceNameAttributeValue)) continue;
                propertyValue = propertyValue.substring(0, propertyValue.length() - userAttributeSeparator.length());
                finalUserList.add(propertyValue);
            }
        }
        catch (NamingException e) {
            log.error((Object)String.format("Error occurred while getting user list from non group filter %s", e.getMessage()));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(attrs);
        }
        return finalUserList;
    }

    private void generatePaginatedUserList(int pageIndex, int offset, int pageSize, List<String> tempUserList, List<String> users) {
        if (pageIndex == offset / pageSize) {
            int startPosition = offset % pageSize;
            if (startPosition < tempUserList.size() - 1) {
                users.addAll(tempUserList.subList(startPosition, tempUserList.size()));
            } else if (startPosition == tempUserList.size() - 1) {
                users.add(tempUserList.get(tempUserList.size() - 1));
            }
        } else if (pageIndex == offset / pageSize + 1) {
            int needMore = pageSize - users.size();
            if (tempUserList.size() >= needMore) {
                users.addAll(tempUserList.subList(0, needMore));
            } else {
                users.addAll(tempUserList);
            }
        }
    }

    private List<String> getMatchUsersFromMemberList(List<ExpressionCondition> expressionConditions, List<String> userNames) {
        ArrayList<String> derivedUserList = new ArrayList<String>();
        for (ExpressionCondition expressionCondition : expressionConditions) {
            if (!ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) continue;
            derivedUserList.addAll(this.getMatchUserNames(expressionCondition, userNames));
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(derivedUserList);
        derivedUserList.clear();
        derivedUserList.addAll(linkedHashSet);
        return derivedUserList;
    }

    private List<String> getMatchUserNames(ExpressionCondition expressionCondition, List<String> users) {
        ArrayList<String> newUserNameList = new ArrayList<String>();
        for (String user : users) {
            if (ExpressionOperation.SW.toString().equals(expressionCondition.getOperation()) && user.startsWith(expressionCondition.getAttributeValue()) && !newUserNameList.contains(user)) {
                newUserNameList.add(user);
                continue;
            }
            if (ExpressionOperation.EQ.toString().equals(expressionCondition.getOperation()) && user.equals(expressionCondition.getAttributeValue()) && !newUserNameList.contains(user)) {
                newUserNameList.add(user);
                continue;
            }
            if (ExpressionOperation.CO.toString().equals(expressionCondition.getOperation()) && user.contains(expressionCondition.getAttributeValue()) && !newUserNameList.contains(user)) {
                newUserNameList.add(user);
                continue;
            }
            if (!ExpressionOperation.EW.toString().equals(expressionCondition.getOperation()) || !user.endsWith(expressionCondition.getAttributeValue()) || newUserNameList.contains(user)) continue;
            newUserNameList.add(user);
        }
        return newUserNameList;
    }

    private List<String> membershipGroupFilterPostProcessing(boolean isUsernameFiltering, boolean isClaimFiltering, List<ExpressionCondition> expressionConditions, List<String> tempUserList) throws UserStoreException {
        if (isUsernameFiltering) {
            tempUserList = this.getMatchUsersFromMemberList(expressionConditions, tempUserList);
        }
        List<String> users = isClaimFiltering ? this.getUserListFromClaimFiltering(expressionConditions, tempUserList) : tempUserList;
        return users;
    }

    private List<String> getUserListFromClaimFiltering(List<ExpressionCondition> expressionConditions, List<String> tempUserList) throws UserStoreException {
        List<Object> claimSearchUserList = new ArrayList();
        List<ExpressionCondition> derivedConditionList = expressionConditions;
        Iterator<ExpressionCondition> iterator = derivedConditionList.iterator();
        while (iterator.hasNext()) {
            ExpressionCondition expressionCondition = iterator.next();
            if (!ExpressionAttribute.ROLE.toString().equals(expressionCondition.getAttributeName())) continue;
            iterator.remove();
        }
        LDAPSearchSpecification claimSearch = new LDAPSearchSpecification(this.realmConfig, derivedConditionList);
        SearchControls claimSearchControls = claimSearch.getSearchControls();
        DirContext claimSearchDirContext = this.connectionSource.getContext();
        NamingEnumeration<SearchResult> tempAnswer = null;
        try {
            tempAnswer = claimSearchDirContext.search(claimSearch.getSearchBases(), claimSearch.getSearchFilterQuery(), claimSearchControls);
            if (tempAnswer.hasMore()) {
                claimSearchUserList = this.getUserListFromNonGroupFilterResult(tempAnswer, Arrays.asList(claimSearchControls.getReturningAttributes()));
            }
        }
        catch (NamingException e) {
            log.error((Object)String.format("Error occurred while doing claim filtering for user(s) with filter: %s, %s", claimSearch.getSearchFilterQuery(), e.getMessage()));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeContext(claimSearchDirContext);
            JNDIUtil.closeNamingEnumeration(tempAnswer);
        }
        tempUserList.retainAll(claimSearchUserList);
        return tempUserList;
    }

    protected String convertBytesToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            builder.append("\\").append(String.format("%02x", b));
        }
        return builder.toString();
    }

    protected String transformUUIDToObjectGUID(String value) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(UUID.fromString(value).getMostSignificantBits());
        bb.putLong(UUID.fromString(value).getLeastSignificantBits());
        byte[] bytes = this.swapBytes(bb.array());
        return this.convertBytesToHexString(bytes);
    }

    protected byte[] swapBytes(byte[] bytes) {
        byte swap = bytes[3];
        bytes[3] = bytes[0];
        bytes[0] = swap;
        swap = bytes[2];
        bytes[2] = bytes[1];
        bytes[1] = swap;
        swap = bytes[5];
        bytes[5] = bytes[4];
        bytes[4] = swap;
        swap = bytes[7];
        bytes[7] = bytes[6];
        bytes[6] = swap;
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean doCheckIsUserInRole(String userName, String roleName) throws UserStoreException {
        String membershipValue;
        boolean debug = log.isDebugEnabled();
        if (userName == null) {
            return false;
        }
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        LDAPRoleContext context = (LDAPRoleContext)this.createRoleContext(roleName);
        String searchBases = this.getEffectiveSearchBase(context.isShared());
        String memberOfProperty = this.realmConfig.getUserStoreProperty("MemberOfAttribute");
        if (memberOfProperty != null && memberOfProperty.length() > 0) {
            List<String> list;
            String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
            String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
            String searchFilter = userSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
            String binaryAttribute = this.realmConfig.getUserStoreProperty("java.naming.ldap.attributes.binary");
            String primaryGroupId = this.realmConfig.getUserStoreProperty("PrimaryGroupId");
            String[] returnedAtts = new String[]{memberOfProperty};
            if (binaryAttribute != null && primaryGroupId != null) {
                returnedAtts = new String[]{memberOfProperty, binaryAttribute, primaryGroupId};
            }
            searchCtls.setReturningAttributes(returnedAtts);
            if (debug) {
                log.debug((Object)("Do check whether the user: " + userName + " is in role: " + roleName));
                log.debug((Object)("Search filter: " + searchFilter));
                for (String retAttrib : returnedAtts) {
                    log.debug((Object)("Requesting attribute: " + retAttrib));
                }
            }
            if (binaryAttribute != null && primaryGroupId != null) {
                list = this.getAttributeListOfOneElementWithPrimarGroup(searchBases, searchFilter, searchCtls, binaryAttribute, primaryGroupId, userNameProperty, memberOfProperty);
            } else {
                LdapName ldn = this.getFromUserCache(userName);
                if (ldn != null) {
                    searchBases = ldn.toString();
                } else {
                    String userDNPattern = this.realmConfig.getUserStoreProperty("UserDNPattern");
                    if (StringUtils.isNotEmpty((String)userDNPattern) && !userDNPattern.contains("#")) {
                        searchBases = MessageFormat.format(userDNPattern, this.escapeSpecialCharactersForDN(userName));
                    }
                }
                List<String> groupDNs = this.getListOfNames(searchBases, searchFilter, searchCtls, memberOfProperty, false);
                list = this.getAttributeListOfOneElement(searchBases, searchFilter, searchCtls);
            }
            if (debug) {
                if (list != null) {
                    boolean isUserInRole = false;
                    for (String item : list) {
                        log.debug((Object)("Result: " + item));
                        if (!item.equalsIgnoreCase(roleName)) continue;
                        isUserInRole = true;
                    }
                    log.debug((Object)("Is user: " + userName + " in role: " + roleName + " ? " + isUserInRole));
                } else {
                    log.debug((Object)"No results found !");
                }
            }
            if (list == null) return false;
            RealmService defaultRealmService = UserStoreMgtDSComponent.getRealmService();
            if (defaultRealmService != null && defaultRealmService.getCachedUserRealm(this.tenantId) != null) {
                this.addAllRolesToUserRolesCache(userName, list);
            }
            for (String role : list) {
                if (!role.equalsIgnoreCase(roleName)) continue;
                return true;
            }
            return false;
        }
        String searchFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
        String membershipProperty = this.realmConfig.getUserStoreProperty("MembershipAttribute");
        if (membershipProperty == null || membershipProperty.length() < 1) {
            throw new UserStoreException("Please set member of attribute or membership attribute");
        }
        String roleNameProperty = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
        String userDNPattern = this.realmConfig.getUserStoreProperty("UserDNPattern");
        String nameInSpace = StringUtils.isNotEmpty((String)userDNPattern) && !userDNPattern.contains("#") ? MessageFormat.format(userDNPattern, this.escapeSpecialCharactersForDN(userName)) : this.getNameInSpaceForUserName(userName);
        if (nameInSpace == null) return false;
        try {
            LdapName ldn = new LdapName(nameInSpace);
            membershipValue = this.escapeLdapNameForFilter(ldn);
        }
        catch (InvalidNameException e) {
            log.error((Object)("Error while creating LDAP name from: " + nameInSpace));
            throw new UserStoreException("Invalid naming exception for : " + nameInSpace, e);
        }
        searchFilter = "(&" + searchFilter + "(" + membershipProperty + "=" + membershipValue + "))";
        String[] returnedAtts = new String[]{roleNameProperty};
        searchCtls.setReturningAttributes(returnedAtts);
        if (debug) {
            log.debug((Object)("Do check whether the user : " + userName + " is in role: " + roleName));
            log.debug((Object)("Search filter : " + searchFilter));
            for (String retAttrib : returnedAtts) {
                log.debug((Object)("Requesting attribute: " + retAttrib));
            }
        }
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        try {
            String[] searchBaseArray;
            dirContext = this.connectionSource.getContext();
            if (context.getRoleDNPatterns().size() > 0) {
                for (String pattern : context.getRoleDNPatterns()) {
                    block40: {
                        if (debug) {
                            log.debug((Object)("Using pattern: " + pattern));
                        }
                        searchBases = MessageFormat.format(pattern.trim(), this.escapeSpecialCharactersForDN(roleName));
                        try {
                            answer = dirContext.search(this.escapeDNForSearch(searchBases), searchFilter, searchCtls);
                        }
                        catch (NamingException e) {
                            if (!log.isDebugEnabled()) break block40;
                            log.debug((Object)e);
                        }
                    }
                    if (answer != null && answer.hasMoreElements()) {
                        if (debug) {
                            log.debug((Object)("User: " + userName + " in role: " + roleName));
                        }
                        boolean bl = true;
                        return bl;
                    }
                    if (!debug) continue;
                    log.debug((Object)("User: " + userName + " NOT in role: " + roleName));
                }
                return false;
            }
            if (debug) {
                log.debug((Object)("Do check whether the user: " + userName + " is in role: " + roleName));
                log.debug((Object)("Search filter: " + searchFilter));
                for (String retAttrib : returnedAtts) {
                    log.debug((Object)("Requesting attribute: " + retAttrib));
                }
            }
            searchFilter = "(&" + searchFilter + "(" + membershipProperty + "=" + membershipValue + ") (" + roleNameProperty + "=" + this.escapeSpecialCharactersForFilter(roleName) + "))";
            for (String searchBase : searchBaseArray = searchBases.split("#")) {
                answer = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchCtls);
                if (answer.hasMoreElements()) {
                    if (debug) {
                        log.debug((Object)("User: " + userName + " in role: " + roleName));
                    }
                    boolean bl = true;
                    return bl;
                }
                if (!debug) continue;
                log.debug((Object)("User: " + userName + " NOT in role: " + roleName));
            }
            return false;
        }
        catch (NamingException e) {
            if (!log.isDebugEnabled()) return false;
            log.debug((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
    }

    private void addAllRolesToUserRolesCache(String userName, List<String> roleList) throws UserStoreException {
        String[] internalRoleList = this.doGetInternalRoleListOfUser(userName, "*");
        String[] combinedRoleList = UserCoreUtil.combineArrays(roleList.toArray(new String[roleList.size()]), internalRoleList);
        this.addToUserRolesCache(this.getTenantId(), userName, combinedRoleList);
    }

    @Override
    public Date getPasswordExpirationTime(String username) throws UserStoreException {
        if (username != null && username.contains(CarbonConstants.DOMAIN_SEPARATOR)) {
            return super.getPasswordExpirationTime(username);
        }
        return null;
    }

    @Override
    public int getTenantId(String username) throws UserStoreException {
        throw new UserStoreException("Invalid operation");
    }

    @Override
    public int getUserId(String username) throws UserStoreException {
        throw new UserStoreException("Invalid operation");
    }

    @Override
    public void doDeleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doDeleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    protected void doSetUserAttribute(String userName, String attributeName, String value, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    protected void doSetUserAttributes(String userName, Map<String, String> processedClaimAttributes, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    protected void doSetUserAttributes(String userName, Map<String, List<String>> claimAttributesToAdd, Map<String, List<String>> claimAttributesToDelete, Map<String, List<String>> claimAttributesToReplace, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doDeleteUser(String userName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public Map<String, String> getProperties(Tenant tenant) throws UserStoreException {
        return this.realmConfig.getUserStoreProperties();
    }

    @Override
    public boolean isBulkImportSupported() throws UserStoreException {
        return new Boolean(this.realmConfig.getUserStoreProperty("IsBulkImportSupported"));
    }

    public void addRememberMe(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        JDBCUserStoreManager jdbcUserStore = new JDBCUserStoreManager(this.dataSource, this.realmConfig, this.realmConfig.getTenantId(), false);
        jdbcUserStore.addRememberMe(userName, token);
    }

    public boolean isValidRememberMeToken(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        try {
            if (this.isExistingUser(userName)) {
                JDBCUserStoreManager jdbcUserStore = new JDBCUserStoreManager(this.dataSource, this.realmConfig, this.realmConfig.getTenantId(), false);
                return jdbcUserStore.isExistingRememberMeToken(userName, token);
            }
        }
        catch (Exception e) {
            log.error((Object)("Validating remember me token failed for" + userName));
        }
        return false;
    }

    private boolean isInSearchBase(LdapName name, LdapName searchBase) {
        List<Rdn> baseRdns = searchBase.getRdns();
        return name.startsWith(baseRdns);
    }

    private List<String> getGroupNameAttributeValuesOfGroups(List<LdapName> groupDNs) throws UserStoreException {
        log.debug((Object)"GetGroupNameAttributeValuesOfGroups with DN");
        boolean debug = log.isDebugEnabled();
        String groupNameAttribute = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
        String[] returnedAttributes = new String[]{groupNameAttribute};
        ArrayList<String> groupNameAttributeValues = new ArrayList<String>();
        DirContext dirContext = null;
        try {
            dirContext = this.connectionSource.getContext();
            for (LdapName group : groupDNs) {
                Attribute groupAttribute;
                Rdn rdn;
                if (!this.isInSearchBase(group, new LdapName(this.groupSearchBase))) continue;
                if (debug) {
                    log.debug((Object)("Using DN: " + group));
                }
                if ((rdn = group.getRdn(group.getRdns().size() - 1)).getType().equalsIgnoreCase(groupNameAttribute)) {
                    groupNameAttributeValues.add(rdn.getValue().toString());
                    continue;
                }
                Attributes groupAttributes = dirContext.getAttributes(group, returnedAttributes);
                if (groupAttributes == null || (groupAttribute = groupAttributes.get(groupNameAttribute)) == null) continue;
                String groupNameAttributeValue = (String)groupAttribute.get();
                if (debug) {
                    log.debug((Object)(groupNameAttribute + " : " + groupNameAttributeValue));
                }
                groupNameAttributeValues.add(groupNameAttributeValue);
            }
        }
        catch (UserStoreException e) {
            String errorMessage = "Error in getting group name attribute values of groups";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)((Object)e));
            }
            throw new UserStoreException(errorMessage, (Throwable)((Object)e));
        }
        catch (NamingException e) {
            String errorMessage = "Error in getting group name attribute values of groups";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeContext(dirContext);
        }
        return groupNameAttributeValues;
    }

    public Properties getDefaultUserStoreProperties() {
        Properties properties = new Properties();
        properties.setMandatoryProperties(ReadOnlyLDAPUserStoreConstants.ROLDAP_USERSTORE_PROPERTIES.toArray(new Property[ReadOnlyLDAPUserStoreConstants.ROLDAP_USERSTORE_PROPERTIES.size()]));
        properties.setOptionalProperties(ReadOnlyLDAPUserStoreConstants.OPTIONAL_ROLDAP_USERSTORE_PROPERTIES.toArray(new Property[ReadOnlyLDAPUserStoreConstants.OPTIONAL_ROLDAP_USERSTORE_PROPERTIES.size()]));
        properties.setAdvancedProperties(RO_LDAP_UM_ADVANCED_PROPERTIES.toArray(new Property[RO_LDAP_UM_ADVANCED_PROPERTIES.size()]));
        return properties;
    }

    @Override
    public boolean isSharedRole(String roleName, String roleNameBase) {
        String sharedRoleBase;
        return super.isSharedRole(roleName, roleNameBase) && roleNameBase != null && roleNameBase.contains(sharedRoleBase = (String)this.realmConfig.getUserStoreProperties().get("SharedGroupSearchBase"));
    }

    @Override
    protected boolean isOwnRole(String roleName) {
        String[] nameArray = roleName.split("@");
        if (nameArray.length > 1) {
            String currentTenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            return currentTenantDomain.equalsIgnoreCase(nameArray[1]);
        }
        return super.isOwnRole(roleName);
    }

    @Override
    protected RoleContext createRoleContext(String roleName) {
        String[] rolePortions;
        LDAPRoleContext roleContext = new LDAPRoleContext();
        if (this.isSharedGroupEnabled()) {
            rolePortions = roleName.split("@");
            if (rolePortions.length > 1 && (rolePortions[1] == null || rolePortions[1].equals("null"))) {
                rolePortions = new String[]{rolePortions[0]};
            }
        } else {
            rolePortions = new String[]{roleName};
        }
        boolean shared = false;
        if (rolePortions.length == 1) {
            roleContext.setSearchBase(this.realmConfig.getUserStoreProperty("GroupSearchBase"));
            roleContext.setTenantDomain(CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
        } else if (rolePortions.length > 1) {
            roleContext.setTenantDomain(rolePortions[1]);
            String base = this.realmConfig.getUserStoreProperty("SharedGroupSearchBase");
            if (!rolePortions[1].equalsIgnoreCase("carbon.super")) {
                String groupNameAttributeName = this.realmConfig.getUserStoreProperty("SharedTenantNameAttribute");
                base = groupNameAttributeName + "=" + this.escapeSpecialCharactersForDN(rolePortions[1]) + "," + base;
            }
            String roleDNPattern = this.realmConfig.getUserStoreProperty("GroupNameAttribute") + "={0}," + base;
            roleContext.setSearchBase(base);
            roleContext.addRoleDNPatterns(roleDNPattern);
            shared = true;
        }
        if (shared) {
            roleContext.setSearchFilter(this.realmConfig.getUserStoreProperty("GroupNameSearchFilter"));
            roleContext.setRoleNameProperty(this.realmConfig.getUserStoreProperty("GroupNameAttribute"));
            roleContext.setListFilter(this.realmConfig.getUserStoreProperty("GroupNameListFilter"));
            roleContext.setGroupEntryObjectClass(this.realmConfig.getUserStoreProperty("GroupEntryObjectClass"));
        } else {
            roleContext.setSearchFilter(this.realmConfig.getUserStoreProperty("GroupNameSearchFilter"));
            roleContext.setRoleNameProperty(this.realmConfig.getUserStoreProperty("GroupNameAttribute"));
            roleContext.setListFilter(this.realmConfig.getUserStoreProperty("GroupNameListFilter"));
            roleContext.setGroupEntryObjectClass(this.realmConfig.getUserStoreProperty("GroupEntryObjectClass"));
            String roleDNPattern = this.realmConfig.getUserStoreProperty("RoleDNPattern");
            if (roleDNPattern != null && roleDNPattern.trim().length() > 0) {
                if (roleDNPattern.contains("#")) {
                    String[] patterns;
                    for (String pattern : patterns = roleDNPattern.split("#")) {
                        roleContext.addRoleDNPatterns(pattern);
                    }
                } else {
                    roleContext.addRoleDNPatterns(roleDNPattern);
                }
            }
        }
        roleContext.setRoleName(rolePortions[0]);
        roleContext.setShared(shared);
        return roleContext;
    }

    private String escapeLdapNameForFilter(LdapName ldn) {
        if (ldn == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Received null value to escape special characters. Returning null");
            }
            return null;
        }
        boolean replaceEscapeCharacters = true;
        String replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin");
        if (replaceEscapeCharactersAtUserLoginString != null) {
            replaceEscapeCharacters = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replace escape characters configured to: " + replaceEscapeCharactersAtUserLoginString));
            }
        }
        if (replaceEscapeCharacters) {
            String escapedDN = "";
            for (int i = ldn.size() - 1; i > -1; --i) {
                escapedDN = escapedDN + this.escapeSpecialCharactersForFilterWithStarAsRegex(ldn.get(i));
                if (i == 0) continue;
                escapedDN = escapedDN + ",";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Escaped DN value for filter : " + escapedDN));
            }
            return escapedDN;
        }
        return ldn.toString();
    }

    private String escapeSpecialCharactersForFilterWithStarAsRegex(String dnPartial) {
        boolean replaceEscapeCharacters = true;
        String replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin");
        if (replaceEscapeCharactersAtUserLoginString != null) {
            replaceEscapeCharacters = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replace escape characters configured to: " + replaceEscapeCharactersAtUserLoginString));
            }
        }
        if (replaceEscapeCharacters) {
            StringBuilder sb = new StringBuilder();
            block6: for (int i = 0; i < dnPartial.length(); ++i) {
                char currentChar = dnPartial.charAt(i);
                switch (currentChar) {
                    case '\\': {
                        if (dnPartial.charAt(i + 1) == '*') {
                            sb.append("\\2a");
                            ++i;
                            continue block6;
                        }
                        sb.append("\\5c");
                        continue block6;
                    }
                    case '(': {
                        sb.append("\\28");
                        continue block6;
                    }
                    case ')': {
                        sb.append("\\29");
                        continue block6;
                    }
                    case '\u0000': {
                        sb.append("\\00");
                        continue block6;
                    }
                    default: {
                        sb.append(currentChar);
                    }
                }
            }
            return sb.toString();
        }
        return dnPartial;
    }

    private String escapeSpecialCharactersForFilter(String dnPartial) {
        boolean replaceEscapeCharacters = true;
        dnPartial.replace("\\*", "*");
        String replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin");
        if (replaceEscapeCharactersAtUserLoginString != null) {
            replaceEscapeCharacters = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replace escape characters configured to: " + replaceEscapeCharactersAtUserLoginString));
            }
        }
        if (replaceEscapeCharacters) {
            StringBuilder sb = new StringBuilder();
            block7: for (int i = 0; i < dnPartial.length(); ++i) {
                char currentChar = dnPartial.charAt(i);
                switch (currentChar) {
                    case '\\': {
                        sb.append("\\5c");
                        continue block7;
                    }
                    case '*': {
                        sb.append("\\2a");
                        continue block7;
                    }
                    case '(': {
                        sb.append("\\28");
                        continue block7;
                    }
                    case ')': {
                        sb.append("\\29");
                        continue block7;
                    }
                    case '\u0000': {
                        sb.append("\\00");
                        continue block7;
                    }
                    default: {
                        sb.append(currentChar);
                    }
                }
            }
            return sb.toString();
        }
        return dnPartial;
    }

    private String escapeSpecialCharactersForDN(String text) {
        boolean replaceEscapeCharacters = true;
        text.replace("\\*", "*");
        String replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin");
        if (replaceEscapeCharactersAtUserLoginString != null) {
            replaceEscapeCharacters = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replace escape characters configured to: " + replaceEscapeCharactersAtUserLoginString));
            }
        }
        if (replaceEscapeCharacters) {
            StringBuilder sb = new StringBuilder();
            if (text.length() > 0 && (text.charAt(0) == ' ' || text.charAt(0) == '#')) {
                sb.append('\\');
            }
            block10: for (int i = 0; i < text.length(); ++i) {
                char currentChar = text.charAt(i);
                switch (currentChar) {
                    case '\\': {
                        sb.append("\\\\");
                        continue block10;
                    }
                    case ',': {
                        sb.append("\\,");
                        continue block10;
                    }
                    case '+': {
                        sb.append("\\+");
                        continue block10;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        continue block10;
                    }
                    case '<': {
                        sb.append("\\<");
                        continue block10;
                    }
                    case '>': {
                        sb.append("\\>");
                        continue block10;
                    }
                    case ';': {
                        sb.append("\\;");
                        continue block10;
                    }
                    case '*': {
                        sb.append("\\2a");
                        continue block10;
                    }
                    default: {
                        sb.append(currentChar);
                    }
                }
            }
            if (text.length() > 1 && text.charAt(text.length() - 1) == ' ') {
                sb.insert(sb.length() - 1, '\\');
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("value after escaping special characters in " + text + " : " + sb.toString()));
            }
            return sb.toString();
        }
        return text;
    }

    protected Name escapeDNForSearch(String dn) throws InvalidNameException {
        return new CompositeName().add(dn);
    }

    protected boolean isIgnorePartialResultException() {
        return PROPERTY_REFERRAL_IGNORE.equals(this.realmConfig.getUserStoreProperty("Referral"));
    }

    private static void setAdvancedProperties() {
        RO_LDAP_UM_ADVANCED_PROPERTIES.clear();
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("PasswordHashMethod", "Password Hashing Algorithm", "PLAIN_TEXT", "Password Hash method to use when storing user entries");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty(MULTI_ATTRIBUTE_SEPARATOR, "Multiple Attribute Separator", ",", MULTI_ATTRIBUTE_SEPARATOR_DESCRIPTION);
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("MaxUserNameListLength", "Maximum User List Length", "100", "Maximum number of users retrieved at once");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("MaxRoleNameListLength", "Maximum Role List Length", "100", "Maximum number of groups retrieved at once");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("UserRolesCacheEnabled", "Enable User Role Cache", "true", "This is to indicate whether to cache the group list of a user");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("ConnectionPoolingEnabled", "Enable LDAP Connection Pooling", "false", "Set this property to enable LDAP connection pooling.");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty(LDAPConnectionTimeout, LDAPConnectionTimeoutDescription, "5000", LDAPConnectionTimeoutDescription);
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty(readTimeout, "LDAP Read Timeout", "5000", readTimeoutDescription);
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty(RETRY_ATTEMPTS, "Retry Attempts", "0", "Number of retries for authentication in case ldap read timed out.");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("CountRetrieverClass", "Count Implementation", "", "Name of the class that implements the count functionality");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("java.naming.ldap.attributes.binary", "LDAP binary attributes", " ", LDAPBinaryAttributesDescription);
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("ClaimOperationsSupported", "Claim Operations Supported", "false", "Whether the userstore supports claim read and write");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty(MEMBERSHIP_ATTRIBUTE_RANGE, MEMBERSHIP_ATTRIBUTE_RANGE_DISPLAY_NAME, String.valueOf(0), "Number of maximum users of role returned by the LDAP");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("UserCacheExpiryMilliseconds", USER_CACHE_EXPIRY_TIME_ATTRIBUTE_NAME, "", USER_CACHE_EXPIRY_TIME_ATTRIBUTE_DESCRIPTION);
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("UserDNCacheEnabled", USER_DN_CACHE_ENABLED_ATTRIBUTE_NAME, "true", USER_DN_CACHE_ENABLED_ATTRIBUTE_DESCRIPTION);
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("StartTLSEnabled", "Enable StartTLS", "false", "Enable secure connection by using StartTLS extended operation in LDAP");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("ConnectionRetryDelay", "Connection Retry Delay", String.valueOf(120000), "Specifies waiting time in milliseconds inorder to establish the connection after couple of failure attempts.");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("SSLCertificateValidationEnabled", "Enable SSL certificate validation", "true", "Set/Unset this property to enable/disable certificate validation for LDAPS connections");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("ImmutableAttributes", "Immutable Attributes", " ", "Comma-separated list of user store maintained immutable attributes");
        ReadOnlyLDAPUserStoreManager.setAdvancedProperty("TimestampAttributes", "Timestamp Attributes", " ", "Comma-separated list of user store attributes having the data type of Timestamp and may require a conversion when reading from/writing to user store");
    }

    private static void setAdvancedProperty(String name, String displayName, String value, String description) {
        Property property = new Property(name, value, displayName + "#" + description, null);
        RO_LDAP_UM_ADVANCED_PROPERTIES.add(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initUserCache() throws UserStoreException {
        RealmService realmService;
        if (!this.userDnCacheEnabled) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User DN cache is disabled in configuration on UserStore having SearchBase: " + this.userSearchBase));
            }
            return;
        }
        boolean isUserDnCacheCustomExpiryValuePresent = false;
        if (StringUtils.isNotEmpty((String)this.cacheExpiryTimeAttribute)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache expiry time : " + this.cacheExpiryTimeAttribute + " configured for the user DN cache having search base: " + this.userSearchBase));
            }
            try {
                this.userDnCacheExpiryTime = Long.parseLong(this.cacheExpiryTimeAttribute);
                isUserDnCacheCustomExpiryValuePresent = true;
            }
            catch (NumberFormatException nfe) {
                log.error((Object)("Could not convert the cache expiry time to Number (long) : " + this.cacheExpiryTimeAttribute + " . Will default to system wide expiry settings."), (Throwable)nfe);
            }
        }
        if ((realmService = UserStoreMgtDSComponent.getRealmService()) != null && realmService.getTenantManager() != null) {
            try {
                this.tenantDomain = realmService.getTenantManager().getDomain(this.tenantId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Tenant domain : " + this.tenantDomain + " found for the tenant ID : " + this.tenantId));
                }
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException("Could not get the tenant domain for tenant id : " + this.tenantId, e);
            }
        }
        if (this.tenantDomain == null && this.tenantId == -1234) {
            this.tenantDomain = "carbon.super";
        }
        if (this.tenantDomain == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not find a tenant domain for the tenant ID : " + this.tenantId + ". Not initializing the User DN cache."));
            }
            return;
        }
        try {
            this.startTenantFlow();
            this.userDnCacheName = USER_CACHE_NAME_PREFIX + this.hashCode();
            this.cacheManager = Caching.getCacheManagerFactory().getCacheManager(USER_CACHE_MANAGER);
            this.cacheManager.removeCache(this.userDnCacheName);
            if (isUserDnCacheCustomExpiryValuePresent) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using cache expiry time : " + this.userDnCacheExpiryTime + " configured for the user DN cache having search base: " + this.userSearchBase));
                }
                this.userDnCacheBuilder = this.cacheManager.createCacheBuilder(this.userDnCacheName);
                this.userDnCacheBuilder.setExpiry(CacheConfiguration.ExpiryType.ACCESSED, new CacheConfiguration.Duration(TimeUnit.MILLISECONDS, this.userDnCacheExpiryTime)).setExpiry(CacheConfiguration.ExpiryType.MODIFIED, new CacheConfiguration.Duration(TimeUnit.MILLISECONDS, this.userDnCacheExpiryTime)).setStoreByValue(false);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putToUserCache(String name, LdapName value) {
        try {
            this.startTenantFlow();
            Cache<String, LdapName> userDnCache = this.createOrGetUserDnCache();
            if (userDnCache == null) {
                return;
            }
            userDnCache.put((Object)name, (Object)value);
        }
        catch (IllegalStateException e) {
            log.error((Object)("Error occurred while putting User DN to the cache having search base : " + this.userSearchBase), (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LdapName getFromUserCache(String userName) {
        try {
            this.startTenantFlow();
            Cache<String, LdapName> userDnCache = this.createOrGetUserDnCache();
            if (userDnCache == null) {
                LdapName ldapName = null;
                return ldapName;
            }
            LdapName ldapName = (LdapName)userDnCache.get((Object)userName);
            return ldapName;
        }
        catch (IllegalStateException e) {
            log.error((Object)("Error occurred while getting User DN from cache having search base : " + this.userSearchBase), (Throwable)e);
            LdapName ldapName = null;
            return ldapName;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFromUserCache(String userName) {
        try {
            this.startTenantFlow();
            Cache<String, LdapName> userDnCache = this.createOrGetUserDnCache();
            if (userDnCache == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = userDnCache.remove((Object)userName);
            return bl;
        }
        catch (IllegalStateException e) {
            log.error((Object)("Error occurred while removing User DN from cache having search base : " + this.userSearchBase), (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void startTenantFlow() {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantId(this.tenantId);
        carbonContext.setTenantDomain(this.tenantDomain);
    }

    private Cache<String, LdapName> createOrGetUserDnCache() {
        Cache userDnCache;
        if (this.cacheManager == null || !this.userDnCacheEnabled) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not using the cache on UserDN. cacheManager: " + this.cacheManager + " , Enabled : " + this.userDnCacheEnabled));
            }
            return null;
        }
        if (this.userDnCacheBuilder != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using cache bulder to get the cache, for UserSearchBase: " + this.userSearchBase));
            }
            userDnCache = this.userDnCacheBuilder.build();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using default configurations for the user DN cache, having search base : " + this.userSearchBase));
            }
            userDnCache = this.cacheManager.getCache(this.userDnCacheName);
        }
        return userDnCache;
    }

    protected void finalize() throws Throwable {
        if (this.cacheManager != null && this.userDnCacheName != null) {
            try {
                this.startTenantFlow();
                this.cacheManager.removeCache(this.userDnCacheName);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        super.finalize();
    }

    @Override
    public boolean isUniqueUserIdEnabled() {
        return false;
    }

    protected boolean isBinaryUserAttribute(String attributeName) {
        String ldapBinaryAttributesProperty = Optional.ofNullable(this.realmConfig.getUserStoreProperty("java.naming.ldap.attributes.binary")).orElse("");
        Object[] ldapBinaryAttributes = StringUtils.split((String)ldapBinaryAttributesProperty, (String)",");
        if (ArrayUtils.isNotEmpty((Object[])ldapBinaryAttributes)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("LDAP binary attributes: " + Arrays.toString(ldapBinaryAttributes)));
            }
            return ArrayUtils.contains((Object[])ldapBinaryAttributes, (Object)attributeName);
        }
        return false;
    }

    protected boolean isGUIDValue(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            Matcher matcher = OBJECT_GUID_PATTERN.matcher(value);
            return matcher.find();
        }
        return false;
    }

    @Override
    protected void processAttributesAfterRetrieval(String userName, Map<String, String> userStorePropertyValues, String profileName) {
        String timestampAttributesProperty = Optional.ofNullable(this.realmConfig.getUserStoreProperty("TimestampAttributes")).orElse("");
        Object[] timestampAttributes = StringUtils.split((String)timestampAttributesProperty, (String)",");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read only user store  timestamp attributes: " + Arrays.toString(timestampAttributes)));
        }
        if (ArrayUtils.isNotEmpty((Object[])timestampAttributes)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieved user store properties before type conversions: " + userStorePropertyValues));
            }
            Map convertedTimestampAttributeValues = Arrays.stream(timestampAttributes).map(StringUtils::trim).filter(attribute -> userStorePropertyValues.get(attribute) != null).collect(Collectors.toMap(Function.identity(), attribute -> this.convertDateFormatFromLDAP((String)userStorePropertyValues.get(attribute))));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converted timestamp attribute values: " + convertedTimestampAttributeValues));
            }
            userStorePropertyValues.putAll(convertedTimestampAttributeValues);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieved user store properties after type conversions: " + userStorePropertyValues));
            }
        }
    }

    protected String convertDateFormatFromLDAP(String date) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(GENARALIZE_DATE_TIME_FORMAT);
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(date, dateTimeFormatter);
        Instant instant = offsetDateTime.toInstant();
        return instant.toString();
    }

    static {
        log = LogFactory.getLog(ReadOnlyLDAPUserStoreManager.class);
        RO_LDAP_UM_ADVANCED_PROPERTIES = new ArrayList();
        logger = LogFactory.getLog(ReadOnlyLDAPUserStoreManager.class);
        ReadOnlyLDAPUserStoreManager.setAdvancedProperties();
        OBJECT_GUID_PATTERN = Pattern.compile(OBJECT_GUID_REGEX, 2);
    }
}

