/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.util.ArrayList;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.core.constants.UserStoreUIConstants;

public class ReadOnlyLDAPUserStoreConstants {
    public static final ArrayList<Property> ROLDAP_USERSTORE_PROPERTIES = new ArrayList();
    public static final ArrayList<Property> UNIQUE_ID_ROLDAP_USERSTORE_PROPERTIES = new ArrayList();
    public static final ArrayList<Property> OPTIONAL_ROLDAP_USERSTORE_PROPERTIES = new ArrayList();
    private static final String MULTI_ATTRIBUTE_SEPARATOR = "MultiAttributeSeparator";
    private static final String MULTI_ATTRIBUTE_SEPARATOR_DESCRIPTION = "This is the separator for multiple claim values";
    private static final String DisplayNameAttributeDescription = "Attribute name to display as the Display Name";
    private static final String DisplayNameAttribute = "DisplayNameAttribute";
    private static final String roleDNPattern = "RoleDNPattern";
    private static final String roleDNPatternDescription = "The patten for groups's DN. It can be defined to improve the LDAP search";

    private static void setMandatoryProperty(String name, String displayName, String value, String description, boolean encrypt, Property[] childProperties) {
        String propertyDescription = displayName + "#" + description;
        if (encrypt) {
            propertyDescription = propertyDescription + "#encrypt";
        }
        Property property = new Property(name, value, propertyDescription, childProperties);
        ROLDAP_USERSTORE_PROPERTIES.add(property);
    }

    private static void setMandatoryPropertyForUniqueIdStore(String name, String displayName, String value, String description, boolean encrypt, Property[] childProperties) {
        String propertyDescription = displayName + "#" + description;
        if (encrypt) {
            propertyDescription = propertyDescription + "#encrypt";
        }
        Property property = new Property(name, value, propertyDescription, childProperties);
        UNIQUE_ID_ROLDAP_USERSTORE_PROPERTIES.add(property);
    }

    private static void setProperty(String name, String displayName, String value, String description, Property[] childProperties) {
        Property property = new Property(name, value, displayName + "#" + description, childProperties);
        OPTIONAL_ROLDAP_USERSTORE_PROPERTIES.add(property);
    }

    static {
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("ConnectionURL", "Connection URL", "ldap://", "Connection URL for the user store", false, new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("ConnectionName", "Connection Name", "uid=,ou=", "This should be a DN (Distinguish Name) of a user with sufficient permissions to perform operations on users and groups in LDAP", false, new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("ConnectionPassword", "Connection Password", "", "Password of the admin user", true, new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.PASSWORD.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("UserSearchBase", "User Search Base", "ou=Users,dc=wso2,dc=org", "DN of the context under which user entries are stored in LDAP", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("UserNameAttribute", "Username Attribute", "uid", "Attribute used for uniquely identifying a user entry. Users can be authenticated using their email address, uid and etc", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("UserNameSearchFilter", "User Search Filter", "(&(objectClass=person)(uid=?))", "Filtering criteria for searching a particular user entry", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("UserNameListFilter", "User List Filter", "(objectClass=person)", "Filtering criteria for listing all the user entries in LDAP", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setMandatoryPropertyForUniqueIdStore("UserIDAttribute", "User ID Attribute", "scimId", "Attribute used for uniquely identifying a user entry.", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setMandatoryPropertyForUniqueIdStore("UserIdSearchFilter", "User ID Search Filter", "(&(objectClass=person)(uid=?))", "Filtering criteria for searching a particular user entry", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("UserDNPattern", "User DN Pattern", "", "The patten for user's DN. It can be defined to improve the LDAP search", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty(DisplayNameAttribute, "Display name attribute", "", DisplayNameAttributeDescription, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("Disabled", "Disabled", "false", "Whether user store is disabled", new Property[]{UserStoreUIConstants.DataCategory.BASIC.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("ReadGroups", "Read Groups", "true", "Specifies whether groups should be read from LDAP", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("GroupSearchBase", "Group Search Base", "ou=Groups,dc=wso2,dc=org", "DN of the context under which user entries are stored in LDAP", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("GroupNameAttribute", "Group Name Attribute", "cn", "Attribute used for uniquely identifying a user entry", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("GroupNameSearchFilter", "Group Search Filter", "(&(objectClass=groupOfNames)(cn=?))", "Filtering criteria for searching a particular group entry", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("GroupNameListFilter", "Group List Filter", "(objectClass=groupOfNames)", "Filtering criteria for listing all the group entries in LDAP", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty(roleDNPattern, "Group DN Pattern", "", roleDNPatternDescription, new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("MembershipAttribute", "Membership Attribute", "member", "Attribute used to define members of LDAP groups", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("MemberOfAttribute", "Member Of Attribute", "", "MemberOfAttribute", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("BackLinksEnabled", "Enable Back Links", "false", " Whether to allow attributes to be result from references to the object from other objects", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("Referral", "Referral", "follow", "Guides the requests to a domain controller in the correct domain", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("ReplaceEscapeCharactersAtUserLogin", "Enable Escape Characters at User Login", "true", "Whether replace escape character when user login", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("UniqueID", "", "", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("LDAPInitialContextFactory", "LDAP Initial Context Factory", "com.sun.jndi.ldap.LdapCtxFactory", "The property to set LDAP Initial Context Factory", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("DateAndTimePattern", "", "Date And Time Pattern", "Pattern of Date and Time values are stored, if not specified default timestamp representation is used.", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ReadOnlyLDAPUserStoreConstants.setProperty("CaseInsensitiveUsername", "Case Insensitive Username", "true", "Whether the username is case sensitive or not", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
    }
}

