/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.user.core.model.ExpressionCondition;
import org.wso2.carbon.user.core.model.ExpressionOperation;

public class LDAPFilterQueryBuilder {
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSE_PARENTHESIS = ")";
    private static final String AND_OPERATION = "&";
    private static final String OR_OPERATION = "|";
    private static final String EQUALS_SIGN = "=";
    private static final String GREATER_THAN_SIGN = ">";
    private static final String LESS_THAN_SIGN = "<";
    private static final String ANY_STRING = "*";
    private StringBuilder searchFilter;
    private StringBuilder membershipMultiGroupFilters;

    public LDAPFilterQueryBuilder(String searchFilter) {
        this.searchFilter = new StringBuilder(OPEN_PARENTHESIS).append(AND_OPERATION).append(searchFilter);
        this.membershipMultiGroupFilters = new StringBuilder();
    }

    public void addFilter(ExpressionCondition condition, boolean isMembershipMultiGroupFilters) {
        String property = condition.getAttributeName();
        String operation = condition.getOperation();
        String value = condition.getAttributeValue();
        if (isMembershipMultiGroupFilters) {
            this.buildFilter(this.membershipMultiGroupFilters, property, operation, value);
        } else {
            this.buildFilter(this.searchFilter, property, operation, value);
        }
    }

    private void buildFilter(StringBuilder queryBuilder, String property, String operation, String value) {
        if (ExpressionOperation.EQ.toString().equals(operation)) {
            queryBuilder.append(this.equalFilterBuilder(property, value));
        } else if (ExpressionOperation.CO.toString().equals(operation)) {
            queryBuilder.append(this.containsFilterBuilder(property, value));
        } else if (ExpressionOperation.EW.toString().equals(operation)) {
            queryBuilder.append(this.endWithFilterBuilder(property, value));
        } else if (ExpressionOperation.SW.toString().equals(operation)) {
            queryBuilder.append(this.startWithFilterBuilder(property, value));
        } else if (ExpressionOperation.GE.toString().equals(operation)) {
            queryBuilder.append(this.greaterThanOrEqualFilterBuilder(property, value));
        } else if (ExpressionOperation.LE.toString().equals(operation)) {
            queryBuilder.append(this.lessThanOrEqualFilterBuilder(property, value));
        }
    }

    private String equalFilterBuilder(String property, String value) {
        StringBuilder filter = new StringBuilder();
        filter.append(OPEN_PARENTHESIS).append(property).append(EQUALS_SIGN).append(value).append(CLOSE_PARENTHESIS);
        return filter.toString();
    }

    private String containsFilterBuilder(String property, String value) {
        StringBuilder filter = new StringBuilder();
        filter.append(OPEN_PARENTHESIS).append(property).append(EQUALS_SIGN).append(ANY_STRING).append(value).append(ANY_STRING).append(CLOSE_PARENTHESIS);
        return filter.toString();
    }

    private String endWithFilterBuilder(String property, String value) {
        StringBuilder filter = new StringBuilder();
        filter.append(OPEN_PARENTHESIS).append(property).append(EQUALS_SIGN).append(ANY_STRING).append(value).append(CLOSE_PARENTHESIS);
        return filter.toString();
    }

    private String startWithFilterBuilder(String property, String value) {
        StringBuilder filter = new StringBuilder();
        filter.append(OPEN_PARENTHESIS).append(property).append(EQUALS_SIGN).append(value).append(ANY_STRING).append(CLOSE_PARENTHESIS);
        return filter.toString();
    }

    private String lessThanOrEqualFilterBuilder(String property, String value) {
        StringBuilder filter = new StringBuilder();
        filter.append(OPEN_PARENTHESIS).append(property).append(LESS_THAN_SIGN).append(EQUALS_SIGN).append(value).append(CLOSE_PARENTHESIS);
        return filter.toString();
    }

    private String greaterThanOrEqualFilterBuilder(String property, String value) {
        StringBuilder filter = new StringBuilder();
        filter.append(OPEN_PARENTHESIS).append(property).append(GREATER_THAN_SIGN).append(EQUALS_SIGN).append(value).append(CLOSE_PARENTHESIS);
        return filter.toString();
    }

    public String getSearchFilterQuery() {
        if (this.searchFilter != null) {
            if (StringUtils.isNotEmpty((String)this.membershipMultiGroupFilters.toString())) {
                this.searchFilter.append(OPEN_PARENTHESIS).append(OR_OPERATION).append((CharSequence)this.membershipMultiGroupFilters).append(CLOSE_PARENTHESIS);
            }
            this.searchFilter.append(CLOSE_PARENTHESIS);
            return String.valueOf(this.searchFilter);
        }
        return "";
    }
}

