/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.Properties;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.RoleContext;
import org.wso2.carbon.user.core.ldap.ActiveDirectoryUserStoreConstants;
import org.wso2.carbon.user.core.ldap.LDAPConstants;
import org.wso2.carbon.user.core.ldap.ReadWriteLDAPUserStoreManager;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.JNDIUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.Secret;
import org.wso2.carbon.utils.UnsupportedSecretTypeException;

public class ActiveDirectoryUserStoreManager
extends ReadWriteLDAPUserStoreManager {
    private static Log logger = LogFactory.getLog(ActiveDirectoryUserStoreManager.class);
    private boolean isADLDSRole = false;
    private boolean isSSLConnection = false;
    private String userAccountControl = "512";
    private String userAttributeSeparator = ",";
    private static final String MULTI_ATTRIBUTE_SEPARATOR = "MultiAttributeSeparator";
    private static final String MULTI_ATTRIBUTE_SEPARATOR_DESCRIPTION = "This is the separator for multiple claim values";
    private static final ArrayList<Property> ACTIVE_DIRECTORY_UM_ADVANCED_PROPERTIES = new ArrayList();
    private static final String LDAPConnectionTimeout = "LDAPConnectionTimeout";
    private static final String LDAPConnectionTimeoutDescription = "LDAP Connection Timeout";
    private static final String BULK_IMPORT_SUPPORT = "BulkImportSupported";
    private static final String readTimeout = "ReadTimeout";
    private static final String readTimeoutDescription = "Configure this to define the read timeout for LDAP operations";
    private static final String RETRY_ATTEMPTS = "RetryAttempts";
    private static final String LDAPBinaryAttributesDescription = "Configure this to define the LDAP binary attributes seperated by a space. Ex:mpegVideo mySpecialKey";
    private static final String ACTIVE_DIRECTORY_DATE_TIME_FORMAT = "uuuuMMddHHmmss[,S][.S]X";
    protected static final int MEMBERSHIP_ATTRIBUTE_RANGE_VALUE = 1500;

    public ActiveDirectoryUserStoreManager() {
    }

    public ActiveDirectoryUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        super(realmConfig, properties, claimManager, profileManager, realm, tenantId);
        this.checkRequiredUserStoreConfigurations();
    }

    public ActiveDirectoryUserStoreManager(RealmConfiguration realmConfig, ClaimManager claimManager, ProfileConfigurationManager profileManager) throws UserStoreException {
        super(realmConfig, claimManager, profileManager);
        this.checkRequiredUserStoreConfigurations();
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        this.addUser(userName, credential, roleList, claims, profileName, false);
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        Secret credentialObj;
        boolean isUserBinded = false;
        DirContext dirContext = this.getSearchBaseDirectoryContext();
        BasicAttributes basicAttributes = this.getAddUserBasicAttributes(userName);
        if (!this.isADLDSRole) {
            BasicAttribute userAccountControl = new BasicAttribute("userAccountControl");
            userAccountControl.add(LDAPConstants.ACTIVE_DIRECTORY_DISABLED_NORMAL_ACCOUNT);
            basicAttributes.put(userAccountControl);
        }
        this.setUserClaims(claims, basicAttributes, userName);
        try {
            credentialObj = Secret.getSecret((Object)credential);
        }
        catch (UnsupportedSecretTypeException e) {
            throw new UserStoreException("Unsupported credential type", e);
        }
        Name compoundName = null;
        try {
            NameParser ldapParser = dirContext.getNameParser("");
            compoundName = ldapParser.parse("cn=" + this.escapeSpecialCharactersForDN(userName));
            dirContext.bind(compoundName, null, (Attributes)basicAttributes);
            isUserBinded = true;
            this.doUpdateRoleListOfUser(userName, null, roleList);
            if (!this.isSSLConnection) {
                logger.warn((Object)"Unsecured connection is being used. Enabling user account operation will fail");
            }
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("unicodePwd", this.createUnicodePassword(credentialObj))), this.isADLDSRole ? new ModificationItem(2, new BasicAttribute("msDS-UserAccountDisabled", "FALSE")) : new ModificationItem(2, new BasicAttribute("userAccountControl", this.userAccountControl))};
            dirContext.modifyAttributes(compoundName, mods);
        }
        catch (NamingException e) {
            String errorMessage = "Error while adding the user to the Active Directory for user : " + userName;
            if (isUserBinded) {
                try {
                    dirContext.unbind(compoundName);
                }
                catch (NamingException e1) {
                    errorMessage = "Error while accessing the Active Directory for user : " + userName;
                    throw new UserStoreException(errorMessage, e);
                }
                errorMessage = "Error while enabling the user account. Please check password policy at DC for user : " + userName;
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            credentialObj.clear();
            JNDIUtil.closeContext(dirContext);
        }
    }

    @Override
    protected void setUserClaims(Map<String, String> claims, BasicAttributes basicAttributes, String userName) throws UserStoreException {
        if (claims != null) {
            HashMap<String, String> attributeValueMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : claims.entrySet()) {
                String attributeName2;
                String claimURI;
                if ("".equals(entry.getValue()) || (claimURI = entry.getKey()).equals("profileConfiguration")) continue;
                try {
                    attributeName2 = this.getClaimAtrribute(claimURI, userName, null);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e) {
                    String errorMessage = "Error in obtaining claim mapping.";
                    throw new UserStoreException(errorMessage, e);
                }
                attributeValueMap.put(attributeName2, entry.getValue());
            }
            this.processAttributesBeforeUpdate(userName, attributeValueMap, null);
            attributeValueMap.forEach((attributeName, attributeValue) -> {
                BasicAttribute claim = new BasicAttribute((String)attributeName);
                if (attributeValue != null) {
                    String claimSeparator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
                    if (claimSeparator != null && !claimSeparator.trim().isEmpty()) {
                        this.userAttributeSeparator = claimSeparator;
                    }
                    if (attributeValue.contains(this.userAttributeSeparator)) {
                        StringTokenizer st = new StringTokenizer((String)attributeValue, this.userAttributeSeparator);
                        while (st.hasMoreElements()) {
                            String newVal = st.nextElement().toString();
                            if (newVal == null || newVal.trim().length() <= 0) continue;
                            claim.add(newVal.trim());
                        }
                    } else {
                        claim.add(attributeValue);
                    }
                } else {
                    claim.add(attributeValue);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AttributeName: " + attributeName + " AttributeValue: " + attributeValue));
                }
                basicAttributes.put(claim);
            });
        }
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        Secret credentialObj;
        if (!this.isSSLConnection) {
            logger.warn((Object)"Unsecured connection is being used. Password operations will fail");
        }
        DirContext dirContext = this.connectionSource.getContext();
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        searchFilter = searchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
        SearchControls searchControl = new SearchControls();
        String[] returningAttributes = new String[]{"CN"};
        searchControl.setReturningAttributes(returningAttributes);
        searchControl.setSearchScope(2);
        DirContext subDirContext = null;
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            credentialObj = Secret.getSecret((Object)newCredential);
        }
        catch (UnsupportedSecretTypeException e) {
            throw new UserStoreException("Unsupported credential type", e);
        }
        if (logger.isDebugEnabled()) {
            try {
                if (dirContext != null) {
                    logger.debug((Object)("Searching for user with SearchFilter: " + searchFilter + " in SearchBase: " + dirContext.getNameInNamespace()));
                }
            }
            catch (NamingException e) {
                logger.debug((Object)"Error while getting DN of search base", (Throwable)e);
            }
        }
        try {
            searchResults = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchControl);
            SearchResult user = null;
            int count = 0;
            while (searchResults.hasMoreElements()) {
                if (count > 0) {
                    throw new UserStoreException("There are more than one result in the user store for user: " + userName);
                }
                user = searchResults.next();
                ++count;
            }
            if (user == null) {
                throw new UserStoreException("User :" + userName + " does not Exist");
            }
            ModificationItem[] mods = null;
            if (oldCredential != null && newCredential != null) {
                mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("unicodePwd", this.createUnicodePassword(credentialObj)))};
            }
            subDirContext = (DirContext)dirContext.lookup(this.escapeDNForSearch(searchBase));
            subDirContext.modifyAttributes(user.getName(), mods);
        }
        catch (NamingException e) {
            try {
                String error = "Can not access the directory service for user : " + userName;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)error, (Throwable)e);
                }
                throw new UserStoreException(error, e);
            }
            catch (Throwable throwable) {
                credentialObj.clear();
                JNDIUtil.closeNamingEnumeration(searchResults);
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
                throw throwable;
            }
        }
        credentialObj.clear();
        JNDIUtil.closeNamingEnumeration(searchResults);
        JNDIUtil.closeContext(subDirContext);
        JNDIUtil.closeContext(dirContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        block19: {
            if (!this.isSSLConnection) {
                logger.warn((Object)"Unsecured connection is being used. Password operations will fail");
            }
            DirContext dirContext = this.connectionSource.getContext();
            String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
            String searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
            searchFilter = searchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
            SearchControls searchControl = new SearchControls();
            String[] returningAttributes = new String[]{"CN"};
            searchControl.setReturningAttributes(returningAttributes);
            searchControl.setSearchScope(2);
            DirContext subDirContext = null;
            NamingEnumeration<SearchResult> searchResults = null;
            try {
                Secret credentialObj;
                searchResults = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchControl);
                if (logger.isDebugEnabled()) {
                    try {
                        if (dirContext != null) {
                            logger.debug((Object)("Searching for user with SearchFilter: " + searchFilter + " in SearchBase: " + dirContext.getNameInNamespace()));
                        }
                    }
                    catch (NamingException e) {
                        logger.debug((Object)"Error while getting DN of search base", (Throwable)e);
                    }
                }
                SearchResult user = null;
                int count = 0;
                while (searchResults.hasMoreElements()) {
                    if (count > 0) {
                        throw new UserStoreException("There are more than one result in the user store for user: " + userName);
                    }
                    user = searchResults.next();
                    ++count;
                }
                if (user == null) {
                    throw new UserStoreException("User :" + userName + " does not Exist");
                }
                if (newCredential == null) break block19;
                try {
                    credentialObj = Secret.getSecret((Object)newCredential);
                }
                catch (UnsupportedSecretTypeException e) {
                    throw new UserStoreException("Unsupported credential type", e);
                }
                try {
                    ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("unicodePwd", this.createUnicodePassword(credentialObj)))};
                    subDirContext = (DirContext)dirContext.lookup(this.escapeDNForSearch(searchBase));
                    subDirContext.modifyAttributes(user.getName(), mods);
                }
                finally {
                    credentialObj.clear();
                }
            }
            catch (NamingException e) {
                String error = "Can not access the directory service for user : " + userName;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)error, (Throwable)e);
                }
                throw new UserStoreException(error, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(searchResults);
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
            }
        }
    }

    @Override
    protected void doUpdateCredentialsValidityChecks(String userName, Object newCredential) throws UserStoreException {
        super.doUpdateCredentialsValidityChecks(userName, newCredential);
        if (!this.isSSLConnection) {
            logger.warn((Object)"Unsecured connection is being used. Password operations will fail");
        }
    }

    @Override
    protected void checkRequiredUserStoreConfigurations() throws UserStoreException {
        super.checkRequiredUserStoreConfigurations();
        String is_ADLDSRole = this.realmConfig.getUserStoreProperty("isADLDSRole");
        this.isADLDSRole = Boolean.parseBoolean(is_ADLDSRole);
        if (!this.isADLDSRole) {
            this.userAccountControl = this.realmConfig.getUserStoreProperty("userAccountControl");
            try {
                Integer.parseInt(this.userAccountControl);
            }
            catch (NumberFormatException e) {
                this.userAccountControl = "512";
            }
        }
        String connectionURL = this.realmConfig.getUserStoreProperty("ConnectionURL");
        String[] array = connectionURL.split(":");
        boolean startTLSEnabled = Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("StartTLSEnabled"));
        if (array[0].equals("ldaps") || startTLSEnabled) {
            this.isSSLConnection = true;
        } else {
            logger.warn((Object)"Connection to the Active Directory is not secure. Password involved operations such as update credentials and adduser operations will fail");
        }
    }

    private byte[] createUnicodePassword(Secret password) {
        char[] passwordChars = password.getChars();
        char[] quotedPasswordChars = new char[passwordChars.length + 2];
        for (int i = 0; i < quotedPasswordChars.length; ++i) {
            quotedPasswordChars[i] = i == 0 || i == quotedPasswordChars.length - 1 ? 34 : passwordChars[i - 1];
        }
        password.setChars(quotedPasswordChars);
        return password.getBytes(StandardCharsets.UTF_16LE);
    }

    @Override
    protected void handleLdapUserNameAttributeChanges(Map<String, ? extends Object> userAttributeValues, DirContext subDirContext, String returnedUserEntry) throws NamingException {
        if (userAttributeValues.containsKey("cn")) {
            String commonName = "";
            if (userAttributeValues.get("cn") instanceof String) {
                commonName = (String)userAttributeValues.get("cn");
            } else if (userAttributeValues.get("cn") instanceof List) {
                commonName = (String)((List)userAttributeValues.get("cn")).get(0);
            }
            subDirContext.rename(returnedUserEntry, "CN=" + this.escapeSpecialCharactersForDN(commonName));
            userAttributeValues.remove("cn");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doSetUserAttribute(String userName, String attributeName, String value, String profileName) throws UserStoreException {
        DirContext subDirContext;
        DirContext dirContext;
        block20: {
            block19: {
                dirContext = this.connectionSource.getContext();
                subDirContext = null;
                String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
                String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
                userSearchFilter = userSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                searchControls.setReturningAttributes(null);
                NamingEnumeration<SearchResult> returnedResultList = null;
                String returnedUserEntry = null;
                try {
                    returnedResultList = dirContext.search(this.escapeDNForSearch(userSearchBase), userSearchFilter, searchControls);
                    returnedUserEntry = returnedResultList.next().getName();
                }
                catch (NamingException e) {
                    String errorMessage = "Results could not be retrieved from the directory context for user : " + userName;
                    if (!logger.isDebugEnabled()) throw new UserStoreException(errorMessage, e);
                    logger.debug((Object)errorMessage, (Throwable)e);
                    throw new UserStoreException(errorMessage, e);
                }
                finally {
                    JNDIUtil.closeNamingEnumeration(returnedResultList);
                }
                try {
                    BasicAttributes updatedAttributes = new BasicAttributes(true);
                    if ("CN".equals(attributeName)) {
                        subDirContext = (DirContext)dirContext.lookup(this.escapeDNForSearch(userSearchBase));
                        subDirContext.rename(returnedUserEntry, "CN=" + value);
                        JNDIUtil.closeContext(subDirContext);
                        break block19;
                    }
                    BasicAttribute currentUpdatedAttribute = new BasicAttribute(attributeName);
                    if ("".equals(value)) {
                        currentUpdatedAttribute.clear();
                    } else {
                        String claimSeparator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
                        if (claimSeparator != null && !claimSeparator.trim().isEmpty()) {
                            this.userAttributeSeparator = claimSeparator;
                        }
                        if (value.contains(this.userAttributeSeparator)) {
                            StringTokenizer st = new StringTokenizer(value, this.userAttributeSeparator);
                            while (st.hasMoreElements()) {
                                String newVal = st.nextElement().toString();
                                if (newVal == null || newVal.trim().length() <= 0) continue;
                                currentUpdatedAttribute.add(newVal.trim());
                            }
                        } else {
                            currentUpdatedAttribute.add(value);
                        }
                    }
                    updatedAttributes.put(currentUpdatedAttribute);
                    subDirContext = (DirContext)dirContext.lookup(this.escapeDNForSearch(userSearchBase));
                    subDirContext.modifyAttributes(returnedUserEntry, 2, (Attributes)updatedAttributes);
                    JNDIUtil.closeContext(subDirContext);
                    break block20;
                }
                catch (Exception e) {
                    this.handleException(e, userName);
                    return;
                }
            }
            JNDIUtil.closeContext(dirContext);
            return;
        }
        JNDIUtil.closeContext(dirContext);
        return;
        finally {
            JNDIUtil.closeContext(subDirContext);
            JNDIUtil.closeContext(dirContext);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public String[] getUserListOfLDAPRole(RoleContext context, String filter) throws UserStoreException {
        String[] names;
        block24: {
            int searchTime;
            int givenMax;
            boolean debug = logger.isDebugEnabled();
            if (debug) {
                logger.debug((Object)("Getting user list of role: " + context.getRoleName() + " with filter: " + filter));
            }
            ArrayList<String> userList = new ArrayList<String>();
            names = new String[]{};
            try {
                givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
            }
            catch (NumberFormatException e) {
                if (debug) {
                    logger.debug((Object)("Error occurred while reading user store property: MaxUserNameListLength : " + e));
                }
                givenMax = 100;
            }
            try {
                searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
            }
            catch (NumberFormatException e) {
                if (debug) {
                    logger.debug((Object)("Error occurred while reading user store property: MaxSearchQueryTime : " + e));
                }
                searchTime = 10000;
            }
            DirContext dirContext = null;
            NamingEnumeration<SearchResult> answer = null;
            try {
                SearchControls searchCtls = new SearchControls();
                searchCtls.setSearchScope(2);
                searchCtls.setTimeLimit(searchTime);
                searchCtls.setCountLimit(givenMax);
                String groupSearchBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
                String userListFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
                String memberOFAttribute = this.realmConfig.getUserStoreProperty("MemberOfAttribute");
                String groupNameAttribute = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
                this.userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
                String searchFilter = "(&" + userListFilter + "(" + memberOFAttribute + "=" + groupNameAttribute + "=" + this.escapeSpecialCharactersForFilter(context.getRoleName()) + "," + groupSearchBase + "))";
                String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
                String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
                String[] returnedAtts = new String[]{userNameProperty, displayNameAttribute};
                searchCtls.setReturningAttributes(returnedAtts);
                SearchResult sr = null;
                dirContext = this.connectionSource.getContext();
                answer = dirContext.search(this.escapeDNForSearch(this.userSearchBase), searchFilter, searchCtls);
                for (int index = 0; index < givenMax && answer.hasMore(); ++index) {
                    String displayName = null;
                    String userName = null;
                    sr = answer.next();
                    Attributes userAttributes = sr.getAttributes();
                    if (userAttributes == null) continue;
                    Attribute userNameAttribute = userAttributes.get(userNameProperty);
                    if (userNameAttribute != null) {
                        userName = (String)userNameAttribute.get();
                        if (debug) {
                            logger.debug((Object)("UserName: " + userName));
                        }
                    }
                    if (StringUtils.isNotEmpty((String)displayNameAttribute)) {
                        Attribute displayAttribute = userAttributes.get(displayNameAttribute);
                        if (displayAttribute != null) {
                            displayName = (String)displayAttribute.get();
                        }
                        if (debug) {
                            logger.debug((Object)("DisplayName: " + displayName));
                        }
                    }
                    String domainName = this.realmConfig.getUserStoreProperty("DomainName");
                    if (userName != null) {
                        userName = UserCoreUtil.getCombinedName(domainName, userName, displayName);
                        userList.add(userName);
                        if (!debug) continue;
                        logger.debug((Object)(userName + " is added to the result list"));
                        continue;
                    }
                    if (!debug) continue;
                    logger.debug((Object)("User doesn't have the user name property : " + userNameProperty));
                }
                names = userList.toArray(new String[userList.size()]);
                JNDIUtil.closeNamingEnumeration(answer);
            }
            catch (PartialResultException e) {
                String errorMessage = "Error in reading user information in the user store for filter : " + filter;
                if (this.isIgnorePartialResultException()) {
                    if (debug) {
                        logger.debug((Object)errorMessage, (Throwable)e);
                    }
                    break block24;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (NamingException e2) {
                String errorMessage = "Error in reading user information in the user store for filter : " + filter;
                if (debug) {
                    logger.debug((Object)errorMessage, (Throwable)e2);
                }
                throw new UserStoreException(errorMessage, e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                JNDIUtil.closeNamingEnumeration(answer);
                JNDIUtil.closeContext(dirContext);
            }
            JNDIUtil.closeContext(dirContext);
        }
        return names;
    }

    @Override
    public Properties getDefaultUserStoreProperties() {
        Properties properties = new Properties();
        properties.setMandatoryProperties(ActiveDirectoryUserStoreConstants.ACTIVE_DIRECTORY_UM_PROPERTIES.toArray(new Property[ActiveDirectoryUserStoreConstants.ACTIVE_DIRECTORY_UM_PROPERTIES.size()]));
        properties.setOptionalProperties(ActiveDirectoryUserStoreConstants.OPTIONAL_ACTIVE_DIRECTORY_UM_PROPERTIES.toArray(new Property[ActiveDirectoryUserStoreConstants.OPTIONAL_ACTIVE_DIRECTORY_UM_PROPERTIES.size()]));
        properties.setAdvancedProperties(ACTIVE_DIRECTORY_UM_ADVANCED_PROPERTIES.toArray(new Property[ACTIVE_DIRECTORY_UM_ADVANCED_PROPERTIES.size()]));
        return properties;
    }

    private void handleException(Exception e, String userName) throws UserStoreException {
        if (e instanceof InvalidAttributeValueException) {
            String errorMessage = "One or more attribute values provided are incompatible for user : " + userName + "Please check and try again.";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        if (e instanceof InvalidAttributeIdentifierException) {
            String errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP for user : " + userName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        if (e instanceof NoSuchAttributeException) {
            String errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP for user : " + userName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        if (e instanceof NamingException) {
            String errorMessage = "Profile information could not be updated in LDAP user store for user : " + userName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        if (e instanceof org.wso2.carbon.user.api.UserStoreException) {
            String errorMessage = "Error in obtaining claim mapping for user : " + userName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
    }

    private String escapeSpecialCharactersForFilter(String dnPartial) {
        boolean replaceEscapeCharacters = true;
        String replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin");
        if (replaceEscapeCharactersAtUserLoginString != null) {
            replaceEscapeCharacters = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Replace escape characters configured to: " + replaceEscapeCharactersAtUserLoginString));
            }
        }
        if (replaceEscapeCharacters) {
            StringBuilder sb = new StringBuilder();
            block6: for (int i = 0; i < dnPartial.length(); ++i) {
                char currentChar = dnPartial.charAt(i);
                switch (currentChar) {
                    case '\\': {
                        sb.append("\\5c");
                        continue block6;
                    }
                    case '(': {
                        sb.append("\\28");
                        continue block6;
                    }
                    case ')': {
                        sb.append("\\29");
                        continue block6;
                    }
                    case '\u0000': {
                        sb.append("\\00");
                        continue block6;
                    }
                    default: {
                        sb.append(currentChar);
                    }
                }
            }
            return sb.toString();
        }
        return dnPartial;
    }

    private String escapeSpecialCharactersForDN(String text) {
        boolean replaceEscapeCharacters = true;
        String replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin");
        if (replaceEscapeCharactersAtUserLoginString != null) {
            replaceEscapeCharacters = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Replace escape characters configured to: " + replaceEscapeCharactersAtUserLoginString));
            }
        }
        if (replaceEscapeCharacters) {
            StringBuilder sb = new StringBuilder();
            if (text.length() > 0 && (text.charAt(0) == ' ' || text.charAt(0) == '#')) {
                sb.append('\\');
            }
            block9: for (int i = 0; i < text.length(); ++i) {
                char currentChar = text.charAt(i);
                switch (currentChar) {
                    case '\\': {
                        sb.append("\\\\");
                        continue block9;
                    }
                    case ',': {
                        sb.append("\\,");
                        continue block9;
                    }
                    case '+': {
                        sb.append("\\+");
                        continue block9;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        continue block9;
                    }
                    case '<': {
                        sb.append("\\<");
                        continue block9;
                    }
                    case '>': {
                        sb.append("\\>");
                        continue block9;
                    }
                    case ';': {
                        sb.append("\\;");
                        continue block9;
                    }
                    default: {
                        sb.append(currentChar);
                    }
                }
            }
            if (text.length() > 1 && text.charAt(text.length() - 1) == ' ') {
                sb.insert(sb.length() - 1, '\\');
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("value after escaping special characters in " + text + " : " + sb.toString()));
            }
            return sb.toString();
        }
        return text;
    }

    private static void setAdvancedProperties() {
        ACTIVE_DIRECTORY_UM_ADVANCED_PROPERTIES.clear();
        ActiveDirectoryUserStoreManager.setAdvancedProperty(BULK_IMPORT_SUPPORT, "Bulk Import Support", "true", "Bulk Import Supported");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("EmptyRolesAllowed", "Allow Empty Roles", "true", "Specifies whether the underlying user store allows empty groups to be added");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("PasswordHashMethod", "Password Hashing Algorithm", "PLAIN_TEXT", "Password Hash method to use when storing user entries");
        ActiveDirectoryUserStoreManager.setAdvancedProperty(MULTI_ATTRIBUTE_SEPARATOR, "Multiple Attribute Separator", ",", MULTI_ATTRIBUTE_SEPARATOR_DESCRIPTION);
        ActiveDirectoryUserStoreManager.setAdvancedProperty("isADLDSRole", "Is ADLDS Role", "false", "Whether an Active Directory Lightweight Directory Services role");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("userAccountControl", "User Account Control", "512", "Flags that control the behavior of the user account");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("MaxUserNameListLength", "Maximum User List Length", "100", "Maximum number of users retrieved at once");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("MaxRoleNameListLength", "Maximum Role List Length", "100", "Maximum number of groups retrieved at once");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("kdcEnabled", "Enable KDC", "false", "Whether key distribution center enabled");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("defaultRealmName", "Default Realm Name", "WSO2.ORG", "Default name for the realm");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("UserRolesCacheEnabled", "Enable User Role Cache", "true", "This is to indicate whether to cache the group list of a user");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("ConnectionPoolingEnabled", "Enable LDAP Connection Pooling", "false", "Set this property to enable LDAP connection pooling.");
        ActiveDirectoryUserStoreManager.setAdvancedProperty(LDAPConnectionTimeout, LDAPConnectionTimeoutDescription, "5000", LDAPConnectionTimeoutDescription);
        ActiveDirectoryUserStoreManager.setAdvancedProperty(readTimeout, "LDAP Read Timeout", "5000", readTimeoutDescription);
        ActiveDirectoryUserStoreManager.setAdvancedProperty(RETRY_ATTEMPTS, "Retry Attempts", "0", "Number of retries for authentication in case ldap read timed out.");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("CountRetrieverClass", "Count Implementation", "", "Name of the class that implements the count functionality");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("java.naming.ldap.attributes.binary", "LDAP binary attributes", " ", LDAPBinaryAttributesDescription);
        ActiveDirectoryUserStoreManager.setAdvancedProperty("ClaimOperationsSupported", "Claim Operations Supported", "true", "Whether the userstore supports claim read and write");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("transformObjectGUIDToUUID", "Return objectGUID in UUID Canonical Format", "true", "Return objectGUID in UUID Canonical Format");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("MembershipAttributeRange", "Membership Attribute Range", String.valueOf(1500), "Number of maximum users of role returned by the AD");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("UserCacheExpiryMilliseconds", "User Cache Expiry milliseconds", "", "Configure the user cache expiry in milliseconds. Values  {0: expire immediately, -1: never expire, '': i.e. empty, system default}.");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("UserDNCacheEnabled", "Enable User DN Cache", "true", "Enables the user cache. Default true, Unless set to false. Empty value is interpreted as true.");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("StartTLSEnabled", "Enable StartTLS", "false", "Enable secure connection by using StartTLS extended operation in LDAP");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("ConnectionRetryDelay", "Connection Retry Delay", String.valueOf(120000), "Specifies waiting time in milliseconds inorder to establish the connection after couple of failure attempts.");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("SSLCertificateValidationEnabled", "Enable SSL certificate validation", "true", "Set/Unset this property to enable/disable certificate validation for LDAPS connections");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("ImmutableAttributes", "Immutable Attributes", " ", "Comma-separated list of user store maintained immutable attributes");
        ActiveDirectoryUserStoreManager.setAdvancedProperty("TimestampAttributes", "Timestamp Attributes", " ", "Comma-separated list of user store attributes having the data type of Timestamp and may require a conversion when reading from/writing to user store");
    }

    private static void setAdvancedProperty(String name, String displayName, String value, String description) {
        Property property = new Property(name, value, displayName + "#" + description, null);
        ACTIVE_DIRECTORY_UM_ADVANCED_PROPERTIES.add(property);
    }

    @Override
    protected void processAttributesBeforeUpdate(String userName, Map<String, ? extends Object> userStorePropertyValues, String profileName) {
        String immutableAttributesProperty = Optional.ofNullable(this.realmConfig.getUserStoreProperty("ImmutableAttributes")).orElse("");
        Object[] immutableAttributes = StringUtils.split((String)immutableAttributesProperty, (String)",");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved user store properties for update: " + userStorePropertyValues));
        }
        if (ArrayUtils.isNotEmpty((Object[])immutableAttributes)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping Active Directory maintained default attributes: " + Arrays.toString(immutableAttributes)));
            }
            Arrays.stream(immutableAttributes).map(StringUtils::trim).forEach(userStorePropertyValues::remove);
        }
    }

    @Override
    protected void processAttributesAfterRetrieval(String userName, Map<String, String> userStorePropertyValues, String profileName) {
        String timestampAttributesProperty = Optional.ofNullable(this.realmConfig.getUserStoreProperty("TimestampAttributes")).orElse("");
        Object[] timestampAttributes = StringUtils.split((String)timestampAttributesProperty, (String)",");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Active Directory timestamp attributes: " + Arrays.toString(timestampAttributes)));
        }
        if (ArrayUtils.isNotEmpty((Object[])timestampAttributes)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieved user store properties before type conversions: " + userStorePropertyValues));
            }
            Map convertedTimestampAttributeValues = Arrays.stream(timestampAttributes).map(StringUtils::trim).filter(attribute -> userStorePropertyValues.get(attribute) != null).collect(Collectors.toMap(Function.identity(), attribute -> this.convertDateFormatFromAD((String)userStorePropertyValues.get(attribute))));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converted timestamp attribute values: " + convertedTimestampAttributeValues));
            }
            userStorePropertyValues.putAll(convertedTimestampAttributeValues);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieved user store properties after type conversions: " + userStorePropertyValues));
            }
        }
    }

    private String convertDateFormatFromAD(String date) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(ACTIVE_DIRECTORY_DATE_TIME_FORMAT);
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(date, dateTimeFormatter);
        Instant instant = offsetDateTime.toInstant();
        return instant.toString();
    }

    static {
        ActiveDirectoryUserStoreManager.setAdvancedProperties();
    }
}

