/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.util.ArrayList;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.core.constants.UserStoreUIConstants;

public class ActiveDirectoryUserStoreConstants {
    public static final ArrayList<Property> ACTIVE_DIRECTORY_UM_PROPERTIES = new ArrayList();
    public static final ArrayList<Property> UNIQUE_ID_ACTIVE_DIRECTORY_UM_PROPERTIES = new ArrayList();
    public static final ArrayList<Property> OPTIONAL_ACTIVE_DIRECTORY_UM_PROPERTIES = new ArrayList();
    public static final String TRANSFORM_OBJECTGUID_TO_UUID = "transformObjectGUIDToUUID";
    public static final String TRANSFORM_OBJECTGUID_TO_UUID_DESC = "Return objectGUID in UUID Canonical Format";
    private static final String DisplayNameAttributeDescription = "Attribute name to display as the Display Name";
    private static final String DisplayNameAttribute = "DisplayNameAttribute";
    private static final String usernameJavaRegExViolationErrorMsg = "UsernameJavaRegExViolationErrorMsg";
    private static final String usernameJavaRegExViolationErrorMsgDescription = "Error message when the Username is not matched with UsernameJavaRegEx";
    private static final String passwordJavaRegEx = "PasswordJavaRegEx";
    private static final String passwordJavaRegExViolationErrorMsg = "PasswordJavaRegExViolationErrorMsg";
    private static final String passwordJavaRegExViolationErrorMsgDescription = "Error message when the Password is not matched with passwordJavaRegEx";
    private static final String passwordJavaRegExDescription = "Policy that defines the password format in backend";
    private static final String roleDNPattern = "RoleDNPattern";
    private static final String roleDNPatternDescription = "The patten for group's DN. It can be defined to improve the LDAP search";

    private static void setMandatoryProperty(String name, String displayName, String value, String description, boolean encrypt, Property[] childProperties) {
        String propertyDescription = displayName + "#" + description;
        if (encrypt) {
            propertyDescription = propertyDescription + "#encrypt";
        }
        Property property = new Property(name, value, propertyDescription, childProperties);
        ACTIVE_DIRECTORY_UM_PROPERTIES.add(property);
    }

    private static void setMandatoryPropertyForUniqueIdStore(String name, String displayName, String value, String description, boolean encrypt, Property[] childProperties) {
        String propertyDescription = displayName + "#" + description;
        if (encrypt) {
            propertyDescription = propertyDescription + "#encrypt";
        }
        Property property = new Property(name, value, propertyDescription, childProperties);
        UNIQUE_ID_ACTIVE_DIRECTORY_UM_PROPERTIES.add(property);
    }

    private static void setProperty(String name, String displayName, String value, String description, Property[] childProperties) {
        Property property = new Property(name, value, displayName + "#" + description, childProperties);
        OPTIONAL_ACTIVE_DIRECTORY_UM_PROPERTIES.add(property);
    }

    static {
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("ConnectionURL", "Connection URL", "ldaps://", "Connection URL for the user store", false, new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("ConnectionName", "Connection Name", "CN=,DC=", "This should be a DN (Distinguish Name) of a user with sufficient permissions to perform operations on users and groups in LDAP", false, new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("ConnectionPassword", "Connection Password", "", "Password of the admin user", true, new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.PASSWORD.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("UserSearchBase", "User Search Base", "CN=Users,DC=WSO2,DC=Com", "DN of the context under which user entries are stored in LDAP", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("UserEntryObjectClass", "User Entry Object Class", "user", "Object Class used to construct user entries", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("UserNameAttribute", "Username Attribute", "cn", "Attribute used for uniquely identifying a user entry. Users can be authenticated using their email address, uid and etc", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("UserNameSearchFilter", "User Search Filter", "(&(objectClass=user)(cn=?))", "Filtering criteria for searching a particular user entry", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("UserNameListFilter", "User List Filter", "(objectClass=person)", "Filtering criteria for listing all the user entries in LDAP", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("UserDNPattern", "User DN Pattern", "", "The patten for user's DN. It can be defined to improve the LDAP search", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty(DisplayNameAttribute, "Display name attribute", "", DisplayNameAttributeDescription, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("Disabled", "Disabled", "false", "Whether user store is disabled", new Property[]{UserStoreUIConstants.DataCategory.BASIC.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("CaseInsensitiveUsername", "Case Insensitive Username", "true", "Whether the username is case sensitive or not", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        Property readLDAPGroups = new Property("ReadGroups", "true", "Read Groups#Specifies whether groups should be read from LDAP", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        Property groupSearchBase = new Property("GroupSearchBase", "CN=Users,DC=WSO2,DC=Com", "Group Search Base#DN of the context under which user entries are stored in LDAP", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        Property groupNameListFilter = new Property("GroupNameListFilter", "(objectcategory=group)", "Group Filter#Filtering criteria for listing all the group entries in LDAP", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        Property groupNameAttribute = new Property("GroupNameAttribute", "cn", "Group Name Attribute#Attribute used for uniquely identifying a user entry", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        Property membershipAttribute = new Property("MembershipAttribute", "member", "Membership Attribute#Attribute used to define members of LDAP groups", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        Property groupNameSearchFilter = new Property("GroupNameSearchFilter", "(&(objectClass=group)(cn=?))", "Group Search Filter#Filtering criteria for searching a particular group entry", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        readLDAPGroups.setChildProperties(new Property[]{groupSearchBase, groupNameAttribute, groupNameListFilter, membershipAttribute, groupNameSearchFilter});
        OPTIONAL_ACTIVE_DIRECTORY_UM_PROPERTIES.add(readLDAPGroups);
        ActiveDirectoryUserStoreConstants.setProperty("WriteGroups", "Write Groups", "true", "Indicate whether write groups enabled", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("GroupSearchBase", "Group Search Base", "CN=Users,DC=WSO2,DC=Com", "DN of the context under which user entries are stored in LDAP", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("GroupEntryObjectClass", "Group Entry Object Class", "group", "Object Class used to construct group entries", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("GroupNameAttribute", "Group Name Attribute", "cn", "Attribute used for uniquely identifying a user entry", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("GroupNameSearchFilter", "Group Search Filter", "(&(objectClass=group)(cn=?))", "Filtering criteria for searching a particular group entry", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("GroupNameListFilter", "Group List Filter", "(objectcategory=group)", "Filtering criteria for listing all the group entries in LDAP", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty(roleDNPattern, "Group DN Pattern", "", roleDNPatternDescription, new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("MembershipAttribute", "Membership Attribute", "member", "Attribute used to define members of LDAP groups", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("MemberOfAttribute", "Member Of Attribute", "memberOf", "MemberOfAttribute", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("BackLinksEnabled", "Enable Back Links", "true", "Whether to allow attributes to be result from references to the object from other objects", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("Referral", "Referral", "follow", "Guides the requests to a domain controller in the correct domain", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("UserNameJavaRegEx", "Username RegEx (Java)", "[a-zA-Z0-9._-|//]{3,30}$", "A regular expression to validate user names", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("UserNameJavaScriptRegEx", "Username RegEx (Javascript)", "^[\\S]{3,30}$", "The regular expression used by the front-end components for username validation", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty(usernameJavaRegExViolationErrorMsg, "Username RegEx Violation Error Message", "Username pattern policy violated.", usernameJavaRegExViolationErrorMsgDescription, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty(passwordJavaRegEx, "Password RegEx (Java)", "^[\\S]{5,30}$", passwordJavaRegExDescription, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("PasswordJavaScriptRegEx", "Password RegEx (Javascript)", "^[\\S]{5,30}$", "Policy that defines the password format", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty(passwordJavaRegExViolationErrorMsg, "Password RegEx Violation Error Message", "Password pattern policy violated.", passwordJavaRegExViolationErrorMsgDescription, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("RoleNameJavaRegEx", "Group Name RegEx (Java)", "[a-zA-Z0-9._-|//]{3,30}$", "A regular expression to validate group names", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("RoleNameJavaScriptRegEx", "Group Name RegEx (Javascript)", "^[\\S]{3,30}$", "The regular expression used by the front-end components for group name validation", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("UniqueID", "", "", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("LDAPInitialContextFactory", "LDAP Initial Context Factory", "com.sun.jndi.ldap.LdapCtxFactory", "The property to set LDAP Initial Context Factory", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        ActiveDirectoryUserStoreConstants.setMandatoryPropertyForUniqueIdStore("UserIDAttribute", "User ID Attribute", "objectGuid", "Attribute used for uniquely identifying a user entry.", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setMandatoryPropertyForUniqueIdStore("UserIdSearchFilter", "User ID Search Filter", "(&(objectClass=person)(uid=?))", "Filtering criteria for searching a particular user entry", false, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        ActiveDirectoryUserStoreConstants.setProperty("DateAndTimePattern", "", "Date And Time Pattern", "Pattern of Date and Time values are stored, if not specified default timestamp representation is used.", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
    }
}

