/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.jdbc;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.NotImplementedException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreClientException;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.AuthenticationResult;
import org.wso2.carbon.user.core.common.FailureReason;
import org.wso2.carbon.user.core.common.LoginIdentifier;
import org.wso2.carbon.user.core.common.PaginatedSearchResult;
import org.wso2.carbon.user.core.common.RoleBreakdown;
import org.wso2.carbon.user.core.common.RoleContext;
import org.wso2.carbon.user.core.common.UniqueIDPaginatedSearchResult;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.constants.UserCoreErrorConstants;
import org.wso2.carbon.user.core.jdbc.JDBCRoleContext;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreManager;
import org.wso2.carbon.user.core.model.Condition;
import org.wso2.carbon.user.core.model.ExpressionAttribute;
import org.wso2.carbon.user.core.model.ExpressionCondition;
import org.wso2.carbon.user.core.model.ExpressionOperation;
import org.wso2.carbon.user.core.model.OperationalCondition;
import org.wso2.carbon.user.core.model.SqlBuilder;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.Secret;
import org.wso2.carbon.utils.UnsupportedSecretTypeException;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class UniqueIDJDBCUserStoreManager
extends JDBCUserStoreManager {
    private static Log log = LogFactory.getLog(UniqueIDJDBCUserStoreManager.class);
    private static final String QUERY_FILTER_STRING_ANY = "*";
    private static final String SQL_FILTER_STRING_ANY = "%";
    private static final String CASE_INSENSITIVE_USERNAME = "CaseInsensitiveUsername";
    private static final String SHA_1_PRNG = "SHA1PRNG";
    private static final String DB2 = "db2";
    private static final String MSSQL = "mssql";
    private static final String ORACLE = "oracle";
    private static final String MYSQL = "mysql";
    private static final String MARIADB = "mariadb";
    private static final String MULTI_ATTRIBUTE_SEPARATOR = "MultiAttributeSeparator";
    private static final String MULTI_ATTRIBUTE_SEPARATOR_DESCRIPTION = "This is the separator for multiple claim values";
    private static final String VALIDATION_INTERVAL = "validationInterval";
    private static final List<Property> UNIQUE_ID_JDBC_UM_ADVANCED_PROPERTIES = new ArrayList<Property>();
    private static final String UID = "uid";

    public UniqueIDJDBCUserStoreManager() {
    }

    public UniqueIDJDBCUserStoreManager(RealmConfiguration realmConfig, int tenantId) throws UserStoreException {
        super(realmConfig, tenantId);
    }

    public UniqueIDJDBCUserStoreManager(DataSource ds, RealmConfiguration realmConfig, int tenantId, boolean addInitData) throws UserStoreException {
        super(ds, realmConfig, tenantId, addInitData);
    }

    public UniqueIDJDBCUserStoreManager(DataSource ds, RealmConfiguration realmConfig) throws UserStoreException {
        super(ds, realmConfig);
    }

    public UniqueIDJDBCUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        super(realmConfig, properties, claimManager, profileManager, realm, tenantId);
    }

    public UniqueIDJDBCUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId, boolean skipInitData) throws UserStoreException {
        super(realmConfig, properties, claimManager, profileManager, realm, tenantId, skipInitData);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<User> doListUsersWithID(String filter, int maxItemLimit) throws UserStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 2[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean doCheckIsUserInRoleWithID(String userID, String roleName) throws UserStoreException {
        String[] roles = this.doGetExternalRoleListOfUserWithID(userID, roleName);
        if (roles != null) {
            for (String role : roles) {
                if (!role.equalsIgnoreCase(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] doGetUserListOfRole(String roleName, String filter) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public String[] doGetUserListOfRole(String roleName, String filter, int maxItemLimit) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public List<User> doGetUserListOfRoleWithID(String roleName, String filter) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        return this.getUserListOfJDBCRoleWithID(roleContext, filter);
    }

    public List<User> getUserListOfJDBCRoleWithID(RoleContext ctx, String filter) throws UserStoreException {
        return this.getUserListOfJDBCRoleWithID(ctx, filter, -1);
    }

    @Override
    public List<User> doGetUserListOfRoleWithID(String roleName, String filter, int maxItemLimit) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        return this.getUserListOfJDBCRoleWithID(roleContext, filter, maxItemLimit);
    }

    public List<User> getUserListOfJDBCRoleWithID(RoleContext ctx, String filter, int maxItemLimit) throws UserStoreException {
        List<User> users;
        String roleName = ctx.getRoleName();
        if (maxItemLimit == 0) {
            return Collections.emptyList();
        }
        if (maxItemLimit < 0 || maxItemLimit > this.maximumUserNameListLength) {
            maxItemLimit = this.maximumUserNameListLength;
        }
        if (StringUtils.isNotEmpty((String)filter)) {
            filter = filter.trim();
            filter = filter.replace(QUERY_FILTER_STRING_ANY, SQL_FILTER_STRING_ANY);
            filter = filter.replace("?", "_");
        } else {
            filter = SQL_FILTER_STRING_ANY;
        }
        if (!ctx.isShared()) {
            String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserListOfRoleFilterWithIDSQL");
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for retrieving user roles is null");
            }
            users = sqlStmt.contains("UM_TENANT_ID") ? this.getUsersFromDatabaseWithConstraints(this, sqlStmt, maxItemLimit, this.queryTimeout, filter, roleName, this.tenantId, this.tenantId, this.tenantId) : this.getUsersFromDatabaseWithConstraints(this, sqlStmt, maxItemLimit, this.queryTimeout, filter, roleName);
        } else {
            String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserListOfSharedRoleFilterWithIDSQL");
            users = this.getUsersFromDatabaseWithConstraints(this, sqlStmt, maxItemLimit, this.queryTimeout, filter, roleName);
        }
        return users;
    }

    @Override
    public String[] getProfileNames(String userName) throws UserStoreException {
        String userID = this.getUserIDFromUserName(userName);
        return this.getProfileNamesWithID(userID);
    }

    @Override
    public String[] getProfileNamesWithID(String userID) throws UserStoreException {
        userID = UserCoreUtil.removeDomainFromName(userID);
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserProfileNamesWithIDSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving is null.");
        }
        Object[] names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, userID, this.tenantId, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, userID);
        if (names.length == 0) {
            names = new String[]{"default"};
        } else {
            Arrays.sort(names);
            if (Arrays.binarySearch(names, "default") < 0) {
                String[] newNames = new String[names.length + 1];
                int i = 0;
                for (i = 0; i < names.length; ++i) {
                    newNames[i] = names[i];
                }
                newNames[i] = "default";
                names = newNames;
            }
        }
        return names;
    }

    @Override
    public boolean doCheckIsUserInRole(String userName, String roleName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public Map<String, String> getUserPropertyValues(String userName, String[] propertyNames, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public Map<String, String> getUserPropertyValuesWithID(String userID, String[] propertyNames, String profileName) throws UserStoreException {
        Object name;
        if (profileName == null) {
            profileName = "default";
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Object[] propertyNamesSorted = (String[])propertyNames.clone();
        Arrays.sort(propertyNamesSorted);
        HashMap<Object, String> map = new HashMap<Object, String>();
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserPropertiesForProfileWithIDSQL");
        try {
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, userID);
            prepStmt.setString(2, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(3, this.tenantId);
                prepStmt.setInt(4, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                name = rs.getString(1);
                String value = rs.getString(2);
                if (Arrays.binarySearch(propertyNamesSorted, name) < 0) continue;
                map.put(name, value);
            }
            name = map;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error Occurred while getting property values for user : " + userID + " & profile name : " + profileName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return name;
    }

    @Override
    public boolean doCheckExistingUser(String userName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    private String[] getStringValuesFromDatabase(String sqlStmt, Object ... params) throws UserStoreException {
        String[] values;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing Query: " + sqlStmt));
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                log.debug((Object)("Input value: " + param));
            }
        }
        Connection dbConnection = null;
        Object prepStmt = null;
        ResultSet rs = null;
        try {
            dbConnection = this.getDBConnection();
            values = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, params);
        }
        catch (SQLException e) {
            try {
                String msg = "Error occurred while retrieving string values.";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return values;
    }

    private List<User> getUsersFromDatabaseWithConstraints(UserStoreManager userStoreManager, String sqlStmt, int maxRows, int queryTimeout, Object ... params) throws UserStoreException {
        List<User> values;
        if (log.isDebugEnabled()) {
            String loggableSqlString = DatabaseUtil.getLoggableSqlString(sqlStmt, params);
            String msg = "Using SQL : " + loggableSqlString + ", and maxRows: " + maxRows + ", and queryTimeout: " + queryTimeout;
            log.debug((Object)msg);
        }
        try (Connection dbConnection = this.getDBConnection();){
            values = DatabaseUtil.getUsersFromDatabaseWithConstraints(userStoreManager, dbConnection, sqlStmt, maxRows, queryTimeout, params);
        }
        catch (SQLException e) {
            String msg = "Error occurred while accessing the database connection.";
            throw new UserStoreException(msg, e);
        }
        return values;
    }

    private String[] getRoleNamesWithDomainWithID(String sqlStmt, String userID, int tenantId, boolean appendDn) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<String> roles = new ArrayList<String>();
        try {
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            int count = 0;
            count = (byte)(count + 1);
            prepStmt.setString(count, userID);
            count = (byte)(count + 1);
            prepStmt.setInt(count, tenantId);
            rs = prepStmt.executeQuery();
            String domain = this.realmConfig.getUserStoreProperty("DomainName");
            while (rs.next()) {
                String name = rs.getString(1);
                int tenant = rs.getInt(2);
                String role = name;
                if (appendDn) {
                    name = UserCoreUtil.addTenantDomainToEntry(name, String.valueOf(tenant));
                }
                roles.add(role);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Error occurred while retrieving role name with tenant id : " + tenantId + " & user : " + userID;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return roles.toArray(new String[roles.size()]);
    }

    @Override
    public boolean doCheckExistingUserWithID(String userID) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for userID " + userID));
        }
        if (userID == null) {
            return false;
        }
        return this.doGetUserNameFromUserID(userID) != null;
    }

    @Override
    public boolean doCheckExistingUserNameWithIDImpl(String userName) throws UserStoreException {
        boolean isExisting;
        String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("IsUserNameExistingSQL") : this.realmConfig.getUserStoreProperty("IsUserNameExistingSQLCaseInsensitive");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for is user existing null");
        }
        String isUnique = this.realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenants");
        if (Boolean.parseBoolean(isUnique) && !"wso2.anonymous.user".equals(userName)) {
            String uniquenesSql = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenantsSQL") : this.realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenantsSQLCaseInsensitive");
            isExisting = this.isValueExisting(uniquenesSql, null, userName);
            if (log.isDebugEnabled()) {
                log.debug((Object)"The username should be unique across tenants.");
            }
        } else {
            isExisting = sqlStmt.contains("UM_TENANT_ID") ? this.isValueExisting(sqlStmt, null, userName, this.tenantId) : this.isValueExisting(sqlStmt, null, userName);
        }
        return isExisting;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected AuthenticationResult doAuthenticateWithID(List<LoginIdentifier> loginIdentifiers, Object credential) throws UserStoreException {
        AuthenticationResult authenticationResult;
        PreparedStatement prepStmt;
        ResultSet rs;
        Connection dbConnection;
        block17: {
            AuthenticationResult authenticationResult2;
            block18: {
                authenticationResult2 = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
                if (!this.isValidCredentials(credential)) {
                    String reason = "Password validation failed";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)reason);
                    }
                    return this.getAuthenticationResult(reason);
                }
                dbConnection = null;
                rs = null;
                prepStmt = null;
                boolean isAuthed = false;
                try {
                    dbConnection = this.getDBConnection();
                    dbConnection.setAutoCommit(false);
                    String sqlstmt = this.getSqlQuery(loginIdentifiers.size()).toString();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sqlstmt);
                    }
                    prepStmt = dbConnection.prepareStatement(sqlstmt);
                    int count = 1;
                    prepStmt.setInt(count++, this.tenantId);
                    for (LoginIdentifier loginIdentifier : loginIdentifiers) {
                        prepStmt.setString(count++, loginIdentifier.getLoginKey());
                        prepStmt.setString(count++, loginIdentifier.getLoginValue());
                        prepStmt.setString(count++, loginIdentifier.getProfileName());
                        prepStmt.setInt(count++, this.tenantId);
                    }
                    rs = prepStmt.executeQuery();
                    int resultsCount = 0;
                    while (rs.next()) {
                        if (++resultsCount > 1) {
                            String reason = "Invalid scenario. Multiple users found for the given attribute values: ";
                            if (log.isDebugEnabled()) {
                                log.debug((Object)reason);
                            }
                            authenticationResult = this.getAuthenticationResult(reason);
                            break block17;
                        }
                        String userID = rs.getString(1);
                        String userName = rs.getString(2);
                        String storedPassword = rs.getString(3);
                        String saltValue = null;
                        if ("true".equalsIgnoreCase(this.realmConfig.getUserStoreProperty("StoreSaltedPassword"))) {
                            saltValue = rs.getString(4);
                        }
                        boolean requireChange = rs.getBoolean(5);
                        Timestamp changedTime = rs.getTimestamp(6);
                        GregorianCalendar gc = new GregorianCalendar();
                        gc.add(10, -24);
                        Date date = gc.getTime();
                        if (requireChange && changedTime.before(date)) {
                            isAuthed = false;
                            authenticationResult2 = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
                            authenticationResult2.setFailureReason(new FailureReason("Password change required."));
                            continue;
                        }
                        String password = this.preparePassword(credential, saltValue);
                        if (storedPassword == null || !storedPassword.equals(password)) continue;
                        isAuthed = true;
                        User user = new User(userID, userName, userName, null, null, null, null);
                        try {
                            user.setTenantDomain(this.getTenantDomain(this.tenantId));
                            user.setUserStoreDomain(UserCoreUtil.getDomainName(this.realmConfig));
                        }
                        catch (org.wso2.carbon.user.api.UserStoreException e) {
                            throw new UserStoreException(e);
                        }
                        authenticationResult2 = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.SUCCESS);
                        authenticationResult2.setAuthenticatedUser(user);
                    }
                }
                catch (SQLException e) {
                    try {
                        String msg = "Error occurred while retrieving user authentication info for user : ";
                        if (log.isDebugEnabled()) {
                            log.debug((Object)msg, (Throwable)e);
                        }
                        throw new UserStoreException("Authentication Failure", e);
                    }
                    catch (Throwable throwable) {
                        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                        throw throwable;
                    }
                }
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                if (!log.isDebugEnabled()) break block18;
                log.debug((Object)("User login attempt. Login status: " + isAuthed));
            }
            return authenticationResult2;
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return authenticationResult;
    }

    private StringBuilder getSqlQuery(int limit) {
        StringBuilder sqlStatement = new StringBuilder("SELECT UM_USER.UM_USER_ID, UM_USER.UM_USER_NAME, UM_USER.UM_USER_PASSWORD, UM_USER.UM_SALT_VALUE, UM_USER.UM_REQUIRE_CHANGE, UM_USER.UM_CHANGED_TIME FROM UM_USER WHERE UM_USER.UM_TENANT_ID=? AND UM_USER.UM_ID IN (");
        for (int i = 1; i <= limit; ++i) {
            sqlStatement.append("SELECT UM_USER_ATTRIBUTE.UM_USER_ID FROM UM_USER_ATTRIBUTE WHERE UM_ATTR_NAME = ? AND UM_ATTR_VALUE = ? AND UM_PROFILE_ID = ? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=?");
            if (i >= limit) continue;
            sqlStatement.append(" AND ");
        }
        sqlStatement.append(")");
        return sqlStatement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AuthenticationResult doAuthenticateWithID(String preferredUserNameProperty, String preferredUserNameValue, Object credential, String profileName) throws UserStoreException {
        AuthenticationResult authenticationResult;
        PreparedStatement prepStmt;
        ResultSet rs;
        Connection dbConnection;
        block17: {
            AuthenticationResult authenticationResult2;
            block18: {
                if (preferredUserNameProperty.equals(this.getUserNameMappedAttribute())) {
                    return this.doAuthenticateWithUserName(preferredUserNameValue, credential);
                }
                authenticationResult2 = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
                if (!this.isValidCredentials(credential)) {
                    String reason = "Password validation failed";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)reason);
                    }
                    return this.getAuthenticationResult(reason);
                }
                if (profileName == null) {
                    profileName = "default";
                }
                dbConnection = null;
                rs = null;
                prepStmt = null;
                boolean isAuthed = false;
                try {
                    dbConnection = this.getDBConnection();
                    dbConnection.setAutoCommit(false);
                    String sqlstmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("SelectUserWithIDSQL") : this.realmConfig.getUserStoreProperty("SelectUserWithIDSQLCaseInsensitive");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sqlstmt);
                    }
                    prepStmt = dbConnection.prepareStatement(sqlstmt);
                    prepStmt.setString(1, preferredUserNameProperty);
                    prepStmt.setString(2, preferredUserNameValue);
                    prepStmt.setString(3, profileName);
                    if (sqlstmt.contains("UM_TENANT_ID")) {
                        prepStmt.setInt(4, this.tenantId);
                        prepStmt.setInt(5, this.tenantId);
                    }
                    rs = prepStmt.executeQuery();
                    int count = 0;
                    while (rs.next()) {
                        if (++count > 1) {
                            String reason = "Invalid scenario. Multiple users found for the given username property: " + preferredUserNameProperty + " and value: " + preferredUserNameValue;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)reason);
                            }
                            authenticationResult = this.getAuthenticationResult(reason);
                            break block17;
                        }
                        String userID = rs.getString(1);
                        String userName = rs.getString(2);
                        String storedPassword = rs.getString(3);
                        String saltValue = null;
                        if ("true".equalsIgnoreCase(this.realmConfig.getUserStoreProperty("StoreSaltedPassword"))) {
                            saltValue = rs.getString(4);
                        }
                        boolean requireChange = rs.getBoolean(5);
                        Timestamp changedTime = rs.getTimestamp(6);
                        GregorianCalendar gc = new GregorianCalendar();
                        gc.add(10, -24);
                        Date date = gc.getTime();
                        if (requireChange && changedTime.before(date)) {
                            isAuthed = false;
                            authenticationResult2 = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
                            authenticationResult2.setFailureReason(new FailureReason("Password change required."));
                            continue;
                        }
                        String password = this.preparePassword(credential, saltValue);
                        if (storedPassword == null || !storedPassword.equals(password)) continue;
                        isAuthed = true;
                        User user = this.getUser(userID, userName);
                        user.setPreferredUsername(preferredUserNameProperty);
                        authenticationResult2 = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.SUCCESS);
                        authenticationResult2.setAuthenticatedUser(user);
                    }
                }
                catch (SQLException e) {
                    try {
                        String msg = "Error occurred while retrieving user authentication info for user : " + preferredUserNameValue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)msg, (Throwable)e);
                        }
                        throw new UserStoreException("Authentication Failure", e);
                    }
                    catch (Throwable throwable) {
                        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                        throw throwable;
                    }
                }
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                if (!log.isDebugEnabled()) break block18;
                log.debug((Object)("User " + preferredUserNameValue + " login attempt. Login success: " + isAuthed));
            }
            return authenticationResult2;
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return authenticationResult;
    }

    @Override
    public AuthenticationResult doAuthenticateWithID(String userID, Object credential) throws UserStoreException {
        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
        if (!this.isValidCredentials(credential)) {
            String reason = "Password validation failed";
            if (log.isDebugEnabled()) {
                log.debug((Object)reason);
            }
            return this.getAuthenticationResult(reason);
        }
        Connection dbConnection = null;
        ResultSet rs = null;
        PreparedStatement prepStmt = null;
        boolean isAuthed = false;
        try {
            dbConnection = this.getDBConnection();
            dbConnection.setAutoCommit(false);
            String sqlstmt = this.realmConfig.getUserStoreProperty("SelectUserIDSQL");
            if (log.isDebugEnabled()) {
                log.debug((Object)sqlstmt);
            }
            prepStmt = dbConnection.prepareStatement(sqlstmt);
            prepStmt.setString(1, userID);
            if (sqlstmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String userName = rs.getString(2);
                String storedPassword = rs.getString(3);
                String saltValue = null;
                if ("true".equalsIgnoreCase(this.realmConfig.getUserStoreProperty("StoreSaltedPassword"))) {
                    saltValue = rs.getString(4);
                }
                boolean requireChange = rs.getBoolean(5);
                Timestamp changedTime = rs.getTimestamp(6);
                GregorianCalendar gc = new GregorianCalendar();
                gc.add(10, -24);
                Date date = gc.getTime();
                if (requireChange && changedTime.before(date)) {
                    isAuthed = false;
                    authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
                    authenticationResult.setFailureReason(new FailureReason("Password change required."));
                    continue;
                }
                String password = this.preparePassword(credential, saltValue);
                if (storedPassword == null || !storedPassword.equals(password)) continue;
                isAuthed = true;
                User user = this.getUser(userID, userName);
                authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.SUCCESS);
                authenticationResult.setAuthenticatedUser(user);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Error occurred while retrieving user authentication info for userID : " + userID;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException("Authentication Failure", e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        if (log.isDebugEnabled()) {
            log.debug((Object)("UserID " + userID + " login attempt. Login success: " + isAuthed));
        }
        return authenticationResult;
    }

    protected AuthenticationResult doAuthenticateWithUserName(String userName, Object credential) throws UserStoreException {
        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
        if (!this.isValidUserName(userName)) {
            String reason = "Username validation failed.";
            if (log.isDebugEnabled()) {
                log.debug((Object)reason);
            }
            return this.getAuthenticationResult(reason);
        }
        if (UserCoreUtil.isRegistryAnnonymousUser(userName)) {
            String reason = "Anonymous user trying to login.";
            log.error((Object)reason);
            return this.getAuthenticationResult(reason);
        }
        if (!this.isValidCredentials(credential)) {
            String reason = "Password validation failed.";
            if (log.isDebugEnabled()) {
                log.debug((Object)reason);
            }
            return this.getAuthenticationResult(reason);
        }
        Connection dbConnection = null;
        ResultSet rs = null;
        PreparedStatement prepStmt = null;
        boolean isAuthed = false;
        try {
            dbConnection = this.getDBConnection();
            dbConnection.setAutoCommit(false);
            String sqlstmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("SelectUserNameSQL") : this.realmConfig.getUserStoreProperty("SelectUserNameSQLCaseInsensitive");
            if (log.isDebugEnabled()) {
                log.debug((Object)sqlstmt);
            }
            prepStmt = dbConnection.prepareStatement(sqlstmt);
            prepStmt.setString(1, userName);
            if (sqlstmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String userID = rs.getString(1);
                String storedPassword = rs.getString(3);
                String saltValue = null;
                if ("true".equalsIgnoreCase(this.realmConfig.getUserStoreProperty("StoreSaltedPassword"))) {
                    saltValue = rs.getString(4);
                }
                boolean requireChange = rs.getBoolean(5);
                Timestamp changedTime = rs.getTimestamp(6);
                GregorianCalendar gc = new GregorianCalendar();
                gc.add(10, -24);
                Date date = gc.getTime();
                if (requireChange && changedTime.before(date)) {
                    isAuthed = false;
                    authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
                    authenticationResult.setFailureReason(new FailureReason("Password change required."));
                    continue;
                }
                String password = this.preparePassword(credential, saltValue);
                if (storedPassword == null || !storedPassword.equals(password)) continue;
                isAuthed = true;
                User user = this.getUser(userID, userName);
                authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.SUCCESS);
                authenticationResult.setAuthenticatedUser(user);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Error occurred while retrieving user authentication info for userName : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException("Authentication Failure", e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        if (log.isDebugEnabled()) {
            log.debug((Object)("UserName " + userName + " login attempt. Login success: " + isAuthed));
        }
        return authenticationResult;
    }

    private AuthenticationResult getAuthenticationResult(String reason) {
        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
        authenticationResult.setFailureReason(new FailureReason(reason));
        return authenticationResult;
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public User doAddUserWithID(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        String userID = this.getUniqueUserID();
        this.updateLocationClaimWithUserId(userID, claims);
        claims = this.addUserNameAttribute(userName, claims);
        claims = this.addUserIDAttribute(userID, claims);
        this.persistUser(userID, userName, credential, roleList, claims, profileName, requirePasswordChange);
        return this.getUser(userID, userName);
    }

    protected void persistUser(String userID, String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        Secret credentialObj;
        Connection dbConnection;
        try {
            dbConnection = this.getDBConnection();
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting DB connection.";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        try {
            credentialObj = Secret.getSecret((Object)credential);
        }
        catch (UnsupportedSecretTypeException e) {
            throw new UserStoreException("Unsupported credential type.", e);
        }
        try {
            String sqlStmt1 = this.realmConfig.getUserStoreProperty("AddUserWithIDSQL");
            String saltValue = null;
            if ("true".equalsIgnoreCase((String)this.realmConfig.getUserStoreProperties().get("StoreSaltedPassword"))) {
                saltValue = this.generateSaltValue();
            }
            String password = this.preparePassword(credentialObj, saltValue);
            if (sqlStmt1.contains("UM_TENANT_ID") && saltValue == null) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userID, userName, password, "", requirePasswordChange, new Date(), this.tenantId);
            } else if (sqlStmt1.contains("UM_TENANT_ID") && saltValue != null) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userID, userName, password, saltValue, requirePasswordChange, new Date(), this.tenantId);
            } else if (!sqlStmt1.contains("UM_TENANT_ID") && saltValue == null) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userID, userName, password, "", requirePasswordChange, new Date());
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userID, userName, password, saltValue, requirePasswordChange, new Date());
            }
            if (roleList != null && roleList.length > 0) {
                String sqlStmt2;
                RoleBreakdown breakdown = this.getSharedRoleBreakdown(roleList);
                String[] roles = breakdown.getRoles();
                String[] sharedRoles = breakdown.getSharedRoles();
                Integer[] sharedTenantIds = breakdown.getSharedTenantIDs();
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                if (roles.length > 0) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddRoleToUserWithIDSQL-" + type);
                    if (sqlStmt2 == null) {
                        sqlStmt2 = this.realmConfig.getUserStoreProperty("AddRoleToUserWithIDSQL");
                    }
                    if (sqlStmt2.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, roles, this.tenantId, userID, this.tenantId);
                        } else {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roles, this.tenantId, userID, this.tenantId, this.tenantId);
                        }
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roleList, userID);
                    }
                }
                if (sharedRoles.length > 0) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddSharedRoleToUserWithIDSQL");
                    DatabaseUtil.udpateUserRoleMappingWithExactParams(dbConnection, sqlStmt2, sharedRoles, userID, sharedTenantIds, this.tenantId);
                }
            }
            if (claims != null) {
                if (profileName == null) {
                    profileName = "default";
                }
                HashMap<String, String> userStoreAttributeValues = new HashMap<String, String>();
                for (Map.Entry<String, String> claimEntry : claims.entrySet()) {
                    userStoreAttributeValues.put(this.getClaimAtrribute(claimEntry.getKey(), userID, null), claimEntry.getValue());
                }
                this.addPropertiesWithID(dbConnection, userID, userStoreAttributeValues, profileName);
            }
            dbConnection.commit();
        }
        catch (Exception e) {
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                String errorMessage = "Error while rollback add user operation for user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e1);
                }
                throw new UserStoreException(errorMessage, e1);
            }
            String errorMessage = "Error while persisting user : " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            if (e instanceof UserStoreException && UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_WRITING_TO_DATABASE.getCode().equals(((UserStoreException)((Object)e)).getErrorCode())) {
                throw new UserStoreException(errorMessage, UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_A_USER.getCode(), e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            credentialObj.clear();
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    protected String doGetUserIDFromUserNameWithID(String userName) throws UserStoreException {
        if (userName == null) {
            throw new IllegalArgumentException("userName cannot be null.");
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String userID = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("SelectUserIDFromUserNameSQL") : this.realmConfig.getUserStoreProperty("SelectUserIDFromUserNameSQLCaseInsensitive");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, userName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                userID = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Database error occurred while retrieving userID for a UserName : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return userID;
    }

    @Override
    public String getUserIDFromProperties(String claimURI, String claimValue, String profileName) throws UserStoreException {
        try {
            String property = this.claimManager.getAttributeName(this.getMyDomainName(), claimURI);
            if (property == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Could not find the matching property for claim URI: " + claimURI + " in user domain: " + this.getMyDomainName()));
                }
                return null;
            }
            List<String> userIds = this.doGetUserListFromPropertiesWithID(property, claimValue, profileName);
            if (userIds.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No UserID found for the claim: " + claimURI + ", value: " + claimValue + ", in domain: " + this.getMyDomainName()));
                }
                return null;
            }
            if (userIds.size() > 1) {
                throw new UserStoreException("Invalid scenario. Multiple users cannot be found for the given value: " + claimValue + "of the claim: " + claimURI);
            }
            return userIds.get(0);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException("Error occurred while retrieving the userId of domain : " + this.getMyDomainName() + " and claim" + claimURI + " value: " + claimValue, e);
        }
    }

    @Override
    public String doGetUserNameFromUserIDWithID(String userID) throws UserStoreException {
        if (userID == null) {
            throw new IllegalArgumentException("userID cannot be null.");
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String userName = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = this.realmConfig.getUserStoreProperty("SelectUserNameFromUserIDSQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, userID);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                userName = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Database error occurred while retrieving userName for a userID : " + userID;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return userName;
    }

    @Override
    public void doAddRoleWithID(String roleName, String[] userIDList, boolean shared) throws UserStoreException {
        if (shared && this.isSharedGroupEnabled()) {
            this.doAddSharedRoleWithID(roleName, userIDList);
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = this.realmConfig.getUserStoreProperty("AddRoleSQL");
            if (sqlStmt.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, roleName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, roleName);
            }
            if (userIDList != null) {
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                String sqlStmt2 = this.realmConfig.getUserStoreProperty("AddUserToRoleWithIDSQL-" + type);
                if (sqlStmt2 == null) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddUserToRoleWithIDSQL");
                }
                if (sqlStmt2.contains("UM_TENANT_ID")) {
                    if ("openedge".equals(type)) {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, userIDList, this.tenantId, roleName, this.tenantId);
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, userIDList, this.tenantId, roleName, this.tenantId, this.tenantId);
                    }
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, userIDList, roleName);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            DatabaseUtil.rollBack(dbConnection);
            String msg = "Error occurred while adding role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while getting database type from DB connection";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            if (e instanceof UserStoreException && UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_WRITING_TO_DATABASE.getCode().equals(((UserStoreException)((Object)e)).getErrorCode())) {
                throw new UserStoreException(errorMessage, UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_ROLE.getCode(), e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public String[] doListUsers(String filter, int maxItemLimit) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doDeleteUserWithID(String userID) throws UserStoreException {
        String sqlStmt1 = this.realmConfig.getUserStoreProperty("OnDeleteUserRemoveUserRoleMappingWithIDSQL");
        if (sqlStmt1 == null) {
            throw new UserStoreException("The sql statement for delete user-role mapping is null.");
        }
        String sqlStmt2 = this.realmConfig.getUserStoreProperty("OnDeleteUserRemoveUserAttributeWithIDSQL");
        if (sqlStmt2 == null) {
            throw new UserStoreException("The sql statement for delete user attribute is null.");
        }
        String sqlStmt3 = this.realmConfig.getUserStoreProperty("DeleteUserWithIDSQL");
        if (sqlStmt3 == null) {
            throw new UserStoreException("The sql statement for delete user is null.");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            if (sqlStmt1.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userID, this.tenantId, this.tenantId);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt2, userID, this.tenantId, this.tenantId);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt3, userID, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userID);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt2, userID);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt3, userID);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            DatabaseUtil.rollBack(dbConnection);
            String msg = "Error occurred while deleting user : " + userID;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doUpdateUserListOfRoleWithID(String roleName, String[] deletedUserIDs, String[] newUserIDs) throws UserStoreException {
        JDBCRoleContext ctx = (JDBCRoleContext)this.createRoleContext(roleName);
        roleName = ctx.getRoleName();
        int roleTenantId = ctx.getTenantId();
        boolean isShared = ctx.isShared();
        String sqlStmt1 = this.realmConfig.getUserStoreProperty(isShared ? "RemoveUserFromSharedRoleWithIDSQL" : "RemoveUserFromRoleWithIDSQL");
        if (sqlStmt1 == null) {
            throw new UserStoreException("The sql statement for remove user from role is null.");
        }
        Connection dbConnection = null;
        try {
            String sqlStmt2;
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            if (!isShared) {
                sqlStmt2 = this.realmConfig.getUserStoreProperty("AddUserToRoleWithIDSQL-" + type);
                if (sqlStmt2 == null) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddUserToRoleWithIDSQL");
                }
            } else {
                sqlStmt2 = this.realmConfig.getUserStoreProperty("AddSharedRoleToUserWithIDSQL");
            }
            if (sqlStmt2 == null) {
                throw new UserStoreException("The sql statement for add user to role is null.");
            }
            if (deletedUserIDs != null) {
                if (isShared) {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, roleName, this.tenantId, deletedUserIDs, this.tenantId, this.tenantId, roleTenantId);
                } else if (sqlStmt1.contains("UM_TENANT_ID")) {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedUserIDs, this.tenantId, roleName, this.tenantId, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedUserIDs, roleName);
                }
            }
            if (newUserIDs != null) {
                if (isShared) {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roleName, roleTenantId, newUserIDs, this.tenantId, this.tenantId, roleTenantId);
                } else if (sqlStmt1.contains("UM_TENANT_ID")) {
                    if ("openedge".equals(type)) {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, newUserIDs, this.tenantId, roleName, this.tenantId);
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newUserIDs, this.tenantId, roleName, this.tenantId, this.tenantId);
                    }
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newUserIDs, roleName);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            DatabaseUtil.rollBack(dbConnection);
            String msg = "Database error occurred while updating user list of role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while getting database type from DB connection";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    private RoleBreakdown getSharedRoleBreakdown(String[] rolesList) {
        ArrayList<String> roles = new ArrayList<String>();
        ArrayList<Integer> tenantIds = new ArrayList<Integer>();
        ArrayList<String> sharedRoles = new ArrayList<String>();
        ArrayList<Integer> sharedTenantIds = new ArrayList<Integer>();
        for (String role : rolesList) {
            if (!StringUtils.isNotEmpty((String)role)) continue;
            String[] deletedRoleNames = role.split(CarbonConstants.DOMAIN_SEPARATOR);
            if (deletedRoleNames.length > 1) {
                role = deletedRoleNames[1];
            }
            JDBCRoleContext ctx = (JDBCRoleContext)this.createRoleContext(role);
            role = ctx.getRoleName();
            int roleTenantId = ctx.getTenantId();
            boolean isShared = ctx.isShared();
            if (isShared) {
                sharedRoles.add(role);
                sharedTenantIds.add(roleTenantId);
                continue;
            }
            roles.add(role);
            tenantIds.add(roleTenantId);
        }
        RoleBreakdown breakdown = new RoleBreakdown();
        breakdown.setRoles(roles.toArray(new String[0]));
        breakdown.setTenantIds(tenantIds.toArray(new Integer[0]));
        breakdown.setSharedRoles(sharedRoles.toArray(new String[0]));
        breakdown.setSharedTenantIDs(sharedTenantIds.toArray(new Integer[0]));
        return breakdown;
    }

    @Override
    public void doUpdateRoleListOfUserWithID(String userID, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            String sqlStmt2 = null;
            String[] userNames = userID.split(CarbonConstants.DOMAIN_SEPARATOR);
            if (userNames.length > 1) {
                userID = userNames[1];
            }
            if (deletedRoles != null && deletedRoles.length > 0) {
                String sqlStmt1;
                RoleBreakdown breakdown = this.getSharedRoleBreakdown(deletedRoles);
                String[] roles = breakdown.getRoles();
                String[] sharedRoles = breakdown.getSharedRoles();
                Integer[] sharedTenantIds = breakdown.getSharedTenantIDs();
                if (roles.length > 0) {
                    sqlStmt1 = this.realmConfig.getUserStoreProperty("RemoveRoleFromUserWithIDSQL");
                    if (sqlStmt1 == null) {
                        throw new UserStoreException("The sql statement for remove user from role is null.");
                    }
                    if (sqlStmt1.contains("UM_TENANT_ID")) {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, roles, this.tenantId, userID, this.tenantId, this.tenantId);
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, roles, userID);
                    }
                }
                if (sharedRoles.length > 0) {
                    sqlStmt1 = this.realmConfig.getUserStoreProperty("RemoveUserFromSharedRoleWithIDSQL");
                    if (sqlStmt1 == null) {
                        throw new UserStoreException("The sql statement for remove user from role is null");
                    }
                    DatabaseUtil.udpateUserRoleMappingWithExactParams(dbConnection, sqlStmt1, sharedRoles, userID, sharedTenantIds, this.tenantId);
                }
            }
            if (newRoles != null && newRoles.length > 0) {
                ArrayList<String> newRoleList = new ArrayList<String>();
                for (String role : newRoles) {
                    if (!this.isExistingRole(role)) {
                        String errorMessage = "The role: " + role + " does not exist.";
                        throw new UserStoreException(errorMessage);
                    }
                    if (this.doCheckIsUserInRoleWithID(userID, role)) continue;
                    newRoleList.add(role);
                }
                String[] rolesToAdd = newRoleList.toArray(new String[0]);
                RoleBreakdown breakdown = this.getSharedRoleBreakdown(rolesToAdd);
                String[] roles = breakdown.getRoles();
                String[] sharedRoles = breakdown.getSharedRoles();
                Integer[] sharedTenantIds = breakdown.getSharedTenantIDs();
                if (roles.length > 0) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddRoleToUserWithIDSQL-" + type);
                    if (sqlStmt2 == null) {
                        sqlStmt2 = this.realmConfig.getUserStoreProperty("AddRoleToUserWithIDSQL");
                    }
                    if (sqlStmt2 == null) {
                        throw new UserStoreException("The sql statement for add user to role is null.");
                    }
                    if (sqlStmt2.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, roles, this.tenantId, userID, this.tenantId);
                        } else {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roles, this.tenantId, userID, this.tenantId, this.tenantId);
                        }
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newRoles, userID);
                    }
                }
                if (sharedRoles.length > 0) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddSharedRoleToUserWithIDSQL");
                    if (sqlStmt2 == null) {
                        throw new UserStoreException("The sql statement for remove user from role is null.");
                    }
                    DatabaseUtil.udpateUserRoleMappingWithExactParams(dbConnection, sqlStmt2, sharedRoles, userID, sharedTenantIds, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            DatabaseUtil.rollBack(dbConnection);
            String msg = "Database error occurred while updating role list of user : " + userID;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (UserStoreException e) {
            String errorMessage = "Error occurred while updating role list of user:" + userID;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)((Object)e));
            }
            throw new UserStoreException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while getting database type from DB connection";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public String[] doGetExternalRoleListOfUser(String userName, String filter) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    protected void doSetUserAttributeWithID(String userID, String attributeName, String value, String profileName) throws UserStoreException {
        if (profileName == null) {
            profileName = "default";
        }
        if (value == null) {
            throw new UserStoreException("Cannot set null values.");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String propertyValue = this.getProperty(dbConnection, userID, attributeName, profileName);
            if (propertyValue == null) {
                this.addPropertyWithID(dbConnection, userID, attributeName, value, profileName);
            } else {
                this.updatePropertyWithID(dbConnection, userID, attributeName, value, profileName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            DatabaseUtil.rollBack(dbConnection);
            String msg = "Database error occurred while saving user claim value for user : " + userID + " & attribute : " + attributeName + " claim value : " + value;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (UserStoreException e) {
            String errorMessage = "Error occurred while adding or updating claim value for user : " + userID + " attribute : " + attributeName + " profile : " + profileName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)((Object)e));
            }
            throw new UserStoreException(errorMessage, (Throwable)((Object)e));
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doSetUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doSetUserClaimValues(String userName, Map<String, List<String>> multiValuedClaimsToAdd, Map<String, List<String>> multiValuedClaimsToDelete, Map<String, List<String>> claimsExcludingMultiValuedClaims, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doSetUserClaimValuesWithID(String userID, Map<String, String> claims, String profileName) throws UserStoreException {
        claims.putIfAbsent("profileConfiguration", "default");
        super.doSetUserClaimValuesWithID(userID, claims, profileName);
    }

    @Override
    public void doSetUserClaimValuesWithID(String userID, Map<String, List<String>> multiValuedClaimsToAdd, Map<String, List<String>> multiValuedClaimsToDelete, Map<String, List<String>> claimsExcludingMultiValuedClaims, String profileName) throws NotImplementedException {
        throw new NotImplementedException("This functionality is not yet implemented for UniqueID JDBC userstores.");
    }

    @Override
    protected void doSetUserAttributesWithID(String userId, Map<String, String> processedClaimAttributes, String profileName) throws UserStoreException {
        Connection dbConnection = null;
        try {
            Set<String> receivedProperties = processedClaimAttributes.keySet();
            Map<String, String> alreadyAvailableProperties = this.getUserPropertyValuesWithID(userId, receivedProperties.toArray(new String[0]), profileName);
            dbConnection = this.getDBConnection();
            this.addPropertiesWithID(dbConnection, userId, this.filterNewlyAddedProperties(processedClaimAttributes, alreadyAvailableProperties), profileName);
            this.updateProperties(dbConnection, userId, this.filterUpdatedProperties(processedClaimAttributes, receivedProperties, alreadyAvailableProperties), profileName);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Database error occurred while setting user claim values for user : " + userId;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    @Override
    protected void doSetUserAttributesWithID(String userID, Map<String, List<String>> claimAttributesToAdd, Map<String, List<String>> claimAttributesToDelete, Map<String, List<String>> claimAttributesToReplace, String profileName) throws NotImplementedException {
        throw new NotImplementedException("This functionality is not yet implemented for JDBC userstores.");
    }

    @Override
    protected void doSetUserAttribute(String userName, String attributeName, String value, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    protected void doSetUserAttributes(String userName, Map<String, String> processedClaimAttributes, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    protected void doSetUserAttributes(String userID, Map<String, List<String>> claimAttributesToAdd, Map<String, List<String>> claimAttributesToDelete, Map<String, List<String>> claimAttributesToReplace, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doDeleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doDeleteUserClaimValueWithID(String userID, String claimURI, String profileName) throws UserStoreException {
        Connection dbConnection = null;
        if (profileName == null) {
            profileName = "default";
        }
        try {
            String property = "profileConfiguration".equals(claimURI) ? "profileConfiguration" : this.getClaimAtrribute(claimURI, userID, null);
            dbConnection = this.getDBConnection();
            this.deletePropertyWithID(dbConnection, userID, property, profileName);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Database error occurred while deleting user claim value for user : " + userID + " & claim URI : " + claimURI;
                if (!log.isDebugEnabled()) throw new UserStoreException(msg, e);
                log.debug((Object)msg, (Throwable)e);
                throw new UserStoreException(msg, e);
                catch (org.wso2.carbon.user.api.UserStoreException e2) {
                    String errorMessage = "Error occurred while getting claim attribute for user : " + userID + " & claim URI : " + claimURI;
                    if (!log.isDebugEnabled()) throw new UserStoreException(errorMessage, e2);
                    log.debug((Object)errorMessage, (Throwable)e2);
                    throw new UserStoreException(errorMessage, e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    @Override
    public void doDeleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doDeleteUserClaimValuesWithID(String userID, String[] claims, String profileName) throws UserStoreException {
        Connection dbConnection = null;
        if (profileName == null) {
            profileName = "default";
        }
        try {
            dbConnection = this.getDBConnection();
            for (String claimURI : claims) {
                String property = this.getClaimAtrribute(claimURI, userID, null);
                this.deletePropertyWithID(dbConnection, userID, property, profileName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            DatabaseUtil.rollBack(dbConnection);
            String msg = "Database error occurred while deleting user claim values for user : " + userID;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String errorMessage = "Error occurred while getting claim attribute for user : " + userID;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doUpdateCredentialWithID(String userID, Object newCredential, Object oldCredential) throws UserStoreException {
        this.doUpdateCredentialByAdminWithID(userID, newCredential);
    }

    @Override
    public void doUpdateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doUpdateCredentialByAdminWithID(String userID, Object newCredential) throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("UpdateUserPasswordWithIDSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for delete user claim value is null");
        }
        String saltValue = null;
        if ("true".equalsIgnoreCase((String)this.realmConfig.getUserStoreProperties().get("StoreSaltedPassword"))) {
            saltValue = this.generateSaltValue();
        }
        String password = this.preparePassword(newCredential, saltValue);
        if (sqlStmt.contains("UM_TENANT_ID") && saltValue == null) {
            this.updateStringValuesToDatabase(null, sqlStmt, password, "", false, new Date(), userID, this.tenantId);
        } else if (sqlStmt.contains("UM_TENANT_ID") && saltValue != null) {
            this.updateStringValuesToDatabase(null, sqlStmt, password, saltValue, false, new Date(), userID, this.tenantId);
        } else if (!sqlStmt.contains("UM_TENANT_ID") && saltValue == null) {
            this.updateStringValuesToDatabase(null, sqlStmt, password, "", false, new Date(), userID);
        } else {
            this.updateStringValuesToDatabase(null, sqlStmt, password, saltValue, false, new Date(), userID);
        }
    }

    @Override
    public void doDeleteUser(String userName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public Date doGetPasswordExpirationTimeWithID(String userID) throws UserStoreException {
        Date date;
        PreparedStatement prepStmt;
        ResultSet rs;
        Connection dbConnection;
        block9: {
            if (userID != null && userID.contains(CarbonConstants.DOMAIN_SEPARATOR)) {
                return super.getPasswordExpirationTimeWithID(userID);
            }
            dbConnection = null;
            rs = null;
            prepStmt = null;
            date = null;
            try {
                dbConnection = this.getDBConnection();
                dbConnection.setAutoCommit(false);
                String sqlstmt = this.realmConfig.getUserStoreProperty("SelectUserIDWithIDSQL");
                if (log.isDebugEnabled()) {
                    log.debug((Object)sqlstmt);
                }
                prepStmt = dbConnection.prepareStatement(sqlstmt);
                prepStmt.setString(1, userID);
                if (sqlstmt.contains("UM_TENANT_ID")) {
                    prepStmt.setInt(2, this.tenantId);
                }
                if (!(rs = prepStmt.executeQuery()).next()) break block9;
                boolean requireChange = rs.getBoolean(1);
                Timestamp changedTime = rs.getTimestamp(2);
                if (requireChange) {
                    GregorianCalendar gc = new GregorianCalendar();
                    gc.setTime(changedTime);
                    gc.add(10, 24);
                    date = gc.getTime();
                }
            }
            catch (SQLException e) {
                try {
                    String msg = "Error occurred while retrieving password expiration time for user : " + userID;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg, (Throwable)e);
                    }
                    throw new UserStoreException(msg, e);
                }
                catch (Throwable throwable) {
                    DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                    throw throwable;
                }
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return date;
    }

    private String generateSaltValue() {
        String saltValue;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance(SHA_1_PRNG);
            byte[] bytes = new byte[16];
            secureRandom.nextBytes(bytes);
            saltValue = Base64.encode((byte[])bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA1PRNG algorithm could not be found.");
        }
        return saltValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateStringValuesToDatabase(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        PreparedStatement prepStmt;
        block16: {
            prepStmt = null;
            boolean localConnection = false;
            try {
                if (dbConnection == null) {
                    localConnection = true;
                    dbConnection = this.getDBConnection();
                }
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                if (params != null && params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        Object param = params[i];
                        if (param == null) {
                            throw new UserStoreException("Invalid data provided");
                        }
                        if (param instanceof String) {
                            prepStmt.setString(i + 1, (String)param);
                            continue;
                        }
                        if (param instanceof Integer) {
                            prepStmt.setInt(i + 1, (Integer)param);
                            continue;
                        }
                        if (param instanceof Date) {
                            prepStmt.setTimestamp(i + 1, new Timestamp(System.currentTimeMillis()));
                            continue;
                        }
                        if (!(param instanceof Boolean)) continue;
                        prepStmt.setBoolean(i + 1, (Boolean)param);
                    }
                }
                int count = prepStmt.executeUpdate();
                if (log.isDebugEnabled()) {
                    if (count == 0) {
                        log.debug((Object)"No rows were updated");
                    }
                    log.debug((Object)("Executed query is " + sqlStmt + " and number of updated rows :: " + count));
                }
                if (localConnection) {
                    dbConnection.commit();
                }
                if (!localConnection) break block16;
            }
            catch (SQLException e) {
                try {
                    DatabaseUtil.rollBack(dbConnection);
                    String msg = "Error occurred while updating string values to database.";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg, (Throwable)e);
                    }
                    if (!(e instanceof SQLIntegrityConstraintViolationException)) throw new UserStoreException(msg, e);
                    throw new UserStoreException(msg, UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_WRITING_TO_DATABASE.getCode(), e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    public void addPropertyWithID(Connection dbConnection, String userID, String propertyName, String value, String profileName) throws UserStoreException {
        try {
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            String sqlStmt = this.realmConfig.getUserStoreProperty("AddUserPropertyWithIDSQL-" + type);
            if (sqlStmt == null) {
                sqlStmt = this.realmConfig.getUserStoreProperty("AddUserPropertyWithIDSQL");
            }
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for add user property sql is null");
            }
            if (sqlStmt.contains("UM_TENANT_ID")) {
                if ("openedge".equals(type)) {
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt, propertyName, value, profileName, this.tenantId, userID, this.tenantId);
                } else {
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt, userID, this.tenantId, propertyName, value, profileName, this.tenantId);
                }
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, userID, propertyName, value, profileName);
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while adding user property for user : " + userID + " & property name : " + propertyName + " & value : " + value;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
    }

    protected void updatePropertyWithID(Connection dbConnection, String userID, String propertyName, String value, String profileName) throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("UpdateUserPropertyWithIDSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for add user property sql is null.");
        }
        if (sqlStmt.contains("UM_TENANT_ID")) {
            this.updateStringValuesToDatabase(dbConnection, sqlStmt, value, userID, this.tenantId, propertyName, profileName, this.tenantId);
        } else {
            this.updateStringValuesToDatabase(dbConnection, sqlStmt, value, userID, propertyName, profileName);
        }
    }

    protected void deletePropertyWithID(Connection dbConnection, String userID, String propertyName, String profileName) throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("DeleteUserPropertyWWithIDSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for add user property sql is null.");
        }
        if (sqlStmt.contains("UM_TENANT_ID")) {
            this.updateStringValuesToDatabase(dbConnection, sqlStmt, userID, this.tenantId, propertyName, profileName, this.tenantId);
        } else {
            this.updateStringValuesToDatabase(dbConnection, sqlStmt, userID, propertyName, profileName);
        }
    }

    @Override
    protected String getProperty(Connection dbConnection, String userID, String propertyName, String profileName) throws UserStoreException {
        String string;
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserPropertyForProfileWithIDSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for add user property sql is null");
        }
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String value = null;
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, userID);
            prepStmt.setString(2, propertyName);
            prepStmt.setString(3, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                value = rs.getString(1);
            }
            string = value;
        }
        catch (SQLException e) {
            try {
                String msg = "Error occurred while retrieving user profile property for user : " + userID + " & property name : " + propertyName + " & profile name : " + profileName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return string;
    }

    @Override
    public List<String> doGetUserListFromPropertiesWithID(String property, String value, String profileName) throws UserStoreException {
        String sqlStmt;
        if (profileName == null) {
            profileName = "default";
        }
        if (value == null) {
            throw new IllegalArgumentException("Filter value cannot be null");
        }
        if (value.contains(QUERY_FILTER_STRING_ANY)) {
            if (!value.matches("(\\*)\\1+")) {
                value = value.replaceAll("(?<!\\\\)\\*", SQL_FILTER_STRING_ANY);
            }
            sqlStmt = !this.isCaseSensitiveUsername() && UID.equals(property) ? this.realmConfig.getUserStoreProperty("GetUserListForPropertyWithIDSQLCaseInsensitive") : this.realmConfig.getUserStoreProperty("GetUserLisForPropertyWithIDSQL");
        } else {
            sqlStmt = !this.isCaseSensitiveUsername() && UID.equals(property) ? this.realmConfig.getUserStoreProperty("GetUserListForClaimValueWithIDSQLCaseInsensitive") : this.realmConfig.getUserStoreProperty("GetUserListForClaimValueWithIDSQL");
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<String> userList = new ArrayList<String>();
        try {
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, property);
            prepStmt.setString(2, value);
            prepStmt.setString(3, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String userID = rs.getString(1);
                userList.add(userID);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Database error occurred while listing users for a property : " + property + " & value : " + value + " & profile name : " + profileName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return userList;
    }

    @Override
    public boolean doAuthenticate(String userName, Object credential) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public String[] doGetExternalRoleListOfUserWithID(String userID, String filter) throws UserStoreException {
        String[] names;
        String sqlStmt;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting roles of user: " + userID + " with filter: " + filter));
        }
        if (filter.equals(QUERY_FILTER_STRING_ANY) || StringUtils.isEmpty((String)filter)) {
            sqlStmt = this.realmConfig.getUserStoreProperty("UserRoleWithIDSQL");
            names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, userID, this.tenantId, this.tenantId, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, userID);
        } else {
            filter = filter.trim();
            filter = filter.replace(QUERY_FILTER_STRING_ANY, SQL_FILTER_STRING_ANY);
            filter = filter.replace("?", "_");
            sqlStmt = this.realmConfig.getUserStoreProperty("UserRoleExistWithIDSQL");
            names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, userID, this.tenantId, this.tenantId, this.tenantId, filter) : this.getStringValuesFromDatabase(sqlStmt, userID, filter);
        }
        ArrayList roles = new ArrayList();
        if (log.isDebugEnabled()) {
            if (names != null) {
                for (String name : names) {
                    log.debug((Object)("Found role: " + name));
                }
            } else {
                log.debug((Object)("No external role found for the user: " + userID));
            }
        }
        Collections.addAll(roles, names);
        return roles.toArray(new String[0]);
    }

    @Override
    protected String[] doGetSharedRoleListOfUser(String userName, String tenantDomain, String filter) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    protected Map<String, Map<String, String>> getUsersPropertyValuesWithID(List<String> users, String[] propertyNames, String profileName) throws UserStoreException {
        HashMap<String, Map<String, String>> name2;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Object[] propertyNamesSorted = (String[])propertyNames.clone();
        Arrays.sort(propertyNamesSorted);
        HashMap<String, Map<String, String>> usersPropertyValuesMap = new HashMap<String, Map<String, String>>();
        try {
            dbConnection = this.getDBConnection();
            StringBuilder usernameParameter = new StringBuilder();
            String sqlStmt = this.realmConfig.getUserStoreProperty("GetUsersPropertiesForProfileWithIDSQL");
            for (int i = 0; i < users.size(); ++i) {
                usernameParameter.append("'").append(users.get(i)).append("'");
                if (i == users.size() - 1) continue;
                usernameParameter.append(",");
            }
            sqlStmt = sqlStmt.replaceFirst("\\?", usernameParameter.toString());
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
                prepStmt.setInt(3, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String name2 = rs.getString(2);
                if (Arrays.binarySearch(propertyNamesSorted, name2) < 0) continue;
                String userID = rs.getString(1);
                String value = rs.getString(3);
                if (usersPropertyValuesMap.get(userID) != null) {
                    ((Map)usersPropertyValuesMap.get(userID)).put(name2, value);
                    continue;
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put(name2, value);
                usersPropertyValuesMap.put(userID, attributes);
            }
            name2 = usersPropertyValuesMap;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error Occurred while getting property values";
                if (log.isDebugEnabled()) {
                    errorMessage = errorMessage + ": " + users;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return name2;
    }

    @Override
    protected Map<String, List<String>> doGetExternalRoleListOfUsers(List<String> userNames) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    protected Map<String, List<String>> doGetExternalRoleListOfUsersWithID(List<String> userIDs) throws UserStoreException {
        HashMap<String, List<String>> hashMap;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting roles of users: " + userIDs));
        }
        HashMap<String, List<String>> rolesListOfUsersMap = new HashMap<String, List<String>>();
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            dbConnection = this.getDBConnection();
            StringBuilder usernameParameter = new StringBuilder();
            String sqlStmt = this.realmConfig.getUserStoreProperty("UsersRoleWithIDSQL");
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for retrieving users roles is null.");
            }
            for (int i = 0; i < userIDs.size(); ++i) {
                usernameParameter.append("'").append(userIDs.get(i)).append("'");
                if (i == userIDs.size() - 1) continue;
                usernameParameter.append(",");
            }
            sqlStmt = sqlStmt.replaceFirst("\\?", usernameParameter.toString());
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(1, this.tenantId);
                prepStmt.setInt(2, this.tenantId);
                prepStmt.setInt(3, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            String domainName = this.getMyDomainName();
            while (rs.next()) {
                String userID = rs.getString(1);
                String roleName = rs.getString(2);
                if (rolesListOfUsersMap.get(userID) != null) {
                    ((List)rolesListOfUsersMap.get(userID)).add(roleName);
                    continue;
                }
                ArrayList<String> roleNames = new ArrayList<String>();
                roleNames.add(roleName);
                rolesListOfUsersMap.put(userID, roleNames);
            }
            hashMap = rolesListOfUsersMap;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error Occurred while getting role lists of users.";
                if (log.isDebugEnabled()) {
                    errorMessage = errorMessage + ": " + userIDs;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return hashMap;
    }

    protected void doAddSharedRoleWithID(String roleName, String[] userList) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = this.realmConfig.getUserStoreProperty("AddSharedRoleSQL");
            if (sqlStmt.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, true, roleName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, true, roleName);
            }
            if (userList != null) {
                int roleTenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
                sqlStmt = this.realmConfig.getUserStoreProperty("AddSharedRoleToUserWithIDSQL");
                DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt, roleName, roleTenantId, userList, this.tenantId, this.tenantId, roleTenantId);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String msg = "Database error occurred while adding shared role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (Exception e) {
            String msg = "Error occurred while adding shared role.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public String[] doGetSharedRoleListOfUserWithID(String userID, String tenantDomain, String filter) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking for shared roles for user: " + userID + " for tenant: " + tenantDomain));
        }
        if (this.isSharedGroupEnabled()) {
            String sqlStmt = this.realmConfig.getUserStoreProperty("UserSharedRoleWithIDSQL");
            String[] sharedNames = this.getRoleNamesWithDomainWithID(sqlStmt, userID, this.tenantId, true);
            return sharedNames;
        }
        return new String[0];
    }

    @Override
    public void doAddRole(String roleName, String[] userList, boolean shared) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addPropertiesWithID(Connection dbConnection, String userID, Map<String, String> properties, String profileName) throws UserStoreException {
        PreparedStatement prepStmt;
        block19: {
            String type;
            try {
                type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            }
            catch (Exception e) {
                String msg = "Error occurred while adding user properties for user : " + userID;
                if (!log.isDebugEnabled()) throw new UserStoreException(msg, e);
                log.debug((Object)msg, (Throwable)e);
                throw new UserStoreException(msg, e);
            }
            String sqlStmt = this.realmConfig.getUserStoreProperty("AddUserPropertyWithIDSQL-" + type);
            if (sqlStmt == null) {
                sqlStmt = this.realmConfig.getUserStoreProperty("AddUserPropertyWithIDSQL");
            }
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for add user property sql is null");
            }
            prepStmt = null;
            boolean localConnection = false;
            try {
                if (dbConnection == null) {
                    localConnection = true;
                    dbConnection = this.getDBConnection();
                }
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                HashMap<String, String> userAttributes = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    String attributeName = entry.getKey();
                    String attributeValue = entry.getValue();
                    userAttributes.put(attributeName, attributeValue);
                }
                for (Map.Entry<String, String> entry : userAttributes.entrySet()) {
                    String propertyName = entry.getKey();
                    String propertyValue = entry.getValue();
                    if (sqlStmt.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            this.batchUpdateStringValuesToDatabase(prepStmt, propertyName, propertyValue, profileName, this.tenantId, userID, this.tenantId);
                            continue;
                        }
                        this.batchUpdateStringValuesToDatabase(prepStmt, userID, this.tenantId, propertyName, propertyValue, profileName, this.tenantId);
                        continue;
                    }
                    this.batchUpdateStringValuesToDatabase(prepStmt, userID, propertyName, propertyValue, profileName);
                }
                int[] counts = prepStmt.executeBatch();
                if (log.isDebugEnabled()) {
                    void var11_19;
                    boolean bl = false;
                    if (counts != null) {
                        int i;
                        int[] nArray = counts;
                        int n = nArray.length;
                        for (int j = 0; j < n; var11_19 += i, ++j) {
                            i = nArray[j];
                        }
                    }
                    if (var11_19 == false) {
                        log.debug((Object)"No rows were updated");
                    }
                    log.debug((Object)("Executed query is " + sqlStmt + " and number of updated rows :: " + (int)var11_19));
                }
                if (localConnection) {
                    dbConnection.commit();
                }
                if (!localConnection) break block19;
            }
            catch (SQLException e) {
                try {
                    DatabaseUtil.rollBack(dbConnection);
                    String msg = "Error occurred while updating string values to database.";
                    if (!log.isDebugEnabled()) throw new UserStoreException(msg, e);
                    log.debug((Object)msg, (Throwable)e);
                    throw new UserStoreException(msg, e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateProperties(Connection dbConnection, String userID, Map<String, String> properties, String profileName) throws UserStoreException {
        PreparedStatement prepStmt;
        block18: {
            String type;
            try {
                type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            }
            catch (Exception e) {
                String msg = "Error occurred while updating user properties for user : " + userID;
                if (!log.isDebugEnabled()) throw new UserStoreException(msg, e);
                log.debug((Object)msg, (Throwable)e);
                throw new UserStoreException(msg, e);
            }
            String sqlStmt = this.realmConfig.getUserStoreProperty("UpdateUserPropertyWithIDSQL-" + type);
            if (sqlStmt == null) {
                sqlStmt = this.realmConfig.getUserStoreProperty("UpdateUserPropertyWithIDSQL");
            }
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for update user property sql is null.");
            }
            prepStmt = null;
            boolean localConnection = false;
            try {
                if (dbConnection == null) {
                    localConnection = true;
                    dbConnection = this.getDBConnection();
                }
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    String propertyName = entry.getKey();
                    String propertyValue = entry.getValue();
                    if (sqlStmt.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            this.batchUpdateStringValuesToDatabase(prepStmt, propertyName, propertyValue, profileName, this.tenantId, userID, this.tenantId);
                            continue;
                        }
                        this.batchUpdateStringValuesToDatabase(prepStmt, propertyValue, userID, this.tenantId, propertyName, profileName, this.tenantId);
                        continue;
                    }
                    this.batchUpdateStringValuesToDatabase(prepStmt, propertyValue, userID, propertyName, profileName);
                }
                int[] counts = prepStmt.executeBatch();
                if (log.isDebugEnabled()) {
                    int totalUpdated = 0;
                    if (counts != null) {
                        int i;
                        int[] nArray = counts;
                        int n = nArray.length;
                        for (int j = 0; j < n; totalUpdated += i, ++j) {
                            i = nArray[j];
                        }
                    }
                    if (totalUpdated == 0) {
                        log.debug((Object)"No rows were updated");
                    }
                    log.debug((Object)("Executed query is " + sqlStmt + " and number of updated rows :: " + totalUpdated));
                }
                if (localConnection) {
                    dbConnection.commit();
                }
                if (!localConnection) break block18;
            }
            catch (SQLException e) {
                try {
                    DatabaseUtil.rollBack(dbConnection);
                    String msg = "Error occurred while updating string values to database.";
                    if (!log.isDebugEnabled()) throw new UserStoreException(msg, e);
                    log.debug((Object)msg, (Throwable)e);
                    throw new UserStoreException(msg, e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    private void batchUpdateStringValuesToDatabase(PreparedStatement prepStmt, Object ... params) throws UserStoreException {
        try {
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    Object param = params[i];
                    if (param == null) {
                        throw new UserStoreException("Invalid data provided");
                    }
                    if (param instanceof String) {
                        prepStmt.setString(i + 1, (String)param);
                        continue;
                    }
                    if (param instanceof Integer) {
                        prepStmt.setInt(i + 1, (Integer)param);
                        continue;
                    }
                    if (param instanceof Date) {
                        prepStmt.setTimestamp(i + 1, new Timestamp(System.currentTimeMillis()));
                        continue;
                    }
                    if (!(param instanceof Boolean)) continue;
                    prepStmt.setBoolean(i + 1, (Boolean)param);
                }
            }
            prepStmt.addBatch();
        }
        catch (SQLException e) {
            String msg = "Error occurred while updating property values to database.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
    }

    private boolean isCaseSensitiveUsername() {
        String isUsernameCaseInsensitiveString = this.realmConfig.getUserStoreProperty(CASE_INSENSITIVE_USERNAME);
        return !Boolean.parseBoolean(isUsernameCaseInsensitiveString);
    }

    @Override
    protected PaginatedSearchResult doListUsers(String filter, int limit, int offset) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected UniqueIDPaginatedSearchResult doListUsersWithID(String filter, int limit, int offset) throws UserStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 10[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int doGetListUsersCountWithID(String filter) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int count = 0;
        try {
            if (filter != null && StringUtils.isNotEmpty((String)filter.trim())) {
                filter = filter.trim().replace(QUERY_FILTER_STRING_ANY, SQL_FILTER_STRING_ANY);
                filter = filter.replace("?", "_");
            } else {
                filter = SQL_FILTER_STRING_ANY;
            }
            dbConnection = this.getDBConnection();
            if (dbConnection == null) {
                throw new UserStoreException("null connection");
            }
            String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("UserFilterPaginatedCountWithIDSQL") : this.realmConfig.getUserStoreProperty("UserFilterPaginatedSQLCaseInsensitiveCountWithID");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, filter);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
            }
            if ((rs = prepStmt.executeQuery()).next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Error occurred while retrieving users count for filter : " + filter;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return count;
    }

    @Override
    public PaginatedSearchResult getUserListFromProperties(String property, String value, String profileName, int limit, int offset) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public UniqueIDPaginatedSearchResult doGetUserListFromPropertiesWithID(String property, String value, String profileName, int limit, int offset) throws UserStoreException {
        UniqueIDPaginatedSearchResult result = new UniqueIDPaginatedSearchResult();
        if (profileName == null) {
            profileName = "default";
        }
        if (limit == 0) {
            return result;
        }
        if (value == null) {
            throw new IllegalArgumentException("Filter value cannot be null.");
        }
        if (value.contains(QUERY_FILTER_STRING_ANY) && !value.matches("(\\*)\\1+")) {
            value = value.replaceAll("(?<!\\\\)\\*", SQL_FILTER_STRING_ANY);
        }
        ArrayList<User> users = new ArrayList<User>();
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<User> list = new ArrayList<User>();
        try {
            int initialOffset;
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            offset = offset <= 0 ? 0 : --offset;
            if (ORACLE.equalsIgnoreCase(type)) {
                limit = offset + limit;
            } else if (MSSQL.equalsIgnoreCase(type)) {
                initialOffset = offset;
                offset = limit + offset;
                limit = initialOffset + 1;
            } else if (DB2.equalsIgnoreCase(type)) {
                initialOffset = offset;
                offset += limit;
                limit = initialOffset + 1;
            }
            String sqlStmt = this.realmConfig.getUserStoreProperty("GetPaginatedUserLisForPropertyWithIDSQL-" + type);
            if (sqlStmt == null) {
                sqlStmt = this.realmConfig.getUserStoreProperty("GetPaginatedUserLisForPropertyWithIDSQL");
            }
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, property);
            prepStmt.setString(2, value);
            prepStmt.setString(3, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
                prepStmt.setInt(6, limit);
                prepStmt.setInt(7, offset);
            } else {
                prepStmt.setInt(4, limit);
                prepStmt.setInt(5, offset);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String userID = rs.getString(1);
                String userName = rs.getString(2);
                User user = this.getUser(userID, userName);
                list.add(user);
            }
            if (list.size() > 0) {
                users = list;
            }
            result.setUsers(users);
        }
        catch (Exception e) {
            try {
                String msg = "Database error occurred while paginating users for a property : " + property + " & value : " + value + "& profile name : " + profileName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        if (users.size() == 0) {
            result.setSkippedUserCount(this.getUserListFromPropertiesCountWithID(property, value, profileName));
        }
        return result;
    }

    protected int getUserListFromPropertiesCountWithID(String property, String value, String profileName) throws UserStoreException {
        if (profileName == null) {
            profileName = "default";
        }
        if (value == null) {
            throw new IllegalArgumentException("Filter value cannot be null");
        }
        if (value.contains(QUERY_FILTER_STRING_ANY) && !value.matches("(\\*)\\1+")) {
            value = value.replaceAll("(?<!\\\\)\\*", SQL_FILTER_STRING_ANY);
        }
        int count = 0;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = this.realmConfig.getUserStoreProperty("GetPaginatedUserCountForPropertyWithIDSQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, property);
            prepStmt.setString(2, value);
            prepStmt.setString(3, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
            }
            if ((rs = prepStmt.executeQuery()).next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Database error occurred while paginating users count for a property : " + property + " & value : " + value + "& profile name : " + profileName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return count;
    }

    @Override
    protected PaginatedSearchResult doGetUserList(Condition condition, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    protected UniqueIDPaginatedSearchResult doGetUserListWithID(Condition condition, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        boolean isGroupFiltering = false;
        boolean isUsernameFiltering = false;
        boolean isClaimFiltering = false;
        int totalMultiGroupFilters = 0;
        int totalMultiClaimFilters = 0;
        UniqueIDPaginatedSearchResult result = new UniqueIDPaginatedSearchResult();
        if (limit == 0) {
            return result;
        }
        ArrayList<ExpressionCondition> expressionConditions = new ArrayList<ExpressionCondition>();
        this.getExpressionConditions(condition, expressionConditions);
        for (ExpressionCondition expressionCondition : expressionConditions) {
            if (ExpressionOperation.GE.toString().equals(expressionCondition.getOperation()) || ExpressionOperation.LE.toString().equals(expressionCondition.getOperation())) {
                throw new UserStoreClientException("ge and le operations are not supported for JDBC userstores.");
            }
            if (ExpressionAttribute.ROLE.toString().equals(expressionCondition.getAttributeName())) {
                isGroupFiltering = true;
                ++totalMultiGroupFilters;
                continue;
            }
            if (ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) {
                isUsernameFiltering = true;
                continue;
            }
            isClaimFiltering = true;
            ++totalMultiClaimFilters;
        }
        ArrayList<User> users = new ArrayList<User>();
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<User> list = new ArrayList<User>();
        try {
            int initialOffset;
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            offset = offset <= 0 ? 0 : --offset;
            if (DB2.equalsIgnoreCase(type)) {
                initialOffset = offset;
                offset += limit;
                limit = initialOffset + 1;
            } else if (ORACLE.equalsIgnoreCase(type)) {
                limit = offset + limit;
            } else if (MSSQL.equalsIgnoreCase(type)) {
                initialOffset = offset;
                offset = limit + offset;
                limit = initialOffset + 1;
            }
            SqlBuilder sqlBuilder = this.getQueryString(isGroupFiltering, isUsernameFiltering, isClaimFiltering, expressionConditions, limit, offset, sortBy, sortOrder, profileName, type, totalMultiGroupFilters, totalMultiClaimFilters);
            if ((MYSQL.equals(type) || MARIADB.equals(type)) && totalMultiGroupFilters > 1 && totalMultiClaimFilters > 1) {
                String fullQuery = sqlBuilder.getQuery();
                String[] splits = fullQuery.split("INTERSECT ");
                int startIndex = 0;
                int endIndex = 0;
                for (String query : splits) {
                    ArrayList<User> tempUserList = new ArrayList<User>();
                    int occurrence = StringUtils.countMatches((String)query, (String)"?");
                    prepStmt = dbConnection.prepareStatement(query);
                    this.populatePrepareStatement(sqlBuilder, prepStmt, startIndex, endIndex += occurrence);
                    rs = prepStmt.executeQuery();
                    while (rs.next()) {
                        String userID = rs.getString(1);
                        String userName = rs.getString(2);
                        User user = this.getUser(userID, userName);
                        user.setUserStoreDomain(this.getMyDomainName());
                        tempUserList.add(user);
                    }
                    if (startIndex == 0) {
                        list = tempUserList;
                    } else {
                        list.retainAll(tempUserList);
                    }
                    startIndex += occurrence;
                }
            } else {
                prepStmt = dbConnection.prepareStatement(sqlBuilder.getQuery());
                int occurrence = StringUtils.countMatches((String)sqlBuilder.getQuery(), (String)"?");
                this.populatePrepareStatement(sqlBuilder, prepStmt, 0, occurrence);
                rs = prepStmt.executeQuery();
                while (rs.next()) {
                    String userID = rs.getString(1);
                    String userName = rs.getString(2);
                    User user = this.getUser(userID, userName);
                    user.setUserStoreDomain(this.getMyDomainName());
                    list.add(user);
                }
            }
            if (list.size() > 0) {
                users = list;
            }
            result.setUsers(users);
        }
        catch (Exception e) {
            try {
                String msg = "Error occur while doGetUserList for multi attribute searching";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return result;
    }

    private void populatePrepareStatement(SqlBuilder sqlBuilder, PreparedStatement prepStmt, int startIndex, int endIndex) throws SQLException {
        Map<Integer, Integer> integerParameters = sqlBuilder.getIntegerParameters();
        Map<Integer, String> stringParameters = sqlBuilder.getStringParameters();
        Map<Integer, Long> longParameters = sqlBuilder.getLongParameters();
        for (Map.Entry<Integer, Integer> entry : integerParameters.entrySet()) {
            if (entry.getKey() <= startIndex || entry.getKey() > endIndex) continue;
            prepStmt.setInt(entry.getKey() - startIndex, entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : stringParameters.entrySet()) {
            if (entry.getKey() <= startIndex || entry.getKey() > endIndex) continue;
            prepStmt.setString(entry.getKey() - startIndex, (String)entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : longParameters.entrySet()) {
            if (entry.getKey() <= startIndex || entry.getKey() > endIndex) continue;
            prepStmt.setLong(entry.getKey() - startIndex, (Long)entry.getValue());
        }
    }

    @Override
    protected SqlBuilder getQueryString(boolean isGroupFiltering, boolean isUsernameFiltering, boolean isClaimFiltering, List<ExpressionCondition> expressionConditions, int limit, int offset, String sortBy, String sortOrder, String profileName, String dbType, int totalMultiGroupFilters, int totalMultiClaimFilters) throws UserStoreException {
        SqlBuilder sqlBuilder;
        StringBuilder sqlStatement;
        boolean hitGroupFilter = false;
        boolean hitClaimFilter = false;
        int groupFilterCount = 0;
        int claimFilterCount = 0;
        if (isGroupFiltering && isUsernameFiltering && isClaimFiltering || isGroupFiltering && isClaimFiltering) {
            sqlStatement = DB2.equals(dbType) ? new StringBuilder("SELECT U.UM_USER_ID, U.UM_USER_NAME FROM (SELECT ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS rn, p.*  FROM (SELECT DISTINCT UM_USER_NAME  FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : (MSSQL.equals(dbType) ? new StringBuilder("SELECT UM_USER_ID, UM_USER_NAME FROM (SELECT UM_USER_ID, UM_USER_NAME, ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS RowNum FROM (SELECT DISTINCT U.UM_USER_ID, UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : (ORACLE.equals(dbType) ? new StringBuilder("SELECT U.UM_USER_ID, U.UM_USER_NAME FROM (SELECT UM_USER_NAME, rownum AS rnum FROM (SELECT  UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : new StringBuilder("SELECT DISTINCT U.UM_USER_ID, U.UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR INNER JOIN UM_USER U INNER JOIN UM_USER_ATTRIBUTE UA ON R.UM_ID = UR.UM_ROLE_ID AND UR.UM_USER_ID = U.UM_ID AND U.UM_ID = UA.UM_USER_ID")));
            sqlBuilder = new SqlBuilder(sqlStatement).where("R.UM_TENANT_ID = ?", this.tenantId).where("U.UM_TENANT_ID = ?", this.tenantId).where("UR.UM_TENANT_ID = ?", this.tenantId).where("UA.UM_TENANT_ID = ?", this.tenantId).where("UA.UM_PROFILE_ID = ?", profileName);
        } else if (isGroupFiltering && isUsernameFiltering || isGroupFiltering) {
            sqlStatement = DB2.equals(dbType) ? new StringBuilder("SELECT U.UM_USER_ID, U.UM_USER_NAME FROM (SELECT ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS rn, p.*  FROM (SELECT DISTINCT UM_USER_NAME  FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID ") : (MSSQL.equals(dbType) ? new StringBuilder("SELECT UM_USER_ID, UM_USER_NAME FROM (SELECT UM_USER_ID, UM_USER_NAME, ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS RowNum FROM (SELECT DISTINCT U.UM_USER_ID, UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID") : (ORACLE.equals(dbType) ? new StringBuilder("SELECT U.UM_USER_ID, U.UM_USER_NAME FROM (SELECT UM_USER_NAME, rownum AS rnum FROM (SELECT  UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID") : new StringBuilder("SELECT DISTINCT U.UM_USER_ID, U.UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR INNER JOIN UM_USER U ON R.UM_ID = UR.UM_ROLE_ID AND UR.UM_USER_ID =U.UM_ID")));
            sqlBuilder = new SqlBuilder(sqlStatement).where("R.UM_TENANT_ID = ?", this.tenantId).where("U.UM_TENANT_ID = ?", this.tenantId).where("UR.UM_TENANT_ID = ?", this.tenantId);
        } else if (isUsernameFiltering && isClaimFiltering || isClaimFiltering) {
            sqlStatement = DB2.equals(dbType) ? new StringBuilder("SELECT U.UM_USER_ID, U.UM_USER_NAME FROM (SELECT ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS rn, p.*  FROM (SELECT DISTINCT UM_USER_NAME  FROM  UM_USER U INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : (MSSQL.equals(dbType) ? new StringBuilder("SELECT UM_USER_ID, UM_USER_NAME FROM (SELECT UM_USER_ID, UM_USER_NAME, ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS RowNum FROM (SELECT DISTINCT U.UM_USER_ID, U.UM_USER_NAME FROM UM_USER U INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : (ORACLE.equals(dbType) ? new StringBuilder("SELECT U.UM_USER_ID, U.UM_USER_NAME FROM (SELECT UM_USER_NAME, rownum AS rnum FROM (SELECT UM_USER_NAME FROM UM_USER U INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : new StringBuilder("SELECT DISTINCT U.UM_USER_ID, U.UM_USER_NAME FROM UM_USER U INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID")));
            sqlBuilder = new SqlBuilder(sqlStatement).where("U.UM_TENANT_ID = ?", this.tenantId).where("UA.UM_TENANT_ID = ?", this.tenantId).where("UA.UM_PROFILE_ID = ?", profileName);
        } else if (isUsernameFiltering) {
            sqlStatement = DB2.equals(dbType) ? new StringBuilder("SELECT UM_USER_ID, UM_USER_NAME FROM (SELECT ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS rn, p.*  FROM (SELECT DISTINCT UM_USER_ID, UM_USER_NAME  FROM UM_USER U") : (MSSQL.equals(dbType) ? new StringBuilder("SELECT UM_USER_ID, UM_USER_NAME FROM (SELECT UM_USER_ID, UM_USER_NAME, ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS RowNum FROM (SELECT DISTINCT UM_USER_NAME, UM_USER_ID FROM UM_USER U") : (ORACLE.equals(dbType) ? new StringBuilder("SELECT UM_USER_ID, UM_USER_NAME FROM (SELECT UM_USER_ID, UM_USER_NAME, rownum AS rnum FROM (SELECT UM_USER_ID, UM_USER_NAME FROM UM_USER U") : new StringBuilder("SELECT U.UM_USER_ID, U.UM_USER_NAME FROM UM_USER U")));
            sqlBuilder = new SqlBuilder(sqlStatement).where("U.UM_TENANT_ID = ?", this.tenantId);
        } else {
            throw new UserStoreException("Condition is not valid.");
        }
        SqlBuilder header = new SqlBuilder(new StringBuilder(sqlBuilder.getSql()));
        this.addingWheres(sqlBuilder, header);
        for (ExpressionCondition expressionCondition : expressionConditions) {
            if (ExpressionAttribute.ROLE.toString().equals(expressionCondition.getAttributeName())) {
                if (!MYSQL.equals(dbType) && !MARIADB.equals(dbType) || totalMultiGroupFilters > 1 && totalMultiClaimFilters > 1) {
                    this.multiGroupQueryBuilder(sqlBuilder, header, hitGroupFilter, expressionCondition);
                    hitGroupFilter = true;
                    continue;
                }
                this.multiGroupMySqlQueryBuilder(sqlBuilder, groupFilterCount, expressionCondition);
                ++groupFilterCount;
                continue;
            }
            if (ExpressionOperation.EQ.toString().equals(expressionCondition.getOperation()) && ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) {
                if (this.isCaseSensitiveUsername()) {
                    sqlBuilder.where("U.UM_USER_NAME = ?", expressionCondition.getAttributeValue());
                    continue;
                }
                sqlBuilder.where("U.UM_USER_NAME = LOWER(?)", expressionCondition.getAttributeValue());
                continue;
            }
            if (ExpressionOperation.CO.toString().equals(expressionCondition.getOperation()) && ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) {
                if (this.isCaseSensitiveUsername()) {
                    sqlBuilder.where("U.UM_USER_NAME LIKE ?", SQL_FILTER_STRING_ANY + expressionCondition.getAttributeValue() + SQL_FILTER_STRING_ANY);
                    continue;
                }
                sqlBuilder.where("U.UM_USER_NAME LIKE LOWER(?)", SQL_FILTER_STRING_ANY + expressionCondition.getAttributeValue() + SQL_FILTER_STRING_ANY);
                continue;
            }
            if (ExpressionOperation.EW.toString().equals(expressionCondition.getOperation()) && ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) {
                if (this.isCaseSensitiveUsername()) {
                    sqlBuilder.where("U.UM_USER_NAME LIKE ?", SQL_FILTER_STRING_ANY + expressionCondition.getAttributeValue());
                    continue;
                }
                sqlBuilder.where("U.UM_USER_NAME LIKE LOWER(?)", SQL_FILTER_STRING_ANY + expressionCondition.getAttributeValue());
                continue;
            }
            if (ExpressionOperation.SW.toString().equals(expressionCondition.getOperation()) && ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) {
                if (this.isCaseSensitiveUsername()) {
                    sqlBuilder.where("U.UM_USER_NAME LIKE ?", expressionCondition.getAttributeValue() + SQL_FILTER_STRING_ANY);
                    continue;
                }
                sqlBuilder.where("U.UM_USER_NAME LIKE LOWER(?)", expressionCondition.getAttributeValue() + SQL_FILTER_STRING_ANY);
                continue;
            }
            if (!MYSQL.equals(dbType) && !MARIADB.equals(dbType) || totalMultiGroupFilters > 1 && totalMultiClaimFilters > 1) {
                this.multiClaimQueryBuilder(sqlBuilder, header, hitClaimFilter, expressionCondition);
                hitClaimFilter = true;
                continue;
            }
            this.multiClaimMySqlQueryBuilder(sqlBuilder, claimFilterCount, expressionCondition);
            ++claimFilterCount;
        }
        if (MYSQL.equals(dbType) || MARIADB.equals(dbType)) {
            sqlBuilder.updateSql(" GROUP BY U.UM_USER_NAME, U.UM_USER_ID ");
            if (groupFilterCount > 0 && claimFilterCount > 0) {
                sqlBuilder.updateSql(" HAVING (COUNT(DISTINCT R.UM_ROLE_NAME) = " + groupFilterCount + " AND COUNT(DISTINCT UA.UM_ATTR_VALUE) = " + claimFilterCount + ")");
            } else if (groupFilterCount > 0) {
                sqlBuilder.updateSql(" HAVING COUNT(DISTINCT R.UM_ROLE_NAME) = " + groupFilterCount);
            } else if (claimFilterCount > 0) {
                sqlBuilder.updateSql(" HAVING COUNT(DISTINCT UA.UM_ATTR_VALUE) = " + claimFilterCount);
            }
        }
        if (!MYSQL.equals(dbType) && !MARIADB.equals(dbType) || totalMultiGroupFilters <= 1 || totalMultiClaimFilters <= 1) {
            if (DB2.equals(dbType)) {
                sqlBuilder.setTail(") AS p) WHERE rn BETWEEN ? AND ?", limit, offset);
            } else if (MSSQL.equals(dbType)) {
                if (isClaimFiltering && !isGroupFiltering && totalMultiClaimFilters > 1) {
                    sqlBuilder.setTail(") AS Q) AS S) AS R) AS P WHERE P.RowNum BETWEEN ? AND ?", limit, offset);
                } else {
                    sqlBuilder.setTail(") AS R) AS P WHERE P.RowNum BETWEEN ? AND ?", limit, offset);
                }
            } else if (ORACLE.equals(dbType)) {
                sqlBuilder.setTail(" ORDER BY UM_USER_NAME) where rownum <= ?) WHERE  rnum > ?", limit, offset);
            } else {
                sqlBuilder.setTail(" ORDER BY UM_USER_NAME ASC LIMIT ? OFFSET ?", limit, offset);
            }
        }
        return sqlBuilder;
    }

    private void multiGroupQueryBuilder(SqlBuilder sqlBuilder, SqlBuilder header, boolean hitFirstRound, ExpressionCondition expressionCondition) {
        if (hitFirstRound) {
            sqlBuilder.updateSql(" INTERSECT " + header.getSql());
            this.addingWheres(header, sqlBuilder);
            this.buildGroupWhereConditions(sqlBuilder, expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        } else {
            this.buildGroupWhereConditions(sqlBuilder, expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        }
    }

    private void buildGroupWhereConditions(SqlBuilder sqlBuilder, String operation, String value) {
        if (ExpressionOperation.EQ.toString().equals(operation)) {
            sqlBuilder.where("R.UM_ROLE_NAME = ?", value);
        } else if (ExpressionOperation.EW.toString().equals(operation)) {
            sqlBuilder.where("R.UM_ROLE_NAME LIKE ?", SQL_FILTER_STRING_ANY + value);
        } else if (ExpressionOperation.CO.toString().equals(operation)) {
            sqlBuilder.where("R.UM_ROLE_NAME LIKE ?", SQL_FILTER_STRING_ANY + value + SQL_FILTER_STRING_ANY);
        } else if (ExpressionOperation.SW.toString().equals(operation)) {
            sqlBuilder.where("R.UM_ROLE_NAME LIKE ?", value + SQL_FILTER_STRING_ANY);
        }
    }

    private void multiGroupMySqlQueryBuilder(SqlBuilder sqlBuilder, int groupFilterCount, ExpressionCondition expressionCondition) {
        if (groupFilterCount == 0) {
            this.buildGroupWhereConditions(sqlBuilder, expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        } else {
            this.buildGroupConditionWithOROperator(sqlBuilder, expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        }
    }

    private void buildGroupConditionWithOROperator(SqlBuilder sqlBuilder, String operation, String value) {
        if (ExpressionOperation.EQ.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("R.UM_ROLE_NAME = ?", value);
        } else if (ExpressionOperation.EW.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("R.UM_ROLE_NAME LIKE ?", SQL_FILTER_STRING_ANY + value);
        } else if (ExpressionOperation.CO.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("R.UM_ROLE_NAME LIKE ?", SQL_FILTER_STRING_ANY + value + SQL_FILTER_STRING_ANY);
        } else if (ExpressionOperation.SW.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("R.UM_ROLE_NAME LIKE ?", value + SQL_FILTER_STRING_ANY);
        }
    }

    private void multiClaimQueryBuilder(SqlBuilder sqlBuilder, SqlBuilder header, boolean hitFirstRound, ExpressionCondition expressionCondition) {
        if (hitFirstRound) {
            sqlBuilder.updateSql(" INTERSECT " + header.getSql());
            this.addingWheres(header, sqlBuilder);
            this.buildClaimWhereConditions(sqlBuilder, expressionCondition.getAttributeName(), expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        } else {
            this.buildClaimWhereConditions(sqlBuilder, expressionCondition.getAttributeName(), expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        }
    }

    private void buildClaimWhereConditions(SqlBuilder sqlBuilder, String attributeName, String operation, String attributeValue) {
        sqlBuilder.where("UA.UM_ATTR_NAME = ?", attributeName);
        if (ExpressionOperation.EQ.toString().equals(operation)) {
            sqlBuilder.where("UA.UM_ATTR_VALUE = ?", attributeValue);
        } else if (ExpressionOperation.EW.toString().equals(operation)) {
            sqlBuilder.where("UA.UM_ATTR_VALUE LIKE ?", SQL_FILTER_STRING_ANY + attributeValue);
        } else if (ExpressionOperation.CO.toString().equals(operation)) {
            sqlBuilder.where("UA.UM_ATTR_VALUE LIKE ?", SQL_FILTER_STRING_ANY + attributeValue + SQL_FILTER_STRING_ANY);
        } else if (ExpressionOperation.SW.toString().equals(operation)) {
            sqlBuilder.where("UA.UM_ATTR_VALUE LIKE ?", attributeValue + SQL_FILTER_STRING_ANY);
        }
    }

    private void multiClaimMySqlQueryBuilder(SqlBuilder sqlBuilder, int claimFilterCount, ExpressionCondition expressionCondition) {
        if (claimFilterCount == 0) {
            this.buildClaimWhereConditions(sqlBuilder, expressionCondition.getAttributeName(), expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        } else {
            this.buildClaimConditionWithOROperator(sqlBuilder, expressionCondition.getAttributeName(), expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        }
    }

    private void buildClaimConditionWithOROperator(SqlBuilder sqlBuilder, String attributeName, String operation, String attributeValue) {
        sqlBuilder.updateSqlWithOROperation("UA.UM_ATTR_NAME = ?", attributeName);
        if (ExpressionOperation.EQ.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("UA.UM_ATTR_VALUE = ?", attributeValue);
        } else if (ExpressionOperation.EW.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("UA.UM_ATTR_VALUE LIKE ?", SQL_FILTER_STRING_ANY + attributeValue);
        } else if (ExpressionOperation.CO.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("UA.UM_ATTR_VALUE LIKE ?", SQL_FILTER_STRING_ANY + attributeValue + SQL_FILTER_STRING_ANY);
        } else if (ExpressionOperation.SW.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("UA.UM_ATTR_VALUE LIKE ?", attributeValue + SQL_FILTER_STRING_ANY);
        }
    }

    private void addingWheres(SqlBuilder baseSqlBuilder, SqlBuilder newSqlBuilder) {
        for (int i = 0; i < baseSqlBuilder.getWheres().size(); ++i) {
            if (baseSqlBuilder.getIntegerParameters().containsKey(i + 1)) {
                newSqlBuilder.where(baseSqlBuilder.getWheres().get(i), baseSqlBuilder.getIntegerParameters().get(i + 1));
                continue;
            }
            if (baseSqlBuilder.getStringParameters().containsKey(i + 1)) {
                newSqlBuilder.where(baseSqlBuilder.getWheres().get(i), baseSqlBuilder.getStringParameters().get(i + 1));
                continue;
            }
            if (!baseSqlBuilder.getIntegerParameters().containsKey(i + 1)) continue;
            newSqlBuilder.where(baseSqlBuilder.getWheres().get(i), baseSqlBuilder.getLongParameters().get(i + 1));
        }
    }

    private void getExpressionConditions(Condition condition, List<ExpressionCondition> expressionConditions) {
        if (condition instanceof ExpressionCondition) {
            expressionConditions.add((ExpressionCondition)condition);
        } else if (condition instanceof OperationalCondition) {
            Condition leftCondition = ((OperationalCondition)condition).getLeftCondition();
            this.getExpressionConditions(leftCondition, expressionConditions);
            Condition rightCondition = ((OperationalCondition)condition).getRightCondition();
            this.getExpressionConditions(rightCondition, expressionConditions);
        }
    }

    @Override
    public int getUserId(String username) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public int getTenantId(String username) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public boolean isUniqueUserIdEnabled() {
        return true;
    }
}

