/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.crypto.api.CryptoService;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimManagerFactory;
import org.wso2.carbon.user.core.internal.UserStoreMgtDataHolder;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreManager;
import org.wso2.carbon.user.core.jdbc.UniqueIDJDBCUserStoreManager;
import org.wso2.carbon.user.core.ldap.ActiveDirectoryUserStoreManager;
import org.wso2.carbon.user.core.ldap.ReadOnlyLDAPUserStoreManager;
import org.wso2.carbon.user.core.ldap.ReadWriteLDAPUserStoreManager;
import org.wso2.carbon.user.core.ldap.UniqueIDActiveDirectoryUserStoreManager;
import org.wso2.carbon.user.core.ldap.UniqueIDReadOnlyLDAPUserStoreManager;
import org.wso2.carbon.user.core.ldap.UniqueIDReadWriteLDAPUserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tracker.UserStoreManagerRegistry;

@Component(name="user.store.mgt.dscomponent", immediate=true)
public class UserStoreMgtDSComponent {
    private static Log log = LogFactory.getLog(UserStoreMgtDSComponent.class);
    private static RealmService realmService;
    private static ServerConfigurationService serverConfigurationService;
    private static ClaimManagerFactory claimManagerFactory;
    private UserStoreMgtDataHolder userStoreMgtDataHolder = UserStoreMgtDataHolder.getInstance();

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="user.realmservice.default", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService rlmService) {
        realmService = rlmService;
    }

    public static ServerConfigurationService getServerConfigurationService() {
        return serverConfigurationService;
    }

    @Reference(name="server.configuration.service", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        UserStoreMgtDSComponent.serverConfigurationService = serverConfigurationService;
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (Boolean.parseBoolean(System.getProperty("NonUserCoreMode"))) {
            log.debug((Object)"UserCore component activated in NonUserCoreMode Mode");
            return;
        }
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            JDBCUserStoreManager jdbcUserStoreManager = new JDBCUserStoreManager();
            ctxt.getBundleContext().registerService(UserStoreManager.class.getName(), (Object)jdbcUserStoreManager, null);
            ReadWriteLDAPUserStoreManager readWriteLDAPUserStoreManager = new ReadWriteLDAPUserStoreManager();
            ctxt.getBundleContext().registerService(UserStoreManager.class.getName(), (Object)readWriteLDAPUserStoreManager, null);
            ReadOnlyLDAPUserStoreManager readOnlyLDAPUserStoreManager = new ReadOnlyLDAPUserStoreManager();
            ctxt.getBundleContext().registerService(UserStoreManager.class.getName(), (Object)readOnlyLDAPUserStoreManager, null);
            ActiveDirectoryUserStoreManager activeDirectoryUserStoreManager = new ActiveDirectoryUserStoreManager();
            ctxt.getBundleContext().registerService(UserStoreManager.class.getName(), (Object)activeDirectoryUserStoreManager, null);
            UniqueIDJDBCUserStoreManager uniqueIDjdbcUserStoreManager = new UniqueIDJDBCUserStoreManager();
            ctxt.getBundleContext().registerService(UserStoreManager.class.getName(), (Object)uniqueIDjdbcUserStoreManager, null);
            UniqueIDReadWriteLDAPUserStoreManager uniqueIDreadWriteLDAPUserStoreManager = new UniqueIDReadWriteLDAPUserStoreManager();
            ctxt.getBundleContext().registerService(UserStoreManager.class.getName(), (Object)uniqueIDreadWriteLDAPUserStoreManager, null);
            UniqueIDReadOnlyLDAPUserStoreManager uniqueIDreadOnlyLDAPUserStoreManager = new UniqueIDReadOnlyLDAPUserStoreManager();
            ctxt.getBundleContext().registerService(UserStoreManager.class.getName(), (Object)uniqueIDreadOnlyLDAPUserStoreManager, null);
            UniqueIDActiveDirectoryUserStoreManager uniqueIDactiveDirectoryUserStoreManager = new UniqueIDActiveDirectoryUserStoreManager();
            ctxt.getBundleContext().registerService(UserStoreManager.class.getName(), (Object)uniqueIDactiveDirectoryUserStoreManager, null);
            UserStoreManagerRegistry.init(ctxt.getBundleContext());
            log.info((Object)"Carbon UserStoreMgtDSComponent activated successfully.");
        }
        catch (Exception e) {
            log.error((Object)"Failed to activate Carbon UserStoreMgtDSComponent ", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Carbon UserStoreMgtDSComponent is deactivated ");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        realmService = null;
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the ServerConfigurationService");
        }
        UserStoreMgtDSComponent.serverConfigurationService = null;
    }

    public static ClaimManagerFactory getClaimManagerFactory() {
        return claimManagerFactory;
    }

    @Reference(name="claim.mgt.component", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetClaimManagerFactory")
    protected void setClaimManagerFactory(ClaimManagerFactory claimManagerFactory) {
        UserStoreMgtDSComponent.claimManagerFactory = claimManagerFactory;
        try {
            if (claimManagerFactory.createClaimManager(-1234) != null) {
                ClaimManager claimManager = claimManagerFactory.createClaimManager(-1234);
                this.setClaimManager(realmService.getBootstrapRealm(), claimManager);
                this.setClaimManager(realmService.getBootstrapRealm().getUserStoreManager(), claimManager);
                RealmConfiguration secondaryRealmConfiguration = realmService.getBootstrapRealm().getRealmConfiguration().getSecondaryRealmConfig();
                if (secondaryRealmConfiguration != null) {
                    do {
                        String userDomain = secondaryRealmConfiguration.getUserStoreProperty("DomainName");
                        this.setClaimManager(realmService.getBootstrapRealm().getUserStoreManager().getSecondaryUserStoreManager(userDomain), claimManager);
                    } while ((secondaryRealmConfiguration = secondaryRealmConfiguration.getSecondaryRealmConfig()) != null);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while setting claim manager from claim manager factory");
        }
    }

    @Reference(name="carbonCryptoService", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonCryptoService")
    protected void setCarbonCryptoService(CryptoService cryptoService) {
        this.userStoreMgtDataHolder.setCryptoService(cryptoService);
    }

    protected void unsetCarbonCryptoService(CryptoService cryptoService) {
        this.userStoreMgtDataHolder.setCryptoService(null);
    }

    protected void unsetClaimManagerFactory(ClaimManagerFactory claimManagerFactory) {
        UserStoreMgtDSComponent.claimManagerFactory = null;
    }

    private void setClaimManager(Object object, ClaimManager claimManager) {
        try {
            Class<?> currentClass = object.getClass();
            Method method = null;
            while (currentClass != null && method == null) {
                try {
                    method = currentClass.getDeclaredMethod("setClaimManager", ClaimManager.class);
                }
                catch (NoSuchMethodException e) {
                    currentClass = currentClass.getSuperclass();
                }
            }
            if (method == null) {
                throw new NoSuchMethodException();
            }
            method.setAccessible(true);
            method.invoke(object, claimManager);
            log.info((Object)("Claim manager set for " + object.getClass()));
            method.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error((Object)("No claim manager setter found for " + object.getClass() + " or its supper classes"));
        }
    }

    static {
        serverConfigurationService = null;
        claimManagerFactory = null;
    }
}

