/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.common.PaginatedSearchResult;
import org.wso2.carbon.user.core.common.UniqueIDPaginatedSearchResult;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.common.UserIdResolverCache;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class UserUniqueIDManger {
    private static final Log log = LogFactory.getLog(UserUniqueIDManger.class);

    public User addUser(String username, String profileName, AbstractUserStoreManager userStoreManager) throws UserStoreException {
        HashMap<String, String> claims = new HashMap<String, String>();
        String uniqueId = this.generateUniqueId();
        claims.put("http://wso2.org/claims/userid", uniqueId);
        userStoreManager.setUserClaimValues(username, claims, profileName);
        User user = new User();
        user.setUserID(uniqueId);
        user.setUsername(username);
        user.setUserStoreDomain(userStoreManager.getMyDomainName());
        return user;
    }

    public User getUser(String uniqueId, AbstractUserStoreManager userStoreManager) throws UserStoreException {
        String userName = this.getFromUserNameCache(uniqueId);
        if (StringUtils.isEmpty((String)userName)) {
            String[] usernames = userStoreManager.getUserList("http://wso2.org/claims/userid", uniqueId, null);
            if (usernames.length > 1) {
                throw new UserStoreException("More than one user presents with the same user unique id.");
            }
            if (usernames.length == 0) {
                return null;
            }
            userName = usernames[0];
            this.addToUserNameCache(uniqueId, userName);
            this.addToUserIDCache(uniqueId, userName);
        }
        User user = new User();
        user.setUserID(uniqueId);
        user.setUsername(UserCoreUtil.removeDomainFromName(userName));
        user.setUserStoreDomain(UserCoreUtil.extractDomainFromName(userName));
        return user;
    }

    private void addToUserIDCache(String userID, String userName) {
        UserIdResolverCache.getInstance().addToCache(userName, userID, "user_unique_id_from_user_name_cache", -1234);
    }

    private void addToUserNameCache(String userID, String userName) {
        UserIdResolverCache.getInstance().addToCache(userID, userName, "user_name_from_unique_user_id_cache", -1234);
    }

    private String getFromUserNameCache(String userID) {
        return UserIdResolverCache.getInstance().getValueFromCache(userID, "user_name_from_unique_user_id_cache", -1234);
    }

    public List<User> getUsers(List<String> userIds, AbstractUserStoreManager userStoreManager) throws UserStoreException {
        ArrayList<User> users = new ArrayList<User>();
        for (String userId : userIds) {
            User user = userStoreManager.getUserWithID(userId, new String[0], null);
            users.add(user);
        }
        return users;
    }

    public String getUniqueId(String username, AbstractUserStoreManager userStoreManager) throws UserStoreException {
        return userStoreManager.getUserClaimValues(username, new String[]{"http://wso2.org/claims/userid"}, null).get("http://wso2.org/claims/userid");
    }

    public boolean checkUserExist(String uniqueId, String profile, AbstractUserStoreManager userStoreManager) throws UserStoreException {
        String[] usernames = userStoreManager.getUserList("http://wso2.org/claims/userid", uniqueId, profile);
        if (usernames.length > 1) {
            throw new UserStoreException("More than one user presents with the same user unique id.");
        }
        return usernames.length != 0;
    }

    public UniqueIDPaginatedSearchResult listUsers(PaginatedSearchResult paginatedSearchResult, AbstractUserStoreManager userStoreManager) throws UserStoreException {
        UniqueIDPaginatedSearchResult uniqueIDPaginatedSearchResult = new UniqueIDPaginatedSearchResult();
        ArrayList<User> users = new ArrayList<User>();
        for (String username : paginatedSearchResult.getUsers()) {
            User user = new User();
            String uniqueId = this.getUniqueId(username, userStoreManager);
            if (StringUtils.isEmpty((String)uniqueId)) {
                user = this.addUser(username, null, userStoreManager);
            } else {
                user.setUserID(uniqueId);
            }
            user.setUsername(username);
            users.add(user);
        }
        uniqueIDPaginatedSearchResult.setUsers(users);
        uniqueIDPaginatedSearchResult.setSkippedUserCount(paginatedSearchResult.getSkippedUserCount());
        return uniqueIDPaginatedSearchResult;
    }

    public List<User> listUsers(String[] listUsers, AbstractUserStoreManager userStoreManager) {
        return this.listUsers(Arrays.asList(listUsers), userStoreManager);
    }

    public List<User> listUsers(List<String> listUsers, AbstractUserStoreManager userStoreManager) {
        ArrayList<User> users = new ArrayList<User>();
        for (String username : listUsers) {
            User user = new User();
            try {
                String uniqueId = this.getUniqueId(username, userStoreManager);
                user.setUsername(username);
                user.setUserID(uniqueId);
                user.setUserStoreDomain(userStoreManager.getMyDomainName());
            }
            catch (UserStoreException e) {
                log.debug((Object)String.format("Error while retrieving user ID for user: %s. Hence dropping this user from the list of users.", username), (Throwable)((Object)e));
                continue;
            }
            users.add(user);
        }
        return users;
    }

    protected String generateUniqueId() {
        return UUID.randomUUID().toString();
    }
}

