/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheConfiguration;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.UserRolesCacheEntry;
import org.wso2.carbon.user.core.common.UserRolesCacheKey;
import org.wso2.carbon.user.core.internal.UserStoreMgtDSComponent;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class UserRolesCache {
    private static final String USER_ROLES_CACHE_MANAGER = "USER_ROLES_CACHE_MANAGER";
    private static final String USER_ROLES_CACHE = "USER_ROLES_CACHE";
    private static final String CASE_INSENSITIVE_USERNAME = "CaseInsensitiveUsername";
    private static Log log = LogFactory.getLog(UserRolesCache.class);
    private static UserRolesCache userRolesCache = new UserRolesCache();
    private int timeOut = 5;

    private UserRolesCache() {
    }

    public static UserRolesCache getInstance() {
        return userRolesCache;
    }

    private Cache<UserRolesCacheKey, UserRolesCacheEntry> getUserRolesCache() {
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(USER_ROLES_CACHE_MANAGER);
        Cache userRoleCache = null;
        for (Cache cache : cacheManager.getCaches()) {
            if (!StringUtils.equals((String)cache.getName(), (String)USER_ROLES_CACHE) && !StringUtils.equals((String)cache.getName(), (String)"$__local__$.USER_ROLES_CACHE")) continue;
            userRoleCache = cache;
        }
        if (userRoleCache == null) {
            cacheManager.createCacheBuilder(USER_ROLES_CACHE).setExpiry(CacheConfiguration.ExpiryType.MODIFIED, new CacheConfiguration.Duration(TimeUnit.MINUTES, (long)this.timeOut)).build();
        }
        return cacheManager.getCache(USER_ROLES_CACHE);
    }

    private boolean isCacheNull(Cache<UserRolesCacheKey, UserRolesCacheEntry> cache) {
        if (cache == null) {
            if (log.isDebugEnabled()) {
                StackTraceElement[] elemets = Thread.currentThread().getStackTrace();
                String traceString = "";
                for (int i = 1; i < elemets.length; ++i) {
                    traceString = traceString + elemets[i] + System.getProperty("line.separator");
                }
                log.debug((Object)("USER_ROLES_CACHE doesn't exist in CacheManager:\n" + traceString));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(String serverId, int tenantId, String userName, String[] userRoleList) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(tenantId, true);
            Cache<UserRolesCacheKey, UserRolesCacheEntry> cache = this.getUserRolesCache();
            if (this.isCacheNull(cache)) {
                return;
            }
            if (!this.isCaseSensitiveUsername(userName, tenantId)) {
                userName = userName.toLowerCase();
            }
            UserRolesCacheKey userRolesCacheKey = new UserRolesCacheKey(serverId, tenantId, userName);
            UserRolesCacheEntry userRolesCacheEntry = new UserRolesCacheEntry(userRoleList);
            cache.put((Object)userRolesCacheKey, (Object)userRolesCacheEntry);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRolesListOfUser(String serverId, int tenantId, String userName) {
        try {
            UserRolesCacheKey userRolesCacheKey;
            UserRolesCacheEntry userRolesCacheEntry;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(tenantId, true);
            Cache<UserRolesCacheKey, UserRolesCacheEntry> cache = this.getUserRolesCache();
            if (this.isCacheNull(cache)) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            if (!this.isCaseSensitiveUsername(userName, tenantId)) {
                userName = userName.toLowerCase();
            }
            if ((userRolesCacheEntry = (UserRolesCacheEntry)cache.get((Object)(userRolesCacheKey = new UserRolesCacheKey(serverId, tenantId, userName)))) == null) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] stringArray = userRolesCacheEntry.getUserRolesList();
            return stringArray;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheByTenant(int tenantId) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(tenantId, true);
            Cache<UserRolesCacheKey, UserRolesCacheEntry> cache = this.getUserRolesCache();
            cache.removeAll();
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheEntry(String serverId, int tenantId, String userName) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(tenantId, true);
            Cache<UserRolesCacheKey, UserRolesCacheEntry> cache = this.getUserRolesCache();
            if (this.isCacheNull(cache)) {
                return;
            }
            boolean caseSensitiveUsername = this.isCaseSensitiveUsername(userName, tenantId);
            if (!caseSensitiveUsername) {
                userName = userName.toLowerCase();
            }
            UserRolesCacheKey userRolesCacheKey = new UserRolesCacheKey(serverId, tenantId, userName);
            cache.remove((Object)userRolesCacheKey);
            String userNameWithCacheIdentifier = "@__isUserHasTheRole__@" + userName;
            if (!caseSensitiveUsername) {
                userNameWithCacheIdentifier = userNameWithCacheIdentifier.toLowerCase();
            }
            userRolesCacheKey = new UserRolesCacheKey(serverId, tenantId, userNameWithCacheIdentifier);
            cache.remove((Object)userRolesCacheKey);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private boolean isCaseSensitiveUsername(String username, int tenantId) {
        block4: {
            if (UserStoreMgtDSComponent.getRealmService() != null) {
                try {
                    if (UserStoreMgtDSComponent.getRealmService().getTenantUserRealm(tenantId) != null) {
                        UserStoreManager userStoreManager = (UserStoreManager)UserStoreMgtDSComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
                        UserStoreManager userAvailableUserStoreManager = userStoreManager.getSecondaryUserStoreManager(this.removeUserInRoleIdentifier(UserCoreUtil.extractDomainFromName(username)));
                        String isUsernameCaseInsensitiveString = userAvailableUserStoreManager.getRealmConfiguration().getUserStoreProperty(CASE_INSENSITIVE_USERNAME);
                        return !Boolean.parseBoolean(isUsernameCaseInsensitiveString);
                    }
                }
                catch (UserStoreException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"Error while reading user store property CaseInsensitiveUsername. Considering as false.");
                }
            }
        }
        return true;
    }

    private String removeUserInRoleIdentifier(String modifiedName) {
        String originalName = modifiedName;
        if (originalName.contains("@__isUserHasTheRole__@")) {
            originalName = modifiedName.replace("@__isUserHasTheRole__@", "");
        }
        return originalName;
    }
}

