/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.utils.xml.StringUtils;

public class UserIdResolverCache {
    private static Log log = LogFactory.getLog(UserIdResolverCache.class);
    private static UserIdResolverCache userIdResolverCache = new UserIdResolverCache();
    private static final String USER_ID_RESOLVER_CACHE_MANAGER = "USER_ID_RESOLVER_CACHE_MANAGER";

    private UserIdResolverCache() {
    }

    public static synchronized UserIdResolverCache getInstance() {
        return userIdResolverCache;
    }

    private Cache<String, String> UserIdResolverCache(String cacheName) {
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(USER_ID_RESOLVER_CACHE_MANAGER);
        Cache cache = cacheManager.getCache(cacheName);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(String key, String entry, String cacheName, int tenantId) {
        if (this.validateAddToCacheRequest(key, entry, cacheName)) {
            return;
        }
        try {
            this.startTenantFlow(tenantId);
            Cache<String, String> cache = this.UserIdResolverCache(cacheName);
            if (cache != null && !cache.containsKey((Object)key)) {
                cache.put((Object)key, (Object)entry);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cache: " + cacheName + " which is under " + USER_ID_RESOLVER_CACHE_MANAGER + ",added the entry: " + entry + " for the key: " + key + " successfully"));
                }
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValueFromCache(String key, String cacheName, int tenantId) {
        if (this.validateGetValueFromCacheRequest(key, cacheName)) {
            return null;
        }
        try {
            this.startTenantFlow(tenantId);
            Cache<String, String> cache = this.UserIdResolverCache(cacheName);
            if (cache != null) {
                if (cache.containsKey((Object)key)) {
                    String entry = (String)cache.get((Object)key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cache: " + cacheName + " which is under " + USER_ID_RESOLVER_CACHE_MANAGER + ", found the entry: " + entry + " for the key: " + key + " successfully."));
                    }
                    String string = entry;
                    return string;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cache: " + cacheName + " which is under " + USER_ID_RESOLVER_CACHE_MANAGER + ", doesn't contain the key: " + key));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Error while getting the cache: " + cacheName + " which is under " + USER_ID_RESOLVER_CACHE_MANAGER));
            }
            String string = null;
            return string;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheEntry(String key, String cacheName, int tenantId) {
        if (this.validateClearCacheEntryRequest(key, cacheName)) {
            return;
        }
        try {
            this.startTenantFlow(tenantId);
            Cache<String, String> cache = this.UserIdResolverCache(cacheName);
            if (cache != null) {
                cache.remove((Object)key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cache: " + cacheName + " which is under " + USER_ID_RESOLVER_CACHE_MANAGER + ", is removed entry for the key: " + key + " successfully."));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Error while getting the cache: " + cacheName + " which is under " + USER_ID_RESOLVER_CACHE_MANAGER));
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String cacheName, int tenantId) {
        if (this.validateClearCacheRequest(cacheName)) {
            return;
        }
        try {
            this.startTenantFlow(tenantId);
            Cache<String, String> cache = this.UserIdResolverCache(cacheName);
            if (cache != null) {
                cache.removeAll();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cache: " + cacheName + " which is under " + USER_ID_RESOLVER_CACHE_MANAGER + ", is cleared successfully"));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Error while getting the cache: " + cacheName + " which is under " + USER_ID_RESOLVER_CACHE_MANAGER));
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void startTenantFlow(int tenantId) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantId(tenantId, true);
    }

    private boolean validateAddToCacheRequest(String key, String entry, String cacheName) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)entry) || StringUtils.isEmpty((String)cacheName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid input parameters in add to cache request. Cache key: " + key + " ,Cache entry: " + entry + " ,Cache: " + cacheName));
            }
            return true;
        }
        return false;
    }

    private boolean validateGetValueFromCacheRequest(String key, String cacheName) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)cacheName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid input parameters in get value from cache request. Cache key: " + key + " ,Cache: " + cacheName));
            }
            return true;
        }
        return false;
    }

    private boolean validateClearCacheEntryRequest(String key, String cacheName) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)cacheName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid input parameters in clear from cache request. Cache key: " + key + " ,Cache: " + cacheName));
            }
            return true;
        }
        return false;
    }

    private boolean validateClearCacheRequest(String cacheName) {
        if (StringUtils.isEmpty((String)cacheName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid input parameters in clear all cache request. Cache: " + cacheName));
            }
            return true;
        }
        return false;
    }
}

