/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.util.Map;
import org.wso2.carbon.user.core.common.Entity;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class User
extends Entity {
    private static final long serialVersionUID = -8811345359211553015L;
    private String preferredUsername;
    private Map<String, String> attributes;

    public User() {
    }

    public User(String userID) {
        super(userID);
    }

    public User(String userID, String username, String preferredUsername) {
        super(userID, username);
        this.preferredUsername = preferredUsername;
    }

    public User(String userID, String username, String preferredUsername, String displayName, String tenantDomain, String userStoreDomain, Map<String, String> attributes) {
        super(userID, username, displayName, tenantDomain, userStoreDomain);
        this.attributes = attributes;
        this.preferredUsername = preferredUsername;
    }

    public String getUserID() {
        return super.getId();
    }

    public void setUserID(String userID) {
        super.setId(userID);
    }

    public String getUsername() {
        return super.getName();
    }

    public void setUsername(String username) {
        super.setName(username);
    }

    public String getDomainQualifiedUsername() {
        return UserCoreUtil.addDomainToName(super.getName(), super.getUserStoreDomain());
    }

    public String getFullQualifiedUsername() {
        String domainQualifiedUsername = this.getDomainQualifiedUsername();
        return UserCoreUtil.addTenantDomainToEntry(domainQualifiedUsername, super.getTenantDomain());
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    public void setPreferredUsername(String preferredUsername) {
        this.preferredUsername = preferredUsername;
    }

    public boolean equals(Object obj) {
        if (obj instanceof User) {
            return this.getFullQualifiedUsername().equals(((User)obj).getFullQualifiedUsername());
        }
        return false;
    }

    public int hashCode() {
        return this.getFullQualifiedUsername().hashCode();
    }
}

