/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.CharBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.NotImplementedException;
import org.wso2.carbon.user.core.PaginatedUserStoreManager;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UniqueIDUserStoreManager;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreClientException;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.authorization.AuthorizationCache;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.common.AbstractUserManagementErrorListener;
import org.wso2.carbon.user.core.common.AbstractUserOperationEventListener;
import org.wso2.carbon.user.core.common.AbstractUserStoreManagerListener;
import org.wso2.carbon.user.core.common.AuthenticationResult;
import org.wso2.carbon.user.core.common.Claim;
import org.wso2.carbon.user.core.common.FailureReason;
import org.wso2.carbon.user.core.common.Group;
import org.wso2.carbon.user.core.common.IterativeUserStoreManager;
import org.wso2.carbon.user.core.common.LoginIdentifier;
import org.wso2.carbon.user.core.common.PaginatedSearchResult;
import org.wso2.carbon.user.core.common.RoleContext;
import org.wso2.carbon.user.core.common.UniqueIDPaginatedSearchResult;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.common.UserIdResolverCache;
import org.wso2.carbon.user.core.common.UserRolesCache;
import org.wso2.carbon.user.core.common.UserStore;
import org.wso2.carbon.user.core.common.UserUniqueIDDomainResolver;
import org.wso2.carbon.user.core.common.UserUniqueIDManger;
import org.wso2.carbon.user.core.config.UserStorePreferenceOrderSupplier;
import org.wso2.carbon.user.core.constants.UserCoreErrorConstants;
import org.wso2.carbon.user.core.dto.RoleDTO;
import org.wso2.carbon.user.core.hybrid.HybridRoleManager;
import org.wso2.carbon.user.core.internal.UMListenerServiceComponent;
import org.wso2.carbon.user.core.internal.UserStoreMgtDSComponent;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreManager;
import org.wso2.carbon.user.core.listener.SecretHandleableListener;
import org.wso2.carbon.user.core.listener.UniqueIDUserManagementErrorEventListener;
import org.wso2.carbon.user.core.listener.UniqueIDUserOperationEventListener;
import org.wso2.carbon.user.core.listener.UserManagementErrorEventListener;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.listener.UserStoreManagerConfigurationListener;
import org.wso2.carbon.user.core.listener.UserStoreManagerListener;
import org.wso2.carbon.user.core.model.Condition;
import org.wso2.carbon.user.core.model.ExpressionCondition;
import org.wso2.carbon.user.core.model.ExpressionOperation;
import org.wso2.carbon.user.core.model.OperationalCondition;
import org.wso2.carbon.user.core.model.OperationalOperation;
import org.wso2.carbon.user.core.model.UniqueIDUserClaimSearchEntry;
import org.wso2.carbon.user.core.model.UserClaimSearchEntry;
import org.wso2.carbon.user.core.model.UserMgtContext;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.system.SystemUserRoleManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.Secret;
import org.wso2.carbon.utils.UnsupportedSecretTypeException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public abstract class AbstractUserStoreManager
implements PaginatedUserStoreManager,
UniqueIDUserStoreManager {
    protected static final String TRUE_VALUE = "true";
    protected static final String FALSE_VALUE = "false";
    protected static final String QUERY_FILTER_STRING_ANY = "*";
    protected static final int QUERY_MAX_ITEM_LIMIT_ANY = -1;
    private static final String MAX_LIST_LENGTH = "100";
    private static final int MAX_ITEM_LIMIT_UNLIMITED = -1;
    private static final String MULIPLE_ATTRIBUTE_ENABLE = "MultipleAttributeEnable";
    private static final String DISAPLAY_NAME_CLAIM = "http://wso2.org/claims/displayName";
    private static final String SCIM_USERNAME_CLAIM_URI = "urn:scim:schemas:core:1.0:userName";
    private static final String SCIM2_USERNAME_CLAIM_URI = "urn:ietf:params:scim:schemas:core:2.0:User:userName";
    protected static final String USERNAME_CLAIM_URI = "http://wso2.org/claims/username";
    private static final String APPLICATION_DOMAIN = "Application";
    private static final String WORKFLOW_DOMAIN = "Workflow";
    private static final String INVALID_CLAIM_URL = "InvalidClaimUrl";
    private static final String INVALID_USER_NAME = "InvalidUserName";
    private static final String READ_ONLY_STORE = "ReadOnlyUserStoreManager";
    private static final String READ_ONLY_PRIMARY_STORE = "ReadOnlyPrimaryUserStoreManager";
    private static final String ADMIN_USER = "AdminUser";
    private static final String PROPERTY_PASSWORD_ERROR_MSG = "PasswordJavaRegExViolationErrorMsg";
    private static final String MULTI_ATTRIBUTE_SEPARATOR = "MultiAttributeSeparator";
    private static final String LOCATION_CLAIM_URI = "http://wso2.org/claims/location";
    private static Log log = LogFactory.getLog(AbstractUserStoreManager.class);
    protected int tenantId;
    protected DataSource dataSource = null;
    protected RealmConfiguration realmConfig = null;
    protected ClaimManager claimManager = null;
    protected UserRealm userRealm = null;
    protected HybridRoleManager hybridRoleManager = null;
    protected UserRolesCache userRolesCache = null;
    protected SystemUserRoleManager systemUserRoleManager = null;
    protected boolean readGroupsEnabled = false;
    protected boolean writeGroupsEnabled = false;
    private UserStoreManager secondaryUserStoreManager;
    private boolean userRolesCacheEnabled = true;
    private String cacheIdentifier;
    private boolean replaceEscapeCharactersAtUserLogin = true;
    private Map<String, UserStoreManager> userStoreManagerHolder = new HashMap<String, UserStoreManager>();
    private Map<String, Integer> maxUserListCount = null;
    private Map<String, Integer> maxRoleListCount = null;
    private List<UserStoreManagerConfigurationListener> listener = new ArrayList<UserStoreManagerConfigurationListener>();
    private static final ThreadLocal<Boolean> isSecureCall = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private UserUniqueIDManger userUniqueIDManger = new UserUniqueIDManger();
    private UserUniqueIDDomainResolver userUniqueIDDomainResolver;

    private void setClaimManager(ClaimManager claimManager) throws IllegalAccessException {
        if (!Boolean.parseBoolean(this.realmConfig.getRealmProperty("initializeNewClaimManager"))) {
            throw new IllegalAccessException("Set claim manager is not allowed");
        }
        this.claimManager = claimManager;
    }

    private Object callSecure(String methodName, final Object[] objects, Class[] argTypes) throws UserStoreException {
        Method method;
        final AbstractUserStoreManager instance = this;
        isSecureCall.set(Boolean.TRUE);
        try {
            Class<?> clazz = Class.forName("org.wso2.carbon.user.core.common.AbstractUserStoreManager");
            method = clazz.getDeclaredMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)("Error occurred when calling method " + methodName), (Throwable)e);
            throw new UserStoreException(e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Error occurred when calling class " + methodName), (Throwable)e);
            throw new UserStoreException(e);
        }
        try {
            Object e = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return method.invoke((Object)instance, objects);
                }
            });
            return e;
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof UserStoreException) {
                if (((UserStoreException)((Object)e.getCause().getCause())).getErrorCode() != null) {
                    throw new UserStoreException(e.getCause().getCause().getMessage(), ((UserStoreException)((Object)e.getCause().getCause())).getErrorCode(), e);
                }
                throw new UserStoreException(e.getCause().getCause().getMessage(), e);
            }
            String msg = objects != null && argTypes != null ? "Error occurred while accessing Java Security Manager Privilege Block when called by method " + methodName + " with " + objects.length + " length of Objects and argTypes " + Arrays.toString(argTypes) : "Error occurred while accessing Java Security Manager Privilege Block";
            log.error((Object)msg);
            throw new UserStoreException(msg, e);
        }
        finally {
            isSecureCall.set(Boolean.FALSE);
        }
    }

    protected abstract Map<String, String> getUserPropertyValues(String var1, String[] var2, String var3) throws UserStoreException;

    protected Map<String, String> getUserPropertyValuesWithID(String userID, String[] propertyNames, String profileName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUserPropertyValuesWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("getUserPropertyValuesWithID operation is not implemented in: " + this.getClass());
    }

    protected abstract boolean doCheckExistingRole(String var1) throws UserStoreException;

    protected abstract RoleContext createRoleContext(String var1) throws UserStoreException;

    protected abstract boolean doCheckExistingUser(String var1) throws UserStoreException;

    protected boolean doCheckExistingUserNameWithIDImpl(String userName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doCheckExistingUserNameWithIDImpl operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doCheckExistingUserNameWithIDImpl operation is not implemented in: " + this.getClass());
    }

    protected boolean doCheckExistingUserWithID(String userID) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doCheckExistingUserWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doCheckExistingUserWithID operation is not implemented in: " + this.getClass());
    }

    protected abstract String[] getUserListFromProperties(String var1, String var2, String var3) throws UserStoreException;

    protected List<String> doGetUserListFromPropertiesWithID(String property, String value, String profileName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doGetUserListFromPropertiesWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doGetUserListFromPropertiesWithID operation is not implemented in: " + this.getClass());
    }

    protected abstract boolean doAuthenticate(String var1, Object var2) throws UserStoreException;

    protected AuthenticationResult doAuthenticateWithID(String preferredUserNameProperty, String preferredUserNameValue, Object credential, String profileName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doAuthenticateWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doAuthenticateWithID operation is not implemented in: " + this.getClass());
    }

    protected AuthenticationResult doAuthenticateWithID(List<LoginIdentifier> loginIdentifiers, Object credential) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doAuthenticateWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doAuthenticateWithID operation is not implemented in: " + this.getClass());
    }

    protected AuthenticationResult doAuthenticateWithID(String userID, Object credential) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doAuthenticateWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doAuthenticateWithID operation is not implemented in: " + this.getClass());
    }

    protected abstract void doAddUser(String var1, Object var2, String[] var3, Map<String, String> var4, String var5, boolean var6) throws UserStoreException;

    protected User doAddUserWithID(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doAddUserWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doAddUserWithID operation is not implemented in: " + this.getClass());
    }

    protected void updateLocationClaimWithUserId(String userID, Map<String, String> claims) {
        if (MapUtils.isEmpty(claims)) {
            return;
        }
        String locationClaim = claims.get(LOCATION_CLAIM_URI);
        if (locationClaim != null && locationClaim.contains("/Users/")) {
            claims.put(LOCATION_CLAIM_URI, locationClaim.substring(0, locationClaim.indexOf("/Users/") + 7) + userID);
        }
    }

    protected abstract void doUpdateCredential(String var1, Object var2, Object var3) throws UserStoreException;

    protected void doUpdateCredentialWithID(String userID, Object newCredential, Object oldCredential) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doUpdateCredentialWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doUpdateCredentialWithID operation is not implemented in: " + this.getClass());
    }

    protected abstract void doUpdateCredentialByAdmin(String var1, Object var2) throws UserStoreException;

    protected void doUpdateCredentialByAdminWithID(String userID, Object newCredential) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doUpdateCredentialByAdminWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doUpdateCredentialByAdminWithID operation is not implemented in: " + this.getClass());
    }

    protected abstract void doDeleteUser(String var1) throws UserStoreException;

    protected void doDeleteUserWithID(String userID) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doDeleteUserWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doDeleteUserWithID operation is not implemented in: " + this.getClass());
    }

    protected void doSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        try {
            String attributeName = this.getClaimAtrribute(claimURI, userName, null);
            HashMap<String, String> userStoreAttributeValueMap = new HashMap<String, String>();
            userStoreAttributeValueMap.put(attributeName, claimValue);
            this.processAttributesBeforeUpdate(userName, userStoreAttributeValueMap, profileName);
            for (Map.Entry entry : userStoreAttributeValueMap.entrySet()) {
                this.doSetUserAttribute(userName, (String)entry.getKey(), (String)entry.getValue(), profileName);
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException("Error occurred while getting the claim attribute for claimURI: " + claimURI + " of the user: " + userName, e);
        }
    }

    protected void doSetUserAttribute(String userName, String attributeName, String value, String profileName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doSetUserAttribute operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doSetUserAttribute operation is not implemented in: " + this.getClass());
    }

    protected void doSetUserAttributeWithID(String userID, String attributeName, String value, String profileName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doSetUserAttributeWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doSetUserAttributeWithID operation is not implemented in: " + this.getClass());
    }

    protected void doSetUserAttributes(String userName, Map<String, String> processedClaimAttributes, String profileName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doSetUserAttributes operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doSetUserAttributes operation is not implemented in: " + this.getClass());
    }

    protected void doSetUserAttributes(String userName, Map<String, List<String>> claimAttributesToAdd, Map<String, List<String>> claimAttributesToDelete, Map<String, List<String>> claimAttributesToReplace, String profileName) throws UserStoreException, NotImplementedException {
        throw new NotImplementedException("doSetUserAttributes operation is not implemented in: " + this.getClass());
    }

    protected void doSetUserAttributesWithID(String userID, Map<String, String> processedClaimAttributes, String profileName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doSetUserAttributesWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doSetUserAttributesWithID operation is not implemented in: " + this.getClass());
    }

    protected void doSetUserAttributesWithID(String userID, Map<String, List<String>> claimAttributesToAdd, Map<String, List<String>> claimAttributesToDelete, Map<String, List<String>> claimAttributesToReplace, String profileName) throws UserStoreException, NotImplementedException {
        throw new NotImplementedException("doSetUserAttributesWithID operation is not implemented in: " + this.getClass());
    }

    protected void doSetUserClaimValueWithID(String userID, String claimURI, String claimValue, String profileName) throws UserStoreException {
        try {
            String attributeName = this.getClaimAtrribute(claimURI, userID, null);
            HashMap<String, String> userStoreAttributeValueMap = new HashMap<String, String>();
            userStoreAttributeValueMap.put(attributeName, claimValue);
            this.processAttributesBeforeUpdateWithID(userID, userStoreAttributeValueMap, profileName);
            for (Map.Entry entry : userStoreAttributeValueMap.entrySet()) {
                this.doSetUserAttributeWithID(userID, (String)entry.getKey(), (String)entry.getValue(), profileName);
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException("Error occurred while getting the claim attribute for claimURI: " + claimURI + " of the user: " + userID, e);
        }
    }

    public void doSetUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        if (profileName == null) {
            profileName = "default";
        }
        Map<String, String> claimAttributeValueMapForPersist = this.resolveUserStoreAttributeValueMap(userName, claims);
        this.processAttributesBeforeUpdate(userName, claimAttributeValueMapForPersist, profileName);
        this.doSetUserAttributes(userName, claimAttributeValueMapForPersist, profileName);
    }

    protected void doSetUserClaimValues(String userName, Map<String, List<String>> multiValuedClaimsToAdd, Map<String, List<String>> multiValuedClaimsToDelete, Map<String, List<String>> claimsExcludingMultiValuedClaims, String profileName) throws UserStoreException, NotImplementedException {
        if (StringUtils.isBlank((String)profileName)) {
            profileName = "default";
        }
        Map<String, List<String>> claimAttributeValueMapToAdd = this.resolveUserStoreAttributeValueMaps(userName, multiValuedClaimsToAdd);
        Map<String, List<String>> claimAttributeValueMapToDelete = this.resolveUserStoreAttributeValueMaps(userName, multiValuedClaimsToDelete);
        Map<String, List<String>> claimAttributeValueMapToModify = this.resolveUserStoreAttributeValueMaps(userName, claimsExcludingMultiValuedClaims);
        this.processAttributesBeforeUpdate(userName, claimAttributeValueMapToAdd, profileName);
        this.processAttributesBeforeUpdate(userName, claimAttributeValueMapToDelete, profileName);
        this.processAttributesBeforeUpdate(userName, claimAttributeValueMapToModify, profileName);
        this.doSetUserAttributes(userName, claimAttributeValueMapToAdd, claimAttributeValueMapToDelete, claimAttributeValueMapToModify, profileName);
    }

    private Map<String, String> resolveUserStoreAttributeValueMap(String userIdentifier, Map<String, String> claims) throws UserStoreException {
        HashMap<String, String> userStoreAttributeValueMap = new HashMap<String, String>();
        try {
            for (Map.Entry<String, String> claimEntry : claims.entrySet()) {
                String claimURI = claimEntry.getKey();
                String attributeName = this.getClaimAtrribute(claimURI, userIdentifier, null);
                userStoreAttributeValueMap.put(attributeName, claimEntry.getValue());
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String errorMessage = "Error occurred while getting claim attribute for user : " + userIdentifier;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        return userStoreAttributeValueMap;
    }

    private Map<String, List<String>> resolveUserStoreAttributeValueMaps(String userIdentifier, Map<String, List<String>> claims) throws UserStoreException {
        HashMap<String, List<String>> userStoreAttributeValueMap = new HashMap<String, List<String>>();
        try {
            for (Map.Entry<String, List<String>> claimEntry : claims.entrySet()) {
                String claimURI = claimEntry.getKey();
                String attributeName = this.getClaimAtrribute(claimURI, userIdentifier, null);
                userStoreAttributeValueMap.put(attributeName, claimEntry.getValue());
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String errorMessage = "Error occurred while getting claim attribute for user : " + userIdentifier;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        return userStoreAttributeValueMap;
    }

    protected void doSetUserClaimValuesWithID(String userID, Map<String, String> claims, String profileName) throws UserStoreException {
        if (profileName == null) {
            profileName = "default";
        }
        Map<String, String> claimAttributeValueMapForPersist = this.resolveUserStoreAttributeValueMap(userID, claims);
        this.processAttributesBeforeUpdateWithID(userID, claimAttributeValueMapForPersist, profileName);
        this.doSetUserAttributesWithID(userID, claimAttributeValueMapForPersist, profileName);
    }

    protected void doSetUserClaimValuesWithID(String userID, Map<String, List<String>> multiValuedClaimsToAdd, Map<String, List<String>> multiValuedClaimsToDelete, Map<String, List<String>> claimsExcludingMultiValuedClaims, String profileName) throws UserStoreException, NotImplementedException {
        if (profileName == null) {
            profileName = "default";
        }
        Map<String, List<String>> claimAttributeValueMapToAdd = this.resolveUserStoreAttributeValueMaps(userID, multiValuedClaimsToAdd);
        Map<String, List<String>> claimAttributeValueMapToDelete = this.resolveUserStoreAttributeValueMaps(userID, multiValuedClaimsToDelete);
        Map<String, List<String>> claimAttributeValueMapToModify = this.resolveUserStoreAttributeValueMaps(userID, claimsExcludingMultiValuedClaims);
        this.processAttributesBeforeUpdateWithID(userID, claimAttributeValueMapToAdd, profileName);
        this.processAttributesBeforeUpdateWithID(userID, claimAttributeValueMapToDelete, profileName);
        this.processAttributesBeforeUpdateWithID(userID, claimAttributeValueMapToModify, profileName);
        this.doSetUserAttributesWithID(userID, claimAttributeValueMapToAdd, claimAttributeValueMapToDelete, claimAttributeValueMapToModify, profileName);
    }

    protected abstract void doDeleteUserClaimValue(String var1, String var2, String var3) throws UserStoreException;

    protected void doDeleteUserClaimValueWithID(String userID, String claimURI, String profileName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doDeleteUserClaimValueWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doDeleteUserClaimValueWithID operation is not implemented in: " + this.getClass());
    }

    protected abstract void doDeleteUserClaimValues(String var1, String[] var2, String var3) throws UserStoreException;

    protected void doDeleteUserClaimValuesWithID(String userID, String[] claims, String profileName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doDeleteUserClaimValuesWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doDeleteUserClaimValuesWithID operation is not implemented in: " + this.getClass());
    }

    protected abstract void doUpdateUserListOfRole(String var1, String[] var2, String[] var3) throws UserStoreException;

    protected void doUpdateUserListOfRoleWithID(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doUpdateUserListOfRoleWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doUpdateUserListOfRoleWithID operation is not implemented in: " + this.getClass());
    }

    protected abstract void doUpdateRoleListOfUser(String var1, String[] var2, String[] var3) throws UserStoreException;

    protected void doUpdateRoleListOfUserWithID(String userID, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doUpdateRoleListOfUserWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doUpdateRoleListOfUserWithID operation is not implemented in: " + this.getClass());
    }

    protected String[] doGetInternalRoleListOfUser(String userName, String filter) throws UserStoreException {
        Map<String, String> map;
        String tempUserName;
        String userNameAttribute;
        if (Boolean.parseBoolean(this.realmConfig.getUserStoreProperty(MULIPLE_ATTRIBUTE_ENABLE)) && (userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute")) != null && userNameAttribute.trim().length() > 0 && (tempUserName = (map = this.getUserPropertyValues(userName, new String[]{userNameAttribute}, null)).get(userNameAttribute)) != null) {
            userName = tempUserName;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replaced user name : " + userName + " from user property value : " + tempUserName));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving internal roles for user name :  " + userName + " and search filter : " + filter));
        }
        return this.hybridRoleManager.getHybridRoleListOfUser(userName, filter);
    }

    protected List<String> doGetInternalRoleListOfUserWithID(String userID, String filter) throws UserStoreException {
        String username = this.doGetUserNameFromUserID(userID);
        if (StringUtils.isEmpty((String)username)) {
            throw new UserStoreException("No user found with UserID: " + userID);
        }
        return Arrays.asList(this.hybridRoleManager.getHybridRoleListOfUser(username, filter));
    }

    protected Map<String, List<String>> doGetInternalRoleListOfUsers(List<String> userNames, String domainName) throws UserStoreException {
        if (Boolean.parseBoolean(this.realmConfig.getUserStoreProperty(MULIPLE_ATTRIBUTE_ENABLE))) {
            ArrayList<String> updatedUserNameList = new ArrayList<String>();
            for (String userName : userNames) {
                String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
                if (userNameAttribute != null && userNameAttribute.trim().length() > 0) {
                    Map<String, String> map = this.getUserPropertyValues(userName, new String[]{userNameAttribute}, null);
                    String tempUserName = map.get(userNameAttribute);
                    if (tempUserName != null) {
                        updatedUserNameList.add(tempUserName);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Replaced user name : " + userName + " from user property value : " + tempUserName));
                        continue;
                    }
                    updatedUserNameList.add(userName);
                    continue;
                }
                updatedUserNameList.add(userName);
            }
            userNames = updatedUserNameList;
        }
        return this.hybridRoleManager.getHybridRoleListOfUsers(userNames, domainName);
    }

    protected Map<String, List<String>> doGetInternalRoleListOfUsersWithID(List<String> userIDs, String domainName) throws UserStoreException {
        List<String> userNamesFromUserIDs = this.getUserNamesFromUserIDs(userIDs);
        HashMap<String, List<String>> hybridRoleList = new HashMap<String, List<String>>();
        Map<String, List<String>> hybridRoleListOfUsers = this.hybridRoleManager.getHybridRoleListOfUsers(userNamesFromUserIDs, domainName);
        for (Map.Entry<String, List<String>> hybridRoleListOfUser : hybridRoleListOfUsers.entrySet()) {
            hybridRoleList.put(this.getUserIDFromUserName(hybridRoleListOfUser.getKey()), hybridRoleListOfUser.getValue());
        }
        return hybridRoleList;
    }

    public Map<String, List<String>> getHybridRoleListOfGroups(List<String> groupNames, String domainName) throws UserStoreException {
        ArrayList<String> externalGroupNames = new ArrayList<String>();
        for (String groupName : groupNames) {
            String roleDomainName = UserCoreUtil.extractDomainFromName(groupName);
            if ("Internal".equalsIgnoreCase(roleDomainName) || APPLICATION_DOMAIN.equalsIgnoreCase(roleDomainName) || WORKFLOW_DOMAIN.equalsIgnoreCase(roleDomainName) || "SYSTEM".equalsIgnoreCase(roleDomainName)) continue;
            externalGroupNames.add(groupName);
        }
        return this.hybridRoleManager.getHybridRoleListOfGroups(externalGroupNames, domainName);
    }

    public List<String> getHybridRoleListOfGroup(String groupName, String domainName) throws UserStoreException {
        return this.getHybridRoleListOfGroups(new ArrayList<String>(Collections.singleton(groupName)), domainName).getOrDefault(groupName, new ArrayList());
    }

    public Map<String, List<String>> getHybridRoleListOfUsers(List<String> userNames, String domainName) throws UserStoreException {
        return this.hybridRoleManager.getHybridRoleListOfUsers(userNames, domainName);
    }

    public List<String> getHybridRoleListOfUser(String userName, String domainName) throws UserStoreException {
        return this.getHybridRoleListOfUsers(new ArrayList<String>(Collections.singleton(userName)), domainName).getOrDefault(userName, new ArrayList());
    }

    public boolean isExistingHybridRole(String roleName) throws UserStoreException {
        return this.hybridRoleManager.isExistingRole(this.removeInternalDomain(roleName));
    }

    public void updateGroupListOfHybridRole(String roleName, String[] deletedGroups, String[] newGroups) throws UserStoreException {
        this.hybridRoleManager.updateGroupListOfHybridRole(this.removeInternalDomain(roleName), deletedGroups, newGroups);
    }

    private String removeInternalDomain(String roleName) {
        if ("Internal".equalsIgnoreCase(UserCoreUtil.extractDomainFromName(roleName))) {
            return UserCoreUtil.removeDomainFromName(roleName);
        }
        return roleName;
    }

    private Set<String> getUniqueSet(Map<String, List<String>> mapOfLists) {
        HashSet<String> fullSet = new HashSet<String>();
        for (List<String> list : mapOfLists.values()) {
            fullSet.addAll(list);
        }
        return fullSet;
    }

    protected abstract String[] doGetExternalRoleListOfUser(String var1, String var2) throws UserStoreException;

    protected String[] doGetExternalRoleListOfUserWithID(String userID, String filter) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doGetExternalRoleListOfUserWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doGetExternalRoleListOfUserWithID operation is not implemented in: " + this.getClass());
    }

    protected abstract String[] doGetSharedRoleListOfUser(String var1, String var2, String var3) throws UserStoreException;

    protected String[] doGetSharedRoleListOfUserWithID(String userID, String tenantDomain, String filter) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doGetSharedRoleListOfUserWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doGetSharedRoleListOfUserWithID operation is not implemented in: " + this.getClass());
    }

    protected abstract void doAddRole(String var1, String[] var2, boolean var3) throws UserStoreException;

    protected void doAddRoleWithID(String roleName, String[] userList, boolean shared) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doAddRoleWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doAddRoleWithID operation is not implemented in: " + this.getClass());
    }

    protected abstract void doDeleteRole(String var1) throws UserStoreException;

    protected abstract void doUpdateRoleName(String var1, String var2) throws UserStoreException;

    protected abstract String[] doGetRoleNames(String var1, int var2) throws UserStoreException;

    protected abstract String[] doListUsers(String var1, int var2) throws UserStoreException;

    protected List<User> doListUsersWithID(String filter, int maxItemLimit) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doListUsersWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doListUsersWithID operation is not implemented in: " + this.getClass());
    }

    @Override
    public String[] getProfileNamesWithID(String userID) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getProfileNamesWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("getProfileNamesWithID operation is not implemented in: " + this.getClass());
    }

    public long doCountUsersWithClaims(String claimURI, String valueFilter) throws UserStoreException {
        throw new UserStoreException("Operation is not supported");
    }

    protected abstract String[] doGetDisplayNamesForInternalRole(String[] var1) throws UserStoreException;

    private boolean validateUserNameAndCredential(String userName, Object credential) throws UserStoreException {
        boolean isValid = true;
        if (userName == null || credential == null) {
            String message = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), "Authentication failure. Either Username or Password is null");
            this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), message, userName, credential);
            log.error((Object)message);
            isValid = false;
        }
        return isValid;
    }

    private boolean validateUserIDAndCredential(String userID, Object credential) throws UserStoreException {
        boolean isValid = true;
        if (userID == null || credential == null) {
            String message = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), "Authentication failure. Either Username or Password is null");
            this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), message, userID, credential);
            log.error((Object)message);
            isValid = false;
        }
        return isValid;
    }

    private boolean validateUserNameAndCredential(String claimURI, String claimValue, Object credential) throws UserStoreException {
        boolean isValid = true;
        if (claimURI == null || claimValue == null || credential == null) {
            String message = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), "Authentication failure. One of the credential element is null.");
            this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), message, claimValue, credential);
            log.error((Object)message);
            isValid = false;
        }
        return isValid;
    }

    private boolean validateUserNameAndCredentials(List<LoginIdentifier> loginIdentifiers, Object credential) throws UserStoreException {
        boolean isValid = true;
        for (LoginIdentifier loginIdentifier : loginIdentifiers) {
            if (credential != null && loginIdentifier.getLoginKey() != null && loginIdentifier.getLoginValue() != null) continue;
            String message = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), "Authentication failure. One of the credential element is null.");
            this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), message, loginIdentifier.getLoginValue(), credential);
            log.error((Object)message);
            isValid = false;
            break;
        }
        return isValid;
    }

    @Override
    public final boolean authenticate(String userName, Object credential) throws UserStoreException {
        try {
            return AccessController.doPrivileged(() -> {
                if (!this.validateUserNameAndCredential(userName, credential)) {
                    return false;
                }
                int index = userName.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
                boolean domainProvided = index > 0;
                return this.authenticate(userName, credential, domainProvided);
            });
        }
        catch (PrivilegedActionException e) {
            if (!(e.getException() instanceof UserStoreException)) {
                this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), e.getMessage()), userName, credential);
            }
            throw (UserStoreException)((Object)e.getException());
        }
    }

    protected boolean authenticate(String userName, Object credential, boolean domainProvided) throws UserStoreException {
        try {
            return AccessController.doPrivileged(() -> this.authenticateInternalIteration(userName, credential, domainProvided));
        }
        catch (PrivilegedActionException e) {
            throw (UserStoreException)((Object)e.getException());
        }
    }

    private boolean authenticateInternalIteration(String userName, Object credential, boolean domainProvided) throws UserStoreException {
        ArrayList<String> userStorePreferenceOrder = new ArrayList<String>();
        if (this.isUserStoreChainNeeded(userStorePreferenceOrder)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User store chain generation is needed hence generating the user store chain using the user store preference order: " + userStorePreferenceOrder));
            }
            return this.generateUserStoreChain(userName, credential, domainProvided, userStorePreferenceOrder);
        }
        return this.authenticateInternal(userName, credential, domainProvided);
    }

    private void handleOnAuthenticateFailure(String errorCode, String errorMessage, String userName, Object credential) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onAuthenticateFailure(errorCode, errorMessage, userName, credential, this)) continue;
            return;
        }
    }

    private void handleOnAuthenticateFailureWithID(String errorCode, String errorMessage, String userID, Object credential) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onAuthenticateFailureWithID(errorCode, errorMessage, userID, credential, (UserStoreManager)this)) continue;
            return;
        }
    }

    private void handleOnAuthenticateFailureWithID(String errorCode, String errorMessage, List<LoginIdentifier> loginIdentifiers, Object credential) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onAuthenticateFailureWithID(errorCode, errorMessage, loginIdentifiers, credential, (UserStoreManager)this)) continue;
            return;
        }
    }

    private void handleOnAuthenticateFailureWithID(String errorCode, String errorMessage, String preferredUserNameClaim, String preferredUserNameValue, Object credential) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onAuthenticateFailureWithID(errorCode, errorMessage, preferredUserNameClaim, preferredUserNameValue, credential, this)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean authenticateInternal(String userName, Object credential, boolean domainProvided) throws UserStoreException {
        boolean authenticated;
        AbstractUserStoreManager abstractUserStoreManager;
        block33: {
            Secret credentialObj;
            boolean iterative = false;
            abstractUserStoreManager = this;
            if (this instanceof IterativeUserStoreManager) {
                iterative = true;
                abstractUserStoreManager = ((IterativeUserStoreManager)this).getAbstractUserStoreManager();
            }
            authenticated = false;
            UserStore userStore = abstractUserStoreManager.getUserStore(userName);
            if (domainProvided && iterative) {
                userName = userStore.getDomainFreeName();
                userStore.setRecurssive(false);
            }
            if (userStore.isRecurssive() && userStore.getUserStoreManager() instanceof AbstractUserStoreManager) {
                return ((AbstractUserStoreManager)userStore.getUserStoreManager()).authenticate(userStore.getDomainFreeName(), credential, domainProvided);
            }
            try {
                credentialObj = Secret.getSecret((Object)credential);
            }
            catch (UnsupportedSecretTypeException e) {
                this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage(), userName, credential);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString(), e);
            }
            try {
                Object credentialArgument;
                Iterator<Object> e = UMListenerServiceComponent.getUserStoreManagerListeners().iterator();
                while (e.hasNext()) {
                    UserStoreManagerListener userStoreManagerListener;
                    credentialArgument = (userStoreManagerListener = e.next()) instanceof SecretHandleableListener ? credentialObj : credential;
                    if (userStoreManagerListener.authenticate(userName, credentialArgument, abstractUserStoreManager)) continue;
                    this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), userName, credentialArgument);
                    boolean bl = false;
                    return bl;
                }
                try {
                    e = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
                    while (e.hasNext()) {
                        UserOperationEventListener userOperationEventListener;
                        credentialArgument = (userOperationEventListener = (UserOperationEventListener)e.next()) instanceof SecretHandleableListener ? credentialObj : credential;
                        if (userOperationEventListener.doPreAuthenticate(userName, credentialArgument, abstractUserStoreManager)) continue;
                        this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), "Pre-listener tasks failed"), userName, credentialArgument);
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (UserStoreException ex) {
                    this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), ex.getMessage()), userName, credential);
                    throw ex;
                }
                int tenantId = abstractUserStoreManager.getTenantId();
                try {
                    boolean tenantActive;
                    RealmService realmService = UserCoreUtil.getRealmService();
                    if (realmService != null && !(tenantActive = realmService.getTenantManager().isTenantActive(tenantId))) {
                        String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_TENANT_DEACTIVATED.getCode();
                        String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_TENANT_DEACTIVATED.getMessage(), tenantId);
                        log.warn((Object)(errorCode + " - " + errorMessage));
                        this.handleOnAuthenticateFailure(errorCode, errorMessage, userName, credential);
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (org.wso2.carbon.user.api.UserStoreException userStoreException) {
                    this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), userStoreException.getMessage()), userName, credential);
                    throw new UserStoreException("Error while trying to check tenant status for Tenant : " + tenantId, userStoreException);
                }
                try {
                    if (abstractUserStoreManager.isUniqueUserIdEnabled()) {
                        String string = abstractUserStoreManager.getUsernameProperty();
                        AuthenticationResult authenticationResult = abstractUserStoreManager.doAuthenticateWithID(string, userName, credential, null);
                        if (authenticationResult.getAuthenticationStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
                            authenticated = true;
                        }
                        break block33;
                    }
                    authenticated = abstractUserStoreManager.doAuthenticate(userName, credentialObj);
                }
                catch (Exception exception) {
                    this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), exception.getMessage()), userName, credential);
                    if (exception instanceof UserStoreClientException) {
                        if (!log.isDebugEnabled()) throw (UserStoreClientException)((Object)exception);
                        log.debug((Object)("Error occurred while authenticating user: " + userName), (Throwable)exception);
                        throw (UserStoreClientException)((Object)exception);
                    }
                    log.error((Object)("Error occurred while authenticating user: " + userName), (Throwable)exception);
                    authenticated = false;
                }
            }
            finally {
                credentialObj.clear();
            }
        }
        if (authenticated) {
            UserCoreUtil.setDomainInThreadLocal(UserCoreUtil.getDomainName(abstractUserStoreManager.realmConfig));
        }
        if (!authenticated && !domainProvided) {
            AbstractUserStoreManager userStoreManager;
            if (this instanceof IterativeUserStoreManager) {
                IterativeUserStoreManager iterativeUserStoreManager = (IterativeUserStoreManager)this;
                userStoreManager = iterativeUserStoreManager.nextUserStoreManager();
            } else {
                userStoreManager = (AbstractUserStoreManager)abstractUserStoreManager.getSecondaryUserStoreManager();
            }
            if (userStoreManager != null) {
                authenticated = userStoreManager.authenticate(userName, credential, domainProvided);
            }
        }
        if (!authenticated) {
            this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), "Authentication failed"), userName, credential);
        }
        try {
            for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (userOperationEventListener.doPostAuthenticate(userName, authenticated, abstractUserStoreManager)) continue;
                this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getMessage(), "Post-listener tasks failed"), userName, credential);
                return false;
            }
        }
        catch (UserStoreException ex) {
            this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getMessage(), ex.getMessage()), userName, credential);
            throw ex;
        }
        if (!log.isDebugEnabled()) return authenticated;
        if (authenticated) return authenticated;
        log.debug((Object)"Authentication failure. Wrong username or password is provided.");
        return authenticated;
    }

    private String getUsernameProperty() throws org.wso2.carbon.user.api.UserStoreException {
        String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        if (StringUtils.isBlank((String)userNameProperty)) {
            userNameProperty = this.claimManager.getAttributeName(this.getMyDomainName(), USERNAME_CLAIM_URI);
        }
        return userNameProperty;
    }

    private void handleGetUserClaimValueFailure(String errorCode, String errorMessage, String userName, String claim, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onGetUserClaimValueFailure(errorCode, errorMessage, userName, claim, profileName, this)) continue;
            return;
        }
    }

    private void handleGetUserClaimValueFailureWithID(String errorCode, String errorMessage, String userID, String claim, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onGetUserClaimValueFailureWithID(errorCode, errorMessage, userID, claim, profileName, this)) continue;
            return;
        }
    }

    @Override
    public final String getUserClaimValue(String userName, String claim, String profileName) throws UserStoreException {
        Map<String, String> finalValues;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            Object object = this.callSecure("getUserClaimValue", new Object[]{userName, claim, profileName}, argTypes);
            return (String)object;
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().getUserClaimValue(userStore.getDomainFreeName(), claim, profileName);
        }
        String userID = null;
        boolean isUserExist = this.isUniqueUserIdEnabledInUserStore(userStore) ? (userID = this.getUserIDFromUserName(userName)) != null : this.doCheckExistingUser(userName);
        if (!isUserExist) {
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userName, this.realmConfig.getUserStoreProperty("DomainName"));
            this.handleGetUserClaimValueFailure(errorCode, errorMessage, userName, claim, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        try {
            finalValues = this.isUniqueUserIdEnabledInUserStore(userStore) ? this.doGetUserClaimValuesWithID(userID, new String[]{claim}, userStore.getDomainName(), profileName) : this.doGetUserClaimValues(userName, new String[]{claim}, userStore.getDomainName(), profileName);
        }
        catch (UserStoreException ex) {
            this.handleGetUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_CLAIM_VALUE.getMessage(), ex.getMessage()), userName, claim, profileName);
            throw ex;
        }
        String value = null;
        if (finalValues != null) {
            value = finalValues.get(claim);
        }
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            list.add(value);
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (!(listener instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPostGetUserClaimValue(userName, claim, list, profileName, this)) continue;
                this.handleGetUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_CLAIM_VALUE.getMessage(), "Post-listener tasks failed"), userName, claim, profileName);
                break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_CLAIM_VALUE.getMessage(), ex.getMessage()), userName, claim, profileName);
            throw ex;
        }
        if (!list.isEmpty()) {
            return (String)list.get(0);
        }
        return value;
    }

    private boolean isUniqueUserIdEnabledInUserStore(UserStore userStore) {
        return this.isUniqueUserIdEnabled(userStore.getUserStoreManager());
    }

    public boolean isRoleAndGroupSeparationEnabled() {
        return Boolean.parseBoolean(this.realmConfig.getAuthorizationManagerProperty("GroupAndRoleSeparationEnabled"));
    }

    private void handleGetUserClaimValuesFailure(String errorCode, String errorMessage, String userName, String[] claims, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onGetUserClaimValuesFailure(errorCode, errorMessage, userName, claims, profileName, this)) continue;
            return;
        }
    }

    private void handleGetUserClaimValuesFailureWithID(String errorCode, String errorMessage, String userID, String[] claims, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onGetUserClaimValuesFailureWithID(errorCode, errorMessage, userID, claims, profileName, this)) continue;
            return;
        }
    }

    @Override
    public final org.wso2.carbon.user.core.claim.Claim[] getUserClaimValues(String userName, String profileName) throws UserStoreException {
        String[] claims;
        boolean isUserExists;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("getUserClaimValues", new Object[]{userName, profileName}, argTypes);
            return (org.wso2.carbon.user.core.claim.Claim[])object;
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().getUserClaimValues(userStore.getDomainFreeName(), profileName);
        }
        boolean isUniqueUserIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        String userID = null;
        if (isUniqueUserIdEnabled) {
            userID = this.getUserIDFromUserName(userName);
        }
        if (!(isUserExists = isUniqueUserIdEnabled ? userID != null : this.doCheckExistingUser(userStore.getDomainFreeName()))) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userName, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleGetUserClaimValuesFailure(errorCode, errorMessage, userName, null, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        if (profileName == null || profileName.trim().length() == 0) {
            profileName = "default";
        }
        try {
            claims = this.claimManager.getAllClaimUris();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            this.handleGetUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_CLAIM_URI.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_CLAIM_URI.getMessage(), e.getMessage()), userName, null, profileName);
            throw new UserStoreException(e);
        }
        Map<String, String> values = this.getUserClaimValues(userName, claims, profileName);
        ArrayList<org.wso2.carbon.user.core.claim.Claim> finalValues = new ArrayList<org.wso2.carbon.user.core.claim.Claim>();
        this.addClaimValues(values, finalValues);
        return finalValues.toArray(new org.wso2.carbon.user.core.claim.Claim[0]);
    }

    @Override
    public final Map<String, String> getUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        Map<String, String> finalValues;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String[].class, String.class};
            Object object = this.callSecure("getUserClaimValues", new Object[]{userName, claims, profileName}, argTypes);
            return (Map)object;
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().getUserClaimValues(userStore.getDomainFreeName(), claims, profileName);
        }
        String userID = null;
        boolean isUniqueIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        boolean isUserExists = isUniqueIdEnabled ? (userID = this.getUserIDFromUserName(userName)) != null : this.doCheckExistingUser(userStore.getDomainFreeName());
        if (!isUserExists) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userName, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleGetUserClaimValuesFailure(errorCode, errorMessage, userName, null, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        if (claims == null) {
            claims = new String[]{};
        }
        try {
            finalValues = isUniqueIdEnabled ? this.doGetUserClaimValuesWithID(userID, claims, userStore.getDomainName(), profileName) : this.doGetUserClaimValues(userStore.getDomainFreeName(), claims, userStore.getDomainName(), profileName);
        }
        catch (UserStoreException ex) {
            this.handleGetUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_CLAIM_VALUES.getMessage(), ex.getMessage()), userName, claims, profileName);
            throw ex;
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (!(listener instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPostGetUserClaimValues(userStore.getDomainFreeName(), claims, profileName, finalValues, this)) continue;
                this.handleGetUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_IN_POST_GET_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_IN_POST_GET_CLAIM_VALUES.getMessage(), "Post-listener tasks failed"), userName, claims, profileName);
                break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_IN_POST_GET_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_IN_POST_GET_CLAIM_VALUES.getMessage(), ex.getMessage()), userName, claims, profileName);
            throw ex;
        }
        return finalValues;
    }

    private void handleGetUserListFailure(String errorCode, String errorMessage, String claim, String claimValue, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onGetUserListFailure(errorCode, errorMessage, claim, claimValue, profileName, this)) continue;
            return;
        }
    }

    protected void handleGetUserCountFailure(String errorCode, String errorMessage, String claim, String claimValue) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onGetUserCountFailure(errorCode, errorMessage, claim, claimValue, this)) continue;
            return;
        }
    }

    private void handleGetUserListFailureWithID(String errorCode, String errorMessage, String claim, String claimValue, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onGetUserListFailureWithID(errorCode, errorMessage, claim, claimValue, profileName, this)) continue;
            return;
        }
    }

    private void handleGetUserFailureWithID(String errorCode, String errorMessage, String userID, String[] requestedClaims, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onGetUserFailureWithID(errorCode, errorMessage, userID, requestedClaims, profileName, this)) continue;
            return;
        }
    }

    private void handleGetUserListFailure(String errorCode, String errorMessage, String claim, String claimValue, int limit, int offset, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || !(listener instanceof AbstractUserManagementErrorListener) || listener.onGetUserListFailure(errorCode, errorMessage, claim, claimValue, limit, offset, profileName, this)) continue;
            return;
        }
    }

    private void handleGetUserListFailureWithID(String errorCode, String errorMessage, String claim, String claimValue, int limit, int offset, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || !(listener instanceof AbstractUserManagementErrorListener) || ((AbstractUserManagementErrorListener)listener).onGetUserListFailureWithID(errorCode, errorMessage, claim, claimValue, limit, offset, profileName, this)) continue;
            return;
        }
    }

    private void handleGetUserListFailure(String errorCode, String errorMassage, Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || !(listener instanceof AbstractUserManagementErrorListener) || listener.onGetUserListFailure(errorCode, errorMassage, condition, domain, profileName, limit, offset, sortBy, sortOrder, this)) continue;
            return;
        }
    }

    private void handleGetUserListFailureWithID(String errorCode, String errorMassage, Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || !(listener instanceof AbstractUserManagementErrorListener) || ((AbstractUserManagementErrorListener)listener).onGetUserListFailureWithID(errorCode, errorMassage, condition, domain, profileName, limit, offset, sortBy, sortOrder, this)) continue;
            return;
        }
    }

    private void handleGetPaginatedUserListFailure(String errorCode, String errorMessage, String claim, String claimValue, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || !(listener instanceof AbstractUserManagementErrorListener) || listener.onGetPaginatedUserListFailure(errorCode, errorMessage, claim, claimValue, profileName, this)) continue;
            return;
        }
    }

    private void handleGetPaginatedUserListFailureWithID(String errorCode, String errorMessage, String claim, String claimValue, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || !(listener instanceof AbstractUserManagementErrorListener) || ((AbstractUserManagementErrorListener)listener).onGetPaginatedUserListFailureWithID(errorCode, errorMessage, claim, claimValue, profileName, this)) continue;
            return;
        }
    }

    private void handleListPaginatedUsersFailure(String errorCode, String errorMessage, String filter, int limit, int offset) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || !(listener instanceof AbstractUserManagementErrorListener) || listener.onListUsersFailure(errorCode, errorMessage, filter, limit, offset, this)) continue;
            return;
        }
    }

    private void handleListPaginatedUsersFailureWithID(String errorCode, String errorMessage, String filter, int limit, int offset) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || !(listener instanceof AbstractUserManagementErrorListener) || ((AbstractUserManagementErrorListener)listener).onListUsersFailureWithID(errorCode, errorMessage, filter, limit, offset, this)) continue;
            return;
        }
    }

    private void handlePostGetUserList(String claim, String claimValue, List<String> filteredUserList, boolean isAuditLogOnly) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (listener instanceof AbstractUserOperationEventListener && (!isAuditLogOnly || listener.getClass().getName().endsWith("AuditLogger")) && !(newListener = (AbstractUserOperationEventListener)listener).doPostGetUserList(claim, claimValue, filteredUserList, this)) break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, null);
            throw ex;
        }
    }

    private void handlePostGetUserListWithID(String claim, String claimValue, List<User> filteredUserList, boolean isAuditLogOnly) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (listener instanceof AbstractUserOperationEventListener && (!isAuditLogOnly || listener.getClass().getName().endsWith("AuditLogger")) && !(newListener = (AbstractUserOperationEventListener)listener).doPostGetUserListWithID(claim, claimValue, filteredUserList, this)) break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, null);
            throw ex;
        }
    }

    private void handlePostGetUserList(String claim, String claimValue, List<String> filteredUserList, int limit, int offset, boolean isAuditLogOnly) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (listener instanceof AbstractUserOperationEventListener && (!isAuditLogOnly || listener.getClass().getName().endsWith("AuditLogger")) && !(newListener = (AbstractUserOperationEventListener)listener).doPostGetUserList(claim, claimValue, filteredUserList, limit, offset, this)) break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, limit, offset, null);
            throw ex;
        }
    }

    private void handlePostGetUserListWithID(String claim, String claimValue, List<User> filteredUserList, int limit, int offset, boolean isAuditLogOnly) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (listener instanceof AbstractUserOperationEventListener && (!isAuditLogOnly || listener.getClass().getName().endsWith("AuditLogger")) && !(newListener = (AbstractUserOperationEventListener)listener).doPostGetUserListWithID(claim, claimValue, filteredUserList, limit, offset, this)) break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, limit, offset, null);
            throw ex;
        }
    }

    private void handlePostGetUserList(Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder, String[] users, boolean isAuditLogOnly) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (listener instanceof AbstractUserOperationEventListener && (!isAuditLogOnly || listener.getClass().getName().endsWith("AuditLogger")) && !(newListener = (AbstractUserOperationEventListener)listener).doPostGetUserList(condition, domain, profileName, limit, offset, sortBy, sortOrder, users, this)) break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_CONDITIONAL_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_CONDITIONAL_USER_LIST.getMessage(), ex.getMessage()), condition, domain, profileName, limit, offset, sortBy, sortOrder);
            throw ex;
        }
    }

    private void handlePostGetUserListWithID(Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder, List<User> users, boolean isAuditLogOnly) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (listener instanceof AbstractUserOperationEventListener && (!isAuditLogOnly || listener.getClass().getName().endsWith("AuditLogger")) && !(newListener = (AbstractUserOperationEventListener)listener).doPostGetUserListWithID(condition, domain, profileName, limit, offset, sortBy, sortOrder, users, this)) break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_CONDITIONAL_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_CONDITIONAL_USER_LIST.getMessage(), ex.getMessage()), condition, domain, profileName, limit, offset, sortBy, sortOrder);
            throw ex;
        }
    }

    private void handlePreGetUserList(Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (!(listener instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPreGetUserList(condition, domain, profileName, limit, offset, sortBy, sortOrder, this)) continue;
                this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET__CONDITIONAL_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET__CONDITIONAL_USER_LIST.getMessage(), "Pre-listener tasks failed"), condition, domain, profileName, limit, offset, sortBy, sortOrder);
                break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET__CONDITIONAL_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET__CONDITIONAL_USER_LIST.getMessage(), ex.getMessage()), condition, domain, profileName, limit, offset, sortBy, sortOrder);
            throw ex;
        }
    }

    private void handlePreGetUserListWithID(Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (!(listener instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPreGetUserListWithID(condition, domain, profileName, limit, offset, sortBy, sortOrder, this)) continue;
                this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET__CONDITIONAL_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET__CONDITIONAL_USER_LIST.getMessage(), "Pre-listener tasks failed"), condition, domain, profileName, limit, offset, sortBy, sortOrder);
                break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET__CONDITIONAL_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET__CONDITIONAL_USER_LIST.getMessage(), ex.getMessage()), condition, domain, profileName, limit, offset, sortBy, sortOrder);
            throw ex;
        }
    }

    private void handlePostGetPaginatedUserList(String claim, String claimValue, List<String> filteredUserList, boolean isAuditLogOnly) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (listener instanceof AbstractUserOperationEventListener && (!isAuditLogOnly || listener.getClass().getName().endsWith("AuditLogger")) && !(newListener = (AbstractUserOperationEventListener)listener).doPostGetPaginatedUserList(claim, claimValue, filteredUserList, this)) break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetPaginatedUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_PAGINATED_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_PAGINATED_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, null);
            throw ex;
        }
    }

    private void handlePostListPaginatedUsers(String filter, int limit, int offset, List<String> filteredUserList, boolean isAuditLogOnly) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (listener instanceof AbstractUserOperationEventListener && (!isAuditLogOnly || listener.getClass().getName().endsWith("AuditLogger")) && !(newListener = (AbstractUserOperationEventListener)listener).doPostListUsers(filter, limit, offset, filteredUserList, this)) break;
            }
        }
        catch (UserStoreException ex) {
            this.handleListPaginatedUsersFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_LIST_PAGINATED_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_LIST_PAGINATED_USER.getMessage(), ex.getMessage()), filter, limit, offset);
            throw ex;
        }
    }

    private void handlePostListPaginatedUsersWithID(String filter, int limit, int offset, List<User> filteredUserList, boolean isAuditLogOnly) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (listener instanceof AbstractUserOperationEventListener && (!isAuditLogOnly || listener.getClass().getName().endsWith("AuditLogger")) && !(newListener = (AbstractUserOperationEventListener)listener).doPostListUsersWithID(filter, limit, offset, filteredUserList, this)) break;
            }
        }
        catch (UserStoreException ex) {
            this.handleListPaginatedUsersFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_LIST_PAGINATED_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_LIST_PAGINATED_USER.getMessage(), ex.getMessage()), filter, limit, offset);
            throw ex;
        }
    }

    @Override
    public final String[] getUserList(String claim, String claimValue, String profileName) throws UserStoreException {
        List<String> userNamesFromUserStore;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            Object object = this.callSecure("getUserList", new Object[]{claim, claimValue, profileName}, argTypes);
            return (String[])object;
        }
        if (claim == null) {
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.getCode();
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.getMessage(), "");
            this.handleGetUserListFailure(errorCode, errorMessage, null, claimValue, profileName);
            throw new IllegalArgumentException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.toString());
        }
        if (claimValue == null) {
            this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_VALUE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_VALUE.getMessage(), claim, null, profileName);
            throw new IllegalArgumentException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_VALUE.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing users who having value as " + claimValue + " for the claim " + claim));
        }
        if (!this.isUniqueUserIdEnabled() && (USERNAME_CLAIM_URI.equalsIgnoreCase(claim) || SCIM_USERNAME_CLAIM_URI.equalsIgnoreCase(claim) || SCIM2_USERNAME_CLAIM_URI.equalsIgnoreCase(claim))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Switching to list users using username");
            }
            Object[] filteredUsers = this.listUsers(claimValue, -1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Filtered users: " + Arrays.toString(filteredUsers)));
            }
            return filteredUsers;
        }
        String extractedDomain = null;
        int index = claimValue.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index > 0) {
            String[] names = claimValue.split(CarbonConstants.DOMAIN_SEPARATOR);
            extractedDomain = names[0].trim();
        }
        UserStoreManager userManager = this;
        if (StringUtils.isNotEmpty(extractedDomain) && !StringUtils.equalsIgnoreCase((String)this.getMyDomainName(), (String)extractedDomain)) {
            UserStoreManager secondaryUserStoreManager = this.getSecondaryUserStoreManager(extractedDomain);
            if (secondaryUserStoreManager != null) {
                userManager = secondaryUserStoreManager;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Domain: " + extractedDomain + " is passed with the claim and user store manager is loaded for the given domain name."));
                }
            } else {
                throw new UserStoreException("Invalid Domain Name: " + extractedDomain);
            }
        }
        if (userManager instanceof JDBCUserStoreManager && (SCIM_USERNAME_CLAIM_URI.equalsIgnoreCase(claim) || SCIM2_USERNAME_CLAIM_URI.equalsIgnoreCase(claim))) {
            if (userManager.isExistingUser(claimValue)) {
                return new String[]{claimValue};
            }
            return new String[0];
        }
        claimValue = UserCoreUtil.removeDomainFromName(claimValue);
        ArrayList<String> filteredUserList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)extractedDomain)) {
            try {
                for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                    AbstractUserOperationEventListener newListener;
                    if (!(listener instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPreGetUserList(claim, claimValue, filteredUserList, userManager)) continue;
                    this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), "Pre-listener tasks failed"), claim, claimValue, profileName);
                    break;
                }
            }
            catch (UserStoreException ex) {
                this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, profileName);
                throw ex;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pre listener user list: " + filteredUserList + " for domain: " + extractedDomain));
        }
        if (this.isUniqueUserIdEnabled(userManager)) {
            List<User> usersFromUserStore = this.doGetUserListWithID(claim, claimValue, profileName, extractedDomain, userManager);
            userNamesFromUserStore = usersFromUserStore.stream().map(User::getDomainQualifiedUsername).collect(Collectors.toList());
        } else {
            userNamesFromUserStore = this.doGetUserList(claim, claimValue, profileName, extractedDomain, userManager);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Users from user store: " + extractedDomain + " : " + userNamesFromUserStore));
            }
        }
        filteredUserList.addAll(userNamesFromUserStore);
        if (StringUtils.isNotEmpty((String)extractedDomain)) {
            this.handlePostGetUserList(claim, claimValue, filteredUserList, false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Post listener user list: " + filteredUserList + " for domain: " + extractedDomain));
        }
        Collections.sort(filteredUserList);
        return filteredUserList.toArray(new String[0]);
    }

    private boolean isUniqueUserIdEnabled(UserStoreManager userManager) {
        return userManager instanceof AbstractUserStoreManager && ((AbstractUserStoreManager)userManager).isUniqueUserIdEnabled();
    }

    private List<String> doGetUserList(String claim, String claimValue, String profileName, String extractedDomain, UserStoreManager userManager) throws UserStoreException {
        if (StringUtils.isNotEmpty((String)extractedDomain)) {
            String property;
            if (userManager == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No user store manager found for domain: " + extractedDomain));
                }
                return Collections.emptyList();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Domain found in claim value. Searching only in the " + extractedDomain + " for possible matches"));
            }
            try {
                property = this.claimManager.getAttributeName(extractedDomain, claim);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), e.getMessage()), claim, claimValue, profileName);
                throw new UserStoreException("Error occurred while retrieving attribute name for domain : " + extractedDomain + " and claim " + claim, e);
            }
            if (property == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Could not find matching property for\nclaim :" + claim + "domain :" + extractedDomain));
                }
                return Collections.emptyList();
            }
            if (userManager instanceof AbstractUserStoreManager) {
                try {
                    AbstractUserStoreManager userStoreManager = (AbstractUserStoreManager)userManager;
                    String[] userArray = userStoreManager.getUserListFromProperties(property, claimValue, profileName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("List of filtered users for: " + extractedDomain + " : " + Arrays.asList(userArray)));
                    }
                    return Arrays.asList(UserCoreUtil.addDomainToNames(userArray, extractedDomain));
                }
                catch (UserStoreException ex) {
                    this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, profileName);
                    throw ex;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getUserListFromProperties is not supported by this user store: " + userManager.getClass()));
            }
            return Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No domain name found in claim value. Searching through all user stores for possible matches");
        }
        ArrayList<String> usersFromAllStoresList = new ArrayList<String>();
        List<UserStoreManager> userStoreManagers = this.getUserStoreMangers();
        for (UserStoreManager userStoreManager : userStoreManagers) {
            if (!(userStoreManager instanceof AbstractUserStoreManager)) continue;
            String domainName = ((AbstractUserStoreManager)userStoreManager).getMyDomainName();
            String claimValueWithDomain = StringUtils.equalsIgnoreCase((String)domainName, (String)"PRIMARY") ? domainName + CarbonConstants.DOMAIN_SEPARATOR + claimValue : UserCoreUtil.addDomainToName(claimValue, domainName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking the get user list for domain: " + domainName + " for claim: " + claim + " value: " + claimValueWithDomain));
            }
            List<String> userList = Arrays.asList(userStoreManager.getUserList(claim, claimValueWithDomain, profileName));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Secondary user list for domain: " + domainName + " : " + userList));
            }
            usersFromAllStoresList.addAll(userList);
        }
        return usersFromAllStoresList;
    }

    @Override
    public final List<User> getUserListWithID(String claim, String claimValue, String profileName) throws UserStoreException {
        List<User> usersFromUserStore;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            Object object = this.callSecure("getUserListWithID", new Object[]{claim, claimValue, profileName}, argTypes);
            return (List)object;
        }
        if (claim == null) {
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.getCode();
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.getMessage(), "");
            this.handleGetUserListFailureWithID(errorCode, errorMessage, null, claimValue, profileName);
            throw new IllegalArgumentException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.toString());
        }
        if (claimValue == null) {
            this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_VALUE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_VALUE.getMessage(), claim, null, profileName);
            throw new IllegalArgumentException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_VALUE.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing users who having value as " + claimValue + " for the claim " + claim));
        }
        String extractedDomain = null;
        int index = claimValue.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index > 0) {
            String[] names = claimValue.split(CarbonConstants.DOMAIN_SEPARATOR);
            extractedDomain = names[0].trim();
        }
        UserStoreManager userManager = this;
        if (StringUtils.isNotEmpty(extractedDomain) && !StringUtils.equalsIgnoreCase((String)this.getMyDomainName(), (String)extractedDomain)) {
            UserStoreManager secondaryUserStoreManager = this.getSecondaryUserStoreManager(extractedDomain);
            if (secondaryUserStoreManager != null) {
                userManager = secondaryUserStoreManager;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Domain: " + extractedDomain + " is passed with the claim and user store manager is loaded for the given domain name."));
                }
            } else {
                throw new UserStoreException("Invalid Domain Name: " + extractedDomain);
            }
        }
        claimValue = UserCoreUtil.removeDomainFromName(claimValue);
        ArrayList<User> filteredUserList = new ArrayList<User>();
        if (StringUtils.isNotEmpty((String)extractedDomain)) {
            try {
                for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                    AbstractUserOperationEventListener newListener;
                    if (!(listener instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPreGetUserListWithID(claim, claimValue, filteredUserList, userManager)) continue;
                    this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), "Pre-listener tasks failed"), claim, claimValue, profileName);
                    break;
                }
            }
            catch (UserStoreException ex) {
                this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, profileName);
                throw ex;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pre listener user list: " + filteredUserList + " for domain: " + extractedDomain));
        }
        if (this.isUniqueUserIdEnabled(userManager)) {
            usersFromUserStore = this.doGetUserListWithID(claim, claimValue, profileName, extractedDomain, userManager);
        } else {
            List<String> userNamesFromUserStore = this.doGetUserList(claim, claimValue, profileName, extractedDomain, userManager);
            usersFromUserStore = this.userUniqueIDManger.listUsers(userNamesFromUserStore, (AbstractUserStoreManager)userManager);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Users from user store: " + extractedDomain + " : " + usersFromUserStore.stream().map(User::getUsername).collect(Collectors.toList())));
        }
        filteredUserList.addAll(usersFromUserStore);
        if (StringUtils.isNotEmpty((String)extractedDomain)) {
            this.handlePostGetUserListWithID(claim, claimValue, filteredUserList, false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Post listener user list: " + filteredUserList.stream().map(User::getUsername).collect(Collectors.toList()) + " for domain: " + extractedDomain));
        }
        return filteredUserList;
    }

    private List<User> doGetUserListWithID(String claim, String claimValue, String profileName, String extractedDomain, UserStoreManager userManager) throws UserStoreException {
        if (StringUtils.isNotEmpty((String)extractedDomain)) {
            String property;
            if (userManager == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No user store manager found for domain: " + extractedDomain));
                }
                return Collections.emptyList();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Domain found in claim value. Searching only in the " + extractedDomain + " for possible matches"));
            }
            try {
                property = this.claimManager.getAttributeName(extractedDomain, claim);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), e.getMessage()), claim, claimValue, profileName);
                throw new UserStoreException("Error occurred while retrieving attribute name for domain : " + extractedDomain + " and claim " + claim, e);
            }
            if (property == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Could not find matching property for\nclaim :" + claim + "domain :" + extractedDomain));
                }
                return Collections.emptyList();
            }
            if (userManager instanceof AbstractUserStoreManager) {
                try {
                    AbstractUserStoreManager userStoreManager = (AbstractUserStoreManager)userManager;
                    List<String> userIDs = userStoreManager.doGetUserListFromPropertiesWithID(property, claimValue, profileName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("List of filtered users for: " + extractedDomain + " : " + Arrays.asList(userIDs)));
                    }
                    return userStoreManager.getUsersFromIDs(userIDs, null, extractedDomain, profileName);
                }
                catch (UserStoreException ex) {
                    this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, profileName);
                    throw ex;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("doGetUserListFromPropertiesWithID is not supported by this user store: " + userManager.getClass()));
            }
            return Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No domain name found in claim value. Searching through all user stores for possible matches");
        }
        ArrayList<User> usersFromAllStoresList = new ArrayList<User>();
        List<UserStoreManager> userStoreManagers = this.getUserStoreMangers();
        for (UserStoreManager userStoreManager : userStoreManagers) {
            if (!(userStoreManager instanceof AbstractUserStoreManager)) continue;
            String domainName = ((AbstractUserStoreManager)userStoreManager).getMyDomainName();
            String claimValueWithDomain = StringUtils.equalsIgnoreCase((String)domainName, (String)"PRIMARY") ? domainName + CarbonConstants.DOMAIN_SEPARATOR + claimValue : UserCoreUtil.addDomainToName(claimValue, domainName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking the get user list for domain: " + domainName + " for claim: " + claim + " value: " + claimValueWithDomain));
            }
            try {
                List<User> userList = ((AbstractUserStoreManager)userStoreManager).getUserListWithID(claim, claimValueWithDomain, profileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Secondary user list for domain: " + domainName + " : " + userList));
                }
                usersFromAllStoresList.addAll(userList);
            }
            catch (UserStoreException e) {
                log.error((Object)String.format("Error occurred while getting the users list for domain: %s Therefore, proceeding remaining domains", domainName), (Throwable)((Object)e));
            }
        }
        return usersFromAllStoresList;
    }

    private List<String> doGetUserList(String claim, String claimValue, String profileName, int limit, int offset, String extractedDomain, UserStoreManager userManager) throws UserStoreException {
        if (StringUtils.isNotEmpty((String)extractedDomain)) {
            String property;
            if (userManager == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No user store manager found for domain: " + extractedDomain));
                }
                return Collections.emptyList();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Domain found in claim value. Searching only in the " + extractedDomain + " for possible matches"));
            }
            try {
                property = this.claimManager.getAttributeName(extractedDomain, claim);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), e.getMessage()), claim, claimValue, limit, offset, profileName);
                throw new UserStoreException("Error occurred while retrieving attribute name for domain : " + extractedDomain + " and claim " + claim, e);
            }
            if (property == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Could not find matching property for\nclaim :" + claim + "domain :" + extractedDomain));
                }
                return Collections.emptyList();
            }
            if (userManager instanceof AbstractUserStoreManager) {
                try {
                    AbstractUserStoreManager userStoreManager = (AbstractUserStoreManager)userManager;
                    PaginatedSearchResult result = userStoreManager.getUserListFromProperties(property, claimValue, profileName, limit, offset);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("List of filtered paginated users for: " + extractedDomain + " : " + Arrays.asList(result.getUsers())));
                    }
                    return Arrays.asList(UserCoreUtil.addDomainToNames(result.getUsers(), extractedDomain));
                }
                catch (UserStoreException ex) {
                    this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, limit, offset, profileName);
                    throw ex;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getUserListFromProperties is not supported by this user store: " + userManager.getClass()));
            }
            return Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No domain name found in claim value. Searching through all user stores for possible matches");
        }
        ArrayList<String> usersFromAllStoresList = new ArrayList<String>();
        List<UserStoreManager> userStoreManagers = this.getUserStoreMangers();
        int nonPaginatedUserCount = 0;
        for (UserStoreManager userStoreManager : userStoreManagers) {
            String property;
            if (!(userStoreManager instanceof AbstractUserStoreManager)) continue;
            if (limit <= 0) {
                return usersFromAllStoresList;
            }
            String domainName = ((AbstractUserStoreManager)userStoreManager).getMyDomainName();
            try {
                property = this.claimManager.getAttributeName(domainName, claim);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), e.getMessage()), claim, claimValue, limit, offset, profileName);
                throw new UserStoreException("Error occurred while retrieving attribute name for domain : " + extractedDomain + " and claim " + claim, e);
            }
            PaginatedSearchResult userList = this.getUserListFromProperties(property, claimValue, profileName, limit, offset);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Secondary user list for domain: " + domainName + " : " + userList));
            }
            limit -= userList.getUsers().length;
            nonPaginatedUserCount = userList.getSkippedUserCount();
            offset = userList.getUsers().length > 0 ? 1 : (offset -= nonPaginatedUserCount);
            usersFromAllStoresList.addAll(Arrays.asList(UserCoreUtil.addDomainToNames(userList.getUsers(), domainName)));
        }
        return usersFromAllStoresList;
    }

    private List<UserStoreManager> getUserStoreMangers() {
        ArrayList<UserStoreManager> userStoreManagers = new ArrayList<UserStoreManager>();
        for (UserStoreManager currentUserStoreManager = this; currentUserStoreManager != null; currentUserStoreManager = currentUserStoreManager.getSecondaryUserStoreManager()) {
            userStoreManagers.add(currentUserStoreManager);
        }
        return userStoreManagers;
    }

    private void handleUpdateCredentialFailureWithID(String errorCode, String errorMessage, String userID, Object newCredential, Object oldCredential) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onUpdateCredentialFailureWithID(errorCode, errorMessage, userID, newCredential, oldCredential, this)) continue;
            return;
        }
    }

    private void handleUpdateCredentialFailure(String errorCode, String errorMessage, String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onUpdateCredentialFailure(errorCode, errorMessage, userName, newCredential, oldCredential, this)) continue;
            return;
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public final void updateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        block40: {
            if (!AbstractUserStoreManager.isSecureCall.get().booleanValue()) {
                argTypes = new Class[]{String.class, Object.class, Object.class};
                this.callSecure("updateCredential", new Object[]{userName, newCredential, oldCredential}, argTypes);
                return;
            }
            userStore = this.getUserStore(userName);
            if (userStore.isRecurssive()) {
                userStore.getUserStoreManager().updateCredential(userStore.getDomainFreeName(), newCredential, oldCredential);
                return;
            }
            if (this.isReadOnly()) {
                this.handleUpdateCredentialFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userName, newCredential, oldCredential);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
            }
            try {
                newCredentialObj = Secret.getSecret((Object)newCredential);
                oldCredentialObj = Secret.getSecret((Object)oldCredential);
            }
            catch (UnsupportedSecretTypeException e) {
                this.handleUpdateCredentialFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage(), userName, newCredential, oldCredential);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString());
            }
            try {
                for (Object listener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
                    if (listener instanceof SecretHandleableListener) {
                        if (listener.updateCredential(userName, newCredentialObj, oldCredentialObj, this)) continue;
                        this.handleUpdateCredentialFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getMessage(), new Object[]{"Pre-listener tasks failed"}), userName, newCredential, oldCredential);
                        return;
                    }
                    if (listener.updateCredential(userName, newCredential, oldCredential, this)) continue;
                    this.handleUpdateCredentialFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getMessage(), new Object[]{"Pre-listener tasks failed"}), userName, newCredential, oldCredential);
                    return;
                }
                for (Object listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                    if (listener instanceof SecretHandleableListener) {
                        if (!listener.doPreUpdateCredential(userName, newCredentialObj, oldCredentialObj, this)) {
                            this.handleUpdateCredentialFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getMessage(), new Object[]{"Pre-listener tasks failed"}), userName, newCredential, oldCredential);
                            return;
                        }
                    } else if (!listener.doPreUpdateCredential(userName, newCredential, oldCredential, this)) {
                        this.handleUpdateCredentialFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getMessage(), new Object[]{"Pre-listener tasks failed"}), userName, newCredential, oldCredential);
                        return;
                    }
                    try {
                    }
                    catch (UserStoreException e) {
                        this.handleUpdateCredentialFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getMessage(), new Object[]{e.getMessage()}), userName, newCredential, oldCredential);
                        throw e;
                    }
                }
                isUniqueUserIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
                userID = null;
                if (isUniqueUserIdEnabled) {
                    userID = this.getUserIDFromUserName(userName);
                }
                if (isAuth = isUniqueUserIdEnabled != false ? this.doAuthenticateWithID(preferredUserNameProperty = this.getUsernameProperty(), userName, oldCredentialObj, null).getAuthenticationStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS : this.doAuthenticate(userName, oldCredentialObj)) {
                    if (!this.checkUserPasswordValid(newCredential)) {
                        errorMsg = this.realmConfig.getUserStoreProperty("PasswordJavaRegExViolationErrorMsg");
                        if (errorMsg != null) {
                            errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getMessage(), new Object[]{errorMsg});
                            errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getCode();
                            this.handleUpdateCredentialFailure(errorCode, errorMessage, userName, newCredential, oldCredential);
                            throw new UserStoreException(errorCode + " - " + errorMessage);
                        }
                        errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getMessage(), new Object[]{this.realmConfig.getUserStoreProperty("PasswordJavaRegEx")});
                        errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getCode();
                        this.handleUpdateCredentialFailure(errorCode, errorMessage, userName, newCredential, oldCredential);
                        throw new UserStoreException(errorCode + " - " + errorMessage);
                    }
                    try {
                        if (isUniqueUserIdEnabled) {
                            this.doUpdateCredentialWithID(userID, newCredential, oldCredential);
                        } else {
                            this.doUpdateCredential(userName, newCredentialObj, oldCredentialObj);
                        }
                    }
                    catch (UserStoreException ex) {
                        this.handleUpdateCredentialFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_CREDENTIAL.getMessage(), new Object[]{ex.getMessage()}), userName, newCredential, oldCredential);
                        throw ex;
                    }
                    for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                        if (!(listener instanceof SecretHandleableListener)) ** break block38
                        if (listener.doPostUpdateCredential(userName, newCredentialObj, this)) break block39;
                        this.handleUpdateCredentialFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL.getMessage(), new Object[]{"Post update credential tasks failed"}), userName, newCredentialObj, oldCredentialObj);
                        return;
                    }
                    break block40;
                    {
                        block39: {
                            if (!listener.doPostUpdateCredential(userName, newCredential, this)) {
                                this.handleUpdateCredentialFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL.getMessage(), new Object[]{"Post update credential tasks failed"}), userName, newCredential, oldCredential);
                                return;
                            }
                        }
                        try {
                            continue;
                        }
                        catch (UserStoreException ex) {
                            this.handleUpdateCredentialFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL.getMessage(), new Object[]{ex.getMessage()}), userName, newCredential, oldCredential);
                            throw ex;
                            break;
                        }
                    }
                }
                this.handleUpdateCredentialFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_OLD_CREDENTIAL_DOES_NOT_MATCH.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_OLD_CREDENTIAL_DOES_NOT_MATCH.getMessage(), userName, newCredential, oldCredential);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_OLD_CREDENTIAL_DOES_NOT_MATCH.toString());
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e.getMessage(), e);
            }
            finally {
                newCredentialObj.clear();
                oldCredentialObj.clear();
            }
        }
    }

    private void handleUpdateCredentialByAdminFailure(String errorCode, String errorMessage, String userName, Object newCredential) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onUpdateCredentialByAdminFailure(errorCode, errorMessage, userName, newCredential, this)) continue;
            return;
        }
    }

    private void handleUpdateCredentialByAdminFailureWithID(String errorCode, String errorMessage, String userID, Object newCredential) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onUpdateCredentialByAdminFailureWithID(errorCode, errorMessage, userID, newCredential, this)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public final void updateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        block36: {
            if (!AbstractUserStoreManager.isSecureCall.get().booleanValue()) {
                argTypes = new Class[]{String.class, Object.class};
                this.callSecure("updateCredentialByAdmin", new Object[]{userName, newCredential}, argTypes);
                return;
            }
            userStore = this.getUserStore(userName);
            if (userStore.isRecurssive()) {
                userStore.getUserStoreManager().updateCredentialByAdmin(userStore.getDomainFreeName(), newCredential);
                return;
            }
            if (this.isReadOnly()) {
                this.handleUpdateCredentialByAdminFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userName, newCredential);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
            }
            try {
                newCredentialObj = Secret.getSecret((Object)newCredential);
            }
            catch (UnsupportedSecretTypeException e) {
                this.handleUpdateCredentialByAdminFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage() + " " + e.getMessage(), userName, newCredential);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString(), e);
            }
            try {
                e = UMListenerServiceComponent.getUserStoreManagerListeners().iterator();
                while (e.hasNext()) {
                    credentialArgument /* !! */  = (listener = e.next()) instanceof SecretHandleableListener != false ? newCredentialObj : newCredential;
                    if (listener.updateCredentialByAdmin(userName, credentialArgument /* !! */ , this)) continue;
                    this.handleUpdateCredentialByAdminFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{"Pre-listener tasks failed"}), userName, credentialArgument /* !! */ );
                    return;
                }
                for (Object listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                    if (listener instanceof SecretHandleableListener) {
                        if (listener.doPreUpdateCredentialByAdmin(userName, newCredentialObj, this)) continue;
                        this.handleUpdateCredentialByAdminFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{"Pre-listener tasks failed"}), userName, newCredentialObj);
                        return;
                    }
                    credBuff = null;
                    if (newCredential == null) {
                        credBuff = new StringBuffer();
                    } else if (newCredential instanceof String) {
                        credBuff = new StringBuffer((String)newCredential);
                    }
                    if (credBuff == null) continue;
                    if (!listener.doPreUpdateCredentialByAdmin(userName, credBuff, this)) {
                        this.handleUpdateCredentialByAdminFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{"Pre-listener tasks failed"}), userName, credBuff);
                        return;
                    }
                    try {
                        newCredential = credBuff.toString();
                        newCredentialObj.clear();
                        try {
                            newCredentialObj = Secret.getSecret((Object)newCredential);
                        }
                        catch (UnsupportedSecretTypeException e) {
                            this.handleUpdateCredentialByAdminFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage() + " " + e.getMessage(), userName, newCredential);
                            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString(), e);
                        }
                    }
                    catch (UserStoreException ex) {
                        this.handleUpdateCredentialByAdminFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{ex.getMessage()}), userName, newCredential);
                        throw ex;
                    }
                }
                if (!this.checkUserPasswordValid(newCredential)) {
                    errorMsg = this.realmConfig.getUserStoreProperty("PasswordJavaRegExViolationErrorMsg");
                    if (errorMsg != null) {
                        errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getCode();
                        errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{errorMsg});
                        this.handleUpdateCredentialByAdminFailure(errorCode, errorMessage, userName, newCredential);
                        throw new UserStoreException(errorCode + " - " + errorMessage);
                    }
                    errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getCode();
                    errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getMessage(), new Object[]{this.realmConfig.getUserStoreProperty("PasswordJavaRegEx")});
                    this.handleUpdateCredentialByAdminFailure(errorCode, errorMessage, userName, newCredential);
                    throw new UserStoreException(errorCode + " - " + errorMessage);
                }
                isUniqueUserIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
                userID = null;
                if (isUniqueUserIdEnabled) {
                    userID = this.getUserIDFromUserName(userName);
                }
                if (!(isUserExists = isUniqueUserIdEnabled != false ? userID != null : this.doCheckExistingUser(userStore.getDomainFreeName()))) {
                    errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), new Object[]{userName, this.realmConfig.getUserStoreProperty("DomainName")});
                    errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
                    this.handleUpdateCredentialByAdminFailure(errorCode, errorMessage, userName, newCredential);
                    throw new UserStoreException(errorCode + "-" + errorMessage);
                }
                try {
                    if (isUniqueUserIdEnabled) {
                        this.doUpdateCredentialByAdminWithID(userID, newCredentialObj);
                    } else {
                        this.doUpdateCredentialByAdmin(userName, newCredentialObj);
                    }
                }
                catch (UserStoreException ex) {
                    this.handleUpdateCredentialByAdminFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{ex.getMessage()}), userName, newCredentialObj);
                    throw ex;
                }
                ex = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
                while (ex.hasNext()) {
                    credentialArgument /* !! */  = (listener = ex.next()) instanceof SecretHandleableListener != false ? newCredentialObj : newCredential;
                    if (listener.doPostUpdateCredentialByAdmin(userName, credentialArgument /* !! */ , this)) ** break block35
                    this.handleUpdateCredentialByAdminFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{"Post-listener tasks failed"}), userName, newCredential);
                    return;
                }
                break block36;
                {
                    try {
                        continue;
                    }
                    catch (UserStoreException ex) {
                        this.handleUpdateCredentialByAdminFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{ex.getMessage()}), userName, newCredential);
                        throw ex;
                        break;
                    }
                }
            }
            finally {
                newCredentialObj.clear();
            }
        }
    }

    protected String getClaimAtrribute(String claimURI, String identifier, String domainName) throws org.wso2.carbon.user.api.UserStoreException {
        domainName = domainName == null || domainName.isEmpty() ? (identifier.indexOf(UserCoreConstants.DOMAIN_SEPARATOR) > -1 ? identifier.split(UserCoreConstants.DOMAIN_SEPARATOR)[0] : this.realmConfig.getUserStoreProperty("DomainName")) : domainName;
        String attributeName = null;
        if (domainName != null) {
            attributeName = this.claimManager.getAttributeName(domainName, claimURI);
        }
        if (attributeName == null || attributeName.isEmpty()) {
            attributeName = this.claimManager.getAttributeName("PRIMARY", claimURI);
        }
        if (attributeName == null) {
            if ("profileConfiguration".equals(claimURI)) {
                attributeName = claimURI;
            } else if (DISAPLAY_NAME_CLAIM.equals(claimURI)) {
                attributeName = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
            } else {
                throw new UserStoreException("Mapped attribute cannot be found for claim : " + claimURI + " in user store : " + this.getMyDomainName());
            }
        }
        return attributeName;
    }

    private void handleDeleteUserFailure(String errorCode, String errorMessage, String userName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onDeleteUserFailure(errorCode, errorMessage, userName, this)) continue;
            return;
        }
    }

    private void handleDeleteUserFailureWithID(String errorCode, String errorMessage, String userID) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onDeleteUserFailureWithID(errorCode, errorMessage, userID, this)) continue;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void deleteUser(String userName) throws UserStoreException {
        String string;
        String deletingUser;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            this.callSecure("deleteUser", new Object[]{userName}, argTypes);
            return;
        }
        String loggedInUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
        if (loggedInUser != null && (loggedInUser = UserCoreUtil.addDomainToName(loggedInUser, UserCoreUtil.getDomainFromThreadLocal())).indexOf(UserCoreConstants.DOMAIN_SEPARATOR) < 0) {
            loggedInUser = "PRIMARY" + CarbonConstants.DOMAIN_SEPARATOR + loggedInUser;
        }
        if ((deletingUser = UserCoreUtil.addDomainToName(userName, this.getMyDomainName())).indexOf(UserCoreConstants.DOMAIN_SEPARATOR) < 0) {
            deletingUser = "PRIMARY" + CarbonConstants.DOMAIN_SEPARATOR + deletingUser;
        }
        if (loggedInUser != null && loggedInUser.equals(deletingUser)) {
            log.debug((Object)("User " + loggedInUser + " tried to delete him/her self"));
            this.handleDeleteUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_LOGGED_IN_USER.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_LOGGED_IN_USER.getMessage(), userName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_LOGGED_IN_USER.toString());
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().deleteUser(userStore.getDomainFreeName());
            return;
        }
        if (UserCoreUtil.isPrimaryAdminUser(userName, this.realmConfig)) {
            this.handleDeleteUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_ADMIN_USER.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_ADMIN_USER.getMessage(), userName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_ADMIN_USER.toString());
        }
        if (UserCoreUtil.isRegistryAnnonymousUser(userName)) {
            this.handleDeleteUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_ANONYMOUS_USER.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_ANONYMOUS_USER.getMessage(), userName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_ANONYMOUS_USER.toString());
        }
        if (this.isReadOnly()) {
            this.handleDeleteUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        try {
            for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
                if (userStoreManagerListener.deleteUser(userName, this)) continue;
                this.handleDeleteUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER.getMessage(), "Pre-listener tasks failed"), userName);
                return;
            }
            for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (userOperationEventListener.doPreDeleteUser(userName, this)) continue;
                this.handleDeleteUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER.getMessage(), "Pre-listener tasks failed"), userName);
                return;
            }
        }
        catch (UserStoreException e) {
            this.handleDeleteUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER.getMessage(), e.getMessage()), userName);
            throw e;
        }
        boolean isUniqueUserIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        Object var6_12 = null;
        boolean isUserExists = isUniqueUserIdEnabled ? (string = this.getUserIDFromUserName(userName)) != null : this.doCheckExistingUser(userName);
        if (!isUserExists) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userName, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleDeleteUserFailure(errorCode, errorMessage, userName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        try {
            void var6_14;
            this.clearUserIDResolverCache((String)var6_14, userName, userStore);
            if (isUniqueUserIdEnabled) {
                this.hybridRoleManager.deleteUser(UserCoreUtil.addDomainToName(userName, this.getMyDomainName()));
                this.doDeleteUserWithID((String)var6_14);
            } else {
                this.hybridRoleManager.deleteUser(UserCoreUtil.addDomainToName(userName, this.getMyDomainName()));
                this.doDeleteUser(userName);
            }
        }
        catch (UserStoreException e) {
            this.handleDeleteUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETING_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETING_USER.getMessage(), e.getMessage()), userName);
            throw e;
        }
        this.clearUserRolesCache(userName);
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (listener.doPostDeleteUser(userName, this)) continue;
                this.handleDeleteUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER.getMessage(), "Post-listener tasks failed"), userName);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER.getMessage(), ex.getMessage()), userName);
            throw ex;
        }
    }

    private void handleSetUserClaimValueFailure(String errorCode, String errorMessage, String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onSetUserClaimValueFailure(errorCode, errorMessage, userName, claimURI, claimValue, profileName, this)) continue;
            return;
        }
    }

    private void handleSetUserClaimValueFailureWithID(String errorCode, String errorMessage, String userID, String claimURI, String claimValue, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onSetUserClaimValueFailureWithID(errorCode, errorMessage, userID, claimURI, claimValue, profileName, this)) continue;
            return;
        }
    }

    @Override
    public final void setUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        boolean isUserExists;
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().setUserClaimValue(userStore.getDomainFreeName(), claimURI, claimValue, profileName);
            return;
        }
        boolean isUniqueUserIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        String userID = null;
        if (isUniqueUserIdEnabled) {
            userID = this.getUserIDFromUserName(userName);
        }
        if (!(isUserExists = isUniqueUserIdEnabled ? userID != null : this.doCheckExistingUser(userName))) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userName, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleSetUserClaimValueFailure(errorCode, errorMessage, userName, claimURI, claimValue, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (listener.doPreSetUserClaimValue(userName, claimURI, claimValue, profileName, this)) continue;
                this.handleSetUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUE.getMessage(), "Pre-listener tasks failed"), userName, claimURI, claimValue, profileName);
                return;
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUE.getMessage(), e.getMessage()), userName, claimURI, claimValue, profileName);
            throw e;
        }
        if (this.isReadOnly()) {
            this.handleSetUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userName, claimURI, claimValue, profileName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        try {
            if (isUniqueUserIdEnabled) {
                this.doSetUserClaimValueWithID(userID, claimURI, claimValue, profileName);
            } else {
                this.doSetUserClaimValue(userName, claimURI, claimValue, profileName);
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_SETTING_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_SETTING_USER_CLAIM_VALUE.getMessage(), e.getMessage()), userName, claimURI, claimValue, profileName);
            throw e;
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (listener.doPostSetUserClaimValue(userName, this)) continue;
                this.handleSetUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUE.getMessage(), "Post-listener tasks failed"), userName, claimURI, claimValue, profileName);
                return;
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUE.getMessage(), e.getMessage()), userName, claimURI, claimValue, profileName);
            throw e;
        }
    }

    private void handleSetUserClaimValuesFailure(String errorCode, String errorMessage, String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onSetUserClaimValuesFailure(errorCode, errorMessage, userName, claims, profileName, this)) continue;
            return;
        }
    }

    private void handleSetUserClaimValuesFailureWithID(String errorCode, String errorMessage, String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onSetUserClaimValuesFailureWithID(errorCode, errorMessage, userName, claims, profileName, this)) continue;
            return;
        }
    }

    @Override
    public final void setUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        boolean isUserExists;
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().setUserClaimValues(userStore.getDomainFreeName(), claims, profileName);
            return;
        }
        boolean isUniqueUserIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        String userID = null;
        if (isUniqueUserIdEnabled) {
            userID = this.getUserIDFromUserName(userName);
        }
        if (!(isUserExists = isUniqueUserIdEnabled ? userID != null : this.doCheckExistingUser(userName))) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userName, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleSetUserClaimValuesFailure(errorCode, errorMessage, userName, claims, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        if (claims == null) {
            claims = new HashMap<String, String>();
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (listener.doPreSetUserClaimValues(userName, claims, profileName, this)) continue;
                this.handleSetUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUES.getMessage(), "Pre-listener tasks failed"), userName, claims, profileName);
                return;
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUES.getMessage(), e.getMessage()), userName, claims, profileName);
            throw e;
        }
        if (this.isReadOnly() && !claims.isEmpty()) {
            this.handleSetUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userName, claims, profileName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        try {
            if (!this.isReadOnly()) {
                if (isUniqueUserIdEnabled) {
                    this.doSetUserClaimValuesWithID(userID, claims, profileName);
                } else {
                    this.doSetUserClaimValues(userName, claims, profileName);
                }
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_SETTING_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_SETTING_USER_CLAIM_VALUES.getMessage(), e.getMessage()), userName, claims, profileName);
            throw e;
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (listener.doPostSetUserClaimValues(userName, claims, profileName, this)) continue;
                this.handleSetUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUES.getMessage(), "Post-listener tasks failed"), userName, claims, profileName);
                return;
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUES.getMessage(), e.getMessage()), userName, claims, profileName);
            throw e;
        }
    }

    private void handleDeleteUserClaimValueFailure(String errorCode, String errorMessage, String userName, String claimURI, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onDeleteUserClaimValueFailure(errorCode, errorMessage, userName, claimURI, profileName, this)) continue;
            return;
        }
    }

    private void handleDeleteUserClaimValueFailureWithID(String errorCode, String errorMessage, String userID, String claimURI, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onDeleteUserClaimValueFailureWithID(errorCode, errorMessage, userID, claimURI, profileName, this)) continue;
            return;
        }
    }

    @Override
    public final void deleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            this.callSecure("deleteUserClaimValue", new Object[]{userName, claimURI, profileName}, argTypes);
            return;
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().deleteUserClaimValue(userStore.getDomainFreeName(), claimURI, profileName);
            return;
        }
        if (this.isReadOnly()) {
            this.handleDeleteUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userName, claimURI, profileName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        boolean isUniqueUserIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        String userID = null;
        boolean isUserExists = isUniqueUserIdEnabled ? (userID = this.getUserIDFromUserName(userName)) != null : this.doCheckExistingUser(userName);
        if (!isUserExists) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userName, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleDeleteUserClaimValueFailure(errorCode, errorMessage, userName, claimURI, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (listener.doPreDeleteUserClaimValue(userName, claimURI, profileName, this)) continue;
                this.handleDeleteUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUE.getMessage(), "Pre-listener tasks failed"), userName, claimURI, profileName);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUE.getMessage(), ex.getMessage()), userName, claimURI, profileName);
            throw ex;
        }
        try {
            if (isUniqueUserIdEnabled) {
                this.doDeleteUserClaimValueWithID(userID, claimURI, profileName);
            } else {
                this.doDeleteUserClaimValue(userName, claimURI, profileName);
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETING_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETING_USER_CLAIM_VALUE.getMessage(), ex.getMessage()), userName, claimURI, profileName);
            throw ex;
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (listener.doPostDeleteUserClaimValue(userName, this)) continue;
                this.handleDeleteUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUE.getMessage(), "Post-listener tasks failed"), userName, claimURI, profileName);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserClaimValueFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUE.getMessage(), ex.getMessage()), userName, claimURI, profileName);
            throw ex;
        }
    }

    private void handleDeleteUserClaimValuesFailure(String errorCode, String errorMessage, String userName, String[] claims, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onDeleteUserClaimValuesFailure(errorCode, errorMessage, userName, claims, profileName, this)) continue;
            return;
        }
    }

    private void handleDeleteUserClaimValuesFailureWithID(String errorCode, String errorMessage, String userID, String[] claims, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onDeleteUserClaimValuesFailure(errorCode, errorMessage, userID, claims, profileName, this)) continue;
            return;
        }
    }

    @Override
    public final void deleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String[].class, String.class};
            this.callSecure("deleteUserClaimValues", new Object[]{userName, claims, profileName}, argTypes);
            return;
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().deleteUserClaimValues(userStore.getDomainFreeName(), claims, profileName);
            return;
        }
        if (this.isReadOnly()) {
            this.handleDeleteUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userName, claims, profileName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        boolean isUniqueUserIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        String userID = null;
        boolean isUserExists = isUniqueUserIdEnabled ? (userID = this.getUserIDFromUserName(userName)) != null : this.doCheckExistingUser(userName);
        if (!isUserExists) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userName, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleDeleteUserClaimValuesFailure(errorCode, errorMessage, userName, claims, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        if (claims == null) {
            claims = new String[]{};
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (listener.doPreDeleteUserClaimValues(userName, claims, profileName, this)) continue;
                this.handleDeleteUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUES.getMessage(), "Pre-listener tasks failed"), userName, claims, profileName);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUES.getMessage(), ex.getMessage()), userName, claims, profileName);
            throw ex;
        }
        try {
            if (isUniqueUserIdEnabled) {
                this.doDeleteUserClaimValuesWithID(userID, claims, profileName);
            } else {
                this.doDeleteUserClaimValues(userName, claims, profileName);
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETING_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETING_USER_CLAIM_VALUES.getMessage(), ex.getMessage()), userName, claims, profileName);
            throw ex;
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (listener.doPostDeleteUserClaimValues(userName, this)) continue;
                this.handleDeleteUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUES.getMessage(), "Post-listener tasks failed"), userName, claims, profileName);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserClaimValuesFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUES.getMessage(), ex.getMessage()), userName, claims, profileName);
            throw ex;
        }
    }

    @Override
    public void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        this.addUser(userName, credential, roleList, claims, profileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        Secret credentialObj;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, Object.class, String[].class, Map.class, String.class, Boolean.TYPE};
            this.callSecure("addUser", new Object[]{userName, credential, roleList, claims, profileName, requirePasswordChange}, argTypes);
            return;
        }
        User user = null;
        if (StringUtils.isEmpty((String)userName)) {
            String regEx = this.realmConfig.getUserStoreProperty("UsernameJavaRegEx");
            if (StringUtils.isEmpty((String)regEx) || StringUtils.isEmpty((String)regEx.trim())) {
                regEx = this.realmConfig.getUserStoreProperty("UserNameJavaRegEx");
            }
            String message = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_USER_NAME.getMessage(), null, regEx);
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_USER_NAME.getCode();
            this.handleAddUserFailure(errorCode, message, null, credential, roleList, claims, profileName);
            throw new UserStoreException(errorCode + " - " + message);
        }
        String userNameWithoutDomain = UserCoreUtil.removeDomainFromName(userName);
        if (claims != null && claims.containsKey(USERNAME_CLAIM_URI) && !claims.get(USERNAME_CLAIM_URI).equals(userNameWithoutDomain)) {
            throw new UserStoreException("Username and the username claim value should be same.");
        }
        UserStore userStore = this.getUserStore(userName);
        boolean isUniqueUserIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().addUser(userStore.getDomainFreeName(), credential, roleList, claims, profileName, requirePasswordChange);
            return;
        }
        try {
            credentialObj = Secret.getSecret((Object)credential);
        }
        catch (UnsupportedSecretTypeException e) {
            this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage(), userName, credential, roleList, claims, profileName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString(), e);
        }
        try {
            String errorCode;
            String regEx;
            if (userStore.isSystemStore()) {
                this.systemUserRoleManager.addSystemUser(userName, credentialObj, roleList);
                return;
            }
            if (this.isReadOnly()) {
                this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userName, credential, roleList, claims, profileName);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
            }
            if (userName.indexOf(CarbonConstants.DOMAIN_SEPARATOR) > 0) {
                userName = userStore.getDomainFreeName();
                roleList = UserCoreUtil.removeDomainFromNames(roleList);
            }
            if (roleList == null) {
                roleList = new String[]{};
            }
            if (claims == null) {
                claims = new HashMap<String, String>();
            }
            try {
                Iterator<UserStoreManagerListener> e = UMListenerServiceComponent.getUserStoreManagerListeners().iterator();
                while (e.hasNext()) {
                    UserStoreManagerListener userStoreManagerListener;
                    Object credentialArgument = (userStoreManagerListener = e.next()) instanceof SecretHandleableListener ? credentialObj : credential;
                    if (userStoreManagerListener.addUser(userName, credentialArgument, roleList, claims, profileName, this)) continue;
                    this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getMessage(), "Pre-listener tasks failed"), userName, credential, roleList, claims, profileName);
                    return;
                }
            }
            catch (UserStoreException ex) {
                this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getMessage(), ex.getMessage()), userName, credential, roleList, claims, profileName);
                throw ex;
            }
            for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (userOperationEventListener instanceof SecretHandleableListener) {
                    try {
                        if (userOperationEventListener.doPreAddUser(userName, credentialObj, roleList, claims, profileName, this)) continue;
                        this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getMessage(), "Pre-listener tasks failed"), userName, credential, roleList, claims, profileName);
                        return;
                    }
                    catch (UserStoreException ex) {
                        String message = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getMessage(), ex.getMessage());
                        this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getCode(), message, userName, credential, roleList, claims, profileName);
                        throw ex;
                    }
                }
                StringBuffer credBuff = null;
                if (credential == null) {
                    credBuff = new StringBuffer();
                } else if (credential instanceof String) {
                    credBuff = new StringBuffer((String)credential);
                }
                if (credBuff == null) continue;
                try {
                    if (!userOperationEventListener.doPreAddUser(userName, credBuff, roleList, claims, profileName, this)) {
                        this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getMessage(), "Pre-listener tasks failed"), userName, credential, roleList, claims, profileName);
                        return;
                    }
                }
                catch (UserStoreException e) {
                    this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getMessage(), e.getMessage()), userName, credential, roleList, claims, profileName);
                    throw e;
                }
                credential = credBuff.toString();
                credentialObj.clear();
                try {
                    credentialObj = Secret.getSecret((Object)credential);
                }
                catch (UnsupportedSecretTypeException e) {
                    this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage(), userName, credential, roleList, claims, profileName);
                    throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString(), e);
                }
            }
            if (!this.checkUserNameValid(userStore.getDomainFreeName())) {
                regEx = this.realmConfig.getUserStoreProperty("UsernameJavaRegEx");
                if (StringUtils.isEmpty((String)regEx) || StringUtils.isEmpty((String)regEx.trim())) {
                    regEx = this.realmConfig.getUserStoreProperty("UserNameJavaRegEx");
                }
                String string = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_USER_NAME.getMessage(), userStore.getDomainFreeName(), regEx);
                errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_USER_NAME.getCode();
                this.handleAddUserFailure(errorCode, string, userName, credential, roleList, claims, profileName);
                throw new UserStoreException(errorCode + " - " + string);
            }
            if (!this.checkUserPasswordValid(credentialObj)) {
                regEx = this.realmConfig.getUserStoreProperty("PasswordJavaRegEx");
                String string = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getMessage(), regEx);
                errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getCode();
                this.handleAddUserFailure(errorCode, string, userName, credential, roleList, claims, profileName);
                throw new UserStoreException(errorCode + " - " + string);
            }
            boolean isExistingUser = isUniqueUserIdEnabled ? this.getUserIDFromUserName(userName) != null : this.doCheckExistingUser(userName);
            if (isExistingUser) {
                String string = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_USER_ALREADY_EXISTS.getMessage(), userName);
                errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_USER_ALREADY_EXISTS.getCode();
                this.handleAddUserFailure(errorCode, string, userName, credential, roleList, claims, profileName);
                throw new UserStoreException(errorCode + " - " + string);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> externalRoles = new ArrayList<String>();
            this.filterRoles(roleList, arrayList, externalRoles);
            for (String string : arrayList) {
                if (this.hybridRoleManager.isExistingRole(string)) continue;
                String message = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INTERNAL_ROLE_NOT_EXISTS.getMessage(), string);
                String errorCode2 = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INTERNAL_ROLE_NOT_EXISTS.getCode();
                this.handleAddUserFailure(errorCode2, message, userName, credential, roleList, claims, profileName);
                throw new UserStoreException(errorCode2 + " - " + message);
            }
            for (String string : externalRoles) {
                if (this.doCheckExistingRole(string)) continue;
                String message = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_EXTERNAL_ROLE_NOT_EXISTS.getMessage(), string);
                String errorCode3 = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_EXTERNAL_ROLE_NOT_EXISTS.getCode();
                this.handleAddUserFailure(errorCode3, message, userName, credential, roleList, claims, profileName);
                throw new UserStoreException(errorCode3 + " - " + message);
            }
            for (Map.Entry entry : claims.entrySet()) {
                ClaimMapping claimMapping;
                try {
                    claimMapping = (ClaimMapping)this.claimManager.getClaimMapping((String)entry.getKey());
                }
                catch (org.wso2.carbon.user.api.UserStoreException e) {
                    String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNABLE_TO_FETCH_CLAIM_MAPPING.getMessage(), "persisting user attributes.");
                    String errorCode4 = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNABLE_TO_FETCH_CLAIM_MAPPING.getCode();
                    this.handleAddUserFailure(errorCode4, errorMessage, userName, credential, roleList, claims, profileName);
                    throw new UserStoreException(errorCode4 + " - " + errorMessage, e);
                }
                if (claimMapping != null) continue;
                String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.getMessage(), entry.getKey());
                String errorCode5 = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.getCode();
                this.handleAddUserFailure(errorCode5, errorMessage, userName, credential, roleList, claims, profileName);
                throw new UserStoreException(errorCode5 + " - " + errorMessage);
            }
            try {
                if (isUniqueUserIdEnabled) {
                    user = this.doAddUserWithID(userName, credential, externalRoles.toArray(new String[0]), claims, profileName, requirePasswordChange);
                } else {
                    this.doAddUser(userName, credentialObj, externalRoles.toArray(new String[0]), claims, profileName, requirePasswordChange);
                }
            }
            catch (UserStoreException ex) {
                this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_ADDING_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_ADDING_USER.getMessage(), ex.getMessage()), userName, credential, roleList, claims, profileName);
                throw ex;
            }
            if (arrayList.size() > 0) {
                this.hybridRoleManager.updateHybridRoleListOfUser(userName, null, arrayList.toArray(new String[0]));
            }
            try {
                Iterator<UserOperationEventListener> ex = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
                while (ex.hasNext()) {
                    UserOperationEventListener userOperationEventListener;
                    Object credentialArgument = (userOperationEventListener = ex.next()) instanceof SecretHandleableListener ? credentialObj : credential;
                    if (userOperationEventListener.doPostAddUser(userName, credentialArgument, roleList, claims, profileName, this)) continue;
                    this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_USER.getMessage(), "Post-listener tasks failed"), userName, credential, roleList, claims, profileName);
                    return;
                }
            }
            catch (UserStoreException ex) {
                this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_USER.getMessage(), ex.getMessage()), userName, credential, roleList, claims, profileName);
                throw ex;
            }
        }
        finally {
            credentialObj.clear();
        }
        this.clearUserRolesCache(userName);
    }

    public boolean isUniqueUserIdEnabled() {
        return Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("UserIDEnabled"));
    }

    private void handleAddUserFailure(String errorCode, String errorMessage, String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onAddUserFailure(errorCode, errorMessage, userName, credential, roleList, claims, profileName, this)) continue;
            return;
        }
    }

    private void handleAddUserFailureWithID(String errorCode, String errorMessage, String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onAddUserFailureWithID(errorCode, errorMessage, userName, credential, roleList, claims, profileName, this)) continue;
            return;
        }
    }

    @Override
    public final void updateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        try {
            AccessController.doPrivileged(() -> {
                this.updateUserListOfRoleInternal(roleName, deletedUsers, newUsers);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            if (!(e.getException() instanceof UserStoreException)) {
                this.handleUpdateUserListOfRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_ROLE_OF_USER.getMessage(), e.getMessage()), roleName, deletedUsers, newUsers);
            }
            throw (UserStoreException)((Object)e.getException());
        }
    }

    private void handleUpdateUserListOfRoleFailure(String errorCode, String errorMessage, String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onUpdateUserListOfRoleFailure(errorCode, errorMessage, roleName, deletedUsers, newUsers, this)) continue;
            return;
        }
    }

    private void handleUpdateUserListOfRoleFailureWithID(String errorCode, String errorMessage, String roleName, String[] deletedUserIDs, String[] newUserIDs) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onUpdateUserListOfRoleFailureWithID(errorCode, errorMessage, roleName, deletedUserIDs, newUserIDs, this)) continue;
            return;
        }
    }

    private final void updateUserListOfRoleInternal(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        UserStore userStore;
        String primaryDomain = this.getMyDomainName();
        if (primaryDomain != null) {
            primaryDomain = primaryDomain + CarbonConstants.DOMAIN_SEPARATOR;
        }
        if (deletedUsers != null && deletedUsers.length > 0) {
            Arrays.sort(deletedUsers);
            if (UserCoreUtil.isPrimaryAdminRole(roleName, this.realmConfig)) {
                for (int i = 0; i < deletedUsers.length; ++i) {
                    if (!deletedUsers[i].equalsIgnoreCase(this.realmConfig.getAdminUserName()) && !(primaryDomain + deletedUsers[i]).equalsIgnoreCase(this.realmConfig.getAdminUserName())) continue;
                    this.handleUpdateUserListOfRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_REMOVE_ADMIN_ROLE_FROM_ADMIN.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_REMOVE_ADMIN_ROLE_FROM_ADMIN.getMessage(), roleName, deletedUsers, newUsers);
                    throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_REMOVE_ADMIN_ROLE_FROM_ADMIN.toString());
                }
            }
        }
        if ((userStore = this.getUserStore(roleName)).isHybridRole()) {
            if (UserCoreUtil.isEveryoneRole(roleName, this.realmConfig)) {
                this.handleUpdateUserListOfRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getMessage(), roleName, deletedUsers, newUsers);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.toString());
            }
            if (!this.handlePreUpdateUserListOfRole(roleName, deletedUsers, newUsers, false, true)) {
                this.handleUpdateUserListOfRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_UPDATE_USERS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_UPDATE_USERS_OF_ROLE.getMessage(), "Pre-listener tasks failed"), roleName, deletedUsers, newUsers);
                return;
            }
            if ("Internal".equalsIgnoreCase(userStore.getDomainName())) {
                this.hybridRoleManager.updateUserListOfHybridRole(userStore.getDomainFreeName(), deletedUsers, newUsers);
                this.handleDoPostUpdateUserListOfRole(roleName, deletedUsers, newUsers, true);
            } else {
                this.hybridRoleManager.updateUserListOfHybridRole(userStore.getDomainAwareName(), deletedUsers, newUsers);
                this.handleDoPostUpdateUserListOfRole(roleName, deletedUsers, newUsers, true);
            }
            this.clearUserRolesCacheByTenant(this.tenantId);
            return;
        }
        if (userStore.isSystemStore()) {
            this.systemUserRoleManager.updateUserListOfSystemRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedUsers), UserCoreUtil.removeDomainFromNames(newUsers));
            this.handleDoPostUpdateUserListOfRole(roleName, deletedUsers, newUsers, true);
            return;
        }
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().updateUserListOfRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedUsers), UserCoreUtil.removeDomainFromNames(newUsers));
            return;
        }
        if (deletedUsers == null) {
            deletedUsers = new String[]{};
        }
        if (newUsers == null) {
            newUsers = new String[]{};
        }
        if (!this.handlePreUpdateUserListOfRole(roleName, deletedUsers, newUsers, false, false)) {
            this.handleUpdateUserListOfRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_UPDATE_USERS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_UPDATE_USERS_OF_ROLE.getMessage(), "Pre-listener tasks failed"), roleName, deletedUsers, newUsers);
            return;
        }
        if (deletedUsers.length > 0 || newUsers != null && newUsers.length > 0) {
            if (!this.isReadOnly() && this.writeGroupsEnabled) {
                try {
                    if (this.isUniqueUserIdEnabledInUserStore(userStore)) {
                        List<String> newUserIds = this.getUserIDsFromUserNames(Arrays.asList(newUsers));
                        List<String> deletedUserIds = this.getUserIDsFromUserNames(Arrays.asList(deletedUsers));
                        this.doUpdateUserListOfRoleWithID(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedUserIds.toArray(new String[0])), UserCoreUtil.removeDomainFromNames(newUserIds.toArray(new String[0])));
                    }
                    this.doUpdateUserListOfRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedUsers), UserCoreUtil.removeDomainFromNames(newUsers));
                }
                catch (UserStoreException ex) {
                    this.handleUpdateUserListOfRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_UPDATE_USERS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_UPDATE_USERS_OF_ROLE.getMessage(), ex.getMessage()), roleName, deletedUsers, newUsers);
                    throw ex;
                }
            } else {
                this.handleUpdateUserListOfRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), roleName, deletedUsers, newUsers);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
            }
        }
        this.clearUserRolesCacheByTenant(this.tenantId);
        this.handleDoPostUpdateUserListOfRole(roleName, deletedUsers, newUsers, false);
    }

    private void handleDoPostUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers, boolean isAuditLogOnly) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger") || listener.doPostUpdateUserListOfRole(roleName, deletedUsers, newUsers, this)) continue;
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleUpdateUserListOfRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_UPDATE_USERS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_UPDATE_USERS_OF_ROLE.getMessage(), ex.getMessage()), roleName, deletedUsers, newUsers);
            throw ex;
        }
    }

    private void handleDoPostUpdateUserListOfRoleWithID(String roleName, String[] deletedUserIDs, String[] newUserIDs, boolean isAuditLogOnly) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger") || ((AbstractUserOperationEventListener)listener).doPostUpdateUserListOfRoleWithID(roleName, deletedUserIDs, newUserIDs, this)) continue;
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleUpdateUserListOfRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_UPDATE_USERS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_UPDATE_USERS_OF_ROLE.getMessage(), ex.getMessage()), roleName, deletedUserIDs, newUserIDs);
            throw ex;
        }
    }

    @Override
    public final void updateRoleListOfUser(String username, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        try {
            AccessController.doPrivileged(() -> {
                this.updateRoleListOfUserInternal(username, deletedRoles, newRoles);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            if (!(e.getException() instanceof UserStoreException)) {
                this.handleUpdateRoleListOfUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_UPDATE_USERS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_UPDATE_USERS_OF_ROLE.getMessage(), e.getMessage()), username, deletedRoles, newRoles);
            }
            throw (UserStoreException)((Object)e.getException());
        }
    }

    private void handleUpdateRoleListOfUserFailure(String errorCode, String errorMessage, String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onUpdateRoleListOfUserFailure(errorCode, errorMessage, userName, deletedRoles, newRoles, this)) continue;
            return;
        }
    }

    private void handleUpdateRoleListOfUserFailureWithID(String errorCode, String errorMessage, String userID, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((AbstractUserManagementErrorListener)listener).onUpdateRoleListOfUserFailureWithID(errorCode, errorMessage, userID, deletedRoles, newRoles, this)) continue;
            return;
        }
    }

    private final void updateRoleListOfUserInternal(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        String domain;
        UserStore userStore;
        String primaryDomain = this.realmConfig.getUserStoreProperty("DomainName");
        if (primaryDomain != null) {
            primaryDomain = primaryDomain + CarbonConstants.DOMAIN_SEPARATOR;
        }
        if (deletedRoles != null && deletedRoles.length > 0) {
            Arrays.sort(deletedRoles);
            if (UserCoreUtil.isPrimaryAdminUser(userName, this.realmConfig)) {
                for (int i = 0; i < deletedRoles.length; ++i) {
                    if (!deletedRoles[i].equalsIgnoreCase(this.realmConfig.getAdminRoleName()) && !(primaryDomain + deletedRoles[i]).equalsIgnoreCase(this.realmConfig.getAdminRoleName())) continue;
                    this.handleUpdateRoleListOfUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_REMOVE_ADMIN_ROLE_FROM_ADMIN.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_REMOVE_ADMIN_ROLE_FROM_ADMIN.getMessage(), userName, deletedRoles, newRoles);
                    throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_REMOVE_ADMIN_ROLE_FROM_ADMIN.toString());
                }
            }
        }
        if ((userStore = this.getUserStore(userName)).isRecurssive()) {
            userStore.getUserStoreManager().updateRoleListOfUser(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedRoles), UserCoreUtil.removeDomainFromNames(newRoles));
            return;
        }
        if (userStore.isSystemStore()) {
            this.systemUserRoleManager.updateSystemRoleListOfUser(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedRoles), UserCoreUtil.removeDomainFromNames(newRoles));
            return;
        }
        if (deletedRoles == null) {
            deletedRoles = new String[]{};
        }
        if (newRoles == null) {
            newRoles = new String[]{};
        }
        if (userName.indexOf(CarbonConstants.DOMAIN_SEPARATOR) > 0) {
            userName = userStore.getDomainFreeName();
            deletedRoles = UserCoreUtil.removeDomainFromNames(deletedRoles);
            newRoles = UserCoreUtil.removeDomainFromNames(newRoles);
        }
        ArrayList<String> internalRoleDel = new ArrayList<String>();
        ArrayList<String> internalRoleNew = new ArrayList<String>();
        ArrayList<String> roleDel = new ArrayList<String>();
        ArrayList<String> roleNew = new ArrayList<String>();
        ArrayList<String> internalRoleDelWithDomain = new ArrayList<String>();
        ArrayList<String> internalRoleNewWithDomain = new ArrayList<String>();
        if (deletedRoles != null && deletedRoles.length > 0) {
            for (String deleteRole : deletedRoles) {
                if (UserCoreUtil.isEveryoneRole(deleteRole, this.realmConfig)) {
                    this.handleUpdateRoleListOfUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getMessage(), userName, deletedRoles, newRoles);
                    throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.toString());
                }
                domain = null;
                int index1 = deleteRole.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
                if (index1 > 0) {
                    domain = deleteRole.substring(0, index1);
                }
                this.processDeletedRoles(internalRoleDel, roleDel, deleteRole, domain, internalRoleDelWithDomain);
            }
            deletedRoles = roleDel.toArray(new String[roleDel.size()]);
        }
        if (newRoles != null && newRoles.length > 0) {
            for (String newRole : newRoles) {
                if (UserCoreUtil.isEveryoneRole(newRole, this.realmConfig)) {
                    this.handleUpdateRoleListOfUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getMessage(), userName, deletedRoles, newRoles);
                    throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.toString());
                }
                domain = null;
                int index2 = newRole.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
                if (index2 > 0) {
                    domain = newRole.substring(0, index2);
                }
                this.processNewRoles(internalRoleNew, roleNew, newRole, domain, internalRoleNewWithDomain);
            }
            newRoles = roleNew.toArray(new String[roleNew.size()]);
        }
        boolean isPreUpdateInternalRoleListOfUserSuccess = true;
        boolean isPreUpdateRoleListOfUserSuccess = true;
        Object[] deletedInternalRolesArray = new String[]{};
        Object[] addInternalRolesArray = new String[]{};
        if (CollectionUtils.isNotEmpty(internalRoleDel) || CollectionUtils.isNotEmpty(internalRoleNew)) {
            deletedInternalRolesArray = internalRoleDel.toArray(new String[internalRoleDel.size()]);
            String[] deletedRolesArrayWithDomain = internalRoleDelWithDomain.toArray(new String[internalRoleDelWithDomain.size()]);
            addInternalRolesArray = internalRoleNew.toArray(new String[internalRoleNew.size()]);
            String[] addRolesArrayWithDomain = internalRoleNewWithDomain.toArray(new String[internalRoleNewWithDomain.size()]);
            isPreUpdateInternalRoleListOfUserSuccess = this.handlePreUpdateRoleListOfUser(userName, deletedRolesArrayWithDomain, addRolesArrayWithDomain, false, true);
        }
        if (ArrayUtils.isNotEmpty((Object[])deletedRoles) || ArrayUtils.isNotEmpty((Object[])newRoles)) {
            isPreUpdateRoleListOfUserSuccess = this.handlePreUpdateRoleListOfUser(userName, deletedRoles, newRoles, false, false);
        }
        if (!isPreUpdateInternalRoleListOfUserSuccess || !isPreUpdateRoleListOfUserSuccess) {
            this.handleUpdateRoleListOfUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_OF_USER.getMessage(), "Pre-listener tasks failed"), userName, deletedRoles, newRoles);
            return;
        }
        if (ArrayUtils.isNotEmpty((Object[])deletedInternalRolesArray) || ArrayUtils.isNotEmpty((Object[])addInternalRolesArray)) {
            this.hybridRoleManager.updateHybridRoleListOfUser(userStore.getDomainFreeName(), (String[])deletedInternalRolesArray, (String[])addInternalRolesArray);
        }
        if (ArrayUtils.isNotEmpty((Object[])deletedRoles) || ArrayUtils.isNotEmpty((Object[])newRoles)) {
            if (!this.isReadOnly() && this.writeGroupsEnabled) {
                try {
                    boolean isUniqueUserIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
                    if (isUniqueUserIdEnabled) {
                        String userID = this.getUserIDFromUserName(userName);
                        this.doUpdateRoleListOfUserWithID(userID, deletedRoles, newRoles);
                    }
                    this.doUpdateRoleListOfUser(userName, deletedRoles, newRoles);
                }
                catch (UserStoreException ex) {
                    this.handleUpdateRoleListOfUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_ROLE_OF_USER.getMessage(), ex.getMessage()), userName, deletedRoles, newRoles);
                    throw ex;
                }
            } else {
                this.handleUpdateRoleListOfUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userName, deletedRoles, newRoles);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
            }
        }
        this.clearUserRolesCache(userName);
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (listener.doPostUpdateRoleListOfUser(userName, deletedRoles, newRoles, this)) continue;
                this.handleUpdateRoleListOfUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_ROLE_OF_USER.getMessage(), "Post-listener tasks failed"), userName, deletedRoles, newRoles);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleUpdateRoleListOfUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_ROLE_OF_USER.getMessage(), ex.getMessage()), userName, deletedRoles, newRoles);
            throw ex;
        }
    }

    private void handleUpdateRoleNameFailure(String errorCode, String errorMessage, String roleName, String newRoleName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onUpdateRoleNameFailure(errorCode, errorMessage, roleName, newRoleName, this)) continue;
            return;
        }
    }

    private void handlePostUpdateRoleName(String roleName, String newRoleName, boolean isAuditLogOnly) throws UserStoreException {
        try {
            boolean internalRole = this.isAnInternalRole(roleName);
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger")) continue;
                boolean success = false;
                if (internalRole && listener instanceof AbstractUserOperationEventListener) {
                    success = ((AbstractUserOperationEventListener)listener).doPostUpdateInternalRoleName(roleName, newRoleName, this);
                } else if (internalRole && !(listener instanceof AbstractUserOperationEventListener)) {
                    success = true;
                } else if (!internalRole) {
                    success = listener.doPostUpdateRoleName(roleName, newRoleName, this);
                }
                if (success) continue;
                this.handleUpdateRoleNameFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_ROLE_NAME.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_ROLE_NAME.getMessage(), "Post-listener tasks failed"), roleName, newRoleName);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleUpdateRoleNameFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_ROLE_NAME.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_ROLE_NAME.getMessage(), ex.getMessage()), roleName, newRoleName);
            throw ex;
        }
    }

    private boolean handlePreUpdateRoleName(String roleName, String newRoleName, boolean isAuditLogOnly) throws UserStoreException {
        try {
            boolean internalRole = this.isAnInternalRole(roleName);
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger")) continue;
                boolean success = false;
                if (internalRole && listener instanceof AbstractUserOperationEventListener) {
                    success = ((AbstractUserOperationEventListener)listener).doPreUpdateInternalRoleName(roleName, newRoleName, this);
                }
                if (internalRole && !(listener instanceof AbstractUserOperationEventListener)) {
                    success = true;
                } else if (!internalRole) {
                    success = listener.doPreUpdateRoleName(roleName, newRoleName, this);
                }
                if (success) continue;
                this.handleUpdateRoleNameFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_NAME.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_NAME.getMessage(), "Pre-listener tasks failed"), roleName, newRoleName);
                return false;
            }
        }
        catch (UserStoreException ex) {
            this.handleUpdateRoleNameFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_NAME.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_NAME.getMessage(), ex.getMessage()), roleName, newRoleName);
            throw ex;
        }
        return true;
    }

    @Override
    public final void updateRoleName(String roleName, String newRoleName) throws UserStoreException {
        UserStore userStoreNew;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            this.callSecure("updateRoleName", new Object[]{roleName, newRoleName}, argTypes);
            return;
        }
        if (UserCoreUtil.isPrimaryAdminRole(newRoleName, this.realmConfig)) {
            this.handleUpdateRoleNameFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_ADMIN_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_ADMIN_ROLE.getMessage(), roleName, newRoleName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_ADMIN_ROLE.toString());
        }
        if (UserCoreUtil.isEveryoneRole(newRoleName, this.realmConfig)) {
            this.handleUpdateRoleNameFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getMessage(), roleName, newRoleName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.toString());
        }
        UserStore userStore = this.getUserStoreOfRoles(roleName);
        if (!UserCoreUtil.canRoleBeRenamed(userStore, userStoreNew = this.getUserStore(newRoleName), this.realmConfig)) {
            this.handleUpdateRoleNameFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_RENAME_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_RENAME_ROLE.getMessage(), roleName, newRoleName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_RENAME_ROLE.toString());
        }
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().updateRoleName(userStore.getDomainFreeName(), userStoreNew.getDomainFreeName());
            return;
        }
        if (userStore.isHybridRole()) {
            if (!this.handlePreUpdateRoleName(roleName, newRoleName, false)) {
                return;
            }
            if ("Internal".equalsIgnoreCase(userStore.getDomainName())) {
                this.hybridRoleManager.updateHybridRoleName(userStore.getDomainFreeName(), userStoreNew.getDomainFreeName());
            } else {
                this.hybridRoleManager.updateHybridRoleName(userStore.getDomainAwareName(), userStoreNew.getDomainAwareName());
            }
            this.userRealm.getAuthorizationManager().resetPermissionOnUpdateRole(userStore.getDomainAwareName(), userStoreNew.getDomainAwareName());
            this.handlePostUpdateRoleName(roleName, newRoleName, false);
            this.clearUserRolesCacheByTenant(this.tenantId);
            return;
        }
        if (!this.isRoleNameValid(roleName)) {
            String regEx = this.realmConfig.getUserStoreProperty("RolenameJavaRegEx");
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_ROLE_NAME.getMessage(), roleName, regEx);
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_ROLE_NAME.getCode();
            this.handleUpdateRoleNameFailure(errorCode, errorMessage, roleName, newRoleName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        if (this.isExistingRole(newRoleName)) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ROLE_ALREADY_EXISTS.getMessage(), newRoleName);
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ROLE_ALREADY_EXISTS.getCode();
            this.handleUpdateRoleNameFailure(errorCode, errorMessage, roleName, newRoleName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        if (!this.handlePreUpdateRoleName(roleName, newRoleName, false)) {
            return;
        }
        if (!this.isReadOnly() && this.writeGroupsEnabled) {
            try {
                this.doUpdateRoleName(userStore.getDomainFreeName(), userStoreNew.getDomainFreeName());
            }
            catch (UserStoreException ex) {
                this.handleUpdateRoleNameFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_ROLE_NAME.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_ROLE_NAME.getMessage(), ex.getMessage()), roleName, newRoleName);
            }
        } else {
            this.handleUpdateRoleNameFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), roleName, newRoleName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        this.userRealm.getAuthorizationManager().resetPermissionOnUpdateRole(userStore.getDomainAwareName(), userStoreNew.getDomainAwareName());
        this.clearUserRolesCacheByTenant(this.tenantId);
        this.handlePostUpdateRoleName(roleName, newRoleName, false);
    }

    public boolean isExistingRole(String roleName, boolean shared) throws org.wso2.carbon.user.api.UserStoreException {
        if (shared) {
            return this.isExistingShareRole(roleName);
        }
        return this.isExistingRole(roleName);
    }

    @Override
    public boolean isExistingRole(String roleName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            Object object = this.callSecure("isExistingRole", new Object[]{roleName}, argTypes);
            return (Boolean)object;
        }
        UserStore userStore = this.getUserStoreOfRoles(roleName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().isExistingRole(userStore.getDomainFreeName());
        }
        if (userStore.isSystemStore()) {
            return this.systemUserRoleManager.isExistingRole(userStore.getDomainFreeName());
        }
        if (userStore.isHybridRole()) {
            boolean exist = !"Internal".equalsIgnoreCase(userStore.getDomainName()) ? this.hybridRoleManager.isExistingRole(userStore.getDomainAwareName()) : this.hybridRoleManager.isExistingRole(userStore.getDomainFreeName());
            return exist;
        }
        roleName = userStore.getDomainFreeName();
        if (this.isSharedGroupEnabled() && roleName.contains("@")) {
            return false;
        }
        boolean isExisting = this.doCheckExistingRole(roleName);
        if (!(isExisting || !this.isReadOnly() && this.readGroupsEnabled)) {
            isExisting = this.hybridRoleManager.isExistingRole(roleName);
        }
        if (!isExisting && this.systemUserRoleManager.isExistingRole(roleName)) {
            isExisting = true;
        }
        return isExisting;
    }

    public boolean isExistingShareRole(String roleName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            Object object = this.callSecure("isExistingShareRole", new Object[]{roleName}, argTypes);
            return (Boolean)object;
        }
        UserStoreManager manager = this.getUserStoreWithSharedRoles();
        if (manager == null) {
            throw new UserStoreException("Share Groups are not supported by this realm");
        }
        return ((AbstractUserStoreManager)manager).doCheckExistingRole(roleName);
    }

    public void updateUsersOfSharedRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        UserStoreManager manager = this.getUserStoreWithSharedRoles();
        if (manager == null) {
            throw new UserStoreException("Share Groups are not supported by this realm");
        }
        if (this.isUniqueUserIdEnabled(manager)) {
            ((AbstractUserStoreManager)manager).doUpdateUserListOfRoleWithID(roleName, this.getUserIDsFromUserNames(Arrays.asList(deletedUsers)).toArray(new String[0]), this.getUserIDsFromUserNames(Arrays.asList(newUsers)).toArray(new String[0]));
        } else {
            ((AbstractUserStoreManager)manager).doUpdateUserListOfRole(roleName, deletedUsers, newUsers);
        }
    }

    public String[] getSharedRolesOfUser(String userName, String tenantDomain, String filter) throws UserStoreException {
        UserStore userStore = this.getUserStore(userName);
        UserStoreManager manager = userStore.getUserStoreManager();
        if (!((AbstractUserStoreManager)manager).isSharedGroupEnabled()) {
            throw new UserStoreException("Share Groups are not supported by user store");
        }
        String[] sharedRoles = ((AbstractUserStoreManager)manager).isUniqueUserIdEnabled() ? ((AbstractUserStoreManager)manager).doGetSharedRoleListOfUserWithID(this.getUserIDFromUserName(userStore.getDomainFreeName()), tenantDomain, filter) : ((AbstractUserStoreManager)manager).doGetSharedRoleListOfUser(userStore.getDomainFreeName(), tenantDomain, filter);
        return UserCoreUtil.removeDomainFromNames(sharedRoles);
    }

    public String[] getUsersOfSharedRole(String roleName, String filter) throws UserStoreException {
        UserStoreManager manager = this.getUserStoreWithSharedRoles();
        if (manager == null) {
            throw new UserStoreException("Share Groups are not supported by this realm");
        }
        if (this.isUniqueUserIdEnabled(manager)) {
            List<User> users = ((AbstractUserStoreManager)manager).doGetUserListOfRoleWithID(roleName, filter);
            return (String[])users.stream().map(User::getDomainQualifiedUsername).toArray(String[]::new);
        }
        String[] users = ((AbstractUserStoreManager)manager).doGetUserListOfRole(roleName, filter);
        return UserCoreUtil.removeDomainFromNames(users);
    }

    public String[] getSharedRoleNames(String tenantDomain, String filter, int maxItemLimit) throws UserStoreException {
        UserStoreManager manager = this.getUserStoreWithSharedRoles();
        if (manager == null) {
            throw new UserStoreException("Share Groups are not supported by this realm");
        }
        String[] sharedRoles = null;
        try {
            sharedRoles = ((AbstractUserStoreManager)manager).doGetSharedRoleNames(tenantDomain, filter, maxItemLimit);
        }
        catch (UserStoreException e) {
            throw new UserStoreException("Error while retrieving shared roles", (Throwable)((Object)e));
        }
        return UserCoreUtil.removeDomainFromNames(sharedRoles);
    }

    public String[] getSharedRoleNames(String filter, int maxItemLimit) throws UserStoreException {
        UserStoreManager manager = this.getUserStoreWithSharedRoles();
        if (manager == null) {
            throw new UserStoreException("Share Groups are not supported by this realm");
        }
        String[] sharedRoles = null;
        try {
            sharedRoles = ((AbstractUserStoreManager)manager).doGetSharedRoleNames(null, filter, maxItemLimit);
        }
        catch (UserStoreException e) {
            throw new UserStoreException("Error while retrieving shared roles", (Throwable)((Object)e));
        }
        return UserCoreUtil.removeDomainFromNames(sharedRoles);
    }

    public void addInternalRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permission) throws UserStoreException {
        this.doAddInternalRole(roleName, userList, permission);
    }

    private UserStoreManager getUserStoreWithSharedRoles() throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{};
            Object object = this.callSecure("getUserStoreWithSharedRoles", new Object[0], argTypes);
            return (UserStoreManager)object;
        }
        UserStoreManager sharedRoleManager = null;
        if (this.isSharedGroupEnabled()) {
            return this;
        }
        for (Map.Entry<String, UserStoreManager> entry : this.userStoreManagerHolder.entrySet()) {
            UserStoreManager manager = entry.getValue();
            if (manager == null || !((AbstractUserStoreManager)manager).isSharedGroupEnabled()) continue;
            if (sharedRoleManager != null) {
                throw new UserStoreException("There can not be more than one user store that supportshared groups");
            }
            sharedRoleManager = manager;
        }
        return sharedRoleManager;
    }

    public boolean isUserInRole(String userName, String roleName) throws UserStoreException {
        String[] internalRoles;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("isUserInRole", new Object[]{userName, roleName}, argTypes);
            return (Boolean)object;
        }
        if (roleName == null || roleName.trim().length() == 0 || userName == null || userName.trim().length() == 0) {
            return false;
        }
        if ("system/wso2.anonymous.role".equalsIgnoreCase(roleName) && "wso2.anonymous.user".equalsIgnoreCase(userName)) {
            return true;
        }
        if (!"wso2.anonymous.user".equalsIgnoreCase(userName) && this.realmConfig.getEveryOneRoleName().equalsIgnoreCase(roleName) && !this.systemUserRoleManager.isExistingSystemUser(UserCoreUtil.removeDomainFromName(userName))) {
            return true;
        }
        String[] roles = null;
        roles = this.getRoleListOfUserFromCache(this.tenantId, userName);
        if (roles != null && roles.length > 0 && UserCoreUtil.isContain(roleName, roles)) {
            return true;
        }
        String modifiedUserName = "@__isUserHasTheRole__@" + userName;
        roles = this.getRoleListOfUserFromCache(this.tenantId, modifiedUserName);
        if (roles != null && roles.length > 0 && UserCoreUtil.isContain(roleName, roles)) {
            return true;
        }
        if (("Internal".equalsIgnoreCase(UserCoreUtil.extractDomainFromName(roleName)) || APPLICATION_DOMAIN.equalsIgnoreCase(UserCoreUtil.extractDomainFromName(roleName)) || WORKFLOW_DOMAIN.equalsIgnoreCase(UserCoreUtil.extractDomainFromName(roleName))) && UserCoreUtil.isContain(roleName, internalRoles = this.doGetInternalRoleListOfUser(userName, roleName))) {
            this.addToIsUserHasRole(modifiedUserName, roleName, roles);
            return true;
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive() && userStore.getUserStoreManager() instanceof AbstractUserStoreManager) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).isUserInRole(userStore.getDomainFreeName(), roleName);
        }
        if (userStore.isSystemStore()) {
            return this.systemUserRoleManager.isUserInRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromName(roleName));
        }
        if (this.realmConfig.isPrimary() && roleName.equalsIgnoreCase(this.realmConfig.getAdminRoleName()) && userName.equalsIgnoreCase(this.realmConfig.getAdminUserName())) {
            return true;
        }
        String roleDomainName = UserCoreUtil.extractDomainFromName(roleName);
        String roleDomainNameForForest = this.realmConfig.getUserStoreProperty("GroupSearchDomains");
        if (roleDomainNameForForest != null && roleDomainNameForForest.trim().length() > 0) {
            String[] values;
            for (String value : values = roleDomainNameForForest.split("#")) {
                if (value == null || value.trim().equalsIgnoreCase(roleDomainName)) continue;
                return false;
            }
        } else if (!(userStore.getDomainName().equalsIgnoreCase(roleDomainName) || "Internal".equalsIgnoreCase(roleDomainName) || APPLICATION_DOMAIN.equalsIgnoreCase(roleDomainName) || WORKFLOW_DOMAIN.equalsIgnoreCase(roleDomainName))) {
            return false;
        }
        boolean success = false;
        if (this.readGroupsEnabled) {
            success = this.isUniqueUserIdEnabledInUserStore(userStore) ? this.doCheckIsUserInRoleWithID(this.getUserIDFromUserName(userName), UserCoreUtil.removeDomainFromName(roleName)) : this.doCheckIsUserInRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromName(roleName));
            if (this.isRoleAndGroupSeparationEnabled()) {
                String[] rolesList = this.isUniqueUserIdEnabledInUserStore(userStore) ? this.doGetExternalRoleListOfUserWithID(this.getUserIDFromUserName(userName), QUERY_FILTER_STRING_ANY) : this.doGetExternalRoleListOfUser(userName, QUERY_FILTER_STRING_ANY);
                Map<String, List<String>> rolesOfGroups = this.getHybridRoleListOfGroups(Arrays.asList(rolesList), userStore.getDomainName());
                Set<String> roleListOfGroups = this.getUniqueSet(rolesOfGroups);
                if (roleListOfGroups.stream().anyMatch(roleName::equalsIgnoreCase)) {
                    success = true;
                }
            }
        }
        if (success) {
            this.addToIsUserHasRole(modifiedUserName, roleName, roles);
        }
        return success;
    }

    public abstract boolean doCheckIsUserInRole(String var1, String var2) throws UserStoreException;

    public boolean doCheckIsUserInRoleWithID(String userID, String roleName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doCheckIsUserInRoleWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doCheckIsUserInRoleWithID operation is not implemented in: " + this.getClass());
    }

    private void addToIsUserHasRole(String userName, String roleName, String[] currentRoles) {
        ArrayList<Object> roles = currentRoles != null ? new ArrayList<String>(Arrays.asList(currentRoles)) : new ArrayList<String>();
        roles.add(roleName);
        this.addToUserRolesCache(this.tenantId, userName, roles.toArray(new String[0]));
    }

    @Override
    public boolean isExistingUser(String userName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            Object object = this.callSecure("isExistingUser", new Object[]{userName}, argTypes);
            return (Boolean)object;
        }
        if (UserCoreUtil.isRegistrySystemUser(userName)) {
            return true;
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().isExistingUser(userStore.getDomainFreeName());
        }
        if (userStore.isSystemStore()) {
            return this.systemUserRoleManager.isExistingSystemUser(userStore.getDomainFreeName());
        }
        if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
            return this.doCheckExistingUser(userStore.getDomainFreeName());
        }
        return this.getUserIDFromUserName(userName) != null;
    }

    @Override
    public final String[] listUsers(String filter, int maxItemLimit) throws UserStoreException {
        String[] userList;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, Integer.TYPE};
            Object object = this.callSecure("listUsers", new Object[]{filter, maxItemLimit}, argTypes);
            return (String[])object;
        }
        int index = filter.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index > 0) {
            String domain = filter.substring(0, index);
            UserStoreManager secManager = this.getSecondaryUserStoreManager(domain);
            if (secManager != null) {
                filter = filter.substring(index + 1);
                if (secManager instanceof AbstractUserStoreManager) {
                    String[] userList2 = !((AbstractUserStoreManager)secManager).isUniqueUserIdEnabled() ? ((AbstractUserStoreManager)secManager).doListUsers(filter, maxItemLimit) : (String[])((AbstractUserStoreManager)secManager).doListUsersWithID(filter, maxItemLimit).stream().map(User::getDomainQualifiedUsername).toArray(String[]::new);
                    this.handlePostGetUserList(null, null, new ArrayList<String>(Arrays.asList(userList2)), true);
                    return userList2;
                }
                String[] userList3 = secManager.listUsers(filter, maxItemLimit);
                this.handlePostGetUserList(null, null, new ArrayList<String>(Arrays.asList(userList3)), true);
                return userList3;
            }
        } else if (index == 0) {
            String[] userList4 = !this.isUniqueUserIdEnabled() ? this.doListUsers(filter.substring(1), maxItemLimit) : (String[])this.doListUsersWithID(filter.substring(1), maxItemLimit).stream().map(User::getDomainQualifiedUsername).toArray(String[]::new);
            this.handlePostGetUserList(null, null, new ArrayList<String>(Arrays.asList(userList4)), true);
            return userList4;
        }
        try {
            userList = !this.isUniqueUserIdEnabled() ? this.doListUsers(filter, maxItemLimit) : (String[])this.doListUsersWithID(filter, maxItemLimit).stream().map(User::getUsername).toArray(String[]::new);
        }
        catch (UserStoreException ex) {
            this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getMessage(), ex.getMessage()), null, null, null);
            throw ex;
        }
        String primaryDomain = this.realmConfig.getUserStoreProperty("DomainName");
        if (this.getSecondaryUserStoreManager() != null) {
            for (Map.Entry<String, UserStoreManager> entry : this.userStoreManagerHolder.entrySet()) {
                String[] secondUserList;
                if (entry.getKey().equalsIgnoreCase(primaryDomain)) continue;
                UserStoreManager storeManager = entry.getValue();
                if (storeManager instanceof AbstractUserStoreManager) {
                    try {
                        secondUserList = !((AbstractUserStoreManager)storeManager).isUniqueUserIdEnabled() ? ((AbstractUserStoreManager)storeManager).doListUsers(filter, maxItemLimit) : (String[])((AbstractUserStoreManager)storeManager).doListUsersWithID(filter, maxItemLimit).stream().map(User::getDomainQualifiedUsername).toArray(String[]::new);
                        userList = UserCoreUtil.combineArrays(userList, secondUserList);
                    }
                    catch (UserStoreException ex) {
                        this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getMessage(), ex.getMessage()), null, null, null);
                        log.error((Object)ex);
                    }
                    continue;
                }
                secondUserList = storeManager.listUsers(filter, maxItemLimit);
                userList = UserCoreUtil.combineArrays(userList, secondUserList);
            }
        }
        this.handlePostGetUserList(null, null, new ArrayList<String>(Arrays.asList(userList)), true);
        return userList;
    }

    @Override
    public long countRoles(String filter) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            Object object = this.callSecure("countRoles", new Object[]{filter}, argTypes);
            return (Long)object;
        }
        int index = filter.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index > 0) {
            String domain = filter.substring(0, index);
            if (this.isInternalRole(domain)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Internal domain is provided. Thus calling the hybrid role manager to get the internal role count.");
                }
                return this.hybridRoleManager.countHybridRoles(filter);
            }
            filter = filter.substring(index + 1);
            UserStoreManager secondaryUserStoreManager = this.getSecondaryUserStoreManager(domain);
            if (secondaryUserStoreManager != null) {
                if (secondaryUserStoreManager instanceof AbstractUserStoreManager) {
                    return ((AbstractUserStoreManager)secondaryUserStoreManager).doCountRoles(filter);
                }
                throw new UserStoreException("User store not supported");
            }
        } else if (index == 0) {
            return this.doCountRoles(filter.substring(1));
        }
        return this.doCountRoles(filter);
    }

    public final long countUsersWithClaims(String claimURI, String valueFilter) throws UserStoreException {
        return this.doCountUsersWithClaims(claimURI, valueFilter);
    }

    private void handleDoPostGetUserListOfRoleWithID(String roleName, List<User> userList) throws UserStoreException {
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (!(userOperationEventListener instanceof AbstractUserOperationEventListener) || ((AbstractUserOperationEventListener)userOperationEventListener).doPostGetUserListOfRoleWithID(roleName, userList, this)) continue;
            return;
        }
    }

    private void handleDoPostGetUserListOfRole(String roleName, String[] userList) throws UserStoreException {
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (!(userOperationEventListener instanceof AbstractUserOperationEventListener) || ((AbstractUserOperationEventListener)userOperationEventListener).doPostGetUserListOfRole(roleName, userList, this)) continue;
            return;
        }
    }

    @Override
    public final String[] getUserListOfRole(String roleName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            Object object = this.callSecure("getUserListOfRole", new Object[]{roleName}, argTypes);
            return (String[])object;
        }
        return this.getUserListOfRole(roleName, QUERY_FILTER_STRING_ANY, -1);
    }

    public final String[] getUserListOfRole(String roleName, String filter, int maxItemLimit) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, Integer.TYPE};
            Object object = this.callSecure("getUserListOfRole", new Object[]{roleName, filter, maxItemLimit}, argTypes);
            return (String[])object;
        }
        String[] userNames = new String[]{};
        if (!this.isExistingRole(roleName)) {
            this.handleDoPostGetUserListOfRole(roleName, userNames);
            return userNames;
        }
        UserStore userStore = this.getUserStoreOfRoles(roleName);
        if (userStore.isRecurssive()) {
            UserStoreManager resolvedUserStoreManager = userStore.getUserStoreManager();
            if (resolvedUserStoreManager instanceof AbstractUserStoreManager) {
                return ((AbstractUserStoreManager)resolvedUserStoreManager).getUserListOfRole(userStore.getDomainFreeName(), filter, maxItemLimit);
            }
            return resolvedUserStoreManager.getUserListOfRole(userStore.getDomainFreeName());
        }
        if (userStore.isSystemStore()) {
            String[] userList = this.systemUserRoleManager.getUserListOfSystemRole(userStore.getDomainFreeName());
            this.handleDoPostGetUserListOfRole(roleName, userList);
            return userList;
        }
        if (userStore.isHybridRole()) {
            String[] userNamesInHybrid = "Internal".equalsIgnoreCase(userStore.getDomainName()) ? this.hybridRoleManager.getUserListOfHybridRole(userStore.getDomainFreeName()) : this.hybridRoleManager.getUserListOfHybridRole(userStore.getDomainAwareName());
            if (this.isRoleAndGroupSeparationEnabled()) {
                HashSet<String> userListOfGroups = new HashSet<String>();
                String[] groupsOfRole = "Internal".equalsIgnoreCase(userStore.getDomainName()) ? this.hybridRoleManager.getGroupListOfHybridRole(userStore.getDomainFreeName()) : this.hybridRoleManager.getGroupListOfHybridRole(userStore.getDomainAwareName());
                for (String group : groupsOfRole) {
                    userListOfGroups.addAll(Arrays.asList(this.getUserListOfRole(group, filter, maxItemLimit)));
                }
                userNamesInHybrid = UserCoreUtil.combine(userNamesInHybrid, new ArrayList<String>(userListOfGroups));
            }
            ArrayList<String> finalNameList = new ArrayList<String>();
            String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
            if (userNamesInHybrid != null && userNamesInHybrid.length > 0) {
                if (displayNameAttribute != null && displayNameAttribute.trim().length() > 0) {
                    for (String userName : userNamesInHybrid) {
                        String domainName = UserCoreUtil.extractDomainFromName(userName);
                        if (domainName == null || domainName.trim().length() == 0) {
                            finalNameList.add(userName);
                        }
                        UserStoreManager userManager = this.userStoreManagerHolder.get(domainName);
                        userName = UserCoreUtil.removeDomainFromName(userName);
                        if (userManager == null) continue;
                        String[] displayNames = null;
                        displayNames = userManager instanceof AbstractUserStoreManager ? ((AbstractUserStoreManager)userManager).doGetDisplayNamesForInternalRole(new String[]{userName}) : userManager.getRoleNames();
                        for (String displayName : displayNames) {
                            String nameWithDomain = UserCoreUtil.addDomainToName(displayName, domainName);
                            finalNameList.add(nameWithDomain);
                        }
                    }
                } else {
                    this.handleDoPostGetUserListOfRole(roleName, userNamesInHybrid);
                    return userNamesInHybrid;
                }
            }
            String[] userList = finalNameList.toArray(new String[0]);
            this.handleDoPostGetUserListOfRole(roleName, userList);
            return userList;
        }
        if (this.readGroupsEnabled) {
            if (this.isUniqueUserIdEnabledInUserStore(userStore)) {
                List<User> users = this.doGetUserListOfRoleWithID(roleName, filter, maxItemLimit);
                userNames = (String[])users.stream().map(User::getDomainQualifiedUsername).toArray(String[]::new);
            } else {
                userNames = this.doGetUserListOfRole(roleName, filter, maxItemLimit);
            }
            this.handleDoPostGetUserListOfRole(roleName, userNames);
        }
        return userNames;
    }

    @Override
    public String[] getRoleListOfUser(String userName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            Object object = this.callSecure("getRoleListOfUser", new Object[]{userName}, argTypes);
            return (String[])object;
        }
        if ("wso2.anonymous.user".equalsIgnoreCase(userName)) {
            return new String[]{"system/wso2.anonymous.role"};
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().getRoleListOfUser(userStore.getDomainFreeName());
        }
        String[] roleNames = this.getRoleListOfUserFromCache(this.tenantId, userName);
        if (roleNames != null && roleNames.length > 0) {
            return roleNames;
        }
        if (userStore.isSystemStore()) {
            return this.systemUserRoleManager.getSystemRoleListOfUser(userStore.getDomainFreeName());
        }
        if (this.isUniqueUserIdEnabledInUserStore(userStore)) {
            String userID = this.getUserIDFromUserName(userName);
            if (userID == null) {
                return new String[]{this.realmConfig.getEveryOneRoleName()};
            }
            roleNames = this.doGetRoleListOfUserWithID(userID, QUERY_FILTER_STRING_ANY).toArray(new String[0]);
        } else {
            roleNames = this.doGetRoleListOfUser(userName, QUERY_FILTER_STRING_ANY);
        }
        return roleNames;
    }

    public ClaimManager getClaimManager() {
        return this.claimManager;
    }

    private void handleAddRoleFailure(String errorCode, String errorMessage, String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onAddRoleFailure(errorCode, errorMessage, roleName, userList, permissions, this)) continue;
            return;
        }
    }

    private void handleAddRoleFailureWithID(String errorCode, String errorMessage, String roleName, String[] userIDList, org.wso2.carbon.user.api.Permission[] permissions) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || ((UniqueIDUserManagementErrorEventListener)listener).onAddRoleFailureWithID(errorCode, errorMessage, roleName, userIDList, permissions, this)) continue;
            return;
        }
    }

    private void handlePostAddRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions, boolean isAuditLogOnly) throws UserStoreException {
        try {
            boolean internalRole = this.isAnInternalRole(roleName);
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger")) continue;
                boolean success = false;
                if (internalRole && listener instanceof AbstractUserOperationEventListener) {
                    success = ((AbstractUserOperationEventListener)listener).doPostAddInternalRole(roleName, userList, permissions, this);
                } else if (internalRole && !(listener instanceof AbstractUserOperationEventListener)) {
                    success = true;
                } else if (!internalRole) {
                    success = listener.doPostAddRole(roleName, userList, permissions, this);
                }
                if (success) continue;
                this.handleAddRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_ROLE.getMessage(), "Post-listener tasks failed"), roleName, userList, permissions);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleAddRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_ROLE.getMessage(), ex.getMessage()), roleName, userList, permissions);
            throw ex;
        }
    }

    private boolean handlePreAddRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions, boolean isAuditLogOnly) throws UserStoreException {
        try {
            boolean internalRole = this.isAnInternalRole(roleName);
            String internalSystemRolePrefix = "Internal" + UserCoreConstants.DOMAIN_SEPARATOR + "system_";
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                boolean success;
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger") || (success = internalRole && roleName.startsWith(internalSystemRolePrefix) ? true : (internalRole && listener instanceof AbstractUserOperationEventListener ? ((AbstractUserOperationEventListener)listener).doPreAddInternalRole(roleName, userList, permissions, this) : (internalRole ? true : listener.doPreAddRole(roleName, userList, permissions, this))))) continue;
                this.handleAddRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_ROLE.getMessage(), "Pre-listener tasks failed"), roleName, userList, permissions);
                return false;
            }
        }
        catch (UserStoreException ex) {
            this.handleAddRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_ROLE.getMessage(), ex.getMessage()), roleName, userList, permissions);
            throw ex;
        }
        return true;
    }

    public void addRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions, boolean isSharedRole) throws org.wso2.carbon.user.api.UserStoreException {
        if (StringUtils.isEmpty((String)roleName)) {
            this.handleAddRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_ADD_EMPTY_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_ADD_EMPTY_ROLE.getMessage(), roleName, userList, permissions);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_ADD_EMPTY_ROLE.toString());
        }
        if (userList == null) {
            userList = new String[]{};
        }
        UserStore userStore = this.getUserStoreOfRoles(roleName);
        if (isSharedRole && !this.isSharedGroupEnabled()) {
            this.handleAddRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_SHARED_ROLE_NOT_SUPPORTED.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_SHARED_ROLE_NOT_SUPPORTED.getMessage(), roleName, userList, permissions);
            throw new org.wso2.carbon.user.api.UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_SHARED_ROLE_NOT_SUPPORTED.toString());
        }
        if (userStore.isHybridRole()) {
            if (!this.handlePreAddRole(roleName, userList, permissions, false)) {
                return;
            }
            this.doAddInternalRole(roleName, userList, permissions);
            this.handlePostAddRole(roleName, userList, permissions, false);
            return;
        }
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().addRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(userList), permissions, isSharedRole);
            return;
        }
        if (permissions == null) {
            permissions = new org.wso2.carbon.user.api.Permission[]{};
        }
        if (roleName.indexOf(CarbonConstants.DOMAIN_SEPARATOR) > 0) {
            roleName = userStore.getDomainFreeName();
            userList = UserCoreUtil.removeDomainFromNames(userList);
        }
        if (!this.handlePreAddRole(roleName, userList, permissions, false)) {
            return;
        }
        if (this.isReadOnly()) {
            this.handleAddRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), roleName, userList, permissions);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        if (!this.isRoleNameValid(roleName)) {
            String regEx = this.realmConfig.getUserStoreProperty("RolenameJavaRegEx");
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_ROLE_NAME.getMessage(), roleName, regEx);
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_ROLE_NAME.getCode();
            this.handleAddRoleFailure(errorCode, errorMessage, roleName, userList, permissions);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        if (this.doCheckExistingRole(roleName)) {
            this.handleRoleAlreadyExistException(roleName, userList, permissions);
        }
        String roleWithDomain = null;
        if (this.writeGroupsEnabled) {
            try {
                if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
                    this.doAddRole(roleName, userList, isSharedRole);
                } else {
                    List<String> userIDs = this.getUserIDsFromUserNames(Arrays.asList(userList));
                    this.doAddRoleWithID(roleName, userIDs.toArray(new String[0]), isSharedRole);
                }
                roleWithDomain = UserCoreUtil.addDomainToName(roleName, this.getMyDomainName());
            }
            catch (UserStoreException ex) {
                this.handleAddRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_ADDING_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_ADDING_ROLE.getMessage(), ex.getMessage()), roleName, userList, permissions);
                throw ex;
            }
        } else {
            this.handleAddRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_WRITE_GROUPS_NOT_ENABLED.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_WRITE_GROUPS_NOT_ENABLED.getMessage(), roleName, userList, permissions);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_WRITE_GROUPS_NOT_ENABLED.toString());
        }
        if (permissions != null) {
            for (org.wso2.carbon.user.api.Permission permission : permissions) {
                String resourceId = permission.getResourceId();
                String action = permission.getAction();
                if (resourceId == null || resourceId.trim().length() == 0) continue;
                if (action == null || action.trim().length() == 0) {
                    action = "read";
                }
                this.userRealm.getAuthorizationManager().authorizeRole(roleWithDomain, resourceId, action);
            }
        }
        if (userList != null && userList.length > 0) {
            this.clearUserRolesCacheByTenant(this.tenantId);
        }
        this.handlePostAddRole(roleName, userList, permissions, false);
    }

    public boolean isSharedGroupEnabled() {
        String value = this.realmConfig.getUserStoreProperty("SharedGroupEnabled");
        try {
            return this.realmConfig.isPrimary() && !this.isReadOnly() && TRUE_VALUE.equalsIgnoreCase(value);
        }
        catch (UserStoreException e) {
            log.error((Object)e);
            return false;
        }
    }

    protected void filterSharedRoles(List<String> sharedRoles, String tenantDomain) {
        if (tenantDomain != null) {
            Iterator<String> i = sharedRoles.iterator();
            while (i.hasNext()) {
                String role = i.next();
                if (role.indexOf(tenantDomain) <= -1) continue;
                i.remove();
            }
        }
    }

    private void handleDeleteRoleFailure(String errorCode, String errorMessage, String roleName) throws UserStoreException {
        for (UserManagementErrorEventListener listener : UMListenerServiceComponent.getUserManagementErrorEventListeners()) {
            if (!listener.isEnable() || listener.onDeleteRoleFailure(errorCode, errorMessage, roleName, this)) continue;
            return;
        }
    }

    private void handleDoPostDeleteRole(String roleName, boolean isAuditLogOnly) throws UserStoreException {
        try {
            boolean internalRole = this.isAnInternalRole(roleName);
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger")) continue;
                boolean success = false;
                if (internalRole && listener instanceof AbstractUserOperationEventListener) {
                    success = ((AbstractUserOperationEventListener)listener).doPostDeleteInternalRole(roleName, this);
                } else if (internalRole && !(listener instanceof AbstractUserOperationEventListener)) {
                    success = true;
                } else if (!internalRole) {
                    success = listener.doPostDeleteRole(roleName, this);
                }
                if (success) continue;
                this.handleDeleteRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_ROLE.getMessage(), "Post-listener tasks failed"), roleName);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_ROLE.getMessage(), ex.getMessage()), roleName);
            throw ex;
        }
    }

    private boolean handleDoPreDeleteRole(String roleName, boolean isAuditLogOnly) throws UserStoreException {
        try {
            boolean internalRole = this.isAnInternalRole(roleName);
            String internalSystemRolePrefix = "Internal" + UserCoreConstants.DOMAIN_SEPARATOR + "system_";
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                boolean success;
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger") || (success = internalRole && roleName.startsWith(internalSystemRolePrefix) ? true : (internalRole && listener instanceof AbstractUserOperationEventListener ? ((AbstractUserOperationEventListener)listener).doPreDeleteInternalRole(roleName, this) : (internalRole ? true : listener.doPreDeleteRole(roleName, this))))) continue;
                this.handleDeleteRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_ROLE.getMessage(), "Pre-listener tasks failed"), roleName);
                return false;
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_ROLE.getMessage(), ex.getMessage()), roleName);
            throw ex;
        }
        return true;
    }

    @Override
    public final void deleteRole(String roleName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            this.callSecure("deleteRole", new Object[]{roleName}, argTypes);
            return;
        }
        if (UserCoreUtil.isPrimaryAdminRole(roleName, this.realmConfig)) {
            this.handleDeleteRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_DELETE_ADMIN_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_DELETE_ADMIN_ROLE.getMessage(), roleName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_DELETE_ADMIN_ROLE.toString());
        }
        if (UserCoreUtil.isEveryoneRole(roleName, this.realmConfig)) {
            this.handleDeleteRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_DELETE_EVERYONE_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_DELETE_EVERYONE_ROLE.getMessage(), roleName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_DELETE_EVERYONE_ROLE.toString());
        }
        UserStore userStore = this.getUserStoreOfRoles(roleName);
        if (userStore.isRecurssive()) {
            userStore.getUserStoreManager().deleteRole(userStore.getDomainFreeName());
            return;
        }
        String roleWithDomain = UserCoreUtil.addDomainToName(roleName, this.getMyDomainName());
        if (userStore.isHybridRole()) {
            if (!this.handleDoPreDeleteRole(roleName, false)) {
                return;
            }
            try {
                if (APPLICATION_DOMAIN.equalsIgnoreCase(userStore.getDomainName()) || WORKFLOW_DOMAIN.equalsIgnoreCase(userStore.getDomainName())) {
                    this.hybridRoleManager.deleteHybridRole(roleName);
                } else {
                    this.hybridRoleManager.deleteHybridRole(userStore.getDomainFreeName());
                }
            }
            catch (UserStoreException ex) {
                this.handleDeleteRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETE_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETE_ROLE.getMessage(), ex.getMessage()), roleName);
                throw ex;
            }
            this.handleDoPostDeleteRole(roleName, false);
            this.clearUserRolesCacheByTenant(this.tenantId);
            return;
        }
        if (!this.doCheckExistingRole(roleName)) {
            this.handleDeleteRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_DELETE_NON_EXISTING_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_DELETE_NON_EXISTING_ROLE.getMessage(), roleName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_DELETE_NON_EXISTING_ROLE.toString());
        }
        if (!this.handleDoPreDeleteRole(roleName, false)) {
            return;
        }
        if (this.isReadOnly()) {
            this.handleDeleteRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), roleName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        if (!this.writeGroupsEnabled) {
            this.handleDeleteRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_WRITE_GROUPS_NOT_ENABLED.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_WRITE_GROUPS_NOT_ENABLED.getMessage(), roleName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_WRITE_GROUPS_NOT_ENABLED.toString());
        }
        try {
            this.doDeleteRole(roleName);
        }
        catch (UserStoreException ex) {
            this.handleDeleteRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETE_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETE_ROLE.getMessage(), ex.getMessage()), roleName);
            throw ex;
        }
        this.userRealm.getAuthorizationManager().clearRoleAuthorization(roleWithDomain);
        this.clearUserRolesCacheByTenant(this.tenantId);
        this.handleDoPostDeleteRole(roleName, false);
    }

    @Override
    public Date getPasswordExpirationTime(String userName) throws UserStoreException {
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return userStore.getUserStoreManager().getPasswordExpirationTime(userStore.getDomainFreeName());
        }
        if (this.isUniqueUserIdEnabledInUserStore(userStore)) {
            String userIDFromUserName = this.getUserIDFromUserName(userName);
            if (userIDFromUserName == null) {
                throw new UserStoreException("No UserId found for user:" + userName);
            }
            return this.doGetPasswordExpirationTimeWithID(this.getUserIDFromUserName(userName));
        }
        return this.doGetPasswordExpirationTime(userName);
    }

    protected Date doGetPasswordExpirationTime(String userName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doGetPasswordExpirationTime operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doGetPasswordExpirationTime operation is not implemented in: " + this.getClass());
    }

    protected Date doGetPasswordExpirationTimeWithID(String userName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doGetPasswordExpirationTimeWithId operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doGetPasswordExpirationTimeWithId operation is not implemented in: " + this.getClass());
    }

    private UserStore getUserStore(String user) throws UserStoreException {
        try {
            return AccessController.doPrivileged(() -> this.getUserStoreInternal(user));
        }
        catch (PrivilegedActionException e) {
            throw (UserStoreException)((Object)e.getException());
        }
    }

    protected UserStore getUserStoreWithID(String userID) throws UserStoreException {
        try {
            return AccessController.doPrivileged(() -> this.getUserStoreInternalWithId(userID));
        }
        catch (PrivilegedActionException e) {
            throw (UserStoreException)((Object)e.getException());
        }
    }

    private UserStore getUserStoreOfRoles(String role) throws UserStoreException {
        return this.getUserStore(role);
    }

    private UserStore getUserStoreInternal(String user) throws UserStoreException {
        UserStore userStore = new UserStore();
        if (user == null) {
            userStore.setUserStoreManager(this);
            userStore.setRecurssive(false);
            userStore.setDomainName(this.getMyDomainName());
            return userStore;
        }
        int index = user.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        String domainFreeName = null;
        if (index > 0) {
            String domain = user.substring(0, index);
            UserStoreManager secManager = this.getSecondaryUserStoreManager(domain);
            if (secManager == null) {
                secManager = this.getSecondaryUserStore(domain);
            }
            domainFreeName = user.substring(index + 1);
            if (secManager != null) {
                userStore.setUserStoreManager(secManager);
                userStore.setDomainAwareName(user);
                userStore.setDomainFreeName(domainFreeName);
                userStore.setDomainName(domain);
                userStore.setRecurssive(true);
                return userStore;
            }
            if (!domain.equalsIgnoreCase(this.getMyDomainName())) {
                if ("Internal".equalsIgnoreCase(domain) || APPLICATION_DOMAIN.equalsIgnoreCase(domain) || WORKFLOW_DOMAIN.equalsIgnoreCase(domain)) {
                    userStore.setHybridRole(true);
                } else if ("SYSTEM".equalsIgnoreCase(domain)) {
                    userStore.setSystemStore(true);
                } else {
                    throw new UserStoreException("Invalid Domain Name");
                }
            }
            userStore.setDomainAwareName(user);
            userStore.setDomainFreeName(domainFreeName);
            userStore.setDomainName(domain);
            userStore.setRecurssive(false);
            userStore.setUserStoreManager(this);
            return userStore;
        }
        String domain = this.getMyDomainName();
        userStore.setUserStoreManager(this);
        if (index > 0) {
            userStore.setDomainAwareName(user);
            userStore.setDomainFreeName(domainFreeName);
        } else {
            userStore.setDomainAwareName(domain + CarbonConstants.DOMAIN_SEPARATOR + user);
            userStore.setDomainFreeName(user);
        }
        userStore.setRecurssive(false);
        userStore.setDomainName(domain);
        return userStore;
    }

    private UserStore getUserStoreInternalWithId(String userId) throws UserStoreException {
        UserStore userStore = new UserStore();
        if (userId == null) {
            userStore.setUserStoreManager(this);
            userStore.setRecurssive(false);
            userStore.setDomainName(this.getMyDomainName());
            return userStore;
        }
        String domainName = this.userUniqueIDDomainResolver.getDomainForUserId(userId, this.tenantId);
        if (domainName == null) {
            for (Map.Entry<String, UserStoreManager> entry : this.userStoreManagerHolder.entrySet()) {
                if (!(entry.getValue() instanceof AbstractUserStoreManager)) continue;
                AbstractUserStoreManager abstractUserStoreManager = (AbstractUserStoreManager)entry.getValue();
                if (abstractUserStoreManager.isUniqueUserIdEnabled()) {
                    if (!this.isUserExistsWithGivenDomain(userId, abstractUserStoreManager, entry.getKey()).booleanValue()) continue;
                    domainName = entry.getKey();
                    this.userUniqueIDDomainResolver.setDomainForUserId(userId, domainName, this.tenantId);
                    break;
                }
                try {
                    if (abstractUserStoreManager.getUserListFromProperties(this.claimManager.getAttributeName(entry.getKey(), "http://wso2.org/claims/userid"), userId, null).length <= 0) continue;
                    domainName = entry.getKey();
                    this.userUniqueIDDomainResolver.setDomainForUserId(userId, domainName, this.tenantId);
                    break;
                }
                catch (org.wso2.carbon.user.api.UserStoreException e) {
                    this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getMessage(), e.getMessage()), "http://wso2.org/claims/userid", userId, null);
                    throw new UserStoreException("Unable retrieve users from getUserListFromProperties method from the user store: " + entry.getKey() + ".", e);
                }
            }
        }
        if (domainName == null || domainName.equals(this.getMyDomainName())) {
            String domain = this.getMyDomainName();
            userStore.setUserStoreManager(this);
            userStore.setDomainAwareUserId(UserCoreUtil.addDomainToName(userId, domainName));
            userStore.setDomainFreeUserId(userId);
            userStore.setRecurssive(false);
            userStore.setDomainName(domain);
            return userStore;
        }
        UserStoreManager secManager = this.getSecondaryUserStoreManager(domainName);
        if (secManager == null) {
            secManager = this.getSecondaryUserStore(domainName);
        }
        if (secManager != null) {
            userStore.setUserStoreManager(secManager);
            userStore.setDomainAwareUserId(UserCoreUtil.addDomainToName(userId, domainName));
            userStore.setDomainFreeUserId(userId);
            userStore.setDomainName(domainName);
            userStore.setRecurssive(true);
            return userStore;
        }
        if (!domainName.equalsIgnoreCase(this.getMyDomainName())) {
            if ("Internal".equalsIgnoreCase(domainName) || APPLICATION_DOMAIN.equalsIgnoreCase(domainName) || WORKFLOW_DOMAIN.equalsIgnoreCase(domainName)) {
                userStore.setHybridRole(true);
            } else if ("SYSTEM".equalsIgnoreCase(domainName)) {
                userStore.setSystemStore(true);
            } else {
                throw new UserStoreException("Invalid Domain Name");
            }
        }
        userStore.setDomainAwareUserId(UserCoreUtil.addDomainToName(userId, domainName));
        userStore.setDomainFreeUserId(userId);
        userStore.setDomainName(domainName);
        userStore.setRecurssive(false);
        userStore.setUserStoreManager(this);
        return userStore;
    }

    private Boolean isUserExistsWithGivenDomain(String userId, AbstractUserStoreManager abstractUserStoreManager, String domainName) throws UserStoreException {
        String userName = this.getFromUserNameCache(userId);
        if (StringUtils.isNotEmpty((String)userName)) {
            return StringUtils.equals((String)UserCoreUtil.extractDomainFromName(userName), (String)domainName);
        }
        return abstractUserStoreManager.doGetUserNameFromUserIDWithID(userId) != null;
    }

    @Override
    public final UserStoreManager getSecondaryUserStoreManager() {
        return this.secondaryUserStoreManager;
    }

    @Override
    public final void setSecondaryUserStoreManager(UserStoreManager secondaryUserStoreManager) {
        this.secondaryUserStoreManager = secondaryUserStoreManager;
    }

    @Override
    public final UserStoreManager getSecondaryUserStoreManager(String userDomain) {
        if (userDomain == null) {
            return null;
        }
        return this.userStoreManagerHolder.get(userDomain.toUpperCase());
    }

    private UserStoreManager getSecondaryUserStore(String userDomain) throws UserStoreException {
        try {
            RealmService realmService = UserStoreMgtDSComponent.getRealmService();
            if (realmService == null) {
                return null;
            }
            org.wso2.carbon.user.api.UserStoreManager userStoreManager = realmService.getTenantUserRealm(this.tenantId).getUserStoreManager();
            return ((AbstractUserStoreManager)userStoreManager).getSecondaryUserStoreManager(userDomain);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    @Override
    public final void addSecondaryUserStoreManager(String userDomain, UserStoreManager userStoreManager) {
        if (userDomain != null) {
            this.userStoreManagerHolder.put(userDomain.toUpperCase(), userStoreManager);
        }
    }

    public final void clearAllSecondaryUserStores() {
        this.userStoreManagerHolder.clear();
        if (this.getMyDomainName() != null) {
            this.userStoreManagerHolder.put(this.getMyDomainName().toUpperCase(), this);
        }
    }

    @Override
    public final String[] getAllSecondaryRoles() throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{};
            Object object = this.callSecure("getAllSecondaryRoles", new Object[0], argTypes);
            return (String[])object;
        }
        ArrayList roleList = new ArrayList();
        for (UserStoreManager secondary = this.getSecondaryUserStoreManager(); secondary != null; secondary = secondary.getSecondaryUserStoreManager()) {
            String[] roles = secondary.getRoleNames(true);
            if (roles == null || roles.length <= 0) continue;
            Collections.addAll(roleList, roles);
        }
        return roleList.toArray(new String[roleList.size()]);
    }

    public boolean isSCIMEnabled() {
        return true;
    }

    @Override
    public final String[] getHybridRoles() throws UserStoreException {
        return this.hybridRoleManager.getHybridRoles(QUERY_FILTER_STRING_ANY);
    }

    @Override
    public final String[] getRoleNames() throws UserStoreException {
        return this.getRoleNames(false);
    }

    @Override
    public final String[] getRoleNames(boolean noHybridRoles) throws UserStoreException {
        return this.getRoleNames(QUERY_FILTER_STRING_ANY, -1, noHybridRoles, true, true);
    }

    protected void doAddInternalRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions) throws UserStoreException {
        String domainModeratedRoleName = this.removeDomainIfNotApplicationRole(roleName);
        if (this.hybridRoleManager.isExistingRole(domainModeratedRoleName)) {
            this.handleRoleAlreadyExistException(domainModeratedRoleName, userList, permissions);
        }
        this.createHybridRole(domainModeratedRoleName, userList, permissions);
        if (permissions != null) {
            for (org.wso2.carbon.user.api.Permission permission : permissions) {
                String resourceId = permission.getResourceId();
                String action = permission.getAction();
                this.userRealm.getAuthorizationManager().authorizeRole(UserCoreUtil.addInternalDomainName(roleName), resourceId, action);
            }
        }
        if (userList != null && userList.length > 0) {
            this.clearUserRolesCacheByTenant(this.tenantId);
        }
    }

    private void handleRoleAlreadyExistException(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions) throws UserStoreException {
        String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ROLE_ALREADY_EXISTS.getCode();
        String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ROLE_ALREADY_EXISTS.getMessage(), roleName);
        this.handleAddRoleFailure(errorCode, errorMessage, roleName, userList, permissions);
        throw new UserStoreException(errorCode + " - " + errorMessage, errorCode, null);
    }

    private void handleRoleAlreadyExistExceptionWithID(String roleName, String[] userIDList, org.wso2.carbon.user.api.Permission[] permissions) throws UserStoreException {
        String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ROLE_ALREADY_EXISTS.getCode();
        String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ROLE_ALREADY_EXISTS.getMessage(), roleName);
        this.handleAddRoleFailureWithID(errorCode, errorMessage, roleName, userIDList, permissions);
        throw new UserStoreException(errorCode + " - " + errorMessage);
    }

    protected abstract String[] doGetSharedRoleNames(String var1, String var2, int var3) throws UserStoreException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String[] getRoleNames(String filter, int maxItemLimit, boolean noInternalRoles, boolean noSystemRole, boolean noSharedRoles) throws UserStoreException {
        String[] externalRoles;
        int index;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE};
            Object object = this.callSecure("getRoleNames", new Object[]{filter, maxItemLimit, noInternalRoles, noSystemRole, noSharedRoles}, argTypes);
            return (String[])object;
        }
        String[] roleList = new String[]{};
        if (!noInternalRoles && filter.toLowerCase().startsWith(APPLICATION_DOMAIN.toLowerCase())) {
            roleList = this.hybridRoleManager.getHybridRoles(filter);
        } else if (!(noInternalRoles || this.isAnInternalRole(filter) || filter.contains(UserCoreConstants.DOMAIN_SEPARATOR))) {
            if (filter == QUERY_FILTER_STRING_ANY) {
                roleList = this.hybridRoleManager.getHybridRoles(filter);
            } else {
                String[] applicationDomainRoleArray = this.hybridRoleManager.getHybridRoles(APPLICATION_DOMAIN + UserCoreConstants.DOMAIN_SEPARATOR + filter);
                String[] internalDomainRoleArray = this.hybridRoleManager.getHybridRoles(filter);
                ArrayList<String> internalOnlyList = new ArrayList<String>();
                for (String filteredRole : internalDomainRoleArray) {
                    if (filteredRole == null || filteredRole.matches("Application/(.*)")) continue;
                    internalOnlyList.add(filteredRole);
                }
                roleList = UserCoreUtil.combineArrays(applicationDomainRoleArray, internalOnlyList.toArray(new String[internalOnlyList.size()]));
            }
        } else if (!noInternalRoles) {
            roleList = this.hybridRoleManager.getHybridRoles(UserCoreUtil.removeDomainFromName(filter));
        }
        if (!noSystemRole) {
            String[] systemRoles = this.systemUserRoleManager.getSystemRoles();
            roleList = UserCoreUtil.combineArrays(roleList, systemRoles);
        }
        if ((index = filter.indexOf(CarbonConstants.DOMAIN_SEPARATOR)) > 0) {
            String[] externalRoles2;
            String domain = filter.substring(0, index);
            UserStoreManager secManager = this.getSecondaryUserStoreManager(domain);
            if ("Internal".equalsIgnoreCase(domain) || APPLICATION_DOMAIN.equalsIgnoreCase(domain) || WORKFLOW_DOMAIN.equalsIgnoreCase(domain)) {
                return roleList;
            }
            if (secManager == null) {
                throw new UserStoreClientException("Invalid Domain Name.");
            }
            filter = filter.substring(index + 1);
            if (!(secManager instanceof AbstractUserStoreManager)) {
                externalRoles2 = secManager.getRoleNames();
                return UserCoreUtil.combineArrays(roleList, externalRoles2);
            }
            if (this.readGroupsEnabled) {
                externalRoles2 = ((AbstractUserStoreManager)secManager).doGetRoleNames(filter, maxItemLimit);
                return UserCoreUtil.combineArrays(roleList, externalRoles2);
            }
        } else if (index == 0 && this.readGroupsEnabled) {
            externalRoles = this.doGetRoleNames(filter.substring(index + 1), maxItemLimit);
            return UserCoreUtil.combineArrays(roleList, externalRoles);
        }
        if (this.readGroupsEnabled) {
            externalRoles = this.doGetRoleNames(filter, maxItemLimit);
            roleList = UserCoreUtil.combineArrays(externalRoles, roleList);
        }
        String primaryDomain = this.getMyDomainName();
        if (this.getSecondaryUserStoreManager() != null) {
            for (Map.Entry<String, UserStoreManager> entry : this.userStoreManagerHolder.entrySet()) {
                if (entry.getKey().equalsIgnoreCase(primaryDomain)) continue;
                UserStoreManager storeManager = entry.getValue();
                if (storeManager instanceof AbstractUserStoreManager) {
                    try {
                        if (!this.readGroupsEnabled) continue;
                        String[] secondRoleList = ((AbstractUserStoreManager)storeManager).doGetRoleNames(filter, maxItemLimit);
                        roleList = UserCoreUtil.combineArrays(roleList, secondRoleList);
                    }
                    catch (UserStoreException e) {
                        log.error((Object)e);
                    }
                    continue;
                }
                roleList = UserCoreUtil.combineArrays(roleList, storeManager.getRoleNames());
            }
        }
        return roleList;
    }

    private Map<String, String> doGetUserClaimValues(String userName, String[] claims, String domainName, String profileName) throws UserStoreException {
        boolean requireRoles = false;
        boolean requireIntRoles = false;
        boolean requireExtRoles = false;
        String roleClaim = null;
        if (profileName == null || profileName.trim().length() == 0) {
            profileName = "default";
        }
        HashSet<String> propertySet = new HashSet<String>();
        for (String claim : claims) {
            String property = null;
            try {
                property = this.getClaimAtrribute(claim, userName, domainName);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            if (!(property == null || "http://wso2.org/claims/role".equalsIgnoreCase(claim) && "http://wso2.org/claims/role/internal".equalsIgnoreCase(claim) && "http://wso2.org/claims/role/external".equalsIgnoreCase(claim))) {
                propertySet.add(property);
            }
            if ("http://wso2.org/claims/role".equalsIgnoreCase(claim)) {
                requireRoles = true;
                roleClaim = claim;
                continue;
            }
            if ("http://wso2.org/claims/role/internal".equalsIgnoreCase(claim)) {
                requireIntRoles = true;
                roleClaim = claim;
                continue;
            }
            if (!"http://wso2.org/claims/role/external".equalsIgnoreCase(claim)) continue;
            requireExtRoles = true;
            roleClaim = claim;
        }
        String[] properties = propertySet.toArray(new String[propertySet.size()]);
        Map<String, String> userPropertyValues = this.getUserPropertyValues(userName, properties, profileName);
        this.processAttributesAfterRetrieval(userName, userPropertyValues, profileName);
        ArrayList getAgain = new ArrayList();
        HashMap<String, String> finalValues = new HashMap<String, String>();
        boolean isOverrideUsernameClaimEnabled = false;
        if (!this.isUniqueUserIdEnabled()) {
            isOverrideUsernameClaimEnabled = Boolean.parseBoolean(this.realmConfig.getIsOverrideUsernameClaimFromInternalUsername());
        }
        for (String claim : claims) {
            ClaimMapping mapping;
            try {
                mapping = (ClaimMapping)this.claimManager.getClaimMapping(claim);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            String property = null;
            String value = null;
            if (mapping != null) {
                if (domainName != null) {
                    Map attrMap = mapping.getMappedAttributes();
                    if (attrMap != null) {
                        String attr = null;
                        attr = (String)attrMap.get(domainName.toUpperCase());
                        property = attr != null ? attr : mapping.getMappedAttribute();
                    }
                } else {
                    property = mapping.getMappedAttribute();
                }
                value = userPropertyValues.get(property);
                if (isOverrideUsernameClaimEnabled && USERNAME_CLAIM_URI.equals(mapping.getClaim().getClaimUri())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The username claim value is overridden by the username :" + userName));
                    }
                    value = userName;
                }
                if (value == null || value.trim().length() <= 0) continue;
                finalValues.put(claim, value);
                continue;
            }
            if (property == null && claim.equals(DISAPLAY_NAME_CLAIM)) {
                property = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
            }
            if ((value = userPropertyValues.get(property)) == null || value.trim().length() <= 0) continue;
            finalValues.put(claim, value);
        }
        if (getAgain.size() > 0) {
            Map<String, String> mapClaimValues = this.getUserClaimValues(userName, getAgain.toArray(new String[getAgain.size()]), profileName);
            for (Map.Entry<String, String> entry : mapClaimValues.entrySet()) {
                if (entry.getValue() == null) continue;
                finalValues.put(entry.getKey(), entry.getValue());
            }
        }
        String[] roles = null;
        if (requireRoles) {
            roles = this.getRoleListOfUser(userName);
        } else if (requireIntRoles) {
            roles = this.doGetInternalRoleListOfUser(userName, QUERY_FILTER_STRING_ANY);
        } else if (requireExtRoles) {
            String[] sharedRoles;
            ArrayList<String> rolesList = new ArrayList<String>();
            String[] externalRoles = this.doGetExternalRoleListOfUser(userName, QUERY_FILTER_STRING_ANY);
            rolesList.addAll(Arrays.asList(externalRoles));
            if (this.isSharedGroupEnabled() && (sharedRoles = this.doGetSharedRoleListOfUser(userName, null, QUERY_FILTER_STRING_ANY)) != null) {
                rolesList.addAll(Arrays.asList(sharedRoles));
            }
            roles = rolesList.toArray(new String[rolesList.size()]);
        }
        if (roles != null && roles.length > 0) {
            String userAttributeSeparator = ",";
            String claimSeparator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
            if (claimSeparator != null && !claimSeparator.trim().isEmpty()) {
                userAttributeSeparator = claimSeparator;
            }
            String delim = "";
            StringBuffer roleBf = new StringBuffer();
            for (String role : roles) {
                roleBf.append(delim).append(role);
                delim = userAttributeSeparator;
            }
            finalValues.put(roleClaim, roleBf.toString());
        }
        return finalValues;
    }

    protected void processAttributesAfterRetrieval(String userName, Map<String, String> userAttributes, String profileName) {
    }

    protected void processAttributesBeforeUpdate(String userName, Map<String, ? extends Object> userAttributes, String profileName) {
    }

    protected void processAttributesAfterRetrievalWithID(String userID, Map<String, String> userAttributes, String profileName) {
    }

    protected void processAttributesBeforeUpdateWithID(String userID, Map<String, ? extends Object> userAttributes, String profileName) {
    }

    protected String getEveryOneRoleName() {
        return this.realmConfig.getEveryOneRoleName();
    }

    protected String getAdminRoleName() {
        return this.realmConfig.getAdminRoleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkUserPasswordValid(Object credential) throws UserStoreException {
        Secret credentialObj;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{Object.class};
            Object object = this.callSecure("checkUserPasswordValid", new Object[]{credential}, argTypes);
            return (Boolean)object;
        }
        if (credential == null) {
            return false;
        }
        try {
            credentialObj = Secret.getSecret((Object)credential);
        }
        catch (UnsupportedSecretTypeException e) {
            throw new UserStoreException("Unsupported credential type", e);
        }
        try {
            if (credentialObj.getChars().length < 1) {
                boolean e = false;
                return e;
            }
            String regularExpression = this.realmConfig.getUserStoreProperty("PasswordJavaRegEx");
            if (regularExpression != null) {
                if (this.isFormatCorrect(regularExpression, credentialObj.getChars())) {
                    boolean bl = true;
                    return bl;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Submitted password does not match with the regex " + regularExpression));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            credentialObj.clear();
        }
    }

    protected boolean isValidCredentials(Object credential) throws UserStoreException {
        Secret credentialObj;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{Object.class};
            Object object = this.callSecure("isValidCredentials", new Object[]{credential}, argTypes);
            return (Boolean)object;
        }
        if (credential == null) {
            return false;
        }
        try {
            credentialObj = Secret.getSecret((Object)credential);
        }
        catch (UnsupportedSecretTypeException e) {
            throw new UserStoreException("Unsupported credential type", e);
        }
        return credentialObj.getChars().length >= 1;
    }

    protected boolean checkUserNameValid(String userName) throws UserStoreException {
        if (this.isValidUserName(userName)) {
            String regularExpression = this.realmConfig.getUserStoreProperty("UsernameJavaRegEx");
            if (StringUtils.isEmpty((String)regularExpression) || StringUtils.isEmpty((String)regularExpression.trim())) {
                regularExpression = this.realmConfig.getUserStoreProperty("UserNameJavaRegEx");
            }
            if (MultitenantUtils.isEmailUserName()) {
                regularExpression = this.realmConfig.getUserStoreProperty("UsernameWithEmailJavaScriptRegEx");
                if (StringUtils.isEmpty((String)regularExpression) || StringUtils.isEmpty((String)regularExpression.trim())) {
                    regularExpression = this.realmConfig.getUserStoreProperty("UsernameJavaRegEx");
                }
                if (StringUtils.isEmpty((String)regularExpression) || StringUtils.isEmpty((String)regularExpression.trim())) {
                    regularExpression = this.realmConfig.getUserStoreProperty("UserNameJavaRegEx");
                }
                if (StringUtils.isEmpty((String)regularExpression) || StringUtils.isEmpty((String)regularExpression.trim())) {
                    regularExpression = "^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$";
                }
            }
            if (regularExpression != null) {
                regularExpression = regularExpression.trim();
            }
            if (StringUtils.isNotEmpty((String)regularExpression)) {
                if (this.isFormatCorrect(regularExpression, userName)) {
                    return true;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Username " + userName + " does not match with the regex " + regularExpression));
                }
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isValidUserName(String userName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            Object object = this.callSecure("isValidUserName", new Object[]{userName}, argTypes);
            return (Boolean)object;
        }
        if (userName == null || "wso2.system.user".equals(userName)) {
            return false;
        }
        String leadingOrTrailingSpaceAllowedInUserName = this.realmConfig.getUserStoreProperty("LeadingOrTrailingSpaceAllowedInUserName");
        if (StringUtils.isEmpty((String)leadingOrTrailingSpaceAllowedInUserName)) {
            userName = userName.trim();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("'LeadingOrTrailingSpaceAllowedInUserName' property is set to : " + leadingOrTrailingSpaceAllowedInUserName + ". Hence username trimming will be skipped during validation for the username: " + userName));
        }
        return !userName.isEmpty();
    }

    protected boolean isRoleNameValid(String roleName) {
        if (roleName == null) {
            return false;
        }
        if (roleName.length() < 1) {
            return false;
        }
        String regularExpression = this.realmConfig.getUserStoreProperty("RolenameJavaRegEx");
        return regularExpression == null || this.isFormatCorrect(regularExpression, roleName);
    }

    protected String[] getRoleListOfUserFromCache(int tenantID, String userName) {
        if (this.userRolesCache != null) {
            String usernameWithDomain = UserCoreUtil.addDomainToName(userName, this.getMyDomainName());
            return this.userRolesCache.getRolesListOfUser(this.cacheIdentifier, tenantID, usernameWithDomain);
        }
        return null;
    }

    protected void clearUserRolesCacheByTenant(int tenantID) {
        if (this.userRolesCache != null) {
            this.userRolesCache.clearCacheByTenant(tenantID);
        }
        AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
        authorizationCache.clearCacheByTenant(tenantID);
    }

    protected void addToUserRolesCache(int tenantID, String userName, String[] roleList) {
        if (this.userRolesCache != null) {
            String usernameWithDomain = UserCoreUtil.addDomainToName(userName, this.getMyDomainName());
            String[] rolesWithDomain = UserCoreUtil.addDomainToNames(roleList, this.getMyDomainName());
            this.userRolesCache.addToCache(this.cacheIdentifier, tenantID, usernameWithDomain, rolesWithDomain);
            AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
            authorizationCache.clearCacheByTenant(tenantID);
        }
    }

    protected void clearUserRolesCache(String userIdentifier) {
        String usernameWithDomain = UserCoreUtil.addDomainToName(userIdentifier, this.getMyDomainName());
        if (this.userRolesCache != null) {
            this.userRolesCache.clearCacheEntry(this.cacheIdentifier, this.tenantId, usernameWithDomain);
        }
        AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
        authorizationCache.clearCacheByUser(this.tenantId, usernameWithDomain);
    }

    protected void initUserRolesCache() {
        String userRolesCacheEnabledString = this.realmConfig.getUserStoreProperty("UserRolesCacheEnabled");
        String userCoreCacheIdentifier = this.realmConfig.getUserStoreProperty("UserCoreCacheIdentifier");
        this.cacheIdentifier = userCoreCacheIdentifier != null && userCoreCacheIdentifier.trim().length() > 0 ? userCoreCacheIdentifier : "defaultCacheDomain";
        if (userRolesCacheEnabledString != null && !userRolesCacheEnabledString.equals("")) {
            this.userRolesCacheEnabled = Boolean.parseBoolean(userRolesCacheEnabledString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User Roles Cache is configured to:" + userRolesCacheEnabledString));
            }
        } else if (log.isDebugEnabled()) {
            log.info((Object)("User Roles Cache is not configured. Default value: " + this.userRolesCacheEnabled + " is taken."));
        }
        if (this.userRolesCacheEnabled) {
            int timeOut = 5;
            String timeOutString = this.realmConfig.getUserStoreProperty("UserCoreCacheTimeOut");
            if (timeOutString != null) {
                timeOut = Integer.parseInt(timeOutString);
            }
            this.userRolesCache = UserRolesCache.getInstance();
            this.userRolesCache.setTimeOut(timeOut);
        }
    }

    private boolean isFormatCorrect(String regularExpression, String attribute) {
        Pattern p2 = Pattern.compile(regularExpression);
        Matcher m2 = p2.matcher(attribute);
        return m2.matches();
    }

    private boolean isFormatCorrect(String regularExpression, char[] attribute) {
        CharBuffer charBuffer = CharBuffer.wrap(attribute);
        Pattern p2 = Pattern.compile(regularExpression);
        Matcher m2 = p2.matcher(charBuffer);
        boolean matches = m2.matches();
        return matches;
    }

    protected String replaceEscapeCharacters(String userName) {
        String replaceEscapeCharactersAtUserLoginString;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Replacing escape characters in " + userName));
        }
        if ((replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin")) != null) {
            this.replaceEscapeCharactersAtUserLogin = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replace escape characters at userlogin is configured to: " + replaceEscapeCharactersAtUserLoginString));
            }
            if (this.replaceEscapeCharactersAtUserLogin) {
                return userName.replaceAll("\\\\", "\\\\\\\\");
            }
        }
        return userName;
    }

    public RoleDTO[] getAllSecondaryRoleDTOs() throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{};
            Object object = this.callSecure("getAllSecondaryRoleDTOs", new Object[0], argTypes);
            return (RoleDTO[])object;
        }
        ArrayList roleList = new ArrayList();
        for (UserStoreManager secondary = this.getSecondaryUserStoreManager(); secondary != null; secondary = secondary.getSecondaryUserStoreManager()) {
            String domain = secondary.getRealmConfiguration().getUserStoreProperty("DomainName");
            String[] roles = secondary.getRoleNames(true);
            if (roles == null || roles.length <= 0) continue;
            Collections.addAll(roleList, UserCoreUtil.convertRoleNamesToRoleDTO(roles, domain));
        }
        return roleList.toArray(new RoleDTO[roleList.size()]);
    }

    public void addSystemRole(String roleName, String[] userList, Permission[] permissions) throws UserStoreException {
        if (!this.isRoleNameValid(roleName)) {
            String regEx = this.realmConfig.getUserStoreProperty("RolenameJavaRegEx");
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_ROLE_NAME.getCode();
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_ROLE_NAME.getMessage(), roleName, regEx);
            this.handleAddRoleFailure(errorCode, errorMessage, roleName, userList, permissions);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        this.createSystemRole(roleName, userList, permissions);
    }

    protected abstract String[] doGetUserListOfRole(String var1, String var2) throws UserStoreException;

    protected String[] doGetUserListOfRole(String roleName, String filter, int maxItemLimit) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using the default implementation of retrieving users in the role: " + roleName + " only with the filter: " + filter + ". The provided value: " + maxItemLimit + " for the maximum limit of returning users is ignored"));
        }
        return this.doGetUserListOfRole(roleName, filter);
    }

    protected List<User> doGetUserListOfRoleWithID(String roleName, String filter) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doGetUserListOfRoleWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doGetUserListOfRoleWithID operation is not implemented in: " + this.getClass());
    }

    protected List<User> doGetUserListOfRoleWithID(String roleName, String filter, int maxItemLimit) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using the default implementation of retrieving users in the role: " + roleName + " only with the filter: " + filter + ". The provided value: " + maxItemLimit + " for the maximum limit of returning users is ignored"));
        }
        return this.doGetUserListOfRoleWithID(roleName, filter);
    }

    public List<String> doGetRoleListOfUserWithID(String userID, String filter) throws UserStoreException {
        List<String> roleList;
        String[] roleListOfUserFromCache;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("doGetRoleListOfUserWithID", new Object[]{userID, filter}, argTypes);
            return (List)object;
        }
        String username = this.getUserNameFromUserID(userID);
        if (username != null && (roleListOfUserFromCache = this.getRoleListOfUserFromCache(this.tenantId, username)) != null && !(roleList = Arrays.asList(roleListOfUserFromCache)).isEmpty()) {
            return roleList;
        }
        return this.getUserRolesWithID(userID, filter);
    }

    private List<String> getUserRolesWithID(String userID, String filter) throws UserStoreException {
        UserOperationEventListener userOperationEventListener;
        Object externalRoles;
        List<String> internalRoles = this.doGetInternalRoleListOfUserWithID(userID, filter);
        HashSet<String> modifiedInternalRoles = new HashSet<String>();
        String[] modifiedExternalRoleList = new String[]{};
        if (this.readGroupsEnabled && this.doCheckExistingUserWithID(userID)) {
            String[] sharedRoles;
            ArrayList<String> roles = new ArrayList<String>();
            externalRoles = this.doGetExternalRoleListOfUserWithID(userID, QUERY_FILTER_STRING_ANY);
            roles.addAll(Arrays.asList(externalRoles));
            if (this.isSharedGroupEnabled() && (sharedRoles = this.doGetSharedRoleListOfUserWithID(userID, null, QUERY_FILTER_STRING_ANY)) != null) {
                roles.addAll(Arrays.asList(sharedRoles));
            }
            modifiedExternalRoleList = UserCoreUtil.addDomainToNames(roles.toArray(new String[0]), this.getMyDomainName());
            if (this.isRoleAndGroupSeparationEnabled()) {
                Set<String> rolesOfGroups = this.getUniqueSet(this.getHybridRoleListOfGroups(roles, this.getMyDomainName()));
                modifiedInternalRoles.addAll(rolesOfGroups);
            }
        }
        modifiedInternalRoles.addAll(internalRoles);
        String[] roleList = UserCoreUtil.combine(modifiedExternalRoleList, new ArrayList<String>(modifiedInternalRoles));
        externalRoles = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
        while (externalRoles.hasNext() && (!((userOperationEventListener = (UserOperationEventListener)externalRoles.next()) instanceof AbstractUserOperationEventListener) || ((AbstractUserOperationEventListener)userOperationEventListener).doPostGetRoleListOfUserWithID(userID, filter, roleList, this))) {
        }
        String username = this.getUserNameFromUserID(userID);
        if (username != null) {
            this.addToUserRolesCache(this.tenantId, username, roleList);
        }
        return Arrays.asList(roleList);
    }

    public final String[] doGetRoleListOfUser(String userName, String filter) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("doGetRoleListOfUser", new Object[]{userName, filter}, argTypes);
            return (String[])object;
        }
        String[] roleList = this.getRoleListOfUserFromCache(this.tenantId, userName);
        if (roleList != null && roleList.length > 0) {
            return roleList;
        }
        return this.getUserRoles(userName, filter);
    }

    private String[] getUserRoles(String username, String filter) throws UserStoreException {
        String[] internalRoles = this.doGetInternalRoleListOfUser(username, filter);
        String[] modifiedExternalRoleList = new String[]{};
        if (this.readGroupsEnabled && this.doCheckExistingUser(username)) {
            String[] sharedRoles;
            String[] externalRoles = this.doGetExternalRoleListOfUser(username, QUERY_FILTER_STRING_ANY);
            List<String> roles = Arrays.asList(externalRoles);
            if (this.isSharedGroupEnabled() && (sharedRoles = this.doGetSharedRoleListOfUser(username, null, QUERY_FILTER_STRING_ANY)) != null) {
                roles.addAll(Arrays.asList(sharedRoles));
            }
            modifiedExternalRoleList = UserCoreUtil.addDomainToNames(roles.toArray(new String[0]), this.getMyDomainName());
            if (this.isRoleAndGroupSeparationEnabled()) {
                Set<String> rolesOfGroups = this.getUniqueSet(this.getHybridRoleListOfGroups(roles, this.getMyDomainName()));
                internalRoles = UserCoreUtil.combine(internalRoles, new ArrayList<String>(rolesOfGroups));
            }
        }
        String[] roleList = UserCoreUtil.combine(internalRoles, Arrays.asList(modifiedExternalRoleList));
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener instanceof AbstractUserOperationEventListener && !((AbstractUserOperationEventListener)userOperationEventListener).doPostGetRoleListOfUser(username, filter, roleList, this)) break;
        }
        this.addToUserRolesCache(this.tenantId, username, roleList);
        return roleList;
    }

    public final String[] getRoleListOfUserFromDatabase(String username, String filter) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("getRoleListOfUserFromDatabase", new Object[]{username, filter}, argTypes);
            return (String[])object;
        }
        if (this.isUniqueUserIdEnabledInUserStore(this.getUserStore(username))) {
            String userID = this.getUserIDFromUserName(username);
            if (userID == null) {
                return new String[]{this.realmConfig.getEveryOneRoleName()};
            }
            return this.getUserRolesWithID(userID, filter).toArray(new String[0]);
        }
        return this.getUserRoles(username, filter);
    }

    public final String[] getHybridRoles(String filter) throws UserStoreException {
        return this.hybridRoleManager.getHybridRoles(filter);
    }

    protected List<String> getMappingAttributeList(List<String> claimList) throws UserStoreException {
        ArrayList<String> attributeList = null;
        Iterator<String> claimIter = null;
        attributeList = new ArrayList<String>();
        if (claimList == null) {
            return attributeList;
        }
        claimIter = claimList.iterator();
        while (claimIter.hasNext()) {
            try {
                attributeList.add(this.claimManager.getAttributeName(this.getMyDomainName(), claimIter.next()));
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
        }
        return attributeList;
    }

    protected void doInitialSetup() throws UserStoreException {
        this.systemUserRoleManager = new SystemUserRoleManager(this.dataSource, this.tenantId);
        this.hybridRoleManager = new HybridRoleManager(this.dataSource, this.tenantId, this.realmConfig, this.userRealm);
        this.userUniqueIDDomainResolver = new UserUniqueIDDomainResolver(this.dataSource);
    }

    protected void doInitialUserAdding() throws UserStoreException {
        String systemUser = UserCoreUtil.removeDomainFromName("wso2.anonymous.user");
        String systemRole = UserCoreUtil.removeDomainFromName("system/wso2.anonymous.role");
        if (!this.systemUserRoleManager.isExistingSystemUser(systemUser)) {
            try {
                this.systemUserRoleManager.addSystemUser(systemUser, UserCoreUtil.getPolicyFriendlyRandomPassword(systemUser), null);
            }
            catch (UserStoreException e) {
                if (UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_A_SYSTEM_USER.getCode().equals(e.getErrorCode())) {
                    log.warn((Object)String.format("System User :%s has already added. Hence, continue without adding the user.", systemUser));
                }
                throw e;
            }
        }
        if (!this.systemUserRoleManager.isExistingRole(systemRole)) {
            try {
                this.systemUserRoleManager.addSystemRole(systemRole, new String[]{systemUser});
            }
            catch (UserStoreException e) {
                if (UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_A_SYSTEM_ROLE.getCode().equals(e.getErrorCode())) {
                    log.warn((Object)String.format("System Role :%s is already added. Hence, continue without adding the role.", systemRole), (Throwable)((Object)e));
                }
                throw e;
            }
        }
        if (!this.hybridRoleManager.isExistingRole(UserCoreUtil.removeDomainFromName(this.realmConfig.getEveryOneRoleName()))) {
            try {
                this.hybridRoleManager.addHybridRole(UserCoreUtil.removeDomainFromName(this.realmConfig.getEveryOneRoleName()), null);
            }
            catch (UserStoreException e) {
                if (UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_A_HYBRID_ROLE.getCode().equals(e.getErrorCode())) {
                    log.warn((Object)String.format("Hybrid Role :%s is already added. Hence, continue without adding the role.", systemRole));
                }
                throw e;
            }
        }
    }

    protected boolean isInitSetupDone() throws UserStoreException {
        boolean isInitialSetUp = false;
        String systemUser = UserCoreUtil.removeDomainFromName("wso2.anonymous.user");
        String systemRole = UserCoreUtil.removeDomainFromName("system/wso2.anonymous.role");
        if (this.systemUserRoleManager.isExistingSystemUser(systemUser)) {
            isInitialSetUp = true;
        }
        if (this.systemUserRoleManager.isExistingRole(systemRole)) {
            isInitialSetUp = true;
        }
        return isInitialSetUp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addInitialAdminData(boolean addAdmin, boolean initialSetup) throws UserStoreException {
        block69: {
            boolean doCheckIsUserInRole;
            String message;
            String adminUserID;
            boolean isInternalRole;
            String adminRoleName;
            String adminUserName;
            block68: {
                String message2;
                User user;
                boolean roleExist;
                block67: {
                    if (this.realmConfig.getAdminRoleName() == null || this.realmConfig.getAdminUserName() == null) {
                        log.error((Object)"Admin user name or role name is not valid. Please provide valid values.");
                        throw new UserStoreException("Admin user name or role name is not valid. Please provide valid values.");
                    }
                    adminUserName = UserCoreUtil.removeDomainFromName(this.realmConfig.getAdminUserName());
                    adminRoleName = UserCoreUtil.removeDomainFromName(this.realmConfig.getAdminRoleName());
                    boolean userExist = false;
                    roleExist = false;
                    isInternalRole = false;
                    adminUserID = null;
                    user = null;
                    try {
                        if (!this.isRoleAndGroupSeparationEnabled() && Boolean.parseBoolean(this.getRealmConfiguration().getUserStoreProperty("ReadGroups"))) {
                            roleExist = this.doCheckExistingRole(adminRoleName);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!roleExist) {
                        try {
                            roleExist = this.hybridRoleManager.isExistingRole(adminRoleName);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (roleExist) {
                            isInternalRole = true;
                        }
                    }
                    try {
                        if (this.isUniqueUserIdEnabled()) {
                            userExist = this.doCheckExistingUserNameWithIDImpl(adminUserName);
                            if (userExist) {
                                String userIDFromUserName = this.getUserIDFromUserName(adminUserName);
                                String userIDAttribute = this.realmConfig.getUserStoreProperty("UserIDAttribute");
                                String userID = this.getUniqueUserID();
                                if (StringUtils.isEmpty((String)userIDFromUserName) && !this.isReadOnly()) {
                                    this.doSetUserAttribute(adminUserName, userIDAttribute, userID, null);
                                }
                            }
                        } else {
                            userExist = this.doCheckExistingUser(adminUserName);
                        }
                    }
                    catch (Exception userIDFromUserName) {
                        // empty catch block
                    }
                    if (!userExist) {
                        if (this.isReadOnly()) {
                            message2 = "Admin user can not be created in primary user store. User store is read only. Please pick a user name which is exist in the primary user store as Admin user";
                            if (initialSetup) {
                                throw new UserStoreException(message2);
                            }
                            if (log.isDebugEnabled()) {
                                log.error((Object)message2);
                            }
                        } else {
                            if (addAdmin) {
                                try {
                                    if (this.isUniqueUserIdEnabled()) {
                                        user = this.doAddUserWithID(adminUserName, this.realmConfig.getAdminPassword(), null, null, null, false);
                                        break block67;
                                    }
                                    HashMap<String, String> claims = new HashMap<String, String>();
                                    claims.put("http://wso2.org/claims/userid", this.getUniqueUserID());
                                    this.doAddUser(adminUserName, this.realmConfig.getAdminPassword(), null, claims, null, false);
                                }
                                catch (Exception e) {
                                    message = "Admin user has not been created. Error occurs while creating Admin user in primary user store.";
                                    if (initialSetup) {
                                        if (!(e instanceof UserStoreException) || !UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_A_USER.getCode().equals(((UserStoreException)((Object)e)).getErrorCode())) throw new UserStoreException(message, e);
                                        log.warn((Object)String.format("Admin User :%s is already added. Hence, continue without adding the user.", adminUserName));
                                    } else if (log.isDebugEnabled()) {
                                        log.error((Object)message, (Throwable)e);
                                    }
                                    break block67;
                                }
                            }
                            if (initialSetup) {
                                message2 = "Admin user can not be created in primary user store. Add-Admin has been set to false. Please pick a User name which is exist in the primary user store as Admin user";
                                if (initialSetup) {
                                    throw new UserStoreException(message2);
                                }
                                if (log.isDebugEnabled()) {
                                    log.error((Object)message2);
                                }
                            }
                        }
                    }
                }
                if (this.isUniqueUserIdEnabled()) {
                    adminUserID = user != null && user.getUserID() != null ? user.getUserID() : this.getUserIDFromUserName(adminUserName);
                }
                if (!roleExist) {
                    if (addAdmin) {
                        if (!this.isRoleAndGroupSeparationEnabled() && !this.isReadOnly() && this.writeGroupsEnabled) {
                            try {
                                if (this.isUniqueUserIdEnabled()) {
                                    this.doAddRoleWithID(adminRoleName, new String[]{adminUserID}, false);
                                    break block68;
                                }
                                this.doAddRole(adminRoleName, new String[]{adminUserName}, false);
                            }
                            catch (org.wso2.carbon.user.api.UserStoreException e) {
                                message = "Admin role has not been created. Error occurs while creating Admin role in primary user store.";
                                if (initialSetup) {
                                    if (!UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_ROLE.getCode().equals(((UserStoreException)e).getErrorCode())) throw new UserStoreException(message, e);
                                    log.warn((Object)String.format("Admin Role :%s is already added. Hence, continue without adding the role.", adminRoleName));
                                } else if (log.isDebugEnabled()) {
                                    log.error((Object)message, (Throwable)e);
                                }
                                break block68;
                            }
                        }
                        try {
                            if (this.isUniqueUserIdEnabled()) {
                                this.hybridRoleManager.addHybridRole(adminRoleName, new String[]{adminUserName});
                            } else {
                                this.hybridRoleManager.addHybridRole(adminRoleName, new String[]{adminUserName});
                            }
                            isInternalRole = true;
                            if (this.isRoleAndGroupSeparationEnabled()) {
                                boolean groupExist = false;
                                if (Boolean.parseBoolean(this.getRealmConfiguration().getUserStoreProperty("ReadGroups"))) {
                                    groupExist = this.doCheckExistingRole(adminRoleName);
                                }
                                if (!groupExist && !this.isReadOnly() && this.writeGroupsEnabled) {
                                    if (this.isUniqueUserIdEnabled()) {
                                        this.doAddRoleWithID(adminRoleName, new String[]{adminUserID}, false);
                                    } else {
                                        this.doAddRole(adminRoleName, new String[]{adminUserName}, false);
                                    }
                                    groupExist = true;
                                }
                                if (groupExist) {
                                    this.updateGroupListOfHybridRole(adminRoleName, null, new String[]{adminRoleName});
                                }
                            }
                            break block68;
                        }
                        catch (Exception e) {
                            message = "Admin role has not been created. Error occurs while creating Admin role in primary user store.";
                            if (initialSetup) {
                                if (!UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_A_HYBRID_ROLE.getCode().equals(((UserStoreException)((Object)e)).getErrorCode())) throw new UserStoreException(message, e);
                                log.warn((Object)String.format("Hybrid Admin Role :%s is already added. Hence, continue without adding the hybrid role.", adminRoleName));
                            } else if (log.isDebugEnabled()) {
                                log.error((Object)message, (Throwable)e);
                            }
                            break block68;
                        }
                    }
                    message2 = "Admin role can not be created in primary user store. Add-Admin has been set to false. Please pick a Role name which is exist in the primary user store as Admin Role";
                    if (initialSetup) {
                        throw new UserStoreException(message2);
                    }
                    if (log.isDebugEnabled()) {
                        log.error((Object)message2);
                    }
                }
            }
            if (isInternalRole) {
                if (this.isUniqueUserIdEnabled()) {
                    this.updateHybridRoleListOfUserInternal(initialSetup, adminRoleName, adminUserName);
                } else {
                    this.updateHybridRoleListOfUserInternal(initialSetup, adminRoleName, adminUserName);
                }
                this.realmConfig.setAdminRoleName(UserCoreUtil.addInternalDomainName(adminRoleName));
            } else if (!this.isReadOnly() && this.writeGroupsEnabled && !(doCheckIsUserInRole = this.isUniqueUserIdEnabled() ? this.doCheckIsUserInRoleWithID(adminUserID, adminRoleName) : this.doCheckIsUserInRole(adminUserName, adminRoleName))) {
                if (addAdmin) {
                    try {
                        if (this.isUniqueUserIdEnabled()) {
                            this.doUpdateRoleListOfUserWithID(adminUserID, null, new String[]{adminRoleName});
                            break block69;
                        }
                        this.doUpdateRoleListOfUser(adminUserName, null, new String[]{adminRoleName});
                    }
                    catch (Exception e) {
                        String message3 = "Admin user has not been assigned to Admin role. Error while assignment is done";
                        if (initialSetup) {
                            throw new UserStoreException(message3, e);
                        }
                        if (log.isDebugEnabled()) {
                            log.error((Object)message3, (Throwable)e);
                        }
                        break block69;
                    }
                }
                message = "Admin user can not be assigned to Admin role Add-Admin has been set to false. Please do the assign it in user store level";
                if (initialSetup) {
                    throw new UserStoreException(message);
                }
                if (log.isDebugEnabled()) {
                    log.error((Object)message);
                }
            }
        }
        this.doInitialUserAdding();
    }

    private void updateHybridRoleListOfUserInternal(boolean initialSetup, String adminRoleName, String adminUserID) throws UserStoreException {
        block4: {
            if (!this.hybridRoleManager.isUserInRole(adminUserID, adminRoleName)) {
                try {
                    this.hybridRoleManager.updateHybridRoleListOfUser(adminUserID, null, new String[]{adminRoleName});
                }
                catch (Exception e) {
                    String message = "Admin user has not been assigned to Admin role. Error while assignment is done";
                    if (initialSetup) {
                        throw new UserStoreException(message, e);
                    }
                    if (!log.isDebugEnabled()) break block4;
                    log.error((Object)message, (Throwable)e);
                }
            }
        }
    }

    public Map<String, Integer> getMaxListCount(String type) throws UserStoreException {
        if (!type.equals("MaxUserNameListLength") && !type.equals("MaxRoleNameListLength")) {
            throw new UserStoreException("Invalid count parameter");
        }
        if (type.equals("MaxUserNameListLength") && this.maxUserListCount != null) {
            return this.maxUserListCount;
        }
        if (type.equals("MaxRoleNameListLength") && this.maxRoleListCount != null) {
            return this.maxRoleListCount;
        }
        HashMap<String, Integer> maxListCount = new HashMap<String, Integer>();
        for (Map.Entry<String, UserStoreManager> entry : this.userStoreManagerHolder.entrySet()) {
            UserStoreManager storeManager = entry.getValue();
            String maxConfig = storeManager.getRealmConfiguration().getUserStoreProperty(type);
            if (maxConfig == null) {
                maxConfig = MAX_LIST_LENGTH;
            }
            maxListCount.put(entry.getKey(), Integer.parseInt(maxConfig));
        }
        if (this.realmConfig.getUserStoreProperty("DomainName") == null) {
            String maxConfig = this.realmConfig.getUserStoreProperty(type);
            if (maxConfig == null) {
                maxConfig = MAX_LIST_LENGTH;
            }
            maxListCount.put(null, Integer.parseInt(maxConfig));
        }
        if (type.equals("MaxUserNameListLength")) {
            this.maxUserListCount = maxListCount;
            return this.maxUserListCount;
        }
        if (type.equals("MaxRoleNameListLength")) {
            this.maxRoleListCount = maxListCount;
            return this.maxRoleListCount;
        }
        throw new UserStoreException("Invalid count parameter");
    }

    protected String getMyDomainName() {
        return UserCoreUtil.getDomainName(this.realmConfig);
    }

    protected void persistDomain() throws UserStoreException {
        String domain = UserCoreUtil.getDomainName(this.realmConfig);
        if (domain != null) {
            UserCoreUtil.persistDomain(domain, this.tenantId, this.dataSource);
        }
    }

    public void deletePersistedDomain(String domain) throws UserStoreException {
        if (domain != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting persisted domain " + domain));
            }
            UserCoreUtil.deletePersistedDomain(domain, this.tenantId, this.dataSource);
        }
    }

    public void updatePersistedDomain(String oldDomain, String newDomain) throws UserStoreException {
        if (oldDomain != null && newDomain != null) {
            for (RealmConfiguration realmConfigTmp = this.getRealmConfiguration(); realmConfigTmp != null; realmConfigTmp = realmConfigTmp.getSecondaryRealmConfig()) {
                String domainName = realmConfigTmp.getUserStoreProperty("DomainName");
                if (!newDomain.equalsIgnoreCase(domainName)) continue;
                throw new UserStoreException("Cannot update persisted domain name " + oldDomain + " into " + newDomain + ". New domain name already in use");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Renaming persisted domain " + oldDomain + " to " + newDomain));
            }
            UserCoreUtil.updatePersistedDomain(oldDomain, newDomain, this.tenantId, this.dataSource);
        }
    }

    public boolean isSharedRole(String roleName, String roleNameBase) {
        return this.isSharedGroupEnabled();
    }

    protected boolean isOwnRole(String roleName) {
        return true;
    }

    public void addRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions) throws org.wso2.carbon.user.api.UserStoreException {
        this.addRole(roleName, userList, permissions, false);
    }

    public boolean isOthersSharedRole(String roleName) {
        return false;
    }

    public void notifyListeners(String domainName) {
        for (UserStoreManagerConfigurationListener aListener : this.listener) {
            aListener.propertyChange(domainName);
        }
    }

    public void addChangeListener(UserStoreManagerConfigurationListener newListener) {
        this.listener.add(newListener);
    }

    private UserStoreManager createSecondaryUserStoreManager(RealmConfiguration realmConfig, UserRealm realm) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{RealmConfiguration.class, UserRealm.class};
            Object object = this.callSecure("createSecondaryUserStoreManager", new Object[]{realmConfig, realm}, argTypes);
            return (UserStoreManager)object;
        }
        realmConfig.setEveryOneRoleName(this.realmConfig.getEveryOneRoleName());
        realmConfig.setAdminUserName(this.realmConfig.getAdminUserName());
        realmConfig.setAdminRoleName(this.realmConfig.getAdminRoleName());
        String className = realmConfig.getUserStoreClass();
        if (className == null) {
            String errmsg = "Unable to add user store. UserStoreManager class name is null.";
            log.error((Object)errmsg);
            throw new UserStoreException(errmsg);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("um.datasource", this.dataSource);
        properties.put("FistStartupCheck", false);
        Class[] initClassOpt1 = new Class[]{RealmConfiguration.class, Map.class, ClaimManager.class, ProfileConfigurationManager.class, UserRealm.class, Integer.class};
        Object[] initObjOpt1 = new Object[]{realmConfig, properties, realm.getClaimManager(), null, realm, this.tenantId};
        Class[] initClassOpt2 = new Class[]{RealmConfiguration.class, Map.class, ClaimManager.class, ProfileConfigurationManager.class, UserRealm.class};
        Object[] initObjOpt2 = new Object[]{realmConfig, properties, realm.getClaimManager(), null, realm};
        Class[] initClassOpt3 = new Class[]{RealmConfiguration.class, Map.class};
        Object[] initObjOpt3 = new Object[]{realmConfig, properties};
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = null;
            Object newObject = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Start initializing class with the first option");
            }
            try {
                constructor = clazz.getConstructor(initClassOpt1);
                newObject = constructor.newInstance(initObjOpt1);
                return newObject;
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannont initialize " + className + " using the option 1"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"End initializing class with the first option");
                }
                try {
                    constructor = clazz.getConstructor(initClassOpt2);
                    newObject = constructor.newInstance(initObjOpt2);
                    return newObject;
                }
                catch (NoSuchMethodException e2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cannot initialize " + className + " using the option 2"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"End initializing class with the second option");
                    }
                    try {
                        constructor = clazz.getConstructor(initClassOpt3);
                        newObject = constructor.newInstance(initObjOpt3);
                        return newObject;
                    }
                    catch (NoSuchMethodException e3) {
                        String message = "Cannot initialize " + className + ". Error " + e3.getMessage();
                        log.error((Object)message);
                        throw new UserStoreException(message);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)("Cannot create " + className), e);
            throw new UserStoreException(e.getMessage() + "Type " + e.getClass(), e);
        }
    }

    public void addSecondaryUserStoreManager(RealmConfiguration userStoreRealmConfig, UserRealm realm) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{RealmConfiguration.class, UserRealm.class};
            this.callSecure("addSecondaryUserStoreManager", new Object[]{userStoreRealmConfig, realm}, argTypes);
            return;
        }
        boolean isDisabled = Boolean.parseBoolean(userStoreRealmConfig.getUserStoreProperty("Disabled"));
        String domainName = userStoreRealmConfig.getUserStoreProperty("DomainName");
        if (isDisabled) {
            log.warn((Object)("Secondary user store disabled with domain " + domainName + "."));
        } else {
            UserStoreManager manager = this.createSecondaryUserStoreManager(userStoreRealmConfig, realm);
            if (domainName != null) {
                if (this.getSecondaryUserStoreManager(domainName) != null) {
                    String errmsg = "Could not initialize new user store manager : " + domainName + " Duplicate domain names not allowed.";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errmsg);
                    }
                    throw new UserStoreException(errmsg);
                }
                UserStoreManager tmpUserStoreManager = this;
                while (tmpUserStoreManager.getSecondaryUserStoreManager() != null) {
                    tmpUserStoreManager = tmpUserStoreManager.getSecondaryUserStoreManager();
                }
                tmpUserStoreManager.setSecondaryUserStoreManager(manager);
                this.addSecondaryUserStoreManager(domainName.toUpperCase(), tmpUserStoreManager.getSecondaryUserStoreManager());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("UserStoreManager : " + domainName + "added to the list"));
                }
            } else {
                log.warn((Object)"Could not initialize new user store manager.  Domain name is not defined");
            }
        }
    }

    @Override
    public Map<String, List<String>> getRoleListOfUsers(String[] userNames) throws UserStoreException {
        AbstractUserOperationEventListener newListener;
        UserOperationEventListener listener;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String[].class};
            Object object = this.callSecure("getRoleListOfUsers", new Object[]{userNames}, argTypes);
            return (Map)object;
        }
        HashMap<String, List<String>> allRoleNames = new HashMap<String, List<String>>();
        Map<String, List<String>> domainFreeUsers = this.getDomainFreeUsers(userNames);
        for (Map.Entry<String, List<String>> entry : domainFreeUsers.entrySet()) {
            UserStoreManager secondaryUserStoreManager = this.getSecondaryUserStoreManager(entry.getKey());
            if (!(secondaryUserStoreManager instanceof AbstractUserStoreManager)) continue;
            if (((AbstractUserStoreManager)secondaryUserStoreManager).isUniqueUserIdEnabled()) {
                Map<String, List<String>> userRoles = ((AbstractUserStoreManager)secondaryUserStoreManager).doGetRoleListOfUsersWithID(this.getUserIDsFromUserNames(entry.getValue()), entry.getKey());
                userRoles.forEach((key, value) -> {
                    try {
                        allRoleNames.put(this.getUserNameFromUserID((String)key), (List<String>)value);
                    }
                    catch (UserStoreException userStoreException) {
                        // empty catch block
                    }
                });
                continue;
            }
            Map<String, List<String>> roleNames = ((AbstractUserStoreManager)secondaryUserStoreManager).doGetRoleListOfUsers(entry.getValue(), entry.getKey());
            allRoleNames.putAll(roleNames);
        }
        Iterator<Object> iterator = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
        while (iterator.hasNext() && (!((listener = (UserOperationEventListener)iterator.next()) instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPostGetRoleListOfUsers(userNames, allRoleNames))) {
        }
        iterator = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
        while (iterator.hasNext() && (!((listener = (UserOperationEventListener)iterator.next()) instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPostGetRoleListOfUsers(userNames, allRoleNames, this))) {
        }
        return allRoleNames;
    }

    public Map<String, List<String>> doGetRoleListOfUsers(List<String> userNames, String domainName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{List.class, String.class};
            Object object = this.callSecure("doGetRoleListOfUsers", new Object[]{userNames, domainName}, argTypes);
            return (Map)object;
        }
        Map<String, List<String>> internalRoles = this.doGetInternalRoleListOfUsers(userNames, domainName);
        Map<Object, Object> externalRoles = new HashMap();
        if (this.readGroupsEnabled) {
            externalRoles = this.doGetExternalRoleListOfUsers(userNames);
        }
        Map<Object, Object> combinedRoles = new HashMap();
        if (!internalRoles.isEmpty() && !externalRoles.isEmpty()) {
            for (String userName : userNames) {
                ArrayList<String> roles = new ArrayList<String>();
                if (internalRoles.get(userName) != null) {
                    roles.addAll((Collection)internalRoles.get(userName));
                }
                if (externalRoles.get(userName) != null) {
                    List<String> domainQualifiedRoleNames = this.getNamesWithDomain((List)externalRoles.get(userName), domainName);
                    roles.addAll(domainQualifiedRoleNames);
                }
                if (roles.isEmpty()) continue;
                combinedRoles.put(userName, roles);
            }
        } else if (!internalRoles.isEmpty()) {
            combinedRoles = internalRoles;
        } else if (!externalRoles.isEmpty()) {
            combinedRoles = externalRoles;
        }
        return combinedRoles;
    }

    protected Map<String, List<String>> doGetExternalRoleListOfUsers(List<String> userNames) throws UserStoreException {
        HashMap<String, List<String>> externalRoleListOfUsers = new HashMap<String, List<String>>();
        for (String userName : userNames) {
            Object[] externalRoles = this.doGetExternalRoleListOfUser(userName, null);
            if (ArrayUtils.isEmpty((Object[])externalRoles)) continue;
            externalRoleListOfUsers.put(userName, Arrays.asList(externalRoles));
        }
        return externalRoleListOfUsers;
    }

    protected Map<String, List<String>> doGetExternalRoleListOfUsersWithID(List<String> userIDs) throws UserStoreException {
        HashMap<String, List<String>> externalRoleListOfUsers = new HashMap<String, List<String>>();
        for (String userID : userIDs) {
            Object[] externalRoles = this.doGetExternalRoleListOfUserWithID(userID, null);
            if (ArrayUtils.isEmpty((Object[])externalRoles)) continue;
            externalRoleListOfUsers.put(userID, Arrays.asList(externalRoles));
        }
        return externalRoleListOfUsers;
    }

    @Override
    public UserClaimSearchEntry[] getUsersClaimValues(String[] userNames, String[] claims, String profileName) throws UserStoreException {
        AbstractUserOperationEventListener newListener;
        UserOperationEventListener listener;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String[].class, String[].class, String.class};
            Object object = this.callSecure("getUsersClaimValues", new Object[]{userNames, claims, profileName}, argTypes);
            return (UserClaimSearchEntry[])object;
        }
        if (StringUtils.isEmpty((String)profileName)) {
            profileName = "default";
        }
        if (claims == null) {
            claims = new String[]{};
        }
        Object[] allUsers = new UserClaimSearchEntry[]{};
        Map<String, List<String>> domainFreeUsers = this.getDomainFreeUsers(userNames);
        for (Map.Entry<String, List<String>> entry : domainFreeUsers.entrySet()) {
            UserStoreManager secondaryUserStoreManager = this.getSecondaryUserStoreManager(entry.getKey());
            if (!(secondaryUserStoreManager instanceof AbstractUserStoreManager)) continue;
            List<String> usersWithDomain = this.getNamesWithDomain(entry.getValue(), entry.getKey());
            if (((AbstractUserStoreManager)secondaryUserStoreManager).isUniqueUserIdEnabled()) {
                List<UniqueIDUserClaimSearchEntry> uniqueIDUserClaimSearchEntries = ((AbstractUserStoreManager)secondaryUserStoreManager).doGetUsersClaimValuesWithID(this.getUserIDsFromUserNames(usersWithDomain), Arrays.asList(claims), entry.getKey(), profileName);
                List<UserClaimSearchEntry> userClaimSearchEntries = this.getUserClaimSearchEntries(uniqueIDUserClaimSearchEntries);
                allUsers = (UserClaimSearchEntry[])ArrayUtils.addAll((Object[])userClaimSearchEntries.toArray(new UserClaimSearchEntry[0]), (Object[])allUsers);
                continue;
            }
            Object[] users = ((AbstractUserStoreManager)secondaryUserStoreManager).doGetUsersClaimValues(entry.getValue(), claims, entry.getKey(), profileName);
            allUsers = (UserClaimSearchEntry[])ArrayUtils.addAll((Object[])users, (Object[])allUsers);
        }
        Iterator<Object> iterator = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
        while (iterator.hasNext() && (!((listener = (UserOperationEventListener)iterator.next()) instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPostGetUsersClaimValues(userNames, claims, profileName, (UserClaimSearchEntry[])allUsers))) {
        }
        iterator = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
        while (iterator.hasNext() && (!((listener = (UserOperationEventListener)iterator.next()) instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPostGetUsersClaimValues(userNames, claims, profileName, (UserClaimSearchEntry[])allUsers, this))) {
        }
        return allUsers;
    }

    public List<UserClaimSearchEntry> getUserClaimSearchEntries(List<UniqueIDUserClaimSearchEntry> uniqueIDUserClaimSearchEntries) {
        ArrayList<UserClaimSearchEntry> userClaimSearchEntries = new ArrayList<UserClaimSearchEntry>();
        for (UniqueIDUserClaimSearchEntry uniqueIDUserClaimSearchEntry : uniqueIDUserClaimSearchEntries) {
            userClaimSearchEntries.add(uniqueIDUserClaimSearchEntry.getUserClaimSearchEntry());
        }
        return userClaimSearchEntries;
    }

    public UserClaimSearchEntry[] doGetUsersClaimValues(List<String> users, String[] claims, String domainName, String profileName) throws UserStoreException {
        HashSet<String> propertySet = new HashSet<String>();
        HashMap<String, String> claimToAttributeMap = new HashMap<String, String>();
        ArrayList<UserClaimSearchEntry> userClaimSearchEntryList = new ArrayList<UserClaimSearchEntry>();
        for (String claim : claims) {
            String property;
            try {
                property = this.getClaimAtrribute(claim, null, domainName);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            propertySet.add(property);
            claimToAttributeMap.put(claim, property);
        }
        String[] properties = propertySet.toArray(new String[0]);
        Map<String, Map<String, String>> userProperties = this.getUsersPropertyValues(users, properties, profileName);
        for (Map.Entry<String, Map<String, String>> entry : userProperties.entrySet()) {
            UserClaimSearchEntry userClaimSearchEntry = new UserClaimSearchEntry();
            userClaimSearchEntry.setUserName(UserCoreUtil.addDomainToName(entry.getKey(), domainName));
            HashMap<String, String> userClaims = new HashMap<String, String>();
            for (String claim : claims) {
                for (Map.Entry<String, String> userAttribute : entry.getValue().entrySet()) {
                    if (claimToAttributeMap.get(claim) == null || !((String)claimToAttributeMap.get(claim)).equals(userAttribute.getKey())) continue;
                    userClaims.put(claim, userAttribute.getValue());
                }
            }
            userClaimSearchEntry.setClaims(userClaims);
            userClaimSearchEntryList.add(userClaimSearchEntry);
        }
        return userClaimSearchEntryList.toArray(new UserClaimSearchEntry[0]);
    }

    private Map<String, List<String>> getDomainFreeUsers(String[] userNames) {
        HashMap<String, List<String>> domainAwareUsers = new HashMap<String, List<String>>();
        if (ArrayUtils.isNotEmpty((Object[])userNames)) {
            for (String username : userNames) {
                ArrayList<String> users;
                String domainName = UserCoreUtil.extractDomainFromName(username);
                if (StringUtils.isEmpty((String)domainName)) {
                    domainName = "PRIMARY";
                }
                if ((users = (ArrayList<String>)domainAwareUsers.get(domainName)) == null) {
                    users = new ArrayList<String>();
                    domainAwareUsers.put(domainName.toUpperCase(), users);
                }
                users.add(UserCoreUtil.removeDomainFromName(username));
            }
        }
        return domainAwareUsers;
    }

    protected Map<String, Map<String, String>> getUsersPropertyValues(List<String> users, String[] propertyNames, String profileName) throws UserStoreException {
        HashMap<String, Map<String, String>> usersPropertyValuesMap = new HashMap<String, Map<String, String>>();
        for (String userName : users) {
            Map<String, String> propertyValuesMap = this.getUserPropertyValues(userName, propertyNames, profileName);
            this.processAttributesAfterRetrieval(userName, propertyValuesMap, profileName);
            if (propertyValuesMap == null || propertyValuesMap.isEmpty()) continue;
            usersPropertyValuesMap.put(userName, propertyValuesMap);
        }
        return usersPropertyValuesMap;
    }

    public void removeSecondaryUserStoreManager(String userStoreDomainName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            this.callSecure("removeSecondaryUserStoreManager", new Object[]{userStoreDomainName}, argTypes);
            return;
        }
        if (userStoreDomainName == null) {
            throw new UserStoreException("Cannot remove user store. User store domain name is null");
        }
        if ("".equals(userStoreDomainName)) {
            throw new UserStoreException("Cannot remove user store. User store domain name is empty");
        }
        userStoreDomainName = userStoreDomainName.toUpperCase();
        boolean isUSMContainsInMap = false;
        if (this.userStoreManagerHolder.containsKey(userStoreDomainName.toUpperCase())) {
            isUSMContainsInMap = true;
            this.userStoreManagerHolder.remove(userStoreDomainName.toUpperCase());
            if (log.isDebugEnabled()) {
                log.debug((Object)("UserStore: " + userStoreDomainName + " removed from map"));
            }
        }
        boolean isUSMConatainsInChain = false;
        UserStoreManager prevUserStoreManager = this;
        while (prevUserStoreManager.getSecondaryUserStoreManager() != null) {
            UserStoreManager secondaryUSM = prevUserStoreManager.getSecondaryUserStoreManager();
            if (secondaryUSM.getRealmConfiguration().getUserStoreProperty("DomainName").equalsIgnoreCase(userStoreDomainName)) {
                isUSMConatainsInChain = true;
                prevUserStoreManager.setSecondaryUserStoreManager(secondaryUSM.getSecondaryUserStoreManager());
                log.info((Object)("User store: " + userStoreDomainName + " of tenant:" + this.tenantId + " is removed from user store chain."));
                return;
            }
            prevUserStoreManager = secondaryUSM;
        }
        if (!isUSMContainsInMap && isUSMConatainsInChain) {
            throw new UserStoreException("Removed user store manager : " + userStoreDomainName + " didnt exists in userStoreManagerHolder map");
        }
        if (isUSMContainsInMap && !isUSMConatainsInChain) {
            throw new UserStoreException("Removed user store manager : " + userStoreDomainName + " didnt exists in user store manager chain");
        }
    }

    public HybridRoleManager getInternalRoleManager() {
        return this.hybridRoleManager;
    }

    @Override
    public String[] getUserList(String claim, String claimValue, String profileName, int limit, int offset) throws UserStoreException {
        List<String> userNamesFromUserStore;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class, Integer.TYPE, Integer.TYPE};
            Object object = this.callSecure("getUserList", new Object[]{claim, claimValue, profileName, limit, offset}, argTypes);
            return (String[])object;
        }
        if (claim == null) {
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.getCode();
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.getMessage(), "");
            this.handleGetUserListFailure(errorCode, errorMessage, null, claimValue, limit, offset, profileName);
            throw new IllegalArgumentException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.toString());
        }
        if (claimValue == null) {
            this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_VALUE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_VALUE.getMessage(), claim, null, limit, offset, profileName);
            throw new IllegalArgumentException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_VALUE.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing and paginate users who having value as " + claimValue + " for the claim " + claim));
        }
        if (USERNAME_CLAIM_URI.equalsIgnoreCase(claim) || SCIM_USERNAME_CLAIM_URI.equalsIgnoreCase(claim) || SCIM2_USERNAME_CLAIM_URI.equalsIgnoreCase(claim)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Switching to paginate users using username");
            }
            Object[] filteredUsers = this.listUsers(claimValue, limit, offset);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Filtered users: " + Arrays.toString(filteredUsers)));
            }
            return filteredUsers;
        }
        String extractedDomain = null;
        int index = claimValue.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index > 0) {
            String[] names = claimValue.split(CarbonConstants.DOMAIN_SEPARATOR);
            extractedDomain = names[0].trim();
        }
        UserStoreManager userManager = this;
        if (StringUtils.isNotEmpty(extractedDomain) && !StringUtils.equalsIgnoreCase((String)this.getMyDomainName(), (String)extractedDomain)) {
            UserStoreManager secondaryUserStoreManager = this.getSecondaryUserStoreManager(extractedDomain);
            if (secondaryUserStoreManager != null) {
                userManager = secondaryUserStoreManager;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Domain: " + extractedDomain + " is passed with the claim and user store manager is loaded for the given domain name."));
                }
            } else {
                throw new UserStoreException("Invalid Domain Name: " + extractedDomain);
            }
        }
        if (userManager instanceof JDBCUserStoreManager && (SCIM_USERNAME_CLAIM_URI.equalsIgnoreCase(claim) || SCIM2_USERNAME_CLAIM_URI.equalsIgnoreCase(claim))) {
            if (userManager.isExistingUser(claimValue)) {
                return new String[]{claimValue};
            }
            return new String[0];
        }
        claimValue = UserCoreUtil.removeDomainFromName(claimValue);
        ArrayList<String> filteredUserList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)extractedDomain)) {
            try {
                for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                    AbstractUserOperationEventListener newListener;
                    if (!(listener instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPreGetUserList(claim, claimValue, limit, offset, filteredUserList, userManager)) continue;
                    this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), "Pre-listener tasks failed"), claim, claimValue, limit, offset, profileName);
                    break;
                }
            }
            catch (UserStoreException ex) {
                this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, limit, offset, profileName);
                throw ex;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pre listener user list: " + filteredUserList + " for domain: " + extractedDomain));
        }
        if (this.isUniqueUserIdEnabled(userManager)) {
            List<User> usersFromUserStore = this.doGetUserListWithID(claim, claimValue, profileName, limit, offset, extractedDomain, userManager);
            userNamesFromUserStore = usersFromUserStore.stream().map(User::getDomainQualifiedUsername).collect(Collectors.toList());
        } else {
            userNamesFromUserStore = this.doGetUserList(claim, claimValue, profileName, limit, offset, extractedDomain, userManager);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Users from user store: " + extractedDomain + " : " + userNamesFromUserStore));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Users from user store: " + extractedDomain + " : " + userNamesFromUserStore));
        }
        filteredUserList.addAll(userNamesFromUserStore);
        if (StringUtils.isNotEmpty((String)extractedDomain)) {
            this.handlePostGetUserList(claim, claimValue, filteredUserList, limit, offset, false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Post listener user list pagination: " + filteredUserList + " for domain: " + extractedDomain));
        }
        return filteredUserList.toArray(new String[0]);
    }

    @Override
    public long getUserCountWithClaims(String claimUri, String filter) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("getUserCountWithClaims", new Object[]{claimUri, filter}, argTypes);
            return (Long)object;
        }
        if (claimUri == null) {
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NULL_CLAIM_URI.getCode();
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NULL_CLAIM_URI.getMessage(), new Object[0]);
            this.handleGetUserCountFailure(errorCode, errorMessage, null, filter);
            throw new IllegalArgumentException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NULL_CLAIM_URI.toString());
        }
        if (filter == null) {
            this.handleGetUserCountFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DOMAIN_VALUE_WITH_FILTER_EMPTY.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DOMAIN_VALUE_WITH_FILTER_EMPTY.getMessage(), claimUri, null);
            throw new IllegalArgumentException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DOMAIN_VALUE_WITH_FILTER_EMPTY.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Count users who having filter and domain " + filter + " for the claim " + claimUri));
        }
        String extractedDomain = null;
        int index = filter.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index > 0) {
            String[] names = filter.split(CarbonConstants.DOMAIN_SEPARATOR);
            extractedDomain = names[0].trim();
        }
        if (StringUtils.isEmpty(extractedDomain)) {
            extractedDomain = "PRIMARY";
        }
        UserStoreManager userManager = this.getSecondaryUserStoreManager(extractedDomain);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Domain: " + extractedDomain + " is passed with the claim and user store manager is loaded for the given domain name."));
        }
        String filterValue = UserCoreUtil.removeDomainFromName(filter);
        return this.getCountUsers(claimUri, filterValue, userManager);
    }

    @Override
    public String[] getUserList(Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        this.validateCondition(condition);
        if (StringUtils.isNotEmpty((String)sortBy) && StringUtils.isNotEmpty((String)sortOrder)) {
            throw new UserStoreException("Sorting is not supported.");
        }
        if (StringUtils.isEmpty((String)domain)) {
            domain = "PRIMARY";
        }
        if (StringUtils.isEmpty((String)profileName)) {
            profileName = "default";
        }
        this.handlePreGetUserList(condition, domain, profileName, limit, offset, sortBy, sortOrder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pre listener get conditional  user list for domain: " + domain));
        }
        String[] filteredUsers = new String[]{};
        UserStoreManager secManager = this.getSecondaryUserStoreManager(domain);
        if (secManager != null && secManager instanceof AbstractUserStoreManager) {
            if (((AbstractUserStoreManager)secManager).isUniqueUserIdEnabled()) {
                UniqueIDPaginatedSearchResult users = ((AbstractUserStoreManager)secManager).doGetUserListWithID(condition, profileName, limit, offset, sortBy, sortOrder);
                this.addUsersToUserIdCache(users.getUsers());
                this.addUsersToUserNameCache(users.getUsers());
                filteredUsers = (String[])users.getUsers().stream().map(User::getUsername).toArray(String[]::new);
            } else {
                PaginatedSearchResult users = ((AbstractUserStoreManager)secManager).doGetUserList(condition, profileName, limit, offset, sortBy, sortOrder);
                filteredUsers = users.getUsers();
            }
        }
        this.handlePostGetUserList(condition, domain, profileName, limit, offset, sortBy, sortOrder, filteredUsers, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("post listener get conditional  user list for domain: " + domain));
        }
        return filteredUsers;
    }

    protected PaginatedSearchResult doGetUserList(Condition condition, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        return new PaginatedSearchResult();
    }

    protected UniqueIDPaginatedSearchResult doGetUserListWithID(Condition condition, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doGetUserListWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doGetUserListWithID operation is not implemented in: " + this.getClass());
    }

    @Override
    public String[] listUsers(String filter, int limit, int offset) throws UserStoreException {
        PaginatedSearchResult userList;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
            Object object = this.callSecure("listUsers", new Object[]{filter, limit, offset}, argTypes);
            return (String[])object;
        }
        int index = filter.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        String[] users = new String[]{};
        if (offset <= 0) {
            offset = 1;
        }
        if (index > 0) {
            String domain = filter.substring(0, index);
            UserStoreManager secManager = this.getSecondaryUserStoreManager(domain);
            if (secManager != null) {
                filter = filter.substring(index + 1);
                if (secManager instanceof AbstractUserStoreManager) {
                    PaginatedSearchResult userList2 = !((AbstractUserStoreManager)secManager).isUniqueUserIdEnabled() ? ((AbstractUserStoreManager)secManager).doListUsers(filter, limit, offset) : ((AbstractUserStoreManager)secManager).doListUsersWithID(filter, limit, offset).getPaginatedSearchResult();
                    this.handlePostListPaginatedUsers(filter, limit, offset, new ArrayList<String>(Arrays.asList(userList2.getUsers())), true);
                    return userList2.getUsers();
                }
            }
        } else if (index == 0) {
            PaginatedSearchResult userList3 = !this.isUniqueUserIdEnabled() ? this.doListUsers(filter.substring(1), limit, offset) : this.doListUsersWithID(filter.substring(1), limit, offset).getPaginatedSearchResult();
            this.handlePostListPaginatedUsers(filter, limit, offset, new ArrayList<String>(Arrays.asList(userList3.getUsers())), true);
            return userList3.getUsers();
        }
        try {
            userList = !this.isUniqueUserIdEnabled() ? this.doListUsers(filter, limit, offset) : this.doListUsersWithID(filter, limit, offset).getPaginatedSearchResult();
            users = UserCoreUtil.combineArrays(users, userList.getUsers());
            limit -= users.length;
        }
        catch (UserStoreException ex) {
            this.handleGetPaginatedUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_LISTING_PAGINATED_USERS.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_LISTING_PAGINATED_USERS.getMessage(), ex.getMessage()), null, null, null);
            throw ex;
        }
        String primaryDomain = this.realmConfig.getUserStoreProperty("DomainName");
        int nonPaginatedUserCount = userList.getSkippedUserCount();
        if (this.getSecondaryUserStoreManager() != null) {
            for (Map.Entry<String, UserStoreManager> entry : this.userStoreManagerHolder.entrySet()) {
                UserStoreManager storeManager;
                if (limit <= 0) {
                    return users;
                }
                if (entry.getKey().equalsIgnoreCase(primaryDomain) || !((storeManager = entry.getValue()) instanceof AbstractUserStoreManager)) continue;
                try {
                    offset = userList.getUsers().length > 0 ? 1 : (offset -= nonPaginatedUserCount);
                    PaginatedSearchResult secondUserList = !((AbstractUserStoreManager)storeManager).isUniqueUserIdEnabled() ? ((AbstractUserStoreManager)storeManager).doListUsers(filter, limit, offset) : ((AbstractUserStoreManager)storeManager).doListUsersWithID(filter, limit, offset).getPaginatedSearchResult();
                    nonPaginatedUserCount = secondUserList.getSkippedUserCount();
                    users = UserCoreUtil.combineArrays(users, secondUserList.getUsers());
                    limit -= users.length;
                }
                catch (UserStoreException ex) {
                    this.handleGetPaginatedUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_LISTING_PAGINATED_USERS.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_LISTING_PAGINATED_USERS.getMessage(), ex.getMessage()), null, null, null);
                    log.error((Object)ex);
                }
            }
        }
        this.handlePostListPaginatedUsers(filter, limit, offset, new ArrayList<String>(Arrays.asList(users)), true);
        return users;
    }

    protected PaginatedSearchResult doListUsers(String filter, int limit, int offset) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Operation is not implemented in: " + this.getClass()));
        }
        return new PaginatedSearchResult();
    }

    protected UniqueIDPaginatedSearchResult doListUsersWithID(String filter, int limit, int offset) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doListUsersWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doListUsersWithID operation is not implemented in: " + this.getClass());
    }

    protected long doCountRoles(String filter) throws UserStoreException {
        throw new UserStoreException("Operation is not supported");
    }

    protected PaginatedSearchResult getUserListFromProperties(String property, String value, String profileName, int limit, int offset) throws UserStoreException {
        return new PaginatedSearchResult();
    }

    protected UniqueIDPaginatedSearchResult doGetUserListFromPropertiesWithID(String property, String value, String profileName, int limit, int offset) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doGetUserListFromPropertiesWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doGetUserListFromPropertiesWithID operation is not implemented in: " + this.getClass());
    }

    private void validateCondition(Condition condition) throws UserStoreException {
        if (condition instanceof ExpressionCondition) {
            if (this.isNotSupportedExpressionOperation(condition)) {
                throw new UserStoreException("Unsupported expression operation: " + condition.getOperation());
            }
        } else if (condition instanceof OperationalCondition) {
            Condition leftCondition = ((OperationalCondition)condition).getLeftCondition();
            this.validateCondition(leftCondition);
            Condition rightCondition = ((OperationalCondition)condition).getRightCondition();
            String operation = condition.getOperation();
            if (!OperationalOperation.AND.toString().equals(operation)) {
                throw new UserStoreException("Unsupported Conditional operation: " + condition.getOperation());
            }
            this.validateCondition(rightCondition);
        }
    }

    private boolean isNotSupportedExpressionOperation(Condition condition) {
        return !ExpressionOperation.EQ.toString().equals(condition.getOperation()) && !ExpressionOperation.CO.toString().equals(condition.getOperation()) && !ExpressionOperation.SW.toString().equals(condition.getOperation()) && !ExpressionOperation.EW.toString().equals(condition.getOperation()) && !ExpressionOperation.GE.toString().equals(condition.getOperation()) && !ExpressionOperation.LE.toString().equals(condition.getOperation());
    }

    private boolean isAnInternalRole(String roleName) {
        return roleName.toLowerCase().startsWith(APPLICATION_DOMAIN.toLowerCase()) || roleName.toLowerCase().startsWith("Internal".toLowerCase()) || roleName.toLowerCase().startsWith(WORKFLOW_DOMAIN.toLowerCase());
    }

    private List<String> getUserStorePreferenceOrder() throws UserStoreException {
        List<String> userStorePreferenceOrder;
        UserStorePreferenceOrderSupplier<List<String>> userStorePreferenceSupplier;
        UserMgtContext userMgtContext = UserCoreUtil.getUserMgtContextFromThreadLocal();
        if (userMgtContext != null && (userStorePreferenceSupplier = userMgtContext.getUserStorePreferenceOrderSupplier()) != null && (userStorePreferenceOrder = userStorePreferenceSupplier.get()) != null) {
            return userStorePreferenceOrder;
        }
        return Collections.emptyList();
    }

    private boolean hasUserStorePreferenceChainGenerated() throws UserStoreException {
        return this instanceof IterativeUserStoreManager;
    }

    private boolean isUserStoreChainNeeded(List<String> userStorePreferenceOrder) throws UserStoreException {
        if (this instanceof IterativeUserStoreManager) {
            return false;
        }
        userStorePreferenceOrder.addAll(this.getUserStorePreferenceOrder());
        return CollectionUtils.isNotEmpty(userStorePreferenceOrder) && !this.hasUserStorePreferenceChainGenerated();
    }

    private boolean generateUserStoreChain(String userName, Object credential, boolean domainProvided, List<String> userStorePreferenceOrder) throws UserStoreException {
        if (domainProvided) {
            String providedDomainName = this.getUserStore(userName).getDomainName();
            if (!userStorePreferenceOrder.contains(providedDomainName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Authentication failure. Invalid username or password is provided.");
                }
                this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), "Authentication failed"), userName, credential);
                throw new UserStoreException("Authentication failed. Invalid username or password.");
            }
            UserStoreManager userStoreManager = this.getSecondaryUserStoreManager(providedDomainName);
            if (!(userStoreManager instanceof AbstractUserStoreManager)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"UserStoreManager is not an instance of AbstractUserStoreManager. Hence authenticate the user through all the available user store list.");
                }
                return this.authenticateInternal(userName, credential, true);
            }
            IterativeUserStoreManager iterativeUserStoreManager = new IterativeUserStoreManager((AbstractUserStoreManager)userStoreManager);
            return iterativeUserStoreManager.authenticate(userName, credential);
        }
        AbstractUserStoreManager initialUserStoreManager = null;
        IterativeUserStoreManager prevUserStoreManager = null;
        for (String domainName : userStorePreferenceOrder) {
            UserStoreManager userStoreManager = this.getSecondaryUserStoreManager(domainName);
            if (userStoreManager instanceof AbstractUserStoreManager) {
                if (initialUserStoreManager == null) {
                    prevUserStoreManager = new IterativeUserStoreManager((AbstractUserStoreManager)userStoreManager);
                    initialUserStoreManager = prevUserStoreManager;
                    continue;
                }
                IterativeUserStoreManager currentUserStoreManager = new IterativeUserStoreManager((AbstractUserStoreManager)userStoreManager);
                prevUserStoreManager.setNextUserStoreManager(currentUserStoreManager);
                prevUserStoreManager = currentUserStoreManager;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"UserStoreManager is not an instance of AbstractUserStoreManager hence authenticate the user through all the available user store list.");
            }
            return this.authenticateInternal(userName, credential, domainProvided);
        }
        return initialUserStoreManager.authenticate(userName, credential);
    }

    private long getCountUsers(String claimUri, String filterValue, UserStoreManager userManager) throws UserStoreException {
        if (userManager instanceof AbstractUserStoreManager) {
            return ((AbstractUserStoreManager)userManager).countUsersWithClaims(claimUri, filterValue);
        }
        String msg = "Get user count is not supported by this user store: ";
        if (log.isDebugEnabled()) {
            log.debug((Object)(msg + userManager.getClass()));
        }
        throw new UserStoreException(msg + userManager.getClass());
    }

    private boolean isInternalRole(String domain) {
        return domain.equals("Internal") || domain.equals(APPLICATION_DOMAIN);
    }

    private String removeDomainIfNotApplicationRole(String roleName) {
        String formattedRoleName = roleName.contains(UserCoreConstants.DOMAIN_SEPARATOR) && roleName.toLowerCase().startsWith(APPLICATION_DOMAIN.toLowerCase()) ? roleName : UserCoreUtil.removeDomainFromName(roleName);
        return formattedRoleName;
    }

    private void createHybridRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions) throws UserStoreException {
        try {
            this.hybridRoleManager.addHybridRole(roleName, userList);
        }
        catch (UserStoreException e) {
            if (UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ROLE_ALREADY_EXISTS.getCode().equals(e.getErrorCode())) {
                this.handleRoleAlreadyExistException(roleName, userList, permissions);
            }
            throw e;
        }
    }

    private void createSystemRole(String roleName, String[] userList, Permission[] permissions) throws UserStoreException {
        if (this.systemUserRoleManager.isExistingRole(roleName)) {
            this.handleRoleAlreadyExistException(roleName, userList, permissions);
        }
        try {
            this.systemUserRoleManager.addSystemRole(roleName, userList);
        }
        catch (UserStoreException e) {
            if (UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_A_SYSTEM_ROLE.getCode().contains(e.getErrorCode())) {
                this.handleRoleAlreadyExistException(roleName, userList, permissions);
            }
            throw e;
        }
    }

    @Override
    public final AuthenticationResult authenticateWithID(List<LoginIdentifier> loginIdentifiers, String domain, Object credential) throws UserStoreException {
        try {
            return AccessController.doPrivileged(() -> {
                if (!this.validateUserNameAndCredentials(loginIdentifiers, credential)) {
                    AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
                    authenticationResult.setFailureReason(new FailureReason("Invalid Credentials"));
                    return authenticationResult;
                }
                ArrayList<String> userStorePreferenceOrder = new ArrayList<String>();
                if (this.isUserStoreChainNeeded(userStorePreferenceOrder)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("User store chain generation is needed hence generating the user store chain using the user store preference order: " + userStorePreferenceOrder));
                    }
                    return this.generateUserStoreChainWithID(loginIdentifiers, domain, credential, userStorePreferenceOrder);
                }
                return this.authenticateInternalWithID(loginIdentifiers, domain, credential);
            });
        }
        catch (PrivilegedActionException e) {
            if (!(e.getException() instanceof UserStoreException)) {
                this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), e.getMessage()), loginIdentifiers, credential);
            }
            throw (UserStoreException)((Object)e.getException());
        }
    }

    private AuthenticationResult generateUserStoreChainWithID(List<LoginIdentifier> loginIdentifiers, String domain, Object credential, List<String> userStorePreferenceOrder) throws UserStoreException {
        AbstractUserStoreManager initialUserStoreManager = null;
        IterativeUserStoreManager prevUserStoreManager = null;
        for (String domainName : userStorePreferenceOrder) {
            UserStoreManager userStoreManager = this.getSecondaryUserStoreManager(domainName);
            if (userStoreManager instanceof AbstractUserStoreManager) {
                if (initialUserStoreManager == null) {
                    prevUserStoreManager = new IterativeUserStoreManager((AbstractUserStoreManager)userStoreManager);
                    initialUserStoreManager = prevUserStoreManager;
                    continue;
                }
                IterativeUserStoreManager currentUserStoreManager = new IterativeUserStoreManager((AbstractUserStoreManager)userStoreManager);
                prevUserStoreManager.setNextUserStoreManager(currentUserStoreManager);
                prevUserStoreManager = currentUserStoreManager;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"UserStoreManager is not an instance of AbstractUserStoreManager hence authenticate the user through all the available user store list.");
            }
            return this.authenticateInternalWithID(loginIdentifiers, domain, credential);
        }
        return initialUserStoreManager.authenticateWithID(loginIdentifiers, domain, credential);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationResult authenticateInternalWithID(List<LoginIdentifier> loginIdentifiers, String domain, Object credential) throws UserStoreException {
        Secret credentialObj;
        AbstractUserStoreManager abstractUserStoreManager = this;
        if (this instanceof IterativeUserStoreManager) {
            abstractUserStoreManager = ((IterativeUserStoreManager)this).getAbstractUserStoreManager();
        }
        boolean authenticated = false;
        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
        try {
            credentialObj = Secret.getSecret((Object)credential);
        }
        catch (UnsupportedSecretTypeException e) {
            this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage(), loginIdentifiers, credential);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString(), e);
        }
        try {
            Iterator<UserOperationEventListener> e = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
            while (e.hasNext()) {
                UserOperationEventListener userOperationEventListener;
                Object credentialArgument = (userOperationEventListener = e.next()) instanceof SecretHandleableListener ? credentialObj : credential;
                if (!((AbstractUserOperationEventListener)userOperationEventListener).doPreAuthenticateWithID(loginIdentifiers, credentialArgument, (UserStoreManager)abstractUserStoreManager)) {
                    this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), "Pre-listener tasks failed"), loginIdentifiers, credentialArgument);
                    authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                    authenticationResult.setFailureReason(new FailureReason(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage()));
                    AuthenticationResult authenticationResult2 = authenticationResult;
                    return authenticationResult2;
                }
                try {
                }
                catch (UserStoreException ex) {
                    this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), ex.getMessage()), loginIdentifiers, credential);
                    throw ex;
                }
            }
            int tenantId = abstractUserStoreManager.getTenantId();
            try {
                boolean tenantActive;
                for (LoginIdentifier loginIdentifier : loginIdentifiers) {
                    String mappedAttribute;
                    if (!loginIdentifier.getLoginIdentifierType().equals((Object)LoginIdentifier.LoginIdentifierType.CLAIM_URI) || (mappedAttribute = this.claimManager.getAttributeName(this.getMyDomainName(), loginIdentifier.getLoginKey())) == null) continue;
                    loginIdentifier.setLoginIdentifierType(LoginIdentifier.LoginIdentifierType.ATTRIBUTE);
                    loginIdentifier.setLoginKey(mappedAttribute);
                }
                RealmService realmService = UserCoreUtil.getRealmService();
                if (realmService != null && !(tenantActive = realmService.getTenantManager().isTenantActive(tenantId))) {
                    String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_TENANT_DEACTIVATED.getCode();
                    String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_TENANT_DEACTIVATED.getMessage(), tenantId);
                    log.warn((Object)(errorCode + " - " + errorMessage));
                    this.handleOnAuthenticateFailureWithID(errorCode, errorMessage, loginIdentifiers, credential);
                    authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                    authenticationResult.setFailureReason(new FailureReason("Inactive Tenant: " + tenantId));
                    AuthenticationResult authenticationResult3 = authenticationResult;
                    return authenticationResult3;
                }
            }
            catch (org.wso2.carbon.user.api.UserStoreException userStoreException) {
                this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), userStoreException.getMessage()), loginIdentifiers, credential);
                throw new UserStoreException("Error while trying to check tenant status for Tenant : " + tenantId, userStoreException);
            }
            if (StringUtils.isNotEmpty((String)domain)) {
                UserStoreManager userStoreManager = abstractUserStoreManager.getSecondaryUserStoreManager(domain);
                if (this.isUniqueUserIdEnabled(userStoreManager)) {
                    authenticationResult = ((AbstractUserStoreManager)userStoreManager).doAuthenticateWithID(loginIdentifiers, credential);
                } else {
                    String userName = this.getUsernameByClaims(loginIdentifiers);
                    String userID = this.userUniqueIDManger.getUniqueId(userName, this);
                    boolean status = ((AbstractUserStoreManager)userStoreManager).doAuthenticate(userName, credential);
                    if (status) {
                        User user = this.getUser(userID, userName);
                        authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.SUCCESS);
                        authenticationResult.setAuthenticatedUser(user);
                    } else {
                        authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                        authenticationResult.setFailureReason(new FailureReason("Authentication failed."));
                    }
                }
                if (authenticationResult.getAuthenticationStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
                    authenticated = true;
                }
                if (authenticated) {
                    UserCoreUtil.setDomainInThreadLocal(domain);
                }
            } else {
                if (abstractUserStoreManager.isUniqueUserIdEnabled()) {
                    authenticationResult = abstractUserStoreManager.doAuthenticateWithID(loginIdentifiers, credential);
                } else {
                    String string = this.getUsernameByClaims(loginIdentifiers);
                    String userID = this.userUniqueIDManger.getUniqueId(string, abstractUserStoreManager);
                    boolean status = abstractUserStoreManager.doAuthenticate(string, credential);
                    if (status) {
                        User user = this.getUser(userID, string);
                        authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.SUCCESS);
                        authenticationResult.setAuthenticatedUser(user);
                    } else {
                        authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                        authenticationResult.setFailureReason(new FailureReason("Authentication failed."));
                    }
                }
                if (authenticationResult.getAuthenticationStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
                    authenticated = true;
                }
                if (authenticated) {
                    UserCoreUtil.setDomainInThreadLocal(UserCoreUtil.getDomainName(abstractUserStoreManager.realmConfig));
                }
            }
        }
        finally {
            credentialObj.clear();
        }
        if (!authenticated && StringUtils.isEmpty((String)domain)) {
            AbstractUserStoreManager userStoreManager;
            if (this instanceof IterativeUserStoreManager) {
                IterativeUserStoreManager iterativeUserStoreManager = (IterativeUserStoreManager)this;
                userStoreManager = iterativeUserStoreManager.nextUserStoreManager();
            } else {
                userStoreManager = (AbstractUserStoreManager)abstractUserStoreManager.getSecondaryUserStoreManager();
            }
            if (userStoreManager != null && (authenticationResult = userStoreManager.authenticateWithID(loginIdentifiers, null, credential)).getAuthenticationStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
                authenticated = true;
            }
        }
        if (!authenticated) {
            this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), "Authentication failed"), loginIdentifiers, credential);
        }
        try {
            for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)userOperationEventListener).doPostAuthenticateWithID(loginIdentifiers, authenticationResult, (UserStoreManager)abstractUserStoreManager)) continue;
                this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getMessage(), "Post-listener tasks failed"), loginIdentifiers, credential);
                authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                authenticationResult.setFailureReason(new FailureReason(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getMessage()));
                return authenticationResult;
            }
        }
        catch (UserStoreException ex) {
            this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getMessage(), ex.getMessage()), loginIdentifiers, credential);
            throw ex;
        }
        if (log.isDebugEnabled() && !authenticated) {
            log.debug((Object)"Authentication failure. Wrong userID or password is provided.");
        }
        return authenticationResult;
    }

    public String getUsernameByClaims(List<LoginIdentifier> loginIdentifiers) throws UserStoreException {
        if (loginIdentifiers.isEmpty()) {
            return null;
        }
        for (LoginIdentifier loginIdentifier : loginIdentifiers) {
            String mappedAttribute;
            if (!loginIdentifier.getLoginIdentifierType().equals((Object)LoginIdentifier.LoginIdentifierType.CLAIM_URI)) continue;
            try {
                mappedAttribute = this.claimManager.getAttributeName(this.getMyDomainName(), loginIdentifier.getLoginKey());
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            if (mappedAttribute == null) continue;
            loginIdentifier.setLoginIdentifierType(LoginIdentifier.LoginIdentifierType.ATTRIBUTE);
            loginIdentifier.setLoginKey(mappedAttribute);
        }
        String userName = null;
        Object[] resultedUserList = null;
        for (LoginIdentifier loginIdentifier : loginIdentifiers) {
            Object[] matchedUserList;
            String attribute = loginIdentifier.getLoginKey();
            String attributeValue = loginIdentifier.getLoginValue();
            if (attribute == null || attributeValue == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Searching users for " + attribute + " with the value :" + attributeValue));
            }
            if (!ArrayUtils.isEmpty((Object[])(matchedUserList = this.getUserListFromProperties(attribute, attributeValue, null)))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Matched userList : " + Arrays.toString(matchedUserList)));
                }
                if (resultedUserList != null) {
                    ArrayList<Object> users = new ArrayList<Object>();
                    for (Object user : resultedUserList) {
                        for (Object matchedUser : matchedUserList) {
                            if (!((String)user).equals(matchedUser)) continue;
                            users.add(matchedUser);
                        }
                    }
                    if (users.size() > 0) {
                        resultedUserList = new String[users.size()];
                        users.toArray(resultedUserList);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Current matching temporary userlist :" + Arrays.toString(resultedUserList)));
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("There are no users for " + attribute + " with the value : " + attributeValue + " in the previously filtered user list"));
                    }
                    return null;
                }
                resultedUserList = matchedUserList;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Current matching temporary userlist :" + Arrays.toString(resultedUserList)));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("There are no matching users for " + attribute + " with the value : " + attributeValue));
            }
            return null;
        }
        if (resultedUserList.length == 1) {
            userName = resultedUserList[0];
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("There are more than one user in the result set : " + Arrays.toString(resultedUserList)));
        }
        return userName;
    }

    @Override
    public final AuthenticationResult authenticateWithID(String preferredUserNameClaim, String preferredUserNameValue, Object credential, String profileName) throws UserStoreException {
        try {
            return AccessController.doPrivileged(() -> {
                if (!this.validateUserNameAndCredential(preferredUserNameClaim, preferredUserNameValue, credential)) {
                    AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
                    authenticationResult.setFailureReason(new FailureReason("Invalid Credentials"));
                    return authenticationResult;
                }
                int index = preferredUserNameValue.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
                boolean domainProvided = index > 0;
                return this.authenticateWithID(preferredUserNameClaim, preferredUserNameValue, credential, profileName, domainProvided);
            });
        }
        catch (PrivilegedActionException e) {
            if (!(e.getException() instanceof UserStoreException)) {
                this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), e.getMessage()), preferredUserNameClaim, preferredUserNameValue, credential);
            }
            throw (UserStoreException)((Object)e.getException());
        }
    }

    protected AuthenticationResult authenticateWithID(String preferredUserNameClaim, String preferredUserNameValue, Object credential, String profileName, boolean domainProvided) throws UserStoreException {
        try {
            return AccessController.doPrivileged(() -> this.authenticateInternalIterationWithID(preferredUserNameClaim, preferredUserNameValue, credential, profileName, domainProvided));
        }
        catch (PrivilegedActionException e) {
            throw (UserStoreException)((Object)e.getException());
        }
    }

    private AuthenticationResult authenticateInternalIterationWithID(String preferredUserNameClaim, String preferredUserNameValue, Object credential, String profileName, boolean domainProvided) throws UserStoreException {
        ArrayList<String> userStorePreferenceOrder = new ArrayList<String>();
        if (this.isUserStoreChainNeeded(userStorePreferenceOrder)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User store chain generation is needed hence generating the user store chain using the user store preference order: " + userStorePreferenceOrder));
            }
            return this.generateUserStoreChainWithID(preferredUserNameClaim, preferredUserNameValue, credential, profileName, domainProvided, userStorePreferenceOrder);
        }
        return this.authenticateInternalWithID(preferredUserNameClaim, preferredUserNameValue, credential, profileName, domainProvided);
    }

    private AuthenticationResult generateUserStoreChainWithID(String preferredUserNameClaim, String preferredUserNameValue, Object credential, String profileName, boolean domainProvided, List<String> userStorePreferenceOrder) throws UserStoreException {
        if (domainProvided) {
            String providedDomainName = this.getUserStore(preferredUserNameValue).getDomainName();
            if (!userStorePreferenceOrder.contains(providedDomainName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Authentication failure. Invalid username or password is provided.");
                }
                this.handleOnAuthenticateFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), "Authentication failed"), preferredUserNameValue, credential);
                throw new UserStoreException("Authentication failed. Invalid username or password.");
            }
            UserStoreManager userStoreManager = this.getSecondaryUserStoreManager(providedDomainName);
            if (!(userStoreManager instanceof AbstractUserStoreManager)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"UserStoreManager is not an instance of AbstractUserStoreManager. Hence authenticate the user through all the available user store list.");
                }
                return this.authenticateInternalWithID(preferredUserNameClaim, preferredUserNameValue, credential, profileName, domainProvided);
            }
            IterativeUserStoreManager iterativeUserStoreManager = new IterativeUserStoreManager((AbstractUserStoreManager)userStoreManager);
            return iterativeUserStoreManager.authenticateWithID(preferredUserNameClaim, preferredUserNameValue, credential, profileName);
        }
        AbstractUserStoreManager initialUserStoreManager = null;
        IterativeUserStoreManager prevUserStoreManager = null;
        for (String domainName : userStorePreferenceOrder) {
            UserStoreManager userStoreManager = this.getSecondaryUserStoreManager(domainName);
            if (userStoreManager instanceof AbstractUserStoreManager) {
                if (initialUserStoreManager == null) {
                    prevUserStoreManager = new IterativeUserStoreManager((AbstractUserStoreManager)userStoreManager);
                    initialUserStoreManager = prevUserStoreManager;
                    continue;
                }
                IterativeUserStoreManager currentUserStoreManager = new IterativeUserStoreManager((AbstractUserStoreManager)userStoreManager);
                prevUserStoreManager.setNextUserStoreManager(currentUserStoreManager);
                prevUserStoreManager = currentUserStoreManager;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"UserStoreManager is not an instance of AbstractUserStoreManager hence authenticate the user through all the available user store list.");
            }
            return this.authenticateInternalWithID(preferredUserNameClaim, preferredUserNameValue, credential, profileName, domainProvided);
        }
        return initialUserStoreManager.authenticateWithID(preferredUserNameClaim, preferredUserNameValue, credential, profileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthenticationResult authenticateInternalWithID(String preferredUserNameClaim, String preferredUserNameValue, Object credential, String profileName, boolean domainProvided) throws UserStoreException {
        Secret credentialObj;
        AbstractUserStoreManager abstractUserStoreManager = this;
        if (this instanceof IterativeUserStoreManager) {
            abstractUserStoreManager = ((IterativeUserStoreManager)this).getAbstractUserStoreManager();
        }
        boolean authenticated = false;
        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
        UserStore userStore = abstractUserStoreManager.getUserStore(preferredUserNameValue);
        if (userStore.isRecurssive() && userStore.getUserStoreManager() instanceof AbstractUserStoreManager) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).authenticateWithID(preferredUserNameClaim, userStore.getDomainFreeName(), credential, profileName);
        }
        try {
            credentialObj = Secret.getSecret((Object)credential);
        }
        catch (UnsupportedSecretTypeException e) {
            this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage(), preferredUserNameClaim, preferredUserNameValue, credential);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString(), e);
        }
        try {
            Object credentialArgument;
            Iterator<Object> e = UMListenerServiceComponent.getUserStoreManagerListeners().iterator();
            while (e.hasNext()) {
                UserStoreManagerListener userStoreManagerListener;
                credentialArgument = (userStoreManagerListener = e.next()) instanceof SecretHandleableListener ? credentialObj : credential;
                if (((AbstractUserStoreManagerListener)userStoreManagerListener).authenticateWithID(preferredUserNameClaim, preferredUserNameValue, credentialArgument, abstractUserStoreManager)) continue;
                this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), preferredUserNameClaim, preferredUserNameValue, credentialArgument);
                authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                authenticationResult.setFailureReason(new FailureReason(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage()));
                AuthenticationResult authenticationResult2 = authenticationResult;
                return authenticationResult2;
            }
            try {
                e = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
                while (e.hasNext()) {
                    UserOperationEventListener userOperationEventListener;
                    credentialArgument = (userOperationEventListener = (UserOperationEventListener)e.next()) instanceof SecretHandleableListener ? credentialObj : credential;
                    if (((AbstractUserOperationEventListener)userOperationEventListener).doPreAuthenticateWithID(preferredUserNameClaim, preferredUserNameValue, credentialArgument, abstractUserStoreManager)) continue;
                    this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), "Pre-listener tasks failed"), preferredUserNameClaim, preferredUserNameValue, credentialArgument);
                    authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                    authenticationResult.setFailureReason(new FailureReason(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage()));
                    AuthenticationResult authenticationResult3 = authenticationResult;
                    return authenticationResult3;
                }
            }
            catch (UserStoreException ex) {
                this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), ex.getMessage()), preferredUserNameClaim, preferredUserNameValue, credential);
                throw ex;
            }
            int tenantId = abstractUserStoreManager.getTenantId();
            try {
                boolean tenantActive;
                RealmService realmService = UserCoreUtil.getRealmService();
                if (realmService != null && !(tenantActive = realmService.getTenantManager().isTenantActive(tenantId))) {
                    String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_TENANT_DEACTIVATED.getCode();
                    String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_TENANT_DEACTIVATED.getMessage(), tenantId);
                    log.warn((Object)(errorCode + " - " + errorMessage));
                    this.handleOnAuthenticateFailureWithID(errorCode, errorMessage, preferredUserNameClaim, preferredUserNameValue, credential);
                    authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                    authenticationResult.setFailureReason(new FailureReason(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_TENANT_DEACTIVATED.getMessage()));
                    AuthenticationResult authenticationResult4 = authenticationResult;
                    return authenticationResult4;
                }
            }
            catch (org.wso2.carbon.user.api.UserStoreException userStoreException) {
                this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), userStoreException.getMessage()), preferredUserNameClaim, preferredUserNameValue, credential);
                throw new UserStoreException("Error while trying to check tenant status for Tenant : " + tenantId, userStoreException);
            }
            try {
                String string = this.claimManager.getAttributeName(this.getMyDomainName(), preferredUserNameClaim);
                if (abstractUserStoreManager.isUniqueUserIdEnabled()) {
                    authenticationResult = abstractUserStoreManager.doAuthenticateWithID(string, preferredUserNameValue, credentialObj, profileName);
                } else {
                    List<String> users = this.doGetUserList(preferredUserNameClaim, preferredUserNameValue, profileName, abstractUserStoreManager.getMyDomainName(), abstractUserStoreManager);
                    if (users.size() != 1) {
                        String message = "Users count matching to claim: " + preferredUserNameClaim + " and value: " + preferredUserNameValue + " is: " + users.size();
                        authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                        authenticationResult.setFailureReason(new FailureReason(message));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)message);
                        }
                    } else {
                        boolean status = abstractUserStoreManager.doAuthenticate(users.get(0), credentialObj);
                        authenticationResult = new AuthenticationResult(status ? AuthenticationResult.AuthenticationStatus.SUCCESS : AuthenticationResult.AuthenticationStatus.FAIL);
                        if (status) {
                            String userID = this.userUniqueIDManger.getUniqueId(users.get(0), this);
                            User user = this.userUniqueIDManger.getUser(userID, this);
                            authenticationResult.setAuthenticatedUser(user);
                        } else {
                            authenticationResult.setFailureReason(new FailureReason("Invalid credentials."));
                        }
                    }
                }
                if (authenticationResult.getAuthenticationStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
                    authenticated = true;
                }
            }
            catch (Exception exception) {
                this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), exception.getMessage()), preferredUserNameClaim, preferredUserNameValue, credential);
                if (exception instanceof UserStoreClientException) {
                    if (!log.isDebugEnabled()) throw (UserStoreClientException)((Object)exception);
                    log.debug((Object)("Error occurred while authenticating user: " + preferredUserNameValue), (Throwable)exception);
                    throw (UserStoreClientException)((Object)exception);
                }
                log.error((Object)("Error occurred while authenticating user: " + preferredUserNameValue), (Throwable)exception);
                authenticated = false;
            }
        }
        finally {
            credentialObj.clear();
        }
        if (authenticated) {
            UserCoreUtil.setDomainInThreadLocal(UserCoreUtil.getDomainName(abstractUserStoreManager.realmConfig));
        }
        if (!authenticated && !domainProvided) {
            AbstractUserStoreManager userStoreManager;
            if (this instanceof IterativeUserStoreManager) {
                IterativeUserStoreManager iterativeUserStoreManager = (IterativeUserStoreManager)this;
                userStoreManager = iterativeUserStoreManager.nextUserStoreManager();
            } else {
                userStoreManager = (AbstractUserStoreManager)abstractUserStoreManager.getSecondaryUserStoreManager();
            }
            if (userStoreManager != null) {
                authenticationResult = userStoreManager.authenticateWithID(preferredUserNameClaim, preferredUserNameValue, credential, profileName, domainProvided);
            }
        }
        if (!authenticated) {
            this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), "Authentication failed"), preferredUserNameClaim, preferredUserNameValue, credential);
        }
        try {
            for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)userOperationEventListener).doPostAuthenticateWithID(preferredUserNameClaim, preferredUserNameValue, authenticationResult, abstractUserStoreManager)) continue;
                this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getMessage(), "Post-listener tasks failed"), preferredUserNameClaim, preferredUserNameValue, credential);
                authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                authenticationResult.setFailureReason(new FailureReason(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getMessage()));
                return authenticationResult;
            }
        }
        catch (UserStoreException ex) {
            this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getMessage(), ex.getMessage()), preferredUserNameClaim, preferredUserNameValue, credential);
            throw ex;
        }
        if (!log.isDebugEnabled()) return authenticationResult;
        if (authenticated) return authenticationResult;
        log.debug((Object)"Authentication failure. Wrong username or password is provided.");
        return authenticationResult;
    }

    @Override
    public final AuthenticationResult authenticateWithID(String userID, Object credential) throws UserStoreException {
        try {
            return AccessController.doPrivileged(() -> {
                if (!this.validateUserIDAndCredential(userID, credential)) {
                    AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
                    authenticationResult.setFailureReason(new FailureReason("Invalid Credentials"));
                    return authenticationResult;
                }
                ArrayList<String> userStorePreferenceOrder = new ArrayList<String>();
                if (this.isUserStoreChainNeeded(userStorePreferenceOrder)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("User store chain generation is needed hence generating the user store chain using the user store preference order: " + userStorePreferenceOrder));
                    }
                    return this.generateUserStoreChainWithID(userID, credential, userStorePreferenceOrder);
                }
                return this.authenticateInternalWithID(userID, credential);
            });
        }
        catch (PrivilegedActionException e) {
            if (!(e.getException() instanceof UserStoreException)) {
                this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), e.getMessage()), userID, credential);
            }
            throw (UserStoreException)((Object)e.getException());
        }
    }

    private AuthenticationResult generateUserStoreChainWithID(String userID, Object credential, List<String> userStorePreferenceOrder) throws UserStoreException {
        AbstractUserStoreManager initialUserStoreManager = null;
        IterativeUserStoreManager prevUserStoreManager = null;
        for (String domainName : userStorePreferenceOrder) {
            UserStoreManager userStoreManager = this.getSecondaryUserStoreManager(domainName);
            if (userStoreManager instanceof AbstractUserStoreManager) {
                if (initialUserStoreManager == null) {
                    prevUserStoreManager = new IterativeUserStoreManager((AbstractUserStoreManager)userStoreManager);
                    initialUserStoreManager = prevUserStoreManager;
                    continue;
                }
                IterativeUserStoreManager currentUserStoreManager = new IterativeUserStoreManager((AbstractUserStoreManager)userStoreManager);
                prevUserStoreManager.setNextUserStoreManager(currentUserStoreManager);
                prevUserStoreManager = currentUserStoreManager;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"UserStoreManager is not an instance of AbstractUserStoreManager hence authenticate the user through all the available user store list.");
            }
            return this.authenticateInternalWithID(userID, credential);
        }
        return initialUserStoreManager.authenticateWithID(userID, credential);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationResult authenticateInternalWithID(String userID, Object credential) throws UserStoreException {
        Secret credentialObj;
        UserStore userStoreWithID = this.getUserStoreWithID(userID);
        AbstractUserStoreManager abstractUserStoreManager = (AbstractUserStoreManager)userStoreWithID.getUserStoreManager();
        if (userStoreWithID.getUserStoreManager() instanceof IterativeUserStoreManager) {
            abstractUserStoreManager = ((IterativeUserStoreManager)userStoreWithID.getUserStoreManager()).getAbstractUserStoreManager();
        }
        boolean authenticated = false;
        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
        try {
            credentialObj = Secret.getSecret((Object)credential);
        }
        catch (UnsupportedSecretTypeException e) {
            this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage(), userID, credential);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString(), e);
        }
        try {
            Iterator<UserOperationEventListener> e = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
            while (e.hasNext()) {
                UserOperationEventListener listener;
                Object credentialArgument = (listener = e.next()) instanceof SecretHandleableListener ? credentialObj : credential;
                if (!((AbstractUserOperationEventListener)listener).doPreAuthenticateWithID(userID, credentialArgument, (UserStoreManager)abstractUserStoreManager)) {
                    this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), "Pre-listener tasks failed"), userID, credentialArgument);
                    authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                    authenticationResult.setFailureReason(new FailureReason(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage()));
                    AuthenticationResult authenticationResult2 = authenticationResult;
                    return authenticationResult2;
                }
                try {
                }
                catch (UserStoreException ex) {
                    this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), ex.getMessage()), userID, credential);
                    throw ex;
                }
            }
            int tenantId = abstractUserStoreManager.getTenantId();
            try {
                boolean tenantActive;
                RealmService realmService = UserCoreUtil.getRealmService();
                if (realmService != null && !(tenantActive = realmService.getTenantManager().isTenantActive(tenantId))) {
                    String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_TENANT_DEACTIVATED.getCode();
                    String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_TENANT_DEACTIVATED.getMessage(), tenantId);
                    log.warn((Object)(errorCode + " - " + errorMessage));
                    this.handleOnAuthenticateFailureWithID(errorCode, errorMessage, userID, credential);
                    authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                    authenticationResult.setFailureReason(new FailureReason("Inactive Tenant: " + tenantId));
                    AuthenticationResult authenticationResult3 = authenticationResult;
                    return authenticationResult3;
                }
            }
            catch (org.wso2.carbon.user.api.UserStoreException e2) {
                this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_AUTHENTICATION.getMessage(), e2.getMessage()), userID, credential);
                throw new UserStoreException("Error while trying to check tenant status for Tenant : " + tenantId, e2);
            }
            if (this.isUniqueUserIdEnabled(abstractUserStoreManager)) {
                authenticationResult = abstractUserStoreManager.doAuthenticateWithID(userID, credential);
            } else {
                User user = this.userUniqueIDManger.getUser(userID, abstractUserStoreManager);
                boolean status = abstractUserStoreManager.doAuthenticate(user.getUsername(), credential);
                if (status) {
                    authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.SUCCESS);
                    authenticationResult.setAuthenticatedUser(user);
                } else {
                    authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                    authenticationResult.setFailureReason(new FailureReason("Authentication failed for userID: " + userID));
                }
            }
            if (authenticationResult.getAuthenticationStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
                authenticated = true;
            }
            if (authenticated) {
                UserCoreUtil.setDomainInThreadLocal(userStoreWithID.getDomainName());
            }
        }
        finally {
            credentialObj.clear();
        }
        if (!authenticated) {
            this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_AUTHENTICATION.getMessage(), "Authentication failed"), userID, credential);
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPostAuthenticateWithID(userID, authenticationResult, (UserStoreManager)abstractUserStoreManager)) continue;
                this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getMessage(), "Post-listener tasks failed"), userID, credential);
                authenticationResult.setAuthenticationStatus(AuthenticationResult.AuthenticationStatus.FAIL);
                authenticationResult.setFailureReason(new FailureReason(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getMessage()));
                return authenticationResult;
            }
        }
        catch (UserStoreException ex) {
            this.handleOnAuthenticateFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_POST_AUTHENTICATION.getMessage(), ex.getMessage()), userID, credential);
            throw ex;
        }
        if (log.isDebugEnabled() && !authenticated) {
            log.debug((Object)"Authentication failure. Wrong userID or password is provided.");
        }
        return authenticationResult;
    }

    @Override
    public final List<User> listUsersWithID(String filter, int maxItemLimit) throws UserStoreException {
        List<User> userList;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, Integer.TYPE};
            Object object = this.callSecure("listUsersWithID", new Object[]{filter, maxItemLimit}, argTypes);
            return (List)object;
        }
        int index = filter.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index > 0) {
            String domain = filter.substring(0, index);
            UserStoreManager secManager = this.getSecondaryUserStoreManager(domain);
            if (secManager != null) {
                filter = filter.substring(index + 1);
                if (secManager instanceof AbstractUserStoreManager) {
                    List<User> userList2 = !this.isUniqueUserIdEnabled(secManager) ? this.userUniqueIDManger.listUsers(this.doListUsers(filter, maxItemLimit), this) : ((AbstractUserStoreManager)secManager).doListUsersWithID(filter, maxItemLimit);
                    this.handlePostGetUserListWithID(null, null, userList2, true);
                    return userList2;
                }
            }
        } else if (index == 0) {
            List<User> userList3 = !this.isUniqueUserIdEnabled() ? this.userUniqueIDManger.listUsers(this.doListUsers(filter.substring(1), maxItemLimit), this) : this.listUsersWithID(filter.substring(1), maxItemLimit);
            this.handlePostGetUserListWithID(null, null, userList3, true);
            return userList3;
        }
        try {
            userList = !this.isUniqueUserIdEnabled() ? this.userUniqueIDManger.listUsers(this.doListUsers(filter, maxItemLimit), this) : this.doListUsersWithID(filter, maxItemLimit);
        }
        catch (UserStoreException ex) {
            this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getMessage(), ex.getMessage()), null, null, null);
            throw ex;
        }
        String primaryDomain = this.realmConfig.getUserStoreProperty("DomainName");
        if (this.getSecondaryUserStoreManager() != null) {
            for (Map.Entry<String, UserStoreManager> entry : this.userStoreManagerHolder.entrySet()) {
                List<User> secondUserList;
                if (entry.getKey().equalsIgnoreCase(primaryDomain)) continue;
                UserStoreManager storeManager = entry.getValue();
                if (storeManager instanceof AbstractUserStoreManager) {
                    try {
                        secondUserList = !this.isUniqueUserIdEnabled(storeManager) ? this.userUniqueIDManger.listUsers(((AbstractUserStoreManager)storeManager).doListUsers(filter, maxItemLimit), this) : ((AbstractUserStoreManager)storeManager).doListUsersWithID(filter, maxItemLimit);
                        userList.addAll(secondUserList);
                    }
                    catch (UserStoreException ex) {
                        this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getMessage(), ex.getMessage()), null, null, null);
                        log.error((Object)ex);
                    }
                    continue;
                }
                secondUserList = ((UniqueIDUserStoreManager)storeManager).listUsersWithID(filter, maxItemLimit);
                userList.addAll(secondUserList);
            }
        }
        this.handlePostGetUserListWithID(null, null, userList, true);
        return userList;
    }

    @Override
    public User updateUserName(String userID, String newUserName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateUserName operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("updateUserName operation is not implemented in: " + this.getClass());
    }

    @Override
    public User getUserWithID(String userID, String[] requestedClaims, String profileName) throws UserStoreException {
        boolean isUserExists;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String[].class, String.class};
            Object object = this.callSecure("getUserWithID", new Object[]{userID, requestedClaims, profileName}, argTypes);
            return (User)object;
        }
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).getUserWithID(userStore.getDomainFreeUserId(), requestedClaims, profileName);
        }
        boolean isUniqueIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        User user = null;
        if (isUniqueIdEnabled) {
            isUserExists = this.doCheckExistingUserWithID(userID);
        } else {
            user = this.userUniqueIDManger.getUser(userID, this);
            boolean bl = isUserExists = user != null;
        }
        if (!isUserExists) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userID, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleGetUserFailureWithID(errorCode, errorMessage, userID, requestedClaims, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage, errorCode);
        }
        if (requestedClaims == null) {
            requestedClaims = new String[]{};
        }
        try {
            if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
                if (user == null) {
                    user = this.userUniqueIDManger.getUser(userID, this);
                }
            } else {
                user = this.getUserFromID(userID, requestedClaims, userStore.getDomainName(), profileName);
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_CLAIM_VALUES.getMessage(), ex.getMessage()), userID, requestedClaims, profileName);
            throw ex;
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (!(listener instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPostGetUserWithID(userID, requestedClaims, profileName, user, this)) continue;
                this.handleGetUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_IN_POST_GET_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_IN_POST_GET_CLAIM_VALUES.getMessage(), "Post-listener tasks failed"), userID, requestedClaims, profileName);
                break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_IN_POST_GET_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_IN_POST_GET_CLAIM_VALUES.getMessage(), ex.getMessage()), userID, requestedClaims, profileName);
            throw ex;
        }
        return user;
    }

    @Override
    public boolean isExistingUserWithID(String userID) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            Object object = this.callSecure("isExistingUserWithID", new Object[]{userID}, argTypes);
            return (Boolean)object;
        }
        if (UserCoreUtil.isRegistrySystemUser(userID)) {
            return true;
        }
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).isExistingUserWithID(userStore.getDomainFreeUserId());
        }
        if (userStore.isSystemStore()) {
            return this.systemUserRoleManager.isExistingSystemUser(userID);
        }
        if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
            User user = this.userUniqueIDManger.getUser(userID, this);
            if (user == null) {
                return false;
            }
            return this.doCheckExistingUser(user.getUsername());
        }
        return this.doCheckExistingUserWithID(userID);
    }

    @Override
    public List<String> getRoleListOfUserWithID(String userID) throws UserStoreException {
        List<String> roleNames;
        String[] roleListOfUserFromCache;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            Object object = this.callSecure("getRoleListOfUserWithID", new Object[]{userID}, argTypes);
            return (List)object;
        }
        if ("wso2.anonymous.user".equalsIgnoreCase(userID)) {
            return new ArrayList<String>(){
                {
                    this.add("system/wso2.anonymous.role");
                }
            };
        }
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).getRoleListOfUserWithID(userStore.getDomainFreeUserId());
        }
        String userName = this.getUserNameFromUserID(userID);
        if (StringUtils.isNotEmpty((String)userName) && (roleListOfUserFromCache = this.getRoleListOfUserFromCache(this.tenantId, userName)) != null && (roleNames = Arrays.asList(roleListOfUserFromCache)).size() > 0) {
            return roleNames;
        }
        if (userStore.isSystemStore()) {
            return Arrays.asList(this.systemUserRoleManager.getSystemRoleListOfUser(userStore.getDomainFreeUserId()));
        }
        if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
            if (StringUtils.isEmpty((String)userName)) {
                return Arrays.asList(this.realmConfig.getEveryOneRoleName());
            }
            return Arrays.asList(this.doGetRoleListOfUser(userName, QUERY_FILTER_STRING_ANY));
        }
        return this.doGetRoleListOfUserWithID(userID, QUERY_FILTER_STRING_ANY);
    }

    @Override
    public final List<User> getUserListOfRoleWithID(String roleName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            Object object = this.callSecure("getUserListOfRoleWithID", new Object[]{roleName}, argTypes);
            return (List)object;
        }
        return this.getUserListOfRoleWithID(roleName, QUERY_FILTER_STRING_ANY, -1);
    }

    @Override
    public final List<User> getUserListOfRoleWithID(String roleName, String filter, int maxItemLimit) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, Integer.TYPE};
            Object object = this.callSecure("getUserListOfRoleWithID", new Object[]{roleName, filter, maxItemLimit}, argTypes);
            return (List)object;
        }
        List<User> users = new ArrayList<User>();
        if (!this.isExistingRole(roleName)) {
            this.handleDoPostGetUserListOfRoleWithID(roleName, users);
            return users;
        }
        UserStore userStore = this.getUserStoreOfRoles(roleName);
        if (userStore.isRecurssive()) {
            UserStoreManager resolvedUserStoreManager = userStore.getUserStoreManager();
            if (resolvedUserStoreManager instanceof AbstractUserStoreManager) {
                return ((AbstractUserStoreManager)resolvedUserStoreManager).getUserListOfRoleWithID(userStore.getDomainFreeName(), filter, maxItemLimit);
            }
            return ((UniqueIDUserStoreManager)resolvedUserStoreManager).getUserListOfRoleWithID(userStore.getDomainFreeName());
        }
        if (userStore.isSystemStore()) {
            String[] userArray = this.systemUserRoleManager.getUserListOfSystemRole(userStore.getDomainFreeName());
            List<User> userList = UserCoreUtil.getUserList(userArray);
            this.handleDoPostGetUserListOfRoleWithID(roleName, userList);
            return userList;
        }
        if (userStore.isHybridRole()) {
            String[] userNamesInHybrid = "Internal".equalsIgnoreCase(userStore.getDomainName()) ? this.hybridRoleManager.getUserListOfHybridRole(userStore.getDomainFreeName()) : this.hybridRoleManager.getUserListOfHybridRole(userStore.getDomainAwareName());
            if (this.isRoleAndGroupSeparationEnabled()) {
                HashSet<String> userListOfGroups = new HashSet<String>();
                String[] groupsOfRole = "Internal".equalsIgnoreCase(userStore.getDomainName()) ? this.hybridRoleManager.getGroupListOfHybridRole(userStore.getDomainFreeName()) : this.hybridRoleManager.getGroupListOfHybridRole(userStore.getDomainAwareName());
                for (String group : groupsOfRole) {
                    userListOfGroups.addAll(Arrays.asList(this.getUserListOfRole(group, filter, maxItemLimit)));
                }
                userNamesInHybrid = UserCoreUtil.combine(userNamesInHybrid, new ArrayList<String>(userListOfGroups));
            }
            ArrayList<String> finalNameList = new ArrayList<String>();
            String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
            if (userNamesInHybrid != null && userNamesInHybrid.length > 0) {
                if (displayNameAttribute != null && displayNameAttribute.trim().length() > 0) {
                    for (String userName : userNamesInHybrid) {
                        String domainName = UserCoreUtil.extractDomainFromName(userName);
                        if (domainName == null || domainName.trim().length() == 0) {
                            finalNameList.add(userName);
                        }
                        UserStoreManager userManager = this.userStoreManagerHolder.get(domainName);
                        userName = UserCoreUtil.removeDomainFromName(userName);
                        if (userManager == null) continue;
                        String[] displayNames = userManager instanceof AbstractUserStoreManager ? ((AbstractUserStoreManager)userManager).doGetDisplayNamesForInternalRole(new String[]{userName}) : userManager.getRoleNames();
                        for (String displayName : displayNames) {
                            String nameWithDomain = UserCoreUtil.addDomainToName(displayName, domainName);
                            finalNameList.add(nameWithDomain);
                        }
                    }
                } else {
                    List<User> usersInHybrid = this.userUniqueIDManger.listUsers(userNamesInHybrid, this);
                    this.handleDoPostGetUserListOfRoleWithID(roleName, usersInHybrid);
                    return usersInHybrid;
                }
            }
            List<User> usersList = this.userUniqueIDManger.listUsers(finalNameList, this);
            this.handleDoPostGetUserListOfRoleWithID(roleName, usersList);
            return usersList;
        }
        if (this.readGroupsEnabled) {
            users = !this.isUniqueUserIdEnabledInUserStore(userStore) ? this.userUniqueIDManger.listUsers(this.doGetUserListOfRole(roleName, filter, maxItemLimit), this) : this.doGetUserListOfRoleWithID(roleName, filter, maxItemLimit);
            this.handleDoPostGetUserListOfRoleWithID(roleName, users);
        }
        return users;
    }

    @Override
    public final String getUserClaimValueWithID(String userID, String claim, String profileName) throws UserStoreException {
        Map<String, String> finalValues;
        boolean isUserExists;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            Object object = this.callSecure("getUserClaimValueWithID", new Object[]{userID, claim, profileName}, argTypes);
            return (String)object;
        }
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).getUserClaimValueWithID(userStore.getDomainFreeUserId(), claim, profileName);
        }
        boolean isUniqueIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        User user = null;
        if (isUniqueIdEnabled) {
            isUserExists = this.doCheckExistingUserWithID(userID);
        } else {
            user = this.userUniqueIDManger.getUser(userID, this);
            boolean bl = isUserExists = user != null;
        }
        if (!isUserExists) {
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userID, this.realmConfig.getUserStoreProperty("DomainName"));
            this.handleGetUserClaimValueFailureWithID(errorCode, errorMessage, userID, claim, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        try {
            finalValues = !isUniqueIdEnabled ? this.doGetUserClaimValues(user.getUsername(), new String[]{claim}, userStore.getDomainName(), profileName) : this.doGetUserClaimValuesWithID(userID, new String[]{claim}, userStore.getDomainName(), profileName);
        }
        catch (UserStoreException ex) {
            this.handleGetUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_CLAIM_VALUE.getMessage(), ex.getMessage()), userID, claim, profileName);
            throw ex;
        }
        String value = null;
        if (finalValues != null) {
            value = finalValues.get(claim);
        }
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            list.add(value);
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (!(listener instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPostGetUserClaimValueWithID(userID, claim, list, profileName, this)) continue;
                this.handleGetUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_CLAIM_VALUE.getMessage(), "Post-listener tasks failed"), userID, claim, profileName);
                break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_GET_USER_CLAIM_VALUE.getMessage(), ex.getMessage()), userID, claim, profileName);
            throw ex;
        }
        if (!list.isEmpty()) {
            return (String)list.get(0);
        }
        return value;
    }

    @Override
    public final Map<String, String> getUserClaimValuesWithID(String userID, String[] claims, String profileName) throws UserStoreException {
        Map<String, String> finalValues;
        boolean isUserExists;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String[].class, String.class};
            Object object = this.callSecure("getUserClaimValuesWithID", new Object[]{userID, claims, profileName}, argTypes);
            return (Map)object;
        }
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).getUserClaimValuesWithID(userStore.getDomainFreeUserId(), claims, profileName);
        }
        boolean isUniqueIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        User user = null;
        if (isUniqueIdEnabled) {
            isUserExists = this.doCheckExistingUserWithID(userID);
        } else {
            user = this.userUniqueIDManger.getUser(userID, this);
            boolean bl = isUserExists = user != null;
        }
        if (!isUserExists) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userID, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleGetUserClaimValuesFailureWithID(errorCode, errorMessage, userID, claims, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        if (claims == null) {
            claims = new String[]{};
        }
        try {
            finalValues = !isUniqueIdEnabled ? this.doGetUserClaimValues(user.getUsername(), claims, userStore.getDomainName(), profileName) : this.doGetUserClaimValuesWithID(userID, claims, userStore.getDomainName(), profileName);
        }
        catch (UserStoreException ex) {
            this.handleGetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_CLAIM_VALUES.getMessage(), ex.getMessage()), userID, claims, profileName);
            throw ex;
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                AbstractUserOperationEventListener newListener;
                if (!(listener instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPostGetUserClaimValuesWithID(userStore.getDomainFreeUserId(), claims, profileName, finalValues, this)) continue;
                this.handleGetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_IN_POST_GET_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_IN_POST_GET_CLAIM_VALUES.getMessage(), "Post-listener tasks failed"), userID, claims, profileName);
                break;
            }
        }
        catch (UserStoreException ex) {
            this.handleGetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_IN_POST_GET_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_IN_POST_GET_CLAIM_VALUES.getMessage(), ex.getMessage()), userID, claims, profileName);
            throw ex;
        }
        return finalValues;
    }

    @Override
    public final List<org.wso2.carbon.user.core.claim.Claim> getUserClaimValuesWithID(String userID, String profileName) throws UserStoreException {
        String[] claims;
        boolean isUserExists;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("getUserClaimValuesWithID", new Object[]{userID, profileName}, argTypes);
            return (List)object;
        }
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).getUserClaimValuesWithID(userStore.getDomainFreeUserId(), profileName);
        }
        boolean isUniqueIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        if (isUniqueIdEnabled) {
            isUserExists = this.doCheckExistingUserWithID(userID);
        } else {
            String userNameFromUserID = this.doGetUserNameFromUserID(userID);
            boolean bl = isUserExists = userNameFromUserID != null;
        }
        if (!isUserExists) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userID, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleGetUserClaimValuesFailureWithID(errorCode, errorMessage, userID, null, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        if (!isUniqueIdEnabled) {
            User user = this.userUniqueIDManger.getUser(userID, this);
            return Arrays.asList(this.getUserClaimValues(user.getDomainQualifiedUsername(), profileName));
        }
        if (StringUtils.isEmpty((String)profileName)) {
            profileName = "default";
        }
        try {
            claims = this.claimManager.getAllClaimUris();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            this.handleGetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_CLAIM_URI.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_CLAIM_URI.getMessage(), e.getMessage()), userID, null, profileName);
            throw new UserStoreException(e);
        }
        Map<String, String> values = this.doGetUserClaimValuesWithID(userID, claims, userStore.getDomainName(), profileName);
        ArrayList<org.wso2.carbon.user.core.claim.Claim> finalValues = new ArrayList<org.wso2.carbon.user.core.claim.Claim>();
        this.addClaimValues(values, finalValues);
        return finalValues;
    }

    protected Map<String, String> doGetUserClaimValuesWithID(String userID, String[] claims, String domainName, String profileName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String[].class, String.class, String.class};
            Object object = this.callSecure("doGetUserClaimValuesWithID", new Object[]{userID, claims, domainName, profileName}, argTypes);
            return (Map)object;
        }
        if (ArrayUtils.isEmpty((Object[])claims)) {
            return new HashMap<String, String>();
        }
        boolean requireRoles = false;
        boolean requireIntRoles = false;
        boolean requireExtRoles = false;
        String roleClaim = null;
        if (StringUtils.isEmpty((String)profileName)) {
            profileName = "default";
        }
        HashSet<String[]> propertySet = new HashSet<String[]>();
        for (String claim : claims) {
            String[] property;
            try {
                property = this.getClaimAtrribute(claim, userID, domainName);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            if (!(property == null || "http://wso2.org/claims/role".equalsIgnoreCase(claim) && "http://wso2.org/claims/role/internal".equalsIgnoreCase(claim) && "http://wso2.org/claims/role/external".equalsIgnoreCase(claim))) {
                propertySet.add(property);
            }
            if ("http://wso2.org/claims/role".equalsIgnoreCase(claim)) {
                requireRoles = true;
                roleClaim = claim;
                continue;
            }
            if ("http://wso2.org/claims/role/internal".equalsIgnoreCase(claim)) {
                requireIntRoles = true;
                roleClaim = claim;
                continue;
            }
            if (!"http://wso2.org/claims/role/external".equalsIgnoreCase(claim)) continue;
            requireExtRoles = true;
            roleClaim = claim;
        }
        String[] properties = propertySet.toArray(new String[0]);
        Map<String, String> userPropertyValues = this.getUserPropertyValuesWithID(userID, properties, profileName);
        this.processAttributesAfterRetrievalWithID(userID, userPropertyValues, profileName);
        ArrayList getAgain = new ArrayList();
        HashMap<String, String> finalValues = new HashMap<String, String>();
        for (String claim : claims) {
            String value;
            ClaimMapping mapping;
            try {
                mapping = (ClaimMapping)this.claimManager.getClaimMapping(claim);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            String property = null;
            if (mapping != null) {
                if (domainName != null) {
                    Map attrMap = mapping.getMappedAttributes();
                    if (attrMap != null) {
                        String attr = (String)attrMap.get(domainName.toUpperCase());
                        property = attr != null ? attr : mapping.getMappedAttribute();
                    }
                } else {
                    property = mapping.getMappedAttribute();
                }
                value = userPropertyValues.get(property);
                if (!StringUtils.isNotBlank((String)value)) continue;
                finalValues.put(claim, value);
                continue;
            }
            if (property == null && claim.equals(DISAPLAY_NAME_CLAIM)) {
                property = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
            }
            if (!StringUtils.isNotBlank((String)(value = userPropertyValues.get(property)))) continue;
            finalValues.put(claim, value);
        }
        if (getAgain.size() > 0) {
            Map<String, String> mapClaimValues = this.getUserClaimValuesWithID(userID, getAgain.toArray(new String[0]), profileName);
            for (Map.Entry<String, String> entry : mapClaimValues.entrySet()) {
                if (entry.getValue() == null) continue;
                finalValues.put(entry.getKey(), entry.getValue());
            }
        }
        List<String> roles = null;
        if (requireRoles) {
            roles = this.getRoleListOfUserWithID(userID);
        } else if (requireIntRoles) {
            roles = this.doGetInternalRoleListOfUserWithID(userID, QUERY_FILTER_STRING_ANY);
        } else if (requireExtRoles) {
            String[] sharedRoles;
            ArrayList<String> rolesList = new ArrayList<String>();
            String[] externalRoles = this.doGetExternalRoleListOfUserWithID(userID, QUERY_FILTER_STRING_ANY);
            rolesList.addAll(Arrays.asList(externalRoles));
            if (this.isSharedGroupEnabled() && (sharedRoles = this.doGetSharedRoleListOfUserWithID(userID, null, QUERY_FILTER_STRING_ANY)) != null) {
                rolesList.addAll(Arrays.asList(sharedRoles));
            }
            roles = rolesList;
        }
        if (roles != null && roles.size() > 0) {
            String userAttributeSeparator = ",";
            String claimSeparator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
            if (claimSeparator != null && !claimSeparator.trim().isEmpty()) {
                userAttributeSeparator = claimSeparator;
            }
            String delim = "";
            StringBuffer roleBf = new StringBuffer();
            for (String role : roles) {
                roleBf.append(delim).append(role);
                delim = userAttributeSeparator;
            }
            finalValues.put(roleClaim, roleBf.toString());
        }
        return finalValues;
    }

    private User getUserFromID(String userID, String[] requestedClaims, String domainName, String profileName) throws UserStoreException {
        User user = this.getUser(userID, null);
        if (ArrayUtils.isNotEmpty((Object[])requestedClaims)) {
            Map<String, String> claimValues = this.doGetUserClaimValuesWithID(userID, requestedClaims, domainName, profileName);
            user.setAttributes(claimValues);
        }
        return user;
    }

    private void addClaimValues(Map<String, String> values, List<org.wso2.carbon.user.core.claim.Claim> finalValues) throws UserStoreException {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String displayTag;
            org.wso2.carbon.user.core.claim.Claim claim = new org.wso2.carbon.user.core.claim.Claim();
            claim.setValue(entry.getValue());
            claim.setClaimUri(entry.getKey());
            try {
                displayTag = this.claimManager.getClaim(entry.getKey()).getDisplayTag();
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            claim.setDisplayTag(displayTag);
            finalValues.add(claim);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final void updateCredentialWithID(String userID, Object newCredential, Object oldCredential) throws UserStoreException {
        block30: {
            if (!AbstractUserStoreManager.isSecureCall.get().booleanValue()) {
                argTypes = new Class[]{String.class, Object.class, Object.class};
                this.callSecure("updateCredentialWithID", new Object[]{userID, newCredential, oldCredential}, argTypes);
                return;
            }
            userStore = this.getUserStoreWithID(userID);
            if (userStore.isRecurssive()) {
                ((AbstractUserStoreManager)userStore.getUserStoreManager()).updateCredentialWithID(userStore.getDomainFreeUserId(), newCredential, oldCredential);
                return;
            }
            if (this.isReadOnly()) {
                this.handleUpdateCredentialFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userID, newCredential, oldCredential);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
            }
            try {
                newCredentialObj = Secret.getSecret((Object)newCredential);
                oldCredentialObj = Secret.getSecret((Object)oldCredential);
            }
            catch (UnsupportedSecretTypeException e) {
                this.handleUpdateCredentialFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage(), userID, newCredential, oldCredential);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString());
            }
            try {
                for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                    if (listener instanceof AbstractUserOperationEventListener && !((AbstractUserOperationEventListener)listener).doPreUpdateCredentialWithID(userID, newCredential, oldCredential, this)) {
                        this.handleUpdateCredentialFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getMessage(), new Object[]{"Pre-listener tasks failed"}), userID, newCredential, oldCredential);
                        return;
                    }
                    try {
                    }
                    catch (UserStoreException e) {
                        this.handleUpdateCredentialFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getMessage(), new Object[]{e.getMessage()}), userID, newCredential, oldCredential);
                        throw e;
                    }
                }
                try {
                    authenticationResult = !this.isUniqueUserIdEnabledInUserStore(userStore) ? new AuthenticationResult((auth = this.doAuthenticate((user = this.userUniqueIDManger.getUser(userID, this)).getUsername(), oldCredentialObj)) != false ? AuthenticationResult.AuthenticationStatus.SUCCESS : AuthenticationResult.AuthenticationStatus.FAIL) : this.doAuthenticateWithID(userID, (Object)oldCredentialObj);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e) {
                    throw new UserStoreException(e);
                }
                if (authenticationResult.getAuthenticationStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
                    if (!this.checkUserPasswordValid(newCredential)) {
                        errorMsg = this.realmConfig.getUserStoreProperty("PasswordJavaRegExViolationErrorMsg");
                        if (errorMsg != null) {
                            errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getMessage(), new Object[]{errorMsg});
                            errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getCode();
                            this.handleUpdateCredentialFailureWithID(errorCode, errorMessage, userID, newCredential, oldCredential);
                            throw new UserStoreException(errorCode + " - " + errorMessage);
                        }
                        errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getMessage(), new Object[]{this.realmConfig.getUserStoreProperty("PasswordJavaRegEx")});
                        errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getCode();
                        this.handleUpdateCredentialFailureWithID(errorCode, errorMessage, userID, newCredential, oldCredential);
                        throw new UserStoreException(errorCode + " - " + errorMessage);
                    }
                    try {
                        if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
                            user = this.userUniqueIDManger.getUser(userID, this);
                            if (user == null) {
                                this.updateCredential(userID, newCredential, oldCredential);
                            } else {
                                this.updateCredential(user.getUsername(), newCredential, oldCredential);
                            }
                        } else {
                            this.doUpdateCredentialWithID(userID, newCredentialObj, oldCredentialObj);
                        }
                    }
                    catch (UserStoreException ex) {
                        this.handleUpdateCredentialFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_CREDENTIAL.getMessage(), new Object[]{ex.getMessage()}), userID, newCredential, oldCredential);
                        throw ex;
                    }
                    for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                        if (!(listener instanceof AbstractUserOperationEventListener) || ((AbstractUserOperationEventListener)listener).doPostUpdateCredentialWithID(userID, newCredential, this)) ** break block29
                        this.handleUpdateCredentialFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL.getMessage(), new Object[]{"Post update credential tasks failed"}), userID, newCredential, oldCredential);
                        return;
                    }
                    break block30;
                    {
                        try {
                            continue;
                        }
                        catch (UserStoreException ex) {
                            this.handleUpdateCredentialFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL.getMessage(), new Object[]{ex.getMessage()}), userID, newCredential, oldCredential);
                            throw ex;
                            break;
                        }
                    }
                }
                this.handleUpdateCredentialFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_OLD_CREDENTIAL_DOES_NOT_MATCH.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_OLD_CREDENTIAL_DOES_NOT_MATCH.getMessage(), userID, newCredential, oldCredential);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_OLD_CREDENTIAL_DOES_NOT_MATCH.toString());
            }
            finally {
                newCredentialObj.clear();
                oldCredentialObj.clear();
            }
        }
    }

    public User getUser(String userID, String userName) throws UserStoreException {
        if (userID == null && userName == null) {
            throw new UserStoreException("Both userID and UserName cannot be null.");
        }
        String domain = this.getMyDomainName();
        if (userID == null) {
            userID = this.getUserIDFromUserName(userName);
        }
        if (userName == null) {
            userName = this.getUserNameFromUserID(userID);
        }
        if (userName.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
            domain = UserCoreUtil.extractDomainFromName(userName);
            userName = UserCoreUtil.removeDomainFromName(userName);
        }
        User user = new User(userID, userName, userName);
        user.setTenantDomain(this.getTenantDomain(this.tenantId));
        user.setUserStoreDomain(domain);
        return user;
    }

    protected String getTenantDomain(int tenantID) throws UserStoreException {
        String tenantDomain;
        RealmService realmService = UserCoreUtil.getRealmService();
        try {
            tenantDomain = realmService != null ? realmService.getTenantManager().getDomain(tenantID) : CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException("Error occured while getting the tenant domain.", e);
        }
        return tenantDomain;
    }

    protected String getUniqueUserID() {
        return UUID.randomUUID().toString();
    }

    protected boolean isUserIdGeneratedByUserStore(String userName, Map<String, String> userAttributes) {
        return false;
    }

    public String getUserIDFromUserName(String userName) throws UserStoreException {
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).getUserIDFromUserName(userStore.getDomainFreeName());
        }
        userName = userStore.getDomainFreeName();
        String userID = this.getFromUserIDCache(userName, userStore);
        if (StringUtils.isEmpty((String)userID)) {
            if (this.isUniqueUserIdEnabledInUserStore(userStore)) {
                userID = this.doGetUserIDFromUserNameWithID(userName);
                this.addToUserIDCache(userID, userName, userStore);
                this.addToUserNameCache(userID, userName, userStore);
                return userID;
            }
            Map<String, String> claims = this.doGetUserClaimValues(userName, new String[]{"http://wso2.org/claims/userid"}, userStore.getDomainName(), null);
            if (claims != null && claims.size() == 1) {
                userID = claims.get("http://wso2.org/claims/userid");
                this.addToUserIDCache(userID, userName, userStore);
                this.addToUserNameCache(userID, userName, userStore);
                return userID;
            }
        }
        return userID;
    }

    protected String doGetUserIDFromUserNameWithID(String userName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doGetUserIDFromUserName operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doGetUserIDFromUserName operation is not implemented in: " + this.getClass());
    }

    protected String doGetUserNameFromUserID(String userID) throws UserStoreException {
        if (this.isUniqueUserIdEnabled()) {
            String userName = this.getFromUserNameCache(userID);
            if (StringUtils.isNotEmpty((String)userName)) {
                return UserCoreUtil.removeDomainFromName(userName);
            }
            return this.doGetUserNameFromUserIDWithID(userID);
        }
        User user = this.userUniqueIDManger.getUser(userID, this);
        return user.getUsername();
    }

    public String getUserNameFromUserID(String userID) throws UserStoreException {
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).getUserNameFromUserID(userStore.getDomainFreeUserId());
        }
        if (this.isUniqueUserIdEnabledInUserStore(userStore)) {
            return this.getUserNameFromCurrentUserStore(userID, userStore);
        }
        return this.userUniqueIDManger.getUser(userID, this).getDomainQualifiedUsername();
    }

    private String getUserNameFromCurrentUserStore(String userID, UserStore userStore) throws UserStoreException {
        String userName = this.getFromUserNameCache(userID);
        if (StringUtils.isEmpty((String)userName)) {
            userName = this.doGetUserNameFromUserIDWithID(userID);
            this.addToUserNameCache(userID, userName, userStore);
            this.addToUserIDCache(userID, userName, userStore);
        }
        return UserCoreUtil.addDomainToName(userName, userStore.getDomainName());
    }

    private String getFromUserNameCache(String userID) {
        return UserIdResolverCache.getInstance().getValueFromCache(userID, "user_name_from_user_id_cache", this.tenantId);
    }

    private String getFromUserIDCache(String userName, UserStore userStore) {
        return UserIdResolverCache.getInstance().getValueFromCache(UserCoreUtil.addDomainToName(userName, userStore.getDomainName()), "user_id_from_user_name_cache", this.tenantId);
    }

    private void addToUserIDCache(String userID, String userName, UserStore userStore) {
        UserIdResolverCache.getInstance().addToCache(UserCoreUtil.addDomainToName(userName, userStore.getDomainName()), userID, "user_id_from_user_name_cache", this.tenantId);
    }

    private void addToUserNameCache(String userID, String userName, UserStore userStore) {
        UserIdResolverCache.getInstance().addToCache(userID, UserCoreUtil.addDomainToName(userName, userStore.getDomainName()), "user_name_from_user_id_cache", this.tenantId);
    }

    private void clearUserIDResolverCache(String userID, String userName, UserStore userStore) {
        UserIdResolverCache.getInstance().clearCacheEntry(UserCoreUtil.addDomainToName(userName, userStore.getDomainName()), "user_id_from_user_name_cache", this.tenantId);
        UserIdResolverCache.getInstance().clearCacheEntry(userID, "user_name_from_user_id_cache", this.tenantId);
        UserIdResolverCache.getInstance().clearCacheEntry(UserCoreUtil.addDomainToName(userName, userStore.getDomainName()), "user_unique_id_from_user_name_cache", -1234);
        UserIdResolverCache.getInstance().clearCacheEntry(userID, "user_name_from_unique_user_id_cache", -1234);
    }

    private void addUsersToUserIdCache(List<User> userList) {
        UserIdResolverCache userIdResolverCacheInstance = UserIdResolverCache.getInstance();
        for (User user : userList) {
            userIdResolverCacheInstance.addToCache(UserCoreUtil.addDomainToName(user.getUsername(), user.getUserStoreDomain()), user.getUserID(), "user_id_from_user_name_cache", this.tenantId);
        }
    }

    private void addUsersToUserNameCache(List<User> userList) {
        UserIdResolverCache userIdResolverCacheInstance = UserIdResolverCache.getInstance();
        for (User user : userList) {
            userIdResolverCacheInstance.addToCache(user.getUserID(), UserCoreUtil.addDomainToName(user.getUsername(), user.getUserStoreDomain()), "user_name_from_user_id_cache", this.tenantId);
        }
    }

    protected String doGetUserNameFromUserIDWithID(String userID) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doGetUserNameFromUserIDWithID operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("doGetUserNameFromUserIDWithID operation is not implemented in: " + this.getClass());
    }

    public List<String> getUserNamesFromUserIDs(List<String> userIDs) throws UserStoreException {
        ArrayList<String> userNames = new ArrayList<String>();
        for (String userID : userIDs) {
            userNames.add(this.getUserNameFromUserID(userID));
        }
        return userNames;
    }

    public List<String> getUserIDsFromUserNames(List<String> userNames) throws UserStoreException {
        ArrayList<String> userIDs = new ArrayList<String>();
        for (String userName : userNames) {
            String userId = this.getUserIDFromUserName(userName);
            if (userId == null) {
                throw new UserStoreException("User " + userName + " does not exit in the system.");
            }
            userIDs.add(userId);
        }
        return userIDs;
    }

    public List<User> getUsersFromUserNames(List<String> userNamesList) throws UserStoreException {
        ArrayList<User> usersList = new ArrayList<User>();
        for (String userName : userNamesList) {
            String userID = this.getUserIDFromUserName(userName);
            User user = new User(userID, userName, userName);
            usersList.add(user);
        }
        return usersList;
    }

    public String getUserIDFromProperties(String claimURI, String claimValue, String profileName) throws UserStoreException {
        String domain = this.getMyDomainName();
        if (this.isUniqueUserIdEnabled()) {
            List<User> users = this.doGetUserListWithID(claimURI, claimValue, profileName, domain, this);
            if (users.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No userID found for the claim: " + claimURI + ", value: " + claimValue + ", in domain: " + this.getMyDomainName()));
                }
                return null;
            }
            if (users.size() > 1) {
                throw new UserStoreException("Invalid scenario. Multiple users cannot be found for the given value: " + claimValue + "of the claim: " + claimURI);
            }
            return users.get(0).getUserID();
        }
        List<String> userNames = this.doGetUserList(claimURI, claimValue, profileName, domain, this);
        if (userNames.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No userID found for the claim: " + claimURI + ", value: " + claimValue + ", in domain: " + this.getMyDomainName()));
            }
            return null;
        }
        if (userNames.size() > 1) {
            throw new UserStoreException("Invalid scenario. Multiple users cannot be found for the given value: " + claimValue + "of the claim: " + claimURI);
        }
        return this.userUniqueIDManger.getUniqueId(userNames.get(0), this);
    }

    protected List<User> getUsersFromIDs(List<String> userIDs, String[] claims, String domainName, String profileName) throws UserStoreException {
        ArrayList<User> users = new ArrayList<User>();
        for (String userID : userIDs) {
            users.add(this.getUserFromID(userID, claims, domainName, profileName));
        }
        return users;
    }

    protected String getUserNameMappedAttribute() throws UserStoreException {
        try {
            return this.claimManager.getAttributeName(this.getMyDomainName(), USERNAME_CLAIM_URI);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
    }

    protected Map<String, String> addUserNameAttribute(String userName, Map<String, String> claims) {
        if (claims == null) {
            claims = new HashMap<String, String>();
        }
        claims.put(USERNAME_CLAIM_URI, userName);
        return claims;
    }

    protected Map<String, String> addUserIDAttribute(String userID, Map<String, String> claims) {
        if (claims == null) {
            claims = new HashMap<String, String>();
        }
        claims.put("http://wso2.org/claims/userid", userID);
        return claims;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void deleteUserWithID(String userID) throws UserStoreException {
        void var6_13;
        String userName;
        String deletingUser;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            this.callSecure("deleteUserWithID", new Object[]{userID}, argTypes);
            return;
        }
        String loggedInUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
        if (loggedInUser != null && (loggedInUser = UserCoreUtil.addDomainToName(loggedInUser, UserCoreUtil.getDomainFromThreadLocal())).indexOf(UserCoreConstants.DOMAIN_SEPARATOR) < 0) {
            loggedInUser = "PRIMARY" + CarbonConstants.DOMAIN_SEPARATOR + loggedInUser;
        }
        if ((deletingUser = UserCoreUtil.addDomainToName(userID, this.getMyDomainName())).indexOf(UserCoreConstants.DOMAIN_SEPARATOR) < 0) {
            deletingUser = "PRIMARY" + CarbonConstants.DOMAIN_SEPARATOR + deletingUser;
        }
        if (loggedInUser != null && loggedInUser.equals(deletingUser)) {
            log.debug((Object)("User " + loggedInUser + " tried to delete him/her self"));
            this.handleDeleteUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_LOGGED_IN_USER.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_LOGGED_IN_USER.getMessage(), userID);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_LOGGED_IN_USER.toString());
        }
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            ((AbstractUserStoreManager)userStore.getUserStoreManager()).deleteUserWithID(userStore.getDomainFreeUserId());
            return;
        }
        if (UserCoreUtil.isPrimaryAdminUser(userID, this.realmConfig)) {
            this.handleDeleteUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_ADMIN_USER.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_ADMIN_USER.getMessage(), userID);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_ADMIN_USER.toString());
        }
        if (UserCoreUtil.isRegistryAnnonymousUser(userID)) {
            this.handleDeleteUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_ANONYMOUS_USER.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_ANONYMOUS_USER.getMessage(), userID);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DELETE_ANONYMOUS_USER.toString());
        }
        if (this.isReadOnly()) {
            this.handleDeleteUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userID);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        try {
            for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
                if (((AbstractUserStoreManagerListener)userStoreManagerListener).deleteUserWithID(userID, this)) continue;
                this.handleDeleteUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER.getMessage(), "Pre-listener tasks failed"), userID);
                return;
            }
            for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)userOperationEventListener).doPreDeleteUserWithID(userID, this)) continue;
                this.handleDeleteUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER.getMessage(), "Pre-listener tasks failed"), userID);
                return;
            }
        }
        catch (UserStoreException e) {
            this.handleDeleteUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER.getMessage(), e.getMessage()), userID);
            throw e;
        }
        User user = null;
        if (this.isUniqueUserIdEnabledInUserStore(userStore)) {
            userName = this.doGetUserNameFromUserID(userID);
            boolean bl = userName != null;
        } else {
            user = this.userUniqueIDManger.getUser(userID, this);
            boolean bl = user != null;
            userName = user.getUsername();
        }
        if (var6_13 == false) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userID, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleDeleteUserFailureWithID(errorCode, errorMessage, userID);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        try {
            this.clearUserIDResolverCache(userID, userName, userStore);
            if (this.isUniqueUserIdEnabledInUserStore(userStore)) {
                this.hybridRoleManager.deleteUser(UserCoreUtil.addDomainToName(userName, this.getMyDomainName()));
                this.doDeleteUserWithID(userID);
            } else {
                this.hybridRoleManager.deleteUser(user.getDomainQualifiedUsername());
                this.doDeleteUser(userName);
            }
        }
        catch (UserStoreException e) {
            this.handleDeleteUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETING_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETING_USER.getMessage(), e.getMessage()), userID);
            throw e;
        }
        this.clearUserRolesCache(userName);
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPostDeleteUserWithID(userID, this)) continue;
                this.handleDeleteUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER.getMessage(), "Post-listener tasks failed"), userID);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER.getMessage(), ex.getMessage()), userID);
            throw ex;
        }
    }

    @Override
    public final void setUserClaimValueWithID(String userID, String claimURI, String claimValue, String profileName) throws UserStoreException {
        boolean isUserExists;
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            ((AbstractUserStoreManager)userStore.getUserStoreManager()).setUserClaimValueWithID(userStore.getDomainFreeUserId(), claimURI, claimValue, profileName);
            return;
        }
        boolean isUniqueIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        User user = null;
        if (isUniqueIdEnabled) {
            isUserExists = this.doCheckExistingUserWithID(userID);
        } else {
            user = this.userUniqueIDManger.getUser(userID, this);
            boolean bl = isUserExists = user != null;
        }
        if (!isUserExists) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userID, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleSetUserClaimValueFailureWithID(errorCode, errorMessage, userID, claimURI, claimValue, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPreSetUserClaimValueWithID(userID, claimURI, claimValue, profileName, this)) continue;
                this.handleSetUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUE.getMessage(), "Pre-listener tasks failed"), userID, claimURI, claimValue, profileName);
                return;
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUE.getMessage(), e.getMessage()), userID, claimURI, claimValue, profileName);
            throw e;
        }
        if (this.isReadOnly()) {
            this.handleSetUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userID, claimURI, claimValue, profileName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        try {
            if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
                this.doSetUserClaimValue(user.getUsername(), claimURI, claimValue, profileName);
            } else {
                this.doSetUserClaimValueWithID(userID, claimURI, claimValue, profileName);
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_SETTING_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_SETTING_USER_CLAIM_VALUE.getMessage(), e.getMessage()), userID, claimURI, claimValue, profileName);
            throw e;
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPostSetUserClaimValueWithID(userID, this)) continue;
                this.handleSetUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUE.getMessage(), "Post-listener tasks failed"), userID, claimURI, claimValue, profileName);
                return;
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUE.getMessage(), e.getMessage()), userID, claimURI, claimValue, profileName);
            throw e;
        }
    }

    @Override
    public final void setUserClaimValuesWithID(String userID, Map<String, String> claims, String profileName) throws UserStoreException {
        boolean isUserExists;
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            ((AbstractUserStoreManager)userStore.getUserStoreManager()).setUserClaimValuesWithID(userStore.getDomainFreeUserId(), claims, profileName);
            return;
        }
        boolean isUniqueIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        if (isUniqueIdEnabled) {
            isUserExists = this.doCheckExistingUserWithID(userID);
        } else {
            String userNameFromUserID = this.doGetUserNameFromUserID(userID);
            boolean bl = isUserExists = userNameFromUserID != null;
        }
        if (!isUserExists) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userID, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleSetUserClaimValuesFailureWithID(errorCode, errorMessage, userID, claims, profileName);
            throw new UserStoreException(errorCode + " - " + (String)errorMessage);
        }
        if (claims == null) {
            claims = new HashMap<String, String>();
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPreSetUserClaimValuesWithID(userID, claims, profileName, this)) continue;
                this.handleSetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUES.getMessage(), "Pre-listener tasks failed"), userID, claims, profileName);
                return;
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUES.getMessage(), e.getMessage()), userID, claims, profileName);
            throw e;
        }
        if (this.isReadOnly() && !claims.isEmpty()) {
            this.handleSetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userID, claims, profileName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        try {
            if (!this.isReadOnly()) {
                if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
                    User user = this.userUniqueIDManger.getUser(userID, this);
                    this.doSetUserClaimValues(user.getUsername(), claims, profileName);
                } else {
                    this.doSetUserClaimValuesWithID(userID, claims, profileName);
                }
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_SETTING_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_SETTING_USER_CLAIM_VALUES.getMessage(), e.getMessage()), userID, claims, profileName);
            throw e;
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPostSetUserClaimValuesWithID(userID, claims, profileName, this)) continue;
                this.handleSetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUES.getMessage(), "Post-listener tasks failed"), userID, claims, profileName);
                return;
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUES.getMessage(), e.getMessage()), userID, claims, profileName);
            throw e;
        }
    }

    @Override
    public final void setUserClaimValuesWithID(String userID, Map<String, List<String>> oldClaimMap, Map<String, List<String>> multiValuedClaimsToAdd, Map<String, List<String>> multiValuedClaimsToDelete, Map<String, List<String>> claimsExcludingMultiValuedClaims, String profileName) throws UserStoreException {
        boolean isUserExists;
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            ((AbstractUserStoreManager)userStore.getUserStoreManager()).setUserClaimValuesWithID(userStore.getDomainFreeUserId(), oldClaimMap, multiValuedClaimsToAdd, multiValuedClaimsToDelete, claimsExcludingMultiValuedClaims, profileName);
            return;
        }
        Map<String, String> claims = this.getModifiedClaims(oldClaimMap, multiValuedClaimsToAdd, multiValuedClaimsToDelete, claimsExcludingMultiValuedClaims);
        boolean isUniqueIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
        if (isUniqueIdEnabled) {
            isUserExists = this.doCheckExistingUserWithID(userID);
        } else {
            String userNameFromUserID = this.doGetUserNameFromUserID(userID);
            boolean bl = isUserExists = userNameFromUserID != null;
        }
        if (!isUserExists) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userID, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleSetUserClaimValuesFailureWithID(errorCode, errorMessage, userID, claims, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        this.invokeDoPreSetUserClaimsWithIDListeners(userID, claims, profileName);
        if (this.isReadOnly() && !claims.isEmpty()) {
            this.handleSetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userID, claims, profileName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        String separator = ",";
        if (StringUtils.isNotEmpty((String)this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR))) {
            separator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
        }
        if (claimsExcludingMultiValuedClaims != null) {
            for (Map.Entry<String, String> claim : claims.entrySet()) {
                claimsExcludingMultiValuedClaims.put(claim.getKey(), Arrays.asList(claim.getValue().split(separator)));
            }
        }
        claimsExcludingMultiValuedClaims.keySet().removeAll(multiValuedClaimsToAdd.keySet());
        claimsExcludingMultiValuedClaims.keySet().removeAll(multiValuedClaimsToDelete.keySet());
        try {
            if (!this.isReadOnly()) {
                if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
                    User user = this.userUniqueIDManger.getUser(userID, this);
                    this.doSetUserClaimValues(user.getUsername(), multiValuedClaimsToAdd, multiValuedClaimsToDelete, claimsExcludingMultiValuedClaims, profileName);
                } else {
                    this.doSetUserClaimValuesWithID(userID, multiValuedClaimsToAdd, multiValuedClaimsToDelete, claimsExcludingMultiValuedClaims, profileName);
                }
            }
        }
        catch (NotImplementedException e) {
            if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
                User user = this.userUniqueIDManger.getUser(userID, this);
                this.doSetUserClaimValues(user.getUsername(), claims, profileName);
            } else {
                this.doSetUserClaimValuesWithID(userID, claims, profileName);
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_SETTING_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_SETTING_USER_CLAIM_VALUES.getMessage(), e.getMessage()), userID, claims, profileName);
            throw e;
        }
        this.invokeDoPostSetUserClaimsWithIDListeners(userID, claims, profileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public final void updateCredentialByAdminWithID(String userID, Object newCredential) throws UserStoreException {
        block37: {
            if (!AbstractUserStoreManager.isSecureCall.get().booleanValue()) {
                argTypes = new Class[]{String.class, Object.class};
                this.callSecure("updateCredentialByAdminWithID", new Object[]{userID, newCredential}, argTypes);
                return;
            }
            userStore = this.getUserStoreWithID(userID);
            if (userStore.isRecurssive()) {
                ((AbstractUserStoreManager)userStore.getUserStoreManager()).updateCredentialByAdminWithID(userStore.getDomainFreeUserId(), newCredential);
                return;
            }
            if (this.isReadOnly()) {
                this.handleUpdateCredentialByAdminFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userID, newCredential);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
            }
            try {
                newCredentialObj = Secret.getSecret((Object)newCredential);
            }
            catch (UnsupportedSecretTypeException e) {
                this.handleUpdateCredentialByAdminFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage() + " " + e.getMessage(), userID, newCredential);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString(), e);
            }
            try {
                e = UMListenerServiceComponent.getUserStoreManagerListeners().iterator();
                while (e.hasNext()) {
                    credentialArgument /* !! */  = (listener = e.next()) instanceof SecretHandleableListener != false ? newCredentialObj : newCredential;
                    if (((AbstractUserStoreManagerListener)listener).updateCredentialByAdminWithID(userID, credentialArgument /* !! */ , this)) continue;
                    this.handleUpdateCredentialByAdminFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{"Pre-listener tasks failed"}), userID, credentialArgument /* !! */ );
                    return;
                }
                for (Object listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                    if (listener instanceof SecretHandleableListener) {
                        if (((AbstractUserOperationEventListener)listener).doPreUpdateCredentialByAdminWithID(userID, newCredentialObj, this)) continue;
                        this.handleUpdateCredentialByAdminFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{"Pre-listener tasks failed"}), userID, newCredentialObj);
                        return;
                    }
                    credBuff = null;
                    if (newCredential == null) {
                        credBuff = new StringBuffer();
                    } else if (newCredential instanceof String) {
                        credBuff = new StringBuffer((String)newCredential);
                    }
                    if (credBuff == null) continue;
                    if (!((AbstractUserOperationEventListener)listener).doPreUpdateCredentialByAdminWithID(userID, credBuff, this)) {
                        this.handleUpdateCredentialByAdminFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{"Pre-listener tasks failed"}), userID, credBuff);
                        return;
                    }
                    try {
                        newCredential = credBuff.toString();
                        newCredentialObj.clear();
                        try {
                            newCredentialObj = Secret.getSecret((Object)newCredential);
                        }
                        catch (UnsupportedSecretTypeException e) {
                            this.handleUpdateCredentialByAdminFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage() + " " + e.getMessage(), userID, newCredential);
                            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString(), e);
                        }
                    }
                    catch (UserStoreException ex) {
                        this.handleUpdateCredentialByAdminFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{ex.getMessage()}), userID, newCredential);
                        throw ex;
                    }
                }
                if (!this.checkUserPasswordValid(newCredential)) {
                    errorMsg = this.realmConfig.getUserStoreProperty("PasswordJavaRegExViolationErrorMsg");
                    if (errorMsg != null) {
                        errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getCode();
                        errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{errorMsg});
                        this.handleUpdateCredentialByAdminFailureWithID(errorCode, errorMessage, userID, newCredential);
                        throw new UserStoreException(errorCode + " - " + errorMessage);
                    }
                    errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getCode();
                    errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getMessage(), new Object[]{this.realmConfig.getUserStoreProperty("PasswordJavaRegEx")});
                    this.handleUpdateCredentialByAdminFailureWithID(errorCode, errorMessage, userID, newCredential);
                    throw new UserStoreException(errorCode + " - " + errorMessage);
                }
                isUniqueIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
                if (isUniqueIdEnabled) {
                    isUserExists = this.doCheckExistingUserWithID(userID);
                } else {
                    userNameFromUserID = this.doGetUserNameFromUserID(userID);
                    v0 = isUserExists = userNameFromUserID != null;
                }
                if (!isUserExists) {
                    errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), new Object[]{userID, this.realmConfig.getUserStoreProperty("DomainName")});
                    errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
                    this.handleUpdateCredentialByAdminFailureWithID(errorCode, errorMessage, userID, newCredential);
                    throw new UserStoreException(errorCode + "-" + errorMessage);
                }
                try {
                    if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
                        user = this.userUniqueIDManger.getUser(userID, this);
                        this.doUpdateCredentialByAdmin(user.getUsername(), newCredential);
                    } else {
                        this.doUpdateCredentialByAdminWithID(userID, newCredentialObj);
                    }
                }
                catch (UserStoreException ex) {
                    this.handleUpdateCredentialByAdminFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{ex.getMessage()}), userID, newCredentialObj);
                    throw ex;
                }
                ex = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
                while (ex.hasNext()) {
                    credentialArgument /* !! */  = (listener = ex.next()) instanceof SecretHandleableListener != false ? newCredentialObj : newCredential;
                    if (((AbstractUserOperationEventListener)listener).doPostUpdateCredentialByAdminWithID(userID, credentialArgument /* !! */ , this)) ** break block36
                    this.handleUpdateCredentialByAdminFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{"Post-listener tasks failed"}), userID, newCredential);
                    return;
                }
                break block37;
                {
                    try {
                        continue;
                    }
                    catch (UserStoreException ex) {
                        this.handleUpdateCredentialByAdminFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_CREDENTIAL_BY_ADMIN.getMessage(), new Object[]{ex.getMessage()}), userID, newCredential);
                        throw ex;
                        break;
                    }
                }
            }
            finally {
                newCredentialObj.clear();
            }
        }
    }

    @Override
    public final void deleteUserClaimValueWithID(String userID, String claimURI, String profileName) throws UserStoreException {
        boolean isUserEixisting;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            this.callSecure("deleteUserClaimValueWithID", new Object[]{userID, claimURI, profileName}, argTypes);
            return;
        }
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            ((AbstractUserStoreManager)userStore.getUserStoreManager()).deleteUserClaimValueWithID(userStore.getDomainFreeUserId(), claimURI, profileName);
            return;
        }
        if (this.isReadOnly()) {
            this.handleDeleteUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userID, claimURI, profileName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        User user = null;
        if (this.isUniqueUserIdEnabledInUserStore(userStore)) {
            isUserEixisting = this.doCheckExistingUserWithID(userID);
        } else {
            user = this.userUniqueIDManger.getUser(userID, this);
            boolean bl = isUserEixisting = user != null;
        }
        if (!isUserEixisting) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userID, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleDeleteUserClaimValueFailureWithID(errorCode, errorMessage, userID, claimURI, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPreDeleteUserClaimValueWithID(userID, claimURI, profileName, this)) continue;
                this.handleDeleteUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUE.getMessage(), "Pre-listener tasks failed"), userID, claimURI, profileName);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUE.getMessage(), ex.getMessage()), userID, claimURI, profileName);
            throw ex;
        }
        try {
            if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
                this.doDeleteUserClaimValue(user.getUsername(), claimURI, profileName);
            } else {
                this.doDeleteUserClaimValueWithID(userID, claimURI, profileName);
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETING_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETING_USER_CLAIM_VALUE.getMessage(), ex.getMessage()), userID, claimURI, profileName);
            throw ex;
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPostDeleteUserClaimValueWithID(userID, this)) continue;
                this.handleDeleteUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUE.getMessage(), "Post-listener tasks failed"), userID, claimURI, profileName);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserClaimValueFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUE.getMessage(), ex.getMessage()), userID, claimURI, profileName);
            throw ex;
        }
    }

    @Override
    public final void deleteUserClaimValuesWithID(String userID, String[] claims, String profileName) throws UserStoreException {
        boolean isUserExisting;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String[].class, String.class};
            this.callSecure("deleteUserClaimValuesWithID", new Object[]{userID, claims, profileName}, argTypes);
            return;
        }
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            ((AbstractUserStoreManager)userStore.getUserStoreManager()).deleteUserClaimValuesWithID(userStore.getDomainFreeUserId(), claims, profileName);
            return;
        }
        if (this.isReadOnly()) {
            this.handleDeleteUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userID, claims, profileName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        User user = null;
        if (this.isUniqueUserIdEnabledInUserStore(userStore)) {
            isUserExisting = this.doCheckExistingUserWithID(userID);
        } else {
            user = this.userUniqueIDManger.getUser(userID, this);
            boolean bl = isUserExisting = user != null;
        }
        if (!isUserExisting) {
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getMessage(), userID, this.realmConfig.getUserStoreProperty("DomainName"));
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode();
            this.handleDeleteUserClaimValuesFailureWithID(errorCode, errorMessage, userID, claims, profileName);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        if (claims == null) {
            claims = new String[]{};
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPreDeleteUserClaimValuesWithID(userID, claims, profileName, this)) continue;
                this.handleDeleteUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUES.getMessage(), "Pre-listener tasks failed"), userID, claims, profileName);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_DELETE_USER_CLAIM_VALUES.getMessage(), ex.getMessage()), userID, claims, profileName);
            throw ex;
        }
        try {
            if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
                this.doDeleteUserClaimValues(user.getUsername(), claims, profileName);
            } else {
                this.doDeleteUserClaimValuesWithID(userID, claims, profileName);
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETING_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_DELETING_USER_CLAIM_VALUES.getMessage(), ex.getMessage()), userID, claims, profileName);
            throw ex;
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPostDeleteUserClaimValuesWithID(userID, this)) continue;
                this.handleDeleteUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUES.getMessage(), "Post-listener tasks failed"), userID, claims, profileName);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleDeleteUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_DELETE_USER_CLAIM_VALUES.getMessage(), ex.getMessage()), userID, claims, profileName);
            throw ex;
        }
    }

    @Override
    public Date getPasswordExpirationTimeWithID(String userID) throws UserStoreException {
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive()) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).getPasswordExpirationTimeWithID(userStore.getDomainFreeUserId());
        }
        return null;
    }

    @Override
    public final void updateRoleListOfUserWithID(String userID, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        try {
            AccessController.doPrivileged(() -> {
                if (!this.isUniqueUserIdEnabled()) {
                    User user = this.userUniqueIDManger.getUser(userID, this);
                    if (user == null) {
                        throw new UserStoreException("User cannot be found.");
                    }
                    this.updateRoleListOfUserInternal(user.getDomainQualifiedUsername(), deletedRoles, newRoles);
                    return null;
                }
                this.updateRoleListOfUserInternalWithID(userID, deletedRoles, newRoles);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            if (!(e.getException() instanceof UserStoreException)) {
                this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_UPDATE_USERS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_UPDATE_USERS_OF_ROLE.getMessage(), e.getMessage()), userID, deletedRoles, newRoles);
            }
            throw (UserStoreException)((Object)e.getException());
        }
    }

    private final void updateRoleListOfUserInternalWithID(String userID, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        String username;
        String domain;
        UserStore userStore;
        String primaryDomain = this.realmConfig.getUserStoreProperty("DomainName");
        if (primaryDomain != null) {
            primaryDomain = primaryDomain + CarbonConstants.DOMAIN_SEPARATOR;
        }
        if (deletedRoles != null && deletedRoles.length > 0) {
            Arrays.sort(deletedRoles);
            if (UserCoreUtil.isPrimaryAdminUser(userID, this.realmConfig)) {
                for (int i = 0; i < deletedRoles.length; ++i) {
                    if (!deletedRoles[i].equalsIgnoreCase(this.realmConfig.getAdminRoleName()) && !(primaryDomain + deletedRoles[i]).equalsIgnoreCase(this.realmConfig.getAdminRoleName())) continue;
                    this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_REMOVE_ADMIN_ROLE_FROM_ADMIN.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_REMOVE_ADMIN_ROLE_FROM_ADMIN.getMessage(), userID, deletedRoles, newRoles);
                    throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_REMOVE_ADMIN_ROLE_FROM_ADMIN.toString());
                }
            }
        }
        if ((userStore = this.getUserStoreWithID(userID)).isRecurssive()) {
            ((AbstractUserStoreManager)userStore.getUserStoreManager()).updateRoleListOfUserWithID(userStore.getDomainFreeUserId(), UserCoreUtil.removeDomainFromNames(deletedRoles), UserCoreUtil.removeDomainFromNames(newRoles));
            return;
        }
        if (userStore.isSystemStore()) {
            this.systemUserRoleManager.updateSystemRoleListOfUser(userStore.getDomainAwareUserId(), UserCoreUtil.removeDomainFromNames(deletedRoles), UserCoreUtil.removeDomainFromNames(newRoles));
            return;
        }
        if (deletedRoles == null) {
            deletedRoles = new String[]{};
        }
        if (newRoles == null) {
            newRoles = new String[]{};
        }
        if (userID.indexOf(CarbonConstants.DOMAIN_SEPARATOR) > 0) {
            userID = userStore.getDomainFreeName();
            deletedRoles = UserCoreUtil.removeDomainFromNames(deletedRoles);
            newRoles = UserCoreUtil.removeDomainFromNames(newRoles);
        }
        ArrayList<String> internalRoleDel = new ArrayList<String>();
        ArrayList<String> internalRoleNew = new ArrayList<String>();
        ArrayList<String> roleDel = new ArrayList<String>();
        ArrayList<String> roleNew = new ArrayList<String>();
        ArrayList<String> internalRoleDelWithDomain = new ArrayList<String>();
        ArrayList<String> internalRoleNewWithDomain = new ArrayList<String>();
        if (deletedRoles != null && deletedRoles.length > 0) {
            for (String deleteRole : deletedRoles) {
                if (UserCoreUtil.isEveryoneRole(deleteRole, this.realmConfig)) {
                    this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getMessage(), userID, deletedRoles, newRoles);
                    throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.toString());
                }
                domain = null;
                int index1 = deleteRole.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
                if (index1 > 0) {
                    domain = deleteRole.substring(0, index1);
                }
                this.processDeletedRoles(internalRoleDel, roleDel, deleteRole, domain, internalRoleDelWithDomain);
            }
            deletedRoles = roleDel.toArray(new String[0]);
        }
        if (newRoles != null && newRoles.length > 0) {
            for (String newRole : newRoles) {
                if (UserCoreUtil.isEveryoneRole(newRole, this.realmConfig)) {
                    this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getMessage(), userID, deletedRoles, newRoles);
                    throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.toString());
                }
                domain = null;
                int index2 = newRole.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
                if (index2 > 0) {
                    domain = newRole.substring(0, index2);
                }
                this.processNewRoles(internalRoleNew, roleNew, newRole, domain, internalRoleNewWithDomain);
            }
            newRoles = roleNew.toArray(new String[0]);
        }
        boolean isPreUpdateInternalRoleListOfUserSuccess = true;
        boolean isPreUpdateRoleListOfUserSuccess = true;
        Object[] deletedInternalRolesArray = new String[]{};
        Object[] addInternalRolesArray = new String[]{};
        if (CollectionUtils.isNotEmpty(internalRoleDel) || CollectionUtils.isNotEmpty(internalRoleNew)) {
            deletedInternalRolesArray = internalRoleDel.toArray(new String[internalRoleDel.size()]);
            String[] deletedRolesArrayWithDomain = internalRoleDelWithDomain.toArray(new String[internalRoleDelWithDomain.size()]);
            addInternalRolesArray = internalRoleNew.toArray(new String[internalRoleNew.size()]);
            String[] addRolesArrayWithDomain = internalRoleNewWithDomain.toArray(new String[internalRoleNewWithDomain.size()]);
            isPreUpdateInternalRoleListOfUserSuccess = this.handlePreUpdateRoleListOfUserWithID(userID, deletedRolesArrayWithDomain, addRolesArrayWithDomain, false, true);
        }
        if (ArrayUtils.isNotEmpty((Object[])deletedRoles) || ArrayUtils.isNotEmpty((Object[])newRoles)) {
            isPreUpdateRoleListOfUserSuccess = this.handlePreUpdateRoleListOfUserWithID(userID, deletedRoles, newRoles, false, false);
        }
        if (!isPreUpdateInternalRoleListOfUserSuccess || !isPreUpdateRoleListOfUserSuccess) {
            this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_OF_USER.getMessage(), "Pre-listener tasks failed"), userID, deletedRoles, newRoles);
            return;
        }
        if (ArrayUtils.isNotEmpty((Object[])deletedInternalRolesArray) || ArrayUtils.isNotEmpty((Object[])addInternalRolesArray)) {
            this.hybridRoleManager.updateHybridRoleListOfUser(this.doGetUserNameFromUserID(userID), (String[])deletedInternalRolesArray, (String[])addInternalRolesArray);
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPreUpdateRoleListOfUserWithID(userID, deletedRoles, newRoles, this)) continue;
                this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_OF_USER.getMessage(), "Pre-listener tasks failed"), userID, deletedRoles, newRoles);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_OF_USER.getMessage(), ex.getMessage()), userID, deletedRoles, newRoles);
            throw ex;
        }
        if (deletedRoles != null && deletedRoles.length > 0 || newRoles != null && newRoles.length > 0) {
            if (!this.isReadOnly() && this.writeGroupsEnabled) {
                try {
                    if (this.isUniqueUserIdEnabledInUserStore(userStore)) {
                        this.doUpdateRoleListOfUserWithID(userID, deletedRoles, newRoles);
                    }
                    this.doUpdateRoleListOfUser(this.doGetUserNameFromUserID(userID), deletedRoles, newRoles);
                }
                catch (UserStoreException ex) {
                    this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_ROLE_OF_USER.getMessage(), ex.getMessage()), userID, deletedRoles, newRoles);
                    throw ex;
                }
            } else {
                this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userID, deletedRoles, newRoles);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
            }
        }
        if ((username = this.doGetUserNameFromUserID(userID)) != null) {
            this.clearUserRolesCache(username);
        }
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPostUpdateRoleListOfUserWithID(userID, deletedRoles, newRoles, this)) continue;
                this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_ROLE_OF_USER.getMessage(), "Post-listener tasks failed"), userID, deletedRoles, newRoles);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_UPDATE_ROLE_OF_USER.getMessage(), ex.getMessage()), userID, deletedRoles, newRoles);
            throw ex;
        }
    }

    private boolean handlePreUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers, boolean isAuditLogOnly, boolean isInternalRole) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                boolean success;
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger") || (success = isInternalRole && listener instanceof AbstractUserOperationEventListener ? ((AbstractUserOperationEventListener)listener).doPreUpdateUserListOfInternalRole(roleName, deletedUsers, newUsers, this) : (isInternalRole ? true : listener.doPreUpdateUserListOfRole(roleName, deletedUsers, newUsers, this)))) continue;
                return false;
            }
        }
        catch (UserStoreException ex) {
            this.handleUpdateUserListOfRoleFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_UPDATE_USERS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_UPDATE_USERS_OF_ROLE.getMessage(), ex.getMessage()), roleName, deletedUsers, newUsers);
            throw ex;
        }
        return true;
    }

    private boolean handlePreUpdateUserListOfRoleWithID(String roleName, String[] deletedUsersIDs, String[] newUsersIDs, boolean isAuditLogOnly, boolean isInternalRole) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                boolean success;
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger") || (success = isInternalRole && listener instanceof AbstractUserOperationEventListener ? ((AbstractUserOperationEventListener)listener).doPreUpdateUserListOfInternalRoleWithID(roleName, deletedUsersIDs, newUsersIDs, this) : (isInternalRole ? true : ((AbstractUserOperationEventListener)listener).doPreUpdateUserListOfRoleWithID(roleName, deletedUsersIDs, newUsersIDs, this)))) continue;
                return false;
            }
        }
        catch (UserStoreException ex) {
            this.handleUpdateUserListOfRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_UPDATE_USERS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_UPDATE_USERS_OF_ROLE.getMessage(), ex.getMessage()), roleName, deletedUsersIDs, newUsersIDs);
            throw ex;
        }
        return true;
    }

    private boolean handlePreUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles, boolean isAuditLogOnly, boolean isInternalRole) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                boolean success;
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger") || (success = isInternalRole && listener instanceof AbstractUserOperationEventListener ? ((AbstractUserOperationEventListener)listener).doPreUpdateInternalRoleListOfUser(userName, deletedRoles, newRoles, this) : (isInternalRole ? true : listener.doPreUpdateRoleListOfUser(userName, deletedRoles, newRoles, this)))) continue;
                return false;
            }
        }
        catch (UserStoreException ex) {
            this.handleUpdateRoleListOfUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_OF_USER.getMessage(), ex.getMessage()), userName, deletedRoles, newRoles);
            throw ex;
        }
        return true;
    }

    private boolean handlePreUpdateRoleListOfUserWithID(String userID, String[] deletedRoles, String[] newRoles, boolean isAuditLogOnly, boolean isInternalRole) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger")) continue;
                boolean success = true;
                if (isInternalRole && listener instanceof AbstractUserOperationEventListener) {
                    success = ((AbstractUserOperationEventListener)listener).doPreUpdateInternalRoleListOfUserWithID(userID, deletedRoles, newRoles, this);
                } else if (isInternalRole) {
                    success = true;
                } else if (listener instanceof AbstractUserOperationEventListener) {
                    success = ((AbstractUserOperationEventListener)listener).doPreUpdateRoleListOfUserWithID(userID, deletedRoles, newRoles, this);
                }
                if (success) continue;
                return false;
            }
        }
        catch (UserStoreException ex) {
            this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_ROLE_OF_USER.getMessage(), ex.getMessage()), userID, deletedRoles, newRoles);
            throw ex;
        }
        return true;
    }

    private void processNewRoles(List<String> internalRoleNew, List<String> roleNew, String newRole, String domain, List<String> internalRoleNewWithDomain) throws UserStoreException {
        if ("Internal".equalsIgnoreCase(domain)) {
            internalRoleNew.add(UserCoreUtil.removeDomainFromName(newRole));
            internalRoleNewWithDomain.add(newRole);
        } else if (APPLICATION_DOMAIN.equalsIgnoreCase(domain) || WORKFLOW_DOMAIN.equalsIgnoreCase(domain)) {
            internalRoleNew.add(newRole);
            internalRoleNewWithDomain.add(newRole);
        } else if (this.isReadOnly()) {
            internalRoleNew.add(UserCoreUtil.removeDomainFromName(newRole));
            internalRoleNewWithDomain.add(newRole);
        } else {
            roleNew.add(UserCoreUtil.removeDomainFromName(newRole));
        }
    }

    private void processDeletedRoles(List<String> internalRoleDel, List<String> roleDel, String deleteRole, String domain, List<String> internalRoleDelWithDomain) throws UserStoreException {
        if (APPLICATION_DOMAIN.equalsIgnoreCase(domain) || WORKFLOW_DOMAIN.equalsIgnoreCase(domain)) {
            internalRoleDel.add(deleteRole);
            internalRoleDelWithDomain.add(deleteRole);
        } else if ("Internal".equalsIgnoreCase(domain) || this.isReadOnly()) {
            internalRoleDel.add(UserCoreUtil.removeDomainFromName(deleteRole));
            internalRoleDelWithDomain.add(deleteRole);
        } else {
            roleDel.add(UserCoreUtil.removeDomainFromName(deleteRole));
        }
    }

    @Override
    public final void updateUserListOfRoleWithID(String roleName, String[] deletedUserIDs, String[] newUserIDs) throws UserStoreException {
        try {
            AccessController.doPrivileged(() -> {
                UserStore userStore = this.getUserStore(roleName);
                if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
                    List<Object> deletedUsers = new ArrayList();
                    List<Object> newUsers = new ArrayList();
                    if (deletedUserIDs != null) {
                        deletedUsers = this.userUniqueIDManger.getUsers(Arrays.asList(deletedUserIDs), this);
                    }
                    if (newUserIDs != null) {
                        newUsers = this.userUniqueIDManger.getUsers(Arrays.asList(newUserIDs), this);
                    }
                    this.updateUserListOfRoleInternal(roleName, (String[])deletedUsers.stream().map(User::getDomainQualifiedUsername).toArray(String[]::new), (String[])newUsers.stream().map(User::getDomainQualifiedUsername).toArray(String[]::new));
                    return null;
                }
                this.updateUserListOfRoleInternalWithID(roleName, deletedUserIDs, newUserIDs);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            if (!(e.getException() instanceof UserStoreException)) {
                this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_ROLE_OF_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_UPDATING_ROLE_OF_USER.getMessage(), e.getMessage()), roleName, deletedUserIDs, newUserIDs);
            }
            throw (UserStoreException)((Object)e.getException());
        }
    }

    private final void updateUserListOfRoleInternalWithID(String roleName, String[] deletedUserIDs, String[] newUserIDs) throws UserStoreException {
        UserStore userStore;
        String primaryDomain;
        Object[] deletedUsernames = new String[]{};
        if (ArrayUtils.isNotEmpty((Object[])deletedUserIDs)) {
            List<String> deletedUsernameList = this.getUserNamesFromUserIDs(Arrays.asList(deletedUserIDs));
            deletedUsernames = deletedUsernameList.toArray(new String[0]);
        }
        String[] newUsernames = new String[]{};
        if (ArrayUtils.isNotEmpty((Object[])newUserIDs)) {
            List<String> newUsernameList = this.getUserNamesFromUserIDs(Arrays.asList(newUserIDs));
            newUsernames = newUsernameList.toArray(new String[0]);
        }
        if ((primaryDomain = this.getMyDomainName()) != null) {
            primaryDomain = primaryDomain + CarbonConstants.DOMAIN_SEPARATOR;
        }
        if (deletedUsernames.length > 0) {
            Arrays.sort(deletedUsernames);
            if (UserCoreUtil.isPrimaryAdminRole(roleName, this.realmConfig)) {
                for (int i = 0; i < deletedUsernames.length; ++i) {
                    if (!((String)deletedUsernames[i]).equalsIgnoreCase(this.realmConfig.getAdminUserName()) && !(primaryDomain + (String)deletedUsernames[i]).equalsIgnoreCase(this.realmConfig.getAdminUserName())) continue;
                    this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_REMOVE_ADMIN_ROLE_FROM_ADMIN.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_REMOVE_ADMIN_ROLE_FROM_ADMIN.getMessage(), roleName, deletedUserIDs, newUserIDs);
                    throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_REMOVE_ADMIN_ROLE_FROM_ADMIN.toString());
                }
            }
        }
        if ((userStore = this.getUserStoreOfRoles(roleName)).isHybridRole()) {
            if (UserCoreUtil.isEveryoneRole(roleName, this.realmConfig)) {
                this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.getMessage(), roleName, deletedUserIDs, newUserIDs);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_UPDATE_EVERYONE_ROLE.toString());
            }
            if (!this.handlePreUpdateUserListOfRoleWithID(roleName, deletedUserIDs, newUserIDs, false, true)) {
                this.handleUpdateUserListOfRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_UPDATE_USERS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_UPDATE_USERS_OF_ROLE.getMessage(), "Pre-listener tasks failed"), roleName, deletedUserIDs, newUserIDs);
                return;
            }
            if ("Internal".equalsIgnoreCase(userStore.getDomainName())) {
                this.hybridRoleManager.updateUserListOfHybridRole(userStore.getDomainFreeName(), (String[])deletedUsernames, newUsernames);
                this.handleDoPostUpdateUserListOfRoleWithID(roleName, deletedUserIDs, newUserIDs, true);
            } else {
                this.hybridRoleManager.updateUserListOfHybridRole(userStore.getDomainAwareName(), (String[])deletedUsernames, newUsernames);
                this.handleDoPostUpdateUserListOfRoleWithID(roleName, deletedUserIDs, newUserIDs, true);
            }
            this.clearUserRolesCacheByTenant(this.tenantId);
            return;
        }
        if (userStore.isSystemStore()) {
            this.systemUserRoleManager.updateUserListOfSystemRole(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames((String[])deletedUsernames), UserCoreUtil.removeDomainFromNames(newUsernames));
            this.handleDoPostUpdateUserListOfRoleWithID(roleName, deletedUserIDs, newUserIDs, true);
            return;
        }
        if (userStore.isRecurssive()) {
            ((AbstractUserStoreManager)userStore.getUserStoreManager()).updateUserListOfRoleWithID(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedUserIDs), UserCoreUtil.removeDomainFromNames(newUserIDs));
            return;
        }
        if (deletedUserIDs == null) {
            deletedUserIDs = new String[]{};
        }
        if (newUserIDs == null) {
            newUserIDs = new String[]{};
        }
        if (!this.handlePreUpdateUserListOfRoleWithID(roleName, deletedUserIDs, newUserIDs, false, false)) {
            this.handleUpdateUserListOfRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_UPDATE_USERS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_PRE_UPDATE_USERS_OF_ROLE.getMessage(), "Pre-listener tasks failed"), roleName, deletedUserIDs, newUserIDs);
            return;
        }
        if (deletedUserIDs.length > 0 || newUserIDs.length > 0) {
            if (!this.isReadOnly() && this.writeGroupsEnabled) {
                try {
                    this.doUpdateUserListOfRoleWithID(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(deletedUserIDs), UserCoreUtil.removeDomainFromNames(newUserIDs));
                }
                catch (UserStoreException ex) {
                    this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_UPDATE_USERS_OF_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_UPDATE_USERS_OF_ROLE.getMessage(), ex.getMessage()), roleName, deletedUserIDs, newUserIDs);
                    throw ex;
                }
            } else {
                this.handleUpdateRoleListOfUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), roleName, deletedUserIDs, newUserIDs);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
            }
        }
        this.clearUserRolesCacheByTenant(this.tenantId);
        this.handleDoPostUpdateUserListOfRoleWithID(roleName, deletedUserIDs, newUserIDs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final User addUserWithID(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        User user;
        Secret credentialObj;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, Object.class, String[].class, Map.class, String.class};
            Object object = this.callSecure("addUserWithID", new Object[]{userName, credential, roleList, claims, profileName}, argTypes);
            return (User)object;
        }
        if (StringUtils.isEmpty((String)userName)) {
            String message = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_USERNAME_CANNOT_BE_EMPTY.getMessage();
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_USERNAME_CANNOT_BE_EMPTY.getCode();
            this.handleAddUserFailureWithID(errorCode, message, null, credential, roleList, claims, profileName);
            throw new UserStoreException(errorCode + " - " + message, errorCode);
        }
        String userNameWithoutDomain = UserCoreUtil.removeDomainFromName(userName);
        if (claims != null && claims.containsKey(USERNAME_CLAIM_URI) && !claims.get(USERNAME_CLAIM_URI).equals(userNameWithoutDomain)) {
            throw new UserStoreException("Username and the username claim value should be same.");
        }
        UserStore userStore = this.getUserStore(userName);
        if (userStore.isRecurssive()) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).addUserWithID(userStore.getDomainFreeName(), credential, roleList, claims, profileName);
        }
        try {
            credentialObj = Secret.getSecret((Object)credential);
        }
        catch (UnsupportedSecretTypeException e) {
            this.handleAddUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage(), userName, credential, roleList, claims, profileName);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString(), e);
        }
        try {
            void var11_26;
            String errorCode;
            String regEx;
            Object credentialArgument;
            if (userStore.isSystemStore()) {
                this.systemUserRoleManager.addSystemUser(userName, credentialObj, roleList);
                User user2 = null;
                return user2;
            }
            if (this.isReadOnly()) {
                this.handleAddUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), userName, credential, roleList, claims, profileName);
                throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
            }
            if (userName.indexOf(CarbonConstants.DOMAIN_SEPARATOR) > 0) {
                userName = userStore.getDomainFreeName();
                roleList = UserCoreUtil.removeDomainFromNames(roleList);
            }
            if (roleList == null) {
                roleList = new String[]{};
            }
            if (claims == null) {
                claims = new HashMap<String, String>();
            }
            try {
                Iterator<UserStoreManagerListener> iterator = UMListenerServiceComponent.getUserStoreManagerListeners().iterator();
                while (iterator.hasNext()) {
                    UserStoreManagerListener userStoreManagerListener;
                    credentialArgument = (userStoreManagerListener = iterator.next()) instanceof SecretHandleableListener ? credentialObj : credential;
                    if (((AbstractUserStoreManagerListener)userStoreManagerListener).addUserWithID(userName, credentialArgument, roleList, claims, profileName, this)) continue;
                    this.handleAddUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getMessage(), "Pre-listener tasks failed"), userName, credential, roleList, claims, profileName);
                    User user3 = null;
                    return user3;
                }
            }
            catch (UserStoreException ex) {
                this.handleAddUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getMessage(), ex.getMessage()), userName, credential, roleList, claims, profileName);
                throw ex;
            }
            for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (userOperationEventListener instanceof SecretHandleableListener) {
                    try {
                        if (((AbstractUserOperationEventListener)userOperationEventListener).doPreAddUserWithID(userName, credentialObj, roleList, claims, profileName, this)) continue;
                        this.handleAddUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getMessage(), "Pre-listener tasks failed"), userName, credential, roleList, claims, profileName);
                        credentialArgument = null;
                        return credentialArgument;
                    }
                    catch (UserStoreException ex) {
                        String message = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getMessage(), ex.getMessage());
                        this.handleAddUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getCode(), message, userName, credential, roleList, claims, profileName);
                        throw ex;
                    }
                }
                StringBuffer credBuff = null;
                if (credential == null) {
                    credBuff = new StringBuffer();
                } else if (credential instanceof String) {
                    credBuff = new StringBuffer((String)credential);
                }
                if (credBuff == null) continue;
                try {
                    if (!((AbstractUserOperationEventListener)userOperationEventListener).doPreAddUserWithID(userName, credBuff, roleList, claims, profileName, this)) {
                        this.handleAddUserFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getMessage(), "Pre-listener tasks failed"), userName, credential, roleList, claims, profileName);
                        User message = null;
                        return message;
                    }
                }
                catch (UserStoreException e) {
                    this.handleAddUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_USER.getMessage(), e.getMessage()), userName, credential, roleList, claims, profileName);
                    throw e;
                }
                credential = credBuff.toString();
                credentialObj.clear();
                try {
                    credentialObj = Secret.getSecret((Object)credential);
                }
                catch (UnsupportedSecretTypeException e) {
                    this.handleAddUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.getMessage(), userName, credential, roleList, claims, profileName);
                    throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_CREDENTIAL_TYPE.toString(), e);
                }
            }
            if (!this.checkUserNameValid(userStore.getDomainFreeName())) {
                regEx = this.realmConfig.getUserStoreProperty("UsernameJavaRegEx");
                if (StringUtils.isEmpty((String)regEx) || StringUtils.isEmpty((String)regEx.trim())) {
                    regEx = this.realmConfig.getUserStoreProperty("UserNameJavaRegEx");
                }
                String string = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_USER_NAME.getMessage(), userStore.getDomainFreeName(), regEx);
                errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_USER_NAME.getCode();
                this.handleAddUserFailureWithID(errorCode, string, userName, credential, roleList, claims, profileName);
                throw new UserStoreException(errorCode + " - " + string);
            }
            if (!this.checkUserPasswordValid(credentialObj)) {
                regEx = this.realmConfig.getUserStoreProperty("PasswordJavaRegEx");
                String string = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getMessage(), regEx);
                errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getCode();
                this.handleAddUserFailureWithID(errorCode, string, userName, credential, roleList, claims, profileName);
                throw new UserStoreException(errorCode + " - " + string);
            }
            boolean isUniqueUserIdEnabled = this.isUniqueUserIdEnabledInUserStore(userStore);
            if (isUniqueUserIdEnabled) {
                boolean bl = this.getUserIDFromUserName(userName) != null;
            } else {
                boolean bl = this.doCheckExistingUser(userName);
            }
            if (var11_26 != false) {
                String message = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_USER_ALREADY_EXISTS.getMessage(), userName);
                String errorCode2 = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_USER_ALREADY_EXISTS.getCode();
                this.handleAddUserFailureWithID(errorCode2, message, userName, credential, roleList, claims, profileName);
                throw new UserStoreException(errorCode2 + " - " + message);
            }
            ArrayList<String> internalRoles = new ArrayList<String>();
            ArrayList<String> externalRoles = new ArrayList<String>();
            this.filterRoles(roleList, internalRoles, externalRoles);
            for (String string : internalRoles) {
                if (this.hybridRoleManager.isExistingRole(string)) continue;
                String message = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INTERNAL_ROLE_NOT_EXISTS.getMessage(), string);
                String errorCode3 = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INTERNAL_ROLE_NOT_EXISTS.getCode();
                this.handleAddUserFailureWithID(errorCode3, message, userName, credential, roleList, claims, profileName);
                throw new UserStoreException(errorCode3 + " - " + message);
            }
            for (String string : externalRoles) {
                if (this.doCheckExistingRole(string)) continue;
                String message = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_EXTERNAL_ROLE_NOT_EXISTS.getMessage(), string);
                String errorCode4 = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_EXTERNAL_ROLE_NOT_EXISTS.getCode();
                this.handleAddUserFailureWithID(errorCode4, message, userName, credential, roleList, claims, profileName);
                throw new UserStoreException(errorCode4 + " - " + message);
            }
            for (Map.Entry entry : claims.entrySet()) {
                ClaimMapping claimMapping;
                try {
                    claimMapping = (ClaimMapping)this.claimManager.getClaimMapping((String)entry.getKey());
                }
                catch (org.wso2.carbon.user.api.UserStoreException e) {
                    String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNABLE_TO_FETCH_CLAIM_MAPPING.getMessage(), "persisting user attributes.");
                    String errorCode5 = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_UNABLE_TO_FETCH_CLAIM_MAPPING.getCode();
                    this.handleAddUserFailureWithID(errorCode5, errorMessage, userName, credential, roleList, claims, profileName);
                    throw new UserStoreException(errorCode5 + " - " + errorMessage, e);
                }
                if (claimMapping != null) continue;
                String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.getMessage(), entry.getKey());
                String errorCode6 = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.getCode();
                this.handleAddUserFailureWithID(errorCode6, errorMessage, userName, credential, roleList, claims, profileName);
                throw new UserStoreException(errorCode6 + " - " + errorMessage);
            }
            try {
                if (isUniqueUserIdEnabled) {
                    user = this.doAddUserWithID(userName, credentialObj, externalRoles.toArray(new String[0]), claims, profileName, false);
                } else {
                    this.doAddUser(userName, credentialObj, externalRoles.toArray(new String[0]), claims, profileName, false);
                    user = this.userUniqueIDManger.addUser(userStore.getDomainFreeName(), profileName, this);
                }
            }
            catch (UserStoreException ex) {
                this.handleAddUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_ADDING_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_ADDING_USER.getMessage(), ex.getMessage()), userName, credential, roleList, claims, profileName);
                throw ex;
            }
            if (internalRoles.size() > 0) {
                this.hybridRoleManager.updateHybridRoleListOfUser(userName, null, internalRoles.toArray(new String[0]));
            }
            try {
                Iterator<UserOperationEventListener> ex = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
                while (ex.hasNext()) {
                    UserOperationEventListener userOperationEventListener;
                    Object credentialArgument2 = (userOperationEventListener = ex.next()) instanceof SecretHandleableListener ? credentialObj : credential;
                    if (((AbstractUserOperationEventListener)userOperationEventListener).doPostAddUserWithID(user, credentialArgument2, roleList, claims, profileName, this)) continue;
                    this.handleAddUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_USER.getMessage(), "Post-listener tasks failed"), userName, credential, roleList, claims, profileName);
                    User user4 = null;
                    return user4;
                }
            }
            catch (UserStoreException ex) {
                this.handleAddUserFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_USER.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_USER.getMessage(), ex.getMessage()), userName, credential, roleList, claims, profileName);
                throw ex;
            }
        }
        finally {
            credentialObj.clear();
        }
        this.clearUserRolesCache(userName);
        return user;
    }

    @Override
    public void addRoleWithID(String roleName, String[] userIDList, Permission[] permissions, boolean isSharedRole) throws UserStoreException {
        String roleWithDomain;
        if (StringUtils.isEmpty((String)roleName)) {
            this.handleAddRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_ADD_EMPTY_ROLE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_ADD_EMPTY_ROLE.getMessage(), roleName, userIDList, permissions);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_CANNOT_ADD_EMPTY_ROLE.toString());
        }
        if (userIDList == null) {
            userIDList = new String[]{};
        }
        UserStore userStore = this.getUserStore(roleName);
        if (isSharedRole && !this.isSharedGroupEnabled()) {
            this.handleAddRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_SHARED_ROLE_NOT_SUPPORTED.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_SHARED_ROLE_NOT_SUPPORTED.getMessage(), roleName, userIDList, permissions);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_SHARED_ROLE_NOT_SUPPORTED.toString());
        }
        String[] userList = new String[]{};
        if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
            userList = (String[])this.userUniqueIDManger.getUsers(Arrays.asList(userIDList), this).stream().map(User::getDomainQualifiedUsername).toArray(String[]::new);
        }
        if (userStore.isHybridRole()) {
            if (!this.handlePreAddRoleWithID(roleName, userIDList, permissions, false)) {
                return;
            }
            if (this.isUniqueUserIdEnabledInUserStore(userStore)) {
                this.doAddInternalRoleWithID(roleName, userIDList, permissions);
            } else {
                this.doAddInternalRole(roleName, userList, permissions);
            }
            this.handlePostAddRoleWithID(roleName, userIDList, permissions, false);
            return;
        }
        if (userStore.isRecurssive()) {
            ((UniqueIDUserStoreManager)userStore.getUserStoreManager()).addRoleWithID(userStore.getDomainFreeName(), UserCoreUtil.removeDomainFromNames(userIDList), permissions, isSharedRole);
            return;
        }
        if (userIDList == null) {
            userIDList = new String[]{};
        }
        if (permissions == null) {
            permissions = new Permission[]{};
        }
        if (roleName.indexOf(CarbonConstants.DOMAIN_SEPARATOR) > 0) {
            roleName = userStore.getDomainFreeName();
            userIDList = UserCoreUtil.removeDomainFromNames(userIDList);
        }
        if (!this.handlePreAddRoleWithID(roleName, userIDList, permissions, false)) {
            return;
        }
        if (this.isReadOnly()) {
            this.handleAddRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.getMessage(), roleName, userIDList, permissions);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_READONLY_USER_STORE.toString());
        }
        if (!this.isRoleNameValid(roleName)) {
            String regEx = this.realmConfig.getUserStoreProperty("RolenameJavaRegEx");
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_ROLE_NAME.getMessage(), roleName, regEx);
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_ROLE_NAME.getCode();
            this.handleAddRoleFailureWithID(errorCode, errorMessage, roleName, userIDList, permissions);
            throw new UserStoreException(errorCode + " - " + errorMessage);
        }
        if (this.doCheckExistingRole(roleName)) {
            this.handleRoleAlreadyExistExceptionWithID(roleName, userIDList, permissions);
        }
        if (this.writeGroupsEnabled) {
            try {
                if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
                    List<User> users = this.userUniqueIDManger.getUsers(Arrays.asList(userIDList), this);
                    this.doAddRole(roleName, (String[])users.stream().map(User::getUsername).toArray(String[]::new), isSharedRole);
                } else {
                    this.doAddRoleWithID(roleName, userIDList, isSharedRole);
                }
                roleWithDomain = UserCoreUtil.addDomainToName(roleName, this.getMyDomainName());
            }
            catch (UserStoreException ex) {
                this.handleAddRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_ADDING_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_ADDING_ROLE.getMessage(), ex.getMessage()), roleName, userIDList, permissions);
                throw ex;
            }
        } else {
            this.handleAddRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_WRITE_GROUPS_NOT_ENABLED.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_WRITE_GROUPS_NOT_ENABLED.getMessage(), roleName, userIDList, permissions);
            throw new UserStoreException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_WRITE_GROUPS_NOT_ENABLED.toString());
        }
        for (Permission permission : permissions) {
            String resourceId = permission.getResourceId();
            String action = permission.getAction();
            if (resourceId == null || resourceId.trim().length() == 0) continue;
            if (action == null || action.trim().length() == 0) {
                action = "read";
            }
            this.userRealm.getAuthorizationManager().authorizeRole(roleWithDomain, resourceId, action);
        }
        if (userIDList != null && userIDList.length > 0) {
            this.clearUserRolesCacheByTenant(this.tenantId);
        }
        this.handlePostAddRoleWithID(roleName, userIDList, permissions, false);
    }

    private void handlePostAddRoleWithID(String roleName, String[] userList, Permission[] permissions, boolean isAuditLogOnly) throws UserStoreException {
        try {
            boolean internalRole = this.isAnInternalRole(roleName);
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger")) continue;
                boolean success = false;
                if (internalRole && listener instanceof AbstractUserOperationEventListener) {
                    success = ((AbstractUserOperationEventListener)listener).doPostAddInternalRoleWithID(roleName, userList, permissions, this);
                } else if (internalRole && !(listener instanceof AbstractUserOperationEventListener)) {
                    success = true;
                } else if (!internalRole) {
                    success = ((UniqueIDUserOperationEventListener)listener).doPostAddRoleWithID(roleName, userList, permissions, this);
                }
                if (success) continue;
                this.handleAddRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_ROLE.getMessage(), "Post-listener tasks failed"), roleName, userList, permissions);
                return;
            }
        }
        catch (UserStoreException ex) {
            this.handleAddRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_ADD_ROLE.getMessage(), ex.getMessage()), roleName, userList, permissions);
            throw ex;
        }
    }

    private boolean handlePreAddRoleWithID(String roleName, String[] userList, Permission[] permissions, boolean isAuditLogOnly) throws UserStoreException {
        try {
            boolean internalRole = this.isAnInternalRole(roleName);
            String internalSystemRolePrefix = "Internal" + UserCoreConstants.DOMAIN_SEPARATOR + "system_";
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                boolean success;
                if (isAuditLogOnly && !listener.getClass().getName().endsWith("AuditLogger") || (success = internalRole && roleName.startsWith(internalSystemRolePrefix) ? true : (internalRole && listener instanceof AbstractUserOperationEventListener ? ((AbstractUserOperationEventListener)listener).doPreAddInternalRoleWithID(roleName, userList, permissions, this) : (internalRole ? true : ((UniqueIDUserOperationEventListener)listener).doPreAddRoleWithID(roleName, userList, permissions, this))))) continue;
                this.handleAddRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_ROLE.getMessage(), "Pre-listener tasks failed"), roleName, userList, permissions);
                return false;
            }
        }
        catch (UserStoreException ex) {
            this.handleAddRoleFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_ROLE.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_ADD_ROLE.getMessage(), ex.getMessage()), roleName, userList, permissions);
            throw ex;
        }
        return true;
    }

    protected void doAddInternalRoleWithID(String roleName, String[] userIDList, org.wso2.carbon.user.api.Permission[] permissions) throws UserStoreException {
        String[] users = this.getUserNamesFromUserIDs(Arrays.asList(userIDList)).toArray(new String[0]);
        if (roleName.contains(UserCoreConstants.DOMAIN_SEPARATOR) && roleName.toLowerCase().startsWith(APPLICATION_DOMAIN.toLowerCase())) {
            if (this.hybridRoleManager.isExistingRole(roleName)) {
                this.handleRoleAlreadyExistExceptionWithID(roleName, userIDList, permissions);
            }
            this.hybridRoleManager.addHybridRole(roleName, users);
        } else {
            if (this.hybridRoleManager.isExistingRole(UserCoreUtil.removeDomainFromName(roleName))) {
                this.handleRoleAlreadyExistExceptionWithID(roleName, userIDList, permissions);
            }
            this.hybridRoleManager.addHybridRole(UserCoreUtil.removeDomainFromName(roleName), users);
        }
        if (permissions != null) {
            for (org.wso2.carbon.user.api.Permission permission : permissions) {
                String resourceId = permission.getResourceId();
                String action = permission.getAction();
                this.userRealm.getAuthorizationManager().authorizeRole(UserCoreUtil.addInternalDomainName(roleName), resourceId, action);
            }
        }
        if (userIDList != null && userIDList.length > 0) {
            this.clearUserRolesCacheByTenant(this.tenantId);
        }
    }

    private void filterRoles(String[] roleList, List<String> internalRoles, List<String> externalRoles) {
        if (roleList == null) {
            return;
        }
        for (String role : roleList) {
            if (role.trim().length() == 0) continue;
            int index = role.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
            if (index > 0) {
                String domain = role.substring(0, index);
                if ("Internal".equalsIgnoreCase(domain)) {
                    internalRoles.add(UserCoreUtil.removeDomainFromName(role));
                    continue;
                }
                if (APPLICATION_DOMAIN.equalsIgnoreCase(domain) || WORKFLOW_DOMAIN.equalsIgnoreCase(domain)) {
                    internalRoles.add(role);
                    continue;
                }
            }
            externalRoles.add(UserCoreUtil.removeDomainFromName(role));
        }
    }

    @Override
    public boolean isUserInRoleWithID(String userID, String roleName) throws UserStoreException {
        List<String> internalRoles;
        String[] roles;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("isUserInRoleWithID", new Object[]{userID, roleName}, argTypes);
            return (Boolean)object;
        }
        UserStore userStore = this.getUserStoreWithID(userID);
        if (userStore.isRecurssive() && userStore.getUserStoreManager() instanceof AbstractUserStoreManager) {
            return ((AbstractUserStoreManager)userStore.getUserStoreManager()).isUserInRoleWithID(userStore.getDomainFreeUserId(), roleName);
        }
        if (!this.isUniqueUserIdEnabledInUserStore(userStore)) {
            User user = this.userUniqueIDManger.getUser(userID, this);
            if (user == null) {
                return false;
            }
            return this.isUserInRole(user.getDomainQualifiedUsername(), roleName);
        }
        if (roleName == null || roleName.trim().length() == 0 || userID == null || userID.trim().length() == 0) {
            return false;
        }
        if ("system/wso2.anonymous.role".equalsIgnoreCase(roleName) && "wso2.anonymous.user".equalsIgnoreCase(userID)) {
            return true;
        }
        if (!"wso2.anonymous.user".equalsIgnoreCase(userID) && this.realmConfig.getEveryOneRoleName().equalsIgnoreCase(roleName) && !this.systemUserRoleManager.isExistingSystemUser(UserCoreUtil.removeDomainFromName(userID))) {
            return true;
        }
        String username = this.getUserNameFromUserID(userID);
        if (username == null && (roles = this.getRoleListOfUserFromCache(this.tenantId, userID)) != null && roles.length > 0 && UserCoreUtil.isContain(roleName, roles)) {
            return true;
        }
        String modifiedUserName = "@__isUserHasTheRole__@" + username;
        roles = this.getRoleListOfUserFromCache(this.tenantId, modifiedUserName);
        if (roles != null && roles.length > 0 && UserCoreUtil.isContain(roleName, roles)) {
            return true;
        }
        if (("Internal".equalsIgnoreCase(UserCoreUtil.extractDomainFromName(roleName)) || APPLICATION_DOMAIN.equalsIgnoreCase(UserCoreUtil.extractDomainFromName(roleName)) || WORKFLOW_DOMAIN.equalsIgnoreCase(UserCoreUtil.extractDomainFromName(roleName))) && (internalRoles = this.doGetInternalRoleListOfUserWithID(userID, roleName)).contains(roleName)) {
            this.addToIsUserHasRole(modifiedUserName, roleName, roles);
            return true;
        }
        if (userStore.isSystemStore()) {
            return this.systemUserRoleManager.isUserInRole(userStore.getDomainFreeUserId(), UserCoreUtil.removeDomainFromName(roleName));
        }
        if (this.realmConfig.isPrimary() && roleName.equalsIgnoreCase(this.realmConfig.getAdminRoleName()) && userID.equalsIgnoreCase(this.realmConfig.getAdminUserName())) {
            return true;
        }
        String roleDomainName = UserCoreUtil.extractDomainFromName(roleName);
        String roleDomainNameForForest = this.realmConfig.getUserStoreProperty("GroupSearchDomains");
        if (roleDomainNameForForest != null && roleDomainNameForForest.trim().length() > 0) {
            String[] values;
            for (String value : values = roleDomainNameForForest.split("#")) {
                if (value == null || value.trim().equalsIgnoreCase(roleDomainName)) continue;
                return false;
            }
        } else if (!userStore.getDomainName().equalsIgnoreCase(roleDomainName)) {
            return false;
        }
        boolean success = false;
        if (this.readGroupsEnabled) {
            success = this.doCheckIsUserInRoleWithID(userStore.getDomainFreeUserId(), UserCoreUtil.removeDomainFromName(roleName));
        }
        if (success) {
            this.addToIsUserHasRole(modifiedUserName, roleName, roles);
        }
        return success;
    }

    @Override
    public List<User> listUsersWithID(String filter, int limit, int offset) throws UserStoreException {
        ArrayList<User> users;
        UniqueIDPaginatedSearchResult userList;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
            Object object = this.callSecure("listUsersWithID", new Object[]{filter, limit, offset}, argTypes);
            return (List)object;
        }
        int index = filter.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (offset <= 0) {
            offset = 1;
        }
        if (index > 0) {
            String domain = filter.substring(0, index);
            UserStoreManager secManager = this.getSecondaryUserStoreManager(domain);
            if (secManager != null) {
                filter = filter.substring(index + 1);
                if (secManager instanceof AbstractUserStoreManager) {
                    UniqueIDPaginatedSearchResult userList2;
                    if (((AbstractUserStoreManager)secManager).isUniqueUserIdEnabled()) {
                        userList2 = ((AbstractUserStoreManager)secManager).doListUsersWithID(filter, limit, offset);
                        this.handlePostListPaginatedUsersWithID(filter, limit, offset, userList2.getUsers(), true);
                    } else {
                        PaginatedSearchResult paginatedSearchResult = ((AbstractUserStoreManager)secManager).doListUsers(filter, limit, offset);
                        this.handlePostListPaginatedUsers(filter, limit, offset, Arrays.asList(paginatedSearchResult.getUsers()), true);
                        userList2 = this.userUniqueIDManger.listUsers(paginatedSearchResult, this);
                    }
                    return userList2.getUsers();
                }
            }
        } else if (index == 0) {
            UniqueIDPaginatedSearchResult userList3;
            if (this.isUniqueUserIdEnabled()) {
                userList3 = this.doListUsersWithID(filter.substring(1), limit, offset);
                this.handlePostListPaginatedUsersWithID(filter, limit, offset, userList3.getUsers(), true);
            } else {
                PaginatedSearchResult paginatedSearchResult = this.doListUsers(filter.substring(1), limit, offset);
                this.handlePostListPaginatedUsers(filter, limit, offset, Arrays.asList(paginatedSearchResult.getUsers()), true);
                userList3 = this.userUniqueIDManger.listUsers(paginatedSearchResult, this);
            }
            return userList3.getUsers();
        }
        try {
            userList = this.isUniqueUserIdEnabled() ? this.doListUsersWithID(filter, limit, offset) : this.userUniqueIDManger.listUsers(this.doListUsers(filter, limit, offset), this);
            users = new ArrayList<User>(userList.getUsers());
            limit -= users.size();
        }
        catch (UserStoreException ex) {
            this.handleGetPaginatedUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_LISTING_PAGINATED_USERS.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_LISTING_PAGINATED_USERS.getMessage(), ex.getMessage()), null, null, null);
            throw ex;
        }
        String primaryDomain = this.realmConfig.getUserStoreProperty("DomainName");
        int nonPaginatedUserCount = userList.getSkippedUserCount();
        if (this.getSecondaryUserStoreManager() != null) {
            for (Map.Entry<String, UserStoreManager> entry : this.userStoreManagerHolder.entrySet()) {
                UserStoreManager storeManager;
                if (limit <= 0) {
                    return users;
                }
                if (entry.getKey().equalsIgnoreCase(primaryDomain) || !((storeManager = entry.getValue()) instanceof AbstractUserStoreManager)) continue;
                try {
                    UniqueIDPaginatedSearchResult secondUserList;
                    offset = userList.getUsers().size() > 0 ? 1 : (offset -= nonPaginatedUserCount);
                    if (((AbstractUserStoreManager)storeManager).isUniqueUserIdEnabled()) {
                        secondUserList = ((AbstractUserStoreManager)storeManager).doListUsersWithID(filter, limit, offset);
                        nonPaginatedUserCount = secondUserList.getSkippedUserCount();
                    } else {
                        PaginatedSearchResult paginatedSearchResult = ((AbstractUserStoreManager)storeManager).doListUsers(filter.substring(1), limit, offset);
                        secondUserList = this.userUniqueIDManger.listUsers(paginatedSearchResult, this);
                    }
                    users.addAll(secondUserList.getUsers());
                    limit -= users.size();
                }
                catch (UserStoreException ex) {
                    this.handleGetPaginatedUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_LISTING_PAGINATED_USERS.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_LISTING_PAGINATED_USERS.getMessage(), ex.getMessage()), null, null, null);
                    log.error((Object)ex);
                }
            }
        }
        this.handlePostListPaginatedUsersWithID(filter, limit, offset, users, true);
        return users;
    }

    @Override
    public List<User> getUserListWithID(String claim, String claimValue, String profileName, int limit, int offset) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class, Integer.TYPE, Integer.TYPE};
            Object object = this.callSecure("getUserListWithID", new Object[]{claim, claimValue, profileName, limit, offset}, argTypes);
            return (List)object;
        }
        if (claim == null) {
            String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.getCode();
            String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.getMessage(), "");
            this.handleGetUserListFailureWithID(errorCode, errorMessage, null, claimValue, limit, offset, profileName);
            throw new IllegalArgumentException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_URI.toString());
        }
        if (claimValue == null) {
            this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_VALUE.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_VALUE.getMessage(), claim, null, limit, offset, profileName);
            throw new IllegalArgumentException(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_CLAIM_VALUE.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing and paginate users who having value as " + claimValue + " for the claim " + claim));
        }
        if (USERNAME_CLAIM_URI.equalsIgnoreCase(claim) || SCIM_USERNAME_CLAIM_URI.equalsIgnoreCase(claim) || SCIM2_USERNAME_CLAIM_URI.equalsIgnoreCase(claim)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Switching to paginate users using username");
            }
            List<User> filteredUsers = this.isUniqueUserIdEnabled() ? this.listUsersWithID(claimValue, limit, offset) : this.userUniqueIDManger.listUsers(this.listUsers(claimValue, limit, offset), this);
            return filteredUsers;
        }
        String extractedDomain = null;
        int index = claimValue.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index > 0) {
            String[] names = claimValue.split(CarbonConstants.DOMAIN_SEPARATOR);
            extractedDomain = names[0].trim();
        }
        UserStoreManager userManager = this;
        if (StringUtils.isNotEmpty(extractedDomain) && !StringUtils.equalsIgnoreCase((String)this.getMyDomainName(), (String)extractedDomain)) {
            userManager = this.getSecondaryUserStoreManager(extractedDomain);
            if (userManager == null) {
                throw new UserStoreException("Invalid Domain Name: " + extractedDomain);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Domain: " + extractedDomain + " is passed with the claim and user store manager is loaded for the given domain name."));
            }
        }
        claimValue = UserCoreUtil.removeDomainFromName(claimValue);
        ArrayList<User> filteredUserList = new ArrayList<User>();
        if (StringUtils.isNotEmpty((String)extractedDomain)) {
            try {
                for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                    AbstractUserOperationEventListener newListener;
                    if (!(listener instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPreGetUserListWithID(claim, claimValue, limit, offset, filteredUserList, userManager)) continue;
                    this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), "Pre-listener tasks failed"), claim, claimValue, limit, offset, profileName);
                    break;
                }
            }
            catch (UserStoreException ex) {
                this.handleGetUserListFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, limit, offset, profileName);
                throw ex;
            }
        }
        List<User> usersFromUserStore = this.isUniqueUserIdEnabled() ? this.doGetUserListWithID(claim, claimValue, profileName, limit, offset, extractedDomain, userManager) : this.userUniqueIDManger.listUsers(this.doGetUserList(claim, claimValue, profileName, limit, offset, extractedDomain, userManager), this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Users from user store: " + extractedDomain + " : " + usersFromUserStore));
        }
        filteredUserList.addAll(usersFromUserStore);
        this.handlePostGetUserListWithID(claim, claimValue, filteredUserList, limit, offset, false);
        return filteredUserList;
    }

    @Override
    public List<User> getUserListWithID(Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        this.validateCondition(condition);
        if (StringUtils.isNotEmpty((String)sortBy) && StringUtils.isNotEmpty((String)sortOrder)) {
            throw new UserStoreException("Sorting is not supported.");
        }
        if (StringUtils.isEmpty((String)domain)) {
            domain = "PRIMARY";
        }
        if (StringUtils.isEmpty((String)profileName)) {
            profileName = "default";
        }
        this.handlePreGetUserListWithID(condition, domain, profileName, limit, offset, sortBy, sortOrder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pre listener get conditional  user list for domain: " + domain));
        }
        List<User> filteredUsers = new ArrayList<User>();
        UserStoreManager secManager = this.getSecondaryUserStoreManager(domain);
        if (secManager != null) {
            if (secManager instanceof AbstractUserStoreManager) {
                if (this.isUniqueUserIdEnabled(secManager)) {
                    UniqueIDPaginatedSearchResult users = ((AbstractUserStoreManager)secManager).doGetUserListWithID(condition, profileName, limit, offset, sortBy, sortOrder);
                    this.addUsersToUserIdCache(users.getUsers());
                    this.addUsersToUserNameCache(users.getUsers());
                    filteredUsers = users.getUsers();
                } else {
                    PaginatedSearchResult users = ((AbstractUserStoreManager)secManager).doGetUserList(condition, profileName, limit, offset, sortBy, sortOrder);
                    filteredUsers = this.userUniqueIDManger.listUsers(users.getUsers(), this);
                }
            }
        } else if (secManager == null && StringUtils.isNotEmpty((String)domain)) {
            throw new UserStoreClientException("Invalid Domain Name.");
        }
        this.handlePostGetUserListWithID(condition, domain, profileName, limit, offset, sortBy, sortOrder, filteredUsers, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("post listener get conditional  user list for domain: " + domain));
        }
        return filteredUsers;
    }

    private List<User> doGetUserListWithID(String claim, String claimValue, String profileName, int limit, int offset, String extractedDomain, UserStoreManager userManager) throws UserStoreException {
        if (StringUtils.isNotEmpty((String)extractedDomain)) {
            String property;
            if (userManager == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No user store manager found for domain: " + extractedDomain));
                }
                return Collections.emptyList();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Domain found in claim value. Searching only in the " + extractedDomain + " for possible matches"));
            }
            try {
                property = this.claimManager.getAttributeName(extractedDomain, claim);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), e.getMessage()), claim, claimValue, limit, offset, profileName);
                throw new UserStoreException("Error occurred while retrieving attribute name for domain : " + extractedDomain + " and claim " + claim, e);
            }
            if (property == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Could not find matching property for\nclaim :" + claim + "domain :" + extractedDomain));
                }
                return Collections.emptyList();
            }
            if (userManager instanceof AbstractUserStoreManager) {
                try {
                    AbstractUserStoreManager userStoreManager = (AbstractUserStoreManager)userManager;
                    UniqueIDPaginatedSearchResult result = userStoreManager.doGetUserListFromPropertiesWithID(property, claimValue, profileName, limit, offset);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("List of filtered paginated users for: " + extractedDomain + " : " + Arrays.asList(result.getUsers())));
                    }
                    return result.getUsers();
                }
                catch (UserStoreException ex) {
                    this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_USER_LIST.getMessage(), ex.getMessage()), claim, claimValue, limit, offset, profileName);
                    throw ex;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getUserListFromProperties is not supported by this user store: " + userManager.getClass()));
            }
            return Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No domain name found in claim value. Searching through all user stores for possible matches");
        }
        ArrayList<User> usersFromAllStoresList = new ArrayList<User>();
        List<UserStoreManager> userStoreManagers = this.getUserStoreMangers();
        int nonPaginatedUserCount = 0;
        for (UserStoreManager userStoreManager : userStoreManagers) {
            String property;
            if (!(userStoreManager instanceof AbstractUserStoreManager)) continue;
            if (limit <= 0) {
                return usersFromAllStoresList;
            }
            String domainName = ((AbstractUserStoreManager)userStoreManager).getMyDomainName();
            try {
                property = this.claimManager.getAttributeName(domainName, claim);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                this.handleGetUserListFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_GET_USER_LIST.getMessage(), e.getMessage()), claim, claimValue, limit, offset, profileName);
                throw new UserStoreException("Error occurred while retrieving attribute name for domain : " + extractedDomain + " and claim " + claim, e);
            }
            UniqueIDPaginatedSearchResult userList = this.doGetUserListFromPropertiesWithID(property, claimValue, profileName, limit, offset);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Secondary user list for domain: " + domainName + " : " + userList));
            }
            limit -= userList.getUsers().size();
            nonPaginatedUserCount = userList.getSkippedUserCount();
            offset = userList.getUsers().size() > 0 ? 1 : (offset -= nonPaginatedUserCount);
            usersFromAllStoresList.addAll(userList.getUsers());
        }
        return usersFromAllStoresList;
    }

    @Override
    public List<UniqueIDUserClaimSearchEntry> getUsersClaimValuesWithID(List<String> userIDs, List<String> claims, String profileName) throws UserStoreException {
        AbstractUserOperationEventListener newListener;
        UserOperationEventListener listener;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{List.class, List.class, String.class};
            Object object = this.callSecure("getUsersClaimValuesWithID", new Object[]{userIDs, claims, profileName}, argTypes);
            return (List)object;
        }
        if (StringUtils.isEmpty((String)profileName)) {
            profileName = "default";
        }
        ArrayList<UniqueIDUserClaimSearchEntry> allUsers = new ArrayList<UniqueIDUserClaimSearchEntry>();
        Map<String, List<String>> domainFreeUsers = this.getDomainFreeUsersWithID(userIDs);
        for (Map.Entry<String, List<String>> entry : domainFreeUsers.entrySet()) {
            UserStoreManager secondaryUserStoreManager = this.getSecondaryUserStoreManager(entry.getKey());
            if (!(secondaryUserStoreManager instanceof AbstractUserStoreManager)) continue;
            if (this.isUniqueUserIdEnabled(secondaryUserStoreManager)) {
                List<UniqueIDUserClaimSearchEntry> users = ((AbstractUserStoreManager)secondaryUserStoreManager).doGetUsersClaimValuesWithID(entry.getValue(), claims, entry.getKey(), profileName);
                allUsers.addAll(users);
                continue;
            }
            List<String> userNamesFromUserIDs = this.getUserNamesFromUserIDs(entry.getValue()).stream().map(UserCoreUtil::removeDomainFromName).collect(Collectors.toList());
            UserClaimSearchEntry[] users = ((AbstractUserStoreManager)secondaryUserStoreManager).doGetUsersClaimValues(userNamesFromUserIDs, claims.toArray(new String[0]), entry.getKey(), profileName);
            List<UniqueIDUserClaimSearchEntry> uniqueIDUserClaimSearchEntries = this.getUniqueIDUserClaimSearchEntries(users);
            allUsers.addAll(uniqueIDUserClaimSearchEntries);
        }
        Iterator<Object> iterator = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
        while (iterator.hasNext() && (!((listener = (UserOperationEventListener)iterator.next()) instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPostGetUsersClaimValuesWithID(userIDs, claims, profileName, allUsers, this))) {
        }
        return allUsers;
    }

    public List<UniqueIDUserClaimSearchEntry> getUniqueIDUserClaimSearchEntries(UserClaimSearchEntry[] users) throws UserStoreException {
        ArrayList<UniqueIDUserClaimSearchEntry> uniqueIDUserClaimSearchEntries = new ArrayList<UniqueIDUserClaimSearchEntry>();
        for (UserClaimSearchEntry userClaimSearchEntry : users) {
            UniqueIDUserClaimSearchEntry uniqueIDUserClaimSearchEntry = new UniqueIDUserClaimSearchEntry();
            String userName = userClaimSearchEntry.getUserName();
            String userID = this.getUserIDFromUserName(userName);
            User user = this.getUser(userID, userName);
            uniqueIDUserClaimSearchEntry.setUser(user);
            uniqueIDUserClaimSearchEntry.setClaims(userClaimSearchEntry.getClaims());
            uniqueIDUserClaimSearchEntry.setUserClaimSearchEntry(userClaimSearchEntry);
            uniqueIDUserClaimSearchEntries.add(uniqueIDUserClaimSearchEntry);
        }
        return uniqueIDUserClaimSearchEntries;
    }

    public List<UniqueIDUserClaimSearchEntry> doGetUsersClaimValuesWithID(List<String> userIDs, List<String> claims, String domainName, String profileName) throws UserStoreException {
        HashSet<String> propertySet = new HashSet<String>();
        HashMap<String, String> claimToAttributeMap = new HashMap<String, String>();
        ArrayList<UniqueIDUserClaimSearchEntry> userClaimSearchEntryList = new ArrayList<UniqueIDUserClaimSearchEntry>();
        for (String claim : claims) {
            String property;
            try {
                property = this.getClaimAtrribute(claim, null, domainName);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            propertySet.add(property);
            claimToAttributeMap.put(claim, property);
        }
        String[] properties = propertySet.toArray(new String[0]);
        Map<String, Map<String, String>> userProperties = this.getUsersPropertyValuesWithID(userIDs, properties, profileName);
        for (Map.Entry<String, Map<String, String>> entry : userProperties.entrySet()) {
            UniqueIDUserClaimSearchEntry uniqueIDUserClaimSearchEntry = new UniqueIDUserClaimSearchEntry();
            UserClaimSearchEntry userClaimSearchEntry = new UserClaimSearchEntry();
            String userID = entry.getKey();
            String userName = this.doGetUserNameFromUserID(userID);
            User user = this.getUser(userID, userName);
            uniqueIDUserClaimSearchEntry.setUser(user);
            userClaimSearchEntry.setUserName(user.getDomainQualifiedUsername());
            HashMap<String, String> userClaims = new HashMap<String, String>();
            for (String claim : claims) {
                for (Map.Entry<String, String> userAttribute : entry.getValue().entrySet()) {
                    String value;
                    if (claimToAttributeMap.get(claim) == null || !((String)claimToAttributeMap.get(claim)).equals(userAttribute.getKey()) || !StringUtils.isNotBlank((String)(value = userAttribute.getValue()))) continue;
                    userClaims.put(claim, value);
                }
            }
            uniqueIDUserClaimSearchEntry.setClaims(userClaims);
            userClaimSearchEntry.setClaims(userClaims);
            uniqueIDUserClaimSearchEntry.setUserClaimSearchEntry(userClaimSearchEntry);
            userClaimSearchEntryList.add(uniqueIDUserClaimSearchEntry);
        }
        return userClaimSearchEntryList;
    }

    private Map<String, List<String>> getDomainFreeUsersWithID(List<String> userIDs) throws UserStoreException {
        HashMap<String, List<String>> domainAwareUsers = new HashMap<String, List<String>>();
        if (!userIDs.isEmpty()) {
            for (String userID : userIDs) {
                User user = this.getUser(userID, null);
                String domainName = user.getUserStoreDomain();
                ArrayList<String> users = (ArrayList<String>)domainAwareUsers.get(domainName);
                if (users == null) {
                    users = new ArrayList<String>();
                    domainAwareUsers.put(domainName.toUpperCase(), users);
                }
                users.add(UserCoreUtil.removeDomainFromName(userID));
            }
        }
        return domainAwareUsers;
    }

    protected Map<String, Map<String, String>> getUsersPropertyValuesWithID(List<String> userIDs, String[] propertyNames, String profileName) throws UserStoreException {
        HashMap<String, Map<String, String>> usersPropertyValuesMap = new HashMap<String, Map<String, String>>();
        for (String userID : userIDs) {
            Map<String, String> propertyValuesMap = this.getUserPropertyValuesWithID(userID, propertyNames, profileName);
            this.processAttributesAfterRetrievalWithID(userID, propertyValuesMap, profileName);
            if (propertyValuesMap == null || propertyValuesMap.isEmpty()) continue;
            usersPropertyValuesMap.put(userID, propertyValuesMap);
        }
        return usersPropertyValuesMap;
    }

    @Override
    public Map<String, List<String>> getRoleListOfUsersWithID(List<String> userIDs) throws UserStoreException {
        AbstractUserOperationEventListener newListener;
        UserOperationEventListener listener;
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{List.class};
            Object object = this.callSecure("getRoleListOfUsersWithID", new Object[]{userIDs}, argTypes);
            return (Map)object;
        }
        HashMap<String, List<String>> allRoleNames = new HashMap<String, List<String>>();
        Map<String, List<String>> domainFreeUsers = this.getDomainFreeUsersWithID(userIDs);
        for (Map.Entry<String, List<String>> entry : domainFreeUsers.entrySet()) {
            UserStoreManager secondaryUserStoreManager = this.getSecondaryUserStoreManager(entry.getKey());
            if (!(secondaryUserStoreManager instanceof AbstractUserStoreManager)) continue;
            if (((AbstractUserStoreManager)secondaryUserStoreManager).isUniqueUserIdEnabled()) {
                Map<String, List<String>> roleNames = ((AbstractUserStoreManager)secondaryUserStoreManager).doGetRoleListOfUsersWithID(entry.getValue(), entry.getKey());
                allRoleNames.putAll(roleNames);
                continue;
            }
            List<User> users = this.userUniqueIDManger.getUsers(entry.getValue(), (AbstractUserStoreManager)secondaryUserStoreManager);
            Map<String, List<String>> userRoles = ((AbstractUserStoreManager)secondaryUserStoreManager).doGetRoleListOfUsers(users.stream().map(User::getUsername).collect(Collectors.toList()), entry.getKey());
            for (User user : users) {
                allRoleNames.put(user.getUserID(), userRoles.get(user.getUsername()));
            }
        }
        Iterator<Object> iterator = UMListenerServiceComponent.getUserOperationEventListeners().iterator();
        while (iterator.hasNext() && (!((listener = (UserOperationEventListener)iterator.next()) instanceof AbstractUserOperationEventListener) || (newListener = (AbstractUserOperationEventListener)listener).doPostGetRoleListOfUsersWithID(userIDs, allRoleNames, this))) {
        }
        return allRoleNames;
    }

    public Map<String, List<String>> doGetRoleListOfUsersWithID(List<String> userIDs, String domainName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{List.class, String.class};
            Object object = this.callSecure("doGetRoleListOfUsersWithID", new Object[]{userIDs, domainName}, argTypes);
            return (Map)object;
        }
        Map<String, List<String>> internalRoles = this.doGetInternalRoleListOfUsersWithID(userIDs, domainName);
        Map<Object, Object> externalRoles = new HashMap();
        if (this.readGroupsEnabled) {
            externalRoles = this.doGetExternalRoleListOfUsersWithID(userIDs);
        }
        Map<Object, Object> combinedRoles = new HashMap();
        if (!internalRoles.isEmpty() && !externalRoles.isEmpty()) {
            for (String userID : userIDs) {
                ArrayList<String> roles = new ArrayList<String>();
                if (internalRoles.get(userID) != null) {
                    roles.addAll((Collection)internalRoles.get(userID));
                }
                if (externalRoles.get(userID) != null) {
                    List<String> domainQualifiedRoleNames = this.getNamesWithDomain((List)externalRoles.get(userID), domainName);
                    roles.addAll(domainQualifiedRoleNames);
                }
                if (roles.isEmpty()) continue;
                combinedRoles.put(userID, roles);
            }
        } else if (!internalRoles.isEmpty()) {
            combinedRoles = internalRoles;
        } else if (!externalRoles.isEmpty()) {
            combinedRoles = externalRoles;
        }
        return combinedRoles;
    }

    @Override
    public List<Group> listGroups(Condition condition, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("listGroups operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("listGroups operation is not implemented in: " + this.getClass());
    }

    @Override
    public List<Group> listGroups(Condition condition, int limit, int offset) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("listGroups operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("listGroups operation is not implemented in: " + this.getClass());
    }

    @Override
    public List<Group> listGroups(Condition condition) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("listGroups operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("listGroups operation is not implemented in: " + this.getClass());
    }

    @Override
    public Group addGroup(String groupName, List<String> usersIDs, List<Claim> claims) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addGroup operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("addGroup operation is not implemented in: " + this.getClass());
    }

    @Override
    public List<Group> getGroupListOfUser(String userId, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroupListOfUser operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("getGroupListOfUser operation is not implemented in: " + this.getClass());
    }

    @Override
    public List<User> getUserListOfGroup(String groupID, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUserListOfGroup operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("getUserListOfGroup operation is not implemented in: " + this.getClass());
    }

    @Override
    public void updateUserListOfGroup(String groupID, List<String> deletedUserIds, List<String> newUserIds) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateUserListOfGroup operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("updateUserListOfGroup operation is not implemented in: " + this.getClass());
    }

    @Override
    public void updateGroupListOfUser(String userID, List<String> deletedGroupIds, List<String> newGroupIds) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateGroupListOfUser operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("updateGroupListOfUser operation is not implemented in: " + this.getClass());
    }

    @Override
    public boolean isUserInGroup(String userID, String groupID) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("isUserInGroup operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("isUserInGroup operation is not implemented in: " + this.getClass());
    }

    @Override
    public Map<String, List<Group>> getGroupListOfUsers(List<String> userIDs) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroupListOfUsers operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("getGroupListOfUsers operation is not implemented in: " + this.getClass());
    }

    @Override
    public boolean isGroupExist(String groupID) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("isGroupExist operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("isGroupExist operation is not implemented in: " + this.getClass());
    }

    @Override
    public void deleteGroup(String groupID) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteGroup operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("deleteGroup operation is not implemented in: " + this.getClass());
    }

    @Override
    public Group renameGroup(String groupID, String newGroupName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("renameGroup operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("renameGroup operation is not implemented in: " + this.getClass());
    }

    @Override
    public User addUser(String userName, Object credential, List<org.wso2.carbon.user.core.claim.Claim> claims, List<String> groupsIds, String profileName) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addUser operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("addUser operation is not implemented in: " + this.getClass());
    }

    @Override
    public Group getGroup(String groupID, List<String> requiredAttributes) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroup operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("getGroup operation is not implemented in: " + this.getClass());
    }

    @Override
    public Group updateGroup(String groupID, List<Claim> claims) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateGroup operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("updateGroup operation is not implemented in: " + this.getClass());
    }

    @Override
    public List<User> getUserListOfGroup(String groupID, String sortBy, String sortOrder) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUserListOfGroup operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("getUserListOfGroup operation is not implemented in: " + this.getClass());
    }

    @Override
    public List<Group> getGroupListOfUser(String userId, String sortBy, String sortOrder) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroupListOfUser operation is not implemented in: " + this.getClass()));
        }
        throw new NotImplementedException("getGroupListOfUser operation is not implemented in: " + this.getClass());
    }

    private List<String> getNamesWithDomain(List<String> identifiers, String domain) {
        ArrayList<String> usersWithDomain = new ArrayList<String>();
        for (String identifier : identifiers) {
            usersWithDomain.add(UserCoreUtil.addDomainToName(identifier, domain));
        }
        return usersWithDomain;
    }

    private String getUserStoreDomainName(UserStoreManager userStoreManager) {
        String domainNameProperty = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
        if (StringUtils.isEmpty((String)domainNameProperty)) {
            domainNameProperty = "PRIMARY";
        }
        return domainNameProperty;
    }

    private Map<String, String> getModifiedClaims(Map<String, List<String>> oldClaimMap, Map<String, List<String>> multiValuedClaimsToAdd, Map<String, List<String>> multiValuedClaimsToDelete, Map<String, List<String>> claimsExcludingMultiValuedClaims) {
        HashMap<String, String> claims = new HashMap<String, String>();
        String separator = ",";
        if (StringUtils.isNotEmpty((String)this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR))) {
            separator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
        }
        if (claimsExcludingMultiValuedClaims != null) {
            for (String claimURI : claimsExcludingMultiValuedClaims.keySet()) {
                claims.put(claimURI, StringUtils.join(claimsExcludingMultiValuedClaims.get(claimURI).iterator(), (String)separator));
            }
        }
        if (multiValuedClaimsToAdd != null) {
            for (String claimURI : multiValuedClaimsToAdd.keySet()) {
                ArrayList modifiedValue = new ArrayList();
                if (oldClaimMap.containsKey(claimURI)) {
                    modifiedValue.addAll(oldClaimMap.get(claimURI));
                    modifiedValue.addAll(multiValuedClaimsToAdd.get(claimURI));
                } else {
                    modifiedValue.addAll(multiValuedClaimsToAdd.get(claimURI));
                }
                claims.put(claimURI, StringUtils.join(modifiedValue.iterator(), (String)separator));
            }
        }
        if (multiValuedClaimsToDelete != null) {
            for (String claimURI : multiValuedClaimsToDelete.keySet()) {
                List<String> values = null;
                if (claims.containsKey(claimURI)) {
                    values = Arrays.asList(((String)claims.get(claimURI)).split(separator));
                } else if (oldClaimMap.containsKey(claimURI)) {
                    values = oldClaimMap.get(claimURI);
                }
                if (CollectionUtils.isEmpty(values)) continue;
                List modifiedValue = (List)CollectionUtils.subtract(values, (Collection)multiValuedClaimsToDelete.get(claimURI));
                claims.put(claimURI, StringUtils.join(modifiedValue.iterator(), (String)separator));
            }
        }
        return claims;
    }

    private void invokeDoPreSetUserClaimsWithIDListeners(String userID, Map<String, String> claims, String profileName) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPreSetUserClaimValuesWithID(userID, claims, profileName, this)) continue;
                this.handleSetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUES.getMessage(), "Pre-listener tasks failed"), userID, claims, profileName);
                return;
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_SET_USER_CLAIM_VALUES.getMessage(), e.getMessage()), userID, claims, profileName);
            throw e;
        }
    }

    private void invokeDoPostSetUserClaimsWithIDListeners(String userID, Map<String, String> claims, String profileName) throws UserStoreException {
        try {
            for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
                if (((AbstractUserOperationEventListener)listener).doPostSetUserClaimValuesWithID(userID, claims, profileName, this)) continue;
                this.handleSetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUES.getMessage(), "Post-listener tasks failed"), userID, claims, profileName);
                return;
            }
        }
        catch (UserStoreException e) {
            this.handleSetUserClaimValuesFailureWithID(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUES.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_POST_SET_USER_CLAIM_VALUES.getMessage(), e.getMessage()), userID, claims, profileName);
            throw e;
        }
    }
}

