/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.claim.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.constants.UserCoreErrorConstants;
import org.wso2.carbon.user.core.util.DatabaseUtil;

public class ClaimDAO {
    private static Log log = LogFactory.getLog(DatabaseUtil.class);
    private DataSource dataSource = null;
    private int tenantId = -1;

    public ClaimDAO(DataSource dataSource, int tenantId) {
        this.dataSource = dataSource;
        this.tenantId = tenantId;
    }

    public void addClaimMapping(ClaimMapping claim) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            this.addClaimMapping(dbConnection, claim);
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Database Error - " + e.getMessage()), (Throwable)e);
            throw new UserStoreException("Database Error - " + e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeConnection(dbConnection);
        }
    }

    public void updateClaim(ClaimMapping claim) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            this.updateClaimMapping(dbConnection, claim);
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Database Error - " + e.getMessage()), (Throwable)e);
            throw new UserStoreException("Database Error - " + e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeConnection(dbConnection);
        }
    }

    public void deleteClaimMapping(ClaimMapping cm) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            this.deleteClaimMapping(dbConnection, cm.getClaim().getClaimUri(), cm.getClaim().getDialectURI());
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Database Error - " + e.getMessage()), (Throwable)e);
            throw new UserStoreException("Database Error - " + e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeConnection(dbConnection);
        }
    }

    public void deleteDialect(String dialectUri) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        try {
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            prepStmt = dbConnection.prepareStatement("SELECT UM_CLAIM_URI FROM UM_CLAIM, UM_DIALECT WHERE UM_CLAIM.UM_DIALECT_ID=UM_DIALECT.UM_ID AND UM_DIALECT_URI=? AND UM_CLAIM.UM_TENANT_ID=? AND UM_DIALECT.UM_TENANT_ID=?");
            prepStmt.setString(1, dialectUri);
            prepStmt.setInt(2, this.tenantId);
            prepStmt.setInt(3, this.tenantId);
            ResultSet rs = prepStmt.executeQuery();
            ArrayList<String> lst = new ArrayList<String>();
            while (rs.next()) {
                lst.add(rs.getString(1));
            }
            prepStmt.close();
            for (String claimUri : lst) {
                this.deleteClaimMapping(dbConnection, claimUri, dialectUri);
            }
            prepStmt = dbConnection.prepareStatement("DELETE FROM UM_DIALECT WHERE UM_DIALECT_URI=?");
            prepStmt.setString(1, dialectUri);
            prepStmt.executeUpdate();
            prepStmt.close();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Database Error - " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Database Error - " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    public void addCliamMappings(ClaimMapping[] claims) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            for (ClaimMapping claim : claims) {
                this.addClaimMapping(dbConnection, claim);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Database Error - " + e.getMessage()), (Throwable)e);
            DatabaseUtil.rollBack(dbConnection);
            throw new UserStoreException("Database Error - " + e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeConnection(dbConnection);
        }
    }

    public int getDialectCount() throws UserStoreException {
        int count = 0;
        PreparedStatement prepStmt = null;
        Connection dbConnection = null;
        ResultSet rs = null;
        try {
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            prepStmt = dbConnection.prepareStatement("SELECT COUNT(UM_ID) FROM UM_DIALECT WHERE UM_TENANT_ID=?");
            prepStmt.setInt(1, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Database Error - " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Database Error - " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return count;
    }

    protected void addClaimMapping(Connection dbConnection, ClaimMapping claimMapping) throws UserStoreException {
        PreparedStatement prepStmt = null;
        try {
            Map attributes;
            Claim claim = claimMapping.getClaim();
            int dialectId = this.getDialect(dbConnection, claim.getDialectURI());
            if (dialectId == -1) {
                dialectId = this.addDialect(dbConnection, claim.getDialectURI());
            }
            short isSupported = 0;
            if (claim.isSupportedByDefault()) {
                isSupported = 1;
            }
            short isRequired = 0;
            if (claim.isRequired()) {
                isRequired = 1;
            }
            short isCheckedAttributed = 0;
            if (claim.isCheckedAttribute()) {
                isCheckedAttributed = 1;
            }
            short isReadOnly = 0;
            if (claim.isReadOnly()) {
                isReadOnly = 1;
            }
            if (claimMapping.getMappedAttribute() != null) {
                prepStmt = dbConnection.prepareStatement("INSERT INTO UM_CLAIM(UM_DIALECT_ID, UM_CLAIM_URI, UM_DISPLAY_TAG, UM_DESCRIPTION, UM_MAPPED_ATTRIBUTE, UM_REG_EX, UM_SUPPORTED, UM_REQUIRED, UM_DISPLAY_ORDER, UM_TENANT_ID, UM_MAPPED_ATTRIBUTE_DOMAIN, UM_CHECKED_ATTRIBUTE,UM_READ_ONLY) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
                prepStmt.setInt(1, dialectId);
                prepStmt.setString(2, claim.getClaimUri());
                prepStmt.setString(3, claim.getDisplayTag());
                prepStmt.setString(4, claim.getDescription());
                prepStmt.setString(5, claimMapping.getMappedAttribute());
                prepStmt.setString(6, claim.getRegEx());
                prepStmt.setShort(7, isSupported);
                prepStmt.setShort(8, isRequired);
                prepStmt.setInt(9, claim.getDisplayOrder());
                prepStmt.setInt(10, this.tenantId);
                prepStmt.setString(11, null);
                prepStmt.setShort(12, isCheckedAttributed);
                prepStmt.setShort(13, isReadOnly);
                prepStmt.executeUpdate();
                prepStmt.close();
            }
            if ((attributes = claimMapping.getMappedAttributes()).size() > 0) {
                for (Map.Entry entry : attributes.entrySet()) {
                    prepStmt = dbConnection.prepareStatement("INSERT INTO UM_CLAIM(UM_DIALECT_ID, UM_CLAIM_URI, UM_DISPLAY_TAG, UM_DESCRIPTION, UM_MAPPED_ATTRIBUTE, UM_REG_EX, UM_SUPPORTED, UM_REQUIRED, UM_DISPLAY_ORDER, UM_TENANT_ID, UM_MAPPED_ATTRIBUTE_DOMAIN, UM_CHECKED_ATTRIBUTE,UM_READ_ONLY) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    prepStmt.setInt(1, dialectId);
                    prepStmt.setString(2, claim.getClaimUri());
                    prepStmt.setString(3, claim.getDisplayTag());
                    prepStmt.setString(4, claim.getDescription());
                    prepStmt.setString(5, (String)entry.getValue());
                    prepStmt.setString(6, claim.getRegEx());
                    prepStmt.setShort(7, isSupported);
                    prepStmt.setShort(8, isRequired);
                    prepStmt.setInt(9, claim.getDisplayOrder());
                    prepStmt.setInt(10, this.tenantId);
                    prepStmt.setString(11, (String)entry.getKey());
                    prepStmt.setShort(12, isCheckedAttributed);
                    prepStmt.setShort(13, isReadOnly);
                    prepStmt.executeUpdate();
                    prepStmt.close();
                }
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Database Error - " + e.getMessage()), (Throwable)e);
                if (e instanceof SQLIntegrityConstraintViolationException) {
                    throw new UserStoreException("Database Error - " + e.getMessage(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_ERROR_WHILE_ADDING_CLAIM_MAPPINGS.getCode(), e);
                }
                throw new UserStoreException("Database Error - " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    public List<ClaimMapping> loadClaimMappings() throws UserStoreException {
        ArrayList<ClaimMapping> claimList = new ArrayList<ClaimMapping>();
        PreparedStatement prepStmt = null;
        Connection dbConnection = null;
        ResultSet rs = null;
        HashMap<String, ClaimMapping> dialectMap = new HashMap<String, ClaimMapping>();
        try {
            dbConnection = this.dataSource.getConnection();
            prepStmt = dbConnection.prepareStatement("SELECT UM_DIALECT_URI, UM_CLAIM_URI, UM_DISPLAY_TAG, UM_DESCRIPTION, UM_MAPPED_ATTRIBUTE, UM_REG_EX, UM_SUPPORTED, UM_REQUIRED, UM_DISPLAY_ORDER,UM_MAPPED_ATTRIBUTE_DOMAIN, UM_CHECKED_ATTRIBUTE,UM_READ_ONLY FROM UM_CLAIM, UM_DIALECT WHERE UM_CLAIM.UM_DIALECT_ID=UM_DIALECT.UM_ID AND UM_CLAIM.UM_TENANT_ID=? AND UM_DIALECT.UM_TENANT_ID=?");
            prepStmt.setInt(1, this.tenantId);
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            String domainName = null;
            String attributeName = null;
            while (rs.next()) {
                ClaimMapping cm = new ClaimMapping();
                Claim claim = new Claim();
                String value = rs.getString(1);
                claim.setDialectURI(value);
                value = rs.getString(2);
                claim.setClaimUri(value);
                value = rs.getString(3);
                claim.setDisplayTag(value);
                value = rs.getString(4);
                claim.setDescription(value);
                attributeName = value = rs.getString(5);
                value = rs.getString(6);
                claim.setRegEx(value);
                short is = rs.getShort(7);
                if (is == 1) {
                    claim.setSupportedByDefault(true);
                }
                if ((is = rs.getShort(8)) == 1) {
                    claim.setRequired(true);
                }
                claim.setDisplayOrder(rs.getInt(9));
                domainName = value = rs.getString(10);
                is = rs.getShort(11);
                if (is == 1) {
                    claim.setCheckedAttribute(true);
                }
                if ((is = rs.getShort(12)) == 1) {
                    claim.setReadOnly(true);
                }
                cm.setClaim(claim);
                cm.setMappedAttribute(domainName, attributeName);
                if (dialectMap.get(claim.getDialectURI() + claim.getClaimUri()) == null) {
                    dialectMap.put(claim.getDialectURI() + claim.getClaimUri(), cm);
                    continue;
                }
                ClaimMapping mapping = (ClaimMapping)((Object)dialectMap.get(claim.getDialectURI() + claim.getClaimUri()));
                mapping.setMappedAttribute(domainName, attributeName);
                dialectMap.put(claim.getDialectURI() + claim.getClaimUri(), mapping);
            }
            for (Map.Entry entry : dialectMap.entrySet()) {
                claimList.add((ClaimMapping)((Object)entry.getValue()));
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Database Error - " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Database Error - " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return claimList;
    }

    protected void updateClaimMapping(Connection dbConnection, ClaimMapping claimMapping) throws UserStoreException {
        Claim claim = claimMapping.getClaim();
        this.deleteClaimMapping(dbConnection, claim.getClaimUri(), claim.getDialectURI());
        this.addClaimMapping(dbConnection, claimMapping);
    }

    protected void deleteClaimMapping(Connection dbConnection, String claimUri, String dialectUri) throws UserStoreException {
        PreparedStatement prepStmt = null;
        boolean isFinalRow = true;
        try {
            if (dialectUri.equals("http://wso2.org/claims")) {
                prepStmt = dbConnection.prepareStatement("SELECT UM_CLAIM_URI FROM UM_CLAIM, UM_DIALECT WHERE UM_CLAIM.UM_DIALECT_ID=UM_DIALECT.UM_ID AND UM_DIALECT_URI=? AND UM_CLAIM.UM_TENANT_ID=? AND UM_DIALECT.UM_TENANT_ID=?", 1004, 1007);
                prepStmt.setString(1, dialectUri);
                prepStmt.setInt(2, this.tenantId);
                prepStmt.setInt(3, this.tenantId);
                ResultSet rs = prepStmt.executeQuery();
                while (rs.next()) {
                    if (rs.getRow() <= 1) continue;
                    isFinalRow = false;
                    break;
                }
                if (isFinalRow) {
                    throw new UserStoreException("Cannot delete all claim mappings");
                }
            }
            prepStmt = dbConnection.prepareStatement("DELETE FROM UM_CLAIM WHERE UM_CLAIM_URI=? AND UM_DIALECT_ID=(SELECT UM_ID FROM UM_DIALECT WHERE UM_DIALECT_URI=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
            prepStmt.setString(1, claimUri);
            prepStmt.setString(2, dialectUri);
            prepStmt.setInt(3, this.tenantId);
            prepStmt.setInt(4, this.tenantId);
            prepStmt.executeUpdate();
            prepStmt.close();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Database Error - " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Database Error - " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    protected int getDialect(Connection dbConnection, String uri) throws UserStoreException {
        int dialectId = -1;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_DIALECT WHERE UM_DIALECT_URI=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, uri);
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                dialectId = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Database Error - " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Database Error - " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return dialectId;
    }

    protected int addDialect(Connection dbConnection, String uri) throws UserStoreException {
        int dialectId = -1;
        PreparedStatement prepStmt = null;
        try {
            prepStmt = dbConnection.prepareStatement("INSERT INTO UM_DIALECT (UM_DIALECT_URI, UM_TENANT_ID) VALUES (?, ?)");
            prepStmt.setString(1, uri);
            prepStmt.setInt(2, this.tenantId);
            prepStmt.executeUpdate();
            prepStmt.close();
            dialectId = this.getDialect(dbConnection, uri);
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Database Error - " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Database Error - " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
        return dialectId;
    }
}

