/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.claim;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimInvalidationCache;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.claim.builder.ClaimBuilder;
import org.wso2.carbon.user.core.claim.builder.ClaimBuilderException;
import org.wso2.carbon.user.core.claim.dao.ClaimDAO;
import org.wso2.carbon.user.core.internal.UMListenerServiceComponent;
import org.wso2.carbon.user.core.listener.ClaimManagerListener;

public class DefaultClaimManager
implements ClaimManager {
    private ClaimDAO claimDAO = null;
    private ClaimInvalidationCache claimCache;
    private DataSource datasource;
    private ClaimBuilder claimBuilder;
    private Map<String, ClaimMapping> claimMapping;

    public DefaultClaimManager(Map<String, ClaimMapping> claimMapping, DataSource dataSource, int tenantId) {
        this.datasource = dataSource;
        this.claimBuilder = new ClaimBuilder(tenantId);
        this.claimDAO = new ClaimDAO(dataSource, tenantId);
        this.claimCache = ClaimInvalidationCache.getInstance();
        if (this.claimBuilder != null && this.claimCache.isInvalid()) {
            try {
                this.claimMapping = this.getClaimMapFromDB();
            }
            catch (UserStoreException e) {
                this.claimMapping = new ConcurrentHashMap<String, ClaimMapping>();
                this.claimMapping.putAll(claimMapping);
                this.claimCache.invalidateCache();
            }
        } else {
            this.claimMapping = new ConcurrentHashMap<String, ClaimMapping>();
            this.claimMapping.putAll(claimMapping);
            this.claimCache.invalidateCache();
            if (ServerConfiguration.getInstance().getFirstProperty("Cache.ForceLocalCache") != null && ServerConfiguration.getInstance().getFirstProperty("Cache.ForceLocalCache").equals("true")) {
                this.claimCache.setIsAlreadyInitialize(true);
            }
        }
    }

    public String getAttributeName(String claimURI) throws UserStoreException {
        if (claimURI != null) {
            ClaimMapping mapping;
            for (ClaimManagerListener listener : UMListenerServiceComponent.getClaimManagerListeners()) {
                if (listener.getAttributeName(claimURI)) continue;
                return null;
            }
            if (this.claimCache.isInvalid()) {
                this.claimMapping = this.getClaimMapFromDB();
            }
            if ((mapping = this.claimMapping.get(claimURI)) != null) {
                return mapping.getMappedAttribute();
            }
        }
        return null;
    }

    public String getAttributeName(String domainName, String claimURI) throws UserStoreException {
        if (claimURI != null) {
            ClaimMapping mapping;
            for (ClaimManagerListener listener : UMListenerServiceComponent.getClaimManagerListeners()) {
                if (listener.getAttributeName(domainName, claimURI)) continue;
                return null;
            }
            if (this.claimCache.isInvalid()) {
                this.claimMapping = this.getClaimMapFromDB();
            }
            if ((mapping = this.claimMapping.get(claimURI)) != null) {
                if (domainName != null) {
                    String mappedAttrib = mapping.getMappedAttribute(domainName.toUpperCase());
                    if (mappedAttrib != null) {
                        return mappedAttrib;
                    }
                    return mapping.getMappedAttribute();
                }
                return mapping.getMappedAttribute();
            }
        }
        return null;
    }

    public Claim getClaim(String claimURI) throws UserStoreException {
        if (claimURI != null) {
            ClaimMapping mapping;
            for (ClaimManagerListener listener : UMListenerServiceComponent.getClaimManagerListeners()) {
                if (listener.getClaim(claimURI)) continue;
                return null;
            }
            if (this.claimCache.isInvalid()) {
                this.claimMapping = this.getClaimMapFromDB();
            }
            if ((mapping = this.claimMapping.get(claimURI)) != null) {
                return mapping.getClaim();
            }
        }
        return null;
    }

    public ClaimMapping getClaimMapping(String claimURI) throws UserStoreException {
        if (claimURI != null) {
            for (ClaimManagerListener listener : UMListenerServiceComponent.getClaimManagerListeners()) {
                if (listener.getClaimMapping(claimURI)) continue;
                return null;
            }
            if (this.claimCache.isInvalid()) {
                this.claimMapping = this.getClaimMapFromDB();
            }
            return this.claimMapping.get(claimURI);
        }
        throw new UserStoreException("claimURI value is null.");
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllSupportClaimMappingsByDefault() throws UserStoreException {
        for (ClaimManagerListener listener : UMListenerServiceComponent.getClaimManagerListeners()) {
            if (listener.getAllSupportClaimMappingsByDefault()) continue;
            return null;
        }
        if (this.claimCache.isInvalid()) {
            this.claimMapping = this.getClaimMapFromDB();
        }
        ArrayList<ClaimMapping> claimList = new ArrayList<ClaimMapping>();
        for (Map.Entry<String, ClaimMapping> claimMappingEntry : this.claimMapping.entrySet()) {
            ClaimMapping claimMapping = claimMappingEntry.getValue();
            if (claimMapping == null || claimMapping.getClaim() == null || !claimMapping.getClaim().isSupportedByDefault()) continue;
            claimList.add(claimMapping);
        }
        return claimList.toArray(new ClaimMapping[claimList.size()]);
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllClaimMappings() throws UserStoreException {
        for (ClaimManagerListener listener : UMListenerServiceComponent.getClaimManagerListeners()) {
            if (listener.getAllClaimMappings()) continue;
            return null;
        }
        if (this.claimCache.isInvalid()) {
            this.claimMapping = this.getClaimMapFromDB();
        }
        ArrayList<ClaimMapping> claimList = new ArrayList<ClaimMapping>();
        for (Map.Entry<String, ClaimMapping> claimMappingEntry : this.claimMapping.entrySet()) {
            ClaimMapping claimMapping = claimMappingEntry.getValue();
            if (claimMapping == null) continue;
            claimList.add(claimMapping);
        }
        return claimList.toArray(new ClaimMapping[claimList.size()]);
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllClaimMappings(String dialectUri) throws UserStoreException {
        ArrayList<ClaimMapping> claimList = new ArrayList<ClaimMapping>();
        if (dialectUri != null) {
            for (ClaimManagerListener claimManagerListener : UMListenerServiceComponent.getClaimManagerListeners()) {
                if (claimManagerListener.getAllClaimMappings(dialectUri)) continue;
                return null;
            }
            if (this.claimCache.isInvalid()) {
                this.claimMapping = this.getClaimMapFromDB();
            }
            for (Map.Entry entry : this.claimMapping.entrySet()) {
                ClaimMapping claimMapping = (ClaimMapping)((Object)entry.getValue());
                if (claimMapping == null || claimMapping.getClaim() == null || !claimMapping.getClaim().getDialectURI().equals(dialectUri)) continue;
                claimList.add(claimMapping);
            }
        }
        return claimList.toArray(new ClaimMapping[claimList.size()]);
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllRequiredClaimMappings() throws UserStoreException {
        for (ClaimManagerListener listener : UMListenerServiceComponent.getClaimManagerListeners()) {
            if (listener.getAllRequiredClaimMappings()) continue;
            return null;
        }
        if (this.claimCache.isInvalid()) {
            this.claimMapping = this.getClaimMapFromDB();
        }
        ArrayList<ClaimMapping> claimList = new ArrayList<ClaimMapping>();
        for (Map.Entry<String, ClaimMapping> entry : this.claimMapping.entrySet()) {
            ClaimMapping claimMapping = entry.getValue();
            if (claimMapping == null || claimMapping.getClaim() == null || !claimMapping.getClaim().isRequired()) continue;
            claimList.add(claimMapping);
        }
        return claimList.toArray(new ClaimMapping[claimList.size()]);
    }

    public String[] getAllClaimUris() throws UserStoreException {
        for (ClaimManagerListener listener : UMListenerServiceComponent.getClaimManagerListeners()) {
            if (listener.getAllClaimUris()) continue;
            return null;
        }
        if (this.claimCache.isInvalid()) {
            this.claimMapping = this.getClaimMapFromDB();
        }
        return this.claimMapping.keySet().toArray(new String[this.claimMapping.size()]);
    }

    public void addNewClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws org.wso2.carbon.user.api.UserStoreException {
        if (mapping != null && mapping.getClaim() != null) {
            for (ClaimManagerListener listener : UMListenerServiceComponent.getClaimManagerListeners()) {
                if (listener.addNewClaimMapping(mapping)) continue;
                return;
            }
            if (this.claimCache.isInvalid()) {
                this.claimMapping = this.getClaimMapFromDB();
            }
            this.addNewClaimMapping(this.getClaimMapping(mapping));
            this.claimCache.invalidateCache();
        }
    }

    public void addNewClaimMapping(ClaimMapping mapping) throws UserStoreException {
        if (mapping != null && mapping.getClaim() != null) {
            for (ClaimManagerListener listener : UMListenerServiceComponent.getClaimManagerListeners()) {
                if (listener.addNewClaimMapping(mapping)) continue;
                return;
            }
            if (this.claimCache.isInvalid()) {
                this.claimMapping = this.getClaimMapFromDB();
            }
            if (!this.claimMapping.containsKey(mapping.getClaim().getClaimUri())) {
                this.claimMapping.put(mapping.getClaim().getClaimUri(), mapping);
                this.claimDAO.addClaimMapping(mapping);
                this.claimCache.invalidateCache();
            }
        }
    }

    public void deleteClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws UserStoreException {
        if (mapping != null && mapping.getClaim() != null) {
            for (ClaimManagerListener listener : UMListenerServiceComponent.getClaimManagerListeners()) {
                if (listener.deleteClaimMapping(mapping)) continue;
                return;
            }
            if (this.claimCache.isInvalid()) {
                this.claimMapping = this.getClaimMapFromDB();
            }
            if (this.claimMapping.containsKey(mapping.getClaim().getClaimUri())) {
                this.claimMapping.remove(mapping.getClaim().getClaimUri());
                this.claimDAO.deleteClaimMapping(this.getClaimMapping(mapping));
                this.claimCache.invalidateCache();
            }
        }
    }

    public void updateClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws UserStoreException {
        if (mapping != null && mapping.getClaim() != null) {
            for (ClaimManagerListener listener : UMListenerServiceComponent.getClaimManagerListeners()) {
                if (listener.updateClaimMapping(mapping)) continue;
                return;
            }
            if (this.claimCache.isInvalid()) {
                this.claimMapping = this.getClaimMapFromDB();
            }
            if (this.claimMapping.containsKey(mapping.getClaim().getClaimUri())) {
                this.claimMapping.put(mapping.getClaim().getClaimUri(), this.getClaimMapping(mapping));
                this.claimDAO.updateClaim(this.getClaimMapping(mapping));
                this.claimCache.invalidateCache();
            }
        }
    }

    private ClaimMapping getClaimMapping(org.wso2.carbon.user.api.ClaimMapping claimMapping) {
        if (claimMapping == null) {
            return new ClaimMapping();
        }
        ClaimMapping claimMap = new ClaimMapping(this.getClaim(claimMapping.getClaim()), claimMapping.getMappedAttribute());
        claimMap.setMappedAttributes(claimMapping.getMappedAttributes());
        return claimMap;
    }

    private Claim getClaim(org.wso2.carbon.user.api.Claim claim) {
        Claim clm = new Claim();
        if (claim != null) {
            clm.setCheckedAttribute(claim.isCheckedAttribute());
            clm.setClaimUri(claim.getClaimUri());
            clm.setDescription(claim.getDescription());
            clm.setDialectURI(claim.getDialectURI());
            clm.setDisplayOrder(claim.getDisplayOrder());
            clm.setDisplayTag(claim.getDisplayTag());
            clm.setReadOnly(claim.isReadOnly());
            clm.setRegEx(claim.getRegEx());
            clm.setRequired(claim.isRequired());
            clm.setSupportedByDefault(claim.isSupportedByDefault());
            clm.setValue(claim.getValue());
        }
        return clm;
    }

    private Map<String, ClaimMapping> getClaimMapFromDB() throws UserStoreException {
        ConcurrentHashMap<String, ClaimMapping> claimMap = new ConcurrentHashMap<String, ClaimMapping>();
        try {
            Map<String, ClaimMapping> dbClaimMap = this.claimBuilder.buildClaimMappingsFromDatabase(this.datasource, null);
            claimMap.putAll(dbClaimMap);
        }
        catch (ClaimBuilderException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        return claimMap;
    }
}

