/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.authorization;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.api.GhostResource;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.authorization.PermissionTreeCacheKey;
import org.wso2.carbon.user.core.authorization.PermissionTreeUtil;
import org.wso2.carbon.user.core.authorization.SearchResult;
import org.wso2.carbon.user.core.authorization.TreeNode;
import org.wso2.carbon.user.core.internal.UserStoreMgtDSComponent;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.xml.StringUtils;

public class PermissionTree {
    private static final String PERMISSION_CACHE_MANAGER = "PERMISSION_CACHE_MANAGER";
    private static final String PERMISSION_CACHE = "PERMISSION_CACHE";
    private static final String CASE_INSENSITIVE_USERNAME = "CaseInsensitiveUsername";
    private static Log log = LogFactory.getLog(PermissionTree.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    protected TreeNode root = new TreeNode("/");
    protected int tenantId;
    protected String cacheIdentifier;
    protected volatile int hashValueOfRootNode;
    protected DataSource dataSource;
    protected boolean preserveCaseForResources = true;

    public PermissionTree(String cacheIdentifier, int tenantId, DataSource dataSource) {
        this.cacheIdentifier = cacheIdentifier;
        this.tenantId = tenantId;
        this.dataSource = dataSource;
    }

    public PermissionTree(String cacheIdentifier, int tenantId, DataSource dataSource, boolean preserveCaseForResources) {
        this.cacheIdentifier = cacheIdentifier;
        this.tenantId = tenantId;
        this.dataSource = dataSource;
        this.preserveCaseForResources = preserveCaseForResources;
    }

    private PermissionTree() {
    }

    private Cache<PermissionTreeCacheKey, GhostResource<TreeNode>> getPermissionTreeCache() {
        Cache cache = null;
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(PERMISSION_CACHE_MANAGER);
        cache = cacheManager.getCache(PERMISSION_CACHE);
        return cache;
    }

    void authorizeUserInTree(String userName, String resourceId, String action, boolean updateCache) throws UserStoreException {
        if (!this.isCaseSensitiveUsername(userName, this.tenantId)) {
            userName = userName.toLowerCase();
        }
        this.write.lock();
        try {
            SearchResult sr = this.getNode(this.root, PermissionTreeUtil.toComponenets(resourceId));
            if (sr.getUnprocessedPaths() != null) {
                List<String> paths = sr.getUnprocessedPaths();
                TreeNode tn = sr.getLastNode().create(paths);
                tn.authorizeUser(userName, PermissionTreeUtil.actionToPermission(action));
            } else {
                sr.getLastNode().authorizeUser(userName, PermissionTreeUtil.actionToPermission(action));
            }
            if (updateCache) {
                this.invalidateCache(this.root);
            }
        }
        catch (IllegalArgumentException e) {
            throw new UserStoreException("Error while authorizing user: " + userName + "in permission tree for resource id: " + resourceId + "for action: " + action, e);
        }
        finally {
            this.write.unlock();
        }
    }

    void denyUserInTree(String userName, String resourceId, String action, boolean updateCache) throws UserStoreException {
        if (!this.isCaseSensitiveUsername(userName, this.tenantId)) {
            userName = userName.toLowerCase();
        }
        this.write.lock();
        try {
            SearchResult sr = this.getNode(this.root, PermissionTreeUtil.toComponenets(resourceId));
            if (sr.getUnprocessedPaths() != null) {
                List<String> paths = sr.getUnprocessedPaths();
                TreeNode tn = sr.getLastNode().create(paths);
                tn.denyUser(userName, PermissionTreeUtil.actionToPermission(action));
            } else {
                sr.getLastNode().denyUser(userName, PermissionTreeUtil.actionToPermission(action));
            }
            if (updateCache) {
                this.invalidateCache(this.root);
            }
        }
        catch (IllegalArgumentException e) {
            throw new UserStoreException("Error while denying user: " + userName + "in permission tree for resource id: " + resourceId + "for action: " + action, e);
        }
        finally {
            this.write.unlock();
        }
    }

    void authorizeRoleInTree(String roleName, String resourceId, String action, boolean updateCache) throws UserStoreException {
        this.write.lock();
        try {
            SearchResult sr = this.getNode(this.root, PermissionTreeUtil.toComponenets(resourceId));
            if (sr.getUnprocessedPaths() != null) {
                List<String> paths = sr.getUnprocessedPaths();
                TreeNode tn = sr.getLastNode().create(paths);
                tn.authorizeRole(roleName, PermissionTreeUtil.actionToPermission(action));
            } else {
                sr.getLastNode().authorizeRole(roleName, PermissionTreeUtil.actionToPermission(action));
            }
            if (updateCache) {
                this.invalidateCache(this.root);
            }
        }
        catch (IllegalArgumentException e) {
            throw new UserStoreException("Error while authorizing role: " + roleName + "in permission tree for resource id: " + resourceId + "for action: " + action, e);
        }
        finally {
            this.write.unlock();
        }
    }

    void denyRoleInTree(String roleName, String resourceId, String action, boolean updateCache) throws UserStoreException {
        this.write.lock();
        try {
            SearchResult sr = this.getNode(this.root, PermissionTreeUtil.toComponenets(resourceId));
            if (sr.getUnprocessedPaths() != null) {
                List<String> paths = sr.getUnprocessedPaths();
                TreeNode tn = sr.getLastNode().create(paths);
                tn.denyRole(roleName, PermissionTreeUtil.actionToPermission(action));
            } else {
                sr.getLastNode().denyRole(roleName, PermissionTreeUtil.actionToPermission(action));
            }
            if (updateCache) {
                this.invalidateCache(this.root);
            }
        }
        catch (IllegalArgumentException e) {
            throw new UserStoreException("Error while denying role: " + roleName + "in permission tree for resource id: " + resourceId + "for action: " + action, e);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchResult getRolePermission(String role, TreeNode.Permission permission, SearchResult sr, TreeNode node, List<String> pathParts) {
        this.read.lock();
        try {
            TreeNode child;
            Boolean currentNodeAllows;
            if (node == null) {
                node = this.root;
            }
            if (sr == null) {
                sr = new SearchResult();
            }
            if ((currentNodeAllows = node.isRoleAuthorized(role, permission)) == Boolean.TRUE) {
                sr.setLastNodeAllowedAccess(Boolean.TRUE);
            } else if (currentNodeAllows == Boolean.FALSE) {
                sr.setLastNodeAllowedAccess(Boolean.FALSE);
            }
            if (pathParts == null || pathParts.isEmpty()) {
                sr.setLastNode(node);
                sr.setUnprocessedPaths(null);
                SearchResult searchResult = sr;
                return searchResult;
            }
            String key = pathParts.get(0);
            if (key != null && key.length() > 0 && (child = node.getChild(key)) != null) {
                pathParts.remove(0);
                SearchResult searchResult = this.getRolePermission(role, permission, sr, child, pathParts);
                return searchResult;
            }
            sr.setLastNode(node);
            SearchResult searchResult = sr;
            return searchResult;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchResult getUserPermission(String user, TreeNode.Permission permission, SearchResult sr, TreeNode node, List<String> pathParts) {
        if (!this.isCaseSensitiveUsername(user, this.tenantId)) {
            user = user.toLowerCase();
        }
        this.read.lock();
        try {
            TreeNode child;
            Boolean currentNodeAllows;
            if (node == null) {
                node = this.root;
            }
            if (sr == null) {
                sr = new SearchResult();
            }
            if ((currentNodeAllows = node.isUserAuthorized(user, permission)) == Boolean.TRUE) {
                sr.setLastNodeAllowedAccess(Boolean.TRUE);
            } else if (currentNodeAllows == Boolean.FALSE) {
                sr.setLastNodeAllowedAccess(Boolean.FALSE);
            }
            if (pathParts == null || pathParts.isEmpty()) {
                sr.setLastNode(node);
                sr.setUnprocessedPaths(null);
                SearchResult searchResult = sr;
                return searchResult;
            }
            String key = pathParts.get(0);
            if (key != null && key.length() > 0 && (child = node.getChild(key)) != null) {
                pathParts.remove(0);
                SearchResult searchResult = this.getUserPermission(user, permission, sr, child, pathParts);
                return searchResult;
            }
            sr.setLastNode(node);
            SearchResult searchResult = sr;
            return searchResult;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchResult getAllowedUsersForResource(SearchResult sr, TreeNode node, TreeNode.Permission permission, List<String> pathParts) {
        this.read.lock();
        try {
            TreeNode treeNode;
            if (node == null) {
                node = this.root;
            }
            if (sr == null) {
                sr = new SearchResult();
            }
            Map<String, BitSet> allowUsers = node.getUserAllowPermissions();
            for (Map.Entry<String, BitSet> entry : allowUsers.entrySet()) {
                BitSet searchResult = entry.getValue();
                if (!searchResult.get(permission.ordinal()) || sr.getAllowedEntities().contains(entry.getKey())) continue;
                sr.getAllowedEntities().add((String)entry.getKey());
            }
            Map<String, BitSet> denyUsers = node.getUserDenyPermissions();
            for (Map.Entry entry : denyUsers.entrySet()) {
                BitSet bs = (BitSet)entry.getValue();
                if (!bs.get(permission.ordinal()) || !sr.getAllowedEntities().contains(entry.getKey())) continue;
                sr.getAllowedEntities().remove(entry.getKey());
            }
            if (pathParts == null || pathParts.isEmpty()) {
                Map.Entry<String, BitSet> entry;
                sr.setLastNode(node);
                sr.setUnprocessedPaths(null);
                entry = sr;
                return entry;
            }
            String key = pathParts.get(0);
            if (key != null && key.length() > 0 && (treeNode = node.getChild(key)) != null) {
                pathParts.remove(0);
                SearchResult searchResult = this.getAllowedUsersForResource(sr, treeNode, permission, pathParts);
                return searchResult;
            }
            sr.setLastNode(node);
            SearchResult searchResult = sr;
            return searchResult;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchResult getAllowedRolesForResource(SearchResult sr, TreeNode node, TreeNode.Permission permission, List<String> pathParts) {
        this.read.lock();
        try {
            TreeNode treeNode;
            if (node == null) {
                node = this.root;
            }
            if (sr == null) {
                sr = new SearchResult();
            }
            Map<String, BitSet> allowRoles = node.getRoleAllowPermissions();
            for (Map.Entry<String, BitSet> entry : allowRoles.entrySet()) {
                BitSet searchResult = entry.getValue();
                if (!searchResult.get(permission.ordinal()) || sr.getAllowedEntities().contains(entry.getKey())) continue;
                sr.getAllowedEntities().add((String)entry.getKey());
            }
            Map<String, BitSet> denyRoles = node.getRoleDenyPermissions();
            for (Map.Entry entry : denyRoles.entrySet()) {
                BitSet bs = (BitSet)entry.getValue();
                if (!bs.get(permission.ordinal()) || !sr.getAllowedEntities().contains(entry.getKey())) continue;
                sr.getAllowedEntities().remove(entry.getKey());
            }
            if (pathParts == null || pathParts.isEmpty()) {
                Map.Entry<String, BitSet> entry;
                sr.setLastNode(node);
                sr.setUnprocessedPaths(null);
                entry = sr;
                return entry;
            }
            String key = pathParts.get(0);
            if (key != null && key.length() > 0 && (treeNode = node.getChild(key)) != null) {
                pathParts.remove(0);
                SearchResult searchResult = this.getAllowedRolesForResource(sr, treeNode, permission, pathParts);
                return searchResult;
            }
            sr.setLastNode(node);
            SearchResult searchResult = sr;
            return searchResult;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchResult getDeniedRolesForResource(SearchResult sr, TreeNode node, TreeNode.Permission permission, List<String> pathParts) {
        this.read.lock();
        try {
            TreeNode treeNode;
            if (sr == null) {
                sr = new SearchResult();
            }
            if (node == null) {
                node = this.root;
            }
            Map<String, BitSet> denyRoles = node.getRoleDenyPermissions();
            for (Map.Entry<String, BitSet> entry : denyRoles.entrySet()) {
                BitSet searchResult = entry.getValue();
                if (!searchResult.get(permission.ordinal()) || sr.getDeniedEntities().contains(entry.getKey())) continue;
                sr.getDeniedEntities().add((String)entry.getKey());
            }
            Map<String, BitSet> allowRoles = node.getRoleAllowPermissions();
            for (Map.Entry entry : allowRoles.entrySet()) {
                BitSet bs = (BitSet)entry.getValue();
                if (!bs.get(permission.ordinal()) || !sr.getDeniedEntities().contains(entry.getKey())) continue;
                sr.getDeniedEntities().remove(entry.getKey());
            }
            if (pathParts == null || pathParts.isEmpty()) {
                Map.Entry<String, BitSet> entry;
                sr.setLastNode(node);
                sr.setUnprocessedPaths(null);
                entry = sr;
                return entry;
            }
            String key = pathParts.get(0);
            if (key != null && key.length() > 0 && (treeNode = node.getChild(key)) != null) {
                pathParts.remove(0);
                SearchResult searchResult = this.getDeniedRolesForResource(sr, treeNode, permission, pathParts);
                return searchResult;
            }
            sr.setLastNode(node);
            SearchResult searchResult = sr;
            return searchResult;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchResult getDeniedUsersForResource(SearchResult sr, TreeNode node, TreeNode.Permission permission, List<String> pathParts) {
        this.read.lock();
        try {
            TreeNode treeNode;
            if (sr == null) {
                sr = new SearchResult();
            }
            if (node == null) {
                node = this.root;
            }
            Map<String, BitSet> denyUsers = node.getUserDenyPermissions();
            for (Map.Entry<String, BitSet> entry : denyUsers.entrySet()) {
                BitSet searchResult = entry.getValue();
                if (!searchResult.get(permission.ordinal()) || sr.getDeniedEntities().contains(entry.getKey())) continue;
                sr.getDeniedEntities().add((String)entry.getKey());
            }
            Map<String, BitSet> allowUsers = node.getUserAllowPermissions();
            for (Map.Entry entry : allowUsers.entrySet()) {
                BitSet bs = (BitSet)entry.getValue();
                if (!bs.get(permission.ordinal()) || !sr.getDeniedEntities().contains(entry.getKey())) continue;
                sr.getDeniedEntities().remove(entry.getKey());
            }
            if (pathParts == null || pathParts.isEmpty()) {
                Map.Entry<String, BitSet> entry;
                sr.setLastNode(node);
                sr.setUnprocessedPaths(null);
                entry = sr;
                return entry;
            }
            String key = pathParts.get(0);
            if (key != null && key.length() > 0 && (treeNode = node.getChild(key)) != null) {
                pathParts.remove(0);
                SearchResult searchResult = this.getDeniedUsersForResource(sr, treeNode, permission, pathParts);
                return searchResult;
            }
            sr.setLastNode(node);
            SearchResult searchResult = sr;
            return searchResult;
        }
        finally {
            this.read.unlock();
        }
    }

    void clearRoleAuthorization(String roleName, String action) throws UserStoreException {
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.clearRoleAuthorization(roleName, this.root, permission);
        this.invalidateCache(this.root);
    }

    void updateRoleNameInCache(String roleName, String newRoleName) throws UserStoreException {
        this.updateRoleNameInCache(roleName, newRoleName, this.root);
        this.invalidateCache(this.root);
    }

    void clearRoleAuthorization(String roleName) throws UserStoreException {
        this.clearRoleAuthorization(roleName, this.root);
        this.invalidateCache(this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRoleAuthorization(String roleName, String resourceId, String action) throws UserStoreException {
        SearchResult sr = this.getNode(this.root, PermissionTreeUtil.toComponenets(resourceId));
        this.write.lock();
        try {
            if (sr.getUnprocessedPaths() == null) {
                Map<String, BitSet> denyRoles;
                TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
                Map<String, BitSet> allowRoles = sr.getLastNode().getRoleAllowPermissions();
                BitSet bs = allowRoles.get(roleName);
                if (bs == null) {
                    bs = allowRoles.get(this.modify(roleName));
                }
                if (bs != null) {
                    bs.clear(permission.ordinal());
                }
                if ((bs = (denyRoles = sr.getLastNode().getRoleDenyPermissions()).get(roleName)) != null) {
                    bs.clear(permission.ordinal());
                }
            }
            this.invalidateCache(this.root);
        }
        finally {
            this.write.unlock();
        }
    }

    void clearUserAuthorization(String userName) throws UserStoreException {
        this.clearUserAuthorization(userName, this.root);
        this.invalidateCache(this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearUserAuthorization(String userName, String resourceId, String action) throws UserStoreException {
        if (!this.isCaseSensitiveUsername(userName, this.tenantId)) {
            userName = userName.toLowerCase();
        }
        this.write.lock();
        try {
            SearchResult sr = this.getNode(this.root, PermissionTreeUtil.toComponenets(resourceId));
            if (sr.getUnprocessedPaths() == null || sr.getUnprocessedPaths().isEmpty()) {
                Map<String, BitSet> denyUsers;
                TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
                Map<String, BitSet> allowUsers = sr.getLastNode().getUserAllowPermissions();
                BitSet bs = allowUsers.get(userName);
                if (bs != null) {
                    bs.clear(permission.ordinal());
                }
                if ((bs = (denyUsers = sr.getLastNode().getUserDenyPermissions()).get(userName)) != null) {
                    bs.clear(permission.ordinal());
                }
            }
            this.invalidateCache(this.root);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getUIResourcesForRoles(String[] roles, List<String> resources, String path) throws UserStoreException {
        List<String> paths = PermissionTreeUtil.toComponenets(path);
        TreeNode node = null;
        this.read.lock();
        try {
            node = this.root;
            for (String name : paths) {
                if ((node = node.getChild(name)) != null) continue;
                break;
            }
        }
        finally {
            this.read.unlock();
        }
        if (node == null) {
            throw new UserStoreException("Invalid Permission root path provided");
        }
        TreeNode permissionNode = this.root.getChild("permission");
        if (permissionNode == null) {
            throw new UserStoreException("Invalid Permission root path provided");
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.getUIResourcesForRoles(roles, resources, "", PermissionTreeUtil.actionToPermission("ui.execute"), permissionNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getUIResourcesForRoles(String[] roles, List<String> resources, String path, TreeNode.Permission permission, TreeNode node) {
        this.read.lock();
        try {
            String currentPath = path + "/" + node.getName();
            Map<String, BitSet> bsAllowed = node.getRoleAllowPermissions();
            for (String role : roles) {
                BitSet bs = bsAllowed.get(role);
                if (bs == null) {
                    bs = bsAllowed.get(this.modify(role));
                }
                if (bs == null || !bs.get(permission.ordinal())) continue;
                resources.add(currentPath);
                break;
            }
            Map<String, TreeNode> children = node.getChildren();
            for (TreeNode treeNode : children.values()) {
                if (treeNode == null) continue;
                this.getUIResourcesForRoles(roles, resources, currentPath, permission, treeNode);
            }
        }
        finally {
            this.read.unlock();
        }
    }

    void clearResourceAuthorizations(String resourceId) throws UserStoreException {
        this.write.lock();
        try {
            SearchResult sr = this.getNode(this.root, PermissionTreeUtil.toComponenets(resourceId));
            if (sr.getUnprocessedPaths() == null) {
                sr.getLastNode().getUserAllowPermissions().clear();
                sr.getLastNode().getUserDenyPermissions().clear();
                sr.getLastNode().getRoleAllowPermissions().clear();
                sr.getLastNode().getRoleDenyPermissions().clear();
            }
            this.invalidateCache(this.root);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRoleAuthorization(String roleName, TreeNode node, TreeNode.Permission permission) {
        this.write.lock();
        try {
            Map<String, TreeNode> childMap;
            Map<String, BitSet> allowRoles = node.getRoleAllowPermissions();
            Map<String, BitSet> denyRoles = node.getRoleDenyPermissions();
            BitSet bs = allowRoles.get(roleName);
            if (bs == null) {
                bs = allowRoles.get(this.modify(roleName));
            }
            if (bs != null) {
                bs.clear(permission.ordinal());
            }
            if ((bs = denyRoles.get(roleName)) != null) {
                bs.clear(permission.ordinal());
            }
            if ((childMap = node.getChildren()) != null && childMap.size() > 0) {
                for (TreeNode treeNode : childMap.values()) {
                    this.clearRoleAuthorization(roleName, treeNode, permission);
                }
            }
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRoleAuthorization(String roleName, TreeNode node) {
        this.write.lock();
        try {
            Map<String, TreeNode> childMap;
            Map<String, BitSet> allowRoles = node.getRoleAllowPermissions();
            Map<String, BitSet> denyRoles = node.getRoleDenyPermissions();
            BitSet bs = allowRoles.get(roleName);
            boolean modified = false;
            if (bs == null) {
                bs = allowRoles.get(this.modify(roleName));
                modified = true;
            }
            if (bs != null) {
                if (modified) {
                    allowRoles.remove(this.modify(roleName));
                } else {
                    allowRoles.remove(roleName);
                }
            }
            modified = false;
            bs = denyRoles.get(roleName);
            if (bs == null) {
                bs = denyRoles.get(this.modify(roleName));
                modified = true;
            }
            if (bs != null) {
                if (modified) {
                    denyRoles.remove(this.modify(roleName));
                } else {
                    denyRoles.remove(roleName);
                }
            }
            if ((childMap = node.getChildren()) != null && childMap.size() > 0) {
                for (TreeNode treeNode : childMap.values()) {
                    this.clearRoleAuthorization(roleName, treeNode);
                }
            }
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRoleNameInCache(String roleName, String newRoleName, TreeNode node) {
        Map<String, BitSet> allowRoles = node.getRoleAllowPermissions();
        Map<String, BitSet> denyRoles = node.getRoleDenyPermissions();
        this.write.lock();
        try {
            Map<String, TreeNode> childMap;
            boolean modified = false;
            BitSet bs = allowRoles.get(roleName);
            if (bs == null) {
                bs = allowRoles.get(this.modify(roleName));
                modified = true;
            }
            if (bs != null) {
                if (!modified) {
                    allowRoles.remove(roleName);
                } else {
                    allowRoles.remove(this.modify(roleName));
                }
                allowRoles.put(this.modify(newRoleName), bs);
            }
            modified = false;
            bs = denyRoles.get(roleName);
            if (bs == null) {
                bs = denyRoles.get(this.modify(roleName));
                modified = true;
            }
            if (bs != null) {
                if (!modified) {
                    denyRoles.remove(roleName);
                } else {
                    denyRoles.remove(this.modify(roleName));
                }
                denyRoles.put(this.modify(newRoleName), bs);
            }
            if ((childMap = node.getChildren()) != null && childMap.size() > 0) {
                for (TreeNode treeNode : childMap.values()) {
                    this.updateRoleNameInCache(roleName, newRoleName, treeNode);
                }
            }
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearUserAuthorization(String userName, TreeNode node) {
        if (!this.isCaseSensitiveUsername(userName, this.tenantId)) {
            userName = userName.toLowerCase();
        }
        this.write.lock();
        try {
            Map<String, TreeNode> childMap;
            Map<String, BitSet> allowUsers = node.getUserAllowPermissions();
            Map<String, BitSet> denyUsers = node.getUserDenyPermissions();
            BitSet bs = allowUsers.get(userName);
            if (bs != null) {
                allowUsers.remove(userName);
            }
            if ((bs = denyUsers.get(userName)) != null) {
                denyUsers.remove(userName);
            }
            if ((childMap = node.getChildren()) != null && childMap.size() > 0) {
                for (TreeNode treeNode : childMap.values()) {
                    this.clearUserAuthorization(userName, treeNode);
                }
            }
        }
        finally {
            this.write.unlock();
        }
    }

    void clear() {
        Cache<PermissionTreeCacheKey, GhostResource<TreeNode>> permissionCache = this.getPermissionTreeCache();
        if (permissionCache != null) {
            this.write.lock();
            try {
                this.root.clearNodes();
                this.hashValueOfRootNode = -1;
                PermissionTreeCacheKey cacheKey = new PermissionTreeCacheKey(this.cacheIdentifier, this.tenantId);
                permissionCache.remove((Object)cacheKey);
            }
            finally {
                this.write.unlock();
            }
        }
    }

    void updatePermissionTree() throws UserStoreException {
        this.updatePermissionTree("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePermissionTree(String resourceId) throws UserStoreException {
        Cache<PermissionTreeCacheKey, GhostResource<TreeNode>> permissionCache = this.getPermissionTreeCache();
        if (permissionCache != null) {
            PermissionTreeCacheKey cacheKey = new PermissionTreeCacheKey(this.cacheIdentifier, this.tenantId);
            GhostResource cacheEntry = (GhostResource)permissionCache.get((Object)cacheKey);
            if (permissionCache.containsKey((Object)cacheKey) && cacheEntry != null) {
                if (cacheEntry.getResource() == null) {
                    PermissionTree permissionTree = this;
                    synchronized (permissionTree) {
                        cacheEntry = (GhostResource)permissionCache.get((Object)cacheKey);
                        if (cacheEntry == null || cacheEntry.getResource() == null) {
                            this.updatePermissionTreeFromDB();
                            if (cacheEntry == null) {
                                cacheEntry = new GhostResource((Object)this.root);
                                permissionCache.put((Object)cacheKey, (Object)cacheEntry);
                            } else {
                                cacheEntry.setResource((Object)this.root);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Set resource to true");
                            }
                        }
                    }
                } else if (!StringUtils.isEmpty((String)resourceId)) {
                    PermissionTree permissionTree = this;
                    synchronized (permissionTree) {
                        this.updateResourcePermissionsById(resourceId);
                        cacheEntry.setResource((Object)this.root);
                    }
                }
            } else {
                PermissionTree permissionTree = this;
                synchronized (permissionTree) {
                    cacheEntry = (GhostResource)permissionCache.get((Object)cacheKey);
                    if (cacheEntry == null || cacheEntry.getResource() == null) {
                        block23: {
                            this.updatePermissionTreeFromDB();
                            cacheKey = new PermissionTreeCacheKey(this.cacheIdentifier, this.tenantId);
                            cacheEntry = new GhostResource((Object)this.root);
                            try {
                                permissionCache.put((Object)cacheKey, (Object)cacheEntry);
                            }
                            catch (IllegalStateException e) {
                                String msg = "Error occurred while adding the permission tree to cache while trying to update resource: " + resourceId + " in tenant: " + this.tenantId;
                                log.warn((Object)msg);
                                if (!log.isDebugEnabled()) break block23;
                                log.debug((Object)msg, (Throwable)e);
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Permission tree is loaded from database for the resource " + resourceId + " in tenant " + this.tenantId));
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateResourcePermissionsById(String resourceId) throws UserStoreException {
        Connection dbConnection = null;
        ResultSet rs = null;
        PreparedStatement statement = null;
        try {
            PermissionTree tree = new PermissionTree();
            tree.root = this.root;
            dbConnection = this.getDBConnection();
            statement = this.preserveCaseForResources ? dbConnection.prepareStatement("SELECT UM_ROLE_NAME, UM_RESOURCE_ID, UM_IS_ALLOWED, UM_ACTION, UM_DOMAIN_NAME FROM UM_PERMISSION, UM_ROLE_PERMISSION, UM_DOMAIN WHERE UM_ROLE_PERMISSION.UM_PERMISSION_ID=UM_PERMISSION.UM_ID AND UM_ROLE_PERMISSION.UM_DOMAIN_ID=UM_DOMAIN.UM_DOMAIN_ID AND UM_PERMISSION.UM_TENANT_ID=? AND UM_ROLE_PERMISSION.UM_TENANT_ID=? AND UM_RESOURCE_ID=?") : dbConnection.prepareStatement("SELECT UM_ROLE_NAME, LOWER(UM_RESOURCE_ID), UM_IS_ALLOWED, UM_ACTION, UM_DOMAIN_NAME FROM UM_PERMISSION, UM_ROLE_PERMISSION, UM_DOMAIN WHERE UM_ROLE_PERMISSION.UM_PERMISSION_ID=UM_PERMISSION.UM_ID AND UM_ROLE_PERMISSION.UM_DOMAIN_ID=UM_DOMAIN.UM_DOMAIN_ID AND UM_PERMISSION.UM_TENANT_ID=? AND UM_ROLE_PERMISSION.UM_TENANT_ID=? AND UM_RESOURCE_ID=?");
            statement.setInt(1, this.tenantId);
            statement.setInt(2, this.tenantId);
            statement.setString(3, resourceId);
            rs = statement.executeQuery();
            this.write.lock();
            try {
                while (rs.next()) {
                    short allow = rs.getShort(3);
                    String roleName = rs.getString(1);
                    String domain = rs.getString(5);
                    String roleWithDomain = UserCoreUtil.addDomainToName(roleName, domain);
                    if (allow == 1) {
                        tree.authorizeRoleInTree(roleWithDomain, rs.getString(2), rs.getString(4), false);
                        continue;
                    }
                    tree.denyRoleInTree(roleWithDomain, rs.getString(2), rs.getString(4), false);
                }
            }
            finally {
                this.root = tree.root;
                this.write.unlock();
            }
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException("Error loading authorizations. Please check the database. Error message is " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, statement);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, statement);
    }

    private void invalidateCache(TreeNode root) throws UserStoreException {
        Cache<PermissionTreeCacheKey, GhostResource<TreeNode>> permissionCache = this.getPermissionTreeCache();
        if (permissionCache != null) {
            PermissionTreeCacheKey cacheKey = new PermissionTreeCacheKey(this.cacheIdentifier, this.tenantId);
            permissionCache.remove((Object)cacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePermissionTreeFromDB() throws UserStoreException {
        PermissionTree tree = new PermissionTree();
        ResultSet rs = null;
        PreparedStatement prepStmt1 = null;
        PreparedStatement prepStmt2 = null;
        Connection dbConnection = null;
        try {
            short allow;
            dbConnection = this.getDBConnection();
            prepStmt1 = this.preserveCaseForResources ? dbConnection.prepareStatement("SELECT UM_ROLE_NAME, UM_RESOURCE_ID, UM_IS_ALLOWED, UM_ACTION, UM_DOMAIN_NAME FROM UM_PERMISSION, UM_ROLE_PERMISSION, UM_DOMAIN WHERE UM_ROLE_PERMISSION.UM_PERMISSION_ID=UM_PERMISSION.UM_ID AND UM_ROLE_PERMISSION.UM_DOMAIN_ID=UM_DOMAIN.UM_DOMAIN_ID AND UM_PERMISSION.UM_TENANT_ID=? AND UM_ROLE_PERMISSION.UM_TENANT_ID=?") : dbConnection.prepareStatement("SELECT UM_ROLE_NAME, LOWER(UM_RESOURCE_ID), UM_IS_ALLOWED, UM_ACTION, UM_DOMAIN_NAME FROM UM_PERMISSION, UM_ROLE_PERMISSION, UM_DOMAIN WHERE UM_ROLE_PERMISSION.UM_PERMISSION_ID=UM_PERMISSION.UM_ID AND UM_ROLE_PERMISSION.UM_DOMAIN_ID=UM_DOMAIN.UM_DOMAIN_ID AND UM_PERMISSION.UM_TENANT_ID=? AND UM_ROLE_PERMISSION.UM_TENANT_ID=?");
            prepStmt1.setInt(1, this.tenantId);
            prepStmt1.setInt(2, this.tenantId);
            rs = prepStmt1.executeQuery();
            while (rs.next()) {
                allow = rs.getShort(3);
                String roleName = rs.getString(1);
                String domain = rs.getString(5);
                String roleWithDomain = UserCoreUtil.addDomainToName(roleName, domain);
                if (allow == 1) {
                    tree.authorizeRoleInTree(roleWithDomain, rs.getString(2), rs.getString(4), false);
                    continue;
                }
                tree.denyRoleInTree(roleWithDomain, rs.getString(2), rs.getString(4), false);
            }
            prepStmt2 = dbConnection.prepareStatement("SELECT UM_USER_NAME, UM_RESOURCE_ID, UM_IS_ALLOWED, UM_ACTION FROM UM_PERMISSION, UM_USER_PERMISSION WHERE UM_USER_PERMISSION.UM_PERMISSION_ID=UM_PERMISSION.UM_ID AND UM_PERMISSION.UM_TENANT_ID=? AND UM_USER_PERMISSION.UM_TENANT_ID=?");
            prepStmt2.setInt(1, this.tenantId);
            prepStmt2.setInt(2, this.tenantId);
            rs = prepStmt2.executeQuery();
            while (rs.next()) {
                allow = rs.getShort(3);
                if (allow == 1) {
                    tree.authorizeUserInTree(rs.getString(1), rs.getString(2), rs.getString(4), false);
                    continue;
                }
                tree.denyUserInTree(rs.getString(1), rs.getString(2), rs.getString(4), false);
            }
            this.write.lock();
            try {
                this.root = tree.root;
            }
            finally {
                this.write.unlock();
            }
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException("Error loading authorizations. Please check the database. Error message is " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt1, prepStmt2);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt1, prepStmt2);
    }

    private SearchResult getNode(TreeNode node, List<String> pathParts) {
        TreeNode child;
        if (pathParts == null || pathParts.isEmpty()) {
            return new SearchResult(node, null);
        }
        String key = pathParts.get(0);
        if (key != null && key.length() > 0 && (child = node.getChild(key)) != null) {
            pathParts.remove(0);
            if (!pathParts.isEmpty()) {
                return this.getNode(child, pathParts);
            }
            return new SearchResult(child, null);
        }
        return new SearchResult(node, pathParts);
    }

    private Connection getDBConnection() throws SQLException {
        Connection dbConnection = this.dataSource.getConnection();
        dbConnection.setAutoCommit(false);
        return dbConnection;
    }

    private boolean isCaseSensitiveUsername(String username, int tenantId) {
        block4: {
            if (UserStoreMgtDSComponent.getRealmService() != null) {
                try {
                    if (UserStoreMgtDSComponent.getRealmService().getTenantUserRealm(tenantId) != null) {
                        UserStoreManager userStoreManager = (UserStoreManager)UserStoreMgtDSComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
                        UserStoreManager userAvailableUserStoreManager = userStoreManager.getSecondaryUserStoreManager(UserCoreUtil.extractDomainFromName(username));
                        String isUsernameCaseInsensitiveString = userAvailableUserStoreManager.getRealmConfiguration().getUserStoreProperty(CASE_INSENSITIVE_USERNAME);
                        return !Boolean.parseBoolean(isUsernameCaseInsensitiveString);
                    }
                }
                catch (org.wso2.carbon.user.api.UserStoreException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"Error while reading user store property CaseInsensitiveUsername. Considering as false.");
                }
            }
        }
        return true;
    }

    private String modify(String name) {
        if (!name.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
            return name;
        }
        String domain = UserCoreUtil.extractDomainFromName(name);
        String nameWithoutDomain = UserCoreUtil.removeDomainFromName(name);
        String modifiedName = UserCoreUtil.addDomainToName(nameWithoutDomain, domain);
        return modifiedName;
    }
}

