/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.authorization;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.CacheStatistics;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.authorization.AuthorizationCacheException;
import org.wso2.carbon.user.core.authorization.AuthorizationKey;
import org.wso2.carbon.user.core.authorization.AuthorizeCacheEntry;
import org.wso2.carbon.user.core.internal.UserStoreMgtDSComponent;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class AuthorizationCache {
    public static final String AUTHORIZATION_CACHE_MANAGER = "AUTHORIZATION_CACHE_MANAGER";
    public static final String AUTHORIZATION_CACHE_NAME = "AUTHORIZATION_CACHE";
    private static final String CASE_INSENSITIVE_USERNAME = "CaseInsensitiveUsername";
    private static Log log = LogFactory.getLog(AuthorizationCache.class);
    private static Boolean isEnable = true;
    private static AuthorizationCache authorizationCache = new AuthorizationCache();

    private AuthorizationCache() {
    }

    public static AuthorizationCache getInstance() {
        return authorizationCache;
    }

    private Cache<AuthorizationKey, AuthorizeCacheEntry> getAuthorizationCache() {
        Cache cache = null;
        if (isEnable.booleanValue()) {
            CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(AUTHORIZATION_CACHE_MANAGER);
            cache = cacheManager.getCache(AUTHORIZATION_CACHE_NAME);
        }
        return cache;
    }

    private boolean isCacheNull(Cache<AuthorizationKey, AuthorizeCacheEntry> cache) {
        if (cache == null) {
            if (log.isDebugEnabled()) {
                StackTraceElement[] elemets = Thread.currentThread().getStackTrace();
                String traceString = "";
                for (int i = 1; i < elemets.length; ++i) {
                    traceString = traceString + elemets[i] + System.getProperty("line.separator");
                }
                log.debug((Object)("AUTHORIZATION_CACHE doesn't exist in CacheManager:\n" + traceString));
            }
            return true;
        }
        return false;
    }

    public void addToCache(String serverId, int tenantId, String userName, String resourceId, String action, boolean isAuthorized) {
        if (!this.isCaseSensitiveUsername(userName, tenantId)) {
            userName = userName.toLowerCase();
        }
        this.clearCacheEntry(serverId, tenantId, userName, resourceId, action);
        Cache<AuthorizationKey, AuthorizeCacheEntry> cache = this.getAuthorizationCache();
        if (this.isCacheNull(cache)) {
            return;
        }
        AuthorizationKey key = new AuthorizationKey(serverId, tenantId, userName, resourceId, action);
        AuthorizeCacheEntry cacheEntry = new AuthorizeCacheEntry(isAuthorized);
        cache.put((Object)key, (Object)cacheEntry);
    }

    public Boolean isUserAuthorized(String serverId, int tenantId, String userName, String resourceId, String action) throws AuthorizationCacheException {
        AuthorizationKey key;
        Cache<AuthorizationKey, AuthorizeCacheEntry> cache = this.getAuthorizationCache();
        if (this.isCacheNull(cache)) {
            throw new AuthorizationCacheException("Authorization information not found in the cache.");
        }
        if (!this.isCaseSensitiveUsername(userName, tenantId)) {
            userName = userName.toLowerCase();
        }
        if (!cache.containsKey((Object)(key = new AuthorizationKey(serverId, tenantId, userName, resourceId, action)))) {
            throw new AuthorizationCacheException("Authorization information not found in the cache.");
        }
        AuthorizeCacheEntry entry = (AuthorizeCacheEntry)cache.get((Object)key);
        if (entry != null) {
            return entry.isUserAuthorized();
        }
        return null;
    }

    public void clearCache() {
        Cache<AuthorizationKey, AuthorizeCacheEntry> cache = this.getAuthorizationCache();
        if (this.isCacheNull(cache)) {
            return;
        }
        cache.removeAll();
    }

    public void clearCacheEntry(String serverId, int tenantId, String userName, String resourceId, String action) {
        AuthorizationKey key;
        Cache<AuthorizationKey, AuthorizeCacheEntry> cache = this.getAuthorizationCache();
        if (this.isCacheNull(cache)) {
            return;
        }
        if (!this.isCaseSensitiveUsername(userName, tenantId)) {
            userName = userName.toLowerCase();
        }
        if (cache.containsKey((Object)(key = new AuthorizationKey(serverId, tenantId, userName, resourceId, action)))) {
            cache.remove((Object)key);
        }
    }

    public void clearCacheByUser(int tenantId, String userName) {
        Cache<AuthorizationKey, AuthorizeCacheEntry> cache = this.getAuthorizationCache();
        if (this.isCacheNull(cache)) {
            return;
        }
        if (!this.isCaseSensitiveUsername(userName, tenantId)) {
            userName = userName.toLowerCase();
        }
        for (Cache.Entry entry : cache) {
            AuthorizationKey authorizationKey = (AuthorizationKey)entry.getKey();
            if (authorizationKey.getTenantId() != tenantId || !authorizationKey.getUserName().equalsIgnoreCase(userName)) continue;
            cache.remove((Object)authorizationKey);
        }
    }

    public double hitRate() {
        Cache<AuthorizationKey, AuthorizeCacheEntry> cache = this.getAuthorizationCache();
        if (this.isCacheNull(cache)) {
            return 0.0;
        }
        CacheStatistics stats = cache.getStatistics();
        return (double)stats.getCacheHits() / (double)(stats.getCacheHits() + stats.getCacheMisses());
    }

    public void clearCacheByTenant(int tenantId) {
        Cache<AuthorizationKey, AuthorizeCacheEntry> cache = this.getAuthorizationCache();
        if (!this.isCacheNull(cache)) {
            cache.removeAll();
        }
    }

    public void clearCacheByServerId(String serverId) {
        Cache<AuthorizationKey, AuthorizeCacheEntry> cache = this.getAuthorizationCache();
        if (this.isCacheNull(cache) || serverId == null) {
            return;
        }
        for (Cache.Entry entry : cache) {
            AuthorizationKey authorizationKey = (AuthorizationKey)entry.getKey();
            if (!serverId.equals(authorizationKey.getServerId())) continue;
            cache.remove((Object)authorizationKey);
        }
    }

    public void clearCacheByResource(String serverId, int tenantID, String resourceID) {
        Cache<AuthorizationKey, AuthorizeCacheEntry> cache = this.getAuthorizationCache();
        if (this.isCacheNull(cache)) {
            return;
        }
        for (Cache.Entry entry : cache) {
            AuthorizationKey authorizationKey = (AuthorizationKey)entry.getKey();
            if (tenantID != authorizationKey.getTenantId() || !resourceID.equals(authorizationKey.getResourceId()) || serverId != null && !serverId.equals(authorizationKey.getServerId())) continue;
            cache.remove((Object)authorizationKey);
        }
    }

    public void disableCache() {
        isEnable = false;
    }

    private boolean isCaseSensitiveUsername(String username, int tenantId) {
        block4: {
            if (UserStoreMgtDSComponent.getRealmService() != null) {
                try {
                    if (UserStoreMgtDSComponent.getRealmService().getTenantUserRealm(tenantId) != null) {
                        UserStoreManager userStoreManager = (UserStoreManager)UserStoreMgtDSComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
                        UserStoreManager userAvailableUserStoreManager = userStoreManager.getSecondaryUserStoreManager(UserCoreUtil.extractDomainFromName(username));
                        String isUsernameCaseInsensitiveString = userAvailableUserStoreManager.getRealmConfiguration().getUserStoreProperty(CASE_INSENSITIVE_USERNAME);
                        return !Boolean.parseBoolean(isUsernameCaseInsensitiveString);
                    }
                }
                catch (UserStoreException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"Error while reading user store property CaseInsensitiveUsername. Considering as false.");
                }
            }
        }
        return true;
    }
}

