/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.siddhi.metrics.core;

import java.util.List;
import org.wso2.carbon.siddhi.metrics.core.SiddhiLatencyMetric;
import org.wso2.carbon.siddhi.metrics.core.SiddhiMemoryUsageMetric;
import org.wso2.carbon.siddhi.metrics.core.SiddhiStatisticsManager;
import org.wso2.carbon.siddhi.metrics.core.SiddhiThroughputMetric;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.util.statistics.MemoryUsageTracker;
import org.wso2.siddhi.core.util.statistics.StatisticsManager;
import org.wso2.siddhi.core.util.statistics.StatisticsTrackerFactory;
import org.wso2.siddhi.core.util.statistics.ThroughputTracker;
import org.wso2.siddhi.query.api.annotation.Element;

public class SiddhiMetricsFactory
implements StatisticsTrackerFactory {
    private boolean statisticsEnabled = false;

    public SiddhiMetricsFactory(boolean isStatisticsEnabled) {
        this.statisticsEnabled = isStatisticsEnabled;
    }

    public LatencyTracker createLatencyTracker(String name, StatisticsManager statisticsManager) {
        return new SiddhiLatencyMetric(name, this.statisticsEnabled);
    }

    public ThroughputTracker createThroughputTracker(String name, StatisticsManager statisticsManager) {
        return new SiddhiThroughputMetric(name, this.statisticsEnabled);
    }

    public MemoryUsageTracker createMemoryUsageTracker(StatisticsManager statisticsManager) {
        return new SiddhiMemoryUsageMetric(this.statisticsEnabled);
    }

    public StatisticsManager createStatisticsManager(List<Element> elements) {
        return new SiddhiStatisticsManager(elements);
    }
}

