/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.siddhi.metrics.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.wso2.carbon.metrics.manager.Gauge;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.siddhi.core.util.statistics.MemoryUsageTracker;
import org.wso2.siddhi.core.util.statistics.memory.ObjectSizeCalculator;

public class SiddhiMemoryUsageMetric
implements MemoryUsageTracker {
    private ConcurrentMap<Object, ObjectMetric> registeredObjects = new ConcurrentHashMap<Object, ObjectMetric>();
    private boolean enabled;

    public SiddhiMemoryUsageMetric(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    public void registerObject(Object object, String name) {
        if (this.enabled && this.registeredObjects.get(object) == null) {
            String metricId = MetricManager.name((String)name, (String[])new String[]{"memory"});
            this.registeredObjects.put(object, new ObjectMetric(object, metricId));
        }
    }

    public String getName(Object object) {
        if (this.enabled) {
            if (this.registeredObjects.get(object) != null) {
                return ((ObjectMetric)this.registeredObjects.get(object)).getName();
            }
            return null;
        }
        return null;
    }

    class ObjectMetric {
        private final Object object;
        private String name;

        public ObjectMetric(Object object, String name) {
            this.object = object;
            this.name = name;
            this.initMetric();
        }

        public String getName() {
            return this.name;
        }

        private void initMetric() {
            MetricManager.gauge((String)this.name, (Level)Level.DEBUG, (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    try {
                        return ObjectSizeCalculator.getObjectSize((Object)ObjectMetric.this.object);
                    }
                    catch (UnsupportedOperationException e) {
                        return 0L;
                    }
                }
            });
        }
    }
}

