/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.siddhi.metrics.core;

import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.carbon.metrics.manager.Timer;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;

public class SiddhiLatencyMetric
implements LatencyTracker {
    private ThreadLocal<Timer> execLatencyTimer;
    private ThreadLocal<Timer.Context> context;
    private String metricName;
    private boolean enabled;

    public SiddhiLatencyMetric(String name, boolean isEnabled) {
        this.enabled = isEnabled;
        if (this.enabled) {
            this.metricName = MetricManager.name((String)name, (String[])new String[]{"latency"});
            this.execLatencyTimer = new ThreadLocal<Timer>(){

                @Override
                protected Timer initialValue() {
                    return MetricManager.timer((String)SiddhiLatencyMetric.this.metricName, (Level)Level.INFO);
                }
            };
            this.context = new ThreadLocal<Timer.Context>(){

                @Override
                protected Timer.Context initialValue() {
                    return null;
                }
            };
        }
    }

    public void markIn() {
        if (this.enabled) {
            if (this.context.get() != null) {
                throw new IllegalStateException("MarkIn consecutively called without calling markOut in " + this.metricName);
            }
            this.context.set(this.execLatencyTimer.get().start());
        }
    }

    public void markOut() {
        if (this.enabled && this.context.get() != null) {
            this.context.get().stop();
            this.context.set(null);
        }
    }

    public String getName() {
        if (this.enabled) {
            return this.metricName;
        }
        return null;
    }
}

