/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.throttling.siddhi.extension.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.utils.CarbonUtils;

@Component(name="org.wso2.carbon.apimgt.throttling.siddhi.extension.component", immediate=true)
public class APIMSiddhiExtensionsComponent {
    private static Log log = LogFactory.getLog(APIMSiddhiExtensionsComponent.class);
    private static final String PORT_OFFSET_SYSTEM_VAR = "portOffset";
    private static final String PORT_OFFSET_CONFIG = "Ports.Offset";
    private static final String JMS_PORT = "jms.port";

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (System.getProperty(JMS_PORT) == null) {
            int jmsPort = 5672 + APIMSiddhiExtensionsComponent.getPortOffset();
            System.setProperty(JMS_PORT, String.valueOf(jmsPort));
        }
    }

    private static int getPortOffset() {
        ServerConfiguration carbonConfig = CarbonUtils.getServerConfiguration();
        String portOffset = System.getProperty(PORT_OFFSET_SYSTEM_VAR, carbonConfig.getFirstProperty(PORT_OFFSET_CONFIG));
        try {
            if (portOffset != null) {
                return Integer.parseInt(portOffset.trim());
            }
            return 0;
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid Port Offset: " + portOffset + ". Default value 0 will be used."), (Throwable)e);
            return 0;
        }
    }
}

