/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.throttling.siddhi.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

public class ThrottleStreamProcessor
extends StreamProcessor
implements SchedulingProcessor,
FindableProcessor {
    private long timeInMilliSeconds;
    private ComplexEventChunk<StreamEvent> expiredEventChunk = new ComplexEventChunk(true);
    private Scheduler scheduler;
    private ExecutionPlanContext executionPlanContext;
    private long expireEventTime = -1L;
    private long startTime = -1L;

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.executionPlanContext = executionPlanContext;
        if (attributeExpressionExecutors.length == 1) {
            if (!(attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new ExecutionPlanValidationException("Throttle batch window 1st parameter needs to be constant parameter attribute but found a dynamic attribute " + attributeExpressionExecutors[0].getClass().getCanonicalName());
            if (attributeExpressionExecutors[0].getReturnType() == Attribute.Type.INT) {
                this.timeInMilliSeconds = ((Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()).intValue();
            } else {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("Throttle batch window's 1st parameter attribute should be either int or long, but found " + attributeExpressionExecutors[0].getReturnType());
                this.timeInMilliSeconds = (Long)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            }
        } else {
            if (attributeExpressionExecutors.length != 2) throw new ExecutionPlanValidationException("Throttle batch window should only have one/two parameter (<int|long|time> windowTime (and <int|long> startTime), but found " + attributeExpressionExecutors.length + " input attributes");
            if (!(attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new ExecutionPlanValidationException("Throttle batch window 1st parameter needs to be constant attribute but found a dynamic attribute " + attributeExpressionExecutors[0].getClass().getCanonicalName());
            if (attributeExpressionExecutors[0].getReturnType() == Attribute.Type.INT) {
                this.timeInMilliSeconds = ((Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()).intValue();
            } else {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("Throttle batch window's 1st parameter attribute should be either int or long, but found " + attributeExpressionExecutors[0].getReturnType());
                this.timeInMilliSeconds = (Long)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            }
            if (attributeExpressionExecutors[1].getReturnType() == Attribute.Type.INT) {
                this.startTime = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()));
            } else {
                if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("Throttle batch window 2nd parameter needs to be a Long or Int type but found a " + attributeExpressionExecutors[2].getReturnType());
                this.startTime = Long.parseLong(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()));
            }
        }
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        attributeList.add(new Attribute("expiryTimeStamp", Attribute.Type.LONG));
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        ThrottleStreamProcessor throttleStreamProcessor = this;
        synchronized (throttleStreamProcessor) {
            boolean sendEvents;
            long currentTime;
            if (this.expireEventTime == -1L) {
                currentTime = this.executionPlanContext.getTimestampGenerator().currentTime();
                this.expireEventTime = this.startTime != -1L ? this.addTimeShift(currentTime) : this.executionPlanContext.getTimestampGenerator().currentTime() + this.timeInMilliSeconds;
                this.scheduler.notifyAt(this.expireEventTime);
            }
            if ((currentTime = this.executionPlanContext.getTimestampGenerator().currentTime()) >= this.expireEventTime) {
                this.expireEventTime += this.timeInMilliSeconds;
                this.scheduler.notifyAt(this.expireEventTime);
                sendEvents = true;
            } else {
                sendEvents = false;
            }
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                if (streamEvent.getType() != ComplexEvent.Type.CURRENT) continue;
                complexEventPopulater.populateComplexEvent((ComplexEvent)streamEvent, new Object[]{this.expireEventTime});
                StreamEvent clonedStreamEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedStreamEvent.setType(ComplexEvent.Type.EXPIRED);
                clonedStreamEvent.setTimestamp(this.expireEventTime);
                this.expiredEventChunk.add((ComplexEvent)clonedStreamEvent);
            }
            if (sendEvents) {
                this.expiredEventChunk.reset();
                if (this.expiredEventChunk.getFirst() != null) {
                    streamEventChunk.add(this.expiredEventChunk.getFirst());
                }
                this.expiredEventChunk.clear();
            }
        }
        if (streamEventChunk.getFirst() != null) {
            streamEventChunk.setBatch(true);
            nextProcessor.process(streamEventChunk);
            streamEventChunk.setBatch(false);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[]{this.expiredEventChunk.getFirst()};
    }

    public void restoreState(Object[] state) {
        this.expiredEventChunk.clear();
        this.expiredEventChunk.add((ComplexEvent)((StreamEvent)state[0]));
    }

    public synchronized StreamEvent find(StateEvent matchingEvent, Finder finder) {
        return finder.find(matchingEvent, this.expiredEventChunk, this.streamEventCloner);
    }

    public Finder constructFinder(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        return OperatorParser.constructOperator(this.expiredEventChunk, (Expression)expression, (MatchingMetaStateHolder)matchingMetaStateHolder, (ExecutionPlanContext)executionPlanContext, variableExpressionExecutors, eventTableMap, (String)this.queryName);
    }

    private long addTimeShift(long currentTime) {
        long timePassedUntilNow = (currentTime - this.startTime) % this.timeInMilliSeconds;
        return currentTime + (this.timeInMilliSeconds - timePassedUntilNow);
    }
}

