/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.throttling.siddhi.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class EmitOnStateChange
extends StreamProcessor {
    private VariableExpressionExecutor keyExpressionExecutor;
    private VariableExpressionExecutor isThrottledExpressionExecutor;
    private Map<String, Boolean> throttleStateMap = new HashMap<String, Boolean>();

    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        while (streamEventChunk.hasNext()) {
            StreamEvent event = (StreamEvent)streamEventChunk.next();
            Boolean currentThrottleState = (Boolean)this.isThrottledExpressionExecutor.execute((ComplexEvent)event);
            String key = (String)this.keyExpressionExecutor.execute((ComplexEvent)event);
            Boolean lastThrottleState = this.throttleStateMap.get(key);
            if (lastThrottleState == currentThrottleState && !currentThrottleState.booleanValue()) {
                streamEventChunk.remove();
                continue;
            }
            this.throttleStateMap.put(key, currentThrottleState);
        }
        nextProcessor.process(streamEventChunk);
    }

    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to throttler:emitOnStateChange(key,isThrottled), required 2, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the argument of throttler:emitOnStateChange(key,isThrottled), required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[0].getReturnType());
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.BOOL) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the argument of throttler:emitOnStateChange(key,isThrottled), required " + Attribute.Type.BOOL + ", but found " + attributeExpressionExecutors[1].getReturnType());
        }
        this.keyExpressionExecutor = (VariableExpressionExecutor)attributeExpressionExecutors[0];
        this.isThrottledExpressionExecutor = (VariableExpressionExecutor)attributeExpressionExecutors[1];
        return new ArrayList<Attribute>();
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[]{this.throttleStateMap};
    }

    public void restoreState(Object[] state) {
        this.throttleStateMap = (HashMap)state[0];
    }
}

