/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.rename.core.internal.service.impl;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.user.rename.core.constants.UsernameUpdateServiceConstants;
import org.wso2.carbon.identity.user.rename.core.dto.StatusDTO;
import org.wso2.carbon.identity.user.rename.core.dto.UserDTO;
import org.wso2.carbon.identity.user.rename.core.exception.UsernameUpdateClientException;
import org.wso2.carbon.identity.user.rename.core.exception.UsernameUpdateException;
import org.wso2.carbon.identity.user.rename.core.exception.UsernameUpdateServerException;
import org.wso2.carbon.identity.user.rename.core.internal.service.impl.ForgetMeToolExecutor;
import org.wso2.carbon.identity.user.rename.core.service.UsernameUpdateService;
import org.wso2.carbon.identity.user.rename.core.utils.UpdateUsernameServiceUtil;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

@Component(name="org.wso2.carbon.identity.user.rename.service", immediate=true, service={UsernameUpdateService.class})
public class UsernameUpdateServiceImpl
implements UsernameUpdateService {
    private static final Log log = LogFactory.getLog(UsernameUpdateServiceImpl.class);
    protected RealmService realmService;

    @Override
    public StatusDTO updateUsername(UserDTO userDTO) throws UsernameUpdateException {
        this.validate(userDTO);
        String tenantDomain = userDTO.getTenantDomain();
        String domainQualifiedUsername = UserCoreUtil.addDomainToName((String)userDTO.getExistingUsername(), (String)userDTO.getUserStoreDomain());
        UserStoreManager userStoreManager = this.getUserStoreManager(tenantDomain);
        if (!this.isExistingUser(domainQualifiedUsername, tenantDomain, userStoreManager)) {
            throw new UsernameUpdateClientException(String.format(UsernameUpdateServiceConstants.Error.ERROR_USER_NOT_FOUND.getMessage(), tenantDomain, domainQualifiedUsername), UsernameUpdateServiceConstants.Error.ERROR_USER_NOT_FOUND.getCode(), UsernameUpdateClientException.ErrorType.NOT_FOUND);
        }
        this.performUpdate(userDTO, userStoreManager);
        return UpdateUsernameServiceUtil.buildStatus(UsernameUpdateServiceConstants.Status.STATUS_SUCCESS.getCode(), String.format(UsernameUpdateServiceConstants.Status.STATUS_SUCCESS.getMessage(), userDTO.getExistingUsername(), userDTO.getNewUsername()));
    }

    private void performUpdate(UserDTO userDTO, UserStoreManager userStoreManager) throws UsernameUpdateException {
        this.disableAccount(UserCoreUtil.addDomainToName((String)userDTO.getExistingUsername(), (String)userDTO.getUserStoreDomain()), userDTO.getTenantDomain(), userStoreManager);
        ForgetMeToolExecutor.run(userDTO.getExistingUsername(), userDTO.getNewUsername(), userDTO.getUserStoreDomain(), userDTO.getTenantDomain(), this.getTenantId(userDTO.getTenantDomain()));
        this.enableAccount(UserCoreUtil.addDomainToName((String)userDTO.getNewUsername(), (String)userDTO.getUserStoreDomain()), userDTO.getTenantDomain(), userStoreManager);
    }

    private void validate(UserDTO userDTO) throws UsernameUpdateClientException {
        if (StringUtils.isBlank((String)userDTO.getExistingUsername()) || StringUtils.isBlank((String)userDTO.getNewUsername())) {
            throw new UsernameUpdateClientException(UsernameUpdateServiceConstants.Error.ERROR_INVALID_USERNAME.getMessage(), UsernameUpdateServiceConstants.Error.ERROR_INVALID_USERNAME.getCode(), UsernameUpdateClientException.ErrorType.BAD_REQUEST);
        }
        if (userDTO.getExistingUsername().equals(userDTO.getNewUsername())) {
            throw new UsernameUpdateClientException(UsernameUpdateServiceConstants.Error.ERROR_INVALID_NEW_USERNAME.getMessage(), UsernameUpdateServiceConstants.Error.ERROR_INVALID_NEW_USERNAME.getCode(), UsernameUpdateClientException.ErrorType.BAD_REQUEST);
        }
    }

    private boolean isExistingUser(String domainQualifiedUsername, String tenantDomain, UserStoreManager userStoreManager) throws UsernameUpdateServerException {
        try {
            return userStoreManager.isExistingUser(domainQualifiedUsername);
        }
        catch (UserStoreException e) {
            throw new UsernameUpdateServerException("Error while validating if user: " + domainQualifiedUsername + " exists in tenant: " + tenantDomain, e);
        }
    }

    private UserStoreManager getUserStoreManager(String tenantDomain) throws UsernameUpdateException {
        try {
            UserRealm userRealm = this.realmService.getTenantUserRealm(this.getTenantId(tenantDomain));
            if (userRealm != null) {
                return userRealm.getUserStoreManager();
            }
            throw new UsernameUpdateServerException("Failed to retrieve user realm for tenant: " + tenantDomain);
        }
        catch (UserStoreException e) {
            throw new UsernameUpdateServerException("Failed to retrieve user store manager for tenant: " + tenantDomain, e);
        }
    }

    private int getTenantId(String tenantDomain) throws UsernameUpdateServerException {
        try {
            return this.realmService.getTenantManager().getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            throw new UsernameUpdateServerException("Failed to retrieve tenant id for tenant domain: " + tenantDomain);
        }
    }

    private void disableAccount(String domainQualifiedUsername, String tenantDomain, UserStoreManager userStoreManager) throws UsernameUpdateServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disable account of user: " + domainQualifiedUsername + " in tenant: " + tenantDomain));
        }
        this.updateAccountDisableClaim(Boolean.TRUE.toString(), domainQualifiedUsername, tenantDomain, userStoreManager);
    }

    private void enableAccount(String domainQualifiedUsername, String tenantDomain, UserStoreManager userStoreManager) throws UsernameUpdateServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enable account of user: " + domainQualifiedUsername + " in tenant: " + tenantDomain));
        }
        this.updateAccountDisableClaim(Boolean.FALSE.toString(), domainQualifiedUsername, tenantDomain, userStoreManager);
    }

    private void updateAccountDisableClaim(String value, String domainQualifiedUsername, String tenantDomain, UserStoreManager userStoreManager) throws UsernameUpdateServerException {
        try {
            HashMap<String, String> claimValues = new HashMap<String, String>();
            claimValues.put("http://wso2.org/claims/identity/accountDisabled", value);
            userStoreManager.setUserClaimValues(domainQualifiedUsername, claimValues, "default");
        }
        catch (UserStoreException e) {
            throw new UsernameUpdateServerException("Error while updating account lock claim of user: " + domainQualifiedUsername + " in tenant: " + tenantDomain, e);
        }
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    public void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service in username rename component");
        }
        this.realmService = realmService;
    }

    public void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Realm Service in username rename component");
        }
        this.realmService = null;
    }
}

