/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.rename.core.internal.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.user.rename.core.exception.UsernameUpdateException;

public class ForgetMeToolExecutor {
    private static final Log log = LogFactory.getLog(ForgetMeToolExecutor.class);
    private static final String SYSTEM_PROPERTY_CARBON_HOME = "carbon.home";
    private static final String FORGETME_TOOL_HOME = "repository/components/tools/forget-me";
    private static final String SCRIPT_NAME_BASH = "forgetme.sh";
    private static final String SCRIPT_NAME_WINDOWS = "forgetme.bat";
    private static final String SYSTEM_PROPERTY_OS_NAME = "os.name";
    private static final String USER_STORE_EXTENSION_CONF_RELATIVE_PATH = "extensions/user-store/conf";

    public static void run(String existingUsername, String newUsername, String userStoreDomain, String tenantDomain, int tenantId) throws UsernameUpdateException {
        int status = new ForgetMeToolExecutor().execute(existingUsername, newUsername, userStoreDomain, tenantDomain, tenantId);
        if (status != 0) {
            throw new UsernameUpdateException("Error while updating the username from : " + existingUsername + " to: " + newUsername + " of user in userstore domain: " + userStoreDomain + " and tenant domain: " + tenantDomain + ". Refer logs at " + Paths.get(System.getProperty(SYSTEM_PROPERTY_CARBON_HOME), new String[0]).resolve(Paths.get(FORGETME_TOOL_HOME, new String[0])).resolve(Paths.get(USER_STORE_EXTENSION_CONF_RELATIVE_PATH, new String[0])).toString() + " for more information");
        }
    }

    private int execute(String existingUsername, String newUsername, String userStoreDomain, String tenantDomain, int tenantId) throws UsernameUpdateException {
        String scriptName = this.getScriptForOS();
        if (scriptName == null) {
            throw new UsernameUpdateException(String.format("The operating system '%s' doesn't support the forget-me tool script.", System.getProperty(SYSTEM_PROPERTY_OS_NAME)));
        }
        String scriptPath = Paths.get(System.getProperty(SYSTEM_PROPERTY_CARBON_HOME), new String[0]).resolve(Paths.get(FORGETME_TOOL_HOME, "bin", scriptName)).toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolved forget-me tool script path to: " + scriptPath));
        }
        String arguments = this.buildForgetMeToolArguments(existingUsername, newUsername, userStoreDomain, tenantDomain, tenantId);
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(scriptPath + " " + arguments);
            if (log.isInfoEnabled()) {
                log.info((Object)IOUtils.toString((InputStream)process.getInputStream()));
            }
            process.waitFor();
            return process.exitValue();
        }
        catch (IOException | InterruptedException e) {
            throw new UsernameUpdateException("Error while executing username update process for user: " + existingUsername + " in tenant: " + tenantDomain, e);
        }
    }

    private String getScriptForOS() {
        String osName = System.getProperty(SYSTEM_PROPERTY_OS_NAME);
        String scriptName = null;
        if (this.isUnixOS(osName) || this.isMacOS(osName)) {
            scriptName = SCRIPT_NAME_BASH;
        } else if (this.isWindowsOS(osName)) {
            scriptName = SCRIPT_NAME_WINDOWS;
        }
        return scriptName;
    }

    private boolean isWindowsOS(String osName) {
        return osName.toUpperCase().indexOf("WIN") >= 0;
    }

    private boolean isUnixOS(String osName) {
        return osName.toUpperCase().indexOf("NIX") >= 0 || osName.toUpperCase().indexOf("NUX") >= 0 || osName.toUpperCase().indexOf("AIX") > 0;
    }

    private boolean isMacOS(String osName) {
        return osName.toUpperCase().indexOf("MAC") >= 0;
    }

    private String buildForgetMeToolArguments(String existingUsername, String newUsername, String userStoreDomain, String tenantDomain, int tenantId) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-d");
        String configDirectoryPath = Paths.get(System.getProperty(SYSTEM_PROPERTY_CARBON_HOME), new String[0]).resolve(Paths.get(FORGETME_TOOL_HOME, USER_STORE_EXTENSION_CONF_RELATIVE_PATH)).toString();
        args.add(configDirectoryPath);
        args.add("-U");
        args.add(existingUsername);
        args.add("-pu");
        args.add(newUsername);
        args.add("-TID");
        args.add(String.valueOf(tenantId));
        args.add("-T");
        args.add(tenantDomain);
        args.add("-D");
        args.add(userStoreDomain);
        return String.join((CharSequence)" ", args);
    }
}

