/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.wsdl.xsd;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsi.internal.core.wsdl.xsd.InlineXSDResolver;
import org.eclipse.wst.wsi.internal.core.wsdl.xsd.ValidateErrorHandler;

public class XSDValidator {
    private XSModel xsModel = null;
    private boolean isValidXSD = false;
    private List errors = new ArrayList();
    private String filelocation;

    public void validateInlineSchema(String schema, String targetNamespace, String fileloc) {
        this.validateInlineSchema(schema, targetNamespace, fileloc, null, null);
    }

    public void validateInlineSchema(String schema, String targetNamespace, String fileloc, XMLEntityResolver entityResolverChain, XMLEntityResolver inlineSchemaEntityResolver) {
        this.filelocation = fileloc;
        this.validateXSD(schema, true, entityResolverChain, targetNamespace, inlineSchemaEntityResolver);
    }

    public void validate(String uri, XMLEntityResolver entityResolver) {
        this.validateXSD(uri, false, entityResolver, null, null);
    }

    protected void validateXSD(String schema, boolean inlineXSD, XMLEntityResolver entityResolver, String targetNamespace, XMLEntityResolver inlineSchemaEntityResolver) {
        ValidateErrorHandler errorHandler = new ValidateErrorHandler();
        errorHandler.getErrorMessages().clear();
        try {
            XMLGrammarPreparser grammarPreparser = new XMLGrammarPreparser();
            XMLGrammarPoolImpl grammarPool = new XMLGrammarPoolImpl();
            grammarPreparser.setGrammarPool((XMLGrammarPool)grammarPool);
            grammarPreparser.setErrorHandler((XMLErrorHandler)errorHandler);
            if (entityResolver != null) {
                grammarPreparser.setEntityResolver(entityResolver);
            }
            try {
                XMLInputSource is = null;
                if (inlineXSD) {
                    StringReader reader = new StringReader(schema);
                    is = new XMLInputSource(null, this.filelocation, this.filelocation, (Reader)reader, null);
                    ((InlineXSDResolver)inlineSchemaEntityResolver).addReferringSchema(is, targetNamespace);
                } else {
                    is = new XMLInputSource(null, schema, schema);
                }
                grammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
                grammarPreparser.getLoader("http://www.w3.org/2001/XMLSchema");
                XSGrammar grammar = (XSGrammar)grammarPreparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", is);
                this.xsModel = grammar.toXSModel();
            }
            catch (Exception e) {
                this.errors.add("Schema is structurally invalid.");
            }
            this.errors.addAll(errorHandler.getErrorMessages());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (this.errors.isEmpty()) {
            this.isValidXSD = true;
        }
    }

    public XSModel getXSModel() {
        return this.xsModel;
    }

    public boolean isValid() {
        return this.isValidXSD;
    }

    public List getErrors() {
        return this.errors;
    }
}

