/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.wsdl;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.extensions.schema.SchemaConstants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import com.ibm.wsdl.util.xml.XPathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.ElementImpl;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLElementList;
import org.eclipse.wst.wsi.internal.core.xml.dom.ElementLocation;
import org.eclipse.wst.wsi.internal.core.xml.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WSDLReaderImpl
extends com.ibm.wsdl.xml.WSDLReaderImpl {
    protected WSDLElementList wsdlElementList = new WSDLElementList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Definition parseDefinitions(String documentBaseURI, Element defEl, Map importedDefs) throws WSDLException {
        Definition def = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(WSDLReaderImpl.class.getClassLoader());
            def = super.parseDefinitions(documentBaseURI, defEl, importedDefs);
            this.addElementToList(defEl, def);
        }
        catch (Exception e) {
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
        return def;
    }

    protected Import parseImport(Element element, Definition definition, Map map) throws WSDLException {
        Import import1 = definition.createImport();
        String s = DOMUtils.getAttribute((Element)element, (String)"namespace");
        String s1 = DOMUtils.getAttribute((Element)element, (String)"location");
        if (s != null) {
            import1.setNamespaceURI(s);
        }
        if (s1 != null && s1.length() > 0) {
            import1.setLocationURI(s1);
            if (this.importDocuments) {
                try {
                    String s2 = definition.getDocumentBaseURI();
                    Definition definition1 = null;
                    InputStream inputstream = null;
                    InputSource inputsource = null;
                    URL url = null;
                    if (this.loc != null) {
                        inputsource = this.loc.getImportInputSource(s2, s1);
                        String s3 = this.loc.getLatestImportURI();
                        definition1 = (Definition)map.get(s3);
                    } else {
                        URL url1 = s2 == null ? null : StringUtils.getURL(null, (String)s2);
                        url = StringUtils.getURL((URL)url1, (String)s1);
                        definition1 = (Definition)map.get(url.toString());
                        if (definition1 == null) {
                            try {
                                inputstream = url.openStream();
                            }
                            catch (IOException ex) {
                                this.addElementToList(element, import1);
                                return import1;
                            }
                            if (inputstream != null) {
                                inputsource = new InputSource(inputstream);
                            }
                        }
                    }
                    if (definition1 == null) {
                        Element element2;
                        if (inputsource == null) {
                            throw new WSDLException("OTHER_ERROR", "Unable to locate imported document at '" + s1 + "'" + (s2 != null ? ", relative to '" + s2 + "'." : "."));
                        }
                        Document document = null;
                        try {
                            document = this.getDocument(inputsource, s1);
                        }
                        catch (WSDLException ex) {
                            this.addElementToList(element, import1);
                            return import1;
                        }
                        if (inputstream != null) {
                            inputstream.close();
                        }
                        if (QNameUtils.matches((QName)Constants.Q_ELEM_DEFINITIONS, (Node)(element2 = document.getDocumentElement()))) {
                            String s4 = this.loc == null ? (url == null ? s1 : url.toString()) : this.loc.getLatestImportURI();
                            definition1 = this.readWSDL(s4, element2, map);
                        } else {
                            QName qname = QNameUtils.newQName((Node)element2);
                            if (SchemaConstants.XSD_QNAME_LIST.contains(qname)) {
                                WSDLFactory wsdlfactory = this.factoryImplName == null ? WSDLFactory.newInstance() : WSDLFactory.newInstance((String)this.factoryImplName);
                                definition1 = wsdlfactory.newDefinition();
                                if (this.extReg != null) {
                                    definition1.setExtensionRegistry(this.extReg);
                                }
                                String s5 = this.loc == null ? (url == null ? s1 : url.toString()) : this.loc.getLatestImportURI();
                                definition1.setDocumentBaseURI(s5);
                            }
                        }
                    }
                    if (definition1 != null) {
                        import1.setDefinition(definition1);
                    }
                }
                catch (WSDLException wsdlexception) {
                    wsdlexception.setLocation(XPathUtils.getXPathExprFromNode((Node)element));
                    throw wsdlexception;
                }
                catch (Throwable throwable) {
                    throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + s1 + "'.", throwable);
                }
            }
        }
        Element element1 = DOMUtils.getFirstChildElement((Element)element);
        while (element1 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element1)) {
                import1.setDocumentationElement(element1);
            } else {
                DOMUtils.throwWSDLException((Element)element1);
            }
            element1 = DOMUtils.getNextSiblingElement((Element)element1);
        }
        return import1;
    }

    protected Types parseTypes(Element typesEl, Definition def) throws WSDLException {
        Types types = super.parseTypes(typesEl, def);
        this.addElementToList(typesEl, types);
        return types;
    }

    protected Binding parseBinding(Element bindingEl, Definition def) throws WSDLException {
        Binding binding = super.parseBinding(bindingEl, def);
        this.addElementToList(bindingEl, binding);
        return binding;
    }

    protected BindingOperation parseBindingOperation(Element bindingOperationEl, PortType portType, Definition def) throws WSDLException {
        BindingOperation bindingOperation = null;
        try {
            bindingOperation = super.parseBindingOperation(bindingOperationEl, portType, def);
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().startsWith("Duplicate")) {
                bindingOperation = this.parseBindingOperationWithDuplicateNames(bindingOperationEl, portType, def);
            }
            throw iae;
        }
        if (bindingOperation != null) {
            this.addElementToList(bindingOperationEl, bindingOperation);
        }
        return bindingOperation;
    }

    protected BindingInput parseBindingInput(Element bindingInputEl, Definition def) throws WSDLException {
        BindingInput bindingInput = super.parseBindingInput(bindingInputEl, def);
        this.addElementToList(bindingInputEl, bindingInput);
        return bindingInput;
    }

    protected BindingOutput parseBindingOutput(Element bindingOutputEl, Definition def) throws WSDLException {
        BindingOutput bindingOutput = super.parseBindingOutput(bindingOutputEl, def);
        this.addElementToList(bindingOutputEl, bindingOutput);
        return bindingOutput;
    }

    protected BindingFault parseBindingFault(Element bindingFaultEl, Definition def) throws WSDLException {
        BindingFault bindingFault = super.parseBindingFault(bindingFaultEl, def);
        this.addElementToList(bindingFaultEl, bindingFault);
        return bindingFault;
    }

    protected Message parseMessage(Element msgEl, Definition def) throws WSDLException {
        Message msg = super.parseMessage(msgEl, def);
        this.addElementToList(msgEl, msg);
        return msg;
    }

    protected Part parsePart(Element partEl, Definition def) throws WSDLException {
        QName elementName;
        Part part = def.createPart();
        String name = DOMUtils.getAttribute((Element)partEl, (String)"name");
        try {
            elementName = DOMUtils.getQualifiedAttributeValue((Element)partEl, (String)"element", (String)"message", (boolean)false, (Definition)def);
        }
        catch (WSDLException we) {
            String prefixedValue = DOMUtils.getAttribute((Element)partEl, (String)"element");
            int index = prefixedValue.indexOf(58);
            String localPart = prefixedValue.substring(index + 1);
            elementName = new QName(localPart);
        }
        QName typeName = DOMUtils.getQualifiedAttributeValue((Element)partEl, (String)"type", (String)"message", (boolean)false, (Definition)def);
        if (name != null) {
            part.setName(name);
        }
        if (elementName != null) {
            part.setElementName(elementName);
        }
        if (typeName != null) {
            part.setTypeName(typeName);
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)partEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                part.setDocumentationElement(tempEl);
            } else {
                DOMUtils.throwWSDLException((Element)tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.parseExtensibilityAttributes(partEl, Part.class, (AttributeExtensible)part, def);
        this.addElementToList(partEl, part);
        return part;
    }

    protected PortType parsePortType(Element portTypeEl, Definition def) throws WSDLException {
        PortType portType = super.parsePortType(portTypeEl, def);
        this.addElementToList(portTypeEl, portType);
        return portType;
    }

    protected Operation parseOperation(Element opEl, PortType portType, Definition def) throws WSDLException {
        Operation op = super.parseOperation(opEl, portType, def);
        this.addElementToList(opEl, op);
        return op;
    }

    protected Service parseService(Element serviceEl, Definition def) throws WSDLException {
        Service service = super.parseService(serviceEl, def);
        this.addElementToList(serviceEl, service);
        return service;
    }

    protected Port parsePort(Element portEl, Definition def) throws WSDLException {
        Port port = super.parsePort(portEl, def);
        this.addElementToList(portEl, port);
        return port;
    }

    protected ExtensibilityElement parseExtensibilityElement(Class parentType, Element el, Definition def) throws WSDLException {
        ExtensibilityElement extElement = super.parseExtensibilityElement(parentType, el, def);
        this.addElementToList(el, extElement);
        return extElement;
    }

    protected Input parseInput(Element inputEl, Definition def) throws WSDLException {
        Input input = super.parseInput(inputEl, def);
        this.addElementToList(inputEl, input);
        return input;
    }

    protected Output parseOutput(Element outputEl, Definition def) throws WSDLException {
        Output output = super.parseOutput(outputEl, def);
        this.addElementToList(outputEl, output);
        return output;
    }

    protected Fault parseFault(Element faultEl, Definition def) throws WSDLException {
        Fault fault = super.parseFault(faultEl, def);
        this.addElementToList(faultEl, fault);
        return fault;
    }

    protected Document getDocument(InputSource inputSource, String desc) throws WSDLException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Document doc;
            Thread.currentThread().setContextClassLoader(WSDLReaderImpl.class.getClassLoader());
            DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
            Document document = doc = builder.parse(inputSource);
            return document;
        }
        catch (Throwable t) {
            throw new WSDLException("PARSER_ERROR", "Problem parsing '" + desc + "'.", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public WSDLElementList getElementList() {
        return this.wsdlElementList;
    }

    private void addElementToList(Element element, Object wsdlElement) {
        ElementLocation elementLocation = null;
        try {
            ElementImpl elementImpl = (ElementImpl)element;
            elementLocation = (ElementLocation)elementImpl.getUserData();
            this.wsdlElementList.addElement(wsdlElement, elementLocation);
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
    }

    private BindingOperation parseBindingOperationWithDuplicateNames(Element bindingOperationEl, PortType portType, Definition def) throws WSDLException {
        BindingOperation bindingOperation = def.createBindingOperation();
        String name = DOMUtils.getAttribute((Element)bindingOperationEl, (String)"name");
        if (name != null) {
            bindingOperation.setName(name);
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)bindingOperationEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                bindingOperation.setDocumentationElement(tempEl);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_INPUT, (Node)tempEl)) {
                bindingOperation.setBindingInput(this.parseBindingInput(tempEl, def));
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_OUTPUT, (Node)tempEl)) {
                bindingOperation.setBindingOutput(this.parseBindingOutput(tempEl, def));
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_FAULT, (Node)tempEl)) {
                bindingOperation.addBindingFault(this.parseBindingFault(tempEl, def));
            } else {
                bindingOperation.addExtensibilityElement(this.parseExtensibilityElement(BindingOperation.class, tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        if (portType != null) {
            BindingInput bindingInput = bindingOperation.getBindingInput();
            BindingOutput bindingOutput = bindingOperation.getBindingOutput();
            String inputName = bindingInput != null ? bindingInput.getName() : null;
            String outputName = bindingOutput != null ? bindingOutput.getName() : null;
            Operation op = null;
            Iterator iterator = portType.getOperations().iterator();
            while (iterator.hasNext() && op == null) {
                String checkOutputName;
                Operation checkOperation = (Operation)iterator.next();
                String checkName = checkOperation.getName();
                String checkInputName = checkOperation.getInput() == null ? null : checkOperation.getInput().getName();
                String string = checkOutputName = checkOperation.getOutput() == null ? null : checkOperation.getOutput().getName();
                if (checkName == null || !checkName.equals(name) || (checkInputName == null || !checkInputName.equals(inputName)) && (checkInputName != null || inputName != null) || (checkOutputName == null || !checkOutputName.equals(outputName)) && (checkOutputName != null || outputName != null)) continue;
                op = checkOperation;
            }
            if (op == null) {
                op = def.createOperation();
                op.setName(name);
                portType.addOperation(op);
            }
            bindingOperation.setOperation(op);
        }
        return bindingOperation;
    }

    protected ExtensibilityElement parseSchema(Class ccc, Element elem, Definition def) throws WSDLException {
        ExtensibilityElement extElem = null;
        extElem = super.parseSchema(ccc, elem, def);
        this.addElementToList(elem, extElem);
        return extElem;
    }
}

