/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.report.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.log.Log;
import org.eclipse.wst.wsi.internal.core.report.ArtifactReference;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.report.Entry;
import org.eclipse.wst.wsi.internal.core.report.EntryContainer;
import org.eclipse.wst.wsi.internal.core.report.FailureDetail;
import org.eclipse.wst.wsi.internal.core.report.Report;
import org.eclipse.wst.wsi.internal.core.report.ReportArtifact;
import org.eclipse.wst.wsi.internal.core.report.ReportContext;
import org.eclipse.wst.wsi.internal.core.report.impl.AssertionResultImpl;
import org.eclipse.wst.wsi.internal.core.report.impl.EntryContainerImpl;
import org.eclipse.wst.wsi.internal.core.report.impl.EntryImpl;
import org.eclipse.wst.wsi.internal.core.report.impl.FailureDetailImpl;
import org.eclipse.wst.wsi.internal.core.report.impl.ReportArtifactImpl;
import org.eclipse.wst.wsi.internal.core.util.TestUtils;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;

public class ReportImpl
implements Report {
    protected String filename = null;
    protected ReportContext reportContext = null;
    protected Log log = null;
    protected boolean allPassed = true;
    protected Vector artifactList = new Vector();
    protected Vector entryList = new Vector();
    protected ReportArtifact currentArtifact = null;
    protected Entry currentEntry = null;
    protected String prereqType;

    public String getLocation() {
        return this.filename;
    }

    public void setLocation(String reportURI) {
        this.filename = reportURI;
    }

    public ReportContext getReportContext() {
        return this.reportContext;
    }

    public void setReportContext(ReportContext reportContext) {
        this.reportContext = reportContext;
    }

    public ReportArtifact getCurrentArtifact() {
        return this.currentArtifact;
    }

    public void setCurrentArtifact(ReportArtifact artifact) throws WSIException {
        this.artifactList.add(artifact);
        this.currentArtifact = artifact;
        this.prereqType = "entry";
    }

    public void endCurrentArtifact() throws WSIException {
        this.currentArtifact = null;
    }

    public void addArtifactReference(ArtifactReference artifactReference) throws WSIException {
    }

    public Entry getCurrentEntry() {
        return this.currentEntry;
    }

    public void setCurrentEnvelopeEntry(Entry entry) throws WSIException {
    }

    public void setCurrentEntry(Entry entry) throws WSIException {
        this.entryList.add(entry);
        this.currentEntry = entry;
    }

    public List getEntries() {
        return this.entryList;
    }

    public List getArtifacts() {
        return this.artifactList;
    }

    public void endCurrentEntry() throws WSIException {
        this.currentEntry = null;
    }

    public void addAssertionResult(AssertionResult assertionResult) {
        if (this.currentEntry != null) {
            this.currentEntry.addAssertionResult(assertionResult);
        }
        if (assertionResult.getResult().equals("failed")) {
            this.allPassed = false;
        }
    }

    public AssertionResult getAssertionResult(String assertionId) {
        AssertionResult result = null;
        result = this.prereqType.equals("entry") ? this.currentEntry.getAssertionResult(assertionId) : this.currentEntry.getEntryContainer().getAssertionResult(assertionId);
        if (result == null) {
            Entry entry;
            for (int i = 0; i < this.entryList.size() && (result = (entry = (Entry)this.entryList.get(i)).getAssertionResult(assertionId)) == null; ++i) {
            }
        }
        return result;
    }

    public AssertionResult createAssertionResult() {
        AssertionResultImpl assertionResult = new AssertionResultImpl();
        assertionResult.setAssertionResultsOption(this.reportContext.getAnalyzer().getAnalyzerConfig().getAssertionResultsOption());
        return assertionResult;
    }

    public Entry createEntry() {
        EntryImpl entry = new EntryImpl();
        return entry;
    }

    public EntryContainer createEntryContainer() {
        EntryContainerImpl entryContainer = new EntryContainerImpl();
        return entryContainer;
    }

    public ReportArtifact createArtifact() {
        ReportArtifactImpl reportArtifact = new ReportArtifactImpl();
        return reportArtifact;
    }

    public FailureDetail createFailureDetail() {
        FailureDetailImpl failureDetail = new FailureDetailImpl();
        return failureDetail;
    }

    public String getSummaryResult() {
        return this.allPassed ? "passed" : "failed";
    }

    public void setPrereqType(String prereqType) {
        this.prereqType = prereqType;
    }

    public String toString() {
        return "Report:  ";
    }

    public String getStartXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = nsName + ":";
        }
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println(this.reportContext.getAnalyzer().getAnalyzerConfig().getAddStyleSheet().getStyleSheetString());
        String comment = TestUtils.getXMLComment();
        if (comment != null) {
            pw.print(comment);
        }
        pw.print("<" + nsName + "report" + " " + "name" + "=\"" + this.reportContext.getReportTitle() + "\"");
        pw.println("    timestamp=\"" + Utils.getTimestamp() + "\"");
        pw.println("    xmlns=\"http://www.ws-i.org/testing/2004/07/report/\"");
        pw.println("    xmlns:wsi-report=\"http://www.ws-i.org/testing/2004/07/report/\"");
        pw.println("    xmlns:wsi-log=\"http://www.ws-i.org/testing/2004/07/log/\"");
        pw.println("    xmlns:wsi-analyzerConfig=\"http://www.ws-i.org/testing/2004/07/analyzerConfig/\"");
        pw.println("    xmlns:wsi-monConfig=\"http://www.ws-i.org/testing/2004/07/monitorConfig/\"");
        pw.println("    xmlns:wsi-assertions=\"http://www.ws-i.org/testing/2004/07/assertions/\"");
        pw.println("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        pw.print(this.reportContext.getAnalyzer().toXMLString(nsName));
        return sw.toString();
    }

    public String getEndXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = nsName + ":";
        }
        pw.print("  <" + nsName + "summary" + " ");
        pw.println("result=\"" + this.getSummaryResult() + "\">");
        pw.println("  </" + nsName + "summary" + ">");
        pw.println("</" + nsName + "report" + ">");
        return sw.toString();
    }

    public String getErrorXMLString(String namespaceName, String errorDetail) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = nsName + ":";
        }
        pw.println("  <" + nsName + "analyzerFailure" + ">");
        pw.print("    <" + nsName + "failureDetail" + ">");
        pw.print(XMLUtils.xmlEscapedString(errorDetail));
        pw.println("    </" + nsName + "failureDetail" + ">");
        pw.println("</" + nsName + "analyzerFailure" + ">");
        pw.println("</" + nsName + "report" + ">");
        return sw.toString();
    }

    public String toXMLString(String namespaceName) {
        return this.getStartXMLString(namespaceName) + this.getEndXMLString(namespaceName);
    }
}

