/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.HashMap;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.report.FailureDetail;

public class BP2017
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2017(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Vector<FailureDetail> failureDetailList = new Vector<FailureDetail>();
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        if (binding == null) {
            this.result = "notApplicable";
            return this.validator.createAssertionResult(testAssertion, this.result, failureDetailList);
        }
        SOAPBinding soapB = WSDLValidatorImpl.getSoapBinding(binding);
        if (soapB == null) {
            this.result = "notApplicable";
            return this.validator.createAssertionResult(testAssertion, this.result, failureDetailList);
        }
        String styleB = soapB.getStyle() == null ? "document" : soapB.getStyle();
        HashMap soapOperationList = this.validator.getSoapOperations(binding);
        if (soapOperationList.isEmpty()) {
            this.result = "notApplicable";
        } else {
            String style = null;
            for (SOAPOperation soapOperation : soapOperationList.keySet()) {
                String checkStyle = soapOperation.getStyle();
                if (checkStyle == null) {
                    checkStyle = styleB;
                }
                if (checkStyle != null && !checkStyle.equals("document") && !checkStyle.equals("rpc")) {
                    this.result = "failed";
                    failureDetailList.add(this.validator.createFailureDetail("Operation Name: " + soapOperationList.get(soapOperation) + "\nSOAP Operation: " + soapOperation.toString(), entryContext, soapOperation));
                }
                if (style == null) {
                    style = checkStyle;
                    continue;
                }
                if (style.equals(checkStyle) && style.equals(styleB)) continue;
                this.result = "failed";
                failureDetailList.add(this.validator.createFailureDetail("Operation Name: " + soapOperationList.get(soapOperation) + "\nSOAP Operation: " + soapOperation.toString(), entryContext, soapOperation));
            }
            if (style == null) {
                this.result = "notApplicable";
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, failureDetailList);
    }
}

