/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AP2908
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public AP2908(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Binding wsdlBinding = (Binding)entryContext.getEntry().getEntryDetail();
            Document doc = entryContext.getWSDLDocument().getDocument();
            if (doc == null) {
                doc = this.validator.parseXMLDocumentURL(this.validator.wsdlDocument.getLocation(), null);
            }
            Element binding = this.getBindingElement(doc.getDocumentElement(), wsdlBinding.getQName().getLocalPart());
            List ops = this.getChildElements(binding, WSDL_OPERATION);
            boolean multipartsFound = false;
            for (int i = 0; i < ops.size(); ++i) {
                Element bindingOperation = (Element)ops.get(i);
                Element bindingInput = this.getChildElement(bindingOperation, WSDL_INPUT);
                Element bindingOutput = this.getChildElement(bindingOperation, WSDL_OUTPUT);
                List inputMultiparts = this.getMimeMultipartElements(bindingInput);
                List outputMultiparts = this.getMimeMultipartElements(bindingOutput);
                if (!inputMultiparts.isEmpty()) {
                    multipartsFound = true;
                    if (this.containsInvalidMimePart(inputMultiparts)) {
                        throw new AssertionFailException("The invalid mime:part element is in the wsdl:input of the \"" + bindingOperation.getAttribute("name") + "\" binding operation.");
                    }
                }
                if (outputMultiparts.isEmpty()) continue;
                multipartsFound = true;
                if (!this.containsInvalidMimePart(outputMultiparts)) continue;
                throw new AssertionFailException("The invalid mime:part element is in the wsdl:output of the \"" + bindingOperation.getAttribute("name") + "\" binding operation.");
            }
            if (!multipartsFound) {
                this.result = "notApplicable";
            }
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        catch (Exception ioe) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsInvalidMimePart(List multiparts) {
        for (int i = 0; i < multiparts.size(); ++i) {
            List mimeParts = this.getChildElements((Element)multiparts.get(i), WSDL_MIME_PART);
            for (int j = 0; j < mimeParts.size(); ++j) {
                Element mimePart = (Element)mimeParts.get(j);
                if (mimePart.getAttributeNode("name") == null) continue;
                return true;
            }
        }
        return false;
    }

    private List getMimeMultipartElements(Element parent) {
        ArrayList<Element> mimeMultipartElements = new ArrayList<Element>();
        if (parent != null) {
            Element child = XMLUtils.getFirstChild(parent);
            while (child != null) {
                if (child.getNamespaceURI().equals(WSDL_MIME_MULTIPART.getNamespaceURI()) && child.getLocalName().equals(WSDL_MIME_MULTIPART.getLocalPart())) {
                    mimeMultipartElements.add(child);
                    List mimeParts = this.getChildElements(child, WSDL_MIME_PART);
                    for (int i = 0; i < mimeParts.size(); ++i) {
                        List elems = this.getMimeMultipartElements((Element)mimeParts.get(i));
                        mimeMultipartElements.addAll(elems);
                    }
                }
                child = XMLUtils.getNextSibling(child);
            }
        }
        return mimeMultipartElements;
    }

    private Element getChildElement(Element parent, QName childName) {
        Element child = XMLUtils.getFirstChild(parent);
        while (child != null) {
            if (child.getNamespaceURI().equals(childName.getNamespaceURI()) && child.getLocalName().equals(childName.getLocalPart())) {
                return child;
            }
            child = XMLUtils.getNextSibling(child);
        }
        return null;
    }

    private List getChildElements(Element parent, QName childName) {
        ArrayList<Element> children = new ArrayList<Element>();
        if (parent != null) {
            Element child = XMLUtils.getFirstChild(parent);
            while (child != null) {
                if (child.getNamespaceURI().equals(childName.getNamespaceURI()) && child.getLocalName().equals(childName.getLocalPart())) {
                    children.add(child);
                }
                child = XMLUtils.getNextSibling(child);
            }
        }
        return children;
    }

    private Element getBindingElement(Element definitions, String bindingName) {
        Element child = XMLUtils.getFirstChild(definitions);
        while (child != null) {
            if (child.getNamespaceURI().equals(WSDL_BINDING.getNamespaceURI()) && child.getLocalName().equals(WSDL_BINDING.getLocalPart()) && child.getAttribute("name").equals(bindingName)) {
                return child;
            }
            child = XMLUtils.getNextSibling(child);
        }
        return null;
    }
}

