/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionPassException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSI1121
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public WSI1121(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            boolean isSchemaValid;
            Element soapMessageElement;
            Binding[] bindings = this.validator.analyzerContext.getCandidateInfo().getBindings();
            Document messageDoc = null;
            QName messagePartElementQName = null;
            if (!entryContext.getMessageEntry().getMessage().equals("") && (soapMessageElement = this.validator.getSoapBodyChild(messageDoc = XMLUtils.parseXML(entryContext.getMessageEntry().getMessage()))) != null) {
                messagePartElementQName = new QName(soapMessageElement.getNamespaceURI(), soapMessageElement.getLocalName());
            }
            if (messageDoc == null || this.validator.isFault(messageDoc)) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation[] docBindingOperations = this.validator.getMatchingBindingOps("document", bindings);
            BindingOperation[] potentialDocLitOps = this.validator.getDocLitOperations(entryContext.getEntry().getEntryType(), messagePartElementQName, docBindingOperations);
            if (potentialDocLitOps.length == 0) {
                throw new AssertionNotApplicableException();
            }
            try {
                isSchemaValid = this.validator.messageIsDocLitSchemaValid(entryContext);
            }
            catch (Exception e) {
                throw new AssertionFailException();
            }
            if (isSchemaValid) {
                throw new AssertionPassException();
            }
            throw new AssertionFailException();
        }
        catch (AssertionPassException e) {
            this.result = "passed";
        }
        catch (AssertionFailException e) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
        }
        catch (AssertionNotApplicableException e) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

