/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;

public class AP1925
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1925(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), entryContext.getMessageEntryDocument());
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            List extElems = null;
            if (entryContext.getMessageEntry().getType().equals("request") && bindingOperation.getBindingInput() != null) {
                extElems = bindingOperation.getBindingInput().getExtensibilityElements();
            } else if (entryContext.getMessageEntry().getType().equals("response") && bindingOperation.getBindingOutput() != null) {
                extElems = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (extElems == null || extElems.size() == 0 || !(extElems.get(0) instanceof MIMEMultipartRelated)) {
                throw new AssertionNotApplicableException();
            }
            MIMEMultipartRelated mime = (MIMEMultipartRelated)extElems.get(0);
            List parts = mime.getMIMEParts();
            if (parts.size() <= 1) {
                throw new AssertionNotApplicableException();
            }
            String contentType = HTTPUtils.getHttpHeaderAttribute(entryContext.getMessageEntry().getHTTPHeaders(), "Content-Type");
            if (contentType == null || !contentType.equalsIgnoreCase("multipart/related")) {
                throw new AssertionFailException("Incorrect Content-Type value \"" + contentType + "\" in HTTP header");
            }
        }
        catch (AssertionNotApplicableException e) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException e) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

