/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BP1308
extends AssertionProcess
implements WSITag {
    private final BaseMessageValidator validator;

    public BP1308(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document doc = entryContext.getMessageEntryDocument();
            if (doc == null) {
                throw new AssertionNotApplicableException();
            }
            NodeList soapBodyList = doc.getElementsByTagNameNS(ELEM_SOAP_BODY.getNamespaceURI(), ELEM_SOAP_BODY.getLocalPart());
            if (soapBodyList == null || soapBodyList.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            Element child = XMLUtils.getFirstChild((Element)soapBodyList.item(0));
            while (child != null) {
                if (child.getAttributeNodeNS(ELEM_SOAP_BODY.getNamespaceURI(), "encodingStyle") != null) {
                    throw new AssertionFailException("The child element name is \"" + child.getNodeName() + "\".");
                }
                child = XMLUtils.getNextSibling(child);
            }
        }
        catch (AssertionNotApplicableException anae) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

