/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionPassException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BP1031
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1031(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.failureDetail = null;
        try {
            Document doc;
            if (this.validator.isOneWayResponse(entryContext) || (doc = entryContext.getMessageEntryDocument()) == null) {
                throw new AssertionNotApplicableException();
            }
            if (!this.validator.isFault(doc)) {
                throw new AssertionNotApplicableException();
            }
            NodeList faultCodes = doc.getElementsByTagName("faultcode");
            for (int i = 0; i < faultCodes.getLength(); ++i) {
                NodeList faultCodeNodes = faultCodes.item(i).getChildNodes();
                for (int j = 0; j < faultCodeNodes.getLength(); ++j) {
                    Text faultCodeText;
                    if (!(faultCodeNodes.item(j) instanceof Text) || (faultCodeText = (Text)faultCodeNodes.item(j)).getData().indexOf(46) <= 0) continue;
                    throw new AssertionFailException();
                }
            }
            throw new AssertionPassException();
        }
        catch (AssertionPassException e) {
            this.result = "passed";
        }
        catch (AssertionNotApplicableException e) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException e) {
            this.result = "warning";
            this.failureDetail = this.validator.createFailureDetail(entryContext.getMessageEntry().getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

