/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BP1012
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1012(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document requestDoc = entryContext.getRequestDocument();
            if (requestDoc == null) {
                throw new AssertionNotApplicableException();
            }
            Element envElem = requestDoc.getDocumentElement();
            if (!envElem.getLocalName().equals("Envelope") || envElem.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                throw new AssertionNotApplicableException();
            }
            Document responseDoc = XMLUtils.parseXML(entryContext.getResponse().getMessage());
            NodeList soapFaultList = responseDoc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            if (soapFaultList == null || soapFaultList.getLength() == 0) {
                throw new AssertionFailException("--- REQUEST:\n" + entryContext.getRequest().getMessage() + "\n--- RESPONSE:\n" + entryContext.getResponse().getMessage());
            }
        }
        catch (AssertionNotApplicableException anae) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException e) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

