/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.analyzer.config.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.wst.wsi.internal.core.analyzer.config.WSDLElement;
import org.eclipse.wst.wsi.internal.core.analyzer.config.WSDLReference;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;

public class WSDLReferenceImpl
implements WSDLReference {
    protected WSDLElement wsdlElement = null;
    protected String serviceLocation = null;
    protected String wsdlLocation = null;

    public WSDLReferenceImpl() {
    }

    public WSDLReferenceImpl(WSDLElement wsdlElement, String wsdlLocation, String serviceLocation) {
        this.wsdlElement = wsdlElement;
        this.wsdlLocation = wsdlLocation;
        this.serviceLocation = serviceLocation;
    }

    public WSDLElement getWSDLElement() {
        return this.wsdlElement;
    }

    public void setWSDLElement(WSDLElement wsdlElement) {
        this.wsdlElement = wsdlElement;
    }

    public String getWSDLLocation() {
        return this.wsdlLocation;
    }

    public void setWSDLLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public String getServiceLocation() {
        return this.serviceLocation;
    }

    public void setServiceLocation(String serviceLocation) {
        this.serviceLocation = serviceLocation;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("  WSDL Reference:");
        pw.print(this.wsdlElement.toString());
        pw.println("    wsdlURI .................. " + this.wsdlLocation);
        if (this.serviceLocation != null) {
            pw.println("  serviceLocation .......... " + this.serviceLocation);
        }
        return sw.toString();
    }

    public String toXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = nsName + ":";
        }
        pw.println("      <" + nsName + "wsdlReference" + ">");
        pw.print(this.getWSDLElement().toXMLString(nsName));
        pw.print("        <" + nsName + "wsdlURI" + ">");
        pw.print(this.getWSDLLocation());
        pw.println("</" + nsName + "wsdlURI" + ">");
        if (this.serviceLocation != null) {
            pw.print("        <" + nsName + "serviceLocation" + ">");
            pw.print(XMLUtils.xmlEscapedString(this.getServiceLocation()));
            pw.println("</" + nsName + "serviceLocation" + ">");
        }
        pw.println("      </" + nsName + "wsdlReference" + ">");
        return sw.toString();
    }
}

