/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.analyzer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.ToolInfo;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AnalyzerContext;
import org.eclipse.wst.wsi.internal.core.analyzer.CandidateInfo;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AnalyzerConfig;
import org.eclipse.wst.wsi.internal.core.document.DocumentFactory;
import org.eclipse.wst.wsi.internal.core.log.Log;
import org.eclipse.wst.wsi.internal.core.profile.ProfileAssertions;
import org.eclipse.wst.wsi.internal.core.profile.validator.ProfileValidatorFactory;
import org.eclipse.wst.wsi.internal.core.report.Reporter;
import org.eclipse.wst.wsi.internal.core.util.MessageList;
import org.eclipse.wst.wsi.internal.core.util.TestUtils;

public abstract class Analyzer {
    protected MessageList messageList = null;
    protected static final String RESOURCE_BUNDLE_NAME = "org.eclipse.wst.wsi.internal.core.analyzer.Analyzer";
    public static final String USAGE_MESSAGE = "Usage: Analyzer -config <configFilename>";
    protected Reporter reporter = null;
    protected AnalyzerContext analyzerContext = null;
    protected CandidateInfo candidateInfo = null;
    protected ToolInfo toolInfo = null;
    protected ProfileValidatorFactory factory = null;
    protected DocumentFactory documentFactory = null;
    protected List analyzerConfigList = new Vector();
    protected int analyzerConfigIndex = 0;
    protected ProfileAssertions profileAssertions = null;
    protected Log log = null;

    public Analyzer(String[] args, ToolInfo toolInfo) throws WSIException {
        this.init(toolInfo);
        this.analyzerConfigList.add(this.analyzerConfigIndex, this.documentFactory.newAnalyzerConfig());
        this.getAnalyzerConfig().init(this.messageList);
        this.getAnalyzerConfig().parseArgs(args, true);
        TestUtils.printToolInfo(toolInfo);
        System.out.println(((Object)this.getAnalyzerConfig()).toString());
        this.printMessage("progress01", null, "Please wait while the specified artifacts are analyzed...");
    }

    public Analyzer(String[] args, ToolInfo toolInfo, boolean validate) throws WSIException {
        this.init(toolInfo);
        this.analyzerConfigList.add(this.analyzerConfigIndex, this.documentFactory.newAnalyzerConfig());
        this.getAnalyzerConfig().init(this.messageList);
        this.getAnalyzerConfig().parseArgs(args, validate);
        TestUtils.printToolInfo(toolInfo);
        System.out.println(((Object)this.getAnalyzerConfig()).toString());
        this.printMessage("progress01", null, "Please wait while the specified artifacts are analyzed...");
    }

    public Analyzer(List analyzerConfigList, ToolInfo toolInfo) throws WSIException {
        this.init(toolInfo);
        this.analyzerConfigList = analyzerConfigList;
    }

    protected void init(ToolInfo info) throws WSIException {
        this.toolInfo = info;
        this.messageList = new MessageList(RESOURCE_BUNDLE_NAME);
        this.factory = ProfileValidatorFactory.newInstance();
        this.documentFactory = DocumentFactory.newInstance();
    }

    public int validateAll() throws WSIException {
        int statusCode = 0;
        for (int index = 0; index < this.analyzerConfigList.size(); ++index) {
            this.setAnalyzerConfig(index);
            int tempStatusCode = this.validateConformance();
            if (tempStatusCode <= statusCode) continue;
            statusCode = tempStatusCode;
        }
        return statusCode;
    }

    public abstract int validateConformance() throws WSIException;

    public ToolInfo getToolInfo() {
        return this.toolInfo;
    }

    protected void setAnalyzerConfig(int index) {
        this.analyzerConfigIndex = index;
    }

    protected int getAnalyzerConfigIndex() {
        return this.analyzerConfigIndex;
    }

    public AnalyzerConfig getAnalyzerConfig() {
        return (AnalyzerConfig)this.analyzerConfigList.get(this.analyzerConfigIndex);
    }

    public void printMessage(String key, String messageData, String defaultMessage) {
        this.messageList.printMessage(key, messageData, defaultMessage);
    }

    public static void staticPrintMessage(String key, String messageData, String defaultMessage) {
        MessageList.printMessage(RESOURCE_BUNDLE_NAME, key, messageData, defaultMessage);
    }

    public String toXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(this.toolInfo.getStartXMLString(namespaceName));
        pw.print(this.getAnalyzerConfig().toXMLString("wsi-analyzerConfig"));
        pw.println(this.toolInfo.getEndXMLString(namespaceName));
        return sw.toString();
    }

    public void printMessage(String message) {
        if (this.getAnalyzerConfig().getVerboseOption()) {
            System.err.println(message);
        }
    }
}

