/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.analyzer;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.wst.common.uriresolver.internal.util.URIEncoder;
import org.eclipse.wst.wsi.internal.WSIPreferences;
import org.eclipse.wst.wsi.internal.WSITestToolsEclipseProperties;
import org.eclipse.wst.wsi.internal.analyzer.WSIAnalyzerException;
import org.eclipse.wst.wsi.internal.analyzer.WSIBasicProfileAnalyzer;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AnalyzerConfig;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AssertionResultType;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.AssertionResultsOptionImpl;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.WSDLElementImpl;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.WSDLReferenceImpl;
import org.eclipse.wst.wsi.internal.core.common.impl.AddStyleSheetImpl;
import org.eclipse.wst.wsi.internal.core.document.DocumentFactory;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.report.Entry;
import org.eclipse.wst.wsi.internal.core.report.impl.FailureDetailImpl;
import org.eclipse.wst.wsi.internal.core.report.impl.ReportImpl;
import org.eclipse.wst.wsi.internal.core.xml.dom.ElementLocation;
import org.eclipse.wst.wsi.internal.report.AssertionError;

public class MessageAnalyzer {
    public static final String PLUGIN_ID = "org.wsi.test.tools";
    public static final String TYPE_PORT = "port";
    public static final String TYPE_BINDING = "binding";
    public static final String TYPE_PORTTYPE = "porttype";
    public static final String TYPE_OPERATION = "operation";
    public static final String TYPE_MESSAGE = "message";
    protected final String NOTPASSED = "notPassed";
    protected final String WARNING = "warning";
    protected final String FAILED = "failed";
    protected String filename;
    protected String wsdlfile = null;
    protected String elementname = null;
    protected String namespace = null;
    protected String parentname = null;
    protected boolean wsdlspecified = false;
    protected String type = null;
    protected List assertionwarnings;
    protected List assertionerrors;
    protected WSIPreferences wsiPreferences = null;

    public MessageAnalyzer(String filename) {
        this.filename = filename.replace('\\', '/');
        this.assertionwarnings = new Vector();
        this.assertionerrors = new Vector();
        this.wsiPreferences = WSITestToolsEclipseProperties.checkWSIPreferences(filename);
    }

    public MessageAnalyzer(String filename, WSIPreferences wsiPreferences) {
        this.filename = filename.replace('\\', '/');
        this.assertionwarnings = new Vector();
        this.assertionerrors = new Vector();
        this.wsiPreferences = wsiPreferences;
    }

    public MessageAnalyzer(String filename, String wsdlfile, String elementname, String namespace, String parentname, String type) {
        this(filename.replace('\\', '/'));
        this.wsdlspecified = true;
        this.wsdlfile = wsdlfile.replace('\\', '/');
        this.elementname = elementname;
        this.namespace = namespace;
        this.parentname = parentname;
        this.type = type;
    }

    public MessageAnalyzer(String filename, String wsdlfile, String elementname, String namespace, String parentname, String type, WSIPreferences wsiPreferences) {
        this(filename, wsiPreferences);
        this.wsdlspecified = true;
        this.wsdlfile = wsdlfile.replace('\\', '/');
        this.elementname = elementname;
        this.namespace = namespace;
        this.parentname = parentname;
        this.type = type;
    }

    public void validateConformance() throws WSIAnalyzerException {
        block13: {
            try {
                if (this.wsiPreferences.getComplianceLevel() == "2") break block13;
                DocumentFactory documentFactory = DocumentFactory.newInstance();
                AnalyzerConfig analyzerconfig = documentFactory.newAnalyzerConfig();
                if (this.wsdlspecified) {
                    WSDLReferenceImpl wsdlref = new WSDLReferenceImpl();
                    wsdlref.setWSDLLocation(this.wsdlfile);
                    WSDLElementImpl wsdlelem = new WSDLElementImpl();
                    wsdlelem.setName(this.elementname);
                    wsdlelem.setNamespace(this.namespace);
                    wsdlelem.setParentElementName(this.parentname);
                    wsdlelem.setType(this.type);
                    wsdlref.setWSDLElement(wsdlelem);
                    analyzerconfig.setWSDLReference(wsdlref);
                }
                AssertionResultsOptionImpl aro = new AssertionResultsOptionImpl();
                aro.setAssertionResultType(AssertionResultType.newInstance("notPassed"));
                aro.setShowAssertionDescription(false);
                aro.setShowFailureDetail(false);
                aro.setShowFailureMessage(false);
                aro.setShowMessageEntry(false);
                AddStyleSheetImpl addstylesheet = new AddStyleSheetImpl();
                analyzerconfig.setAssertionResultsOption(aro);
                analyzerconfig.setAddStyleSheet(addstylesheet);
                analyzerconfig.setCorrelationType("endpoint");
                try {
                    analyzerconfig.setLogLocation(URIEncoder.encode(this.filename, "UTF8"));
                    analyzerconfig.setTestAssertionsDocumentLocation(this.wsiPreferences.getTADFile());
                }
                catch (UnsupportedEncodingException uee) {
                    analyzerconfig.setLogLocation(URIEncoder.encode(this.filename, "UTF8"));
                    analyzerconfig.setTestAssertionsDocumentLocation(URIEncoder.encode(this.wsiPreferences.getTADFile(), "UTF8"));
                }
                analyzerconfig.setVerboseOption(false);
                Vector<AnalyzerConfig> analyzerConfigs = new Vector<AnalyzerConfig>();
                analyzerConfigs.add(analyzerconfig);
                WSIBasicProfileAnalyzer bpanalyzer = new WSIBasicProfileAnalyzer(analyzerConfigs);
                bpanalyzer.validateAll();
                ReportImpl report = (ReportImpl)bpanalyzer.getReport();
                List entries = report.getEntries();
                if (entries == null) break block13;
                for (Entry entry : entries) {
                    TreeMap assertionResults = entry.getAssertionResultList();
                    if (assertionResults == null) continue;
                    for (AssertionResult ar : assertionResults.values()) {
                        ElementLocation el;
                        int columnNumber;
                        int lineNumber;
                        TestAssertion ta;
                        if (ar.getResult().equalsIgnoreCase("failed") && this.wsiPreferences.getComplianceLevel().equals("0")) {
                            ta = ar.getAssertion();
                            if (!ta.isEnabled()) continue;
                            for (FailureDetailImpl fdi : ar.getFailureDetailList()) {
                                lineNumber = 0;
                                columnNumber = 0;
                                el = fdi.getElementLocation();
                                if (el != null) {
                                    lineNumber = el.getLineNumber();
                                    columnNumber = el.getColumnNumber();
                                }
                                this.assertionerrors.add(new AssertionError(ta.getId(), "Message ID " + entry.getReferenceID() + ":" + ta.getFailureMessage(), lineNumber, columnNumber));
                            }
                            continue;
                        }
                        if (!ar.getResult().equalsIgnoreCase("failed") || !this.wsiPreferences.getComplianceLevel().equals("1") || !(ta = ar.getAssertion()).isEnabled()) continue;
                        for (FailureDetailImpl fdi : ar.getFailureDetailList()) {
                            lineNumber = 0;
                            columnNumber = 0;
                            el = fdi.getElementLocation();
                            if (el != null) {
                                lineNumber = el.getLineNumber();
                                columnNumber = el.getColumnNumber();
                            }
                            this.assertionwarnings.add(new AssertionError(ta.getId(), "Message ID " + entry.getReferenceID() + ":" + ta.getFailureMessage(), lineNumber, columnNumber));
                        }
                    }
                }
            }
            catch (WSIException e) {
                throw new WSIAnalyzerException("The MessageAnalyzer was unable to validate the given logfile.", e.getTargetException());
            }
            catch (Exception e) {
                throw new WSIAnalyzerException("The MessageAnalyzer was unable to validate the given logfile.");
            }
        }
    }

    public List getAssertionWarnings() {
        return this.assertionwarnings;
    }

    public List getAssertionErrors() {
        return this.assertionerrors;
    }
}

