/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsdl.validation.internal.IValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.IWSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.exception.ValidateWSDLException;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11Validator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ReaderError;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ValidatorRegistry;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidationInfoImpl;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDLDocument;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDLReaderImpl;
import org.w3c.dom.Document;

public class WSDL11ValidatorController
implements IWSDLValidator {
    private static String VALIDATOR_RESOURCE_BUNDLE_NAME = "validatewsdl";
    protected final String _WARN_NO_VALDIATOR = "_WARN_NO_VALDIATOR";
    protected MessageGenerator messagegenerator = null;
    protected ValidatorRegistry ver = ValidatorRegistry.getInstance();

    public WSDL11ValidatorController() {
        ResourceBundle rb = ResourceBundle.getBundle(VALIDATOR_RESOURCE_BUNDLE_NAME, Locale.getDefault());
        this.messagegenerator = new MessageGenerator(rb);
    }

    public void validate(Document domModel, IValidationInfo valInfo) throws ValidateWSDLException {
        WSDL11ValidationInfoImpl wsdlvalinfo = new WSDL11ValidationInfoImpl(valInfo);
        WSDLDocument[] wsdlDocs = this.readWSDLDocument(domModel, valInfo.getFileURI(), this.getMessageGenerator(), wsdlvalinfo);
        if (wsdlDocs != null) {
            for (WSDLDocument tempDoc : wsdlDocs) {
                List readerWarnings;
                Definition wsdlDefinition = tempDoc.getDefinition();
                List xsdList = tempDoc.getSchemas();
                Iterator xsdIter = xsdList.iterator();
                while (xsdIter.hasNext()) {
                    wsdlvalinfo.addSchema((XSModel)xsdIter.next());
                }
                wsdlvalinfo.setElementLocations(tempDoc.getElementLocations());
                List readerErrors = tempDoc.getReaderErrors();
                if (readerErrors != null) {
                    for (ReaderError re : readerErrors) {
                        wsdlvalinfo.addError(re.getError(), re.getObject());
                    }
                }
                if ((readerWarnings = tempDoc.getReaderWarnings()) != null) {
                    for (ReaderError re : readerWarnings) {
                        wsdlvalinfo.addWarning(re.getError(), re.getObject());
                    }
                }
                this.validateWSDLElement("http://schemas.xmlsoap.org/wsdl/", wsdlDefinition, new Vector(), wsdlvalinfo);
                wsdlvalinfo.clearSchemas();
            }
        }
    }

    protected WSDLDocument[] readWSDLDocument(Document domModel, String file, MessageGenerator messagegenerator, IWSDL11ValidationInfo wsdlvalinfo) throws ValidateWSDLException {
        WSDLDocument[] wsdlDocs = null;
        try {
            WSDLReaderImpl wsdlReader = new WSDLReaderImpl(wsdlvalinfo);
            wsdlReader.setMessageGenerator(messagegenerator);
            wsdlDocs = domModel != null ? wsdlReader.readWSDL(file, domModel) : wsdlReader.readWSDL(file);
        }
        catch (WSDLException e) {
            throw new ValidateWSDLException(e.getMessage() + " " + e.getFaultCode());
        }
        catch (Exception e) {
            throw new ValidateWSDLException("unable to read file" + e.getMessage() + " " + e.toString());
        }
        return wsdlDocs;
    }

    public void validateWSDLElement(String namespace, Object element, List parents, IWSDL11ValidationInfo wsdlvalinfo) {
        IWSDL11Validator val = this.ver.queryValidatorRegistry(namespace);
        if (val != null) {
            val.validate(element, parents, wsdlvalinfo);
        }
    }

    public void setMessageGenerator(MessageGenerator mesgen) {
        this.messagegenerator = mesgen;
    }

    public MessageGenerator getMessageGenerator() {
        return this.messagegenerator;
    }
}

