/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.ui.text;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.wst.wsdl.validation.internal.logging.ILogger;
import org.eclipse.wst.wsdl.validation.internal.ui.text.WSDLValidate;

public class Log4jLogger
implements ILogger {
    protected Object logger = null;
    protected Method error1 = null;
    protected Method warn1 = null;
    protected Method info1 = null;
    protected Method debug1 = null;
    protected Method error2 = null;
    protected Method warn2 = null;
    protected Method info2 = null;
    protected Method debug2 = null;

    public Log4jLogger() {
        try {
            Class<?> loggerClass = this.getClass().getClassLoader().loadClass("org.apache.log4j.Logger");
            Class<?> categoryClass = this.getClass().getClassLoader().loadClass("org.apache.log4j.Category");
            Method getLogger = loggerClass.getDeclaredMethod("getLogger", Class.class);
            this.logger = getLogger.invoke(loggerClass, WSDLValidate.class);
            this.error1 = categoryClass.getDeclaredMethod("error", Object.class);
            this.warn1 = categoryClass.getDeclaredMethod("warn", Object.class);
            this.info1 = categoryClass.getDeclaredMethod("info", Object.class);
            this.debug1 = categoryClass.getDeclaredMethod("debug", Object.class);
            this.error2 = categoryClass.getDeclaredMethod("error", Object.class, Throwable.class);
            this.warn2 = categoryClass.getDeclaredMethod("warn", Object.class, Throwable.class);
            this.info2 = categoryClass.getDeclaredMethod("info", Object.class, Throwable.class);
            this.debug2 = categoryClass.getDeclaredMethod("debug", Object.class, Throwable.class);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Unable to create Log4j Logger. Ensure Log4J is on the classpath.");
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void log(String message, int severity) {
        if (this.logger != null) {
            try {
                if (severity == 0) {
                    this.error1.invoke(this.logger, message);
                } else if (severity == 1) {
                    this.warn1.invoke(this.logger, message);
                } else if (severity == 2) {
                    this.info1.invoke(this.logger, message);
                } else if (severity == 3) {
                    this.debug1.invoke(this.logger, message);
                }
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public void log(String message, int severity, Throwable throwable) {
        if (this.logger != null) {
            try {
                if (severity == 0) {
                    this.error2.invoke(this.logger, message, throwable);
                } else if (severity == 1) {
                    this.warn2.invoke(this.logger, message, throwable);
                } else if (severity == 2) {
                    this.info2.invoke(this.logger, message, throwable);
                } else if (severity == 3) {
                    this.debug2.invoke(this.logger, message, throwable);
                }
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }
}

