/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.common;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class BundleUtils {
    public static URL getURLFromBundle(String bundleId, String path) throws MalformedURLException {
        Bundle bundle = Platform.getBundle((String)bundleId);
        URL installURL = bundle.getEntry("/");
        URL fileURL = new URL(installURL, path);
        return fileURL;
    }

    public static IPath getJarredPluginPath(String bundleId) {
        Path result = null;
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle != null) {
            Path runtimeLibFullPath = null;
            String jarPluginLocation = bundle.getLocation().substring(7);
            Path jarPluginPath = new Path(jarPluginLocation);
            if (jarPluginPath.isAbsolute()) {
                runtimeLibFullPath = jarPluginPath;
            } else {
                String installPath = Platform.getInstallLocation().getURL().getPath();
                runtimeLibFullPath = new Path(String.valueOf(installPath) + "/" + jarPluginLocation);
            }
            result = runtimeLibFullPath;
        }
        return result;
    }

    public static Version getVersion(String bundleId) {
        Version result = null;
        Bundle bundle = Platform.getBundle((String)bundleId);
        String versionString = (String)bundle.getHeaders().get("Bundle-Version");
        result = new Version(versionString);
        return result;
    }
}

