/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.enablement;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementIdentifier;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementIdentifierEvent;
import org.eclipse.wst.common.frameworks.internal.enablement.FunctionGroup;
import org.eclipse.wst.common.frameworks.internal.enablement.FunctionGroupRegistry;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementIdentifier;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementIdentifierListener;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementManager;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class EnablementManager
implements IEnablementManager {
    public static final IEnablementManager INSTANCE = new EnablementManager();
    private static Map identifiersByProject = new WeakHashMap();

    protected Map getIdentifiersById(IProject project) {
        WeakHashMap aMap = (WeakHashMap)identifiersByProject.get(project);
        if (aMap == null) {
            aMap = new WeakHashMap();
            identifiersByProject.put(project, aMap);
        }
        return aMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEnablementIdentifier getIdentifier(String identifierId, IProject project) {
        if (identifierId == null) {
            throw new NullPointerException();
        }
        if (project != null && !project.isAccessible()) {
            project = null;
        }
        EnablementIdentifier identifier = null;
        boolean identifierRequiresUpdate = false;
        Object object = this;
        synchronized (object) {
            Map identifiersById = this.getIdentifiersById(project);
            identifier = (EnablementIdentifier)identifiersById.get(identifierId);
            if (identifier == null) {
                identifierRequiresUpdate = true;
                identifier = this.createIdentifier(identifierId, project);
                identifiersById.put(identifierId, identifier);
            }
        }
        object = identifier;
        synchronized (object) {
            if (identifierRequiresUpdate) {
                this.updateIdentifier(identifier);
            }
            return identifier;
        }
    }

    protected EnablementIdentifier createIdentifier(String identifierId, IProject project) {
        return new EnablementIdentifier(identifierId, project);
    }

    private EnablementIdentifierEvent updateIdentifier(EnablementIdentifier identifier) {
        String id = identifier.getId();
        HashSet<String> functionGroupIds = new HashSet<String>();
        List groups = FunctionGroupRegistry.getInstance().getKnownGroups();
        Iterator iterator = groups.iterator();
        while (iterator.hasNext()) {
            FunctionGroup group = (FunctionGroup)iterator.next();
            if (group == null) {
                throw new IllegalStateException();
            }
            if (!group.isMatch(id)) continue;
            functionGroupIds.add(group.getGroupID());
        }
        boolean functionGroupsChanged = identifier.setFunctionGroupIds(functionGroupIds);
        boolean enabledChanged = identifier.resetEnabled();
        if (functionGroupsChanged || enabledChanged) {
            return new EnablementIdentifierEvent(identifier, functionGroupsChanged, enabledChanged);
        }
        return null;
    }

    public final void notifyFunctionGroupChanged(String groupID, IProject project) throws CoreException {
        Map identifiers = this.getIdentifiersById(project);
        if (identifiers == null) {
            return;
        }
        EnablementIdentifier identifier = null;
        Iterator iter = identifiers.values().iterator();
        IStatus errorStatus = null;
        IStatus nextStatus = null;
        while (iter.hasNext()) {
            identifier = (EnablementIdentifier)iter.next();
            EnablementIdentifierEvent evt = this.updateIdentifier(identifier);
            try {
                if (evt == null) continue;
                identifier.fireIdentifierChanged(evt);
            }
            catch (Exception ex) {
                nextStatus = WTPCommonPlugin.createErrorStatus("7", ex);
                Logger.getLogger().logError((Throwable)ex);
                if (errorStatus == null) {
                    errorStatus = nextStatus;
                    continue;
                }
                if (errorStatus.isMultiStatus()) {
                    ((MultiStatus)errorStatus).add(nextStatus);
                    continue;
                }
                IStatus[] children = new IStatus[]{errorStatus, nextStatus};
                errorStatus = new MultiStatus(errorStatus.getPlugin(), errorStatus.getCode(), children, "7", null);
            }
        }
        if (errorStatus != null) {
            throw new CoreException(errorStatus);
        }
    }

    public void removeEnablementIdentifierListener(Collection enablementIdentifiers, IEnablementIdentifierListener listener) {
        Iterator iter = enablementIdentifiers.iterator();
        while (iter.hasNext()) {
            IEnablementIdentifier identifier = (IEnablementIdentifier)iter.next();
            identifier.removeIdentifierListener(listener);
        }
    }
}

